<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Solicitação Compra</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.237.18.2">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.237.18.2">

  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">



  <link rel="stylesheet" href="dist/css/custom.css?versao=3.237.18.2">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.237.18.2">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.237.18.2" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.237.18.2">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.237.18.2" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.237.18.2">
  <style>
    #tabelaSolCompra td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaSolCompra td {
      padding: 0 !important;
      padding-left: 10px !important;
    }

    #modalPesquisaPedido div {
      z-index: 999 !important;
    }

    ;
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../../menu.php');
    ?>
    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Solicitação Compra</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="./index">Início</a></li>
                <li class="breadcrumb-item active">Solicitação Compra</li>
              </ol>
            </div>
          </div>
        </div>
        <div class="container-fluid" id="divTabelaSolCompra">
          <div class="row card">
            <div class="col-sm-12 mt-3">
              <button class="btn btn-success btn-sisp" id="btnFiltros"><span class="fas fa-search"></span> Filtros</button>
              <button class="btn btn-danger btn-sisp" id="btnIncluir"><span class="fas fa-plus"></span> Incluir</button>
              <button id="btnImprimir" class="btn-sisp btn btn-success"><i class="fas fa-print"></i> Imprimir</button>
            </div>
            <div class="col-sm-12 table-responsive card-body">
              <h5>Lista de Solicitações</h5>
              <table id="tabelaSolCompra" class="table table-sm table-select table-hover" width="100%">
                <thead>
                  <tr>
                    <th class="th-sm">Numero
                    </th>
                    <th class="th-sm">Cliente
                    </th>
                    <th class="th-sm">Usuário
                    </th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>

      <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-xl" role="document">
          <div class="modal-content" id="modalBody">
            <div class="modal-header">
              <h4 class="modal-title">Filtros</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">

              <div class="row" style="margin-top: 1.4%;">
                <div class="group-default form-group col-6">
                  <label for="txtDataEmiDe">Data Emissão De: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataEmiDe" name="DataDe">
                  </div>
                </div>
                <div class="group-default form-group col-6">
                  <label for="txtDataEmiAte">Até: </label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataEmiAte" name="DataDe">
                  </div>
                </div>
              </div>

              <div class="row">
                <div class="col-lg-12">
                  <label data-error="wrong" data-success="right" for="txtSolCompraConsulta">Solicitação </label>
                  <div class="input-group">
                    <input type="text" class="input-default col-lg-3 col-12 focus form-control" id="txtSolCompraConsulta" name="txtSolCompraConsulta" class="form-control" placeholder="Solicitação">
                    <button class="btn bg-danger" id="btn-SolCompraConsulta" name="btn-SolCompraConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                    <input type="text" id="txtListaSolCompra" class="form-group col-lg-9 col-12 input-default focus form-control" placeholder="Lista de Solicitação" disabled>
                    <button class="btn bg-danger" id="btn-limpa-SolCompra" name="btn-limpa-SolCompra" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                  </div>
                </div>
              </div>

              <div class="row">
                <div class="col-12" id="SolicitanteSolCompra">
                  <label data-error="wrong" data-success="right" for="txtSolicitanteConsulta">Solicitante </label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtSolicitanteConsulta" name="txtSolicitanteConsulta" class="form-control" placeholder="Solicitante">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-SolicitanteSolCompra" name="btn-SolicitanteSolCompra" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-SolicitanteSolCompra" name="btn-limpa-SolicitanteSolCompra" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="row">
                <div class="group-default form-group col-6">
                  <label for="">Status Lib. </label>
                  <div class="relative">
                    <select name="" id="txtStatusLib" value="" class="form-group input-default">
                      <option value="">Todos</option>
                      <option value="L">Liberada</option>
                      <option value="B">Bloqueada</option>
                    </select>
                  </div>
                </div>
                <div class="group-default form-group col-6">
                  <label for="">Status </label>
                  <div class="relative">
                    <select name="" id="txtStatus" value="" class="form-group input-default">
                      <option value="">Todos</option>
                      <option value="A">Aberto</option>
                      <option value="F">Fechado</option>
                      <option value="D">Devovido</option>
                    </select>
                  </div>
                </div>
              </div>

            </div>

            <div class="modal-footer">
              <div class="row">
                <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
                <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php
  include_once('../../../footer.php');
  include_once('../../../modals/modal_anexos.html');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.237.18.2"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.237.18.2"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.237.18.2"></script>
  <script src="dist/js/adminlte.min.js?versao=3.237.18.2"></script>
  <script src="dist/js/sisplan.js?versao=3.237.18.2"></script>
  <script src="utils/funcoes.js?versao=3.237.18.2"></script>
  <script src="utils/cookies.js?versao=3.237.18.2"></script>
  <script src="dist/js/requisicoes.js?versao=3.237.18.2"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.237.18.2"></script>
  <script src="dist/js/driver.min.js?versao=3.237.18.2"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="modals/modal_anexos.js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="config.js?versao=3.237.18.2"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('SOLICITACAO_COMPRA');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/solicitacao_compra/acesso_solicitacao_compra/acesso_solicitacao_compra.js?versao=3.237.18.2`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>