/* eslint-disable prefer-rest-params */
async function avancarPag() {
    currentFs = $(this).parent();
    nextFs = $(this).parent().next();

    $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

    nextFs.show();
    currentFs.animate({
        opacity: 0
    }, {
        step(now) {
            opacity = 1 - now;

            currentFs.css({
                'display': 'none',
                'position': 'relative'
            });
            nextFs.css({
                'opacity': opacity
            });
        },
        duration: 600
    });
}

$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true,
            onNext: (Element) => {
                if ((Element.node.id == 'avancar1')) {
                    avancarPag();
                    $('#avancar1').trigger('click');
                };
                if ((Element.node.id == 'avancar2')) {
                    $('#avancar2').trigger('click');
                }
            },
            onPrevious: (Element) => {
                if (Element.node.id == 'tourEmpresas') {
                    $('#voltar').trigger('click');
                };
                if (Element.node.id == 'tourGuias') {
                    $('#voltar2').trigger('click');
                }
            }
        });

        driver.defineSteps([{
            element: '#formcard1',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtDesc',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCpf',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtDiaPagto',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#avancar1',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para ir para a próxima aba.',
                position: 'left'
            }
        },
        {
            element: '#tourEmpresas',
            popover: {
                title: 'Campos de comparação',
                description: 'Aqui estão as empresas do representante.',
                position: 'top'
            }
        },
        {
            element: '#avancar2',
            popover: {
                title: 'Botão Avançar',
                description: 'Clique aqui para ir para a próxima aba.',
                position: 'left'
            }
        },
        {
            element: '#tourGuias',
            popover: {
                title: 'Dados de Alteração',
                description: 'Aqui estão os guias que este representate pode ter.',
                position: 'top'
            }
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar os dados do Representante.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    let contaFs = 1;

    $(".next").click(function () {

        contaFs += 1;

        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {

            currentFs = $(this).parent();
            nextFs = $(this).parent().next();

            $("#progressbar li").eq($("fieldset.fsPrincipal").index(nextFs)).addClass("active");

            nextFs.show();
            currentFs.animate({
                opacity: 0
            }, {
                step(now) {
                    opacity = 1 - now;

                    currentFs.css({
                        'display': 'none',
                        'position': 'relative'
                    });
                    nextFs.css({
                        'opacity': opacity
                    });
                },
                duration: 600
            });
        }

        $("#tabela-empAcesso").DataTable().columns.adjust().draw(false);
        $("#tabelaSetores").DataTable().columns.adjust().draw(false);
    });

    $(".previous").click(function () {

        contaFs -= 1;

        currentFs = $(this).parent();
        previousFs = $(this).parent().prev();
        $("#progressbar li").eq($("fieldset.fsPrincipal").index(currentFs)).removeClass("active");
        previousFs.show();
        currentFs.animate({
            opacity: 0
        }, {
            step(now) {
                opacity = 1 - now;
                currentFs.css({
                    'display': 'none',
                    'position': 'relative'
                });
                previousFs.css({
                    'opacity': opacity
                });
            },
            duration: 600
        });
    });

    $('#tabelaGuias').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        autoWidth: true,
        destroy: true,
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        }
    });

    $('#txtComFat').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtComRec').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtDiaPagto').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 0
    });

    let SPMaskBehavior = function (val) {
        return val.length === 15 ? '(00) 00000-0000' : '(00) 0000-00009';
    };
    let spOptions = {
        onKeyPress(val, e, field, options) {
            field.mask(SPMaskBehavior.apply({}, arguments), options);
        }
    };

    $('#txtTelefone').mask(SPMaskBehavior, spOptions);

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('REPRESENTANTE', getCookie('usuario'), parametros[5]);
        window.location.href = `${BASE_URI}/representante`;
    });

    $(document).ready(function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtCodigo: {
                    required: true,
                },
                txtDesc: {
                    required: true,
                },
                txtCpf: {
                    required: true,
                },
                txtDiaPagto: {
                    required: true,
                }
            },
            messages: {
                txtCodigo: {
                    required: "Informe um código válido."
                },
                txtDesc: {
                    required: "Informe um nome válido."
                },
                txtCpf: {
                    required: "Informe um CPF/CNPJ válido."
                },
                txtDiaPagto: {
                    required: "Informe um dia de pagamento válido."
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    $('#tabela-empAcesso').DataTable({
        paging: false,
        autoWidth: false,
        filter: false,
        info: false,
        ordering: false,
        destroy: true,
        scrollY: "300px",
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        },
        "columnDefs": [{
            "targets": [2],
            "visible": false
        }]
    });

    let dataSet = await RetornaEmpresas();
    await preencheSetores();
    $("#tabela-empAcesso").DataTable().columns.adjust().draw(false);

    const qtdeRegistros = $('#tabelaSetores').DataTable().rows().data()

    if (qtdeRegistros > 0) {
        $("#tabelaSetores").DataTable().columns.adjust().draw(false);
    }


    function botaoSelecionarGrid() {
        return '<div class="form-check">' +
            '<input type="checkbox" class="align-self-center checkEmpresa" value"">' +
            '</div>';
    };

    $('#tabela-empAcesso').DataTable().rows().remove().draw(false);
    for (let i = 0; i < dataSet.length; i++) {
        const empresa = dataSet[i];
        $('#tabela-empAcesso').DataTable().row.add([botaoSelecionarGrid(), `${empresa.EMP_PAT} - ${empresa.EMP_NOME}`, `${empresa.EMP_ID}`]).draw(false);
    }

    $('#tabela-empAcesso').on('click', 'td', function () {
        selecionarLinhaTabela('#tabela-empAcesso', 'checkEmpresa', this);
    });


    async function RetornaEmpresas() {
        let url = `/sisplan/funcoes/v1/pesquisa?`;
        let params = `JSON={"tabela":"empresa", "camposSelect":[ "emp_id", "emp_pat", "emp_nome"], "where": null}`;

        try {
            let response = await requisicao('GET', url, params, null);

            if (!response) {
                return '';
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return '';
            }

            const arrDados = jsonStr.RESULT[0];
            return arrDados;
        } catch (error) {
            console.error(error);
            msgErro('Não foi possível buscar as empresas.');
            return '';
        }
    }

    $('#txtCep').autocompleta(1, `JSON={ "tabela":"cadcep", "camposSelect":[ "cep chave", "codmun descricao"], "where": null}`);
    $('#txtCoordenador').autocompleta(1, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
    $('#txtTipoEntidade').autocompleta(1, `JSON={ "tabela":"sitcli", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtGrupoCliente').autocompleta(1, `JSON={ "tabela":"grupo_cli", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtGuia').autocompleta(1, `JSON={ "tabela": "represen", "camposSelect": ["codrep chave", "nome descricao"], "where": ["REPRESEN.ATIVO = 'S'", "REPRESEN.GRUPO_REP = 'U'"]}`);
    $('#btnCep').pesquisa('#txtCep', 'CEP', 'CODMUN', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadcep", "camposSelect":[ "cep", "codmun"]}`, 'Pesquisa CEP', 'cadcep');
    $('#btnCoordenador').pesquisa_serverside(['#txtCoordenador'], ['CODCLI', 'NOME'], ['CODCLI', 'NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa Coordenador');
    $('#btnTipoEntidade').pesquisa('#txtTipoEntidade', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"sitcli", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Tipo Entidade', 'sitcli');
    $('#btnGrupoCliente').pesquisa('#txtGrupoCliente', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"grupo_cli", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Grupo Cliente', 'grupo_cli');
    $('#btn-Guia').pesquisa('#txtGuia', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "represen", "camposSelect": ["codrep", "nome"], "where": ["ativo = 'S'", "grupo_rep = 'U'"]}`, 'Pesquisa Guia', 'Represen');
    $('#btnACep').on('click', function () {
        $('#txtCep').val('');
    });
    $('#btnACoordenador').on('click', function () {
        $('#txtCoordenador').val('');
    });
    $('#btnATipoEntidade').on('click', function () {
        $('#txtTipoEntidade').val('');
    });
    $('#btnAGrupoCliente').on('click', function () {
        $('#txtGrupoCliente').val('');
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let representante = parametros[parametros.length - 1];

    $('#txtCodigo').prop('disabled', true);

    async function executaSelectEmpresa(codigo, tabela) {
        try {
            const empValor = await fazSelectNaEmpValor(codigo, tabela);
            const url = '/Sisplan/Funcoes/v1/pesquisa?';

            if (empValor.length > 0) {
                return empValor;
            }
            const response = await requisicao('GET', url, `JSON={ "tabela":"REPRESEN", "camposSelect":["EMP_LOJA", "CODREP"], "where": ["CODREP = '${codigo}'"]}`);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.mensagem);
                return;
            }

            const dadosFormatados = [];
            if (jsonStr.RESULT[0].length > 0) {
                let arrayEmp = jsonStr.RESULT[0][0].EMP_LOJA.split(',');
                for (let i = 0; i < arrayEmp.length; i++) {
                    const dados = {};
                    const dadosArray = arrayEmp[i];
                    dados.EMP_ID = dadosArray.substr(1);
                    dadosFormatados.push(dados);
                }
                return dadosFormatados;
            }

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar as empresas.`);
        }
    }

    if (representante != '' && representante != 'create') {

        $('#account').css('cursor', 'pointer');
        $('#payment').css('cursor', 'pointer');
        $('#personal').css('cursor', 'pointer');

        if (await liberarRegistro('REPRESENTANTE', representante) == false) {
            window.location.href = '../representante';
        } else {

            try {
                $.LoadingOverlay("show");

                try {
                    let resposta = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"represen", 
                        "camposSelect":[
                            "represen.ativo", 
                            "represen.comissao", 
                            "represen.comissao2", 
                            "represen.dia_comissao", 
                            "represen.grupo_rep", 
                            "represen.cep", 
                            "represen.codrep", 
                            "represen.nome", 
                            "represen.cnpj", 
                            "represen.inscricao", 
                            "represen.bairro", 
                            "represen.endereco", 
                            "represen.telefone", 
                            "represen.email", 
                            "represen.SETORES",
                            "represen.COORDENADOR",
                            "entidade.NOME COORDENADOR_NOME",
                            "represen.GRUPO",
                            "sitcli.DESCRICAO GRUPO_DESC",
                            "represen.GRUPO_CLI",
                            "grupo_cli.DESCRICAO GRUPO_CLI_DESC"
                        ], 
                        "LeftJoin": [
                            {"tabela": "grupo_cli", "condicao": "grupo_cli.codigo = represen.grupo_cli"},
                            {"tabela": "sitcli", "condicao": "sitcli.codigo = represen.grupo"},
                            {"tabela": "entidade", "condicao": "entidade.codcli = represen.coordenador"}
                        ],
                        "where": ["represen.codrep = '${representante}'"]
                    }`,
                        null
                    );

                    let jsonTal = await resposta.json();
                    if (jsonTal.RESULT[0].length > 0) {

                        const codigo = jsonTal.RESULT[0][0].CODREP;
                        const tabela = 'REPRESEN';

                        const empValor = await executaSelectEmpresa(codigo, tabela);

                        if (empValor != '') {
                            for (let i = 0; i < empValor.length; i++) {
                                for (let x = 0; x < $('#tabela-empAcesso').DataTable().rows().data().length; x++) {
                                    let dados = $('#tabela-empAcesso').DataTable().rows().data()[x];
                                    let empresa = dados[2];
                                    if (empresa == empValor[i].EMP_ID) {
                                        $($('.checkEmpresa')[x]).prop('checked', true);
                                        $($("table#tabela-empAcesso tr")[x + 1]).addClass("selected");
                                    }
                                }
                            }
                        }

                        let setores = jsonTal.RESULT[0][0].SETORES.replaceAll("'", '').split(',');
                        let dadosSetores = $('#tabelaSetores').DataTable().rows().data();

                        if (dadosSetores.length > 0) {

                            for (let j = 0; j < setores.length; j++) {
                                for (let i = 0; i < dadosSetores.length; i++) {
                                    if (setores[j] == dadosSetores[i].CODIGO) {
                                        $(`#checkSetor${i}`).prop('checked', true);
                                        break;
                                    }
                                }
                            }
                        }

                        $('#txtCodigo').val(jsonTal.RESULT[0][0].CODREP);
                        $('#txtDesc').val(jsonTal.RESULT[0][0].NOME);
                        $('#txtCpf').val(jsonTal.RESULT[0][0].CNPJ);
                        $('#txtIe').val(jsonTal.RESULT[0][0].INSCRICAO);
                        $('#txtBairro').val(jsonTal.RESULT[0][0].BAIRRO);
                        $('#txtEndereco').val(jsonTal.RESULT[0][0].ENDERECO);
                        $('#txtTelefone').val(jsonTal.RESULT[0][0].TELEFONE);
                        $('#txtEmail').val(jsonTal.RESULT[0][0].EMAIL);
                        $('#txtComFat').val(jsonTal.RESULT[0][0].COMISSAO);
                        $('#txtComRec').val(jsonTal.RESULT[0][0].COMISSAO2);
                        $('#txtDiaPagto').val(jsonTal.RESULT[0][0].DIA_COMISSAO);
                        insereValor('#txtCoordenador', jsonTal.RESULT[0][0].COORDENADOR, jsonTal.RESULT[0][0].COORDENADOR_NOME);
                        insereValor('#txtTipoEntidade', jsonTal.RESULT[0][0].GRUPO, jsonTal.RESULT[0][0].GRUPO_DESC);
                        insereValor('#txtGrupoCliente', jsonTal.RESULT[0][0].GRUPO_CLI, jsonTal.RESULT[0][0].GRUPO_CLI_DESC);

                        if (jsonTal.RESULT[0][0].GRUPO_REP == 'R') {
                            $('#radioRepresentante').prop('checked', true);
                        }
                        if (jsonTal.RESULT[0][0].GRUPO_REP == 'V') {
                            $('#radioVendedor').prop('checked', true);
                        }
                        if (jsonTal.RESULT[0][0].GRUPO_REP == 'G') {
                            $('#radioGerente').prop('checked', true);
                        }
                        if (jsonTal.RESULT[0][0].GRUPO_REP == 'U') {
                            $('#radioGuia').prop('checked', true);
                        }
                        if (jsonTal.RESULT[0][0].ATIVO == 'S') {
                            $('#checkAtivo').prop('checked', true);
                        } else {
                            $('#checkAtivo').prop('checked', false);
                        }

                        await BuscaDadosGuia($('#txtCodigo').val());

                        try {
                            let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                                `JSON={ "tabela":"cadcep", 
                            "camposSelect":["codmun"], 
                            "where": ["cep = '${jsonTal.RESULT[0][0].CEP}'"]}`, null);

                            let jsonString = await response.json();

                            insereValor('#txtCep', jsonTal.RESULT[0][0].CEP, jsonString.RESULT[0][0].CODMUN);

                        } catch (error) {
                            console.error(error);
                        }

                    } else {

                        try {
                            let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                                `JSON={ "tabela":"entidade", 
                        "camposSelect":["codcli", "nome", "cnpj", "inscricao", "cep", "bairro", "endereco", "telefone", "email"], 
                        "where": ["codcli = '${representante}'"]}`, null);

                            if (!response) {
                                return;
                            }
                            let jsonStr = await response.json();
                            if (response.status != 200) {
                                msgErro(jsonStr.RESULT[0].mensagem);
                                return;
                            }

                            $('#txtCodigo').val(jsonStr.RESULT[0][0].CODCLI);
                            $('#txtDesc').val(jsonStr.RESULT[0][0].NOME);
                            $('#txtCpf').val(jsonStr.RESULT[0][0].CNPJ);
                            $('#txtIe').val(jsonStr.RESULT[0][0].INSCRICAO);
                            $('#txtBairro').val(jsonStr.RESULT[0][0].BAIRRO);
                            $('#txtEndereco').val(jsonStr.RESULT[0][0].ENDERECO);
                            $('#txtTelefone').val(jsonStr.RESULT[0][0].TELEFONE);
                            $('#txtEmail').val(jsonStr.RESULT[0][0].EMAIL);

                            try {
                                response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                                    `JSON={ "tabela":"cadcep", 
                            "camposSelect":["codmun"], 
                            "where": ["cep = '${jsonStr.RESULT[0][0].CEP}'"]}`, null);

                                let jsonString = await response.json();

                                insereValor('#txtCep', jsonStr.RESULT[0][0].CEP, jsonString.RESULT[0][0].CODMUN);

                            } catch (error) {
                                console.error(error);
                            }

                        } catch (error) {
                            console.error(error);
                            msgErro(`Não foi possível buscar os dados do representante: ${error}`);
                        }
                    }
                } catch (error) {
                    console.error(error);
                }

            } finally {
                $.LoadingOverlay('hide');
            }
        }
    };

    $('#account').on('click', function () {
        if (representante != 'create') {
            if (contaFs == 2) {
                $('#voltar').trigger('click');
            }
            if (contaFs == 3) {
                $('#voltar2').trigger('click');
                $('#voltar').trigger('click');
            }
        }
    });

    $('#payment').on('click', function () {
        if (representante != 'create') {
            if (contaFs == 1) {
                $('#avancar1').trigger('click');
            }
            if (contaFs == 3) {
                $('#voltar2').trigger('click');
            }
        }
    });

    $('#personal').on('click', function () {
        if (representante != 'create') {
            if (contaFs == 1) {
                $('#avancar1').trigger('click');
                $('#avancar2').trigger('click');
            }
            if (contaFs == 2) {
                $('#avancar2').trigger('click');
            }
        }
    });

    $('#txtDiaPagto').change(async function () {
        if ($('#txtDiaPagto').val() > 31) {
            $('#txtDiaPagto').val(31);
        }
        if ($('#txtDiaPagto').val() < 1) {
            $('#txtDiaPagto').val(1);
        }
    });

    console.log($('#txtCpf').val().length);

    $('#txtGuia').on('blur', async function () {
        await AlimentaGridGuia();
    });

    async function AlimentaGridGuia() {
        const CodRep = pegaChave('#txtGuia');
        const NomeRepresentante = pegaDescricao('#txtGuia');
        const linhas = $('#tabelaGuias').DataTable().rows().count();
        let adicionaRegistro = true;
        if (CodRep != '') {
            if (linhas <= 0) {
                $('#tabelaGuias').DataTable().row.add([CodRep, NomeRepresentante, retornaBotaoOpcoes()]).draw(false);
            } else {
                for (let i = 0; i < linhas; i++) {
                    if ($('#tabelaGuias').DataTable().data()[i][0] == CodRep) {
                        adicionaRegistro = false;
                    }
                }
                if (adicionaRegistro) {
                    $('#tabelaGuias').DataTable().row.add([CodRep, NomeRepresentante, retornaBotaoOpcoes()]).draw(false);
                } else {
                    msgAlerta('Código de representante já adicionado no grid! Impossivel adicionar novamente.');
                }
            }
            $('#txtGuia').val('');
        }
    }

    $('#tabelaGuias').on('click', '.btn-excluir', async function () {
        $('#tabelaGuias').DataTable().row($(this).parents('tr')).remove().draw(false);
    });

    function retornaBotaoOpcoes() {
        return '<div class="divBtnOpcoes"> ' +
            '    <button class="botaoOpcoes btn-excluir" type="button"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
            '   </div>';
    }

    function montaJsonGuias(CodRep, Guia) {
        const objeto = {
            CodRep,
            Guia
        };
        return objeto;
    }

    $("#gravar").click(
        async function () {

            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    representante = {};

                    representante.CODREP = $('#txtCodigo').val();
                    representante.NOME = $('#txtDesc').val();
                    representante.CNPJ = $('#txtCpf').val();
                    representante.INSCRICAO = $('#txtIe').val();
                    representante.CEP = pegaChave('#txtCep', representante.CEP);
                    representante.BAIRRO = $('#txtBairro').val();
                    representante.ENDERECO = $('#txtEndereco').val();
                    representante.COMISSAO = $('#txtComFat').val();
                    representante.COMISSAO2 = $('#txtComRec').val();
                    representante.DIA_COMISSAO = $('#txtDiaPagto').val();
                    representante.EMAIL = $('#txtEmail').val();
                    representante.TELEFONE = $('#txtTelefone').val();
                    representante.COORDENADOR = pegaChave('#txtCoordenador');
                    representante.GRUPO = pegaChave('#txtTipoEntidade');
                    representante.GRUPO_CLI = pegaChave('#txtGrupoCliente');

                    if ($('#txtCpf').val().length < 14) {
                        representante.TIPO = '1';
                    } else {
                        representante.TIPO = '2';
                    }

                    if ($('#radioRepresentante').prop('checked')) {
                        representante.GRUPO_REP = 'R';
                    }
                    if ($('#radioVendedor').prop('checked')) {
                        representante.GRUPO_REP = 'V';
                    }
                    if ($('#radioGerente').prop('checked')) {
                        representante.GRUPO_REP = 'G';
                    }
                    if ($('#radioGuia').prop('checked')) {
                        representante.GRUPO_REP = 'U';
                    }

                    if ($('#checkAtivo').prop('checked')) {
                        representante.ATIVO = 'S';
                    } else {
                        representante.ATIVO = 'N';
                    }

                    let arrayEmpresas = [];
                    for (let i = 0; i < $('#tabela-empAcesso').DataTable().rows('.selected').data().length; i++) {
                        let dados = $('#tabela-empAcesso').DataTable().rows('.selected').data()[i];
                        const empresa = dados[2];
                        arrayEmpresas.push(empresa);
                    }

                    const data = $("#tabelaSetores").DataTable().data().toArray();
                    let setores = '';

                    for (let i = 0; i < data.length; i++) {
                        if ($(`#checkSetor${i}`)[0].checked == true) {
                            setores += "'" + data[i].CODIGO + "'" + ",";
                        }
                    }
                    representante.SETORES = setores.substring(0, setores.length - 1);

                    const arrGuias = $('#tabelaGuias').DataTable()
                        .rows()
                        .data()
                        .toArray()
                        .map((guia) => montaJsonGuias($('#txtCodigo').val(), guia[0]));

                    representante.EMP_LOJA = arrayEmpresas;
                    representante.GUIAS = arrGuias;

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/representante?', `JSON=${encodeURIComponent(JSON.stringify(representante))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }

                    $.LoadingOverlay("hide");
                    toastr.success(
                        'Cadastro efetuado com sucesso!',
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/representante`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                } catch (error) {
                    $.LoadingOverlay("hide");
                    msgErro(`Não foi possível gravar os dados do representante: ${error}`);
                }
            }
        });


    async function BuscaDadosGuia(CodRep) {
        const dadosSelect = {
            Tabela: 'rep_guia',
            CamposSelect: ["rep_guia.codrep, rep_guia.guia, represen.nome"],
            LeftJoin: [{ "tabela": "represen", "condicao": "rep_guia.guia = represen.codrep" }],
            Where: [`rep_guia.codrep = '${CodRep}'`],
        };

        const response = await retornaJsonPesquisaPadrao(encodeURIComponent(JSON.stringify(dadosSelect)));

        if (!response) {
            return;
        }
        let jsonStr = response;

        jsonStr.map(element => {
            $('#tabelaGuias').DataTable().row.add([
                element.GUIA,
                element.NOME,
                retornaBotaoOpcoes()]).draw(false);
            return 'ok';
        });
    }

    async function preencheSetores() {
        try {
            let response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', 'JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null, "orderBy": ["CODIGO"]}', null);


            if (!response) {
                return;
            }

            let jsonStr = await response.json();

            if (jsonStr.RESULT[0].length == 0) {
                return;
            }

            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            const listaFormatada = [{}];

            jsonStr.RESULT[0].map((item, i) => {
                listaFormatada[i] = {
                    SEL: item.SEL = `
            <input type="checkbox" class="align-self-center checkSetor" value""="" id="checkSetor${i}">`,
                    CODIGO: jsonStr.RESULT[0][i].CODIGO,
                    SETORES: jsonStr.RESULT[0][i].CODIGO + ' - ' + jsonStr.RESULT[0][i].DESCRICAO,
                };
            });

            const dataSetCols = [];
            const keys = Object.keys(listaFormatada[0]);
            for (let k in keys) {
                dataSetCols.push({
                    data: keys[k],
                });
            }

            $("#tabelaSetores").DataTable({
                bPaginate: false,
                destroy: true,
                search: false,
                filter: false,
                lengthChange: false,
                serverside: false,
                order: false,
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                autoWidth: true,
                data: listaFormatada,
                columns: dataSetCols,
                columnDefs: [
                    {
                        targets: 1,
                        visible: false,
                    },
                ],
            });

        } catch (error) {
            msgErro('Não foi possível buscar os setores.');
            return;
        }
    }
});