$(document).ready(async function () {

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relPosEstoque == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPosEstoque: ['MATERIAL', 'DESC_MATERIAL'] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPosEstoque: novasColunas }))

      $('#tabelaPosicaoEstoque').DataTable().columns().visible(true);
      // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

      $('#tabelaPosicaoEstoque').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltrosRel',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir um relatório.',
          position: 'right'
        }
      }
      ]);
      driver.start();
    });
  });

  let modalAberto = false;

  $('#btnFiltrosRel').on('click', async function() {
    if (!modalAberto) {
      $('[role="combobox"]').trigger('click');
      modalAberto = true;
    }
    
    setTimeout(function() {
      $('.modal-body').trigger('click');
      $('#modal-filtros').modal('show');
    }, 100);
  });
  
  $('#btnLimpaFiltros').on('click', function () {
    limpaFiltros();
  });

  $('#btnConsultar').on('click', async function () {
    await fazConsulta();
    $('#modal-filtros').modal('hide');

  });

  await preencheOrdenacaoTela('RelPosEstoque');

  async function fazConsulta() {
    if ($.fn.DataTable.isDataTable('#tabelaPosicaoEstoque')) {
      $("#tabelaPosicaoEstoque").DataTable().destroy();
      $("#tabelaPosicaoEstoque").empty();
    }
    try {
      dataSetCols = [];
      $.LoadingOverlay('show');

      const url = `/sisplan/impressao/v1/relposestoque?`;
      const filtros = await retornaFiltros();
      const response = await requisicao('GET', url, `${filtros}&COD_USUARIO=${getCookie('cod_usuario')}`, '', 360000);

      if (!response) {
        return;
      };

      const jsonStr = await response.json();

      if (jsonStr.length == 0) {
        msgAlerta("Nenhum registro encontrado!");
        $("#txtMeta").val();
        if ($.fn.DataTable.isDataTable('#tabelaPosicaoEstoque')) {
          $('#tabelaPosicaoEstoque').DataTable().destroy();
          $('#tabelaPosicaoEstoque').empty();
        }
        return;
      }

      if (response.status != 200) {
        console.error(jsonStr.mensagem);
        msgAlerta("Nenhum registro encontrado!");
        return;
      }

      let keys = Object.keys(jsonStr[0]);

      keys.forEach((k) => {
        dataSetCols.push({
          title: k,
          data: k,
        });
      });

      let indiceValor;

      for (let i = 0; i < keys.length; i++) {
        if (keys[i] == 'VALOR') {
          indiceValor = i;
        }
      }

      $('#tabelaPosicaoEstoque').DataTable({
        bPaginate: true,
        destroy: true,
        colReorder: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        columns: dataSetCols,
        data: jsonStr,
        columnDefs: [{
          targets: 0,
          // searchable: false
        }]
      });

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaPosicaoEstoque_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaPosicaoEstoque_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
      $('#buttonExcel').prop('title', 'Exportar')

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      });

      $('#buttonExcel').on('click', async function () {
        const url = `/sisplan/impressao/v1/relposestoque?`;
        const filtros = await retornaFiltros();
        await exportaCSV(url, filtros, false, null, 'Relatório de Posição de Estoque', '#tabelaPosicaoEstoque');
      })

      $('#tabelaPosicaoEstoque').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.relPosEstoque).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaPosicaoEstoque').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relPosEstoque ?? ['MATERIAL', 'DESC_MATERIAL'])
  })

  $('#btnCarregaEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  async function retornaFiltros() {

    let estoqueNegativo = 'N';
    let consideraDtCad = 'N';

    let cbConsideraCodigo = 'N';
    let cbConsideraCor = 'N';
    let cbConsideraDeposito = 'N';
    let cbConsideraGrupo = 'N';
    let cbConsideraMarca = 'N';
    let cbConsideraLinha = 'N';
    let cbConsideraColecao = 'N';
    let cbConsideraSubColecao = 'N';
    let cbConsideraStatus = 'N';
    let cbConsideraTabPreco = 'N';
    let cbConsideraPeriodo = 'N';
    let cbConsideraCategoria = 'N';
    let cbConsideraQualidade = 'N';
    let cbConsideraGramatura = 'N';
    let cbConsideraComposicao = 'N';


    if ($('#cbEstoqueNegativo').is(':checked')) {
      estoqueNegativo = 'S';
    }
    if ($('#cbConsideraDtCad').is(':checked')) {
      consideraDtCad = 'S';
    }

    if ($('#cbConsideraCodigo').is(':checked')) {
      cbConsideraCodigo = 'S';
    }

    if ($('#cbConsideraCor').is(':checked')) {
      cbConsideraCor = 'S';
    }

    if ($('#cbConsideraDeposito').is(':checked')) {
      cbConsideraDeposito = 'S';
    }

    if ($('#cbConsideraGrupo').is(':checked')) {
      cbConsideraGrupo = 'S';
    }

    if ($('#cbConsideraMarca').is(':checked')) {
      cbConsideraMarca = 'S';
    }

    if ($('#cbConsideraLinha').is(':checked')) {
      cbConsideraLinha = 'S';
    }

    if ($('#cbConsideraColecao').is(':checked')) {
      cbConsideraColecao = 'S';
    }

    if ($('#cbConsideraSubColecao').is(':checked')) {
      cbConsideraSubColecao = 'S';
    }

    if ($('#cbConsideraStatus').is(':checked')) {
      cbConsideraStatus = 'S';
    }

    if ($('#cbConsideraTabPreco').is(':checked')) {
      cbConsideraTabPreco = 'S';
    }

    if ($('#cbConsideraPeriodo').is(':checked')) {
      cbConsideraPeriodo = 'S';
    }

    if ($('#cbConsideraCategoria').is(':checked')) {
      cbConsideraCategoria = 'S';
    }

    if ($('#cbConsideraQualidade').is(':checked')) {
      cbConsideraQualidade = 'S';
    }

    if ($('#cbConsideraGramatura').is(':checked')) {
      cbConsideraGramatura = 'S';
    }

    if ($('#cbConsideraComposicao').is(':checked')) {
      cbConsideraComposicao = 'S';
    }

    const empresasFiltradas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')];
    const empresasFiltradasFormatada = await formataListas(empresasFiltradas.toString());
    const vendas = $('input[name="rdTipoTodos"]:checked').val();
    const produtos = $('input[name="filtroTodos"]:checked').val();
    const data = $('#txtData').val().replace();
    const codigo = await formataListas($('#txtCodigo').val().toString());
    const deposito = await formataListas($('#txtDeposito').val().toString());
    const grupo = await formataListas($('#txtGrupo').val().toString());
    const colecao = await formataListas($('#txtColecao').val().toString());
    const status = await formataListas($('#txtStatus').val().toString());
    const gramatura = await formataListas($('#txtGramatura').val().toString());
    const composicao = await formataListas($('#txtComposicao').val().toString());
    const marca = await formataListas($('#txtMarca').val().toString());
    const linha = await formataListas($('#txtLinha').val().toString());
    const tabPreco = await formataListas($('#txtTabPreco').val().toString());
    const diasPrazo = $('#selectPrazo').val();
    const lote = $('#txtLote').val();
    const subColecao = await formataListas($('#txtSubColecao').val().toString());
    const cor = await formataListas($('#txtCor').val().toString());
    const qualidade = await formataListas($('#txtQualidade').val().toString());
    const prazo = await formataListas($('#txtTabPrazo').val().toString());
    const categoria = await formataListas($('#txtCategoria').val().toString());
    const selPrazos = $('#selectPrazo').val();

    const filtros =
      `EMP_IDS=${empresasFiltradas}&` +
      `EMPRESASFILTRADAS=${empresasFiltradasFormatada}&` +
      `PRODUTOS=${produtos}&` +
      `CONSIDERACODIGO=${cbConsideraCodigo}&` +
      `CONSIDERACOR=${cbConsideraCor}&` +
      `CONSIDERADEPOSITO=${cbConsideraDeposito}&` +
      `CONSIDERAGRUPO=${cbConsideraGrupo}&` +
      `CONSIDERAMARCA=${cbConsideraMarca}&` +
      `CONSIDERALINHA=${cbConsideraLinha}&` +
      `CONSIDERACOLECAO=${cbConsideraColecao}&` +
      `CONSIDERASUBCOLECAO=${cbConsideraSubColecao}&` +
      `CONSIDERASTATUS=${cbConsideraStatus}&` +
      `CONSIDERATABPRECO=${cbConsideraTabPreco}&` +
      `CONSIDERAPERIODO=${cbConsideraPeriodo}&` +
      `CONSIDERACATEGORIA=${cbConsideraCategoria}&` +
      `CONSIDERAQUALIDADE=${cbConsideraQualidade}&` +
      `CONSIDERAGRAMATURA=${cbConsideraGramatura}&` +
      `CONSIDERACOMPOSICAO=${cbConsideraComposicao}&` +
      `VENDAS=${vendas}&` +
      `ESTOQUENEGATIVO=${estoqueNegativo}&` +
      `CONSIDERADTCAD=${consideraDtCad}&` +
      `DATA=${data}&` +
      `CODIGO=${codigo}&` +
      `DEPOSITO=${deposito}&` +
      `GRUPO=${grupo}&` +
      `STATUS=${status}&` +
      `GRAMATURA=${gramatura}&` +
      `COMPOSICAO=${composicao}&` +
      `MARCA=${marca}&` +
      `LINHA=${linha}&` +
      `TABPRECO=${tabPreco}&` +
      `DIASPRAZO=${diasPrazo}&` +
      `LOTE=${lote}&` +
      `COLECAO=${colecao}&` +
      `SUBCOLECAO=${subColecao}&` +
      `COR=${cor}&` +
      `QUALIDADE=${qualidade}&` +
      `PRAZO=${prazo}&` +
      `CATEGORIA=${categoria}&` +
      `SELECTPRAZO=${selPrazos}`;

    return filtros;
  };

  $('#txtCodigo').pesquisa_variosServerside(1, '{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtDeposito').pesquisa_variosServerside(1, '{ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtGrupo').pesquisa_variosServerside(1, '{ "tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtColecao').pesquisa_variosServerside(1, '{ "tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtStatus').pesquisa_variosServerside(1, '{ "tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtGramatura').pesquisa_variosServerside(1, '{ "tabela":"CADGRAMAT", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtComposicao').pesquisa_variosServerside(1, '{ "tabela":"CADCOMPOSI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtMarca').pesquisa_variosServerside(1, '{ "tabela":"MARCA", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtLinha').pesquisa_variosServerside(1, '{ "tabela":"TABLIN", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtTabPreco').pesquisa_variosServerside(1, '{ "tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ], "where": null}', 'REGIAO', 'DESCRICAO');
  $('#txtSubColecao').pesquisa_variosServerside(1, '{ "tabela":"CADTAG", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtCor').pesquisa_variosServerside(1, '{ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ], "where": null}', 'COR', 'DESCRICAO');
  $('#txtQualidade').pesquisa_variosServerside(1, '{ "tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'CODIGO', 'DESCRICAO');
  $('#txtTabPrazo').pesquisa_variosServerside(1, '{ "tabela":"TABPRZ", "camposSelect":[ "PRAZO", "DESCRICAO" ], "where": null}', 'PRAZO', 'DESCRICAO', 'DT_FIM', 'DT_INICIO');
  $('#txtCategoria').pesquisa_variosServerside(1, '{ "tabela":"REGIAO", "camposSelect":[ "ID", "DESCRICAO" ], "where": null}', 'PRAZO', 'DESCRICAO');
  $('#btnConsultaCodigo').pesquisa_serversideSel('#txtCodigo', `{ "tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Produto');
  $('#btnConsultaDeposito').pesquisa_serversideSel('#txtDeposito', `{ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Depósito');
  $('#btnConsultaGrupo').pesquisa_serversideSel('#txtGrupo', `{ "tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Grupo');
  $('#btnConsultaColecao').pesquisa_serversideSel('#txtColecao', `{ "tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Coleção');
  $('#btnConsultaStatus').pesquisa_serversideSel('#txtStatus', `{ "tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Status');
  $('#btnConsultaGramatura').pesquisa_serversideSel('#txtGramatura', `{ "tabela":"CADGRAMAT", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Gramatura');
  $('#btnConsultaComposicao').pesquisa_serversideSel('#txtComposicao', `{ "tabela":"CADCOMPOSI", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Composição');
  $('#btnConsultaMarca').pesquisa_serversideSel('#txtMarca', `{ "tabela":"MARCA", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Marca');
  $('#btnConsultaLinha').pesquisa_serversideSel('#txtLinha', `{ "tabela":"TABLIN", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Linha');
  $('#btnConsultaTabPreco').pesquisa_serversideSel('#txtTabPreco', `{ "tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO"], "where": null}`, 'Pesquisa de Preço');
  $('#btnConsultaSubColecao').pesquisa_serversideSel('#txtSubColecao', `{ "tabela":"CADTAG", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Sub-Coleção');
  $('#btnConsultaCor').pesquisa_serversideSel('#txtCor', `{ "tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO"], "where": null}`, 'Pesquisa de Cor');
  $('#btnConsultaQualidade').pesquisa_serversideSel('#txtQualidade', `{ "tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Qualidade');
  $('#btnConsultaTabPrazo').pesquisa_serversideSel('#txtTabPrazo', `{ "tabela":"TABPRZ", "camposSelect":[ "PRAZO", "DESCRICAO", "DT_FIM", "DT_INICIO"], "where": null}`, 'Pesquisa de Período');
  $('#btnConsultaCategoria').pesquisa_serversideSel('#txtCategoria', `{ "tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO"], "where": null}`, 'Pesquisa de Categoria');

  $('#btnLimpaCodigo').on('click', function () {
    $('#txtCodigo').empty().trigger('change');
  });
  $('#btnLimpaDeposito').on('click', function () {
    $('#txtDeposito').empty().trigger('change');
  });
  $('#btnLimpaGrupo').on('click', function () {
    $('#txtGrupo').empty().trigger('change');
  });
  $('#btnLimpaColecao').on('click', function () {
    $('#txtColecao').empty().trigger('change');
  });
  $('#btnLimpaStatus').on('click', function () {
    $('#txtStatus').empty().trigger('change');
  });
  $('#btnLimpaGramatura').on('click', function () {
    $('#txtGramatura').empty().trigger('change');
  });
  $('#btnLimpaComposicao').on('click', function () {
    $('#txtComposicao').empty().trigger('change');
  });
  $('#btnLimpaMarca').on('click', function () {
    $('#txtMarca').empty().trigger('change');
  });
  $('#btnLimpaLinha').on('click', function () {
    $('#txtLinha').empty().trigger('change');
  });
  $('#btnLimpaTabPreco').on('click', function () {
    $('#txtTabPreco').empty().trigger('change');
  });
  $('#btnLimpaSubColecao').on('click', function () {
    $('#txtSubColecao').empty().trigger('change');
  });
  $('#btnLimpaCor').on('click', function () {
    $('#txtCor').empty().trigger('change');
  });
  $('#btnLimpaQualidade').on('click', function () {
    $('#txtQualidade').empty().trigger('change');
  });
  $('#btnLimpaTabPrazo').on('click', function () {
    $('#txtTabPrazo').empty().trigger('change');
  });
  $('#btnLimpaCategoria').on('click', function () {
    $('#txtCategoria').empty().trigger('change');
  });

  function limpaFiltros() {
    $('#txtCodigo').empty().trigger('change');
    $('#txtDeposito').empty().trigger('change');
    $('#txtGrupo').empty().trigger('change');
    $('#txtColecao').empty().trigger('change');
    $('#txtStatus').empty().trigger('change');
    $('#txtGramatura').empty().trigger('change');
    $('#txtComposicao').empty().trigger('change');
    $('#txtMarca').empty().trigger('change');
    $('#txtLinha').empty().trigger('change');
    $('#txtTabPreco').empty().trigger('change');
    $('#txtLote').val('');
    $('#selectPrazo').val('00');
    $('#txtSubColecao').empty().trigger('change');
    $('#txtCor').empty().trigger('change');
    $('#txtQualidade').empty().trigger('change');
    $('#txtTabPrazo').empty().trigger('change');
    $('#txtCategoria').empty().trigger('change');

    $('#txtData').val('1200-01-01');
    $('#rdFiltroTodos').prop('checked', true);
    $('#rdFiltroAtivos').prop('checked', false);
    $('#rdFiltroInativos').prop('checked', false);
    $('#rdTipoTodos').prop('checked', true);
    $('#rdTipoProducao').prop('checked', false);
    $('#rdTipoRevenda').prop('checked', false);
    $('#cbConsideraDtCad').prop('checked', false);
    $('#cbPosseCadDep').prop('checked', false);
    $('#cbEstoqueNegativo').prop('checked', false);
  }

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const filtros = await retornaFiltros();
        let url = `/sisplan/impressao/v1/relposestoque?${filtros}&COD_USUARIO=${getCookie('cod_usuario')}`;
        const ordem = `&TELA_ORDENACAO=RelPosEstoque&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelPosEstoque');
        const arquivo = await GeraRelatorio(`${url}${ordem}&`, "POST", 100000, false, 'relposestoque');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

})













































