$(document).ready(async function () {

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.relatorioMovimentacao == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relatorioMovimentacao: [] }));
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relatorioMovimentacao: novasColunas }))

      $('#tabelaRelMovimentacao').DataTable().columns().visible(true);
      // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

      $('#tabelaRelMovimentacao').DataTable().columns().every(
        function () {
          if ((novasColunas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        })

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar alguma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para Imprimir um relatório.',
          position: 'right'
        }
      }
      ]);
      driver.start();
    });
  });

  await preencheOrdenacaoTela('RelMovimentacaoDeEstoque');

  $('#txtOrdem').val('3');

  // const filtroDeposito = await retornaDepositoUsuario(getCookie('cod_usuario'));
  
  const filtroDeposito = await buscaDepositoEmpresaUsuario();

  componenteFiltro('produto', true);
  componenteFiltro('colecao', true);
  componenteFiltro('depositoUsuario', true);
  componenteFiltro('cor', true);
  componenteFiltro('tamanho', true);
  componenteFiltro('qualidade', true);
  componenteFiltro('tipoMov', true);
  componenteFiltro('etiqueta', true);
  componenteFiltro('grupo', true);
  componenteFiltro('linha', true);
  componenteFiltro('marca', true);
  componenteFiltro('modelo', true);

  $('#btn-limpa-Docto').on('click', function () {
    $('#txtDocto').val('');
    $('#txtListaDocto').val('');
  })

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  $('#txtDocto').on('change', async function () {
    const documento = $('#txtDocto').val();
    const listaDoctos = $('#txtListaDocto').val();
    if (listaDoctos === '') {
      $('#txtListaDocto').val(documento);
      $('#txtDocto').val('');
    } else {
      $('#txtListaDocto').val(`${listaDoctos},${documento}`);
      $('#txtDocto').val('');
    }
    $('#txtDocto').focus();
  });

  $('#txtDocto').on("focus", function () {
    let that = $(this);
    setTimeout(function () {
      that.select();
    }, 1);
  }).on('keydown', function (e) {
    if ((e.key == 'Tab') || (e.key == 'Enter')) {
      e.preventDefault();
      $('#txtDataDe').focus();
      $('#txtDataDe').click();
    }
  });

  async function retornaFiltros() {

    const tipoMov = $('#radioEntrada').is(':checked') ? 'E' : $('#radioSaida').is(':checked') ? 'S' : '';
    const codigo = await formataListas($('#txtProduto').val().toString());
    const cor = await formataListas($('#txtCor').val().toString());
    const tamanho = await formataListas($('#txtTamanho').val().toString());
    let deposito = await formataListas($('#txtDepositoUsuario').val().toString());
    if (deposito == '') {
      deposito = filtroDeposito;
    }
    // deposito = deposito != ''
    //   ? deposito : filtroDeposito.replaceAll('["CODIGO IN (', '').replaceAll(')"]', '') != 'null'
    //     ? filtroDeposito.replaceAll('["CODIGO IN (', '').replaceAll(')"]', '')
    //     : '';
    const tpbai = await formataListas($('#txtTipoMov').val().toString());
    const qualidade = await formataListas($('#txtQualidade').val().toString());
    const grupo = await formataListas($('#txtGrupo').val().toString());
    const etiqueta = await formataListas($('#txtEtiqueta').val().toString());
    const linha = await formataListas($('#txtLinha').val().toString());
    const colecao = await formataListas($('#txtColecao').val().toString());
    const marca = await formataListas($('#txtMarca').val().toString());
    const modelo = await formataListas($('#txtModelo').val().toString());
    const obs = $('#txtObs').val();
    const dataDe = $('#txtDataDe').val();
    const dataAte = $('#txtDataAte').val();
    const doctos = $('#txtListaDocto').val() != '' ? `'${$('#txtListaDocto').val().replaceAll(',', "','")}'` : '';

    const retorno = `CODIGO=${codigo}` +
      `&COLECAO=${colecao}` +
      `&DEPOSITO=${deposito}` +
      `&COR=${cor}` +
      `&TAMANHO=${tamanho}` +
      `&QUALIDADE=${qualidade}` +
      `&TIPOMOV=${tipoMov}` +
      `&OBS=${obs}` +
      `&DOCTO=${doctos}` +
      `&DATADE=${dataDe}` +
      `&DATAATE=${dataAte}` +
      `&ETIQUETA=${etiqueta}` +
      `&TPBAI=${tpbai}` +
      `&GRUPO=${grupo}` +
      `&LINHA=${linha}` +
      `&MARCA=${marca}` +
      `&MODELO=${modelo}`;
    return retorno;
  };

  limparFiltros(true);

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        if ($('#tabelaRelMovimentacao').DataTable().rows().count() != 0) {
          const url = `/sisplan/impressao/v1/movestoque?`;
          const filtros = await retornaFiltros();
          const ordem = `&TELA_ORDENACAO=RelMovimentacaoDeEstoque&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
          const bImprimeAutomatico = await verificaImprimirAutomatico('RelMovimentacaoDeEstoque');
          const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 100000, false, 'RelMovimentacaoDeEstoque');
          if (arquivo != undefined) {
            if (!bImprimeAutomatico) {
              window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
            }
            await limparRelatorios();
          }
        } else {
          msgAlerta('Não há itens para imprimir!');
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {

        let dataSetCols = [];
        const url = '/sisplan/impressao/v1/consultamovestoque?';
        const filtros = await retornaFiltros();
        const response = await requisicao('GET', url, filtros, 30000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          msgAlerta('Nenhum registro encontrado!');
          if ($.fn.DataTable.isDataTable('#tabelaRelMovimentacao')) {
            $('#tabelaRelMovimentacao').DataTable().clear().draw(false);
            return;
          }
        }

        if (response.status != 200) {
          console.error(jsonStr.mensagem);
          return;
        }

        let keys = Object.keys(jsonStr[0]);

        keys.forEach(k => {
          dataSetCols.push({
            'title': k,
            'data': k
          });
        });

        $('#tabelaRelMovimentacao').DataTable({
          destroy: true,
          filter: false,
          language: {
            sEmptyTable: 'Nenhum registro encontrado',
            sInfo: '_TOTAL_ registros',
            sInfoEmpty: ' 0 registros',
            sInfoFiltered: '(Filtrados de _MAX_ registros)',
            sInfoPostFix: '',
            sInfoThousands: '.',
            sLengthMenu: '_MENU_ resultados',
            sLoadingRecords: 'Carregando...',
            sProcessing: 'Processando...',
            sZeroRecords: 'Nenhum registro encontrado',
            sSearch: 'Pesquisar',
            oPaginate: {
              sNext: 'Próximo',
              sPrevious: 'Anterior',
              sFirst: 'Primeiro',
              sLast: 'Último',
            },
            oAria: {
              sSortAscending: ': Ordenar colunas de forma ascendente',
              sSortDescending: ': Ordenar colunas de forma descendente',
            },
          },
          autoWidth: true,
          "colReorder": true,
          "data": jsonStr,
          "columns": dataSetCols,
          "columnDefs": {
            targets: colunas.relatorioMovimentacao ?? [],
            visible: false,
          }
        });

        $('#tabelaRelMovimentacao_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaRelMovimentacao_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
        $('#buttonExcel').prop('title', 'Exportar')

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        });

        $('#buttonExcel').on('click', async function () {
          const url = '/sisplan/impressao/v1/consultamovestoque?';
          const filtros = await retornaFiltros();
          await exportaCSV(url, filtros, false, null, 'Relatório de Movimentação de Estoque', '#tabelaRelMovimentacao');
        })

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $('#tabelaRelMovimentacao').DataTable().columns().every(
          function () {
            if ((colunasInvisiveis.relatorioMovimentacao).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaRelMovimentacao').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.relatorioMovimentacao ?? [])
  })
});