$(document).ready(async function () {

  let options = {
    series: [{
      name: "Cobertura",
      data: [{}]
    }],
    chart: {
      type: 'bar',
      height: 300
    },
    tooltip: {
      x: {
        formatter: function (val) {
          return val;
        }
      }
    },
    xaxis: {
      type: 'category',
      labels: {
        formatter: function (val) {
          return '';
        }
      }
    },
    title: {
      text: 'Top 15 grupos com maior cobertura de estoque',
    },
    fill: {
      colors: ['#75BE25']
    }
  };

  let options2 = {
    series: [{
      name: "Percentual",
      data: [{}]
    }],
    chart: {
      type: 'bar',
      height: 300
    },
    plotOptions: {
      bar: {
        colors: {
          ranges: [{
            from: -100,
            to: -46,
            color: '#F15B46'
          }, {
            from: -45,
            to: 0,
            color: '#FEB019'
          }]
        },
        columnWidth: '80%',
      }
    },
    tooltip: {
      x: {
        formatter: function (val) {
          return val;
        }
      }
    },
    xaxis: {
      type: 'category',
      labels: {
        formatter: function (val) {
          return '';
        }
      }
    },
    title: {
      text: 'Top 15 grupos com maior necessidade de compra',
    },
  };

  let listaOrdenacao = [];
  let controleColunas;
  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  // aqui so valida se nao existe tem que criar para nao dar erro
  if (colunas == null || colunas.coberturaEstoqueGrupo == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, coberturaEstoqueGrupo: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.coberturaEstoqueEtiqueta == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, coberturaEstoqueEtiqueta: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.coberturaEstoqueLinha == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, coberturaEstoqueLinha: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();

      if (controleColunas == 'grupo') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, coberturaEstoqueGrupo: novasColunas }))

        $('#tabelaRelCoberturaEstoque').DataTable().columns().visible(true);
        // $('#tabelaRelCoberturaEstoque').DataTable().columns(novasColunas).visible(false);

        $('#tabelaRelCoberturaEstoque').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          }
        );
      } else if (controleColunas == 'etiqueta') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, coberturaEstoqueEtiqueta: novasColunas }))

        $('#tabelaRelCoberturaEstoque').DataTable().columns().visible(true);
        // $('#tabelaRelCoberturaEstoque').DataTable().columns(novasColunas).visible(false);

        $('#tabelaRelCoberturaEstoque').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          }
        );
      } else {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, coberturaEstoqueLinha: novasColunas }))

        $('#tabelaRelCoberturaEstoque').DataTable().columns().visible(true);
        // $('#tabelaRelCoberturaEstoque').DataTable().columns(novasColunas).visible(false);

        $('#tabelaRelCoberturaEstoque').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          }
        );
      }

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  await preencheOrdenacaoTela('CoberturaEstoqueGrupo');

  $('#checkGrupo').on('change', async function () {
    $('#txtOrdem').empty();
    if ($('#checkGrupo').prop('checked')) {
      await preencheOrdenacaoTela('CoberturaEstoqueGrupo');
    } else {
      await preencheOrdenacaoTela('CoberturaEstoque');
    }
  });

  adicionarConteudoModal(
    'Cobertura de Estoque', [
    {
      tipo: 'paragrafo',
      valor: 'Quando tratamos de Cobertura, falamos em MESES.'
    },
    {
      tipo: 'paragrafo',
      valor: 'Este relatório é essencial para a gestão, para garantir que se tenha um mix e quantidades saudáveis em estoque, sem inchar e sem faltar. ' +
        'A base de cálculo é uma cobertura de 2,5 (meses). Isto significa que em relação ao volume de vendas do período dos últimos 30 dias do ano anterior,  ' +
        'é necessário ter 2x e meia esse volume em estoque. O relatório ainda apresenta um PLUS na visão, que gera todas as demandas de Compras e/ou Produção ' +
        'perante o histórico de venda do cliente.',
    },
    {
      tipo: 'paragrafo',
      valor: 'Importante frisar 4 pontos:'
    },
    {
      tipo: 'lista',
      itens: [
        'Cobertura de Estoque sempre se analisa por Grupo, Linha ou Etiqueta(Gênero).',
        'Este relatório não abre por referência pois poderá resultar distorção nas referências do ano anterior contra o ano atual.',
        'Cobertura abaixo de 1,8 significa "Atenção" em relação a demanda de Compra e/ou Produção.',
        'Cobertura alta, acima de 3 significa "Atenção", pois o estoque está inchado/alto.'
      ]
    },
  ]
  );

  const filtroDeposito = await buscaDepositoEmpresaUsuario();

  componenteFiltro('grupo', true);
  componenteFiltro('linha', true);
  componenteFiltro('etiqueta', true);
  componenteFiltro('produto', true);
  componenteFiltro('colecao', true);
  componenteFiltro('modelo', true);
  componenteFiltro('depositoUsuario', true);

  $('#btnLimparFiltros').on('click', function () {
    $('#txtProduto').empty().trigger('change');
    $('#txtColecao').empty().trigger('change');
    $('#txtModelo').empty().trigger('change');
    $('#txtGrupo').empty().trigger('change');
    $('#txtEtiqueta').empty().trigger('change');
    $('#txtLinha').empty().trigger('change');
    $('#cbCobertura').val('2,50');
    $('#selectGrupo').val('GRUPO');
    $('#txtOrdem').val('0');
  });

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = '/sisplan/impressao/v1/coberturaestoque?';
        const filtros = await retornaFiltros();

        if (filtros.venda_de == '') {
          msgAlerta('Data não informada ou inválida');
          return;
        }

        const params = `
        &GRUPO=${filtros.grupo}
        &ETIQUETA=${filtros.etiqueta}
        &LINHA=${filtros.linha}
        &COLECAO=${filtros.colecao}
        &MODELO=${filtros.modelo}
        &EMPRESAS_FILTRO=${filtros.empresas}
        &CODIGO=${filtros.codigo}
        &ORDERBY=${filtros.orderby}
        &OPCAORELATORIO=${$('#txtOrdem').val()}
        &COBERTURA_POR=${filtros.filtro_por}
        &COBERTURA=${filtros.cobertura}
        &EMITIDO=${filtros.emitido}
        &PENDENTE=${filtros.pendente}
        &AGRUPADO=${filtros.agrupado}
        &DEVOLVIDO=${filtros.devolvido}
        &CANCELADO=${filtros.cancelado}
        &DEPOSITO=${filtros.deposito}`;

        let arquivo = await GeraRelatorio(`${url + params}&`, 'POST', 100000, false);
        if (arquivo != undefined) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function retornaFiltros() {
    let dep = await formataListas($('#txtDepositoUsuario').val().toString());

    if (dep == '') {
        dep = filtroDeposito;
    }

    const filtros = {
      colecao: await formataListas($('#txtColecao').val().toString()),
      etiqueta: await formataListas($('#txtEtiqueta').val().toString()),
      grupo: await formataListas($('#txtGrupo').val().toString()),
      linha: await formataListas($('#txtLinha').val().toString()),
      codigo: await formataListas($('#txtProduto').val().toString()),
      modelo: await formataListas($('#txtModelo').val().toString()),
      deposito: dep,
      empresas: $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
        : [getCookie('emp_id')],
      cobertura: $('#cbCobertura').val(),
      filtro_por: $('#selectGrupo').val(),
      emitido: $('#cbEmitido').prop('checked'),
      pendente: $('#cbPendente').prop('checked'),
      agrupado: $('#cbAgrupado').prop('checked'),
      devolvido: $('#cbDevolvido').prop('checked'),
      cancelado: $('#cbCancelado').prop('checked'),
      orderby: listaOrdenacao
    }
    return filtros
  };

  function adicionaFiltrosCard(data) {
    let card = '<div class="form-row col-12">';
    if (data.codigo != '') {
      card += `<h6 class="ml-3"><b><u>Produto:</u></b>
        ${data.codigo}
        </h6>`
    }
    if (data.grupo != '') {
      card += `<h6 class="ml-3"><b><u>Grupo:</u></b>
      ${data.grupo}
      </h6>`
    }
    if (data.colecao != '') {
      card += `<h6 class="ml-3"><b><u>Coleção:</u></b>
      ${data.colecao}
      </h6>`
    }
    if (data.etiqueta != '') {
      card += `<h6 class="ml-3"><b><u>Etiqueta:</u></b>
      ${data.etiqueta}
      </h6>`
    }
    if (data.linha != '') {
      card += `<h6 class="ml-3"><b><u>Linha:</u></b>
      ${data.linha}
      </h6>`
    }
    card += `</div>`;
    if (data.codigo != '' || data.grupo != '' || data.colecao != '' || data.etiqueta != '' || data.linha != '') {
      $('#card-filtros').append(card);
      $('#card-invisivel').removeClass('d-none');
    }
  }

  function retornaDescricoesFiltros() {
    const v = {
      codigo: pegaDescricao('#txtCodigo'),
      grupo: pegaDescricao('#txtGrupo'),
      colecao: pegaDescricao('#txtColecao'),
      etiqueta: pegaDescricao('#txtEtiqueta'),
      linha: pegaDescricao('#txtLinha')
    }

    return v;
  }

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {

        if ($.fn.DataTable.isDataTable('#tabelaRelCoberturaEstoque')) {
          $('#tabelaRelCoberturaEstoque').DataTable().destroy();
          $('#tabelaRelCoberturaEstoque').empty();
        };

        let colunasAlinharDireita = [];
        let dataSetCols = [];
        const url = '/sisplan/impressao/v1/coberturaestoque?';
        const filtros = await retornaFiltros();
        if (filtros.venda_de == '') {
          msgAlerta('Data não informada ou inválida');
          return;
        }

        $('#card-filtros').empty();
        $('#card-invisivel').addClass('d-none');

        // SELL IN+ESTOQUE / VENDAS.
        const params = `GRUPO=${filtros.grupo}&ETIQUETA=${filtros.etiqueta}&LINHA=${filtros.linha}&COLECAO=${filtros.colecao}&MODELO=${filtros.modelo}
                        &EMPRESAS_FILTRO=${filtros.empresas}&CODIGO=${filtros.codigo}&COBERTURA=${filtros.cobertura}&COBERTURA_POR=${filtros.filtro_por}
                        &EMITIDO=${filtros.emitido}&PENDENTE=${filtros.pendente}&AGRUPADO=${filtros.agrupado}&DEVOLVIDO=${filtros.devolvido}&CANCELADO=${filtros.cancelado}
                        &DEPOSITO=${filtros.deposito}`;
        const response = await requisicao('GET', url, params, 60000);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (jsonStr.length == 0) {
          msgAlerta('Nenhum registro encontrado!');
          return;
        }

        if (response.status != 200) {
          console.error(jsonStr.mensagem);
          return;
        }
        if ($('#checkGrupo').prop('checked')) {
          const descricoes = retornaDescricoesFiltros();
          adicionaFiltrosCard(descricoes);
        }

        const keys = jsonStr.map((key) => {
          return { ...key, NECESSIDADE_COMPRA: `<b>${key.NECESSIDADE_COMPRA}</b>`, COBERTURA: `<b>${(TruncaDecimaisNova(2, key.COBERTURA)).toFixed(2)}</b>` }
        })

        Object.keys(jsonStr[0]).forEach(k => {
          k = { data: k, title: k }

          switch (k.data) {
            case 'QUANTIDADE_VENDIDA':
              k.title = 'VENDAS'
              break;
            case 'NECESSIDADE_COMPRA':
              k.title = 'NECESSIDADE COMPRA'
              break;
            case 'ESTOQUE_ATUAL':
              k.title = 'ESTOQUE ATUAL'
              break;
            default:
              break;
          }

          // if (k.data != 'EMP_ID' && k.data != 'SELL_IN' && k.data != 'ESTOQUE_SELL_IN') {
          dataSetCols.push({
            'title': k.title,
            'data': k.data
          });
          // }
        });

        if ($.fn.DataTable.isDataTable('#tabelaRelCoberturaEstoque')) {
          $('#tabelaRelCoberturaEstoque').DataTable().destroy();
          $('#tabelaRelCoberturaEstoque').empty();
        };

        colunasAlinharDireita = [1, 2, 3, 4];

        $('#tabelaRelCoberturaEstoque').DataTable({
          destroy: true,
          language: {
            sEmptyTable: 'Nenhum registro encontrado',
            sInfo: '_TOTAL_ registros',
            sInfoEmpty: ' 0 registros',
            sInfoFiltered: '(Filtrados de _MAX_ registros)',
            sInfoPostFix: '',
            sInfoThousands: '.',
            sLengthMenu: '_MENU_ resultados',
            sLoadingRecords: 'Carregando...',
            sProcessing: 'Processando...',
            sZeroRecords: 'Nenhum registro encontrado',
            sSearch: 'Pesquisar',
            oPaginate: {
              sNext: 'Próximo',
              sPrevious: 'Anterior',
              sFirst: 'Primeiro',
              sLast: 'Último',
            },
            oAria: {
              sSortAscending: ': Ordenar colunas de forma ascendente',
              sSortDescending: ': Ordenar colunas de forma descendente',
            },
          },
          "colReorder": true,
          "data": keys,
          "columns": dataSetCols,
          "columnDefs": [
            {
              targets: colunasAlinharDireita,
              className: "text-right"
            }
          ],
        });

        if ($('#selectGrupo').val() == 'GRUPO') {
          controleColunas = 'grupo'
        } else if ($('#selectGrupo').val() == 'ETIQUETA') {
          controleColunas = 'etiqueta'
        } else {
          controleColunas = 'linha'
        }

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        $($('#tabelaRelCoberturaEstoque').find('th')[3]).prop('title', 'Cobertura Ideal é de 2,5.')
        $($('#tabelaRelCoberturaEstoque').find('th')[4]).prop('title', 'Necessidade de Compra para chegar na Cobertura Ideal. Caso houver pedidos em carteira (pendentes) deverá descontar manualmente.')

        // adiciona o botão na tabela e adiciona a função de abrir o modal
        $('#tabelaRelCoberturaEstoque_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
        $('#tabelaRelCoberturaEstoque_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

        $('#buttonColVis').on('click', async function () {
          $.LoadingOverlay('show');
          $('#modal-ColunasVisiveis').modal('show');
          $.LoadingOverlay('hide');
        })

        $('#buttonExcel').on('click', async function () {
          const url = '/sisplan/impressao/v1/coberturaestoque?';
          const filtros = await retornaFiltros();
          if (filtros.venda_de == '') {
            msgAlerta('Data não informada ou inválida');
            return;
          }
          const formataCampos = montaComandosCampos();
          const params = `GRUPO=${filtros.grupo}&ETIQUETA=${filtros.etiqueta}&LINHA=${filtros.linha}&COLECAO=${filtros.colecao}&MODELO=${filtros.modelo}
                          &EMPRESAS_FILTRO=${filtros.empresas}&CODIGO=${filtros.codigo}&COBERTURA=${filtros.cobertura}&COBERTURA_POR=${filtros.filtro_por}
                          &EMITIDO=${filtros.emitido}&PENDENTE=${filtros.pendente}&AGRUPADO=${filtros.agrupado}&DEVOLVIDO=${filtros.devolvido}&CANCELADO=${filtros.cancelado}
                          &ORDERBY=${filtros.orderby}&DEPOSITO=${filtros.deposito}`;
          await exportaCSV(url, params, false, null, 'Relatório de Cobertura de Estoque', '#tabelaRelCoberturaEstoque', formataCampos);
        })

        $('#buttonColVis').prop('title', 'Configurar colunas')
        $('#buttonExcel').prop('title', 'Exportar CSV')

        if (controleColunas == 'grupo') {
          $('#tabelaRelCoberturaEstoque').DataTable().columns().every(
            function () {
              if ((colunasInvisiveis.coberturaEstoqueGrupo).indexOf(this.dataSrc()) != -1) {
                this.visible(false);
              }
            }
          )
        } else if (controleColunas == 'etiqueta') {
          $('#tabelaRelCoberturaEstoque').DataTable().columns().every(
            function () {
              if ((colunasInvisiveis.coberturaEstoqueEtiqueta).indexOf(this.dataSrc()) != -1) {
                this.visible(false);
              }
            }
          )
        } else {
          $('#tabelaRelCoberturaEstoque').DataTable().columns().every(
            function () {
              if ((colunasInvisiveis.coberturaEstoqueLinha).indexOf(this.dataSrc()) != -1) {
                this.visible(false);
              }
            }
          )
        }

        $('#tabelaRelCoberturaEstoque th').on('click', function () {
          listaOrdenacao = adicionaOrdenacao(
            retornaDataSrcColuna($('#tabelaRelCoberturaEstoque'), $(this)),
            listaOrdenacao
          );
        });

        $('#chart1').empty();
        $('#chart2').empty();

        keys.sort(function (a, b) {
          if (parseFloat(a.COBERTURA.replace('<b>', '').replace('</b>', '')) < parseFloat(b.COBERTURA.replace('<b>', '').replace('</b>', ''))) {
            return 1;
          } else if (parseFloat(a.COBERTURA.replace('<b>', '').replace('</b>', '')) > parseFloat(b.COBERTURA.replace('<b>', '').replace('</b>', ''))) {
            return -1;
          } else {
            return 0;
          }
        });

        let arrDadosGrafico = [];
        keys.map((item, index) => {
          if (index < 15) {
            arrDadosGrafico.push({
              x: item[$('#selectGrupo').val()],
              y: parseFloat(item.COBERTURA.replace('<b>', '').replace('</b>', ''))
            });
          }
        });

        options.series[0].data = arrDadosGrafico;
        const chart = new ApexCharts(document.querySelector("#chart1"), options);
        chart.render();

        keys.sort(function (a, b) {
          if (parseFloat(a.NECESSIDADE_COMPRA.replace('<b>', '').replace('</b>', '')) < parseFloat(b.NECESSIDADE_COMPRA.replace('<b>', '').replace('</b>', ''))) {
            return 1;
          } else if (parseFloat(a.NECESSIDADE_COMPRA.replace('<b>', '').replace('</b>', '')) > parseFloat(b.NECESSIDADE_COMPRA.replace('<b>', '').replace('</b>', ''))) {
            return -1;
          } else {
            return 0;
          }
        });

        let arrDadosGrafico2 = [];
        keys.map((item, index) => {
          if (index < 15) {
            arrDadosGrafico2.push({
              x: item[$('#selectGrupo').val()],
              y: parseFloat(item.NECESSIDADE_COMPRA.replace('<b>', '').replace('</b>', ''))
            });
          }
        });

        options2.series[0].data = arrDadosGrafico2;
        const chart2 = new ApexCharts(document.querySelector("#chart2"), options2);
        chart2.render();


        // $('#tabelaRelCoberturaEstoque').DataTable().columns(colunasInvisiveis.coberturaEstoque ?? []).visible(false);
        // adicionaColunas(dataSetCols, colunasInvisiveis.coberturaEstoque ?? [])
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  function montaComandosCampos() {
    let retorno;
    retorno = 'dados = dados.map((key) => { \n' +
      `let v1 = key.COBERTURA 
      if (typeof v1 == 'string') {
      v1 = parseFloat(v1.replace(".", "").replace(",", ".")).toFixed(2)
      } else {
      v1 = parseFloat(v1).toFixed(2) } ` +
      'return {...key, COBERTURA: v1 } \n' +
      '}) \n';

    return retorno
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    if (controleColunas == 'grupo') {
      $('#tabelaRelCoberturaEstoque').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.coberturaEstoqueGrupo ?? []);
    } else if (controleColunas == 'etiqueta') {
      $('#tabelaRelCoberturaEstoque').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.coberturaEstoqueEtiqueta ?? []);
    } else {
      $('#tabelaRelCoberturaEstoque').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text(),
          'data': this.dataSrc()
        })
      });
      adicionaColunas(cols, colunasInvisiveis.coberturaEstoqueLinha ?? []);
    }
  })

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });

  $('#tutorial').on('click', function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Botão Filtros',
        description: 'Clique aqui para abrir os filtros padrões da tela.',
        position: 'right'
      }
    },
    {
      element: '#btnImprimir',
      popover: {
        title: 'Botão Imprimir',
        description: 'Clique aqui para Imprimir um relatório.',
        position: 'right'
      }
    },
    {
      element: '#tabelaRelCoberturaEstoque',
      popover: {
        title: 'Tabela',
        description: 'Aqui estão os dados dos produtos Filtrados.',
        position: 'top'
      }
    }
    ]);
    driver.start();
  });
});