$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("REGRA_PROMOCAO");

  $('#txtRegra').autocompleta(1, `JSON={ "tabela":"REGRA_PROMOCAO", "camposSelect":[ "REGRA chave", "DESC_REGRA descricao"], "where": null, "groupby": ["REGRA", "DESC_REGRA"]}`);
  $('#btnRegra').pesquisa('#txtRegra', 'REGRA', 'DESC_REGRA', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REGRA_PROMOCAO", "camposSelect":[ "REGRA", "DESC_REGRA"], "groupby": ["REGRA", "DESC_REGRA"]}`, 'Pesquisa Regra', 'regra_promocao');
  $('#btnARegra').on('click', function () {
    $('#txtRegra').val('');
  });


  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item btn-editar" type="button" title="Editar">Editar</button>     ' +
      '    <button class="dropdown-item btn-excluir" type="button" title="Excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        let url = '/sisplan/funcoes/v1/pesquisa?';
        let regra = pegaChave('#txtRegra') != '' ? `REGRA = '${pegaChave('#txtRegra')}'` : '';
        let params = `JSON={ "tabela": "REGRA_PROMOCAO", "camposSelect": ["REGRA", "DESC_REGRA"], "where": ["1=1", "${regra}"], "groupby": ["REGRA", "DESC_REGRA"]}`;
        let dataSetCols = [];

        let response = await requisicao('GET', url, params);

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          console.log(jsonStr.RESULT[0].mensagem);
          return;
        }

        if (jsonStr.RESULT[0].length <= 0) {
          return;
        }

        let keys = Object.keys(jsonStr.RESULT[0][0]);

        keys.forEach(k => {
          dataSetCols.push({
            'title': k,
            'data': k,
          });
        });

        $('#tabelaRegras').DataTable({
          paging: false,
          filter: true,
          scrollY: '410px',
          info: true,
          order: true,
          destroy: true,
          "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
              "sNext": "Próximo",
              "sPrevious": "Anterior",
              "sFirst": "Primeiro",
              "sLast": "Último"
            },
            "oAria": {
              "sSortAscending": ": Ordenar colunas de forma ascendente",
              "sSortDescending": ": Ordenar colunas de forma descendente"
            }
          },
          "data": jsonStr.RESULT[0],
          "columns": dataSetCols,
          "columnDefs": [{
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          }]
        });

        $('.btn-editar').on('click', async function () {
          try {
            if (permissaoUsuarioLogado.ALTERA == 'S') {
              let data = $('#tabelaRegras').DataTable().row($(this).parents('tr')).data();
              window.location.href = `regrapromocao/${data.REGRA}`;
            } else {
              msgAlertaSemConfirmacao("Sem permissão para alterar!");
            }
          } catch (error) {
            console.error();
          }
        });

        $('#tabelaRegras').on('dblclick', 'tr', async function () {
          try {
            if (permissaoUsuarioLogado.ALTERA == 'S') {
              let data = $('#tabelaRegras').DataTable().row($(this)).data();
              window.location.href = `regrapromocao/${data.REGRA}`;
            } else {
              msgAlertaSemConfirmacao("Sem permissão para alterar!");
            }
          } catch (error) {
            console.error();
          }
        });

        $('.btn-excluir').on('click', async function () {
          if (permissaoUsuarioLogado.EXCLUI == 'S') {
            var data = $('#tabelaRegras').DataTable().row($(this).parents('tr')).data();
            msgAlerta('Deseja realmente excluir essa regra?', deletaRegra);
          } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
          }

          async function deletaRegra() {
            try {
              $.LoadingOverlay('show');
              try {
                url = '/sisplan/cadastros/v1/regrapromocao?';
                params = `REGRA=${data.REGRA}`;

                response = await requisicao('DELETE', url, params);

                if (!response) {
                  return;
                }

                if (response.status === 200) {

                  toastr.success(
                    'Regra excluída com sucesso!',
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                      error: 'alert-error',
                      info: 'alert-info',
                      success: 'alert-success',
                      warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                      window.location.href = `${BASE_URI}/regrapromocao`;
                    }
                  }
                  ).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px"
                  });
                } else {
                  jsonStr = await response.json();
                  msgErro(jsonStr.mensagem);
                }

              } catch (error) {
                console.error(error);
              }
            } finally {
              $.LoadingOverlay('hide');
            }
          }

        });

      } catch (error) {
        console.error(error);
      }

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  });

  $('#btnNovaRegraPromocao').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "regrapromocao/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnConsultar').trigger('click');

});