<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Cadastro de Tabela de Preço</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.237.18.2">
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.237.18.2">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.237.18.2" />
  <link href='../dist/css/bootstrap.min.css?versao=3.237.18.2'>
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.237.18.2">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.237.18.2">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.237.18.2">
  <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.237.18.2">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.237.18.2">

  <!-- Toastr -->
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.237.18.2">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.237.18.2" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.237.18.2">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <style>
    #progressbar li {
      list-style-type: none;
      font-size: 12px;
      width: 50%;
      float: left;
      position: relative
    }

    .labelCheck {
      /* border-bottom: outset 2px;
            border-left: outset 2px; */
      padding: 0.2%;
      margin-left: 1%;
    }

    .configCheck {
      -ms-transform: scale(1.5);
      -moz-transform: scale(1.5);
      -webkit-transform: scale(1.5);
      -o-transform: scale(1.5);
      transform: scale(1.5);
      padding: 10px;
    }

    .radioTop {
      margin-left: 2%;
      margin-top: 2%;
      padding-left: 1%;
      padding-top: 1%;
      padding-right: 1%;
      padding-bottom: 0%;
    }

    .radiosStyle {
      margin-top: 0%;
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      margin-left: 0%;
    }

    .checkboxPreco {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding-top: 3.9%;
      padding-bottom: 2.3%;
    }

    #txtTipoTabela {
      size: 120%;
    }

    .bordaTab {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 1px;
      margin-top: 28px;
      padding-top: 6px;
    }

    .configTabPreco {
      -ms-transform: scale(1.5);
      -moz-transform: scale(1.5);
      -webkit-transform: scale(1.5);
      -o-transform: scale(1.5);
      transform: scale(1.5);
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid #fff !important;
      padding: 0 1.0em 0 1.0em !important;
      margin: 0 0 0 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../../menu.php');
    ?>
    <div id="myModal" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 id="myModalLabel" class="modal-title"></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <p id="myModalText"></p>
          </div>
          <div class="modal-footer">
            <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
            <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
          </div>
        </div>
      </div>
    </div>
    <div class="content-wrapper">
      <section class="content">
        <div class="content-header">
          <div class="container-fluid">
            <div class="row mb-2">
              <div class="col-sm-6 flex">
              </div>
              <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                  <li class="breadcrumb-item"><a href="./index">Início</a></li>
                  <li class="breadcrumb-item"><a href="../tabeladepreco">Acesso Tabela de Preço</a></li>
                  <li class="breadcrumb-item active">Cadastro de Tabela de Preço</li>
                </ol>
              </div><!-- /.col -->
            </div><!-- /.row -->
          </div>
          <div class="row justify-content-center">
            <div class="col-10 text-center">
              <div class="card">
                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                  <h2>Cadastro de Tabela de Preço
                    <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                      <i class="fas fa-question-circle"></i>
                    </button>
                  </h2>
                </div>
                <div class="row">
                  <div class="col-md-12 mx-0">
                    <form class="mt-0" id="msform" name="msform">
                      <!-- progressbar -->
                      <ul id="progressbar">
                        <li class="active" id="account"><strong>Geral</strong></li>
                        <li id="payment"><strong>Configuração</strong></li>
                      </ul> <!-- fieldsets -->
                      <p>Preencha os dados e clique em avançar para realizar o cadastro da tabela de preço</p>
                      <fieldset>
                        <div class="form-card mb-0" id="formcard1">
                          <h2 class="fs-title">Dados Gerais</h2>
                          <div class="row">
                            <div class="col-lg-2  col-12 form-group" id="codigotuto">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo">Código
                                *</label>
                              <div class="input-group">
                                <input type="text" readonly class="input-default focus form-control" required aria-describedby="codigoError" id="txtCodigo" name="txtCodigo" class="form-control" placeholder="Campo preenchido automaticamente">
                              </div>
                            </div>
                            <div class="col-lg-8 col-12 form-group" id="desctuto">
                              <label data-error="wrong" data-success="right" class="labelGeral" for="txtRegiao">Descrição*</label>
                              <input type="text" class="input-default focus form-control" required aria-describedby="descError" id="txtRegiao" name="txtRegiao" class="form-control" placeholder="Descrição">
                            </div>
                            <div class="bordaTab col-lg-2 col-12 form-group">
                              <label class="labelTabPreco mb-0 labelCheck" for="checkPadrao">   <input type="checkbox" class="configTabPreco" id="checkPadrao">     Padrão</label>
                            </div>
                            <div class="col-lg-4  col-12 form-group" id="tipotabelatuto">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtTipoTabela">Tipo
                                da tabela *</label>
                              <div class="input-group">
                                <select class="input-default focus form-control" required aria-describedby="tipoError" data-dropdown-css-class="select2-danger" id="txtTipoTabela" class="custom-select focus">
                                  <option value="">Informe o tipo</option>
                                  <option value="0">C</option>
                                  <option value="1">V</option>
                                </select>
                              </div>
                            </div>
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtOrdem">Ordem</label>
                              <div class="input-group">
                                <input type="number" class="input-default focus form-control" id="txtOrdem" name="txtOrdem" class="form-control" placeholder="Ordem">
                              </div>
                            </div>
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCom1">Comissão
                                1</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCom1" name="txtCom1" class="form-control" placeholder="Comissão 1">
                              </div>
                            </div>
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCom2">Comissão
                                2</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtCom2" name="txtCom2" class="form-control" placeholder="Comissão 2">
                              </div>
                            </div>
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtIndice">Índice</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtIndice" name="txtIndice" class="form-control" placeholder="Índice">
                              </div>
                            </div>
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtPerc">Percentual</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtPerc" name="txtPerc" class="form-control" placeholder="Percentual">
                              </div>
                            </div>
                            <div class="col-lg-12  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtObs">Observação</label>
                              <div class="input-group">
                                <input type="text" class="input-default focus form-control" id="txtObs" name="txtObs" class="form-control" placeholder="Observação">
                              </div>
                            </div>
                          </div>
                        </div>
                        <input type="button" name="next" class="btn-sisp next action-button" value="Avançar" id="avancar1" />
                        <button type="button" id="btnVoltar" style="font-size:15px;" class="btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                      </fieldset>



                      <fieldset id="segundo">
                        <div class="form-card pb-0 mb-0">


                          <h2 class="fs-title">Configurações</h2>
                          <div class="row">
                            <div class="col-lg-12  col-12" id="checkTour">




                              <div class="col-12 col-xl-12 form" id="opcoes">
                                <fieldset class="form border-Field mb-0 pb-0">
                                  <legend class="textoBorda mb-0 pb-0">Opções</legend>
                                  <div class="form-row">
                                    <div class="ml-2">
                                      <label class="" for="checkLiberado">   <input type="checkbox" class="" id="checkLiberado" checked>     Liberado</label>
                                    </div>
                                    <div class="ml-3">
                                      <label class="" for="checkPadProd">   <input type="checkbox" class="" id="checkPadProd">     Tabela Padrão Produção</label>
                                    </div>
                                    <div class="ml-3">
                                      <label class="" for="checkPadAta">   <input type="checkbox" class="" id="checkPadAta">     Tabela Padrão Atacado</label>
                                    </div>
                                    <div class="ml-3">
                                      <label class="" for="checkPadVar">   <input type="checkbox" class="" id="checkPadVar">     Tabela Padrão Varejo</label>
                                    </div>
                                  </div>
                                </fieldset>
                              </div>

                              <div class="col-12 col-xl-12 form mt-4" id="tipo">
                                <fieldset class="form border-Field mb-0 pb-0">
                                  <legend class="textoBorda mb-0 pb-0">Tipo</legend>
                                  <div class="form-row">

                                    <label class="ml-2">
                                      <input type="radio" required aria-describedby="checkError" id="inputTerceiro" name="tipo">
                                      <label for="inputTerceiro" class="mb-0 pb-0">   Terceiro</label>
                                      <span class="checkmark"></span>
                                    </label>
                                    <br>
                                    <label class="ml-4">
                                      <input type="radio" required aria-describedby="checkError" id="inputLoja" name="tipo">
                                      <label for="inputLoja" class="mb-0 pb-0">   Loja</label>
                                      <span class="checkmark"></span>
                                    </label>
                                    <br>
                                    <label class="ml-4">
                                      <input type="radio" required aria-describedby="checkError" id="inputVarejo" name="tipo" checked>
                                      <label for="inputVarejo" class="mb-0 pb-0">   Varejo</label>
                                      <span class="checkmark"></span>
                                    </label>
                                    <br>
                                    <label class="ml-4">
                                      <input type="radio" required aria-describedby="checkError" id="inputComercial" name="tipo">
                                      <label for="inputComercial" class="mb-0 pb-0">   Comercial</label>
                                      <span class="checkmark"></span>
                                    </label>
                                    <br>
                                    <label class="ml-4">
                                      <input type="radio" required aria-describedby="checkError" id="inputAtacado" name="tipo">
                                      <label for="inputAtacado" class="mb-0 pb-0">   Atacado</label>
                                      <span class="checkmark"></span>
                                    </label>
                                    <br>
                                    <label class="ml-4">
                                      <input type="radio" required aria-describedby="checkError" id="inputMostruario" name="tipo">
                                      <label for="inputMostruario" class="mb-0 pb-0">   Mostruário</label>
                                      <span class="checkmark"></span>
                                    </label>
                                  </div>
                                </fieldset>
                              </div>

                            </div>


                            <div class="col-12 mt-4" id="checkTour">
                              <div class="table-responsive">
                                <table id="tabelaMoedas" class="table table-sm table-select table-hover">
                                  <thead>
                                    <tr>
                                      <th>Moeda</th>
                                      <th>Descrição</th>
                                      <th>Ações</th>
                                    </tr>
                                  </thead>
                                  <tbody>
                                  </tbody>
                                </table>
                              </div>

                              <div class="container">
                                <div class="row">
                                  <div class="col-md-9 col-sm-9 col-xs-12 col-12 mx-auto text-center">
                                    <div class="my-div">
                                      <div class="col-12 form-group" id="produtotuto">
                                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtMoedaTabela">Moeda</label>
                                        <div class="input-group">
                                          <input type="text" class="input-default focus form-control" id="txtMoedaTabela" name="txtMoedaTabela" class="form-control" placeholder="Moeda">
                                          <div class="input-group-append">
                                            <button class="btn bg-danger" id="btnMoeda" name="btnMoeda" data-button="absolute" type="button">
                                              <i class="m-0 p-0 fas fa-search"></i>
                                            </button>
                                            <button class="btn bg-danger" id="btnAMoeda" type="button">
                                              <i class="m-0 p-0 fas fa-trash"></i>
                                            </button>
                                          </div>
                                        </div>
                                      </div>
                                      <div class="col-12 form-group justify-content-center">
                                        <button class="btn bg-danger btn-block" id="btnIncluir" name="btnIncluir" data-button="absolute" type="button">
                                          <label class="m-0 p-0">Incluir</label>
                                        </button>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>

                        <div class="row">
                          <div class="col-md-12 col-12 mt-2">
                            <div class="table-responsive">
                              <table id="tabela-empAcesso" class="table table-sm table-select table-hover" width="100%">
                                <thead>
                                  <tr>
                                    <th>Sel</th>
                                    <th>Empresa</th>
                                  </tr>
                                </thead>
                                <tbody>
                                </tbody>
                              </table>
                            </div>
                          </div>
                        </div>
                          <input type="button" name="gravar" class="gravar action-button" value="Gravar" id="btnGravar" />
                          <input type="button" name="previous" class="previous action-button-previous" value="Voltar" id="voltar" />
                      </fieldset>
                    </div>
                  </form>
                </div>
              </div>

              </fieldset>
              </form>
            </div>
          </div>
        </div>
    </div>
  </div>


  <?php
  include_once('../../../footer.php');
  ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  </div>

  <!-- jQuery -->
  <script src="../plugins/jquery/jquery.min.js?versao=3.237.18.2"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.237.18.2"></script>
  <!-- SweetAlert2 -->
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.237.18.2"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.237.18.2"></script>

  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>

  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.237.18.2"></script>

  <script src="../dist/js/adminlte.min.js?versao=3.237.18.2"></script>

  <script src="../dist/js/requisicoes.js?versao=3.237.18.2"></script>
  <script src="../dist/js/cliente/entidade.js?versao=3.237.18.2"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.237.18.2"></script>
  <script src="../dist/js/valida_cpf_cnpj.js?versao=3.237.18.2"></script>
  <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.237.18.2"></script>
  <script src="../dist/js/sisplan.js?versao=3.237.18.2"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.237.18.2"></script>
  <script src="../utils/funcoes.js?versao=3.237.18.2"></script>
  <script src="../utils/cookies.js?versao=3.237.18.2"></script>
  <script src="../dist/js/driver.min.js?versao=3.237.18.2"></script>
  <script src="../dist/js/dataTables.keyTable2.js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="../config.js?versao=3.237.18.2"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('REGIAO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      const permissaoUsuarioLogado = await permissaoAcessos("REGIAO");

      if (permissaoUsuarioLogado.INCLUI == 'N') {
        await criaMensagemErro("Sem permissão para incluir!", () => {
          window.location.href = `${BASE_URI}/tabeladepreco`
        });
        return;
      }

      const queryString = window.location.href;
      const parametros = queryString.split("/");
      const regiao = parametros[parametros.length - 1];

      $(window).on("beforeunload", function(e) {
        e.preventDefault();
        deletaRegistro("REGIAO", getCookie("usuario"), regiao);
        return undefined;
      });

      sArquivo = `${BASE_URI}/pages/regiao/cadastro_regiao/regiao.js?versao=3.237.18.2`;
      insereJavaScriptPagina(sArquivo);

      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>
</body>

</html>