$('#tutorial').on('click', function () {
  $('#geral-tab').trigger('click');
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });

    driver.defineSteps([
      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão filtros',
          description: 'Clique aqui para abrir a aba de filtros.',
          position: 'right'
        }
      },
      {
        element: '#btnAtualizarListaNFe',
        popover: {
          title: 'Botão Atualizar',
          description: 'Clique aqui para atualizar a lista de NF-e.',
          position: 'right'
        }
      },
      {
        element: '#btnDownloadXml',
        popover: {
          title: 'Botão Download',
          description: 'Clique aqui para fazer o download das notas selecionadas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  await setarDataAtual('txtDtEmissaoI', true);
  await setarDataAtual('txtDtEmissaoF');

  const languageDataTable = {
    sEmptyTable: "Nenhum registro encontrado",
    sInfo: "_TOTAL_ registros",
    sInfoEmpty: " 0 registros",
    sInfoFiltered: "(Filtrados de _MAX_ registros)",
    sInfoPostFix: "",
    sInfoThousands: ".",
    language: {
      decimal: ",",
      thousands: ".",
    },
    sLengthMenu: "_MENU_ resultados",
    sLoadingRecords: "Carregando...",
    sProcessing: "Processando...",
    sZeroRecords: "Nenhum registro encontrado",
    sSearch: "Pesquisar",
    oPaginate: {
      sNext: "Próximo",
      sPrevious: "Anterior",
      sFirst: "Primeiro",
      sLast: "Último",
    },
    oAria: {
      sSortAscending: ": Ordenar colunas de forma ascendente",
      sSortDescending: ": Ordenar colunas de forma descendente",
    },
  };

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnConsultar').on('click', async function () {
    await consultaNotas();
  });

  $('#btnAtualizarListaNFe').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const response = await requisicao('GET', '/sisplan/radarnfe/v1/atualizarnotas?', '', '', 30000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      }

    } finally {
      $.LoadingOverlay('hide');
      if ($.fn.DataTable.isDataTable("#tabelaNFe")) {
        await consultaNotas();
      }
    }
  });

  async function consultaNotas() {
    try {
      $.LoadingOverlay('show');

      const pFiltros = {
        FORNECEDORES: pegaValor('#txtFornecedor'),
        DTEMIINI: pegaValor('#txtDtEmissaoI'),
        DTEMIFIM: pegaValor('#txtDtEmissaoF'),
        TIPO: pegaValor('input[name="tp_manifestacao"]:checked'),
        ARQUIVOXML: pegaValor('input[name="arq_xml"]:checked'),
        NUMERONFE: pegaValor('#txtNumeroNFe'),
        SERIENFE: pegaValor('#txtSerieNFe'),
        COMPRAS: pegaValor('input[name="lanc_compras"]:checked'),
      }

      const response = await requisicao('POST', '/sisplan/radarnfe/v1/consultarnotas?', '', JSON.stringify(pFiltros), 30000);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        return;
      }

      if (!jsonStr.notas) {
        msgAlerta('Nenhuma nota encontrada com os filtros feitos, favor verificar.');
        return;
      }

      preencheTabelaNotas(jsonStr);

    } catch (error) {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
      msgAlerta(error);
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
      $('#modal-filtros').modal('hide');
    }
  };

  function preencheTabelaNotas(jsonStr) {
    let dataSetCols = [];

    let keys = Object.keys(jsonStr.notas[0]);
    dataSetCols.push({
      'title': 'SEL',
      'data': 'SEL',
      'width': '15px'
    });

    dataSetCols[0].render = function (data, type, row, meta) {
      return `<div class="icheck-primary d-inline">
								<input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel">
								<label for="check_col_${meta.row}_row_${meta.col}"></label>
						  </div>`
    }

    for (var k in keys) {
      dataSetCols.push({
        'title': keys[k].toUpperCase(),
        'data': keys[k]
      });
    }

    criaDataTablePadrao('#tabelaNFe', false, false, false, false, true, true, '500px', jsonStr.notas, dataSetCols);

    $("#tabelaNFe").DataTable({
      destroy: true,
      scrollY: '500px',
      paging: false,
      filter: false,
      info: false,
      order: true,
      language: languageDataTable,
      autoWidth: true,
      data: jsonStr.notas,
      columns: dataSetCols,
      columnDefs: [
        {
          type: "date-br",
          render(data) {
            return new Intl.DateTimeFormat("pt-BR").format(
              new Date(`${data.substr(0, 10)} 23:59:59`)
            );
          },
          targets: [6, 9],
        },
      ],
      rowCallback: function (row, data) {
        let cor = "";
        if (!['', '0'].includes(data.sit_conf)) {
          cor = '#6495ED';
        } if ((data.entrou_nfe == '') && !['2', '3'].includes(data.sit_conf)) {
          cor = '#FFFF00';
        } if ((data.entrou_nfe == '') && ['2', '3'].includes(data.sit_conf)) {
          cor = '#BC8F8F';
        } if (data.tp_nf == 'E') {
          cor = '#3CB371';
        } if (data.nfe_ref != '') {
          cor = '#006400';
        } if ((data.sit_nfe == 'C') || (data.notaCanc != '') || (data.tipo == 'CAN')) {
          cor = '#FF0000';
        }
        $(row).css('color', cor);
      }
    });

    $('#tabelaNFe').on('click', 'td', function () {
      selecionarLinhaTabela('#tabelaNFe', 'campoSel', this);
    });
  };

  $('#btnDownloadXml').on('click', async function () {
    if (!$.fn.DataTable.isDataTable("#tabelaNFe")) {
      msgAlerta('Nenhuma nota consultada.')
      return;
    }

    try {
      $.LoadingOverlay('show');

      let pRadar = { NOTAS: [] };

      $('#tabelaNFe').DataTable().rows('.selected').data().map(item => {
        pRadar.NOTAS.push({
          CHAVE_NFE: item.chave_nfe,
          CNPJ: item.cnpj,
          NOME: item.nome,
          INSCRICAO: item.inscricao,
          EXISTE_XML: item.existe_xml,
          DT_EMISSAO: item.dt_emissao,
          TP_NF: item.tp_nf,
          VALOR: item.valor,
          DT_NFE: item.dt_nfe,
          SIT_NFE: item.sit_nfe,
          SIT_CONF: item.sit_conf,
          NSU: item.nsu,
          TIPO: item.tipo,
          NUM_NFE: item.num_nfe,
          ENTROU_NFE: item.entrou_nfe,
          NOTACANC: item.notaCanc,
          NFE_REF: item.nfe_ref,
          NATUREZA_NFE: item.natureza_nfe,
          CNPJ_DEST: item.cnpj_dest,
          DATA: item.data,
          FINNFE: item.finNfe,
          DESC_FINNFE: item.desc_FinNfe,
        });
      });

      if (pRadar.NOTAS.length == 0) {
        msgAlerta('Nenhuma nota selecionada.')
        return;
      }

      const response = await requisicao('POST', '/sisplan/radarnfe/v1/downloadxml?', '', JSON.stringify(pRadar), 30000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgAlerta(jsonStr.mensagem);
        return;
      } else {
        $.LoadingOverlay('hide');
        await consultaNotas();
      }

    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#txtFornecedor').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`, ["#txtCNPJ"], ["CNPJ"], ["CNPJ"]);
  $('#btn-Fornecedor').pesquisa_serverside(['#txtFornecedor', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, "Pesquisa Fornecedor");
  $('#btn-limpa-Fornecedor').on('click', function () { $('#txtFornecedor').val(''); });

});