<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan WEB | Entrar </title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.237.18.2">
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.237.18.2">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.237.18.2">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.237.18.2">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.237.18.2">

  <!-- SweetAlert2 -->
  <link rel="stylesheet" href="plugins/sweetalert2-theme-bootstrap-4/bootstrap-4.min.css?versao=3.237.18.2">

  <style>
    .login-page {
      background-position: center;
      min-height: 398.391px;
      background-image: url('dist/img/background.jpg');
      background-repeat: no-repeat;
      background-size: cover;
    }

    .select2-container--default .select2-selection--single {
      height: 38px !important;
    }
  </style>

  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <script type="text/javascript" src="dist/js/datadog-logs-v4.js?versao=3.237.18.2"></script>
  <script>
    const enviarLogs = '<?php if (defined('ENVIAR_LOGS')) {
                          echo ENVIAR_LOGS;
                        } else {
                          echo 1;
                        } ?>';

    if (enviarLogs == '1') {
      window.DD_LOGS &&
        DD_LOGS.init({
          clientToken: 'pub22c993c7a1e62229227b490bbdc2613f',
          forwardErrorsToLogs: true,
          sampleRate: 100,
          beforeSend: (log) => {
            if (log.http && log.http.status_code === 0) {
              return false;
            }

            log.usuario = {
              usuario: getCookie('usuario') ?? '',
              empresa: sessionStorage.getItem('g_nome_empresa_logada') ?? '',
              ipExterno: '<?php echo IP_EXTERNO; ?>',
              versao: VERSAO,
            }
          },
        })
    }
  </script>
</head>

<body class="hold-transition login-page">
  <div class="login-box">
    <div class="login-logo text-white">
      <a class="text-white" href="https://sisplansistemas.com.br/" target="_blank"><b>Sisplan</b> WEB</a>
    </div>
    <!-- /.login-logo -->
    <div class="card">
      <div class="card-body login-card-body">
        <p class="login-box-msg">Autentique-se para acessar o sistema</p>

        <div class="input-group mb-3">
          <input id="txtEmail" type="Usuário" oninput="handleInput(event)" class="input-default focus form-control" placeholder="Usuario">
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-user"></span>
            </div>
          </div>
        </div>
        <div class="input-group mb-3">
          <input id="txtSenha" type="password" class="input-default focus form-control" placeholder="Senha">
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-lock"></span>
            </div>
          </div>
        </div>
        <div class="form-group d-none" id="selectEmpresa">
          <select style="width:100%;" class="form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="rgEmpresa" class="custom-select focus ">
            <option value="">Selecione uma empresa</option>
          </select>
        </div>
        <div class="row">
          <div class="col-8">
            <div class="icheck-danger">
              <input type="checkbox" id="remember">
              <!-- <label for="remember">
                                Lembrar-me
                            </label> -->
            </div>
          </div>
          <!-- /.col -->
          <div class="col-4">
            <button type="submit" class="btnEntrar btn btn-danger btn-block">Entrar</button>
          </div>
          <br><br><br>
          <div id="adilsinho"></div>
          <!-- /.col -->
        </div>
      </div>
      <!-- /.login-card-body -->
    </div>
    <div class="modal fade" id="modal-danger">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content bg-danger">
          <div class="modal-header">
            <h4 id="modal-danger-titulo" class="modal-title">Danger Modal</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <textarea style="resize: none;border:0px;" id="modal-danger-conteudo" placeholder="Mensagem:" class="form-control bg-danger" rows="5" readonly></textarea>
          </div>
          <div id="modal-danger-rodape" class="modal-footer justify-content-between">

          </div>
        </div>
        <!-- /.modal-content -->
      </div>
      <!-- /.modal-dialog -->
    </div>
    <div style="z-index:99999999999!important;" class="modal fade" id="modal-warning">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
          <div class="modal-header">
            <i class="fas fa-exclamation-triangle text-yellow" style="margin-right: 20px;font-size: 35px;margin-right: 20;"></i>
            <h4 id="modal-warning-titulo" class="modal-title">Atenção</h4>
            <button type="button" class="close" id="btn-warning-close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <textarea style="resize: none; border:0px;" id="modal-warning-conteudo" placeholder="Mensagem:" class="form-control" rows="5" readonly></textarea>
          </div>
          <div id="modal-warning-rodape" class="modal-footer justify-content-between">

          </div>
        </div>
        <!-- /.modal-content -->
      </div>
      <!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->


    <!-- /.login-box -->

    <!-- jQuery -->
    <script src="plugins/jquery/jquery.min.js?versao=3.237.18.2"></script>
    <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.237.18.2"></script>
    <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.237.18.2"></script>
    <!-- Bootstrap 4 -->
    <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.237.18.2"></script>
    <!-- SweetAlert2 -->
    <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.237.18.2"></script>
    <!-- Toastr -->
    <script src="plugins/toastr/toastr.min.js?versao=3.237.18.2"></script>
    <!-- AdminLTE App -->
    <script src="dist/js/adminlte.min.js?versao=3.237.18.2"></script>
    <script src="dist/js/loadingoverlay.min.js?versao=3.237.18.2"></script>
    <!-- <script src="dist/js/sisplan.js"></script>
    <script src="dist/js/sisplanOffiline.js"></script> -->
    <script src="dist/js/requisicoes.js?versao=3.237.18.2"></script>
    <script type="text/javascript" src="utils/funcoes.js?versao=3.237.18.2"></script>
    <script type="text/javascript" src="utils/cookies.js?versao=3.237.18.2"></script>
    <script type="text/javascript" src="utils/login.js?versao=3.237.18.2"></script>
    <script src="plugins/select2/js/select2.full.min.js?versao=3.237.18.2"></script>
    <script type="text/javascript" src="config.js?versao=3.237.18.2"></script>
    <script type="text/javascript">
      function handleInput(e) {
        var ss = e.target.selectionStart;
        var se = e.target.selectionEnd;
        e.target.value = e.target.value.toUpperCase();
        e.target.selectionStart = ss;
        e.target.selectionEnd = se;
      }
      $(document).ready(async function() {
        if ($('#txtEmail').val() != '') {
          await retornaEmpresasCadastradas();
        }
        await insereJavaScriptPagina('dist/js/sisplan.js?versao=3.237.18.2');

        var emp_id = 1;
        ipInterno = '<?php echo IP_INTERNO; ?>';
        ipExterno = '<?php echo IP_EXTERNO; ?>';
        basicAuth = '<?php echo BASIC_AUTH; ?>';

        $('#txtEmail').focus();

        //Initialize Select2 Elements
        $('.select2').select2();

        //Initialize Select2 Elements
        $('.select2bs4').select2({
          theme: 'bootstrap4'
        });

        $(".btnEntrar").keyup(function(event) {
          if (event.keyCode === 13) {
            $(".btnEntrar").click();
          }
        });

        $('#txtSenha').on('blur', function() {
          if (($('#txtSenha').val() != '') && ($('#txtEmail').val() != '') && ($('#rgEmpresa').val() != '')) {
            $('.btnEntrar').focus();
            $('.btnEntrar').trigger('click');
          }
        });

        $('#txtEmail').blur(async function() {
          try {
            $.LoadingOverlay('show');
            $("#rgEmpresa").attr('disabled', true);
            await retornaEmpresasCadastradas();
            $("#rgEmpresa").attr('disabled', false);
          } finally {
            $.LoadingOverlay('hide');
          }
        });

        async function buscaCodigoUsuario() {
          let usuario;
          try {
            if ($('#txtEmail').val().split('.')[0] == 'SISPLAN') {
              usuario = $('#txtEmail').val().split('.')[0];
            } else {
              usuario = $('#txtEmail').val();
            }

            if (usuario == ''){
              return;
            }

            const response = await requisicao('GET', '/sisplan/usuario/v1/dadoslogin?', `EMPRESA=_001&USUARIO=${usuario}`, null);

            if (!response) {
              return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
              msgAlerta(jsonStr.RESULT[0].mensagem);
              return;
            }

            if (jsonStr[0].TOKEN_WHATSAPPWEB && jsonStr[0].TOKEN_WHATSAPPWEB != '') {
              setCookie('Token@Whatsapp', jsonStr[0].TOKEN_WHATSAPPWEB);
              setCookie('Session@Whatsapp', jsonStr[0].NOME_WHATSAPPWEB);
            }

            if (jsonStr.length > 0) {
              return jsonStr[0].CODIGO;
            } else {
              msgAlerta('Usuário inválido!');
              return;
            }

          } catch (error) {
            console.error(error);
          }
        }

        function gerarGuid() {
          return ([1e7] + 1e3 + 4e3 + 8e3 + 1e11).replace(/[018]/g, c =>
            // eslint-disable-next-line no-bitwise
            (c ^ crypto.getRandomValues(new Uint8Array(1))[0] & 15 >> c / 4).toString(16)
          );
        }

        async function retornaEmpresasCadastradas() {
          try {
            $("#rgEmpresa").empty();
            $("#rgEmpresa").append(' <option value="">Selecione uma empresa</option>');
            const codigoUsuario = await buscaCodigoUsuario();
            let response;
            if (codigoUsuario != '') {
              const response = await requisicao('GET', '/sisplan/usuario/v1/empresas?',`EMPRESA=_001&USUARIO=${codigoUsuario}`, null);

              if (!response) {
                $.LoadingOverlay("hide");
                return;
              }

              const jsonStr = await response.json();
              if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgAlerta(jsonStr['RESULT'][0].mensagem)
                return;
              }

              for (const empresa of jsonStr) {
                var opcao = new Option(`${empresa.EMP_PAT.substring(1)} - ${empresa.EMP_NOME}`, `${empresa.EMP_PAT}`);
                $(opcao).html(`${empresa.EMP_PAT.substring(1)} - ${empresa.EMP_NOME}`);
                $("#rgEmpresa").append(opcao);
                $('#selectEmpresa').removeClass('d-none')
                if (jsonStr.length == 1) {
                  $('#rgEmpresa').val(empresa.EMP_PAT);
                }
              }
            } else {
              $("#rgEmpresa").empty();
              $("#rgEmpresa").append(' <option value="">Selecione uma empresa</option>');
            }
          } catch (error) {
            console.error(error);
          }

          $('#rgEmpresa').trigger('blur');
        }

        $(function() {
          sessionStorage.removeItem('g_usuario_logado');
          sessionStorage.removeItem('g_empresa_logada');
          sessionStorage.removeItem('g_emp_id_empresa_logada');
          sessionStorage.removeItem('g_nome_empresa_logada');
          sessionStorage.removeItem('g_cnpj_empresa_logada');
          sessionStorage.removeItem('g_vendedor_logado');
          sessionStorage.removeItem('g_caixa_logado');
          sessionStorage.removeItem('g_deposito_vendedor_caixa');
          sessionStorage.removeItem('g_tabpreco_vendedor_caixa');
          deleteCookie('usuario');
          deleteCookie('emp_id');
          deleteCookie('empresa');
          deleteCookie('cod_usuario');
          deleteCookie('acessos_web');
          deleteCookie('Token@Whatsapp');
          deleteCookie('Session@Whatsapp');

          $('.btnEntrar').click(async function() {
            try {
              if ($('#txtEmail').val() == '') {
                msgAlerta('Usuário não informado');
                return;
              }

              if ($('#txtSenha').val() == '') {
                msgAlerta('Senha não informada');
                return;
              }

              if ($('#rgEmpresa').val() == '' || $('#rgEmpresa').val() == null) {
                msgAlerta('Empresa não informada');
                return;
              }

              const ip_interno_php = '<?php echo IP_INTERNO; ?>';
              const ip_externo_php = '<?php echo IP_EXTERNO; ?>';
              const api_whatsapp_php = '<?php echo defined('API_WHATSAPP') ? API_WHATSAPP : "" ?>';
              const base_uri_php = '<?php echo BASE_URI; ?>';
              const chave_api_php = '<?php echo CHAVE_API; ?>';
              const API_WHATSAPP_JS = typeof(API_WHATSAPP) == 'undefined' ? '' : API_WHATSAPP;

              if (ip_interno_php != IP_INTERNO) {
                msgAlerta('Tag IP_INTERNO dos arquivos de configuração diferentes, confira os arquivos CONFIG.PHP e CONFIG.JS');
                return;
              }

              if (ip_externo_php != IP_EXTERNO) {
                msgAlerta('Tag IP_EXTERNO dos arquivos de configuração diferentes, confira os arquivos CONFIG.PHP e CONFIG.JS');
                return;
              }

              if (base_uri_php != BASE_URI) {
                msgAlerta('Tag BASE_URI dos arquivos de configuração diferentes, confira os arquivos CONFIG.PHP e CONFIG.JS');
                return;
              }

              if (chave_api_php != CHAVE_API) {
                msgAlerta('Tag CHAVE_API dos arquivos de configuração diferentes, confira os arquivos CONFIG.PHP e CONFIG.JS');
                return;
              }

              if (api_whatsapp_php != API_WHATSAPP_JS) {
                msgAlerta('Tag API_WHATSAPP dos arquivos de configuração diferentes, confira os arquivos CONFIG.PHP e CONFIG.JS');
                return;
              }

              $.LoadingOverlay("show");
              const login = new Login();
              let senha = login.encriptografarSenha($('#txtSenha').val().toUpperCase());;
              if ($('#txtEmail').val().includes('SISPLAN.')) {
                senha = login.encriptografarSenha($('#txtSenha').val());
              }
              const senhaEncode = encodeURIComponent(senha);
              const porta_api_local = '<?php echo PORTA_API_LOCAL; ?>';
              const ipPortaServidor = '<?php if (defined('IP_API_SERVIDOR')) {
                                          echo IP_API_SERVIDOR;
                                        } else {
                                          echo '';
                                        } ?>';

              setCookie('porta_api_local', porta_api_local, 1500);
              setCookie('ipPortaServidor', ipPortaServidor, 1500);
              setCookie('empresa', $('#rgEmpresa').val());
              verificaSeTemIdNaMaquina();
              gravaIdAba();
              var response = await requisicao('GET', '/Sisplan/Funcoes/V1/LoginWeb?', `email=${$('#txtEmail').val().toUpperCase()}&senha=${senhaEncode}&empresa=${$('#rgEmpresa').val()}`);
              if (response.status != 200) {
                var jsonResponse = await response.json();
                msgAlerta(jsonResponse.mensagem);
                return;
              }

              var jsonResponse = await response.json();

              if (jsonResponse.codUsuario == "") {
                msgAlerta('Usuário não liberado para este aplicativo');
                return;
              }
              
              setCookie('accessToken', jsonResponse.accessToken);
              setCookie('refreshToken', jsonResponse.refreshToken);

              const versaoApi = await buscaVersaoAPI();
              if (VERSAO !== versaoApi) {
                msgAlerta(`Acesso Bloqueado. Versão do Sistema Web (${VERSAO}) está diferente da API (${versaoApi}). Favor corrigir ou contate o SUPORTE da Sisplan Sistemas.`);
                return;
              }

              sessionStorage.setItem('g_usuario_logado', $('#txtEmail').val().replace("SISPLAN.", ""));
              sessionStorage.setItem('g_empresa_logada', $('#rgEmpresa').val());
              emp_id = await busca_emp_id();
              setCookie('cod_usuario', jsonResponse.codUsuario);
              const cnpj = await busca_cnpj();
              if (cnpj && cnpj.startsWith("00.000.000")) {
                $.LoadingOverlay("hide");
                msgAlerta('Acesso Bloqueado. Verifique se o CNPJ está devidamente configurado na tabela Empresa. Contate o SUPORTE ou o COMERCIAL da Sisplan Sistemas.');
                return;
              }
              const bloqueio = await verificarBloqueio(cnpj);
              if (!bloqueio) {
                $.LoadingOverlay("hide");
                msgAlerta('Acesso Bloqueado. Falar com o ADMINISTRADOR da empresa ou contate o SUPORTE da Sisplan Sistemas.');
                return;
              }

              const bloqueioUsuarios = await verificarQuantidadeUsuarios(cnpj, $('#txtEmail').val().replace("SISPLAN.", ""), getCookie('idMaquina'));
              
              if (!bloqueioUsuarios) {
                $.LoadingOverlay("hide");
                msgAlerta('Acesso Bloqueado. Limite de usuários simultâneos atingiu o máximo permitido. Espere até que outro usuário feche o sistema ou contate o setor COMERCIAL da Sisplan Sistemas.',
                  undefined,
                  undefined,
                  async () => {
                      await funcaoLogar(emp_id, cnpj, true);
                    },
                    async () => {
                      await funcaoLogar(emp_id, cnpj, true);
                    }
                );

              } else {
                await funcaoLogar(emp_id, cnpj);
              }
            } catch (error) {
              console.error(error)
              return;
            } finally {
              $.LoadingOverlay("hide");
            }
          });

          async function funcaoLogar(emp_id, cnpj, enviarLog) {
            if (typeof emp_id === 'undefined') {
              $.LoadingOverlay("hide");
              msgAlerta('Não foi possível buscar os dados da empresa logada.');
              return;
            }
            sessionStorage.setItem('g_emp_id_empresa_logada', emp_id);
            sessionStorage.setItem('g_cnpj_empresa_logada', cnpj);
            sessionStorage.setItem('g_nome_empresa_logada', $("#rgEmpresa option:selected").text());

            setCookie('usuario', $('#txtEmail').val().replace("SISPLAN.", ""), 30);
            setCookie('emp_id', emp_id, 30);
            setCookie('empresa', $('#rgEmpresa').val(), 30);
            setCookie('enviando_comando', 'false');
            await carregaParametrosLogin();
            await carregaEmpValorLogin();

            const temRegistroNaEmpValorNatureza = await fazSelectNaEmpValor('', 'NATUREZA');
            if (temRegistroNaEmpValorNatureza.length > 0) {
              setCookie('naturezanaempvalor', 'S', 30);
            } else {
              setCookie('naturezanaempvalor', 'N', 30);
            }

            await loginUsuario();

            if (!$('#txtEmail').val().startsWith("SISPLAN.")) {
              enviarVersao(cnpj);
              enviarDados(cnpj);
            }

            if (enviarLog) {
              const log = {
                descricao: `Aviso de limite de usuários simultâneos atingido: ${cnpj}`,
                tela: 'loginWeb',
                chave: getCookie('cod_usuario')
              }

              requisicao('POST', `/sisplan/funcoes/v1/geralogerp?`, '', `JSON=${encodeURIComponent(JSON.stringify(log))}`);
            }

            window.location.href = "index";
          }

          function enviarVersao(cnpj) {
            requisicao('POST', '/sisplan/versaoweb/v1/versaoweb?', `TIPO=WEB&CNPJ=${cnpj}`);
          }

          function enviarDados(cnpj) {
            const interno = ipInterno.split(':')[0];
            const porta = ipInterno.split(':')[1];
            const externo = ipExterno.split(':')[0];
            const portaExterna = ipExterno.split(':')[1];

            if ($('#txtEmail').val().startsWith('SISPLAN.')) {
              return;
            }

            if (!porta) {
              return;
            }
            if (!portaExterna) {
              return;
            }
            if (!interno) {
              return;
            }
            if (!externo) {
              return;
            }
            if (interno === '127.0.0.1' || interno === 'localhost') {
              return;
            }

            const object = {
              cNPJ: cnpj,
              ipExterno: externo,
              porta_Externo: portaExterna,
              IpInterno: interno,
              Porta_Interno: porta,
              Ativo: 1,
              tipo: "WEB"
            }

            requisicao('POST', `/sisplan/funcoes/v1/salvarconexao?`, '', JSON.stringify(object));
          }

          async function busca_emp_id() {
            try {
              $.LoadingOverlay("show");

              var _url = `/sisplan/funcoes/v1/pesquisa?`;
              var response = await requisicao('GET', _url,
                `EMPRESA=_001&JSON={ "tabela":"EMPRESA", "camposSelect": ["EMP_ID"], "where": ["emp_pat = '${sessionStorage.getItem('g_empresa_logada')}'"] }`,
                null);

              if (!response) {
                $.LoadingOverlay("hide");
                return;
              }

              var jsonStr = await response.json()
              if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgAlerta(jsonStr['RESULT'][0].mensagem)
                return;
              }

              return jsonStr['RESULT'][0][0].EMP_ID;

            } catch (error) {
              console.error(error);
              $.LoadingOverlay("hide");
              msgAlerta('Não foi possível buscar os dados da empresa logada.');
            }
          };
        });
      });
    </script>
</body>

</html>