<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Liberação Pedido Financeiro</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.237.18.2">
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.237.18.2">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.237.18.2">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.237.18.2">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.237.18.2" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.237.18.2">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.237.18.2" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.237.18.2">
  <style>
    .radioStyle {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding: 6px;
    }

    .campoSel {
      display: inline-block;
      position: absolute;
      width: 22px;
      height: 22px;
      border: 1px solid #D3CFC8;
      border-radius: 0;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../menu.php');
    ?>
    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Liberação de Pedido Financeiro</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="./index">Início</a></li>
                <li class="breadcrumb-item active">Liberação de Pedido Financeiro</li>
              </ol>
            </div>
          </div>
        </div>
        <div class="container-fluid card">
          <div class="row card-body" id="abaGeral">

            <div class="col-lg-4 form-group">
              <label data-error="wrong" data-success="right" for="txtDtFaturaDe">Período Fatura (de/até)</label>
              <div class="input-group">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtFaturaDe" name="txtDtFaturaDe">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtFaturaAte" name="txtDtFaturaAte">
              </div>
            </div>

            <div class="col-lg-8 form-group">
              <label data-error="wrong" data-success="right" for="txtPedido">Pedido </label>
              <div class="input-group">
                <input type="text" class="input-default col-lg-3 col-12 focus form-control" id="txtPedido" name="txtPedido" class="form-control" placeholder="Pedido">
                <button class="btn bg-danger" id="btn-PedidoConsulta" name="btn-PedidoConsulta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                <input type="text" id="txtListaPedidos" class="form-group col-lg-9 col-12 input-default focus form-control" placeholder="Lista de Pedidos" disabled>
                <button class="btn bg-danger" id="btn-limpa-Pedido" name="btn-limpa-Pedido" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
              </div>
            </div>

            <div class="col-lg-4 form-group">
              <label data-error="wrong" data-success="right" for="txtDtEmissaoDe">Período Emissão (de/até)</label>
              <div class="input-group">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtEmissaoDe" name="txtDtEmissaoDe">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtEmissaoAte" name="txtDtEmissaoAte">
              </div>
            </div>

            <div class="col-lg-4 form-group">
              <label data-error="wrong" data-success="right" for="txtCliente">Cliente </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtCliente" name="txtCliente" placeholder="Cliente">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Cliente" name="btn-Cliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Cliente" name="btn-limpa-Cliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-4 form-group">
              <label data-error="wrong" data-success="right" for="txtRepresentante">Representante </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtRepresentante" name="txtRepresentante" placeholder="Representante">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Representante" name="btn-Representante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Representante" name="btn-limpa-Representante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-4 form-group">
              <label data-error="wrong" data-success="right" for="txtDtSaidaDe">Data de Saída (de/até)</label>
              <div class="input-group">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtSaidaDe" name="txtDtSaidaDe">
                <input type="date" max="2500-12-31" class="input-default focus form-control" id="txtDtSaidaAte" name="txtDtSaidaAte">
              </div>
            </div>

            <div class="col-lg-4 form-group">
              <label data-error="wrong" data-success="right" for="txtColecao">Coleção </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtColecao" name="txtColecao" placeholder="Coleção">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-Colecao" name="btn-Colecao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-Colecao" name="btn-limpa-Colecao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-2 form-group">
              <label data-error="wrong" data-success="right" for="txtPeriodoEntDe">Período Entrega de </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtPeriodoEntDe" name="txtPeriodoEntDe" placeholder="de">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-PeriodoEntDe" name="btn-PeriodoEntDe" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-PeriodoEntDe" name="btn-limpa-PeriodoEntDe" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-lg-2 form-group">
              <label data-error="wrong" data-success="right" for="txtPeriodoEntAte"> até </label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtPeriodoEntAte" name="txtPeriodoEntAte" placeholder="até">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btn-PeriodoEntAte" name="btn-PeriodoEntAte" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btn-limpa-PeriodoEntAte" name="btn-limpa-PeriodoEntAte" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>

            <div class="col-sm-8">
              <div class="radioStyle">
                <label class="container">
                  <input type="radio" checked="checked" id="radioTodos" name="tipo">
                  <span class="checkmark"></span> Todos
                </label>
                <label class="container">
                  <input type="radio" id="radioBloqVendas" name="tipo">
                  <span class="checkmark"></span> Bloq. Vendas
                </label>
                <label class="container">
                  <input type="radio" id="radioBloqFinan" name="tipo">
                  <span class="checkmark"></span> Bloq. Finan.
                </label>
                <label class="container">
                  <input type="radio" id="radioBloqFinanLibVend" name="tipo">
                  <span class="checkmark"></span> Bloq. Finan. / Lib. Vendas
                </label>
                <label class="container">
                  <input type="radio" id="radioBloqExp" name="tipo">
                  <span class="checkmark"></span> Bloq. Expedição
                </label>
              </div>
            </div>

            <div class="col-lg-2 form-group">
              <button class=" btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
            </div>


            <div class="col-sm-6 table-responsive card-body">
              <h5>Pedidos</h5>
              <table id="tabelaPedido" class="table table-sm table-select table-hover" width="100%">
                <thead>
                  <tr>
                    <th class="th-sm">SEL
                    </th>
                    <th class="th-sm">Pedido
                    </th>
                    <th class="th-sm">Cliente
                    </th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>

            <div class="col-sm-6 table-responsive card-body">
              <h5>Itens</h5>
              <table id="tabelaItens" class="table table-sm table-select table-hover" width="100%">
                <thead>
                  <tr>
                    <th class="th-sm">Código
                    </th>
                    <th class="th-sm">Descrição
                    </th>
                    <th class="th-sm">Cor
                    </th>
                    <th class="th-sm">Tam
                    </th>
                    <th class="th-sm">Qtde
                    </th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>

            <div class="col-sm-12 d-flex justify-content-end">
              <div class="radioStyle">
                <label class="container">
                  <input type="radio" checked="checked" id="radioLiberar" name="liberarBloq">
                  <span class="checkmark"></span> Liberar
                </label>
                <label class="container">
                  <input type="radio" id="radioBloquear" name="liberarBloq">
                  <span class="checkmark"></span> Bloquear
                </label>
                <button id="btnLiberar" class="btn btn-danger btn-sisp">Confirmar</button>
              </div>
            </div>

          </div>
        </div>
      </div>
      <!-- modal  -->
    </div>
  </div>
  <?php
  include_once('../../footer.php');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.237.18.2"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.237.18.2"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.237.18.2"></script>
  <script src="dist/js/adminlte.min.js?versao=3.237.18.2"></script>
  <script src="dist/js/sisplan.js?versao=3.237.18.2"></script>
  <script src="utils/funcoes.js?versao=3.237.18.2"></script>
  <script src="utils/cookies.js?versao=3.237.18.2"></script>
  <script src="dist/js/requisicoes.js?versao=3.237.18.2"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.237.18.2"></script>
  <script src="dist/js/driver.min.js?versao=3.237.18.2"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.237.18.2"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="config.js?versao=3.237.18.2"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('LIBERACAO_FINANCEIRO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/liberacao_financeiro/liberacao_financeiro.js?versao=3.237.18.2`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>