$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([
      {
        element: '#abaGeral',
        popover: {
          title: 'Campos de Filtro',
          description: 'Campos para filtrar o pedido a ser liberado.',
          position: 'bottom'
        }
      },
      {
        element: '#btnConsultar',
        popover: {
          title: 'Botão Consultar',
          description: 'Clique aqui para realizar a consulta de pedidos.',
          position: 'left'
        }
      },
      {
        element: '#btnLiberar',
        popover: {
          title: 'Botão Confirmar',
          description: 'Clique aqui para liberar/bloquear os pedidos selecionados.',
          position: 'left'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  addPesquisaAutocompleta();

  $('#btnConsultar').on('click', async () => { await buscaPedidos() });

  $('#tabelaPedido').on('click', 'tr', async function () {
    $('.selected').removeClass('selected');
    $(this).closest('tr').addClass('selected');
    await buscaItensPedido($(this).closest('tr')[0].children[1].innerHTML);
  });

  $('#btnLiberar').on('click', async function () {
    await gravaDados();
  });

  async function gravaDados() {
    let arrPedidos = [];
    const liberarBloquear = $('#radioLiberar').prop('checked') ? '1' : '0';

    $('.selecionado').closest('tr').map((index, item) => {
      arrPedidos.push({
        NUMERO: item.children[1].innerHTML,
        FINANCEIRO: liberarBloquear
      })
    });

    if (arrPedidos.length == 0) {
      msgAlerta('Nenhum pedido selecionado para liberar.');
      return;
    }

    const response = await requisicao('POST', '/sisplan/pedido/v1/liberapedido?', 'TELA=LIBERACAO_FINANCEIRO_WEB', JSON.stringify({ PEDIDOS: arrPedidos }));

    if (!response) {
      $.LoadingOverlay('hide');
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      $.LoadingOverlay('hide');
      msgErro(jsonStr.mensagem);
      return;
    }
    criaMensagemSucesso('Liberação efetuada com sucesso.', () => { window.location.reload() })
  }

  async function buscaItensPedido(sPedido) {
    $.LoadingOverlay('show');
    try {
      const itens = await retornaItens(sPedido);
      insereItens(itens);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function buscaPedidos() {
    $.LoadingOverlay('show');
    try {
      const sWhere = retornaFiltro();
      const dados = await retornaDados(sWhere);

      if (dados.length == 0) {
        msgAlerta('Nenhum dado encontrado, favor verificar os filtros.')
        return;
      }

      insereDadosTabela(dados);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function retornaDados(sWhere) {
    const dadosSelect = {
      tabela: 'PEDIDO',
      camposSelect: ['PEDIDO.NUMERO', 'ENTIDADE.NOME'],
      leftJoin: [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' }],
      where: [`${sWhere}`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados do pedido.');
      return;
    }
    return retornoSelect;
  }

  async function retornaItens(sPedido) {
    const dadosSelect = {
      tabela: 'PED_ITEN',
      camposSelect: ['PED_ITEN.CODIGO', 'PRODUTO.DESCRICAO', 'PED_ITEN.COR', 'PED_ITEN.TAM', 'PED_ITEN.QTDE'],
      leftJoin: [{ tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = PED_ITEN.CODIGO' }],
      where: [`PED_ITEN.NUMERO = '${sPedido}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados dos itens.');
      return;
    }
    return retornoSelect;
  }

  function insereItens(sDados) {
    let dataSetCols = [];

    const keys = Object.keys(sDados[0]);

    for (var k in keys) {
      dataSetCols.push({
        'data': keys[k]
      });
    };

    criaDataTablePadrao('#tabelaItens', false, false, false, false, true, false, '300px', sDados, dataSetCols);
  }

  function insereDadosTabela(sDados) {
    let dataSetCols = [];

    const keys = Object.keys(sDados[0]);
    dataSetCols.push({
      'data': 'SEL',
      'width': '15px'
    });

    dataSetCols[0].render = function (data, type, row, meta) {
      return `<div class="icheck-primary d-inline">
								<input type="checkbox" id="check_col_${meta.row}_row_${meta.col}" class="campoSel">
								<label for="check_col_${meta.row}_row_${meta.col}"></label>
						  </div>`
    };

    for (var k in keys) {
      dataSetCols.push({
        'data': keys[k]
      });
    };

    criaDataTablePadrao('#tabelaPedido', false, false, false, false, true, false, '300px', sDados, dataSetCols);

    $('.campoSel').on('click', function () {
      if (this.checked) {
        $(this).addClass('selecionado');
      } else {
        $(this).removeClass('selecionado');
      }
    });
  }

  function retornaFiltro() {
    let where = ' 1 = 1 ';
    where += $('#txtDtFaturaDe').val() != '' ? ` AND PEDIDO.DT_FATURA >= '${$('#txtDtFaturaDe').val()}' ` : '';
    where += $('#txtDtFaturaAte').val() != '' ? ` AND PEDIDO.DT_FATURA <= '${$('#txtDtFaturaAte').val()}' ` : '';
    where += $('#txtDtEmissaoDe').val() != '' ? ` AND PEDIDO.DT_EMISSAO >= '${$('#txtDtEmissaoDe').val()}' ` : '';
    where += $('#txtDtEmissaoAte').val() != '' ? ` AND PEDIDO.DT_EMISSAO <= '${$('#txtDtEmissaoAte').val()}' ` : '';
    where += $('#txtDtSaidaDe').val() != '' ? ` AND PEDIDO.DT_SAIDA >= '${$('#txtDtSaidaDe').val()}' ` : '';
    where += $('#txtDtSaidaAte').val() != '' ? ` AND PEDIDO.DT_SAIDA <= '${$('#txtDtSaidaAte').val()}' ` : '';
    where += $('#txtPeriodoEntDe').val() != '' ? ` AND PEDIDO.PERIODO >= '${pegaChave('#txtPeriodoEntDe')}' ` : '';
    where += $('#txtPeriodoEntAte').val() != '' ? ` AND PEDIDO.PERIODO <= '${pegaChave('#txtPeriodoEntAte')}' ` : '';
    where += $('#txtListaPedidos').val() != '' ? ` AND PEDIDO.NUMERO IN (${$('#txtListaPedidos').val()}) ` : '';
    where += $('#txtCliente').val() != '' ? ` AND PEDIDO.CODCLI = '${pegaChave('#txtCliente')}' ` : '';
    where += $('#txtRepresentante').val() != '' ? ` AND PEDIDO.CODREP = '${pegaChave('#txtRepresentante')}' ` : '';
    where += $('#txtColecao').val() != '' ? ` AND PEDIDO.COLECAO = '${pegaChave('#txtColecao')}' ` : '';
    where += $('#radioBloqVendas').prop('checked') ? ` AND PEDIDO.BLOQUEIO = '0' ` : '';
    where += $('#radioBloqFinan').prop('checked') ? ` AND PEDIDO.FINANCEIRO = '0' ` : '';
    where += $('#radioBloqFinanLibVend').prop('checked') ? ` AND (PEDIDO.BLOQUEIO = '1' AND PEDIDO.FINANCEIRO = '0') ` : '';
    where += $('#radioBloqExp').prop('checked') ? ` AND PEDIDO.FINANCEIRO = '2' ` : '';
    where += ` AND PEDIDO.EMP_ID = '${getCookie('emp_id')}' `;
    return where;
  }

  function addPesquisaAutocompleta() {
    $('#txtPedido').on('blur', function () {
      let pedido = $('#txtPedido').val();
      if (pedido.includes("[")) {
        pedido = pegaChave($('#txtPedido'));      
      } else {
        pedido = $('#txtPedido').val();
      }
      pedido = pedido.replace('\w','');

      const listaPedidos = $('#txtListaPedidos').val();
      if (pedido == '') {
        return;
      }
      $('#txtListaPedidos').val((listaPedidos == '') ? `'${pedido}'` : `${listaPedidos},'${pedido}'`);
      $('#txtPedido').val('');
      $('#txtPedido').focus();
    });
    $('#txtPedido').on('keydown', async function (event) {
      if (event.key == 'Enter') {
        $('#txtPedido').trigger('blur');
        $('#txtPedido').focus();
      }
    });
    $('#btn-limpa-Pedido').on('click', function () { $('#txtListaPedidos').val(''); });
    $("#btn-PedidoConsulta").pesquisa_serverside(["#txtPedido"], ["NUMERO"], ["CODCLI"], `{"tabela":"PEDIDO", "camposSelect":[ "NUMERO", "CODCLI" ]}`, "Pesquisa Pedido"); 

    $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`, ["#txtCNPJ"], ["CNPJ"], ["CNPJ"]);
    $('#btn-Cliente').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, "Pesquisa Cliente");
    $('#btn-limpa-Cliente').on('click', function () { $('#txtCliente').val(''); });

    $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"represen", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": ["ativo = 'S' and nome <> 'CONSUMIDOR FINAL'"]}`,);
    $('#btn-Representante').pesquisa_array(['#txtRepresentante'], ['CODREP'], ['NOME'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome" ], "where": ["ativo = 'S' and nome <> 'CONSUMIDOR FINAL'"]}`, "Pesquisa Represen", "represen");
    $('#btn-limpa-Representante').on('click', function () { $('#txtRepresentante').val(''); });

    $('#txtColecao').autocompleta(1, `JSON={ "tabela":"COLECAO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Colecao').pesquisa('#txtColecao', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Coleção', 'colecao');
    $('#btn-limpa-Colecao').on('click', function () { $('#txtColecao').val('') });

    $('#txtPeriodoEntDe').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-PeriodoEntDe').pesquisa('#txtPeriodoEntDe', 'PRAZO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO", "DESCRICAO"]}`, 'Pesquisa Código', 'TABPRZ');
    $('#btn-limpa-PeriodoEntDe').on('click', function () {
      $('#txtPeriodoEntDe').val('');
    });

    $('#txtPeriodoEntAte').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-PeriodoEntAte').pesquisa('#txtPeriodoEntAte', 'PRAZO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO", "DESCRICAO"]}`, 'Pesquisa Código', 'TABPRZ');
    $('#btn-limpa-PeriodoEntAte').on('click', function () {
      $('#txtPeriodoEntAte').val('');
    });
  }
});