<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Parâmetros</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/fontawesome-free/css/all.min.css?versao=3.237.18.2">
  <!-- Ionicons -->
  <!-- Ionicons -->
  <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css?versao=3.237.18.2">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/adminlte.min.css?versao=3.237.18.2">
  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/plugins/overlayScrollbars/css/OverlayScrollbars.min.css?versao=3.237.18.2">
  <!-- Daterange picker -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>

  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/custom.css?versao=3.237.18.2">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/sisplan.css?versao=3.237.18.2">
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URI; ?>/dist/css/dataTables.bootstrap4.min.css?versao=3.237.18.2" />
  <link rel="shortcut icon" href="<?php echo BASE_URI; ?>/favicon.ico">
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URI; ?>/plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.237.18.2">
  <link rel="stylesheet" href="<?php echo BASE_URI; ?>/dist/css/jquery-ui.css?versao=3.237.18.2">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.237.18.2">
  <!-- Google Font: Source Sans Pro -->
  <style>
    .info-box-text {
      font-size: 20px;
      font-weight: bold;
      color: grey;
    }

    div .nav-pills .nav-link.active,
    div .nav-pills .show>.nav-link {
      color: #fff;
      background-color: #a1a6ab;
    }

    .nave.nav-link:hover {
      color: #6c757d !important;
    }

    .nave.nav-link.active:hover {
      color: white !important;
    }

    .group-default {
      margin: 0px;
    }

    label:hover {
      cursor: pointer;
    }

    label {
      width: 750px;
    }
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../menu.php');
    ?>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6">
              <h1 class="m-0 text-dark">Parâmetros</h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="index.php">Início</a></li>
                <li class="breadcrumb-item active">Parâmetros</li>
              </ol>
            </div><!-- /.col -->
          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <!-- Main content -->
      <section class="content">
        <div class="card">
          <div class="card-body">
            <div class="row">
              <div class="col-sm-3">
                <div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                  <a class="nave nav-link active" id="v-pills-venda-tab" data-toggle="pill" href="#v-pills-venda" role="tab" aria-controls="v-pills-venda" aria-selected="true">Venda</a>
                  <a class="nave nav-link" id="v-pills-receber-tab" data-toggle="pill" href="#v-pills-receber" role="tab" aria-controls="v-pills-receber" aria-selected="false">Receber</a>
                  <a class="nave nav-link" id="v-pills-faturamento-tab" data-toggle="pill" href="#v-pills-faturamento" role="tab" aria-controls="v-pills-faturamento" aria-selected="false">Faturamento</a>
                  <a class="nave nav-link" id="v-pills-produto-tab" data-toggle="pill" href="#v-pills-produto" role="tab" aria-controls="v-pills-produto" aria-selected="false">Produto</a>
                  <a class="nave nav-link" id="v-pills-pedido-tab" data-toggle="pill" href="#v-pills-pedido" role="tab" aria-controls="v-pills-pedido" aria-selected="false">Pedido</a>
                  <a class="nave nav-link" id="v-pills-expedicao-tab" data-toggle="pill" href="#v-pills-expedicao" role="tab" aria-controls="v-pills-expedicao" aria-selected="false">Expedição</a>
                  <a class="nave nav-link" id="v-pills-sistema-tab" data-toggle="pill" href="#v-pills-sistema" role="tab" aria-controls="v-pills-sistema" aria-selected="false">Sistema</a>
                  <a class="nave nav-link" id="v-pills-entidade-tab" data-toggle="pill" href="#v-pills-entidade" role="tab" aria-controls="v-pills-entidade" aria-selected="false">Entidade</a>
                  <a class="nave nav-link" id="v-pills-pedidob2b-tab" data-toggle="pill" href="#v-pills-pedidob2b" role="tab" aria-controls="v-pills-pedidob2b" aria-selected="false">Pedido B2B</a>
                </div>
              </div>
              <div class="col-sm-9">
                <div class="tab-content" id="v-pills-tabContent">
                  <div class="tab-pane fade show active primary-color-dark semi-bold" id="v-pills-venda" role="tabpanel" aria-labelledby="v-pills-venda-tab">
                    <div id="loja_content">
                      <div class="card group-default">
                        <div class="card-header" id="param1" data-target="#collapse-param1" data-toggle="collapse">
                          <label for="loja_utiliza_barra_balanca">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param1">
                              01. Habilitar a opção de bipar barra com balança
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param1" class="collapse" aria-labelledby="param1" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Habilita a opção de quando bipada a barra, pegar o código do produto e peso da balança e automaticamente preencher os campos.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="loja_utiliza_barra_balanca" name="loja_utiliza_barra_balanca">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param2" data-target="#collapse-param2" data-toggle="collapse">
                          <label for="loja_deposito_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param2">
                              02. Depósito padrão para venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param2" class="collapse" aria-labelledby="param2" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Depósito padrão utilizado para validar estoque.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtDeposito">Depósito</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtDeposito" name="txtDeposito" class="form-control" placeholder="Depósito">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-deposito" name="btn-deposito" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-deposito" name="btn-limpa-deposito" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param3" data-target="#collapse-param3" data-toggle="collapse">
                          <label for="loja_deposito_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param3">
                              03. Tabela de preço padrão para venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param3" class="collapse" aria-labelledby="param3" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Tabela de preço padrão utilizada para determinar o preço de venda do produto.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtTabela">Tabela</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtTabela" name="txtTabela" class="form-control" placeholder="Tabela">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-tabela" name="btn-tabela" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-tabela" name="btn-limpa-tabela" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param4" data-target="#collapse-param4" data-toggle="collapse">
                          <label for="loja_cliente_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param4">
                              04. Cliente padrão para venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param4" class="collapse" aria-labelledby="param4" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Cliente padrão para já trazer preenchido ao efetuar uma venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtCliente">Cliente</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-cliente" name="btn-cliente" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-cliente" name="btn-limpa-cliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param5" data-target="#collapse-param5" data-toggle="collapse">
                          <label for="loja_controla_estoque">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param5">
                              05. Controle de Estoque
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param5" class="collapse" aria-labelledby="param5" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define como será o controle de estoque ao bipar o item na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="loja_controla_estoque" name="loja_controla_estoque">
                                <option value="0">Bloqueia estoque negativo</option>
                                <option value="1">Permite estoque negativo</option>
                                <option value="2">Permite estoque negativo sem mensagem</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param6" data-target="#collapse-param6" data-toggle="collapse">
                          <label for="loja_tipo_tabela">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param6">
                              06. Tipo de Tabela de Preço
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param6" class="collapse" aria-labelledby="param6" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define qual será o Tipo de Tabela de Preço utilizado na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="loja_tipo_tabela" name="loja_tipo_tabela">
                                <option value="0">Tabela de preço normal</option>
                                <option value="1">Tabela de preço por cor e tamanho</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param7" data-target="#collapse-param7" data-toggle="collapse">
                          <label for="loja_gerar_nfce">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param7">
                              07. Utiliza NFC-e
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param7" class="collapse" aria-labelledby="param7" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se a loja usa ou não a opção de NFC-e, e é possível ainda automatizar a geração.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="loja_gerar_nfce" name="loja_gerar_nfce">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                                <option value="2">Automático</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param8" data-target="#collapse-param8" data-toggle="collapse">
                          <label for="nfce_natureza_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param8">
                              08. Natureza padrão para NFC-e
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param8" class="collapse" aria-labelledby="param8" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Natureza padrão para já trazer preenchido ao gerar uma NFC-e.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtNaturezaNFCE">Natureza</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtNaturezaNFCE" name="txtNaturezaNFCE" class="form-control" placeholder="Natureza">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-NaturezaNFCE" name="btn-NaturezaNFCE" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-NaturezaNFCE" name="btn-limpa-NaturezaNFCE" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param9" data-target="#collapse-param9" data-toggle="collapse">
                          <label for="loja_ecf">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param9">
                              09. Utiliza Impressora Fiscal
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param9" class="collapse" aria-labelledby="param9" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se a loja usa ou não Impressora Fiscal. </br> Obs: Configurar porta da api do cupom no arquivo config.php.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="loja_ecf" name="loja_ecf">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <!-- // -->
                      <div class="card group-default">
                        <div class="card-header" id="param10" data-target="#collapse-param10" data-toggle="collapse">
                          <label for="loja_desc_super">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param10">
                              10. Solicitar senha de supervisor para dar desconto no item da venda.
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param10" class="collapse" aria-labelledby="param10" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se ao dar desconto em um item da venda, será solicitado senha de supervisor ou não.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="loja_desc_super" name="loja_desc_super">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <!-- // -->
                      <div class="card group-default d-none">
                        <!-- Removido parametro abaixo... -->
                        <div class="card-header" id="param11" data-target="#collapse-param11" data-toggle="collapse">
                          <label for="loja_desc_super_2">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param11">
                              11. Solicitar senha de supervisor para estornar/excluir item da venda.
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param11" class="collapse" aria-labelledby="param11" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se ao estornar/excluir um item da venda, será solicitado senha de supervisor ou não.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="loja_desc_super_2" name="loja_desc_super_2">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <!-- // -->
                      <div class="card group-default">
                        <div class="card-header" id="param12" data-target="#collapse-param12" data-toggle="collapse">
                          <label for="imprimir_cupom_gerencial">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param12">
                              12. Imprimir cupom gerencial
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param12" class="collapse" aria-labelledby="param12" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se após imprimir o cupom fiscal, será impresso um cupom gerencial da venda.<br>
                                  <b>OBS</b>: necessário configurar moeda para imprimir cupom gerencial.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="imprimir_cupom_gerencial" name="imprimir_cupom_gerencial">
                                <option value="0">Não</option>
                                <option value="1">Sim - Cupom de Recebimento </option>
                                <option value="2">Sim - Cupom de Itens </option>
                                <option value="3">Sim - Cupom Completo </option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param13" data-target="#collapse-param13" data-toggle="collapse">
                          <label for="utilizar_guia">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param13">
                              13. Utilizar Guia
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param13" class="collapse" aria-labelledby="param13" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se é utilizado o campo guia dentro da venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="utilizar_guia" name="utilizar_guia">
                                <option value="0">Não </option>
                                <option value="1">Sim </option>
                                <option value="2">Sim - Não obrigatório </option>
                                <option value="3">Sim - Considerar representante do cliente </option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param14" data-target="#collapse-param14" data-toggle="collapse">
                          <label for="obrigar_devolucao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param14">
                              14. Obrigar a associação de uma venda na devolução de um item
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param14" class="collapse" aria-labelledby="param14" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se é obrigatório informar o número da venda do item a ser devolvido na tela de devolução.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="obrigar_devolucao" name="obrigar_devolucao">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param15" data-target="#collapse-param15" data-toggle="collapse">
                          <label for="moeda_devolucao_automatica">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param15">
                              15. Moeda Troca Automática
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param15" class="collapse" aria-labelledby="param15" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Moeda de troca para utilizar antecipação automaticamente. <br>
                                  <b>OBS</b>: Necessário vincular uma condição de pagamento no cadastro dessa moeda.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtMoedaTroca">Moeda Troca</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtMoedaTroca" name="txtMoedaTroca" class="form-control" placeholder="Moeda">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-MoedaTroca" name="btn-MoedaTroca" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-MoedaTroca" name="btn-limpa-MoedaTroca" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param16" data-target="#collapse-param16" data-toggle="collapse">
                          <label for="txtMsgTrocaCabecario">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param16">
                              16. Mensagem cupom de troca (cabeçalho)
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param16" class="collapse" aria-labelledby="param16" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Mensagem do cabeçalho no cupom de troca.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-11">
                              <textarea style="resize: none" id="txtMsgTrocaCabecario" class="input-default focus form-control parametroVenda" rows="3">
                                                            </textarea>
                            </div>
                            <div class="col-sm-1">
                              <button id="btn-cabecario" class="btn btn-sm btn-danger d-none" title="Quebrar Linha"><i class="fas fa-level-down-alt"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param17" data-target="#collapse-param17" data-toggle="collapse">
                          <label for="txtMsgTrocaRodape">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param17">
                              17. Mensagem cupom de troca (rodapé)
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param17" class="collapse" aria-labelledby="param17" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Mensagem do rodapé no cupom de troca.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-11">
                              <textarea style="resize: none" id="txtMsgTrocaRodape" class="input-default focus form-control parametroVenda" rows="3">
                                                            </textarea>
                            </div>
                            <div class="col-sm-1">
                              <button id="btn-rodape" class="btn btn-sm btn-danger d-none" title="Quebrar Linha"><i class="fas fa-level-down-alt"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param22" data-target="#collapse-param22" data-toggle="collapse">
                          <label for="vendaProdutoMaterial">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param22">
                              18. Venda de Produto ou Material
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param22" class="collapse" aria-labelledby="param22" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Da prioridade nas pesquisas entre produto ou material na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="vendaProdutoMaterial" name="vendaProdutoMaterial">
                                <option value="0">Produto</option>
                                <option value="1">Material</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param18" data-target="#collapse-param18" data-toggle="collapse">
                          <label for="loja_gerar_nfce">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param18">
                              19. Utiliza CF-e
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param18" class="collapse" aria-labelledby="param18" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se a loja usa ou não a opção de CF-e SAT.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="loja_gerar_cfe" name="loja_gerar_cfe">
                                <option value="0">Não</option>
                                <option value="1">SAT</option>
                                <option value="3">SAT Automático</option>
                                <option value="2">MFE</option>
                                <option value="4">MFE Automático</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param19" data-target="#collapse-param19" data-toggle="collapse">
                          <label for="nfce_natureza_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param19">
                              20. Natureza padrão para CF-e
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param19" class="collapse" aria-labelledby="param19" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Natureza padrão para já trazer preenchido ao gerar uma CF-e.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtNaturezaCFe">Natureza</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtNaturezaCFe" name="txtNaturezaCFe" class="form-control" placeholder="Natureza">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-NaturezaCFe" name="btn-NaturezaCFe" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-NaturezaCFe" name="btn-limpa-NaturezaCFe" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param20" data-target="#collapse-param20" data-toggle="collapse">
                          <label for="nfe_venda">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param20">
                              21. NF-e na venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param20" class="collapse" aria-labelledby="param20" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se é possível faturar uma venda dentro da venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="nfe_venda" name="nfe_venda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param21" data-target="#collapse-param21" data-toggle="collapse">
                          <label for="qtde_venda">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param20">
                              22. Quantidade ao adicionar produto
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param21" class="collapse" aria-labelledby="param21" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Torna visível o campo de quantidade e define em qual campo focar ao adicionar produto.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="qtde_venda" name="qtde_venda">
                                <option value="0">Não</option>
                                <option value="1">Sim - Focar na Quantidade</option>
                                <option value="2">Sim - Focar na Barra</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <!-- pulado para id 23 pois o 22 foi usado na ordem incorreta -->
                      <div class="card group-default">
                        <div class="card-header" id="param23" data-target="#collapse-param23" data-toggle="collapse">
                          <label for="bloqueio_limite_credito">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param23">
                              23. Limite de crédito ao finalizar venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param23" class="collapse" aria-labelledby="param23" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define como o sistema deve tratar o limite de crédito do cliente na finalização da venda.
                                  <p><b style="font-size: 14px;">Moeda Tem que ser crediário ou cheque</b></p>
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="bloqueio_limite_credito" name="bloqueio_limite_credito">
                                <option value="0">Dar mensagem e permitir finalizar a venda</option>
                                <option value="1">Dar mensagem e bloquear a finalização da venda</option>
                                <option value="2">Dar mensagem e permitir apenas com senha de supervisor </option>
                                <option value="3">Não controlar </option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param24" data-target="#collapse-param24" data-toggle="collapse">
                          <label for="bloqueia_cliente_atrasado">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param24">
                              24. Cliente com duplicatas em atraso
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param24" class="collapse" aria-labelledby="param24" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se é possível fazer uma venda com um cliente que possui duplicatas em atraso.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="bloqueia_cliente_atrasado" name="bloqueia_cliente_atrasado">
                                <option value="0">Dar mensagem e permitir seguir</option>
                                <option value="1">Dar mensagem e bloquear</option>
                                <option value="2">Dar mensagem e permitir seguir apenas com senha de supervisor </option>
                                <option value="3">Não controlar </option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param25" data-target="#collapse-param25" data-toggle="collapse">
                          <label for="taxa_juros">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param25">
                              25. Taxa de juros duplicata
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param25" class="collapse" aria-labelledby="param25" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define de onde busca taxa de juros ao gerar as duplicatas da venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="taxa_juros" name="taxa_juros">
                                <option value="0"> </option>
                                <option value="1">Cadastro de empresa</option>
                                <option value="2">Cadastro de cliente</option>
                                <option value="3">Cadastro de moeda</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param26" data-target="#collapse-param26" data-toggle="collapse">
                          <label for="utiliza_pafConferencia">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param26">
                              26. Conferência de Venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param26" class="collapse" aria-labelledby="param26" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se é utilizado ou não conferência de venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="utiliza_pafConferencia" name="utiliza_pafConferencia">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="card group-default">
                        <div class="card-header" id="param28" data-target="#collapse-param28" data-toggle="collapse">
                          <label for="utiliza_acrescimoVenda">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param28">
                              27. Permite Acréscimo na venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param28" class="collapse" aria-labelledby="param28" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se é utilizado acréscimo ou não na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-3">
                              <select class="input-default parametroVenda" id="utiliza_acrescimoVenda" name="utiliza_acrescimoVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param29" data-target="#collapse-param29" data-toggle="collapse">
                          <label for="imprimir_venda">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param29">
                              28. Imprimir venda pendente
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param29" class="collapse" aria-labelledby="param29" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se vai imprimir a venda pendente.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="imprimir_venda" name="imprimir_venda">
                                <option value="0">Sempre imprimir</option>
                                <option value="1">Nunca imprimir</option>
                                <option value="2">Perguntar se deseja imprimir</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param30" data-target="#collapse-param30" data-toggle="collapse">
                          <label for="bloquear_consumidorFinal">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param30">
                              29. Lançar moeda do tipo crediário/cheque para Consumidor Final
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param30" class="collapse" aria-labelledby="param30" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se utiliza moeda do tipo crediário/cheque para Consumidor Final dentro da Venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="imprimir_venda" name="imprimir_venda">
                                <option value="0">Permitir</option>
                                <option value="1">Bloquear</option>
                                <option value="2">Perguntar se deseja lançar</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param31" data-target="#collapse-param31" data-toggle="collapse">
                          <label for="regra_promocao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param31">
                              30. Utiliza Regra de Promoção na Venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param31" class="collapse" aria-labelledby="param31" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se vai usar Regra de Promoção na Venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="regra_promocao" name="regra_promocao">
                                <option value="0">Não</option>
                                <option value="1">Sim - Regra definida na venda</option>
                                <option value="2">Sim - Validar todas as regras ativas</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param32" data-target="#collapse-param32" data-toggle="collapse">
                          <label for="">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param32">
                              31. Bloqueia fechamento de caixa com venda pendente
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param32" class="collapse" aria-labelledby="param32" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Não deixa fechar o caixa com venda pendente.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="" name="">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param34" data-target="#collapse-param34" data-toggle="collapse">
                          <label for="">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param34">
                              32. Permite informar valor de frete na venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param34" class="collapse" aria-labelledby="param34" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Informar valor de frete na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="" name="">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param35" data-target="#collapse-param35" data-toggle="collapse">
                          <label for="">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param35">
                              33. Permite cadastrar preço na tabela de preço
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param35" class="collapse" aria-labelledby="param35" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Permite cadastrar preço na tabela de preço.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="" name="">
                                <option value="0">Sim</option>
                                <option value="1">Não</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param36" data-target="#collapse-param36" data-toggle="collapse">
                          <label for="">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param36">
                              34. Descontar duplicatas em aberto ao finalizar uma devolução
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param36" class="collapse" aria-labelledby="param36" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Permite descontar as duplicatas em aberto ao finalizar a devolução.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="" name="">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param37" data-target="#collapse-param37" data-toggle="collapse">
                          <label for="imprimir_venda">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param37">
                              35. Imprimir Romaneio
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param37" class="collapse" aria-labelledby="param37" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se vai imprimir o romaneio.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="imprimir_vendaRomaneio" name="imprimir_vendaRomaneio">
                                <option value="0">Sempre imprimir</option>
                                <option value="1">Nunca imprimir</option>
                                <option value="2">Perguntar se deseja imprimir</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param37" data-target="#collapse-param38" data-toggle="collapse">
                          <label for="imprimir_venda">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param38">
                              36. Alterar Quantidade do item.
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param38" class="collapse" aria-labelledby="param38" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Habilita Opção para alterar quantidade do item.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="quantidadeGrid" name="quantidadeGrid">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param32" data-target="#collapse-param39" data-toggle="collapse">
                          <label for="">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param39">
                              37. Bloqueia fechamento de caixa com documento fiscal não transmitido
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param39" class="collapse" aria-labelledby="param39" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Não deixa fechar o caixa com venda sem documento fiscal vinculado ou com documento fiscal não transmitido.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="" name="">
                                <option value="0">Não</option>
                                <option value="1">Sim - Vendas sem documento fiscal vinculado ou documento fiscal não transmitido</option>
                                <option value="2">Sim - Somente documentos fiscais não transmitidos</option>
                                <option value="3">Sim - Vendas e Devoluções sem documento fiscal vinculado ou documento fiscal não transmitido</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param40" data-target="#collapse-param40" data-toggle="collapse">
                          <label for="utilizaStatus">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param40">
                              38. Utiliza Status
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param40" class="collapse" aria-labelledby="param40" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se é utilizado o campo status dentro da venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="utilizaStatus" name="utilizaStatus">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param40" data-target="#collapse-param41" data-toggle="collapse">
                          <label for="enviaReceberEmpDemo">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param41">
                              39. Envia receber para empresa demonstração
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param41" class="collapse" aria-labelledby="param41" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se o receber vai para a empresa de demonstração.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="enviaReceberEmpDemo" name="enviaReceberEmpDemo">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                                <option value="2">Sim - controle por moeda</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param42" data-target="#collapse-param42" data-toggle="collapse">
                          <label for="utilizaVendedorItem">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param42">
                              40. Utiliza Vendedor por Item
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param42" class="collapse" aria-labelledby="param42" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Habilita campo de vendedor na aba dos itens.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="utilizaVendedorItem" name="utilizaVendedorItem">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param43" data-target="#collapse-param43" data-toggle="collapse">
                          <label for="utilizaVendedorItem">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param43">
                              41. Cadastra cliente sem CPF/CNPJ
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param43" class="collapse" aria-labelledby="param43" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Permite Cadastrar cliente sem CPF/CNPJ.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="clienteSemCPFCNPJ" name="clienteSemCPFCNPJ">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param44" data-target="#collapse-param44" data-toggle="collapse">
                          <label for="utilizaVendedorItem">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param44">
                              42. Qualidade ao adicionar item na venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param44" class="collapse" aria-labelledby="param44" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Torna visível o campo de qualidade na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="qualidadeVenda" name="qualidadeVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param45" data-target="#collapse-param45" data-toggle="collapse">
                          <label for="utilizaVendedorItem">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param45">
                              43. Emite Bloco X
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param45" class="collapse" aria-labelledby="param45" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">

                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="emiteBlocoXautomatico" name="emiteBlocoXautomatico">
                                <option value="0">Não</option>
                                <option value="1">Sim - Redução Z</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param46" data-target="#collapse-param46" data-toggle="collapse">
                          <label for="utilizaVendedorItem">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param46">
                              44. Permite alterar o preço do item na venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param46" class="collapse" aria-labelledby="param46" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Permite alterar o preço do item na venda
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="permiteAlterarPreco" name="permiteAlterarPreco">
                                <option value="0">Não</option>
                                <option title="Ao selecionar essa opção, será possível alterar o preço dentro da opção 'Desconto' no menu ações do item, onde a diferença do preço original será aplicada como desconto." value="1">Sim - Aplicando desconto</option>
                                <option title="Ao selecionar essa opção, será disponibilizado uma opção 'Alterar Preço' no menu Ações do item, onde não será aplicado a diferença como desconto." value="2">Sim - Sem aplicar desconto</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param47" data-target="#collapse-param47" data-toggle="collapse">
                          <label for="habilitaPesquisaConferencia">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param46">
                              45. Habilita campo de pesquisa do Produto na hora da Conferência
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param47" class="collapse" aria-labelledby="param47" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Habilita campo de pesquisa do Produto na hora da Conferência
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="" name="">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param48" data-target="#collapse-param48" data-toggle="collapse">
                          <label for="habilitaPesquisaConferencia">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param46">
                              46. Não solicitar senha de supervisor ao cancelar uma venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param48" class="collapse" aria-labelledby="param48" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Não solicitar senha de supervisor ao cancelar uma venda
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda" id="" name="">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param49" data-target="#collapse-param49" data-toggle="collapse">
                          <label for="habilitaPesquisaConferencia">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param49">
                              47. Utiliza Barra Log
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param49" class="collapse" aria-labelledby="param49" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se a empresa utiliza Barra Log na venda
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param50" data-target="#collapse-param50" data-toggle="collapse">
                          <label for="nfe_operacao_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param50">
                              48. Operação padrão para NF-e (venda)
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param50" class="collapse" aria-labelledby="param50" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Operação padrão para já trazer preenchido ao gerar uma NF-e na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtOperacaoNFe">Operação</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtOperacaoNFe" name="txtOPeracaoNFe" class="form-control" placeholder="Operação">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-OperacaoNFe" name="btn-OperacaoNFCE" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-OperacaoNFe" name="btn-limpa-OperacaoNFe" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param51" data-target="#collapse-param51" data-toggle="collapse">
                          <label for="mostraCreditoVenda">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param51">
                              49. Mostrar crédito na venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param51" class="collapse" aria-labelledby="param51" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se vai mostrar todo o crédito do cliente na aba dos itens, ou apenas da última devolução.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Todo o crédito</option>
                                <option value="1">Apenas da última devolução</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param52" data-target="#collapse-param52" data-toggle="collapse">
                          <label for="permiteSelecionarAntecipacoes">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param52">
                              50. Permite selecionar antecipações
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param52" class="collapse" aria-labelledby="param52" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se o usuário poderá selecionar as antecipações ou usa conforme a ordem de emissão.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Usa antecipações conforme ordem de emissão</option>
                                <option value="1">Seleciona antecipações</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param53" data-target="#collapse-param53" data-toggle="collapse">
                          <label for="gerarAntecipacaoFrete">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param53">
                              51. Gerar Antecipação com valor de frete na venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param53" class="collapse" aria-labelledby="param53" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se vai gerar uma antecipação do contas a receber com o valor de frete na finalização da venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#collapse-param-venda-51" data-toggle="collapse">
                          <label for="clientePorEmpresa">
                            <span class="primary-color-dark semi-bold">
                              52. Cliente por Empresa
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param-venda-51" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se empresa irá utilizar cliente separado por empresa na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param56" data-target="#collapse-param56" data-toggle="collapse">
                          <label for="duplicata_cliente">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param56">
                              53. Gerar duplicata em nome do cliente
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param56" class="collapse" aria-labelledby="param56" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se vai gerar duplicata em nome do cliente quando for cartão de crédito na finalização da venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param58" data-target="#collapse-param58" data-toggle="collapse">
                          <label for="nfe_operacao_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param58">
                              54. Operação padrão para NF-e (devolução)
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param58" class="collapse" aria-labelledby="param58" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Operação padrão para já trazer preenchido ao gerar uma NF-e na devolução.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtOperacaoNFeDev">Operação</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtOperacaoNFeDev" name="txtOPeracaoNFeDev" class="form-control" placeholder="Operação">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-OperacaoNFeDev" name="btn-OperacaoNFCE" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-OperacaoNFeDev" name="btn-limpa-OperacaoNFeDev" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param59" data-target="#collapse-param59" data-toggle="collapse">
                          <label for="habilitaPesquisaConferencia">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param59">
                              55. Usuário pode consultar outros caixas
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param59" class="collapse" aria-labelledby="param59" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se o usuário pode pesquisar a venda de outros caixas
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                                <option value="2">Apenas caixas vinculados ao usuário</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param60" data-target="#collapse-param60" data-toggle="collapse">
                          <label for="bloqueiaDevolucaoSemNFE">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param60">
                              56. Bloquear devolução sem NF-e
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param60" class="collapse" aria-labelledby="param60" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se irá bloquear gravar devolução sem NF-e
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param61" data-target="#collapse-param61" data-toggle="collapse">
                          <label>
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param60">
                              57. Utiliza número de venda sequencial por dia
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param61" class="collapse" aria-labelledby="param61" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-sm-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se irá mostrar um número de venda sequencial reiniciado todos os dias
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param62" data-target="#collapse-param62" data-toggle="collapse">
                          <label for="nfce_operacao_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param62">
                              58. Operação padrão para NFC-e (venda)
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param62" class="collapse" aria-labelledby="param62" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Operação padrão para já trazer preenchido ao gerar uma NFC-e na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtOperacaoNFCe">Operação</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtOperacaoNFCe" name="txtOPeracaoNFCe" class="form-control" placeholder="Operação">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-OperacaoNFCe" name="btn-OperacaoNFCE" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-OperacaoNFCe" name="btn-limpa-OperacaoNFCe" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param63" data-target="#collapse-param63" data-toggle="collapse">
                          <label for="antecipacao_devolucao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param63">
                              59. Gerar antecipação ao efetuar devolução
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param63" class="collapse" aria-labelledby="param63" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se o sistema deve gerar antecipação ao efetuar uma devolução.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                                <option value="2">Fazer pergunta ao usuário</option>
                                <option value="3">Sim - gerar como tipo devolução</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param64" data-target="#collapse-param64" data-toggle="collapse">
                          <label for="vendedor_padrao_agrup">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param64">
                              60. Vendedor padrão para vendas agrupadas
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param64" class="collapse" aria-labelledby="param64" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Vendedor padrão para já trazer preenchido ao agrupar vendas.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtVendedorAgrup">Vendedor</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtVendedorAgrup" name="txtVendedorAgrup" class="form-control" placeholder="Vendedor">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-vendedorAgrup" name="btn-vendedorAgrup" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-vendedorAgrup" name="btn-limpa-vendedorAgrup" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param64" data-target="#collapse-param65" data-toggle="collapse">
                          <label for="vendedor_padrao_agrup">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param65">
                              61. Utiliza EPC na venda
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param65" class="collapse" aria-labelledby="param65" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Usa integração EPC na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-8">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Itag Monitor</option>
                                <option value="2">Contare</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param66" data-target="#collapse-param66" data-toggle="collapse">
                          <label for="vendedor_padrao_agrup">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param66">
                              62. Agrupamento de Itens
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param66" class="collapse" aria-labelledby="param66" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se ao registrar um novo item no loja e o mesmo já existir na lista de itens deve ser agrupado ou não.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param68" data-target="#collapse-param68" data-toggle="collapse">
                          <label for="antecipacao_outras_empresas">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param68">
                              63. Antecipações outras empresas
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param68" class="collapse" aria-labelledby="param68" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se poderá consultar antecipações de outras empresas.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#devolucao_sem_desconto_moeda" data-toggle="collapse">
                          <label>
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param68">
                              64. Considerar desconto nas formas de pagamento, ao buscar o preço do item na devolução.
                            </span>
                          </label>
                        </div>
                        <div id="devolucao_sem_desconto_moeda" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se o sistema deve considerar o desconto dado nas formas de pagamento da venda referenciada, para definir o preço do item que está sendo devolvido.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não considerar</option>
                                <option value="1">Considerar</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#caixa_cego" data-toggle="collapse">
                          <label>
                            <span class="primary-color-dark semi-bold">
                              65. Utiliza caixa cego para fechamento do caixa.
                            </span>
                          </label>
                        </div>
                        <div id="caixa_cego" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se é utilizado o processo de caixa cego para fechamento do caixa.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#consumidorFinalVenda" data-toggle="collapse">
                          <label>
                            <span class="primary-color-dark semi-bold">
                              66. Cliente pessoa física e consumidor final.
                            </span>
                          </label>
                        </div>
                        <div id="consumidorFinalVenda" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se a venda será feita somente com cliente do tipo pessoa física e selecionado como consumidor final.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#senhaSupervisorCaixa" aria-controls="collapse-param70" data-toggle="collapse">
                          <label>
                            <span class="primary-color-dark semi-bold">
                              67. Solicitar senha de supervisor ao entrar na tela de fechamento de caixa
                            </span>
                          </label>
                        </div>
                        <div id="senhaSupervisorCaixa" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text" aria-controls="collapse-param70">
                                  Define se a senha de supervisor será solicitada ao entrar na tela de fechamento de caixa
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" id="param71" data-target="#collapse-param71" data-toggle="collapse">
                          <label for="cfe_operacao_padrao">
                            <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param71">
                              68. Operação padrão para CF-e (venda)
                            </span>
                          </label>
                        </div>
                        <div id="collapse-param71" class="collapse" aria-labelledby="param71" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Operação padrão para já trazer preenchido ao gerar uma CF-e na venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-md-8">
                              <div class="form-group col-12">
                                <label data-error="wrong" data-success="right" for="txtOperacaoCFe">Operação</label>
                                <div class="input-group">
                                  <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtOperacaoCFe" name="txtOPeracaoCFe" class="form-control" placeholder="Operação">
                                  <div class="input-group-append">
                                    <button class="btn bg-danger" id="btn-OperacaoCFe" name="btn-OperacaoCFe" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                    <button class="btn bg-danger" id="btn-limpa-OperacaoCFe" name="btn-limpa-OperacaoCFe" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#integracaoIshopp" aria-controls="collapse-param72" data-toggle="collapse">
                          <label>
                            <span class="primary-color-dark semi-bold">
                              69. Integração iShopp (iBASi)
                            </span>
                          </label>
                        </div>
                        <div id="integracaoIshopp" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text" aria-controls="collapse-param72">
                                  Define se contém integração com sistema iShopp (iBASi)
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                                <option value="2">Sim (Apenas as vendas com guia)</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#integracaoNetShopping" aria-controls="collapse-param73" data-toggle="collapse">
                          <label>
                            <span class="primary-color-dark semi-bold">
                              70. Integração NetShopping
                            </span>
                          </label>
                        </div>
                        <div id="integracaoNetShopping" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text" aria-controls="collapse-param73">
                                  Define se contém integração com sistema NetShopping
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#integracaoTeiaCard" aria-controls="collapse-param75" data-toggle="collapse">
                          <label>
                            <span class="primary-color-dark semi-bold">
                              71. Integração TeiaCard
                            </span>
                          </label>
                        </div>
                        <div id="integracaoTeiaCard" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text" aria-controls="collapse-param75">
                                  Define se contém integração com sistema TeiaCard
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#tipoVendaPadrao" aria-controls="collapse-param76" data-toggle="collapse">
                          <label>
                            <span class="primary-color-dark semi-bold">
                              72. Tipo venda padrão
                            </span>
                          </label>
                        </div>
                        <div id="tipoVendaPadrao" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <label data-error="wrong" data-success="right" for="txtTipoVendaPadrao">Tipo venda padrão ao iniciar uma venda</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control validate parametroVenda" required="required" id="txtTipoVendaPadrao" name="txtTipoVendaPadrao" class="form-control" placeholder="Tipo Venda Padrão">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-TipoVendaPadrao" name="btn-TipoVendaPadrao" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-TipoVendaPadrao" name="btn-limpa-TipoVendaPadrao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#utiliza_cashback" data-toggle="collapse">
                          <label>
                            <span class="primary-color-dark semi-bold">
                              73. Utiliza Cashback
                            </span>
                          </label>
                        </div>
                        <div id="utiliza_cashback" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se a empresa utiliza sistema de cashback para atribuir descontos ao cliente.
                                </span>
                                <br>OBS: É necessário configurar os valores padrões para definir algumas configurações necessárias.
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim - Normal</option>
                                <option value="2">Sim - CRM&Bônus</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#devolucaoConsignado" data-toggle="collapse">
                          <label>
                            <span class="primary-color-dark semi-bold">
                              74. Devolução de Consignado
                            </span>
                          </label>
                        </div>
                        <div id="devolucaoConsignado" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se irá permitir fazer devolução de consignado na tela de agrupamento de venda.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Liberado</option>
                                <option value="1">Dar mensagem e solicitar senha de supervisor</option>
                                <option value="2">Dar mensagem e bloqueia</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#tipoBalanca" data-toggle="collapse">
                          <label>
                            <span class="primary-color-dark semi-bold">
                              75. Utiliza balança ACBr
                            </span>
                          </label>
                        </div>
                        <div id="tipoBalanca" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se irá utilizar balança ACBr.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Balança Padrão</option>
                                <option value="1">Balança ACBr</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#bloqueiaVendaItemSemTabPreco" data-toggle="collapse">
                          <label>
                            <span class="primary-color-dark semi-bold">
                              76. Bloqueia venda com item sem cadastro na tabela de preço
                            </span>
                          </label>
                        </div>
                        <div id="bloqueiaVendaItemSemTabPreco" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Define se bloqueia adicionar um item sem cadastro na tabela de preço.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="card group-default">
                        <div class="card-header" data-target="#bloqueiaVendaPendenteMesmoCliente" data-toggle="collapse">
                          <label>
                            <span class="primary-color-dark semi-bold">
                              77. Bloqueia venda caso houver consignado/venda pendente para o cliente
                            </span>
                          </label>
                        </div>
                        <div id="bloqueiaVendaPendenteMesmoCliente" class="collapse" data-parent="#loja_content">
                          <div class="card-body row">
                            <div class="col-md-12">
                              <small class="sub-label mt-null bottom-small-spacing">
                                <span class="text">
                                  Bloqueia criar nova venda para um cliente que já contém consignado/venda pendente.
                                </span>
                              </small>
                            </div>
                            <div class="col-sm-5">
                              <select class="input-default parametroVenda">
                                <option value="0">Não</option>
                                <option value="1">Sim</option>
                              </select>
                            </div>
                          </div>
                        </div>
                      </div>

                    </div>
                  </div>
                  <div class="tab-pane fade" id="v-pills-receber" role="tabpanel" aria-labelledby="v-pills-receber-tab">
                    <div class="card group-default">
                      <div class="card-header" id="param27" data-target="#collapse-param27" data-toggle="collapse">
                        <label for="lanca_baixa_caixa_receber">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param27">
                            01. Lançar baixa do receber no caixa
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param27" class="collapse" aria-labelledby="param27" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Traz marcado o campo 'Lançar no caixa' por padrão ao realizar uma baixa.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="lanca_baixa_caixa_receber" name="lanca_baixa_caixa_receber">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param28" data-target="#collapse-param28" data-toggle="collapse">
                        <label for="cupom_gerencial_receber">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param28">
                            02. Impressão de relatório gerencial ao baixar duplicata
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param28" class="collapse" aria-labelledby="param28" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se deve ser impresso um relatório gerencial ao baixar uma duplicata.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="cupom_gerencial_receber" name="cupom_gerencial_receber">
                              <option value="0">Não</option>
                              <option value="1">Sim - 1 via</option>
                              <option value="2">Sim - 2 vias</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="param29" data-target="#collapse-param29" data-toggle="collapse">
                        <label for="BuscaAntecipacao">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param29">
                            03. Busca antecipações da empresa demo na venda
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param29" class="collapse" aria-labelledby="param29" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Busca antecipações da empresa demo na venda
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="BuscaAntecipacao" name="BuscaAntecipacao">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="param30" data-target="#collapse-param30" data-toggle="collapse">
                        <label for="GeraCaixaCheque">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param30">
                            04. Ao cadastrar cheque lançar no caixa do loja
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param30" class="collapse" aria-labelledby="param30" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Ao cadastrar cheque irá fazer a pergunta se deseja lançar no caixa do loja.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="GeraCaixaCheque" name="GeraCaixaCheque">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>

                      <div class="card-header" id="paramRec4" data-target="#collapse-paramRec4" data-toggle="collapse">
                        <label for="valida_credito_cliente">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramRec4">
                            05. Ao cadastrar cheque validar crédito de cliente.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramRec4" class="collapse" aria-labelledby="paramRec4" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se irá validar limite de crédito disponível para o cliente.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="valida_credito_cliente" name="valida_credito_cliente">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>

                      <div class="card-header" id="paramRec5" data-target="#collapse-paramRec5" data-toggle="collapse">
                        <label for="valida_credito_grupo">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramRec5">
                            06. Ao cadastrar cheque validar crédito de grupo.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramRec5" class="collapse" aria-labelledby="paramRec5" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se irá validar limite de crédito disponível para o grupo.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="valida_credito_grupo" name="valida_credito_grupo">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                      <div class="card-header" id="paramRec6" data-target="#collapse-paramRec6" data-toggle="collapse">
                        <label for="bloqueia_conta_corrente">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramRec6">
                            07. Não permite baixar receber sem lançar no conta corrente.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramRec6" class="collapse" aria-labelledby="paramRec6" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se o flag será bloqueado ou liberado.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroReceber" id="bloqueia_conta_corrente" name="bloqueia_conta_corrente">
                              <option value="0">Selecione uma opção</option>
                              <option value="1">B - Marcado e Bloqueado (não pode desmarcar)</option>
                              <option value="2">L - Marcado e Liberado (pode desmarcar)</option>
                              <option value="3">D - Desmarcado e Bloqueado (não pode desmarcar)</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade" id="v-pills-faturamento" role="tabpanel" aria-labelledby="v-pills-faturamento-tab">
                    <div class="card group-default">
                      <div class="card-header" id="param33" data-target="#collapse-param33" data-toggle="collapse">
                        <label for="calcula_peso_faturamento">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param33">
                            01. Calcular peso dos itens
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param33" class="collapse" aria-labelledby="param33" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Calcula automaticamente o peso bruto e líquido no faturamento.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="calcula_peso_faturamento" name="calcula_peso_faturamento">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param43" data-target="#collapse-param43" data-toggle="collapse">
                        <label for="faturamento_automatico">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param43">
                            02. Faturamento automático
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param43" class="collapse" aria-labelledby="param43" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Gerar/Imprimir nota automaticamente ao gravar o faturamento.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="faturamento_automatico" name="faturamento_automatico">
                              <option value="0">Não</option>
                              <option value="1">Gerar</option>
                              <option value="2">Gerar e imprimir</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param51" data-target="#collapse-param51" data-toggle="collapse">
                        <label for="certificado_a3">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param51">
                            03. Utiliza certificado A3.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param51" class="collapse" aria-labelledby="param51" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Pede senha para utilizar certificado. (Obs: Quando o parâmetro estiver "Sim" irá buscar os inis de NFE e NFCE do mesmo diretório onde está a ApiLocal.)
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="certificado_a3" name="certificado_a3">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param54" data-target="#collapse-param54" data-toggle="collapse">
                        <label for="indice_fat">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param54">
                            04. Utiliza índice
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param54" class="collapse" aria-labelledby="param54" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Utiliza percentual de índice ao faturar.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="indice_fat" name="indice_fat">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param55" data-target="#collapse-param55" data-toggle="collapse">
                        <label for="fat_val_liq">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param55">
                            05. Fatura venda com valor líquido
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param55" class="collapse" aria-labelledby="param55" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Utiliza valor líquido dos itens para faturar.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="fat_val_liq" name="fat_val_liq">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param73" data-target="#collapse-param73" data-toggle="collapse">
                        <label for="endentregadados_fat">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param73">
                            06. Endereço de Entrega nos Dados Adicionais
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param73" class="collapse" aria-labelledby="param73" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Destaca o endereço de entrega na nota fiscal após o faturamento
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="endentregadados_fat" name="endentregadados_fat">
                              <option value="0">Não destaca</option>
                              <option value="1">Destaca nos dados adicionais</option>
                              <option value="2">Destaca nos dados adicionais somente se o endereço for diferente do endereço de entrega</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param74" data-target="#collapse-param74" data-toggle="collapse">
                        <label for="obspedidodados_fat">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param74">
                            07. Observação do Pedido nos Dados Adicionais
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param74" class="collapse" aria-labelledby="param74" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Adiciona a observação do pedido nos dados adicionais da nota.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="obspedidodados_fat" name="obspedidodados_fat">
                              <option value="0">Não destaca</option>
                              <option value="1">Destaca nos dados adicionais</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param75" data-target="#collapse-param75" data-toggle="collapse">
                        <label for="emailTransmissao">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param75">
                            08. Enviar e-mail após transmitir a nota.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param75" class="collapse" aria-labelledby="param75" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Enviar e-mail após transmitir a nota.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroFaturamento" id="emailTransmissao" name="emailTransmissao">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade" id="v-pills-produto" role="tabpanel" aria-labelledby="v-pills-produto-tab">
                    <div class="card group-default">
                      <div class="card-header" id="param201" data-target="#collapse-param201" data-toggle="collapse">
                        <label for="calcula_peso_produto">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param201">
                            01. Atualiza preço ao gravar produto
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param201" class="collapse" aria-labelledby="param201" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Atualiza o preço do produto na tabela de preço padrão ao gravar (inclusão ou alteração).
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroProduto" id="calcula_peso_produto" name="calcula_peso_produto">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade" id="v-pills-pedido" role="tabpanel" aria-labelledby="v-pills-pedido-tab">
                    <div class="card group-default">
                      <div class="card-header" id="param200" data-target="#collapse-param200" data-toggle="collapse">
                        <label for="busca_preco_cor_tam">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param33">
                            01. Considerar a busca do preço por cor e tamanho.
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param200" class="collapse" aria-labelledby="param200" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Ao inserir um produto na tela de pedido, irá realizar a busca nos preços por cor e tamanho.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedido" id="busca_preco_cor_tam" name="busca_preco_cor_tam">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade" id="v-pills-expedicao" role="tabpanel" aria-labelledby="v-pills-expedicao-tab">
                    <div class="card group-default">
                      <div class="card-header" id="param57" data-target="#collapse-param57" data-toggle="collapse">
                        <label for="fatura_expedicao_parcial">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param57">
                            01. Fatura expedição parcial
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param57" class="collapse" aria-labelledby="param57" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Cria NF-e mesmo que nem todos os itens da expedição tenham sido bipados.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroExpedicao" id="fatura_expedicao_parcial" name="fatura_expedicao_parcial">
                              <option value="0">Não</option>
                              <option value="2">Não permite gravar expedição parcial</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param62" data-target="#collapse-param62" data-toggle="collapse">
                        <label for="cancela_expedicao_pendente">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param62">
                            02. Cancela sobras da expedição
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param62" class="collapse" aria-labelledby="param62" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Na expedição parcial, cancelar a quantidade que ficar pendente.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroExpedicao" id="cancela_expedicao_pendente" name="cancela_expedicao_pendente">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param63" data-target="#collapse-param63" data-toggle="collapse">
                        <label for="painel_conferencia_caixas">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param63">
                            03. Conferência de caixas no embarque
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param63" class="collapse" aria-labelledby="param63" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Habilita painel para realizar a conferência de caixas na tela de embarque
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroExpedicao" id="painel_conferencia_caixas" name="painel_conferencia_caixas">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param65" data-target="#collapse-param65" data-toggle="collapse">
                        <label for="painel_layout_nfe">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param65">
                            04. Layout de impressão de NF-e da expedição
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param65" class="collapse" aria-labelledby="param65" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define qual layout de NF-e será impresso na expedição
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroExpedicao" id="painel_conferencia_caixas" name="painel_conferencia_caixas">
                              <option value="0">NF-e</option>
                              <option value="1">NF-e Simplificada</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param67" data-target="#collapse-param67" data-toggle="collapse">
                        <label for="param_status_saida">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param67">
                            05. Status destino após liberar expedição
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param67" class="collapse" aria-labelledby="param67" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define o status que será alterado o pedido ao liberá-lo para expedição.
                              </span>
                            </small>
                          </div>
                          <div class="col-md-8">
                            <div class="form-group col-12">
                              <label data-error="wrong" data-success="right" for="txtStatus">Status</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control validate parametroExpedicao" required="required" id="txtStatus" name="txtStatus" class="form-control" placeholder="Status">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-Status" name="btn-Status" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-Status" name="btn-limpa-Status" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param69" data-target="#collapse-param69" data-toggle="collapse">
                        <label for="define_volumes_manualmente">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param69">
                            06. Define volumes manualmente
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param69" class="collapse" aria-labelledby="param69" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Habilita campo volumes dentro da expedição.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroExpedicao" id="define_volumes_manualmente" name="define_volumes_manualmente">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" id="param77" data-target="#collapse-param77" data-toggle="collapse">
                        <label for="controla_estoque_exp">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param77">
                            07. Controla estoque ao expedir
                          </span>
                        </label>
                      </div>
                      <div id="collapse-param77" class="collapse" aria-labelledby="param77" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Valida estoque ao bipar os itens da expedição.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroExpedicao" id="controla_estoque_exp" name="controla_estoque_exp">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                  </div>

                  <div class="tab-pane fade" id="v-pills-sistema" role="tabpanel" aria-labelledby="v-pills-sistema-tab">
                    <div class="card group-default">
                      <div class="card-header" id="paramsis1" data-target="#collapse-paramsis1" data-toggle="collapse">
                        <label for="utiliza_barra_log_sistema">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramsis1">
                            01. Empresa utiliza Barralog
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramsis1" class="collapse" aria-labelledby="paramsis1" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se a empresa utiliza BarraLog, utilizado nas telas com opção de bipagem (menos loja).
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroSistema" id="utiliza_barra_log_sistema" name="utiliza_barra_log_sistema">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" data-target="#collapse-sistema-02" data-toggle="collapse">
                        <label>
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param68">
                            02. Quantidade de casas decimais que a empresa trabalha
                          </span>
                        </label>
                      </div>
                      <div id="collapse-sistema-02" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define a quantidade de casas decimais que a empresa trabalha (venda, faturamento, nfce...)
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-5">
                            <select class="input-default parametroSistema">
                              <option value="0">2 casas decimais</option>
                              <option value="1">3 casas decimais</option>
                              <option value="2">4 casas decimais</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" data-target="#collapse-sistema-03" data-toggle="collapse">
                        <label>
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-param68">
                            03. Filtrar apenas clientes vinculados ao Representante
                          </span>
                        </label>
                      </div>
                      <div id="collapse-sistema-03" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define que irá apenas mostrar clientes vinculados ao representante informado no cadastro de usuário.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroSistema">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>


                  <div class="tab-pane fade" id="v-pills-entidade" role="tabpanel" aria-labelledby="v-pills-entidade-tab">
                    <div class="card group-default">
                      <div class="card-header" id="paramEnt1" data-target="#collapse-paramEnt1" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramEnt1">
                            01. Permitir alterar Limite de Crédito na Entidade
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramEnt1" class="collapse" aria-labelledby="paramEnt1" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se será permitido alterar o campo Limite de Crédito na aba venda do cadastro de entidade.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroEntidade" id="altera_limite_credito" name="altera_limite_credito">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="card group-default">
                      <div class="card-header" data-target="#collapse-paramEnt2" data-toggle="collapse">
                        <label>
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramEnt2">
                            02. Permitir alterar Limite Fidelidade na Entidade
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramEnt2" class="collapse" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se será permitido alterar o campo Limite Fidelidade na aba venda do cadastro de entidade.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroEntidade" id="altera_limite_fidelidade" name="altera_limite_fidelidade">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <div class="tab-pane fade" id="v-pills-pedidob2b" role="tabpanel" aria-labelledby="v-pills-pedidob2b-tab">
                    <div class="card group-default">
                      <div class="card-header" id="paramPedidob2b1" data-target="#collapse-paramPedidob2b1" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramPedidob2b1">
                            01. Cliente com duplicatas em atraso
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramPedidob2b1" class="collapse" aria-labelledby="paramPedidob2b1" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se irá mostrar as duplicatas em atraso do cliente.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedidob2b" id="dupli_atraso" name="dupli_atraso">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="paramPedidob2b2" data-target="#collapse-paramPedidob2b2" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramPedidob2b2">
                            02. Permite editar campos Responsável e Vendedor vinculados ao usuário
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramPedidob2b2" class="collapse" aria-labelledby="paramPedidob2b2" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se o usuário pode alterar o Responsável e Vendedor vinculados.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedidob2b" id="alteraCamposVinculados" name="alteraCamposVinculados">
                              <option value="0">Não</option>
                              <option value="1">Sim</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="paramPedidob2b3" data-target="#collapse-paramPedidob2b3" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramPedidob2b3">
                            03. Permite alterar Tabela de Preço
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramPedidob2b3" class="collapse" aria-labelledby="paramPedidob2b3" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define se o usuário pode alterar a Tabela de Preço.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedidob2b" id="bloqueiaCampos" name="bloqueiaCampos">
                              <option value="0">Campo Inativo para Alteração</option>
                              <option value="1">Qualquer usuário pode alterar</option>
                              <option value="2">Alteração apenas por nível Master</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="paramPedidob2b4" data-target="#collapse-paramPedidob2b4" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramPedidob2b4">
                            04. Tabela de preço padrão
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramPedidob2b4" class="collapse" aria-labelledby="paramPedidob2b4" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-md-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define a tabela padrão ao iniciar um atendimento B2B.
                              </span>
                            </small>
                          </div>
                          <div class="col-md-8">
                            <div class="form-group col-12">
                              <label data-error="wrong" data-success="right" for="txtTabela">Tabela</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control validate parametroPedidob2b" required="required" id="txtTabela-b2b" name="txtTabela-b2b" class="form-control" placeholder="Tabela">
                                <div class="input-group-append">
                                  <button class="btn bg-danger" id="btn-tabela-b2b" name="btn-tabela-b2b" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                  <button class="btn bg-danger" id="btn-limpa-tabela-b2b" name="btn-limpa-tabela-b2b" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="paramPedidob2b5" data-target="#collapse-paramPedidob2b5" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramPedidob2b5">
                            05. Busca tabela de preço
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramPedidob2b5" class="collapse" aria-labelledby="paramPedidob2b5" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define de onde irá buscar a tabela de preço automaticamente ao iniciar um atendimento.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <select class="input-default parametroPedidob2b" id="buscaTabelaRepresentante" name="buscaTabelaRepresentante">
                              <option value="0"> Não busca automaticamente</option>
                              <option value="1"> Vinculada ao Representante</option>
                              <option value="2"> Padrão Comercial</option>
                              <option value="3"> Vinculada ao Cliente</option>
                              <option value="4"> Informada no Parâmetro</option>
                            </select>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="card group-default">
                      <div class="card-header" id="paramPedidob2b6" data-target="#collapse-paramPedidob2b6" data-toggle="collapse">
                        <label for="altera_limite_credito">
                          <span class="primary-color-dark semi-bold" aria-expanded="true" aria-controls="collapse-paramPedidob2b6">
                            06. Prazo máximo vencimento do cheque
                          </span>
                        </label>
                      </div>
                      <div id="collapse-paramPedidob2b6" class="collapse" aria-labelledby="paramPedidob2b6" data-parent="#loja_content">
                        <div class="card-body row">
                          <div class="col-sm-12">
                            <small class="sub-label mt-null bottom-small-spacing">
                              <span class="text">
                                Define quantos dias o cheque ficara como vencido.
                              </span>
                            </small>
                          </div>
                          <div class="col-sm-3">
                            <div class="form-group col-12">
                              <label data-error="wrong" data-success="right" for="txtDiasVencimentoCheque">Dias:</label>
                              <div class="input-group">
                                <input type="text" autocomplete="off" class="input-default focus form-control validate parametroPedidob2b" required="required" id="txtDiasVencimentoCheque" name="txtDiasVencimentoCheque" class="form-control" placeholder="Dias">
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>

                  </div>
                  <div class="clearfix pt-2 float-right">
                    <button id="btnSalvar" class="btn btn-danger btn-sisp relative"><i class="fas fa-save"></i> Salvar</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
      <!-- /.content -->
    </div>

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
      <!-- Control sidebar content goes here -->
    </aside>
    <!-- /.content-wrapper -->
    <?php
    include_once('../../footer.php');
    ?>
    <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->

  <!-- jQuery -->
  <script src="<?php echo BASE_URI; ?>/plugins/jquery/jquery.min.js?versao=3.237.18.2"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="<?php echo BASE_URI; ?>/plugins/jquery-ui/jquery-ui.min.js?versao=3.237.18.2"></script>
  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    if ($('[type="date"]').prop('type') != 'date') {
      $('[type="date"]').datepicker();
    }
    $.widget.bridge('uibutton', $.ui.button)
  </script>

  <!-- Bootstrap 4 -->
  <script src="<?php echo BASE_URI; ?>/plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.237.18.2"></script>
  <!-- ChartJS -->
  <script src="<?php echo BASE_URI; ?>/plugins/chart.js/Chart.min.js?versao=3.237.18.2"></script>
  <!-- Sparkline -->

  <script src="plugins/toastr/toastr.min.js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/loadingoverlay.min.js?versao=3.237.18.2"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/sisplan.js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/utils/funcoes.js?versao=3.237.18.2"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/adminlte.min.js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/jquery.dataTables.min.js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/dataTables.bootstrap4.min.js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="<?php echo BASE_URI; ?>/dist/js/sum().js?versao=3.237.18.2"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/dataTables.keyTable.js?versao=3.237.18.2"></script>
  <script src="<?php echo BASE_URI; ?>/dist/js/requisicoes.js?versao=3.237.18.2"></script>
  <script src="<?php echo BASE_URI; ?>/utils/cookies.js?versao=3.237.18.2"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = "<?php echo BASE_URI; ?>/login"
        return;
      }

      const empId = getCookie('emp_id');
      const temAcesso = await temAcessoTela('PARAMETROS');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, "<?php echo BASE_URI; ?>");
        return;
      }

      $('#txtMsgTrocaRodape').on('keypress', function(e) {
        if (e.keyCode == 13) {
          $('#btn-rodape').trigger('click');
        }
      });

      $('#txtMsgTrocaCabecario').on('keypress', function(e) {
        if (e.keyCode == 13) {
          $('#btn-cabecario').trigger('click');
        }
      });

      $('#btn-rodape').on('click', function() {
        $('#txtMsgTrocaRodape').val($('#txtMsgTrocaRodape').val().trim() + '\n');
        $('#txtMsgTrocaRodape').focus();
      });

      $('#btn-cabecario').on('click', function() {
        $('#txtMsgTrocaCabecario').val($('#txtMsgTrocaCabecario').val().trim() + '\n');
        $('#txtMsgTrocaCabecario').focus();
      });

      //carrega parametros
      $.LoadingOverlay("show");
      try {
        try {
          const parametrosLoja = await BuscaParametrosLoja();
          const parametrosReceber = await BuscaParametrosReceber();
          const parametrosFaturamento = await BuscaParametrosFaturamento();
          const parametrosProduto = await BuscaParametrosProduto();
          const parametrosExpedicao = await BuscaParametrosExpedicao();
          const parametrosSistema = await BuscaParametrosSistema();
          const parametrosEntidade = await BuscaParametrosEntidade();
          const parametrosPedidoB2B = await BuscaParametrosPedidoB2B();
          for (let i = 0; i < parametrosLoja.length; i++) {
            $($(`.parametroVenda`)[i]).val(parametrosLoja[i].VALOR);
          }
          for (let i = 0; i < parametrosReceber.length; i++) {
            $($(`.parametroReceber`)[i]).val(parametrosReceber[i].VALOR);
          }
          for (let i = 0; i < parametrosFaturamento.length; i++) {
            $($(`.parametroFaturamento`)[i]).val(parametrosFaturamento[i].VALOR);
          }
          for (let i = 0; i < parametrosExpedicao.length; i++) {
            $($(`.parametroExpedicao`)[i]).val(parametrosExpedicao[i].VALOR);
          }
          for (let i = 0; i < parametrosSistema.length; i++) {
            $($(`.parametroSistema`)[i]).val(parametrosSistema[i].VALOR);
          }
          for (let i = 0; i < parametrosEntidade.length; i++) {
            $($(`.parametroEntidade`)[i]).val(parametrosEntidade[i].VALOR);
          }
          for (let i = 0; i < parametrosPedidoB2B.length; i++) {
            $($(`.parametroPedidob2b`)[i]).val(parametrosPedidoB2B[i].VALOR);
          }
          for (let i = 0; i < parametrosProduto.length; i++) {
            $($(`.parametroProduto`)[i]).val(parametrosProduto[i].VALOR);
          }
        } catch (error) {
          console.error(error);
        }
      } finally {
        $.LoadingOverlay("hide");
      }

      $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"deposito", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
      $('#txtTabela').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao descricao"], "where": null}`);
      $('#txtTabela-b2b').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao descricao"], "where": null}`);
      $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
      $('#txtVendedorAgrup').autocompleta(3, `JSON={ "tabela":"represen", "camposSelect":[ "codrep chave", "nome descricao"], "where": null}`);
      $('#txtNaturezaNFCE').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":[ "natureza chave", "descricao descricao"], "where": null}`);
      $('#txtNaturezaCFe').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":[ "natureza chave", "descricao descricao"], "where": null}`);
      $('#txtMoedaTroca').autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":[ "codmoe chave", "descricao"], "where": null}`);
      $('#txtOperacaoNFe').autocompleta(1, `JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
      $('#txtTipoVendaPadrao').autocompleta(1, `JSON={ "tabela":"venda_tipo", "camposSelect":[ "id chave", "descricao"], "where": null}`);
      $('#txtOperacaoNFeDev').autocompleta(1, `JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
      $('#txtOperacaoNFCe').autocompleta(1, `JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
      $('#txtOperacaoCFe').autocompleta(1, `JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
      $('#txtStatus').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);

      $('#btn-deposito').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"deposito", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Depósito', 'deposito');
      $('#btn-tabela').pesquisa('#txtTabela', 'REGIAO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"]}`, 'Pesquisa Tabela', 'regiao');
      $('#btn-tabela-b2b').pesquisa('#txtTabela-b2b', 'REGIAO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"]}`, 'Pesquisa Tabela', 'regiao');
      $('#btn-cliente').pesquisa('#txtCliente', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome", "cnpj"]}`, 'Pesquisa Cliente', 'entidade');
      $('#btn-vendedorAgrup').pesquisa('#txtVendedorAgrup', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome"]}`, 'Pesquisa Representante', 'represen');
      $('#btn-NaturezaNFCE').pesquisa('#txtNaturezaNFCE', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao"]}`, 'Pesquisa Natureza', 'natureza');
      $('#btn-NaturezaCFe').pesquisa('#txtNaturezaCFe', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao"]}`, 'Pesquisa Natureza', 'natureza');
      $('#btn-MoedaTroca').pesquisa('#txtMoedaTroca', 'CODMOE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao"]}`, 'Pesquisa Moeda', 'moeda');
      $('#btn-OperacaoNFe').pesquisa('#txtOperacaoNFe', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Operacao Fiscal', 'Operacao Fiscal');
      $('#btn-TipoVendaPadrao').pesquisa('#txtTipoVendaPadrao', 'ID', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"venda_tipo", "camposSelect":[ "id", "descricao"]}`, 'Pesquisa Tipo Venda', 'Tipo Venda');
      $('#btn-OperacaoNFeDev').pesquisa('#txtOperacaoNFeDev', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Operacao Fiscal', 'Operacao Fiscal');
      $('#btn-OperacaoNFCe').pesquisa('#txtOperacaoNFCe', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Operacao Fiscal', 'Operacao Fiscal');
      $('#btn-OperacaoCFe').pesquisa('#txtOperacaoCFe', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Operacao Fiscal', 'Operacao Fiscal');
      $('#btn-Status').pesquisa('#txtStatus', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Status', 'SITPROD');

      $('#btn-limpa-Status').on('click', function() {
        $('#txtStatus').val('');
      });

      $('#btn-limpa-NaturezaNFCE').on('click', function() {
        $('#txtNaturezaNFCE').val('');
      });
      $('#btn-limpa-NaturezaCFe').on('click', function() {
        $('#txtNaturezaCFe').val('');
      });
      $('#btn-limpa-tabela').on('click', function() {
        $('#txtTabela').val('');
      });

      $('#btn-limpa-tabela-b2b').on('click', function() {
        $('#txtTabela-b2b').val('');
      });

      $('#btn-limpa-MoedaTroca').on('click', function() {
        $('#txtMoedaTroca').val('');
      });

      $('#btn-limpa-vendedorAgrup').on('click', function() {
        $('#txtVendedorAgrup').val('');
      });

      $('#btn-limpa-deposito').on('click', function() {
        $('#txtDeposito').val('');
      });

      $('#btn-limpa-cliente').on('click', function() {
        $('#txtCliente').val('');
      });

      $('#btn-limpa-OperacaoNFe').on('click', function() {
        $('#txtOperacaoNFe').val('');
      });

      $('#btn-limpa-TipoVendaPadrao').on('click', function() {
        $('#txtTipoVendaPadrao').val('');
      });

      $('#btn-limpa-OperacaoNFeDev').on('click', function() {
        $('#txtOperacaoNFeDev').val('');
      });

      $('#btn-limpa-OperacaoNFCe').on('click', function() {
        $('#txtOperacaoNFCe').val('');
      });

      $('#btn-limpa-OperacaoCFe').on('click', function() {
        $('#txtOperacaoCFe').val('');
      });

      //salva parametros
      $('#btnSalvar').on('click', async function() {
        try {
          $.LoadingOverlay("show");

          let parametrosObj = [];

          for (let i = 0; i < $('.parametroVenda').length; i++) {
            const objeto = {
              TIPO: 'VENDA',
              POSICAO: i,
              VALOR: $($(`.parametroVenda`)[i]).val(),
              EMP_ID: empId,
              DESCRICAO: $($(`.parametroVenda`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroVenda`)[i])[0][$($(`.parametroVenda`)[i]).val()].text : ''
            };
            parametrosObj.push(objeto);
          }

          for (let i = 0; i < $('.parametroReceber').length; i++) {
            const objeto = {
              TIPO: 'RECEBER',
              POSICAO: i,
              VALOR: $($(`.parametroReceber`)[i]).val(),
              EMP_ID: empId,
              DESCRICAO: $($(`.parametroReceber`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroReceber`)[i])[0][$($(`.parametroReceber`)[i]).val()].text : ''
            };
            parametrosObj.push(objeto);
          }

          for (let i = 0; i < $('.parametroFaturamento').length; i++) {
            const objeto = {
              TIPO: 'FATURAMENTO',
              POSICAO: i,
              VALOR: $($(`.parametroFaturamento`)[i]).val(),
              EMP_ID: empId,
              DESCRICAO: $($(`.parametroFaturamento`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroFaturamento`)[i])[0][$($(`.parametroFaturamento`)[i]).val()].text : ''
            };
            parametrosObj.push(objeto);
          }

          for (let i = 0; i < $('.parametroProduto').length; i++) {
            const objeto = {
              TIPO: 'PRODUTO',
              POSICAO: i,
              VALOR: $($(`.parametroProduto`)[i]).val(),
              EMP_ID: empId,
              DESCRICAO: $($(`.parametroProduto`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroProduto`)[i])[0][$($(`.parametroProduto`)[i]).val()].text : ''
            };
            parametrosObj.push(objeto);
          }

          for (let i = 0; i < $('.parametroPedido').length; i++) {
            const objeto = {
              TIPO: 'PEDIDO',
              POSICAO: i,
              VALOR: $($(`.parametroPedido`)[i]).val(),
              EMP_ID: empId,
              DESCRICAO: $($(`.parametroPedido`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroPedido`)[i])[0][$($(`.parametroPedido`)[i]).val()].text : ''
            };
            parametrosObj.push(objeto);
          }

          for (let i = 0; i < $('.parametroExpedicao').length; i++) {
            const objeto = {
              TIPO: 'EXPEDICAO',
              POSICAO: i,
              VALOR: $($(`.parametroExpedicao`)[i]).val(),
              EMP_ID: empId,
              DESCRICAO: $($(`.parametroExpedicao`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroExpedicao`)[i])[0][$($(`.parametroExpedicao`)[i]).val()].text : ''
            };
            parametrosObj.push(objeto);
          }

          for (let i = 0; i < $('.parametroSistema').length; i++) {
            const objeto = {
              TIPO: 'SISTEMA',
              POSICAO: i,
              VALOR: $($(`.parametroSistema`)[i]).val(),
              EMP_ID: empId,
              DESCRICAO: $($(`.parametroSistema`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroSistema`)[i])[0][$($(`.parametroSistema`)[i]).val()].text : ''
            };
            parametrosObj.push(objeto);
          }

          for (let i = 0; i < $('.parametroEntidade').length; i++) {
            const objeto = {
              TIPO: 'ENTIDADE',
              POSICAO: i,
              VALOR: $($(`.parametroEntidade`)[i]).val(),
              EMP_ID: empId,
              DESCRICAO: $($(`.parametroEntidade`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroEntidade`)[i])[0][$($(`.parametroEntidade`)[i]).val()].text : ''
            };
            parametrosObj.push(objeto);
          }

          for (let i = 0; i < $('.parametroPedidob2b').length; i++) {
            const objeto = {
              TIPO: 'PEDIDOB2B',
              POSICAO: i,
              VALOR: $($(`.parametroPedidob2b`)[i]).val(),
              EMP_ID: empId,
              DESCRICAO: $($(`.parametroPedidob2b`)[i]).prop('tagName') == 'SELECT' ? $($(`.parametroPedidob2b`)[i])[0][$($(`.parametroPedidob2b`)[i]).val()].text : ''
            };
            parametrosObj.push(objeto);
          }

          const parametros = {
            parametros: parametrosObj
          };

          try {
            await SalvaParametro(parametros);
            msgSucesso('Parâmetros gravados com sucesso.');
          } catch (error) {
            msgErro(error);
            console.error(error);
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      });
    });
  </script>
</body>

</html>