$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
      onNext: (Element) => {
        if ((Element.node.id == 'avancar1')) {
          $('#avancar1').trigger('click');
        };
      }
    });

    driver.defineSteps([{
      element: '#formcard1',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para o cadastro.',
        position: 'top'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "left",
      },
    },
    {
      element: '#avancar1',
      popover: {
        title: 'Botão Avançar',
        description: 'Clique aqui para ir para a próxima aba.',
        position: 'left'
      }
    },
    {
      element: '#formcard2',
      popover: {
        title: 'Setores',
        description: 'Aqui estão os setores cadastrados neste fluxo',
        position: 'top'
      }
    },
    {
      element: '#btnAddSetor',
      popover: {
        title: 'Adicionar Setor',
        description: 'Este botão é utilizado para adicionar um setor.',
        position: 'top'
      }
    },
    {
      element: '#voltar2',
      popover: {
        title: 'Botão Voltar',
        description: 'Clique aqui para voltar a página anterior.',
        position: 'top'
      }
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar os dados.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  $('#msform').validate({
    debug: false,
    ignore: "",
    rules: {
      txtCodigo: {
        required: true,
      },
      txtDescricao: {
        required: true,
      }
    },
    messages: {
      txtCodigo: {
        required: "É necessário informar um código."
      },
      txtDescricao: {
        required: "É necessário informar uma descrição."
      }
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight(element) {
      $(element).addClass('is-invalid');
    },
    unhighlight(element) {
      $(element).removeClass('is-invalid');
    }
  });

  let contaFs = 1;
  $('#account').css('cursor', 'pointer');
  $('#payment').css('cursor', 'pointer');

  $(".next").click(function () {
    contaFs += 1;

    let validator = $("#msform").validate();
    validator.form();
    let erros = 0;
    erros = validator.numberOfInvalids();

    if (erros == 0) {
      currentFs = $(this).parent();
      nextFs = $(this).parent().next();

      $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

      nextFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;

            currentFs.css({
              display: "none",
              position: "relative",
            });
            nextFs.css({
              opacity,
            });
          },
          duration: 600,
        }
      );
    }
  });

  $(".previous").click(function () {
    contaFs -= 1;

    currentFs = $(this).parent();
    previousFs = $(this).parent().prev();
    $("#progressbar li")
      .eq($("fieldset").index(currentFs))
      .removeClass("active");
    previousFs.show();
    currentFs.animate(
      {
        opacity: 0,
      },
      {
        step(now) {
          opacity = 1 - now;
          currentFs.css({
            display: "none",
            position: "relative",
          });
          previousFs.css({
            opacity,
          });
        },
        duration: 600,
      }
    );
  });

  $('#account').on('click', function () {
    if (codfluxo != 'create') {
      if (contaFs == 2) {
        $('#voltar').trigger('click');
      } else
        if (contaFs == 2) {
          $('#voltar2').trigger('click');
        }
    }
  });

  $('#payment').on('click', function () {
    if (codfluxo != 'create') {
      if (contaFs == 1) {
        $('#avancar1').trigger('click');
      } else
        if (contaFs == 2) {
          $('#voltar2').trigger('click');
        }
    }
  });

  let queryString = window.location.href;
  let parametros = queryString.split('/');
  let codfluxo = parametros[parametros.length - 1];

  if (codfluxo != 'create') {
    $('#txtCodigo').prop('disabled', true);
  }

  await buscaDados();

  $('#btnVoltar').on('click', async function () {
    // await deletaRegistro("ORDEMPRODUCAO", getCookie("usuario"), parametros[5]);
    window.location.href = `${BASE_URI}/fluxo`;
  });

  $('#txtSetor').autocompleta(1, `JSON={ "tabela": "cadfluxo", "camposSelect": ["codigo chave", "descricao descricao"], "where": ["ATIVO <> 'N'"] }`);
  $('#txtCodigoImportar').autocompleta(1, `JSON={ "tabela": "roteiro", "camposSelect": ["codigo chave", "descricao descricao"], "where": ["ATIVO <> 'N'"] }`);

  $('#btn-Setor').pesquisa_serverside(['#txtSetor'], ['CODIGO'], ['DESCRICAO'], `{"tabela":"cadfluxo", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["ATIVO <> 'N'"]}`, 'Pesquisa Setor');
  $('#btnCodigoImportar').pesquisa_serverside(['#txtCodigoImportar'], ['CODIGO'], ['DESCRICAO'], `{"tabela":"roteiro", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ["ATIVO <> 'N'"]}`, 'Pesquisa Fluxo');

  $('#btn-limpa-Setor').on('click', function () {
    $('#txtSetor').val('');
  });

  $('#btnLimpaImportar').on('click', function () {
    $('#txtCodigoImportar').val('');
  });

  async function buscaDados() {

    try {
      $.LoadingOverlay('show');
      try {

        criaTabelaSetores();

        const pesquisa = await buscaValor('ROTEIRO', 'DESCRICAO', 'CODIGO', codfluxo);

        let descricao;
        if (pesquisa != undefined) {
          descricao = pesquisa.DESCRICAO;
        } else {
          return;
        }

        let baixalivre = await buscaValor('ROTEIRO', 'BAIXALIVRE', 'CODIGO', codfluxo);

        if (baixalivre != undefined) {
          baixalivre = baixalivre.BAIXALIVRE;
        }

        let ativo = await buscaValor('ROTEIRO', 'ATIVO', 'CODIGO', codfluxo);

        if (ativo != undefined) {
          ativo = ativo.ATIVO;
        }

        $('#txtCodigo').val(codfluxo);
        $('#txtDescricao').val(descricao);
        $('#checkBaixas').prop('checked', baixalivre == 'S' ? true : false);
        $('#checkAtivo').prop('checked', ativo == 'S' ? true : false);

        const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
          `JSON={ "tabela":"FLUXO",
              "camposSelect":["FLUXO.ORDEM, FLUXO.SETOR, FLUXO.DESCRICAO"],
              "where": ["FLUXO.CODIGO = '${codfluxo}'"],
              "orderby": ["FLUXO.ORDEM"]}`, null);

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        if (jsonStr.RESULT[0].length == 0) {
          return;
        }

        criaTabelaSetores(jsonStr.RESULT[0]);

      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível buscar os dados: ${error}`);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  function criaTabelaSetores(data = null) {

    $('#tabelaSetores').DataTable().rows().remove();

    $('#tabelaSetores').DataTable({
      paging: false,
      lengthChange: false,
      info: false,
      order: false,
      destroy: true,
      autowidth: true,
      bFilter: false,
      "language": {
        "sEmptyTable": "Nenhum registro encontrado",
        "sInfo": "_TOTAL_ registros",
        "sInfoEmpty": " 0 registros",
        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhum registro encontrado",
        "sSearch": "Pesquisar",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      },
    });

    if (data != null && data != undefined && data != '') {
      data.forEach((e, i) => {
        $('#tabelaSetores').DataTable().row.add([
          `<div class="icheck-primary d-inline m-0 p-0">
          <input class="inputSel" type="checkbox" id="check_${i}">
          <label for="check_${i}"></label>
        </div>`,
          e.ORDEM,
          e.SETOR,
          e.DESCRICAO
        ]).draw(false);
      });
    };
  };

  $('#btnAddSetor').on('click', function () {

    if ($('#checkAtivo').prop('checked') == false) {
      msgErro('Não é possível realizar a manutenção dos setores se o fluxo estiver inativo. Favor ir na aba dados e ativar o fluxo.');
      return;
    }

    const novoSetor = pegaChave('#txtSetor');

    if (novoSetor == '' || novoSetor == undefined || novoSetor == null) {
      msgErro('É necessário informar um setor, favor verificar')
      return;
    };

    const novaDescricao = pegaDescricao('#txtSetor');
    const data = $('#tabelaSetores').DataTable().data();

    let listaSetores = [];

    data.map(e => {
      listaSetores.push(e[2]);
    });

    if (listaSetores.indexOf(novoSetor) != -1) {
      msgErro('Setor já existente, favor verificar.')
      return;
    }

    adicionaSetor(data, novoSetor, novaDescricao);
  });

  function adicionaSetor(data, codigo, descricao) {
    $.LoadingOverlay('show');
    const ordem = retornaProximaOrdem();

    let dados = [];

    data.map(e => {
      dados.push({
        ORDEM: e[1],
        SETOR: e[2],
        DESCRICAO: e[3]
      });
    });

    dados.push({
      ORDEM: ordem,
      SETOR: codigo,
      DESCRICAO: descricao
    });

    criaTabelaSetores(dados);

    $('#btn-limpa-Setor').trigger('click');
    $.LoadingOverlay('hide');
  };

  function retornaProximaOrdem() {
    let ordensAtuais = [];

    const data = $('#tabelaSetores').DataTable().data();

    data.map(e => {
      ordensAtuais.push(parseInt(e[1]));
    });

    const ordemMaximaAtual = Math.max(...ordensAtuais);

    if (ordemMaximaAtual == '-Infinity') {
      return 1;
    }

    return ordemMaximaAtual + 1;
  };

  $('#btnExcluirSetor').on('click', async function () {

    if ($('#checkAtivo').prop('checked') == false) {
      msgErro('Não é possível realizar a manutenção dos setores se o fluxo estiver inativo. Favor ir na aba dados e ativar o fluxo.');
      return;
    };

    const setoresSelecionados = $('#tabelaSetores').DataTable().rows(
      $($('input[class=inputSel]:checked').closest('tr'))
    ).data().toArray().map(
      dados => "'" + dados[2] + "'"
    ).toString();

    if (setoresSelecionados.length == 0) {
      msgErro('Nenhum setor selecionado, favor verificar.');
      return;
    };

    const validaFaccao = await buscaValor('FACCAO', 'FLUXO', 'FLUXO', codfluxo);

    if (validaFaccao != undefined) {
      msgErro('Setor é utilizado na facção, impossível continuar.')
      return;
    };

    msgAlerta('Deseja mesmo excluir os setores selecionados?', () => {
      excluiSetores();
    });
  });

  function excluiSetores() {
    $.LoadingOverlay('show');
    $("#tabelaSetores").DataTable().rows($($("input[class=inputSel]:checked").closest("tr"))).remove().draw(false);
    ajustaOrdem();
    $.LoadingOverlay('hide');
  };

  function ajustaOrdem() {
    const rowsCount = $("#tabelaSetores").DataTable().rows().count();

    for (let i = 0; i < rowsCount; i++) {
      $("#tabelaSetores").DataTable().cell(i, 1).data(i + 1);
    }
  };

  $('#btnSobeAlterarOrdem').on('click', function () {

    if ($('#checkAtivo').prop('checked') == false) {
      msgErro('Não é possível realizar a manutenção dos setores se o fluxo estiver inativo. Favor ir na aba dados e ativar o fluxo.');
      return;
    }

    if ($("input[class=inputSel]:checked").length == 0) {
      msgAlerta("Nenhum setor selecionado para alterar a ordem, favor verificar.");
      return;
    }

    if ($("input[class=inputSel]:checked").length != 1) {
      msgAlerta("Para alterar a ordem, somente um setor pode estar selecionado, favor verificar.");
      return;
    }

    sobeRegistro();
  });

  function sobeRegistro() {
    const registroAlterarOrdem = $("#tabelaSetores").DataTable().rows($($("input[class=inputSel]:checked").closest("tr"))).data().toArray()[0];

    if (registroAlterarOrdem[1] == 1) {
      msgAlerta("O setor já está na primeira posição!");
      return;
    };

    const indexRegistroAcima = $("#tabelaSetores").DataTable().data().toArray().findIndex(function (obj) { return obj[1] === registroAlterarOrdem[1] - 1; });
    const registroAcima = $("#tabelaSetores").DataTable().row(indexRegistroAcima).data();

    $("#tabelaSetores").DataTable().row(indexRegistroAcima).data(registroAlterarOrdem).draw(false);
    $("#tabelaSetores").DataTable().row(registroAlterarOrdem[1] - 1).data(registroAcima).draw(false);
    $($(".inputSel")[indexRegistroAcima]).prop("checked", true);
    ajustaOrdem();
  };

  $("#btnDesceAlterarOrdem").on("click", function () {

    if ($('#checkAtivo').prop('checked') == false) {
      msgErro('Não é possível realizar a manutenção dos setores se o fluxo estiver inativo. Favor ir na aba dados e ativar o fluxo.');
      return;
    }

    if ($("input[class=inputSel]:checked").length == 0) {
      msgAlerta("Nenhum setor selecionado para alterar a ordem, favor verificar.");
      return;
    }

    if ($("input[class=inputSel]:checked").length != 1) {
      msgAlerta("Para alterar a ordem, somente um setor pode estar selecionado, favor verificar.");
      return;
    }

    desceRegistro();
  });

  function desceRegistro() {
    const ultimaOrdem = $("#tabelaSetores").DataTable().rows().count();
    const registroAlterarOrdem = $("#tabelaSetores").DataTable().rows($($("input[class=inputSel]:checked").closest("tr"))).data().toArray()[0];

    if (registroAlterarOrdem[1] == ultimaOrdem) {
      throw msgAlerta("O setor já está na última posição!");
    }

    const indexRegistroAbaixo = $("#tabelaSetores").DataTable().data().toArray().findIndex(function (obj) { return obj[1] === registroAlterarOrdem[1] + 1 });
    const registroAbaixo = $("#tabelaSetores").DataTable().row(indexRegistroAbaixo).data();

    $("#tabelaSetores").DataTable().row(indexRegistroAbaixo).data(registroAlterarOrdem).draw(false);
    $("#tabelaSetores").DataTable().row(registroAlterarOrdem[1] - 1).data(registroAbaixo).draw(false);
    $($(".inputSel")[indexRegistroAbaixo]).prop("checked", true);
    ajustaOrdem();
  };

  $('#btnGravar').on('click', async function () {

    if ($('#txtCodigo').val() == '') {
      msgErro('É necessário informar um código, favor verificar.');
      return;
    };

    if ($('#txtDescricao').val() == '') {
      msgErro('É necessário informar uma descrição, favor verificar.');
      return;
    };

    const numeroSetores = $('#tabelaSetores').DataTable().data().length;

    if (numeroSetores == 1) {
      msgErro('Não é possível gravar o fluxo com somente um setor, favor verificar.');
      return;
    };

    await validaFaccao();

  });

  async function validaFaccao() {
    try {
      $.LoadingOverlay('show');
      try {
        const faccao = await buscaValor('FACCAO', 'FLUXO', 'FLUXO', $('#txtCodigo').val());

        if (faccao != undefined) {
          msgAlerta('Atenção! Fluxo está sendo utilizado na facção. Continuar o procedimento poderá resultar em erros irreversíveis. Deseja continuar?',
            async () => {
              await validaAgendamento()
            },
            () => {
              return;
            }
          );
          return;
        } else {
          await validaAgendamento();
        }
      } catch (e) {
        console.error(e);
        msgErro(`Não foi possível validar os dados: ${e}`);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function validaAgendamento() {

    let setorAgendamento = await buscaValor('CADFLUXO', 'CODIGO, DESCRICAO', 'CALC_AGENDAMENTO', 'S');
    let descricaoAgendamento;

    if (setorAgendamento != undefined) {
      setorAgendamento = setorAgendamento.CODIGO;
      descricaoAgendamento = setorAgendamento.DESCRICAO;
    };

    const data = $('#tabelaSetores').DataTable().data();
    let listaSetores = [];

    if (data.length > 0) {
      data.map(e => {
        listaSetores.push(
          e[2]
        );
      });
    };

    if (setorAgendamento != undefined && listaSetores.indexOf(setorAgendamento) == -1) {
      msgAlerta(`Fluxo não possui o setor ${setorAgendamento} - ${descricaoAgendamento}, utilizado como referência para cálculo no agendamento. Deseja continuar?`,
        async () => {
          await confirmaGravarDados();
        },
        () => {
          return;
        });
      return;
    } else {
      await confirmaGravarDados();
    }
  };

  async function confirmaGravarDados() {
    msgAlerta('Deseja gravar os dados?', async () => {
      await gravaDados();
    });
  };

  async function gravaDados() {
    try {
      $.LoadingOverlay('show');
      try {
        let obj = {};

        obj.CODIGO = $('#txtCodigo').val();
        obj.DESCRICAO = $('#txtDescricao').val();
        obj.BAIXALIVRE = $('#checkBaixas').prop('checked') == true ? 'S' : 'N';
        obj.ATIVO = $('#checkAtivo').prop('checked') == true ? 'S' : 'N';
        obj.SETORES = retornaSetoresGravar();

        const response = await requisicao("POST", `/sisplan/facfluxo/v1/fluxo?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`, `JSON=${encodeURIComponent(JSON.stringify(obj))}`);

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgAlerta(jsonStr.mensagem);
          return;
        }

        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/fluxo`;
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível gravar os dados: ${error}`);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  function retornaSetoresGravar() {
    const data = $('#tabelaSetores').DataTable().data();
    const codigo = $('#txtCodigo').val();

    let setores = [];

    data.map(e => {
      setores.push(
        {
          CODIGO: codigo,
          DESCRICAO: e[3],
          ORDEM: e[1],
          SETOR: e[2]
        }
      )
    });

    return setores;
  };

  $('#avancar1').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        if (codfluxo == 'create') {
          let codigo = $('#txtCodigo').val();

          const validaCodigo = await buscaValor('ROTEIRO', 'CODIGO', 'CODIGO', codigo);

          if (validaCodigo != undefined) {
            msgErro('Código já cadastrado, favor verificar.');
            $('#txtCodigo').focus();
            $('#voltar2').trigger('click');
            return;
          };
        }
      } catch (e) {
        console.error(e);
        msgErro(`Não foi possível buscar os dados: ${e}`);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnImportar').on('click', function () {
    if ($('#checkAtivo').prop('checked') == false) {
      msgErro('Não é possível realizar a manutenção dos setores se o fluxo estiver inativo. Favor ir na aba dados e ativar o fluxo.');
      return;
    };

    $.LoadingOverlay('show');
    criaTabelaImportar();
    $('#modalImportar').modal('show');
    $.LoadingOverlay('hide');
  });

  function criaTabelaImportar(data = null) {

    $('#tabelaImportar').DataTable().rows().remove();

    $('#tabelaImportar').DataTable({
      paging: false,
      lengthChange: false,
      info: false,
      order: false,
      destroy: true,
      autowidth: true,
      bFilter: false,
      "language": {
        "sEmptyTable": "Nenhum registro encontrado",
        "sInfo": "_TOTAL_ registros",
        "sInfoEmpty": " 0 registros",
        "sInfoFiltered": "(Filtrados de _MAX_ registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhum registro encontrado",
        "sSearch": "Pesquisar",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      },
    });

    if (data != undefined && data != null && data != '') {
      data.map(e => {
        $('#tabelaImportar').DataTable().row.add([
          e.ORDEM,
          e.SETOR,
          e.DESCRICAO
        ]).draw(false);
      }
      )
    }
  };

  $('#btnConsultarImportar').on('click', async function () {
    if ($('#txtCodigoImportar').val() == '') {
      msgErro('É necessário informar um fluxo para consultar, favor verificar.');
      return;
    }

    await consultarImportar();
  });

  async function consultarImportar() {
    try {
      $.LoadingOverlay('show');
      try {
        const codigo = pegaChave('#txtCodigoImportar');

        const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
          `JSON={ "tabela":"FLUXO",
              "camposSelect":["FLUXO.ORDEM, FLUXO.SETOR, FLUXO.DESCRICAO"],
              "where": ["FLUXO.CODIGO = '${codigo}'"],
              "orderby": ["FLUXO.ORDEM"]}`, null);

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        if (jsonStr.RESULT[0].length == 0) {
          return;
        }

        criaTabelaImportar(jsonStr.RESULT[0]);

      } catch (e) {
        console.error(e);
        msgErro(`Não foi possível buscar os dados: ${e}`);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  $('#btnCancelarImportar').on('click', function () {
    $('#modalImportar').modal('hide');
  });

  $('#btnConfirmarImportar').on('click', function () {
    if ($('#tabelaImportar').DataTable().data().length == 0) {
      msgErro('Não foram encontrados setores para este fluxo, favor verificar.')
      return;
    };

    confirmaImportarFluxo();
  });

  function confirmaImportarFluxo() {
    try {
      $.LoadingOverlay('show');

      const data = $('#tabelaImportar').DataTable().data();

      let listaSetores = [];

      data.map(e => {
        listaSetores.push({
          ORDEM: e[0],
          SETOR: e[1],
          DESCRICAO: e[2]
        });
      });

      criaTabelaSetores(listaSetores);
    } finally {
      $('#btnLimpaImportar').trigger('click');
      $('#modalImportar').modal('hide');
      $.LoadingOverlay('hide');
    }
  };

  $('#btnProdFluxo').on('click', async function () {
    if ($('#checkAtivo').prop('checked') == false) {
      msgErro('Não é possível realizar a manutenção dos setores se o fluxo estiver inativo. Favor ir na aba dados e ativar o fluxo.');
      return;
    };

    $.LoadingOverlay('show');
    await buscaDadosProdFluxo();
    $('#modalProdFluxo').modal('show');
    $.LoadingOverlay('hide');
  });

  async function buscaDadosProdFluxo() {
    try {
      $.LoadingOverlay('show');
      try {

        const codigo = codfluxo;

        const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
          `JSON={ "tabela":"PRO_FLUXO",
              "camposSelect":["PRO_FLUXO.CODIGO, PRODUTO.DESCRICAO"],
              "innerjoin": [{
                "tabela": "PRODUTO", "condicao": "PRO_FLUXO.CODIGO = PRODUTO.CODIGO"
              }]
              "where": ["PRO_FLUXO.FLUXO = '${codigo}'"],
              "orderby": ["PRO_FLUXO.CODIGO"]}`, null);

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        $('#tabelaProdFluxo').DataTable().rows().remove();

        $('#tabelaProdFluxo').DataTable({
          paging: false,
          lengthChange: false,
          info: false,
          order: false,
          destroy: true,
          autowidth: true,
          bFilter: false,
          "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
              "sNext": "Próximo",
              "sPrevious": "Anterior",
              "sFirst": "Primeiro",
              "sLast": "Último"
            },
            "oAria": {
              "sSortAscending": ": Ordenar colunas de forma ascendente",
              "sSortDescending": ": Ordenar colunas de forma descendente"
            }
          },
        });

        if (jsonStr.RESULT[0].length == 0) {
          return;
        };

        const data = jsonStr.RESULT[0];

        if (data != null && data != undefined && data != '') {
          data.forEach((e, i) => {
            $('#tabelaProdFluxo').DataTable().row.add([
              `<div class="icheck-primary d-inline m-0 p-0">
                <input class="inputSelProdFluxo" type="checkbox" id="checkprod_${i}">
                <label for="checkprod_${i}"></label>
              </div>`,
              e.CODIGO,
              e.DESCRICAO
            ]).draw(false);
          });
        };

      } catch (e) {
        console.error(e);
        msgErro(`Não foi possível buscar os dados: ${e}`);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  $('#btnConfirmarProdFluxo').on('click', function () {
    const produtosSelecionados = $('#tabelaProdFluxo').DataTable().rows(
      $($('input[class=inputSelProdFluxo]:checked').closest('tr'))
    ).data().toArray().map(
      dados => "'" + dados[1] + "'"
    ).toString();

    if (produtosSelecionados.length == 0) {
      msgErro('Nenhum produto selecionado, favor verificar.');
      return;
    };

    msgAlerta('Deseja mesmo atualizar os produtos selecionados?', async () => {
      await atualizaFluxoProduto(produtosSelecionados);
    });
  });

  async function atualizaFluxoProduto(codigos) {
    try {
      $.LoadingOverlay('show');
      try {
        codigos = codigos.replaceAll(`'`, '');
        let listaCodigos = codigos.split(',');

        let obj = {};

        obj.CODIGOS = listaCodigos;
        obj.FLUXO = $('#txtCodigo').val();
        obj.SETORES = retornaSetoresGravar();

        const response = await requisicao("POST", `/sisplan/facfluxo/v1/atualizaprofluxo?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`, `JSON=${encodeURIComponent(JSON.stringify(obj))}`);

        if (!response) {
          return;
        };

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgAlerta(jsonStr.mensagem);
          return;
        };

        toastr.success("Dados gravados com sucesso!", "Confirmação", {
          toastClass: "alert",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/fluxo`;
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (e) {
        console.error(e);
        msgErro(`Não foi possível buscar os dados: ${e}`);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  $('#btnCancelarProdFluxo').on('click', function () {
    $('#modalProdFluxo').modal('hide');
  });

});