$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
    });
    driver.defineSteps([{
      element: '#dataInvIni',
      popover: {
        title: 'Campo Período inventário início',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'bottom'
      }
    },
    {
      element: '#dataInvFim',
      popover: {
        title: 'Campo Período inventário fim',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'bottom'
      }
    },
    {
      element: '#txtQualidade',
      popover: {
        title: 'Campo Qualidade',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtDeposito',
      popover: {
        title: 'Campo Depósito',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#btnConsultar',
      popover: {
        title: 'Botão Cosultar',
        description: 'Clique aqui para consultar os dados informados.',
        position: 'left'
      }
    },
    {
      element: '#btnImprimir',
      popover: {
        title: 'Botão Imprimir',
        description: 'Clique aqui para imprimir os dados.',
        position: 'left'
      }
    },
    {
        element: '#tabela-produtos_wrapper',
        popover: {
            title: 'Itens',
            description: `Aqui estão os itens da consulta. Obs:               
                          QTDE_MOV = quantidade da PA_MOV;         
                          QTDE_EST = quantidade da PA_ITEN;          
                          DIFERENCA = diferença entre os campos QTDE_INV e QTDE_EST.`,
            position: 'top'
        }
    },
    {
      element: '#txtTpBaixa',
      popover: {
        title: 'Campo Tipo de baixa',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#btnAcertarEstoque',
      popover: {
        title: 'Botão Acertar Estoque',
        description: 'Clique aqui para acertar o estoque.',
        position: 'left'
      }
    }
    ]);
    driver.start();
  });
});


$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("CONFERENCIAINV");

  $('#msform').validate({
    ignore: "",
    rules: {
      txtDocumento: {
        required: true,
      },
      txtTipoEntrada: {
        required: true,
      },
      txtQualidade: {
        required: true,
      },
      txtDeposito: {
        required: true,
      }
    },
    messages: {
      txtDocumento: {
        required: "Gere um documento para continuar."
      },
      txtTipoEntrada: {
        required: "Informe um tipo de entrada."
      },
      txtQualidade: {
        required: "Informe uma qualidade."
      },
      txtDeposito: {
        required: "Informe um depósito."
      }
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight(element, errorClass, validClass) {
      $(element).addClass('is-invalid');
    },
    unhighlight(element, errorClass, validClass) {
      $(element).removeClass('is-invalid');
    },
    async submitHandler(form, event) {
      event.preventDefault();
    }
  });

  await setarDataAtual('dataInvIni');
  await setarDataAtual('dataInvFim');

  $('#txtSetor').autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnSetor').pesquisa_array(['#txtSetor'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADFLUXO", "camposSelect":[ "codigo", "descricao" ], "where": null}', 'Pesquisa Setor', 'CADFLUXO');
  $('#btnASetor').on('click', function () { $('#txtSetor').val(''); });

  $('#txtProduto').autocompleta(3, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnProduto').pesquisa_array(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRODUTO", "camposSelect":[ "codigo", "descricao" ], "where": null}', 'Pesquisa Produto', 'PRODUTO');
  $('#btnAProduto').on('click', function () { $('#txtProduto').val(''); });

  $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnCor').pesquisa_array(['#txtCor'], ['COR'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADCOR", "camposSelect":[ "COR", "descricao" ], "where": null}', 'Pesquisa Cor', 'CADCOR');
  $('#btnACor').on('click', function () { $('#txtCor').val(''); });

  $('#txtTamanho').autocompleta(1, `JSON={ "tabela":"TABTAM", "camposSelect":["TAM CHAVE, TAM DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnTamanho').pesquisa_array(['#txtTamanho'], ['TAM'], ['TAM'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTAM", "camposSelect":[ "TAM" ], "where": null}', 'Pesquisa Tamanho', 'TABTAM');
  $('#btnATamanho').on('click', function () { $('#txtTamanho').val(''); });

  $('#txtQualidade').autocompleta(1, `JSON={ "tabela":"TABQUL", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnQualidade').pesquisa_array(['#txtQualidade'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Qualidade', 'TABQUL');
  $('#btnAQualidade').on('click', function () { $('#txtQualidade').val(''); });

  $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnDeposito').pesquisa_array(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Depósito', 'DEPOSITO');
  $('#btnADeposito').on('click', function () { $('#txtDeposito').val(''); });

  $('#txtTpBaixa').autocompleta(1, `JSON={ "tabela":"TABBAI", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $('#btnTpBaixa').pesquisa_array(['#txtTpBaixa'], ['CODIGO'], ['DESCRICAO'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Depósito', 'TABBAI');
  $('#btnATpBaixa').on('click', function () { $('#txtTpBaixa').val(''); });

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const url = `/sisplan/impressao/v1/relconferenciainv?`;
      const dtIni = $('#dataInvIni').val();
      const dtFim = $('#dataInvFim').val();
      const setor = pegaChave('#txtSetor');
      const codigo = pegaChave('#txtProduto');
      const cor = pegaChave('#txtCor');
      const tam = pegaChave('#txtTamanho');
      const qualidade = pegaChave('#txtQualidade');
      const deposito = pegaChave('#txtDeposito');

      if (dtIni, dtFim, qualidade, deposito == '') {
        msgAlerta('Favor preencher os campos de período, qualidade e depósito.');
        return;
      }
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelConferenciaInv');
      const arquivo = await GeraRelatorio(`${url}DTINI=${dtIni}&DTFIM=${dtFim}&SETOR=${setor}&CODIGO=${codigo}&COR=${cor}&TAM=${tam}&QUALIDADE=${qualidade}&DEPOSITO=${deposito}&ENVIO=${0}`, 'GET', 100000, false, 'RelConferenciaInv');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const dtIni = $('#dataInvIni').val();
      const dtFim = $('#dataInvFim').val();
      const setor = pegaChave('#txtSetor');
      const codigo = pegaChave('#txtProduto');
      const cor = pegaChave('#txtCor');
      const tam = pegaChave('#txtTamanho');
      const qualidade = pegaChave('#txtQualidade');
      const deposito = pegaChave('#txtDeposito');

      if (dtIni, dtFim, qualidade, deposito == '') {
        msgAlerta('Favor preencher os campos de período, qualidade e depósito.');
        return;
      }

      await buscaInventario(dtIni, dtFim, setor, codigo, cor, tam, qualidade, deposito);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function buscaInventario(dtIni, dtFim, setor, codigo, cor, tam, qualidade, deposito) {

    try {
      let jsonFinal = [];

      for (let i = 0; i >= 0; i++) {

        const response = await requisicao('GET', '/sisplan/conferenciainv/v1/consultadiferenca?',
          `DTINIINV=${dtIni}&DTFIMINV=${dtFim}&SETOR=${setor}&CODIGO=${codigo}&COR=${cor}&TAM=${tam}&QUALIDADE=${qualidade}&DEPOSITO=${deposito}&ENVIO=${i}`, null);

        if (!response) {
          return;
        }

        const jsonStr = await response.json();

        if (response.status != 200) {
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        jsonFinal = [...jsonFinal, ...jsonStr];

        if (jsonStr.length < 50000) {
          break;
        }
      }

      jsonFinal = jsonFinal.filter(item => (item.QTDEATU != item.QTDEINV) || (item.QTDEEST != item.QTDEINV));

      let dataSetCols = [];
      const keys = Object.keys(jsonFinal[0]);

      for (const k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      }

      $('#tabela-produtos').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: true,
        destroy: true,
        scrollY: '300px',
        "language": {
          "sEmptyTable": "Nenhum registro encontrado",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhum registro encontrado",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },
        data: jsonFinal,
        columns: [
          {
            data: "QTDEATU",
            title: "QTDE_MOV"
          },
          {
            data: "QTDEEST",
            title: "QTDE_EST"
          },
          {
            data: "QTDEINV",
            title: "QTDE_INV"
          },
          {
            data: "DIFERENCA",
            title: "DIFERENCA"
          },
          {
            data: "CODIGO",
            title: "CODIGO"
          },
          {
            data: "CODIGO2",
            title: "CODIGO2"
          },
          {
            data: "DESCRICAO",
            title: "DESCRICAO"
          },
          {
            data: "UNIDADE",
            title: "UNIDADE"
          },
          {
            data: "CUSTO",
            title: "CUSTO"
          },
          {
            data: "COR",
            title: "COR"
          },
          {
            data: "DESC_COR",
            title: "DESC_COR"
          },
          {
            data: "TAM",
            title: "TAM"
          },
          {
            data: "DEPOSITO",
            title: "DEPOSITO"
          },
          {
            data: "LOTE",
            title: "LOTE"
          },
          {
            data: "ID_PA_ITEN",
            title: "ID_PA_ITEN"
          },
        ],
      });


    } catch (error) {
      console.error(error);
    }
  };

  $('#btnAcertarEstoque').on('click', async function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      const tpBaixa = pegaChave('#txtTpBaixa');

      if (tpBaixa == '') {
        msgAlerta('Necessário informar o tipo de baixa.');
        return;
      }
      if ($('#tabela-produtos').DataTable().rows().count() == 0) {
        msgAlerta('Nenhum produto filtrado, favor verificar.');
        return;
      }
      msgAlerta('Este processo irá ajustar as movimentações com o estoque e posteriormente alinhar o estoque com o inventário, deseja continuar?', corrigeEstoque);
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  async function corrigeEstoque() {

    try {
      $.LoadingOverlay('show');
      let arrItens = [];
      $('#tabela-produtos').DataTable().rows().data().map((item) => {
        const diferencaest = parseFloat(item.QTDEATU) - parseFloat(item.QTDEEST);
        const produto = {
          CODIGO: item.CODIGO,
          COR: item.COR,
          TAMANHO: item.TAM,
          LOTE: item.LOTE,
          DEPOSITO: item.DEPOSITO,
          TIPO: pegaChave('#txtQualidade'),
          TIP_BAI: pegaChave('#txtTpBaixa'),
          OPERACAO: diferencaest > 0 ? 'S' : 'E',
          QTDE: diferencaest > 0 ? diferencaest : (diferencaest * -1),
          DESCRICAO: item.DESCRICAO,
          PRECO: item.CUSTO,
          CUSTO: item.CUSTO,
          QTDEPAMOV: item.QTDEATU,
          QTDEPAITEN: item.QTDEEST,
          QTDEINV: item.QTDEINV,
          UNIDADE: item.UNIDADE,
          ID_PA_ITEN: item.ID_PA_ITEN
        };
        arrItens.push(produto);
      });

      const conferencia = {
        PRODUTOS: arrItens
      };

      const response = await requisicao('POST', '/sisplan/conferenciainv/v1/corrigeestoque?', '', `JSON=${JSON.stringify(conferencia)}`, 3000000);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay('hide');
        msgErro(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay('hide');
      toastr
        .success('Correção efetuada com sucesso!', 'Confirmação', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning',
          },
          positionClass: 'toast-top-center',
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            window.location.reload();
          },
        })
        .css({
          'margin-top': '20%',
          width: '500px',
          'max-width': '500px',
        });
    } catch (error) {
      $.LoadingOverlay('hide');
      console.error(error);
    }
  };

});