$(document).ready(async function () {

    async function RetornaVencimentos(arrDias) {
        let arrVencimentos = [];
        try {
            let dataAtual = new Date();
            for (let index = 0; index < arrDias.length; index++) {
                if (arrDias[index] != '') {
                    let novoPrazo = new Date();
                    novoPrazo.setDate(dataAtual.getDate() + parseInt(arrDias[index]));
                    arrVencimentos.push(formataData(novoPrazo));
                }
            }
            return arrVencimentos;
        } catch (error) {
            console.error(error);
        }
    }

    $('#btnGerarDuplicata').on('click', async function () {

        try {
            $.LoadingOverlay("show");
            try {
                const FormatoDtNovo = 'DD/MM/YYYY';
                let classe = $('#txtClasseGer').val().substring(1, $('#txtClasseGer').val().indexOf('] - '));
                let situacao = $('#txtSituacao').val().substring(1, $('#txtSituacao').val().indexOf('] - '));
                let banco = $('#txtBanco').val().substring(1, $('#txtBanco').val().indexOf('] - '));
                let conta = $('#txtConta').val().substring(1, $('#txtConta').val().indexOf('] - '));
                let historico = $('#txtHistorico').val().substring(1, $('#txtHistorico').val().indexOf('] - '));
                let fornecedor = $('#txtFornecedor').val().substring(1, $('#txtFornecedor').val().indexOf('] - '));
                let numeroParcela = 0;
                let table = $('#tabelaFinanceiro').DataTable({
                    paging: false,
                    filter: false,
                    info: false,
                    order: false,
                    autoWidth: false,
                    destroy: true,
                    columnDefs: [{
                        "render": $.fn.dataTable.render.moment(FormatoDtNovo),
                        "targets": 4,
                    }]
                });

                table.clear().draw();

                if ($('#txtNotaFiscal').val() == '') {
                    msgAlerta('Nota fiscal não informada!');
                    return;
                }

                if ($('#txtHistorico').val() == '') {
                    $('#btn-Historico').trigger('click');
                    return;
                }

                if ($('#txtSituacao').val() == '') {
                    $('#btn-Situacao').trigger('click');
                    return;
                }

                if ($('#txtConta').val() == '') {
                    $('#btn-Conta').trigger('click');
                    return;
                }

                if ($('#txtBanco').val() == '') {
                    $('#btn-Banco').trigger('click');
                    return;
                }

                if ($('#txtClasseGer').val() == '') {
                    $('#btn-ClasseGer').trigger('click');
                    return;
                }

                // let data = table.rows().length;

                let arrDias = [];

                if ($('#txtParcela1').val() != '') {
                    numeroParcela = parseInt(numeroParcela) + 1;
                    arrDias.push($('#txtParcela1').val());
                }
                if ($('#txtParcela2').val() != '') {
                    numeroParcela = parseInt(numeroParcela) + 1;
                    arrDias.push($('#txtParcela2').val());
                }
                if ($('#txtParcela3').val() != '') {
                    numeroParcela = parseInt(numeroParcela) + 1;
                    arrDias.push($('#txtParcela3').val());
                }
                if ($('#txtParcela4').val() != '') {
                    numeroParcela = parseInt(numeroParcela) + 1;
                    arrDias.push($('#txtParcela4').val());
                }
                if ($('#txtParcela5').val() != '') {
                    numeroParcela = parseInt(numeroParcela) + 1;
                    arrDias.push($('#txtParcela5').val());
                }
                if ($('#txtParcela6').val() != '') {
                    numeroParcela = parseInt(numeroParcela) + 1;
                    arrDias.push($('#txtParcela6').val());
                }
                if ($('#txtParcela7').val() != '') {
                    numeroParcela = parseInt(numeroParcela) + 1;
                    arrDias.push($('#txtParcela7').val());
                }
                if ($('#txtParcela8').val() != '') {
                    numeroParcela = parseInt(numeroParcela) + 1;
                    arrDias.push($('#txtParcela8').val());
                }
                if ($('#txtParcela9').val() != '') {
                    numeroParcela = parseInt(numeroParcela) + 1;
                    arrDias.push($('#txtParcela9').val());
                }
                if ($('#txtParcela10').val() != '') {
                    numeroParcela = parseInt(numeroParcela) + 1;
                    arrDias.push($('#txtParcela10').val());
                }
                if ($('#txtParcela11').val() != '') {
                    numeroParcela = parseInt(numeroParcela) + 1;
                    arrDias.push($('#txtParcela11').val());
                }
                if ($('#txtParcela12').val() != '') {
                    numeroParcela = parseInt(numeroParcela) + 1;
                    arrDias.push($('#txtParcela12').val());
                }

                if (arrDias.length == 0) {
                    msgAlerta('Impossível gerar duplicatas sem vencimento informado, favor verificar.');
                    return;
                };

                $('#txtParcela').val(numeroParcela);

                let dtArray = [];

                dtArray = await RetornaVencimentos(arrDias);

                let Pagar = {};

                let valorAp = (parseFloat($('#txtValordaNF').val()) / parseInt(numeroParcela)).toFixed(2);
                let diferencaValor = parseFloat($('#txtValordaNF').val()) - (valorAp * parseInt(numeroParcela));

                for (let i = 0; i < parseInt(numeroParcela); i++) {
                    Pagar.NUM_AP = await RetornaProximo('PAGTO', 'PAGTO', 'NUM_AP', 6);
                    Pagar.NOTAFISCAL = $('#txtNotaFiscal').val();
                    Pagar.LANCAMENTO = $('#txtLancamento').val();
                    Pagar.VALOR = valorAp;
                    Pagar.DT_VENCTO = dtArray[i];
                    Pagar.EMP_ID = $('#txtEmpId').val();
                    Pagar.STATUS = 'DUPLI';
                    Pagar.DUPLI = `${$('#txtNotaFiscal').val()}-${i + 1}`;
                    Pagar.QTDEPARCELAS = parseInt(numeroParcela);
                    Pagar.CODCRE = fornecedor;
                    Pagar.HISTORICO = historico;
                    Pagar.SITUACAO = situacao;
                    Pagar.NUM_OS = classe;
                    Pagar.BANCO = banco;
                    Pagar.CONTA = conta;

                    if (i == 0 && diferencaValor.toFixed(2) > 0) {
                        let guardaValor = parseFloat(Pagar.VALOR) + parseFloat(diferencaValor);
                        Pagar.VALOR = guardaValor.toFixed(2);
                    }
                    if (i == (parseInt(numeroParcela) - 1) && diferencaValor.toFixed(2) < 0) {
                        let guardaValor = parseFloat(Pagar.VALOR) + parseFloat(diferencaValor);
                        Pagar.VALOR = guardaValor.toFixed(2);
                    }

                    let GeraDuplicata = [Pagar.NOTAFISCAL, Pagar.VALOR, Pagar.NUM_AP, Pagar.LANCAMENTO, Pagar.DT_VENCTO, Pagar.DUPLI];

                    table.row.add(GeraDuplicata).draw(false);
                }

                toastr.success(
                    'Duplicada gerada com sucesso!',
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000
                }
                ).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px"
                });

            } catch (error) {
                msgErro(`Não foi possível gerar a Duplicata: ${error}`);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });
});