function validarCaracteres(value) {
    const result = value.match(/[&\/\\#,+()$~%.'":*?<>{}´`]/g);
    return result?.length ?? 0;
}

$(document).ready(async function () {
    let jsonCaptcha;

    if (getCookie("usuario") == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
    }

    const paramCadastraSemCPF = await CopiaParametro('VENDA', 40);
    const alterarLimiteCredito = await CopiaParametro('ENTIDADE', 0);
    const alterarLimiteFidelidade = await CopiaParametro('ENTIDADE', 1);
    const usaCertificadoA3 = await CopiaParametro("FATURAMENTO", 2);

    $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"represen", "camposSelect":[ "codrep chave", "nome descricao"], "where": null}`);
    $('#txtPais').autocompleta(1, `JSON={ "tabela":"cadpais", "camposSelect":[ "codigo chave", "nome descricao"], "where": null}`);
    $('#txtTabela').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao descricao"], "where": null}`);
    $('#txtRamoAtividade').autocompleta(1, `JSON={ "tabela":"SITCLI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtRegiao').autocompleta(1, `JSON={ "tabela":"reg_estado", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtGrupo').autocompleta(1, `JSON={ "tabela":"GRUPO_CLI", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtClasse').autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
    $("#txtCanalContato").autocompleta(1, `JSON={ "tabela":"TIPO_CONTATO", "camposSelect":[ "codigo chave", "descricao descricao"], "where": ["TIPO = 'O'"]}`);
    $('#txtTransportadora').autocompleta(1, `JSON={ "tabela":"TABTRAN", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
    $('#txtConfXML').autocompleta(1, `JSON={ "tabela":"FATCONF_XML", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtContaCliente').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtContaCAdiantamento').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtContaCDevolucao').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtContaFornecedor').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtContaFAdiantamento').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtContaFDevolucao').autocompleta(1, `JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtHistorico').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtCondicaoPagto').autocompleta(1, `JSON={ "tabela":"CONDICAO", "camposSelect":[ "CODCOND CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtMoeda').pesquisa_variosServerside(1, '{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": null}', 'CODMOE', 'DESCRICAO');

    $("#btn-representante").pesquisa("#txtRepresentante", "CODREP", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"represen", "camposSelect":[ "codrep", "nome"]}`, "Pesquisa Representante", "represen");
    $("#btn-pais-entidade").pesquisa("#txtPais", "CODIGO", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadpais", "camposSelect":[ "codigo", "nome"]}`, "Pesquisa País", "cadpais");
    $("#btn-tabela").pesquisa("#txtTabela", "REGIAO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"]}`, "Pesquisa Tabela", "regiao");
    $("#btn-RamoAtividade").pesquisa("#txtRamoAtividade", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SITCLI", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Ramo de Atividade", "sitcli");
    $("#btn-Regiao").pesquisa("#txtRegiao", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"reg_estado", "camposSelect":[ "codigo", "descricao"]}`, "Pesquisa Região", "reg_estado");
    $("#btn-Grupo").pesquisa("#txtGrupo", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_CLI", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Grupo", "GRUPO_CLI");
    $('#btn-Classe').pesquisa('#txtClasse', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Classe', 'classe_ger');
    $("#btn-CanalContato").pesquisa("#txtCanalContato", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TIPO_CONTATO", "camposSelect":[ "codigo", "descricao"], "where": ["TIPO = 'O'"]}`, "Pesquisa Canal Contato", "TIPO_CONTATO");
    $('#btnPesquisaTransportadora').pesquisa('#txtTransportadora', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRAN", "camposSelect":[ "CODIGO", "NOME"]}`, 'Pesquisa Transportadora', 'TABTRAN');
    $('#btnConfXML').pesquisa('#txtConfXML', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"FATCONF_XML", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conf XML', 'FATCONF_XML');
    $('#btn-contacliente').pesquisa('#txtContaCliente', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conta Cliente', 'CONTA_CONT');
    $('#btn-Cadiantamento').pesquisa('#txtContaCAdiantamento', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conta Cliente', 'CONTA_CONT');
    $('#btn-Cdevolucao').pesquisa('#txtContaCDevolucao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conta Cliente', 'CONTA_CONT');
    $('#btn-contafornecedor').pesquisa('#txtContaFornecedor', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conta Fornecedor', 'CONTA_CONT');
    $('#btn-Fadiantamento').pesquisa('#txtContaFAdiantamento', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conta Cliente', 'CONTA_CONT');
    $('#btn-Fdevolucao').pesquisa('#txtContaFDevolucao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONTA_CONT", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conta Cliente', 'CONTA_CONT');

    $(`#btnCep`).pesquisa_serverside([`#txtCep`, `#txtCepInv`], ["CADCEP.CEP", "CIDADE.NOME"], ["CADCEP.CEP", "CIDADE.NOME"], '{"tabela":"CADCEP", "camposSelect":["CADCEP.CEP", "CIDADE.NOME"], "leftJoin": [{"tabela": "CIDADE", "condicao": "CADCEP.CODMUN = CIDADE.CODIGO"}], "where": null}', 'Pesquisa de CEP', '', [true, true]);
    $(`#btnCepEntrega`).pesquisa_serverside([`#txtCepEntrega`, `#txtCepInv`], ["CADCEP.CEP", "CIDADE.NOME"], ["CADCEP.CEP", "CIDADE.NOME"], '{"tabela":"CADCEP", "camposSelect":[ "CADCEP.CEP", "CIDADE.NOME"],  "leftJoin": [{"tabela": "CIDADE", "condicao": "CADCEP.CODMUN = CIDADE.CODIGO"}],  "where": null}', 'Pesquisa de CEP', '', [true, true]);
    $(`#btnCepCobranca`).pesquisa_serverside([`#txtCepCobranca`, `#txtCepInv`], ["CADCEP.CEP", "CIDADE.NOME"], ["CADCEP.CEP", "CIDADE.NOME"], '{"tabela":"CADCEP", "camposSelect":[ "CADCEP.CEP", "CIDADE.NOME"],  "leftJoin": [{"tabela": "CIDADE", "condicao": "CADCEP.CODMUN = CIDADE.CODIGO"}],  "where": null}', 'Pesquisa de CEP', '', [true, true]);

    $("#btnTabelaModal").pesquisa("#txtTabelaModal", "REGIAO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"]}`, "Pesquisa Tabela", "regiao");
    $('#btnMoeda').pesquisa_serversideSel('#txtMoeda', `{ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO"], "where": null}`, 'Pesquisa de Moeda');
    $('#btn-Historico').pesquisa('#txtHistorico', 'HISTORICO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO"]}`, 'Pesquisa Histórico', 'HISTCP');
    $('#btn-CondicaoPagto').pesquisa('#txtCondicaoPagto', 'CODCOND', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CONDICAO", "camposSelect":[ "CODCOND", "DESCRICAO"]}`, 'Pesquisa Condição de Pagamento', 'CONDICAO');

    $("#btn-limpa-CanalContato").on("click", function () {
        $("#txtCanalContato").val("");
    });

    $('#btn-limpa-Classe').on('click', function () {
        $('#txtClasse').val('');
    });

    $('#btn-limpar-pais-entidade').on('click', function () {
        $('#txtPais').val('');
    });

    $('#btn-Arepresentante').on('click', function () {
        $('#txtRepresentante').val('');
    });

    $("#btn-Atabela").on('click', function () {
        $('#txtTabela').val('');
    });

    $("#btn-ARamoAtividade").on('click', function () {
        $('#txtRamoAtividade').val('');
    });

    $("#btn-ARegiao").on('click', function () {
        $('#txtRegiao').val('');
    });

    $("#btn-AGrupo").on('click', function () {
        $('#txtGrupo').val('');
    });

    $("#btn-limpa-contacliente").on('click', function () {
        $('#txtContaCliente').val('');
    });

    $("#btn-limpa-Cadiantamento").on('click', function () {
        $('#txtContaCAdiantamento').val('');
    });

    $("#btn-limpa-Cdevolucao").on('click', function () {
        $('#txtContaCDevolucao').val('');
    });

    $("#btn-limpa-contafornecedor").on('click', function () {
        $('#txtContaFornecedor').val('');
    });

    $("#btn-limpa-Fadiantamento").on('click', function () {
        $('#txtContaFAdiantamento').val('');
    });

    $("#btn-limpa-Fdevolucao").on('click', function () {
        $('#txtContaFDevolucao').val('');
    });

    $("#btnLimpaTransportadora").on('click', function () {
        $('#txtTransportadora').val('');
    });

    $("#btnLimpaConfXML").on('click', function () {
        $('#txtConfXML').val('');
    });

    $("#btn-AHistorico").on('click', function () {
        $('#txtHistorico').val('');
    });

    $("#btn-limpa-ACondicaoPagto").on('click', function () {
        $('#txtCondicaoPagto').val('');
    });


    $("#btnLimpaCep").on('click', function () {
        limpaCep()
    });

    $("#btnLimpaCepEntrega").on('click', function () {
        limpaCepEntrega()
    });

    $("#btnLimpaCepCobranca").on('click', function () {
        limpaCepCobranca()
    });

    $("#btn-limpa-moeda").on('click', function () {
        $('#txtMoeda').empty().trigger('change');
    });

    async function limpaCep() {
        $('#txtCidade').val('');
        // $('#txtCep').val('');
        $('#txtUF').val('');
        $('#txtRua').val('');
        $('#txtNumero').val('');
        $('#txtBairro').val('');
    }

    async function limpaCepEntrega() {
        $('#txtCidadeEntrega').val('');
        $('#txtUFEntrega').val('');
        $('#txtRuaEntrega').val('');
        $('#txtNumeroEntrega').val('');
        $('#txtBairroEntrega').val('');
    }

    async function limpaCepCobranca() {
        $('#txtCidadeCobranca').val('');
        $('#txtUFCobranca').val('');
        $('#txtRuaCobranca').val('');
        $('#txtNumeroCobranca').val('');
        $('#txtBairroCobranca').val('');
    }

    $("#btnFecharConsulta").on('click', function () {
        $("#modal-consultaCadastral").modal("hide");
    });

    $("#btnconsultaCadastral").on('click', async function () {
        $("#modal-consultaCadastral").modal("show");
        await retornaCaptcha();
        if ($('#txtCNPJ').val() != '') {
            $('#txtCNPJConsulta').val($('#txtCNPJ').val());
        }
    });


    $("#btnImportarConsulta").on('click', async function () {
        $('#txtCNPJ').val(formata_cpf_cnpj($("#txtCNPJConsulta").val()));
        $('#txtNome').val($('#txtRazaoSocialConsulta').val());
        $('#txtFantasia').val($('#txtFantasiaConsulta').val());
        $('#txtDataNascimento').val($('#txtDataAbertuta').val());
        $('#txtRua').val($('#txtRuaConsulta').val());
        $('#txtBairro').val($('#txtBairroConsulta').val());
        $('#txtNumero').val($('#txtNumeroConsulta').val());
        $('#txtCidade').val($('#txtMunicipioConsulta').val());
        $('#txtUF').val($('#txtUFConsulta').val());
        $('#txtCep').val($('#txtCEPConsulta').val());
        $('#txtComplemento').val($('#txtComplementoConsulta').val());
        $('#txtIE').val($('#txtIEConsulta').val());

        if (($('#txtIEConsulta').val() != '') && (verifica_cpf_cnpj($('#txtCNPJConsulta').val()) == 'CNPJ')) {
            $('#rgIE').val(1);
        } else if (($('#txtIEConsulta').val() == '') && (verifica_cpf_cnpj($('#txtCNPJConsulta').val()) == 'CNPJ')) {
            $('#rgIE').val(2);
        } else if (($('#txtIEConsulta').val() == '') && (verifica_cpf_cnpj($('#txtCNPJConsulta').val()) == 'CPF')) {
            $('#rgIE').val(3);
        } else if (($('#txtIEConsulta').val() != '') && (verifica_cpf_cnpj($('#txtCNPJConsulta').val()) == 'CPF')) {
            $('#rgIE').val(1);
        }

        $('#txtCNPJ').prop('disabled', true);
        await limpaCamposConsultaCadastral();
        $("#modal-consultaCadastral").modal("hide");
    });

    $("#btnConsultar").on('click', async function () {
        if ($('#txtCNPJConsulta').val() == '' && $('#txtCaptcha').val() == '' || $('#txtCaptcha').val() == '' || $('#txtCNPJConsulta').val() == '') {
            await msgAlerta('Para realizar a consulta é necessário preencher o CNPJ e o Captcha!');
            return;
        }

        let consultaReceita;

        if (usaCertificadoA3 == '1') {
            consultaReceita = await retornaConsultaWWW($('#txtCNPJConsulta').val(), $('#txtCaptcha').val(), jsonCaptcha, $('#txtUF').val(), usaCertificadoA3);
        } else {
            consultaReceita = await retornaConsultaWWW($('#txtCNPJConsulta').val(), $('#txtCaptcha').val(), jsonCaptcha, $('#txtUF').val());
        };

        // const consultaReceita = await retornaConsultaWWW($('#txtCNPJConsulta').val(), $('#txtCaptcha').val(), jsonCaptcha, $('#txtUF').val());

        $('#txtRazaoSocialConsulta').val(consultaReceita.NOME);
        $('#txtFantasiaConsulta').val(consultaReceita.FANTASIA);
        $('#txtDataAbertuta').val(consultaReceita.DT_NASC.slice(0, 10));
        $('#txtRuaConsulta').val(consultaReceita.ENDERECO);
        $('#txtBairroConsulta').val(consultaReceita.BAIRRO);
        $('#txtNumeroConsulta').val(consultaReceita.NUMERO);
        $('#txtCEPConsulta').val(consultaReceita.CEP);
        $('#txtComplementoConsulta').val(consultaReceita.COMPLEMENTO);
        $('#txtSituacaoCadastralConsulta').val(consultaReceita.SIT_CLI);
        $('#txtDataSituacaoConsulta').val(consultaReceita.DATA_CAD.slice(0, 10));
        $('#txtIEConsulta').val(consultaReceita.INSCRICAO);

        await BuscaECadastraCep($("#txtCEPConsulta"));
        let retorno = await BuscaCep($("#txtCEPConsulta"));

        $("#txtMunicipioConsulta").val(retorno[0]);
        $("#txtUFConsulta").val(retorno[1]);

    });

    async function limpaCamposConsultaCadastral() {
        $('#txtCNPJConsulta').val('');
        $('#txtCaptcha').val('');
        $('#txtRazaoSocialConsulta').val('');
        $('#txtFantasiaConsulta').val('');
        $('#txtDataAbertuta').val('');
        $('#txtRuaConsulta').val('');
        $('#txtBairroConsulta').val('');
        $('#txtNumeroConsulta').val('');
        $('#txtMunicipioConsulta').val('');
        $('#txtUFConsulta').val('');
        $('#txtCEPConsulta').val('');
        $('#txtComplementoConsulta').val('');
        $('#txtSituacaoCadastralConsulta').val('');
        $('#txtDataSituacaoConsulta').val('');
        $('#txtIEConsulta').val('');
    }

    $("#divImagemCaptcha").on('click', function () {
        retornaCaptcha();
    });

    let queryString = window.location.href;
    let parametros = queryString.split("/");
    let cliente = parametros[parametros.length - 1];

    $("#txtRG").on("input", function () {
        let c = this.selectionStart;
        let r = /[^a-z0-9]/gi;
        let v = $(this).val();
        if (r.test(v)) {
            $(this).val(v.replace(r, ""));
            c--;
        }
        this.setSelectionRange(c, c);
    });

    $('#btnFuncionario').on('click', async function () {
        if ($('#txtCNPJ').val().length > 14) {
            msgAlerta('Não é possível cadastrar pessoa jurídica como funcionário.')
            return;
        }

        await deletaRegistro("ENTIDADE", getCookie("usuario"), cliente);
        window.location.href = `${BASE_URI}/funcionario/${cliente}`;
    });

    $("#btnRepresentante").on("click", async function () {
        if (cliente != "create") {
            await deletaRegistro("ENTIDADE", getCookie("usuario"), cliente);
            window.location.href = `${BASE_URI}/representante/${cliente}`;
        } else {
            msgAlerta("Nenhuma entidade para cadastrar como representante.");
        }
    });

    $("#btnTransportadora").on("click", async function () {
        if (cliente != "create") {
            await deletaRegistro("ENTIDADE", getCookie("usuario"), cliente);
            window.location.href = `${BASE_URI}/transportadora/${cliente}`;
        } else {
            msgAlerta("Nenhuma entidade para cadastrar como transportadora.");
        }
    });

    $('#txtRenda').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#txtDDD').on('keypress', function (event) {
        let regex = new RegExp("^[0-9]+$");
        let key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
    });

    $("#btnVoltar").on("click", async function () {
        await deletaRegistro("ENTIDADE", getCookie("usuario"), cliente);
        window.location.href = `${BASE_URI}/cliente`;
    });

    $('#btnEstatisticas').on('click', async function () {
        await abreEstatisticasCliente($('#txtCodCli').val(), $('#txtNome').val());
    });

    $("#endereco").on("click", async function () {
        $("#enderecoGeral").collapse("show");
    });

    let options = {
        onKeyPress(cpf, ev, el, op) {
            let masks = ["000.000.000-000", "00.000.000/0000-00"];
            $("#txtCNPJ").mask(cpf.length > 14 ? masks[1] : masks[0], op);
        },
    };

    if ($("#txtCNPJ").length > 11) {
        $("#txtCNPJ").mask("00.000.000/0000-00", options);
    } else {
        $("#txtCNPJ").mask("000.000.000-00#", options);
    }

    $("#txtCNPJ").prop("disabled", cliente != "create");

    let SPMaskBehavior = function (val) {
        return val.replace(/\D/g, "").length === 9 ? "00000-0000" : "0000-00009";
    };
    let spOptions = {
        // eslint-disable-next-line no-shadow
        onKeyPress(val, e, field, options) {
            // eslint-disable-next-line prefer-rest-params
            field.mask(SPMaskBehavior.apply({}, arguments), options);
        },
    };

    $("#txtTelefone").mask(SPMaskBehavior, spOptions);

    $("#txtCNPJ").change(async function () {
        try {
            $.LoadingOverlay("show");
            try {

                let validaCNPJ = formata_cpf_cnpj($("#txtCNPJ").val());
                if (validaCNPJ != false) {
                    $("#txtCNPJ").val(validaCNPJ);
                }

                let response = await requisicao("GET", "/Sisplan/Cliente/V1/Entidade?", `CNPJ=${$("#txtCNPJ").val()}`);

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr.mensagem);
                    return;
                }

                if (jsonStr.length > 0) {
                    $.LoadingOverlay("hide");
                    toastr
                        .warning("CNPJ/CPF informado já existe!", "Atenção", {
                            toastClass: "alert",
                            iconClasses: {
                                error: "alert-error",
                                info: "alert-info",
                                success: "alert-success",
                                warning: "alert-warning",
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 3000,
                            fadeOut: 1000,
                            onHidden() {
                                window.location.href = `${BASE_URI}/cliente/${jsonStr[0].CODCLI}`;
                            },
                        })
                        .css({
                            "margin-top": "20%",
                            width: "500px",
                            "max-width": "500px",
                            color: "black",
                        });
                    return;
                }
            } catch (error) {
                console.log(error);
            }

            if (!valida_cpf_cnpj($("#txtCNPJ").val()) && (paramCadastraSemCPF != 1 ?? 0)) {
                $("#txtCNPJ").rules("add", "valida_cpf_cnpj");
                $("#txtCNPJ").focus();
            }

            const verifica_CPF_CNPJ = verifica_cpf_cnpj($("#txtCNPJ").val()) == "CNPJ";
            if (verifica_CPF_CNPJ && cliente == "create" && $("#txtNome").val() == "") {
                await buscaDadosCliente(cliente, $("#txtCNPJ").val().replace(/[^0-9]/g, ""));
            }

            if (!verifica_CPF_CNPJ) {
                $('#btnconsultaCadastral').attr('disabled', true);
            } else {
                $('#btnconsultaCadastral').attr('disabled', false);
            }

        } finally {
            $.LoadingOverlay("hide");
            $("#rgTributacao").val($('#txtCNPJ').val().length == 14 ? 'S' : 'A').change();
        }
    });

    async function cadastroEntidadeContabil(codcli) {
        try {

            const entidadecontabil = {
                CODCLI: codcli,
                CON_CLI: pegaChave('#txtContaCliente'),
                ADI_CLI: pegaChave('#txtContaCAdiantamento'),
                DEV_CLI: pegaChave('#txtContaCDevolucao'),
                CON_FOR: pegaChave('#txtContaFornecedor'),
                ADI_FOR: pegaChave('#txtContaFAdiantamento'),
                DEV_FOR: pegaChave('#txtContaFDevolucao')
            };

            let response = await requisicao("POST", "/sisplan/cliente/V1/entidadecontabil?", `JSON=${encodeURIComponent(JSON.stringify(entidadecontabil))}&CODUSUARIO=${getCookie('cod_usuario')}`);

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgAlerta("Erro ao gravar dados da conta");
                console.log(jsonStr.mensagem);
                return;
            }

        } catch (error) {
            console.log(error);
        }
    }

    async function verificaCheckBox() {
        if ($('#cbTipoCliente').is(':checked') == false &
            $('#cbTipoFornecedor').is(':checked') == false &
            $('#cbTipoTerceiros').is(':checked') == false &
            $('#cbTipoRepresentante').is(':checked') == false &
            $('#cbTipoProspecto').is(':checked') == false &
            $('#cbTipoFuncionario').is(':checked') == false) {
            return false;
        }
    }

    $('#rgSemanaMes').change(async function () {
        await desabilitaDiasConformeSelect();
    });

    async function desabilitaDiasConformeSelect() {
        if ($('#rgSemanaMes').val() === 'SEMANA') {
            $('.cbsSemana').attr('disabled', false);
            $('.cbsMes').attr('disabled', true);
        } else if ($('#rgSemanaMes').val() === 'MES') {
            $('.cbsSemana').attr('disabled', true);
            $('.cbsMes').attr('disabled', false);
        } else {
            $('.cbsSemana').attr('disabled', false);
            $('.cbsMes').attr('disabled', false);
        }
    }

    async function retornaCaptcha() {
        try {
            if (usaCertificadoA3 == '1') {
                response = await requisicao_ecf('GET', '/cliente/retornacaptcha?', '', '', 60000);

                jsonCaptcha = await response.json();

                $('#imagemCaptcha').attr('src', `data:image/png;base64,${jsonCaptcha.imagemCaptcha}`);
            } else {
                response = await requisicao('GET', '/sisplan/cliente/v1/captcha?', '', '', 60000);

                jsonCaptcha = await response.json();

                $('#imagemCaptcha').attr('src', `data:image/png;base64,${jsonCaptcha.imagemCaptcha}`);
            }
        } catch (error) {
            console.error(error);
        }
    };

    jQuery.validator.addMethod("validarCaracteres", function (value) {
        return validarCaracteres(value) === 0;
    });

    jQuery.validator.addMethod("valida_cpf_cnpj", function (value) {
        return valida_cpf_cnpj(value);
    });

    $("#msform").validate({
        debug: false,
        ignore: "",
        rules: {
            txtCNPJ: {
                required: paramCadastraSemCPF != '1',
                valida_cpf_cnpj: paramCadastraSemCPF != '1',
            },
            txtNome: {
                required: true,
                validarCaracteres: true,
            },
            txtFantasia: {
                validarCaracteres: true,
            },
            txtCep: {
                required: true,
            },
            txtPais: {
                required: true,
            },
            txtRua: {
                required: true,
            },
            txtNumero: {
                required: true,
            },
            txtBairro: {
                required: true,
            },
            txtDDD: {
                required: true,
            },
            txtTelefone: {
                required: true,
            },
        },
        messages: {
            txtCNPJ: {
                required: paramCadastraSemCPF != '1' ? "Informe um CNPJ/CPF válido." : '',
                valida_cpf_cnpj: paramCadastraSemCPF != '1' ? "Informe um CNPJ/CPF válido." : '',
            },
            txtNome: {
                required: "Informe um nome válido.",
                validarCaracteres: "Nome não pode conter caracteres especiais",
            },
            txtFantasia: {
                validarCaracteres: "Fantasia não pode conter caracteres especiais",
            },
            txtCep: {
                required: "Informe um CEP válido.",
            },
            txtPais: {
                required: "Informe um País válido.",
            },
            txtRua: {
                required: "Informe uma Rua válida.",
            },
            txtNumero: {
                required: "Informe um Número válido.",
            },
            txtBairro: {
                required: "Informe um Bairro válido.",
            },
            txtDDD: {
                required: "Informe um DDD válido",
            },
            txtTelefone: {
                required: "Informe um Telefone válido",
            },
        },
        errorElement: "span",
        errorPlacement(error, element) {
            error.addClass("invalid-feedback");
            element.closest(".form-group").append(error);
        },
        highlight(element) {
            $(element).addClass("is-invalid");
        },
        unhighlight(element) {
            $(element).removeClass("is-invalid");
        },
        invalidHandler(e, validator) {
            if (validator.errorList.length) {
                console.log(`erro no: ${$(`#${$(validator.errorList[0].element).prop('id')}`)}`);
                if (validator.errorList[0].element.id == "txtCep" || validator.errorList[0].element.id == "txtPais") {
                    if (!$("#multiCollapseExample3").hasClass("show")) {
                        $("#enderecoGeral").collapse("show");
                    }
                }
                if (validator.errorList[0].element.id == "txtRua") {
                    if (!$("#multiCollapseExample3").hasClass("show")) {
                        $("#multiCollapseExample3").collapse("show");
                    }
                }
                if (validator.errorList[0].element.id == "txtNumero") {
                    if (!$("#multiCollapseExample3").hasClass("show")) {
                        $("#multiCollapseExample3").collapse("show");
                    }
                }
                if (validator.errorList[0].element.id == "txtBairro") {
                    if (!$("#multiCollapseExample3").hasClass("show")) {
                        $("#multiCollapseExample3").collapse("show");
                    }
                }


                let id = $(
                    $(`#${$(validator.errorList[0].element).prop("id")}`)
                        .closest(".card-body")
                        .closest(".collapse")
                ).prop("id");
                if ((!$(`#${id}`).hasClass('show')) && id != "multiCollapseExample1") {
                    $(`a[href='#${id}']`).trigger("click");
                }
            }
        },
        async submitHandler(form, event) {
            event.preventDefault();
            try {
                $.LoadingOverlay("show");
                if (cliente == "create") {
                    try {
                        if (paramCadastraSemCPF != '1') {
                            let validaCNPJ = formata_cpf_cnpj($("#txtCNPJ").val());
                            if (validaCNPJ != false) {
                                $("#txtCNPJ").val(validaCNPJ);
                            }
                            let response = await requisicao("GET", "/Sisplan/Cliente/V1/Entidade?", `CNPJ=${$("#txtCNPJ").val()}`);

                            let jsonStr = await response.json();
                            if (response.status != 200) {
                                msgAlerta(jsonStr.mensagem);
                                return;
                            }

                            if (jsonStr.length > 0) {
                                msgAlerta("CNPJ/CPF informado já existe");
                                window.location.href = `${BASE_URI}/cliente/${jsonStr[0].CODCLI}`;
                                return;
                            }
                        }
                    } catch (error) {
                        console.log(error);
                    }
                }

                try {
                    // replace nos cep
                    let cep = $("#txtCep").val().replace(/\D/g, "");

                    let response = await requisicao("GET", "/sisplan/funcoes/v1/pesquisa?", `JSON={"tabela":"CADCEP", "camposSelect":["CEP"], "where": ["CEP = '${cep}'"]}`, null);

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgAlerta(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    if (jsonStr.RESULT[0].length <= 0) {
                        msgAlerta("Cep não informado ou inválido.");
                        $("#txtCep").focus();
                        return;
                    }

                } catch (error) {
                    console.log(error);
                }

                try {

                    let codrep = $("#txtRepresentante").val().substring(1, $("#txtRepresentante").val().indexOf("] - "));
                    let tabela = $("#txtTabela").val().substring(1, $("#txtTabela").val().indexOf("] - "));

                    let entidade = {};

                    let validaCNPJ = formata_cpf_cnpj($("#txtCNPJ").val());
                    if (validaCNPJ != false) {
                        $("#txtCNPJ").val(validaCNPJ);
                    }

                    const temCaracteresEspeciais = validarCaracteres($("#txtNome").val()) > 0;
                    if (temCaracteresEspeciais) {
                        msgAlerta("Nome não pode conter caracteres especiais");
                        return;
                    }

                    const fantasiaTemCaracteresEspeciais = validarCaracteres($("#txtFantasia").val()) > 0;
                    if (fantasiaTemCaracteresEspeciais) {
                        msgAlerta("Fantasia não pode conter caracteres especiais");
                        return;
                    }

                    entidade.CNPJ = $("#txtCNPJ").val();
                    entidade.DATA_CAD = $("#txtDataCadastro").val() != '' ? `${$("#txtDataCadastro").val()}T00:00:00Z` : `1899-01-01T00:00:00Z`;
                    entidade.DATA_BUSCA = `${new Date().toJSON().slice(0, 10)}T00:00:00Z`;
                    entidade.NOME = $("#txtNome").val().toUpperCase();
                    entidade.FANTASIA = $("#txtFantasia").val().toUpperCase();
                    entidade.OBS = $("#txtObs").val();
                    entidade.ATIVO = $("#cbAtivo").is(":checked") ? "S" : "N";
                    entidade.BLOQUEIO = $("#cbBloqueado").is(":checked") ? "S" : "N";
                    entidade.CONS_FINAL = $("#cbConsumidorFinal").is(":checked") ? "Sim" : "Nao";
                    entidade.INTEGRA_SHOPP = $("#cbIntegraShop").is(":checked") ? "N" : "S";
                    entidade.NUM_RG = $("#txtRG").val();
                    entidade.EMI_RG = $("#txtEmissor").val();
                    entidade.INSCRICAO = $("#txtIE").val();
                    entidade.SEXO = $("#rgSexo").val();
                    entidade.PORTE_EMPRESA = $("#rgPorteEmpresa").val();
                    entidade.DT_NASC = $("#txtDataNascimento").val() != '' ? $("#txtDataNascimento").val() : '1899-01-01';
                    entidade.COD_PAIS = pegaChave('#txtPais');
                    entidade.CEP = $("#txtCep").val().replace(/\D/g, "");
                    entidade.ENDERECO = $("#txtRua").val();
                    entidade.NUMERO = $("#txtNumero").val();
                    entidade.COMPLEMENTO = $("#txtComplemento").val();
                    entidade.BAIRRO = $("#txtBairro").val();
                    entidade.TIPO = verifica_cpf_cnpj($("#txtCNPJ").val()) == "CNPJ" ? "2" : "1";
                    entidade.IE_DESTINATARIO = $("#rgIE").val();
                    entidade.DDD_FONE = $("#txtDDD").val();
                    entidade.TELEFONE = $("#txtTelefone").val();
                    entidade.EMAIL = $("#txtEmail").val();
                    validaCNPJ = verifica_cpf_cnpj(entidade.CNPJ);
                    entidade.SIMPLES = $("#rgTributacao").val() != '' ? $("#rgTributacao").val() : ($('#txtCNPJ').val().length == 14 ? 'S' : 'A');
                    entidade.CEP_COB = $("#txtCepCobranca").val().replace(/\D/g, "");
                    entidade.END_COB = $("#txtRuaCobranca").val();
                    entidade.NUM_COB = $("#txtNumeroCobranca").val();
                    entidade.COMP_COB = $("#txtComplementoCobranca").val();
                    entidade.BAIRRO_COB = $("#txtBairroCobranca").val();
                    entidade.CEP_ENT = $("#txtCepEntrega").val().replace(/\D/g, "");
                    entidade.END_ENT = $("#txtRuaEntrega").val();
                    entidade.NUM_ENT = $("#txtNumeroEntrega").val();
                    entidade.COMP_ENT = $("#txtComplementoEntrega").val();
                    entidade.BAIRRO_ENT = $("#txtBairroEntrega").val();
                    entidade.CREDITO = $("#txtLimiteCredito").val();
                    entidade.CREDITO_UTILIZADO = $("#txtLimiteUsado").val();
                    entidade.LIMITE_FID = $("#txtLimiteFidelidade").val();
                    entidade.LIMITE_UTIL_FID = $("#txtLimiteFidelidadeUsado").val();
                    entidade.CODREP = codrep;
                    entidade.TABELA = tabela;
                    entidade.SIT_CLI = $("#txtRamoAtividade").val() != '' ? pegaChave('#txtRamoAtividade') : '';
                    entidade.REG_ESTADO = $("#txtRegiao").val() != '' ? pegaChave('#txtRegiao') : '';
                    entidade.LOCAL_TRAB = $("#txtLocalTrab").val();
                    entidade.ESTADO_CIVIL = $("#txtEstadoCivil").val();
                    entidade.NOME_PAI = $("#txtNomePai").val();
                    entidade.NOME_MAE = $("#txtNomeMae").val();
                    entidade.RENDA = $("#txtRenda").val();
                    entidade.DT_ADMISSAO = $("#txtDtAdmissao").val() != '' ? $("#txtDtAdmissao").val() : '1899-01-01';
                    entidade.GRUPO = pegaChave("#txtGrupo");
                    entidade.CLASSE = pegaChave("#txtClasse");
                    entidade.MIDIAS_SOCIAIS = $('#txtMidiaSocial').val();
                    entidade.INSC_COB = $('#txtInscCob').val();
                    entidade.INSC_ENT = $('#txtInscEnt').val();
                    entidade.CANAL_CONTATO = pegaChave('#txtCanalContato');
                    entidade.TP_FRETE = $('#rgTipoFrete').val();
                    entidade.TRANSPORTE = pegaChave('#txtTransportadora');
                    entidade.TIPO_ENTIDADE = '';
                    entidade.COD_CONF_XML = pegaChave('#txtConfXML');
                    entidade.CRED_CONSIGNADO = $('#txtCreditoGrupo').val();
                    entidade.TIPO_DIAS_VENCTO = $('#rgSemanaMes').val();
                    entidade.MOEDA = parseInt($('#txtMoeda').val()[0]);
                    entidade.HISTORICO = pegaChave('#txtHistorico');
                    entidade.CONDICAO_PAGAMENTO = pegaChave('#txtCondicaoPagto')
                    const moedas = await formataListas($('#txtMoeda').val().toString());

                    let arrDiasVencto = [];
                    if (entidade.TIPO_DIAS_VENCTO == 'SEMANA') {
                        for (let i = 0; i <= 6; i++) {
                            if (isChecked(`#cbSemana${i}`)) {
                                arrDiasVencto.push(i);
                            }
                        }
                    } else {
                        for (let i = 1; i <= 31; i++) {
                            if (isChecked(`#cbDia${i}`)) {
                                arrDiasVencto.push(i);
                            }
                        }
                    }

                    if ($("#cbTipoCliente").is(":checked")) {
                        entidade.TIPO_ENTIDADE += 'C';
                    }
                    if ($("#cbTipoFornecedor").is(":checked")) {
                        entidade.TIPO_ENTIDADE += 'F';
                    }
                    if ($("#cbTipoTerceiros").is(":checked")) {
                        entidade.TIPO_ENTIDADE += 'T';
                    }
                    if ($("#cbTipoRepresentante").is(":checked")) {
                        entidade.TIPO_ENTIDADE += 'R';
                    }
                    if ($("#cbTipoProspecto").is(":checked")) {
                        entidade.TIPO_ENTIDADE += 'P';
                    }
                    if ($("#cbTipoFuncionario").is(":checked")) {
                        entidade.TIPO_ENTIDADE += 'E';
                    }

                    let checkBox = await verificaCheckBox();

                    if (checkBox == false) {
                        try {
                            msgErro('É preciso selecionar pelo menos um tipo de entidade')
                            $('#tabelaEmbarque').DataTable().context[0](0, ($('.selected')[0].offsetTop));
                        } catch (error) {
                            return;
                        }
                    }


                    if (cliente != "create" && cliente.length < 30) {
                        entidade.CODCLI = cliente;
                    } else {
                        cliente = "create";
                    }

                    let response = await requisicao(cliente != "create" ? "PUT" : "POST", `/Sisplan/Cliente/V1/Entidade?LISTADIAS=${encodeURIComponent(JSON.stringify({ ARR_DIAS_VENCTO: arrDiasVencto }))}&MOEDAS=${moedas}&`, `CODUSUARIO=${getCookie('cod_usuario')}`, `JSON=${encodeURIComponent(JSON.stringify(entidade))}`);

                    if (!response) {
                        return;
                    }


                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgAlerta(jsonStr.mensagem);
                        return;
                    }

                    const arrTabelas = $('#gridTabelasModal').DataTable()
                        .rows()
                        .data()
                        .toArray()
                        .map((tabela) => tabela[0]);

                    await vinculaTabelasAoCliente(jsonStr[0].CODCLI, arrTabelas.toString());

                    await cadastroEntidadeContabil(jsonStr[0].CODCLI);

                    toastr
                        .success("Cadastro efetuado com sucesso!", "Confirmação", {
                            toastClass: "alert",
                            iconClasses: {
                                error: "alert-error",
                                info: "alert-info",
                                success: "alert-success",
                                warning: "alert-warning",
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 3000,
                            fadeOut: 1000,
                            onHidden() {
                                window.location.href = `${BASE_URI}/cliente`;
                            },
                        })
                        .css({
                            "margin-top": "20%",
                            width: "500px",
                            "max-width": "500px",
                        });
                } catch (error) {
                    console.error(error);
                    msgAlerta('Não foi possível gravar os dados do cliente!');
                }

            } finally {
                $.LoadingOverlay("hide");
            }
        },
    });

    $('#txtNome').on('input', function () {
        $('#txtNome').val($('#txtNome').val().toUpperCase());
        if (validarCaracteres($("#txtNome").val()) > 0) {
            $("#txtNome").rules("add", "validarCaracteres");
            $("#txtNome").focus();
        }

    });

    $('#txtFantasia').on('input', function () {
        $('#txtFantasia').val($('#txtFantasia').val().toUpperCase());
    });

    infoCep = '';

    $("#txtCep").blur(async function () {
        await limpaCep()
        infoCep = $("#txtCep");
        try {
            let retorno = await BuscaECadastraCep(infoCep);
            if (retorno != undefined) {
                if (retorno[0] != '') {
                    $("#txtCidade").val(retorno[0]);
                }
                if (retorno[1] != '') {
                    $("#txtUF").val(retorno[1]);
                }
                if (retorno[2] != '') {
                    $("#txtRua").val(retorno[2]);
                }
                if (retorno[3] != '') {
                    $("#txtBairro").val(retorno[3]);
                }
            }
        } catch (error) {
            console.error(error);
        }
    });

    $("#txtCepEntrega").blur(async function () {
        await limpaCepEntrega();
        infoCep = $("#txtCepEntrega");
        try {
            let retorno = await BuscaECadastraCep(infoCep);
            if (retorno != undefined) {
                if (retorno[0] != '') {
                    $("#txtCidadeEntrega").val(retorno[0]);
                }
                if (retorno[1] != '') {
                    $("#txtUFEntrega").val(retorno[1]);
                }
                if (retorno[2] != '') {
                    $("#txtRuaEntrega").val(retorno[2]);
                }
                if (retorno[3] != '') {
                    $("#txtBairroEntrega").val(retorno[3]);
                }
            }
        } catch (error) {
            console.error(error);
        }
    });

    $("#txtCepCobranca").blur(async function () {
        await limpaCepCobranca()
        infoCep = $("#txtCepCobranca");
        try {
            let retorno = await BuscaECadastraCep(infoCep);
            if (retorno != undefined) {
                if (retorno[0] != '') {
                    $("#txtCidadeCobranca").val(retorno[0]);
                }
                if (retorno[1] != '') {
                    $("#txtUFCobranca").val(retorno[1]);
                }
                if (retorno[2] != '') {
                    $("#txtRuaCobranca").val(retorno[2]);
                }
                if (retorno[3] != '') {
                    $("#txtBairroCobranca").val(retorno[3]);
                }
            }
        } catch (error) {
            console.error(error);
        }
    });

    if (cliente != "" && cliente != "create") {
        $('#txtLimiteCredito').attr('readonly', !parseInt(alterarLimiteCredito));
        $('#txtLimiteFidelidade').attr('readonly', !parseInt(alterarLimiteFidelidade));
    }

    if (cliente != "" && cliente != "create" && cliente.length < 30) {
        // busca cliente no banco ou webservice se for cnpj...
        await buscaDadosCliente(cliente, "");
    } else {
        // seta valores padrões
        $("#cbAtivo").prop("checked", true);
        $("#cbConsumidorFinal").prop("checked", true);
        $("#rgIE").val("9").change();
        $('#txtPais').val('[1058] - BRASIL');
        $("#txtDataCadastro").val(new Date().toISOString().slice(0, 10));
        $("#txtDataAlteracao").val(new Date().toISOString().slice(0, 10));
        $("#txtDataNascimento").val(
            new Date("1980-01-01").toISOString().slice(0, 10)
        );
        $("#rgSexo").val("M").change();
        $("#btnTransportadora").addClass('d-none');
        $("#btnRepresentante").addClass('d-none');

        await carregaValoresPadroes();
    }

    async function carregaValoresPadroes() {
        const pesquisa = {
            camposSelect: ['CAMPO', 'VALOR'],
            tabela: 'TABPADRAO',
            where: [`TABPADRAO.TABELA = 'ENTIDADE'`]
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        jsonStr.map(async item => {
            switch (item.CAMPO) {
                case 'GRUPO_CLI': {
                    insereValor('#txtGrupo', item.VALOR, 'VALOR PADRÃO');
                    break;
                }
                case 'SIT_DUP': {
                    insereValor('#txtCstIpiSaida', item.VALOR, 'VALOR PADRÃO');
                    break;
                }
                case 'IE_DESTINATARIO': {
                    $('#rgIE').val(item.VALOR).change();
                    break;
                }
                case 'CODREP': {
                    insereValor('#txtRepresentante', item.VALOR, 'VALOR PADRÃO');
                    break;
                }
                case 'CONS_FINAL': {
                    $('#cbConsumidorFinal').prop('checked', item.VALOR != 'Nao');
                    break;
                }
                case 'TRANSPORTE': {
                    insereValor('#txtTransportadora', item.VALOR, 'VALOR PADRÃO');
                    break;
                }
                case 'TP_FRETE': {
                    $('#rgTipoFrete').val(item.VALOR).change();
                    break;
                }
                case 'CLASSE': {
                    insereValor('#txtClasse', item.VALOR, 'VALOR PADRÃO');
                    break;
                }
                case 'EMAIL': {
                    insereValor('#txtEmail', item.VALOR);
                    break;
                }
                case 'MOEDAS': {
                    if (item.VALOR != '') {
                        try {
                            const pesquisaMoeda = {
                                camposSelect: ['CODMOE', 'DESCRICAO'],
                                tabela: 'MOEDA',
                                where: [`CODMOE IN (${item.VALOR})`]
                            };
                            const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaMoeda));
                            await insereValorPesquisaVarios('txtMoeda', 'CODMOE', 'DESCRICAO', jsonStr);

                        } catch (error) {
                            console.error(error);
                        }
                    }
                    break;
                }
            }
        });
    }

    if (cliente != "" && cliente != "create" && cliente.length > 30) {
        let arrayXml = atob(cliente).split(",");

        let cnpj = arrayXml[0];
        let ie = arrayXml[1];
        let nome = arrayXml[2];
        let fantasia = arrayXml[3];
        let cep = arrayXml[4];
        let cidade = arrayXml[5];
        let uf = arrayXml[6];
        let numero = arrayXml[7];
        let bairro = arrayXml[8];
        let telefone = arrayXml[9];

        $("#txtCNPJ").val(cnpj);
        $("#txtNome").val(nome);
        $("#txtFantasia").val(fantasia);
        $("#txtIE").val(ie);
        $("#txtDDD").val(telefone.slice(0, 2));
        $("#txtTelefone").val(telefone.slice(2));
        $("#txtCep").val(cep);
        $("#txtCidade").val(cidade);
        $("#txtUF").val(uf);
        $("#txtNumero").val(numero);
        $("#txtBairro").val(bairro);

    }
    if (cliente != "" && cliente != "create" && cliente.length < 30) {
        await buscaDadosEntidadeContabil(cliente);
    }

    $('#txtLimiteCredito').on('blur', async function () {
        $('#txtLimiteDisponivel').val(TruncaDecimaisNova(2, +$('#txtLimiteCredito').val() - $('#txtLimiteUsado').val()));
    });

    $('#txtLimiteFidelidade').on('blur', async function () {
        $('#txtLimiteFidelidadeDisponivel').val(TruncaDecimaisNova(2, +$('#txtLimiteFidelidade').val() - $('#txtLimiteFidelidadeUsado').val()));
    });

    $(".collapse")
        .on("shown.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-right")
                .removeClass("fa-angle-right")
                .addClass("fa-angle-down");
        })
        .on("hidden.bs.collapse", function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr("id")}']`);

            clicked
                .parent()
                .find(".fa-angle-down")
                .removeClass("fa-angle-down")
                .addClass("fa-angle-right");
        });

    async function abreCadastroCep(cepField) {
        $('#modal-CEP').attr('cepField', cepField[0].id)
        $('#modal-CEP').modal('show');
        $('#txt_Cep').val('');
        $('#txtEndereco').val('');
        $('#txtBairroCEP').val('');
        $('#txtUfCEPCadastro').val('');
        $('#txtCidadeCEPCadastro').val('');
        $('#txtPaisCEPCadastro').val('');
        if ((cepField.val() != '') || (cepField.val() != undefined) || (cepField.val() != null)) {
            $('#txt_Cep').val(`${cepField.val().substr(0, 5)}-${cepField.val().substr(-3)}`);
        }
    }


    async function BuscaECadastraCep(cepInput) {
        try {
            $.LoadingOverlay("show");
            try {
                const cep = cepInput.val().replace('-', '').trim();
                const response = await requisicao('GET', '/sisplan/cep/v1/CEP?', `CEP=${cep}`, null);

                if (!response) {
                    return;
                }

                const jsonStr = await response.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr.mensagem, () => { abreCadastroCep(cepInput) }, undefined, undefined);
                    return;
                }

                return [jsonStr.nOMCIDADE, jsonStr.eSTCEP, jsonStr.nOMCEP, jsonStr.bAIRRO];

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    };
    async function habilitaCampoCidade() {
        let uf;
        $.LoadingOverlay('show');
        setTimeout(() => {

            if ($("#txtUfCEPCadastro").val() != "") {
                uf = pegaChave("#txtUfCEPCadastro", uf);

                $("#txtCidadeCEPCadastro").prop("readonly", false);
                $("#btnCidade").removeClass("d-none");
                $("#btnACidade").removeClass("d-none");
                $("#txtCidadeCEPCadastro").prop("disabled", false);

                $("#txtCidadeCEPCadastro").off();
                $("#txtCidadeCEPCadastro").autocompleta(1, `JSON={ "tabela":"cidade", "camposSelect":[ "codigo chave", "NOME descricao"], "where": ["cod_uf = '${uf}'"]}`);
                $("#btnCidade").pesquisa("#txtCidadeCEPCadastro", "CODIGO", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"cidade", "camposSelect":[ "CODIGO", "NOME"], "where": ["cod_uf = '${uf}'"]}`, "Pesquisa Cidade", "cidade");
            } else {
                $("#txtCidadeCEPCadastro").prop("readonly", true);
                $("#btnCidade").addClass("d-none");
                $("#btnACidade").addClass("d-none");
                $("#txtCidadeCEPCadastro").prop("disabled", true);
                $("#txtCidadeCEPCadastro").off();
            }
        }, 2000);
        $.LoadingOverlay('hide');
    }


    $('#txtUfCEPCadastro').change(async function () {
        await habilitaCampoCidade();
    });

    $("#txtPaisCEPCadastro").autocompleta(1, `JSON={ "tabela":"cadpais", "camposSelect":[ "codigo chave", "NOME descricao"], "where": null}`);
    $("#txtUfCEPCadastro").autocompleta(1, `JSON={ "tabela":"tabuf", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`, '', '', '', habilitaCampoCidade);

    $("#btnPais").pesquisa("#txtPaisCEPCadastro", "CODIGO", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"cadpais", "camposSelect":[ "CODIGO", "NOME"]}`, "Pesquisa País", "cadpais");
    $("#btnUf").pesquisa("#txtUfCEPCadastro", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"tabuf", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa UF", "tabuf", '', habilitaCampoCidade);

    $("#btnACidade").on("click", function () {
        $("#txtCidadeCEPCadastro").val("");
    });
    $("#btnAPais").on("click", function () {
        $("#txtPaisCEPCadastro").val("");
    });
    $("#btnAUf").on("click", async function () {
        $("#txtUfCEPCadastro").val("");
        $("#txtCidadeCEPCadastro").val("");
        $("#txtCidadeCEPCadastro").prop("readonly", true);
        $("#btnCidade").addClass("d-none");
        $("#btnACidade").addClass("d-none");
        $("#txtCidadeCEPCadastro").prop("disabled", true);
        $("#txtCidadeCEPCadastro").off();
    });

    $('#gridTabelasModal').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        autoWidth: true,
        destroy: true,
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        }
    });

    $('#btnAbreModalTabelas').on('click', function () {
        abreModalTabela();
    })

    async function abreModalTabela() {
        $('#modal-tabelas').modal('show');
    }

    $('#btnAdicionarTabela').on('click', async function () {
        await feedTableGrid();
    })

    async function feedTableGrid() {
        const sCodigo = pegaChave('#txtTabelaModal');
        const sDescription = pegaDescricao('#txtTabelaModal');
        const sTable = $('#gridTabelasModal').DataTable().rows().count();
        let adicionaRegistro = true;
        if (sCodigo != '') {
            if (sTable <= 0) {
                $('#gridTabelasModal').DataTable().row.add([sCodigo, sDescription, retornaBotaoOpcoesModalTabelas()]).draw(false);
            } else {
                for (let i = 0; i < sTable; i++) {
                    if ($('#gridTabelasModal').DataTable().data()[i][0] == sCodigo) {
                        adicionaRegistro = false;
                    }
                }
                if (adicionaRegistro) {
                    $('#gridTabelasModal').DataTable().row.add([sCodigo, sDescription, retornaBotaoOpcoesModalTabelas()]).draw(false);
                } else {
                    msgAlerta('Tabela já adicionada ao grid.');
                }
            }
            $('#txtTabelaModal').val('');
        }
    }

    $('#gridTabelasModal').on('click', '.btn-excluir', async function () {
        $('#gridTabelasModal').DataTable().row($(this).parents('tr')).remove().draw(false);
    });

    function retornaBotaoOpcoesModalTabelas() {
        return '<div class="divBtnOpcoes"> ' +
            '    <button class="botaoOpcoes btn-excluir" type="button"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
            '   </div>';
    }

    $('#btnFecharModalTabela').on('click', async function () {
        $('#modal-tabelas').modal('hide')
    })

    // function montaJsonTabelas(Codigo) {
    //     const objeto = {
    //         Codigo
    //     };
    //     return objeto;
    // }

    async function vinculaTabelasAoCliente(sCodCli, sTabelas) {
        try {

            let response = await requisicao("POST", "/sisplan/cliente/V1/tabelascliente?", `TABELAS=${sTabelas}&CODCLI=${sCodCli}`, 3000);

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgAlerta("Erro ao gravar dados da conta");
                console.log(jsonStr.mensagem);
                return;
            }

        } catch (error) {
            console.log(error);
        }
    }

    $('#txtCNPJ').focus();

    async function trazContatos() {

        if ($.fn.DataTable.isDataTable('#tabelaContatosEntidade')) {
            $('#tabelaContatosEntidade').DataTable().destroy();
            $('#tabelaContatosEntidade').empty();
        };

        const codcliContatos = $('#txtCodCli').val() == '' || $('#txtCodCli').val() == undefined ? '99999999' : $('#txtCodCli').val();

        if (codcliContatos == '99999999') {
            $('#btnAlteraContato').prop('disabled', true);
        };

        const PesquisaContatoCliente = {
            tabela: "CONTATO",
            camposSelect: ["CONTATO.NUMERO",
                "CONTATO.CODCLI",
                "CONTATO.NOME",
                "CONTATO.DT_NASC AS DATA_NASC",
                "CONTATO.FONE AS TELEFONE",
                "CONTATO.CELULAR",
                "CONTATO.EMAIL",
                "CONTATO.TIPO",
                "CONTATO.TEXTO",
                "CONTATO.OBS AS OBSERVACAO",
                "CONTATO.CPF_CNPJ",
                "CONTATO.INSCRICAO",
                "CONTATO.TIPO_CONTATO",
                "CONTATO.MALA_DIRETA",
                "CONTATO.FUNCAO",
                "FUNCAO.DESCRICAO DESC_FUNCAO",
                "CONTATO.CARGO",
                "CARGO.DESCRICAO DESC_CARGO",
                "CONTATO.SOMENTE_XML",
                "CONTATO.ID_SETOR",
                "SETOR.DESCRICAO AS DESC_SETOR",
                "CONTATO.ID_ENT",
                "CONTATO.ATIVO"
            ],
            leftJoin: [
                { tabela: "FUNCAO", alias: "FUNCAO", "condicao": "FUNCAO.CODIGO = CONTATO.FUNCAO" },
                { tabela: "CARGO", alias: "CARGO", "condicao": "CARGO.CODIGO = CONTATO.CARGO" },
                { tabela: "CADFLUXO", alias: "SETOR", "condicao": "SETOR.ID = CONTATO.ID_SETOR" },
            ],
            where: [
                `1=1 AND CONTATO.CODCLI = '${codcliContatos}'`,
            ],
            orderBy: [
                "CONTATO.NUMERO",
            ]

        };

        const jsonStrContato = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaContatoCliente));

        const dataSetCols = [];

        dataSetCols.push({
            title: 'Número',
            data: 'NUMERO',
        });

        dataSetCols.push({
            title: 'Nome',
            data: 'NOME',
        });

        dataSetCols.push({
            title: 'Data Nasc.',
            data: 'DATA_NASC',
        });

        dataSetCols.push({
            title: 'Telefone',
            data: 'TELEFONE',
        });

        dataSetCols.push({
            title: 'E-mail',
            data: 'EMAIL',
        });

        dataSetCols.push({
            title: 'Tipo',
            data: 'TIPO',
        });

        dataSetCols.push({
            title: 'Observações',
            data: 'OBSERVACAO',
        });

        dataSetCols.push({
            title: 'CPF/CNPJ',
            data: 'CPF_CNPJ',
        });

        dataSetCols.push({
            title: 'Inscrição',
            data: 'INSCRICAO',
        });

        dataSetCols.push({
            title: 'Celular',
            data: 'CELULAR',
        });


        $('#tabelaContatosEntidade').DataTable({
            bPaginate: false,
            destroy: true,
            search: false,
            filter: false,
            lengthChange: false,
            info: true,
            order: false,
            language: {
                sEmptyTable: "Nenhum registro encontrado",
                sInfo: "_TOTAL_ registros",
                sInfoEmpty: " 0 registros",
                sInfoFiltered: "(Filtrados de _MAX_ registros)",
                sInfoPostFix: "",
                sInfoThousands: ".",
                sLengthMenu: "_MENU_ resultados",
                sLoadingRecords: "Carregando...",
                sProcessing: "Processando...",
                sZeroRecords: "Nenhum registro encontrado",
                sSearch: "Pesquisar",
                oPaginate: {
                    sNext: "Próximo",
                    sPrevious: "Anterior",
                    sFirst: "Primeiro",
                    sLast: "Último",
                },
                oAria: {
                    sSortAscending: ": Ordenar colunas de forma ascendente",
                    sSortDescending: ": Ordenar colunas de forma descendente",
                },
            },
            autoWidth: true,
            columns: dataSetCols,
            data: jsonStrContato,
            columnDefs: [{
                type: 'date-br',
                targets: [2],
                render(data) {
                    if (data) {
                        return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                    } else {
                        return '';
                    }

                },
            }]
        });
    };

    await trazContatos();

    $('#btnAlteraContato').on('click', async function () {
        const codcliContatosEntidade = $('#txtCodCli').val();
        const nomeContatosEntidade = $('#txtNome').val();
        $('#txtTituloContato').html(`${codcliContatosEntidade} - ${nomeContatosEntidade}`);
        $('#modal-cadcontato').modal('show');
    });

    $('#tabelaObsSerasa').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: true,
        destroy: true,
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        }
    });

    async function buscaDadosObsSerasa() {
        const pesquisaParam = {
            tabela: "ENTID_OBS",
            camposSelect: ["NUMERO",
                "OBSERVACAO",
                "CODCLI",
                "DATA"
            ],
            where: [
                `1=1 AND CODCLI = '${$('#txtCodCli').val()}'`,
            ]
        };

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        return jsonStr;
    }

    $('#abaObsSerasa').on('click', async function () {
        $('#tabelaObsSerasa').DataTable().clear().draw(false);
        const dadosObsSerasa = await buscaDadosObsSerasa();
        dadosObsSerasa.map(item => {
            $('#tabelaObsSerasa').DataTable().row.add([
                item.NUMERO,
                item.OBSERVACAO.slice(0, 160) + '...',
            ]).draw(false);
        })
    });

    async function pesquisaObsSerasa(numero) {
        const pesquisaParam = {
            tabela: "ENTID_OBS",
            camposSelect: [
                "NUMERO",
                "CODCLI",
                "DATA",
                "OBSERVACAO"
            ],
            orderBy: [`DATA`],
            where: [` 1=1 AND NUMERO = '${numero}'`]
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

        return jsonStr[0];
    }

    $("#tabelaObsSerasa tbody").on("click", "tr", async function () {
        let sNumero = $('#tabelaObsSerasa').DataTable().row($(this)).data()[0];
        const data = await pesquisaObsSerasa(sNumero)
        $('#txtNumeroObsSerasa').val(sNumero);
        $('#txtObsSerasa').val(data.OBSERVACAO);
        $('#txtDataObsSerasa').val(data.DATA);
        insereValor('#txtClienteObsSerasa', $('#txtCodCli').val(), $('#txtNome').val())
        $('#modal_obs_serasa').modal('show');
    });

    $('#btnIncluiObsSerasaCert').on('click', async function () {
        $('#txtNumeroObsSerasa').val('000000');
        insereValor('#txtClienteObsSerasa', $('#txtCodCli').val(), $('#txtNome').val())
        $('#modal_obs_serasa').modal('show');
        // $('#btnIncluirObsSerasa').trigger('click');
    });

    $('#modal_obs_serasa').on('hide.bs.modal', function () {
        insereValor('#txtClienteObsSerasa', $('#txtCodCli').val(), $('#txtNome').val());
        $('#txtObsSerasa').val('');
        $('#txtDataObsSerasa').val('');
    });

    $("#tutorial").on("click", function () {
        $("#geral-tab").trigger("click");
        const driver = new Driver({
            doneBtnText: "Sair",
            closeBtnText: "Fechar",
            nextBtnText: "Próximo",
            prevBtnText: "Anterior",
            allowClose: false,
            onHighlightStarted: (Element) => {
                if (Element.node.id == "geral") {
                    if (!$("#multiCollapseExample1").hasClass("show"));
                    $("#multiCollapseExample1").collapse("show");
                } else if (Element.node.id == "documentoaba") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#documento").collapse("show");
                        $("#multiCollapseExample2").collapse("show");
                    }
                } else if (Element.node.id == "endereco") {
                    if (!$("#multiCollapseExample3").hasClass("show")) {
                        $("#multiCollapseExample3").collapse("show");
                        $("#enderecoGeral").collapse("show");
                    }
                } else if (Element.node.id == "geral") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#endereco_geral-tab").trigger("click");
                    }
                } else if (Element.node.id == "endereco_entrega_geral") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#enderecoEntrega").collapse("show");
                    }
                } else if (Element.node.id == "endereco_cobranca_geral") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#enderecoCobranca").collapse("show");
                    }
                } else if (Element.node.id == "venda") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#multiCollapseExample4").collapse("show");
                    }
                } else if (Element.node.id == "adicional") {
                    if (!$("#collapseFiltros").hasClass("show")) {
                        $("#multiCollapseExample5").collapse("show");
                    }
                }
            },
            onPrevious: (Element) => {
                if (
                    Element.node.id == "documento-tab" ||
                    Element.node.id == "documentoaba"
                ) {
                    if (!$("#geral>a").hasClass("collapsed")) {
                        $("#multiCollapseExample2").collapse("show");
                    }
                } else if (Element.node.id == "endereco") {
                    if (!$("#documento>a").hasClass("collapsed")) {
                        $("#documentoaba").collapse("show");
                    }
                } else if (Element.node.id == "endereco_entrega_geral-tab") {
                    if (!$("#endereco_geral").hasClass("active")) {
                        $("#endereco_geral-tab").trigger("click");
                        $("#endereco_geral").addClass("active show");
                    }
                } else if (Element.node.id == "endereco_cobranca_geral-tab") {
                    if (!$("#endereco_entrega_geral").hasClass("active")) {
                        $("#endereco_entrega_geral-tab").trigger("click");
                        $("#endereco_entrega_geral").addClass("active show");
                    }
                }
            },
        });

        driver.defineSteps([{
            element: "#geral-tab",
            popover: {
                title: "Aba Geral",
                description: "Clique aqui para abrir a aba geral.",
                position: "top",
            },
        },
        {
            element: "#geral",
            popover: {
                title: "Cadastro Geral",
                description: "Aqui você pode informar os dados gerais de cadastro dos Clientes/Fornecedores.",
                position: "bottom",
            },
        },
        {
            element: "#multiCollapseExample1",
            popover: {
                title: "Dados de Cadastro Geral",
                description: "Esses são os campos que você informará os dados gerais de cadastro.",
                position: "top",
            },
        },
        {
            element: "#cnpjTour",
            popover: {
                title: "Campo CNPJ",
                description: "Ao alterar esse campo, será feita uma pesquisa ao WebService https://www.receitaws.com.br/ e se houver retorno preencherá os campos básicos do cadastro.",
                position: "top",
            },
        },
        {
            element: "#nomeTour",
            popover: {
                title: "Campos Obrigatórios",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#txtEmail",
            popover: {
                title: "Tornar Campos Obrigatórios",
                description: "Você pode tornar esse campo obrigatório selecionando o mesmo e pressionando CTRL + F8.",
                position: "top",
            },
        },
        {
            element: "#dddTelefoneTour",
            popover: {
                title: "Campos Obrigatórios",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#telefoneTour",
            popover: {
                title: "Campos Obrigatórios",
                description: "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
                position: "top",
            },
        },
        {
            element: "#documentoaba",
            popover: {
                title: "Aba Documentos",
                description: "Clique aqui para abrir aba documentos.",
                position: "top",
            },
        },
        {
            element: "#multiCollapseExample2",
            popover: {
                title: "Dados de Documentos",
                description: "Aqui ficam os dados de documentos a serem preenchidos.",
                position: "top",
            },
        },
        {
            element: "#endereco",
            popover: {
                title: "Aba Endereços",
                description: "Clique aqui para abrir os cadastros dos endereços.",
                position: "top",
            },
        },
        {
            element: "#EnderecoGeral",
            popover: {
                title: "Aba Endereço Geral",
                description: "Nessa aba você informa o endereço principal do seu cliente/fornecedor.",
                position: "top",
            },
        },
        {
            element: "#endereco_geral",
            popover: {
                title: "Campos Endereço Geral",
                description: "Aqui ficam os dados de endereço a serem informados.",
                position: "top",
            },
        },
        {
            element: "#enderecoGeral",
            popover: {
                title: "Campos Endereço Geral",
                description: "Aqui ficam os dados de endereço a serem informados.",
                position: "top",
            },
        },
        {
            element: "#cepTour",
            popover: {
                title: "Campo CEP",
                description: "Ao alterar esse campo, será feita uma pesquisa aos WebServices https://apps.correios.com.br/ e http://viacep.com.br/ws/, se houver retorno preencherá os campos de endereço.",
                position: "top",
            },
        },
        {
            element: "#entrega",
            popover: {
                title: "Aba Endereço de Entrega",
                description: "Nessa aba você informa o endereço de entrega do seu cliente/fornecedor.",
                position: "top",
            },
        },
        {
            element: "#endereco_entrega_geral",
            popover: {
                title: "Campos Endereço de Entrega",
                description: "Aqui ficam os dados de endereço a serem informados.",
                position: "top",
            },
        },
        {
            element: "#cobranca",
            popover: {
                title: "Aba Endereço de Cobrança",
                description: "Nessa aba você informa endereço de cobrança do seu cliente/fornecedor.",
                position: "top",
            },
        },
        {
            element: "#endereco_cobranca_geral",
            popover: {
                title: "Campos Endereço de Cobrança",
                description: "Aqui ficam os dados de endereço a serem informados.",
                position: "top",
            },
        },
        {
            element: "#venda",
            popover: {
                title: "Aba Cadastro de Venda",
                description: "Aqui você pode sugerir algumas informações que serão levadas em consideração no módulo de venda.",
                position: "top",
            },
        },
        {
            element: "#multiCollapseExample4",
            popover: {
                title: "Campos de Cadastros de Venda",
                description: "Aqui ficam os dados da venda a serem informados.",
                position: "top",
            },
        },
        {
            element: "#adicional",
            popover: {
                title: "Aba Adicionais",
                description: "Aqui você pode sugerir algumas informações adicionais.",
                position: "top",
            },
        },
        {
            element: "#multiCollapseExample5",
            popover: {
                title: "Campos de Cadastros Adicionais",
                description: "Aqui ficam os dados adicionais a serem informados.",
                position: "top",
            },
        },
        {
            element: "#btnGravar",
            popover: {
                title: "Botão Gravar",
                description: "Ao clicar nesse botão você grava os dados inseridos.",
                position: "left",
            },
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description: "Ao clicar nesse botão você retorna para a tela de consulta da Entidade.",
                position: "left",
            },
        },
        ]);

        driver.start();
        driver.getHighlightedElement();
    });
});