$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#campostuto",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtCodigo",
        popover: {
          title: "Código",
          description:
            "O campo de código é preenchido automaticamente após gravar o registro.",
          position: "top",
        },
      },
      {
        element: "#txtDescricao",
        popover: {
          title: "Descrição",
          description:
            "Neste campo adicionamos a descrição para o caixa.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar o caixa.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let caixa = parametros[parametros.length - 1];

  $("#btnVoltar").on("click", async function () {
    window.location.href = `${BASE_URI}/cadcaixa`;
  });

  $(document).ready(async function () {
    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtCodigo: {
          required: true,
        },
        txtDescricao: {
          required: true,
        },
      },
      messages: {
        txtCodigo: {
          required: "Informe um código válido.",
        },
        txtDescricao: {
          required: "Informe uma descrição válida.",
        },
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });

    if (caixa != "" && caixa != "create") {
      carregaDados(caixa);
    }

    async function carregaDados(iCaixa) {
      try {
        $.LoadingOverlay("show");
        try {
          let response = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ 
                "tabela":"caixa_loja", 
                "camposSelect":["codigo", "descricao"], 
                "where": ["codigo = '${iCaixa}'"]}`,
            null
          );
          if (!response) {
            return;
          }
          let jsonStr = await response.json();
          if (response.status != 200) {
            msgAlerta(jsonStr.RESULT[0].mensagem);
            return;
          }

          $("#txtCodigo").val(jsonStr.RESULT[0][0].CODIGO);
          $("#txtDescricao").val(jsonStr.RESULT[0][0].DESCRICAO);

        } catch (error) {
          console.error(error);
          msgAlerta(`Não foi possível buscar os dados do caixa: ${error}`);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }

    $(".radio-group .radio").click(function () {
      $(this).parent().find(".radio").removeClass("selected");
      $(this).addClass("selected");
    });

    $(".submit").click(function () {
      return false;
    });
  });

  $("#btnGravar").click(async function () {
    try {
      let validator = $("#msform").validate();
      validator.form();
      let erros = 0;
      erros = validator.numberOfInvalids();

      if (erros == 0) {
        $.LoadingOverlay("show");

        let caixaClasse = {};

        caixaClasse.CODIGO = $("#txtCodigo").val() == '' ? await RetornaProximo("CAIXA_LOJA", "CAIXA_LOJA", "CODIGO", 3) : $("#txtCodigo").val();
        caixaClasse.DESCRICAO = $("#txtDescricao").val().toUpperCase();

        let response = await requisicao(
          "POST",
          "/sisplan/cadastros/v1/lojacaixa?",
          `JSON=${encodeURIComponent(JSON.stringify(caixaClasse))}`,
          null
        );

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgAlerta(jsonStr.mensagem);
          return;
        }
        $.LoadingOverlay("hide");
        toastr
          .success(`Cadastro efetuado com sucesso!
                    Caixa: ${caixaClasse.CODIGO}`,
            "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.href = `${BASE_URI}/cadcaixa`;
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      }
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
      msgAlerta(`Não foi possível gravar os dados do caixa: ${error}`);
    }
  });
});
