<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Cadastro de Bancos</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.237.18.2">
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.237.18.2">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.237.18.2" />
  <link href='../dist/css/bootstrap.min.css?versao=3.237.18.2'>
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.237.18.2">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.237.18.2">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.237.18.2">
  <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.237.18.2">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.237.18.2">
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.237.18.2">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.237.18.2" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.237.18.2">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <style>
    .labelGeral {
      margin-top: 7px;
      margin-bottom: 3px;
    }

    .labelCheck {
      font-size: 120%;
      /* border-bottom: outset 2px;
            border-left: outset 2px; */
      padding: 0.2%;
      margin-left: 1%;
    }

    .configCheck {
      -ms-transform: scale(1.5);
      -moz-transform: scale(1.5);
      -webkit-transform: scale(1.5);
      -o-transform: scale(1.5);
      transform: scale(1.5);
      padding: 10px;
    }

    .checkGroupRow {
      padding: 0;
      margin: 0;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid #fff !important;
      padding: 0 1.0em 0 1.0em !important;
      margin: 0 0 0 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../../menu.php');
    ?>

    <div id="myModal" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 id="myModalLabel" class="modal-title"></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <p id="myModalText"></p>
          </div>
          <div class="modal-footer">
            <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
            <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
          </div>
        </div>
      </div>
    </div>

    <div class="content-wrapper">
      <section class="content">
        <div class="content-header">
          <div class="container-fluid">
            <div class="row mb-2">
              <div class="col-sm-12">
                <ol class="breadcrumb float-sm-right">
                  <li class="breadcrumb-item"><a href="../index">Início</a></li>
                  <li class="breadcrumb-item"><a href="../cadbanco">Acesso Banco</a></li>
                  <li class="breadcrumb-item active">Cadastro de Banco</li>
                </ol>
              </div>
            </div>
          </div>
          <div class="row justify-content-center mt-0">
            <div class="col-10 text-center p-0 mt-3 mb-2">
              <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                  <h2>Cadastro de Banco
                    <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                      <i class="fas fa-question-circle"></i>
                    </button>
                  </h2>
                </div>
                <div class="row">
                  <div class="col-md-12 mx-0">
                    <form id="msform">
                      <!-- progressbar -->
                      <ul id="progressbar">
                        <li class="active" id="account" style="font-size: 100%; width:50%;"><strong>Geral</strong></li>
                        <li id="payment" style="font-size: 100%; width:50%;"><strong>Configurar Bordero</strong></li>
                      </ul> <!-- fieldsets -->
                      <p>Preencha os dados e clique em avançar para realizar o cadastro do banco</p>
                      <fieldset>
                        <div class="form-card" id="formcard1">
                          <div class="row">
                            <div class="col-12">

                              <div class="col-12">
                                <div class="row">
                                  <div class="form-group ml-3 pr-3">
                                    <fieldset class="form border-Field mb-0 pb-0">
                                    <legend class="textoBorda mb-0 pb-0">Opções</legend>
                                      <label class="" for="cbTituloTerceiros"><input type="checkbox" id="cbTituloTerceiros">     31 - Título Terceiros</label>
                                      <label class="" for="cbDoc">     <input type="checkbox" id="cbDoc">     03 - Doc</label>
                                      <label for="cbTed">     <input type="checkbox" id="cbTed">     08 - Ted</label>
                                    </fieldset>
                                  </div>
                                </div>
                              </div>
                              
                              <div class="col-12 ">
                                <div class="row">
                                  <div class="col-12 col-md-3 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo">Banco*</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control validate text-uppercase" minlength="3" maxlength="3" id="txtCodigo" name="txtCodigo" class="form-control" placeholder="Código do banco">
                                    </div>
                                  </div>

                                  <div class="col-md-9  col-12 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtDescricao">Nome do Banco*</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control text-uppercase" id="txtDescricao" name="txtDescricao" class="form-control" placeholder="Nome do Banco">
                                    </div>
                                  </div>
                                </div>
                              </div>

                              <div class="col-12 ">
                                <div class="row">
                                  <div class="col-md-12  col-12 form-group">
                                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtCliente">Cliente</label>
                                    <div class="input-group">
                                      <input type="text" class="input-default focus form-control" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                                      <div class="input-group-append">
                                        <button class="btn bg-danger" id="btn-cliente" name="btn-cliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                        <button class="btn bg-danger" id="btn-limpa-cliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>

                          <div class="row" style="margin-bottom: 1.5%">

                            <div class="col-12" id="GrupoInfoTour">
                              <div class="row">
                                <div class="card-left col-12 col-md-6 col-xl-7">
                                  <div class="row">
                                    <div class="col-12">
                                      <div class="row">
                                        <div class="col-md-6  col-12 form-group">
                                          <label data-error="wrong" class="labelGeral" data-success="right" for="txtValContrato">Valor do Contrato</label>
                                          <div class="input-group">
                                            <input type="text" class="input-default focus form-control" id="txtValContrato" name="txtValContrato" class="form-control" placeholder="Valor do Contrato">
                                          </div>
                                        </div>
                                        <div class="col-md-6  col-12 form-group">
                                          <label data-error="wrong" class="labelGeral" data-success="right" for="txtValDespesa">Valor Despesa</label>
                                          <div class="input-group">
                                            <input type="text" class="input-default focus form-control" id="txtValDespesa" name="txtValDespesa" class="form-control" placeholder="Valor Despesa">
                                          </div>
                                        </div>
                                      </div>
                                    </div>
                                    <div class="col-12">
                                      <div class="row">
                                        <div class="col-md-6  col-12 form-group">
                                          <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodComunicacao">Cód. PagFor:</label>
                                          <div class="input-group">
                                            <input type="text" class="input-default focus form-control" minlength="2" maxlength="2" id="txtCodComunicacao" name="txtCodComunicacao" class="form-control" placeholder="Código Comunicação PagFor">
                                          </div>
                                        </div>
                                        <div class="col-md-6  col-12 form-group">
                                          <label data-error="wrong" class="labelGeral" data-success="right" for="txtDesconto">% Desconto</label>
                                          <div class="input-group">
                                            <input type="text" class="input-default focus form-control" id="txtDesconto" name="txtDesconto" class="form-control" placeholder="% Desconto">
                                          </div>
                                        </div>
                                      </div>
                                      <div class="col-lg-12  col-12 form-group mt-2">
                                        <label>Importar o Extrato a partir da linha (0-10)</label>
                                        <input type="text" class="input-default focus form-control" min="0" max="10" id="rgExtrato" name="rgExtrato" value="0">
                                      </div>
                                    </div>
                                  </div>
                                </div>

                                <div class="card-right col-12 col-md-6 col-xl-5">
                                  <div class="col-sm-12 table-wrap">
                                    <fieldset class="form border-Field mb-0 pb-0" style="min-height: 243px;">
                                      <legend class="textoBorda mb-0 pb-0">Opções</legend>
                                      <label class="mt-2" for="cbUltimaLinhaExtrato">   <input type="checkbox" id="cbUltimaLinhaExtrato">     Importar última Linha Extrato</label> <br>
                                      <label for="cbBancoPadrao">   <input type="checkbox" id="cbBancoPadrao">     Banco Padrão</label> <br>
                                      <label for="cbSeguimentoQ">   <input type="checkbox" id="cbSeguimentoQ">     Gerar Seguimento Q</label> <br>
                                      <label for="cbSeguimentoR">   <input type="checkbox" id="cbSeguimentoR">     Gerar Seguimento R</label> <br>
                                      <label for="cbTarifaValPago">   <input type="checkbox" id="cbTarifaValPago">     Somar Tarifa no Valor Pago</label> <br>
                                      <label class="mb-3" for="cbPossuiIntegracao">   <input type="checkbox" id="cbPossuiIntegracao">     Possui Integração</label> <br>
                                    </fieldset>

                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <input type="button" name="avancar1" class="btn-sisp next action-button" value="Avançar" id="avancar1" />
                        <button type="button" id="btnVoltar" style="font-size:15px;" class="btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                      </fieldset>

                      <fieldset>
                        <div class="form-card">
                          <h2 class="fs-title">Configurar Bordero</h2>
                          <div class="row" id="contas">
                            <div class="col-12" id="GrupoInfoTour">
                              <div class="row">
                                <div class="col-md-6 col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtArqEnvio">Caminho Arq. Envio </label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtArqEnvio" name="txtArqEnvio" class="form-control" placeholder="Caminho do Arquivo de Envio">
                                  </div>
                                </div>
                                <div class="col-md-6  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtArquivoLayout">Arquivo Layout</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtArquivoLayout" name="txtArquivoLayout" class="form-control" placeholder="Arquivo Layout">
                                  </div>
                                </div>
                              </div>
                              <div class="row">
                                <div class="col-md-6  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtArqRetorno">Caminho Arq. Retorno</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" aria-describedby="ordemError" id="txtArqRetorno" name="txtArqRetorno" class="form-control" placeholder="Caminho do Arquivo de Retorno">
                                  </div>
                                </div>
                                <div class="col-md-6  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtNomeArquivo">Nome Aquivo</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" maxlength="10" aria-describedby="ordemError" id="txtNomeArquivo" name="txtNomeArquivo" class="form-control" placeholder="Nome do Arquivo">
                                  </div>
                                </div>
                              </div>
                              <div class="row">
                                <div class="col-md-6  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtArqRetornoLido">Caminho Arq. Retorno Lido</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtArqRetornoLido" name="txtArqRetornoLido" class="form-control" placeholder="Caminho do Arquivo de Retorno Lido">
                                  </div>
                                </div>
                                <div class="col-md-6  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtLayoutPagto">Layout Pagto</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtLayoutPagto" name="txtLayoutPagto" class="form-control" placeholder="Layout Pagto">
                                  </div>
                                </div>
                              </div>
                              <div class="row">
                                <div class="col-md-6  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtArqEnvioPagto">Caminho Arq. Envio Pagto</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtArqEnvioPagto" name="txtArqEnvioPagto" class="form-control" placeholder="Caminho do Arquivo de Envio Pagto">
                                  </div>
                                </div>
                                <div class="col-md-6  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtArqRetornoPagto">Caminho Arq. Retorno Pagto</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtArqRetornoPagto" name="txtArqRetornoPagto" class="form-control" placeholder="Caminho do Arquivo de Retorno Pagto">
                                  </div>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <input type="button" name="gravar" class="action-button" value="Gravar" id="gravar">
                        <input type="button" name="voltar4" class="previous action-button-previous" value="Voltar" id="voltar4">
                      </fieldset>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  </div>

  <?php
  include_once('../../../footer.php');
  ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  </div>
  <script src="../plugins/jquery/jquery.min.js?versao=3.237.18.2"></script>
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.237.18.2"></script>
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.237.18.2"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.237.18.2"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.237.18.2"></script>
  <script src="../dist/js/adminlte.min.js?versao=3.237.18.2"></script>
  <script src="../dist/js/requisicoes.js?versao=3.237.18.2"></script>
  <script src="../dist/js/cliente/entidade.js?versao=3.237.18.2"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.237.18.2"></script>
  <script src="../dist/js/valida_cpf_cnpj.js"></script>
  <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.237.18.2"></script>
  <script src="../dist/js/sisplan.js?versao=3.237.18.2"></script>
  <script src="../utils/funcoes.js?versao=3.237.18.2"></script>
  <script src="../utils/cookies.js?versao=3.237.18.2"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.237.18.2"></script>
  <script src="../dist/js/driver.min.js?versao=3.237.18.2"></script>
  <script src="../dist/js/dataTables.keyTable2.js?versao=3.237.18.2"></script>
  <script type="text/javascript" src="../config.js?versao=3.237.18.2"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('CADBANCO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      const permissaoUsuarioLogado = await permissaoAcessos("CADBANCO");

      if (permissaoUsuarioLogado.INCLUI == 'N') {
        await criaMensagemErro("Sem permissão para incluir!", () => {
          window.location.href = `${BASE_URI}/cadbanco`
        });
        return;
      }

      //código para liberar registro ao sair da tela clicando no menu, breadcrumb
      const queryString = window.location.href;
      const parametros = queryString.split('/');
      const banco = parametros[parametros.length - 1];

      $(window).on("beforeunload", function(e) {
        e.preventDefault();
        deletaRegistro('CADBANCO', getCookie('usuario'), parametros[5]);
        return undefined;
      });

      sArquivo = `${BASE_URI}/pages/cadbanco/cadastro_cadbanco/cadbanco.js?versao=3.237.18.2`;
      insereJavaScriptPagina(sArquivo);

      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>
</body>

</html>