$(document).ready(async function () {
  // await pesquisaObsSerasa();
  // obs = {}


  // async function preencheDadosObsSerasa() {
  //   if ($('#tabelaObsSerasa').DataTable().rows().data() == '') {
  //     $('#txtNumeroObsSerasa').val('');
  //     $('#txtObsSerasa').val('');
  //     $('#txtDataObsSerasa').val('');
  //   } else {
  //     const dados = await pesquisaObsSerasa();
  //     $('#txtNumeroObsSerasa').val(dados.NUMERO);
  //     $('#txtObsSerasa').val(dados.OBSERVACAO);
  //     $('#txtDataObsSerasa').val(dados.DATA);
  //   }
  // }

  // $('#modal_obs_serasa').on('shown.bs.modal', async function () {
  //   await preencheDadosObsSerasa();
  // });

  $('#btnIncluirObsSerasa').on('click', function () {
    $('#txtNumeroObsSerasa').val('');
    insereValor('#txtNumeroObsSerasa', '', { tipo: 'NUMERO', tabela: 'ENTID_OBS', campo: 'NUMERO', tamanho: 2 }, true);
    buscaDataAtual();
    $('#txtObsSerasa').val('');
    $('#btnIncluirObsSerasa').addClass('d-none');
    $('#btnGravarObsSerasa').removeClass('d-none');
    $('#btnCancelarObsSerasa').removeClass('d-none');
    $('#btnAlterarObsSerasa').addClass('d-none');
    // $('#btnImprimirObsSerasa').addClass('d-none');
    // $('#btnAnexarObsSerasa').addClass('d-none');
    $('#btnConsultaCertificadoObsSerasa').addClass('d-none');
    $('#btnFecharModalObsSerasa').addClass('d-none');
    $('#btnAbrirAnexosObsSerasa').addClass('d-none');
    $('#txtObsSerasa').attr('disabled', false);
    $('#txtObsSerasa').attr('readonly', false);
  });

  $('#btnCancelarObsSerasa').on('click', async function () {
    $('#btnIncluirObsSerasa').removeClass('d-none');
    $('#btnGravarObsSerasa').addClass('d-none');
    $('#btnCancelarObsSerasa').addClass('d-none');
    $('#btnAlterarObsSerasa').removeClass('d-none');
    // $('#btnImprimirObsSerasa').removeClass('d-none');
    // $('#btnAnexarObsSerasa').removeClass('d-none');
    $('#btnConsultaCertificadoObsSerasa').removeClass('d-none');
    $('#btnFecharModalObsSerasa').removeClass('d-none');
    $('#btnAbrirAnexosObsSerasa').removeClass('d-none');
    // $("#tabelaObsSerasa tr:eq(1)").trigger("click");
    $('#txtObsSerasa').attr('disabled', true);
    $('#txtObsSerasa').attr('readonly', true);
  });

  $('#btnAlterarObsSerasa').on('click', function () {
    $('#btnIncluirObsSerasa').addClass('d-none');
    $('#btnGravarObsSerasa').removeClass('d-none');
    $('#btnCancelarObsSerasa').removeClass('d-none');
    $('#btnAlterarObsSerasa').addClass('d-none');
    // $('#btnImprimirObsSerasa').addClass('d-none');
    // $('#btnAnexarObsSerasa').addClass('d-none');
    $('#btnConsultaCertificadoObsSerasa').addClass('d-none');
    $('#btnFecharModalObsSerasa').addClass('d-none');
    $('#btnAbrirAnexosObsSerasa').addClass('d-none');
    $('#txtObsSerasa').attr('disabled', false);
    $('#txtObsSerasa').attr('readonly', false);
  });

  async function testeConexao() {
    try {
      $.LoadingOverlay('show');
      try {
        let porta;
        porta = getCookie('porta_api_local');

        if (porta == '') {
          return false;
        }

        const response = await requisicao_ecf('GET', '/conexao/conexao?', ``, 1000);

        if (!response) {
          return false;
        }
        if (response.status == 200) {
          return true;
        }
      } catch (error) {
        console.error(error);
        return false;
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  // $('#btnConsultaCertificadoObsSerasa').on('click', async function () {

  //   $('#modal-consulta-certificado').modal('show');
  // });

  // $('#btnAnexarObsSerasa').on('click', function () {
  //   // $('#modal-anexos-serasa').modal('show');
  //   $('#file-input').trigger('click');
  // });

  function buscaDataAtual() {
    Date.prototype.toDateInputValue = (function () {
      var local = new Date(this);
      local.setMinutes(this.getMinutes() - this.getTimezoneOffset());
      return local.toJSON().slice(0, 10);
    });

    $(document).ready(function () {
      $('#txtDataObsSerasa').val(new Date().toDateInputValue());
    });
  }

  $('input[name="checkCert"]').change(function () {
    if ($(this).is(':checked')) {
      $('input[name="checkCert"]').not(this).prop('checked', false);
    }
  });

  async function validaTagPreenchida(json) {
    let naoPreenchido = [];

    for (var chave in json) {
      if (json.hasOwnProperty(chave)) {
        if (chave == 'bvcdlCodigoCdl' && !json[chave]) {
          naoPreenchido.push('CODIGOCDL')
        }
        if (chave == 'bvcdlCodigoAssociado' && !json[chave]) {
          naoPreenchido.push('CODIGOASSOCIADO')
        }
        if (chave == 'bvcdlCodigoFilial' && !json[chave]) {
          naoPreenchido.push('CODIGOFILIAL')
        }
        if (chave == 'bvcdlSenha' && !json[chave]) {
          naoPreenchido.push('SENHA')
        }
        if (chave == 'bvcdlUsuario' && !json[chave]) {
          naoPreenchido.push('USUARIO')
        }
        if (chave == 'bvcdlWsdl' && !json[chave]) {
          naoPreenchido.push('WSDL')
        }
        if (chave == 'bvcdlUrl' && !json[chave]) {
          naoPreenchido.push('URL')
        }
        if (chave == 'bvcdlWsdlConsulta' && !json[chave]) {
          naoPreenchido.push('WSDLCONSULTA')
        }
        if (chave == 'bvcdlUrlConsulta' && !json[chave]) {
          naoPreenchido.push('URLCONSULTA')
        }
      }
    }
    return naoPreenchido;
  }

  async function abreModalApiLocal(serasa, url) {
    try {
      $.LoadingOverlay("SHOW");;
      const response = await requisicao_ecf("POST", url, '', JSON.stringify(serasa));

      const jsonStr = await response.json();

      if (response.status != 200) {
        console.error(jsonStr.RESULT[0][0].mensagem);
        return;
      }

      return jsonStr;

    } catch (err) {
      // console.log(err);
      // msgAlerta('Não foi possível realizar a consulta, verifique se as informações contidas no Ini estão corretas ou entre em contato com o suporte.')
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#btnGravarObsSerasa').on('click', async function () {
    try {
      $.LoadingOverlay("show");

      let Serasa = {
        Numero: $('#txtNumeroObsSerasa').val(),
        Obs: $('#txtObsSerasa').val(),
        Codcli: pegaChave('#txtClienteObsSerasa'),
        Data: $('#txtDataObsSerasa').val(),
      };

      let response = await requisicao('POST', '/Sisplan/Cadastros/v1/serasa?', `JSON=${encodeURIComponent(JSON.stringify(Serasa))}`, null);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      };

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.mensagem);
        return;
      }
      $.LoadingOverlay("hide");
      toastr.success(
        `Cadastro efetuado com sucesso!
          Serasa: ${Serasa.Numero}`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          $('#modal_obs_serasa').modal('hide');
          $('#btnCancelarObsSerasa').trigger('click');
          $('#abaObsSerasa').trigger('click');
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });

    } catch (error) {
      console.error(error);
      // msgErro(`Não foi possível gravar os dados do tamanho: ${error}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function buscaIniApiLocal(serasa) {
    try {
      const response = await requisicao_ecf('GET', `/serasa/ini?`, `EMPRESADAO=${JSON.stringify(serasa)}`, '', 6000);

      const jsonIni = await response.json();
      if (!jsonIni) {
        return
      }
      if (response.status != 200) {
        console.error(jsonIni.RESULT[0][0].mensagem);
        return;
      }
      return jsonIni;
    } catch (err) {
      // console.log(err)
    }
  }

  $('#btnConsultaCertificadoObsSerasa').on('click', async function () {
    if (!await testeConexao()) {
      throw msgAlerta('Não está conectado a Api Local!');
    }
    if ($('#certBoaVista').is(':checked')) {
      const usuarioPermitido = getCookie('cod_usuario') == '0000' ? 'S' : await buscaValor('ACESSO_USUARIOS', 'USA_SERASA', 'NOME', getCookie('g_usuario_logado'));
      if (usuarioPermitido == 'N') {
        throw msgAlerta('Usuário não tem permissão para acessar consulta ao serasa, verifique com o administrador do sistema. (Checar Cadastro de usuario - Utilizar consulta SERASA)');
      }

      const Serasa = {
        Cnpj: $('#txtCNPJ').val(),
        Numero: $('#txtNumeroObsSerasa').val(),
        Parametro: 'N',
        UF: 'SC',
        empresadao: await retornaInformacaoEmpresa()
      };

      const jsonIni = await buscaIniApiLocal(Serasa)
      if (!jsonIni) {
        throw msgAlerta('Não conseguiu buscar os dados do Ini.')
      }
      if (!jsonIni.bvaUsuario && !jsonIni.bvaSenha) {
        throw msgAlerta('Para que seja possível conectar-se ao servidor Boa Vista é necessário um login e uma senha, verifique com a sisplan como adquirir esta credencial e também como configurar o sistema para ativar esta integração');
      }
      await abreModalApiLocal(Serasa, `/serasa/consultaboavista?`);
    }
    if ($('#certSerasa').is(':checked')) {
      const usuarioPermitido = getCookie('cod_usuario') == '0000' ? 'S' : await buscaValor('ACESSO_USUARIOS', 'USA_SERASA', 'NOME', getCookie('g_usuario_logado'));
      if (usuarioPermitido == 'N') {
        throw msgAlerta('Usuário não tem permissão para acessar consulta ao serasa, verifique com o administrador do sistema. (Checar Cadastro de usuario - Utilizar consulta SERASA)');
      }

      const Serasa = {
        Cnpj: $('#txtCNPJ').val(),
        Numero: $('#txtNumeroObsSerasa').val(),
        usuarioPermitido,
        Parametro: 'N',
        UF: 'SC',
        empresadao: await retornaInformacaoEmpresa()
      };

      const jsonIni = await buscaIniApiLocal(Serasa);

      if (!jsonIni.serasaEmail && !jsonIni.serasaSenha) {
        throw msgAlerta('Para que seja possível conectar-se ao servidor SERASA é necessário um login e uma senha, verifique com a sisplan como adquirir esta credencial e também como configurar o sistema para ativar esta integração');
      }
      await abreModalApiLocal(Serasa, `/serasa/consultaserasa?`);
    }
    if ($('#certDossieTotal').is(':checked')) {
      try {
        let jsonStr = '';
        const Serasa = {
          Cnpj: $('#txtCNPJ').val(),
          Numero: $('#txtNumeroObsSerasa').val(),
          UsuarioPermitido: 'S',
          Parametro: 'S',
          UF: 'SC',
          empresadao: await retornaInformacaoEmpresa()
        };
        const jsonIni = await buscaIniApiLocal(Serasa);

        if (!jsonIni.dossieCredencial) {
          msgAlerta('Tag CREDENCIAL no Ini não está configurada, deseja continuar?', async () =>
            jsonStr = await abreModalApiLocal(Serasa, `/serasa/consultadossietotal?`)
          )
        } else {
          jsonStr = await abreModalApiLocal(Serasa, `/serasa/consultadossietotal?`);
        }

        if (jsonStr.mensagem != "") {
          $('#txtNumeroObsSerasa').val(await RetornaProximo('NUMERO', 'ENTID_OBS', 'NUMERO', 2));
          buscaDataAtual();
          $('#txtObsSerasa').val('');
          $('#btnIncluirObsSerasa').addClass('d-none');
          $('#btnGravarObsSerasa').removeClass('d-none');
          $('#btnCancelarObsSerasa').removeClass('d-none');
          $('#btnAlterarObsSerasa').addClass('d-none');
          $('#btnImprimirObsSerasa').addClass('d-none');
          $('#btnAnexarObsSerasa').addClass('d-none');
          $('#btnConsultaCertificadoObsSerasa').addClass('d-none');
          $('#btnFecharModalObsSerasa').addClass('d-none');
          $('#btnAbrirAnexosObsSerasa').addClass('d-none');
          $('#txtObsSerasa').attr('disabled', false);
          $('#txtObsSerasa').attr('readonly', false);
          $('#txtObsSerasa').val(jsonStr.mensagem);
        }
      } catch (err) {

      }
    }
    if ($('#certConnect').is(':checked')) {
      const Serasa = {
        Cnpj: $('#txtCNPJ').val(),
        Numero: $('#txtNumeroObsSerasa').val(),
        UsuarioPermitido: 'S',
        Parametro: 'S',
        UF: 'SC',
        empresadao: await retornaInformacaoEmpresa()
      };

      const jsonIni = await buscaIniApiLocal(Serasa);
      if (!jsonIni.connectPassword && !jsonIni.connetLogin && !jsonIni.connectIdClient && !jsonIni.connectUrl) {
        throw msgAlerta('LOGIN, PASSWORD, IDCLIENT e/ou URL na Tag CONSULTACONNECT, verifique');
      }
      await abreModalApiLocal(Serasa, `/serasa/consultaconnect?`);
    }
    if ($('#certSerasaSitenet').is(':checked')) {
      const Serasa = {
        Cnpj: $('#txtCNPJ').val(),
        Numero: $('#txtNumeroObsSerasa').val(),
        Emp_pat: getCookie('empresa'),
        empresadao: await retornaInformacaoEmpresa()
      };

      const jsonIni = await buscaIniApiLocal(Serasa);
      if (!jsonIni.snetUsuario && !jsonIni.snetSenha) {
        throw msgAlerta('USUARIO e SENHA não informadas no ini na Tag "INTEGRACAOSITENET" ou "INTEGRACAOSITENET_+(EMPRESA_LOGADA)". Verifique.');
      }
      await abreModalApiLocal(Serasa, `/serasa/consultasitenet?`);
    }
    if ($('#certSerasaSCC').is(':checked')) {
      const Serasa = {
        Cnpj: $('#txtCNPJ').val(),
        Numero: $('#txtNumeroObsSerasa').val(),
        Emp_pat: getCookie('empresa'),
        empresadao: await retornaInformacaoEmpresa()
      };
      const jsonIni = await buscaIniApiLocal(Serasa);
      if (!jsonIni.sccUrl && !jsonIni.sccUsuario && !jsonIni.sccSenha) {
        throw msgAlerta('URL, USUARIO e/ou SENHA não foram informados na Tag SERASA_SCC, verifique');
      }

      msgAlerta(`Deseja prosseguir com a consulta no serasa para o cliente ${pegaDescricao('#txtClienteObsSerasa')}?`, async () =>
        await abreModalApiLocal(Serasa, `/serasa/consultascc?`)
      );
    }
    if ($('#certBoaVistaACP').is(':checked')) {
      const Serasa = {
        Cnpj: $('#txtCNPJ').val(),
        Numero: $('#txtNumeroObsSerasa').val(),
        Emp_pat: getCookie('empresa'),
        empresadao: await retornaInformacaoEmpresa()
      };

      const jsonIni = await buscaIniApiLocal(Serasa);

      if (!jsonIni.bvacpUsuario && !jsonIni.bvacpSenha) {
        throw msgAlerta('USUARIO e/ou SENHA não informados na Tag BOAVISTA_ACP, deseja continuar mesmo assim?', async () =>
          await abreModalApiLocal(Serasa, `/serasa/consultaboavistaacp?`)
        );
      } else {
        await abreModalApiLocal(Serasa, `/serasa/consultaboavistaacp?`)
      }
    }
    if ($('#certBoaVistaSCPC').is(':checked')) {
      const Serasa = {
        Cnpj: $('#txtCNPJ').val(),
        Numero: $('#txtNumeroObsSerasa').val(),
        Emp_pat: getCookie('empresa'),
        empresadao: await retornaInformacaoEmpresa()
      };

      const jsonIni = await buscaIniApiLocal(Serasa);

      let Tags = await validaTagPreenchida(jsonIni);

      if (Tags) {
        throw msgAlerta(Tags + ' não informados na Tag BOAVISTA_CDL, favor verificar.')
      }
      await abreModalApiLocal(Serasa, `/serasa/consultaboavistascpc?`);
    }
  });

});
