/* eslint-disable no-unused-vars */
class Login {
    encriptografarSenha(senha) {
        let encrypted = btoa(`sISPKJSDLK${senha}@klSIp1q34534sS`);

        return encrypted;
    }
}

function abreEstatisticasCliente(codcli, nome) {
    if (codcli == '') {
        msgErro("Não é possível mostrar as estatísticas, nenhum cliente informado.");
        return;
    }
    insereValor('#txtEstatisticaCliente', codcli, nome);
    $('#txtEstatisticaNomeCliente').html(`${codcli} - ${nome}`);
    $('#modal-estatisticas').modal('show');

    $('#btnEstatisticaConsultar').click();
}

async function abreModalAnexos(sChave, sDescricao, sTela) {
    const sUsuario = getCookie("cod_usuario");
    if (sChave == '') {
        msgErro("Não é possível mostrar os anexos.");
        return;
    }
    $('#txtTela').val(sTela);
    $('#txtUsuario').val(sUsuario);
    insereValor('#txtChave', `${sChave}`);
    $('#txtCodigoTittle').html(`${sChave} - ${sDescricao}`);
    $('#modal-anexos').modal('show');
}


async function abreModalMedidas(sChave, sDescricao) {
    $('#txtTitulo').html(`${sChave} - ${sDescricao}`);
    $('#btnBuscaMedidas').trigger('click');
    $('#modal-medidas').modal('show');
};

async function abreModalCombinacao(sCodigoProd, sDescricaoProd) {
    $('#txtCodigoProdTittle').html(`${sCodigoProd} - ${sDescricaoProd}`);
    $('#txtCodigoProdTittle').val(sCodigoProd);
    $('#modal-combinacao').modal('show');
};

async function abreModalHistProd(vCodigoProd, vDescricaoProd) {
    $('#txtTituloProduto').html(`${vCodigoProd} - ${vDescricaoProd}`);
    $('#txtTituloProduto').val(vCodigoProd);
    $('#modal-histprod').modal('show');
};

async function abreModalFluxoProd(codigo, descricao) {
    $('#txtTituloFluxo').html(`${codigo} - ${descricao}`);
    $('#modal-fluxoProduto').prop('codigoProduto', codigo);
    $('#modal-fluxoProduto').prop('descricaoProduto', descricao);
    $('#modal-fluxoProduto').modal('show');
};

async function abreModalProdItensEst(iCodigo, iDescricao) {
    $('#txtTituloProdEst').html(`${iCodigo} - ${iDescricao}`);
    $('#txtTituloProdEst').val(iCodigo);
    $('#modal-proditensest').modal('show');
};

async function duplicaCadastroProduto(codigo) {
    try {
        $.LoadingOverlay('show');
        try {

            let response = await requisicao(
                "POST",
                "/sisplan/funcoes/v1/duplicaproduto?",
                `codigo=${codigo}`,
                null
            );
            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
                msgAlerta(jsonStr.mensagem);
                return;
            }

            let codigoNovo = jsonStr.json;

            window.location.href = `produto/${codigoNovo}`;

        } catch (e) {
            console.error(e);
            msgErro(`Não foi possível duplicar o produto: ${error}`);
        }
    } finally {
        $.LoadingOverlay('hide');
    }
};

async function duplicaCadastroMaterial(codigo) {
    try {
        $.LoadingOverlay('show');
        try {

            let response = await requisicao(
                "POST",
                "/sisplan/funcoes/v1/duplicamaterial?",
                `codigo=${codigo}`,
                null
            );
            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
                msgAlerta(jsonStr.mensagem);
                return;
            }

            let codigoNovo = jsonStr.json;

            window.location.href = `material/${codigoNovo}`;

        } catch (e) {
            console.error(e);
            msgErro(`Não foi possível duplicar o material: ${error}`);
        }
    } finally {
        $.LoadingOverlay('hide');
    }
};

async function abreCadConsumo(sProduto) {
    window.location.href = `cadconsumo/${btoa(sProduto)}`;
};

function toggleTheme() {
    if (localStorage.getItem("theme") === "theme-dark") {
        setTheme("theme-light");
    } else {
        setTheme("theme-dark");
    }
}

function setTheme(themeName) {
    localStorage.setItem("theme", themeName);
    document.documentElement.className = themeName;
    let element = document.getElementById("theme-slider");
    if (element) {
        element.checked = themeName != "theme-light";
    }
}

(function () {
    if (localStorage.getItem("theme") === "theme-dark") {
        setTheme("theme-dark");
    } else {
        setTheme("theme-light");
    }
})();

async function retornaCamposObrigatorios(sTela) {
    try {
        let myHeaders = new Headers();
        myHeaders.append("pragma", "no-cache");
        myHeaders.append("cache-control", "no-cache");
        let response = await fetch(`../validacoes_internas/${sTela}.json`, {
            headers: myHeaders,
        });
        let data = await response.json();
        return data.campos_obrigatorios;
    } catch (error) {
        return undefined;
    }
}

function inputValido(e) {
    // eslint-disable-next-line no-var, no-redeclare
    var e = window.e || e;
    if (e.target.tagName !== "INPUT") return false;
    if (
        e.target.type !== "text" &&
        e.target.type !== "date" &&
        e.target.type !== "email"
    )
        return false;
    return true;
}

async function transformaCamposObrigatorios(sCamposObrigatorios, sCamposTela) {
    if (sCamposObrigatorios == undefined) {
        return;
    }
    for (let i = 0; i < sCamposObrigatorios.length; i++) {
        const campo = sCamposObrigatorios[i];
        const found = jQuery.grep(sCamposTela, function (element) {
            return element.id == campo;
        });
        if (found.length > 0) {
            $(found[0]).prop("required", true);
            jQuery.validator.addClassRules(found[0].name, {
                required: true,
            });
        }
    }
    jQuery.extend(jQuery.validator.messages, {
        required: "Campo obrigatório (regra da empresa)",
    });
}

async function BuscaCep(cepInput) {
    try {
        let cep = cepInput.val().replace("-", "").trim();
        let response = await requisicao(
            "GET",
            "/sisplan/funcoes/v1/pesquisa?",
            `JSON={ "tabela":"CADCEP", "camposSelect":["CIDADE.NOME CIDADE", "CIDADE.COD_UF UF"], "leftJoin": [{"tabela": "CIDADE", "condicao": "CADCEP.CODMUN = CIDADE.CODIGO"}], "where": ["CADCEP.cep = '${cep}'"]}`,
            null
        );
        if (!response) {
            var cidade = "";
            var uf = "";
        } else {
            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            var cidade = jsonStr.RESULT[0][0].CIDADE;
            var uf = jsonStr.RESULT[0][0].UF;
        }
    } catch (error) {
        var cidade = "";
        var uf = "";
    }
    return [cidade, uf];
}

async function buscaDadosEntidadeContabil(cliente) {
    try {
        var response = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ "tabela":"CONT_ENTIDADE", "camposSelect":["CODCLI", "CON_CLI", "ADI_CLI", "DEV_CLI", "CON_FOR", "ADI_FOR", "DEV_FOR"], "where": ["CODCLI = '${cliente}'"]}`,
            null
        );
        if (!response) {
            return;
        }
        var jsonStr = await response.json();

        try {
            let resposta1 = await requisicao(
                "GET",
                "/Sisplan/Funcoes/v1/pesquisa?",
                `JSON={ "tabela":"conta_cont", 
                    "camposSelect":["descricao"], 
                    "where": ["codigo = '${jsonStr.RESULT[0][0].CON_CLI}'"]}`,
                null
            );


            let jsonStr1 = await resposta1.json();

            insereValor(
                $("#txtContaCliente"),
                jsonStr.RESULT[0][0].CON_CLI,
                jsonStr1.RESULT[0][0].DESCRICAO
            );
        } catch (error) {
        }
        try {
            let resposta2 = await requisicao(
                "GET",
                "/Sisplan/Funcoes/v1/pesquisa?",
                `JSON={ "tabela":"conta_cont", 
                      "camposSelect":["descricao"], 
                      "where": ["codigo = '${jsonStr.RESULT[0][0].ADI_CLI}'"]}`,
                null
            );

            let jsonStr2 = await resposta2.json();

            insereValor(
                $("#txtContaCAdiantamento"),
                jsonStr.RESULT[0][0].ADI_CLI,
                jsonStr2.RESULT[0][0].DESCRICAO
            );
        } catch (error) {
        }

        try {
            let resposta3 = await requisicao(
                "GET",
                "/Sisplan/Funcoes/v1/pesquisa?",
                `JSON={ "tabela":"conta_cont", 
                        "camposSelect":["descricao"], 
                        "where": ["codigo = '${jsonStr.RESULT[0][0].DEV_CLI}'"]}`,
                null
            );


            let jsonStr3 = await resposta3.json();

            insereValor(
                $("#txtContaCDevolucao"),
                jsonStr.RESULT[0][0].DEV_CLI,
                jsonStr3.RESULT[0][0].DESCRICAO
            );
        } catch (error) {
        }

        try {
            let resposta4 = await requisicao(
                "GET",
                "/Sisplan/Funcoes/v1/pesquisa?",
                `JSON={ "tabela":"conta_cont", 
                          "camposSelect":["descricao"], 
                          "where": ["codigo = '${jsonStr.RESULT[0][0].CON_FOR}'"]}`,
                null
            );

            let jsonStr4 = await resposta4.json();

            insereValor(
                $("#txtContaFornecedor"),
                jsonStr.RESULT[0][0].CON_FOR,
                jsonStr4.RESULT[0][0].DESCRICAO
            );
        } catch (error) {
        }

        try {
            let resposta5 = await requisicao(
                "GET",
                "/Sisplan/Funcoes/v1/pesquisa?",
                `JSON={ "tabela":"conta_cont", 
                            "camposSelect":["descricao"], 
                            "where": ["codigo = '${jsonStr.RESULT[0][0].ADI_FOR}'"]}`,
                null
            );

            let jsonStr5 = await resposta5.json();

            insereValor(
                $("#txtContaFAdiantamento"),
                jsonStr.RESULT[0][0].ADI_FOR,
                jsonStr5.RESULT[0][0].DESCRICAO
            );
        } catch (error) {
        }

        try {
            let resposta6 = await requisicao(
                "GET",
                "/Sisplan/Funcoes/v1/pesquisa?",
                `JSON={ "tabela":"conta_cont", 
                              "camposSelect":["descricao"], 
                              "where": ["codigo = '${jsonStr.RESULT[0][0].DEV_FOR}'"]}`,
                null
            );

            let jsonStr6 = await resposta6.json();

            insereValor(
                $("#txtContaFDevolucao"),
                jsonStr.RESULT[0][0].DEV_FOR,
                jsonStr6.RESULT[0][0].DESCRICAO
            );
        } catch (error) {
        }


    } catch (error) {
        console.error(error);
        msgErro('Erro ao buscar dados do banco');
    }
}

async function clienteDoExterior(codcli) {
    try {
        if (codcli == '') {
            return false;
        }

        const pesquisa = {
            camposSelect: ['NOMCEP'],
            tabela: 'CADCEP',
            where: [`CEP IN (SELECT CEP FROM [ENTIDADE] WHERE CODCLI = '${codcli}')`]
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        if (jsonStr[0].NOMCEP == 'EXTERIOR') {
            return true;
        }
        return false;
    } catch (err) {
        console.error(err);
        return false;
    }

}

async function buscaDadosCliente(cliente, cnpjConsWww = "") {
    try {
        $.LoadingOverlay("show");
        let credito = [];
        if (cnpjConsWww == "") {
            var response = await requisicao(
                "GET",
                "/Sisplan/Cliente/V1/Entidade?",
                `codcli=${cliente}`,
                null
            );

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            var jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.mensagem);
                return;
            }

            var clienteJson = jsonStr[0];

            try {
                var response = await requisicao(
                    "GET",
                    "/Sisplan/Funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"ENTIDADE", "camposSelect":["OBS"], "where": ["CODCLI = '${cliente}'"]}`,
                    null
                );
                if (!response) {
                    var obs = "";
                    return;
                }
                var jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                var obs = jsonStr.RESULT[0][0].OBS;
            } catch (error) {
                var obs = "";
            }

            try {
                let jsonStr = await buscaDuplicatasEmAberto(cliente, 'S');
                if (!response) {
                    var moedas = "";
                    return;
                }
                // const jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                credito = jsonStr;
                // var credito = jsonStr.RESULT[0][0];
            } catch (error) {
                credito = [];
            }

            try {
                var response = await requisicao(
                    "GET",
                    "/Sisplan/Funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"sitcli", "camposSelect":["descricao"], "where": ["codigo = '${clienteJson.SIT_CLI}'"]}`,
                    null
                );
                if (!response) {
                    var sitcli = "";
                    return;
                }
                var jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                var sitcli =
                    jsonStr.RESULT[0][0].SIT_CLI === ""
                        ? ""
                        : `[${clienteJson.SIT_CLI}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
            } catch (error) {
                var sitcli = "";
            }

            try {
                var response = await requisicao(
                    "GET",
                    "/Sisplan/Funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"REG_ESTADO", "camposSelect":["descricao"], "where": ["codigo = '${clienteJson.REG_ESTADO}'"]}`,
                    null
                );
                if (!response) {
                    var regestado = "";
                    return;
                }
                var jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                var regestado =
                    jsonStr.RESULT[0][0].REG_ESTADO === ""
                        ? ""
                        : `[${clienteJson.REG_ESTADO}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
            } catch (error) {
                var regestado = "";
            }

            try {
                var response = await requisicao(
                    "GET",
                    "/sisplan/funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"ENTIDADE", "camposSelect":["ENTIDADE.CODREP", "REPRESEN.NOME"], "leftJoin": [{"tabela": "represen", "condicao": "entidade.codrep = represen.codrep"}], "where": ["ENTIDADE.CODCLI = '${cliente}'"]}`,
                    null
                );
                if (!response) {
                    var represen = "";
                    return;
                }
                var jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                var represen =
                    jsonStr.RESULT[0][0].CODREP === ""
                        ? ""
                        : `[${jsonStr.RESULT[0][0].CODREP}] - ${jsonStr.RESULT[0][0].NOME}`;
            } catch (error) {
                var represen = "";
            }

            try {
                var response = await requisicao(
                    "GET",
                    "/sisplan/funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"CLI_REGIAO",
                    "camposSelect":["CLI_REGIAO.CODCLI", "CLI_REGIAO.REGIAO", "REGIAO.DESCRICAO"],
                    "leftJoin": [{"tabela": "REGIAO", "condicao": "REGIAO.REGIAO = CLI_REGIAO.REGIAO"}],
                    "where": ["CLI_REGIAO.CODCLI = '${cliente}'"]}`,
                    null
                );
                if (!response) {
                    var represen = "";
                    return;
                }
                var jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }
                for (let i = 0; i < jsonStr.RESULT[0].length; i++) {
                    $('#gridTabelasModal').DataTable().row.add([jsonStr.RESULT[0][i].REGIAO, jsonStr.RESULT[0][i].DESCRICAO, retornaBotaoOpcoesModalTabelas()]).draw(false)
                    // const element = array[i];
                }
                // var represen = jsonStr.RESULT[0][0].CODREP === "" ? "" : `[${jsonStr.RESULT[0][0].CODCLI}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;

            } catch (error) {
                console.log(error)
            }

            try {
                var response = await requisicao(
                    "GET",
                    "/sisplan/funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"ENTIDADE", "camposSelect":["ENTIDADE.TABELA", "REGIAO.DESCRICAO"], "leftJoin": [{"tabela": "REGIAO", "condicao": "entidade.tabela = regiao.regiao"}], "where": ["ENTIDADE.CODCLI = '${cliente}'"]}`,
                    null
                );
                if (!response) {
                    var tabPreco = "";
                    return;
                }
                var jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                var tabPreco =
                    jsonStr.RESULT[0][0].TABELA === ""
                        ? ""
                        : `[${jsonStr.RESULT[0][0].TABELA}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
            } catch (error) {
                var tabPreco = "";
            }

            try {
                var response = await requisicao(
                    "GET",
                    "/sisplan/funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"ENTIDADE", "camposSelect":["ENTIDADE.TRANSPORTE", "TABTRAN.NOME"], "leftJoin": [{"tabela": "TABTRAN", "condicao": "ENTIDADE.TRANSPORTE = TABTRAN.CODIGO"}], "where": ["ENTIDADE.CODCLI = '${cliente}'"]}`,
                    null
                );
                if (!response) {
                    var transportadora = "";
                    return;
                }
                var jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                var transportadora =
                    jsonStr.RESULT[0][0].TRANSPORTE === ""
                        ? ""
                        : `[${jsonStr.RESULT[0][0].TRANSPORTE}] - ${jsonStr.RESULT[0][0].NOME}`;
            } catch (error) {
                var transportadora = "";
            }

            try {
                var response = await requisicao(
                    "GET",
                    "/sisplan/funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"ENTIDADE", "camposSelect":["ENTIDADE.GRUPO", "GRUPO_CLI.DESCRICAO"], "leftJoin": [{"tabela": "GRUPO_CLI", "condicao": "ENTIDADE.GRUPO = GRUPO_CLI.CODIGO"}], "where": ["ENTIDADE.CODCLI = '${cliente}'"]}`,
                    null
                );
                if (!response) {
                    var grupo = "";
                    return;
                }
                var jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                var grupo =
                    jsonStr.RESULT[0][0].GRUPO === ""
                        ? ""
                        : `[${jsonStr.RESULT[0][0].GRUPO}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
            } catch (error) {
                var grupo = "";
            }

            try {
                var codigoPais = "";
                var response = await requisicao(
                    "GET",
                    "/sisplan/funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"ENTIDADE", "camposSelect":["ENTIDADE.COD_PAIS", "CADPAIS.NOME"], "leftJoin": [{"tabela": "CADPAIS", "condicao": "ENTIDADE.COD_PAIS = CADPAIS.CODIGO"}], "where": ["ENTIDADE.CODCLI = '${cliente}'"]}`,
                    null
                );
                if (!response) {
                    codigoPais = "";
                    return;
                }
                var jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                codigoPais =
                    jsonStr.RESULT[0][0].COD_PAIS === ""
                        ? ""
                        : `[${jsonStr.RESULT[0][0].COD_PAIS}] - ${jsonStr.RESULT[0][0].NOME}`;
            } catch (error) {
                codigoPais = "";
            }

            try {
                var response = await requisicao(
                    "GET",
                    "/sisplan/funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"classe_ger", "camposSelect":["CODIGO", "DESCRICAO"], "where": ["CODIGO = '${clienteJson.CLASSE}'"]}`,
                    null
                );
                if (!response) {
                    var classe = "";
                    return;
                }
                var jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                var classe =
                    jsonStr.RESULT[0][0].CODIGO === ""
                        ? ""
                        : `[${jsonStr.RESULT[0][0].CODIGO}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
            } catch (error) {
                var classe = "";
            }

            try {
                var response = await requisicao(
                    "GET",
                    "/sisplan/funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"ENTIDADE", "camposSelect":["ENTIDADE.COD_CONF_XML", "FATCONF_XML.DESCRICAO"], "leftJoin": [{"tabela": "FATCONF_XML", "condicao": "ENTIDADE.COD_CONF_XML = FATCONF_XML.CODIGO"}], "where": ["ENTIDADE.CODCLI = '${cliente}'"]}`,
                    null
                );
                if (!response) {
                    var confXML = "";
                    return;
                }
                var jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                var confXML =
                    jsonStr.RESULT[0][0].COD_CONF_XML === ""
                        ? ""
                        : `[${jsonStr.RESULT[0][0].COD_CONF_XML}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
            } catch (error) {
                var confXML = "";
            }

            try {
                var response = await requisicao(
                    "GET",
                    "/sisplan/funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"TIPO_CONTATO", "camposSelect":["CODIGO", "DESCRICAO"], "where": ["CODIGO = '${clienteJson.CANAL_CONTATO}'"]}`,
                    null
                );
                if (!response) {
                    var tpContato = "";
                    return;
                }
                var jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                var tpContato = jsonStr.RESULT[0][0].CODIGO === "" ? "" : `[${jsonStr.RESULT[0][0].CODIGO}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
            } catch (error) {
                var tpContato = "";
            }

            try {
                var response = await requisicao(
                    "GET",
                    "/sisplan/funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"ENTID_DIA", "camposSelect":["DIA"], "where": ["CODCLI = '${cliente}'"]}`,
                    null
                );
                if (!response) {
                    var arrDiasCliente = "";
                    return;
                }
                var jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                var arrDiasCliente = jsonStr.RESULT[0];
            } catch (error) {
                var arrDiasCliente = "";
            }

            try {
                const response = await requisicao(
                    "GET",
                    "/sisplan/funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"ENT_MOEDA", "camposSelect":["ENT_MOEDA.CODMOE" , "MOEDA.DESCRICAO"], 
                    "where": ["ENT_MOEDA.CODCLI = '${cliente}'"], 
                    "leftjoin": [{"tabela": "MOEDA", "condicao" : "ENT_MOEDA.CODMOE = MOEDA.CODMOE"}]}`,
                    null
                );
                if (!response) {
                    var moedas = "";
                    return;
                }
                const jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                var moedas = jsonStr.RESULT[0];
            } catch (error) {
                var moedas = "";
            }

            try {
                var response = await requisicao(
                    "GET",
                    "/sisplan/funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"HISTCP", "camposSelect":["HISTORICO", "DESCRICAO"], "where": ["HISTORICO = '${clienteJson.HISTORICO}'"]}`,
                    null
                );
                if (!response) {
                    var historico = "";
                    return;
                }
                var jsonStr = await response.json();
                if (response.status != 200) {
                    $.LoadingOverlay("hide");
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                var historico =
                    jsonStr.RESULT[0][0].HISTORICO === ""
                        ? ""
                        : `[${jsonStr.RESULT[0][0].HISTORICO}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
            } catch (error) {
                var historico = "";
            }

            try {
                if (clienteJson.CONDICAO_PAGAMENTO != '') {
                    var response = await requisicao(
                        "GET",
                        "/sisplan/funcoes/v1/pesquisa?",
                        `JSON={ "tabela":"CONDICAO", "camposSelect":["CODCOND", "DESCRICAO"], "where": ["CODCOND = '${clienteJson.CONDICAO_PAGAMENTO}'"]}`,
                        null
                    );
                    if (!response) {
                        var condicaopagto = "";
                        return;
                    }
                    var jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    var condicaopagto =
                        jsonStr.RESULT[0][0].CODCOND === ""
                            ? ""
                            : `[${jsonStr.RESULT[0][0].CODCOND}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
                }
            } catch (error) {
                var condicaopagto = "";
            }

        } else {
            try {
                clienteJson = await retornaConsultaWWW(cnpjConsWww);
            } catch {
                console.log("Erro ao consultar");
            }
        }

        if (clienteJson != undefined) {
            if (cnpjConsWww == "") {
                $("#txtCNPJ").val(clienteJson.CNPJ);
                $("#rgSexo")
                    .val(clienteJson.SEXO == "M" ? "M" : "F")
                    .change();
                if (clienteJson.DT_NASC != undefined) {
                    $("#txtDataNascimento").val(clienteJson.DT_NASC.slice(0, 10));
                }
                if (clienteJson.DATA_BUSCA != undefined) {
                    $("#txtDataAlteracao").val(clienteJson.DATA_BUSCA.slice(0, 10));
                }
                if (clienteJson.DATA_CAD != undefined) {
                    $("#txtDataCadastro").val(clienteJson.DATA_CAD.slice(0, 10));
                }
                $("#rgIE").val(clienteJson.IE_DESTINATARIO).change();
                $("#rgPorteEmpresa").val(clienteJson.PORTE_EMPRESA).change();
                $("#cbAtivo").prop("checked", clienteJson.ATIVO == "S");
                $("#cbIntegraShop").prop("checked", clienteJson.INTEGRA_SHOPP == "N");
                $("#cbConsumidorFinal").prop(
                    "checked",
                    clienteJson.CONS_FINAL == "Sim"
                );
                $("#txtCepEntrega").val(clienteJson.CEP_ENT);
                $("#txtRuaEntrega").val(clienteJson.END_ENT);
                $("#txtNumeroEntrega").val(clienteJson.NUM_ENT);
                $("#txtComplementoEntrega").val(clienteJson.COMP_ENT);
                $("#txtBairroEntrega").val(clienteJson.BAIRRO_ENT);
                $("#txtNomePai").val(clienteJson.NOME_PAI);
                $("#txtNomeMae").val(clienteJson.NOME_MAE);
                $("#txtEstadoCivil").val(clienteJson.ESTADO_CIVIL);
                $("#txtRenda").val(clienteJson.RENDA);
                $("#txtMidiaSocial").val(clienteJson.MIDIAS_SOCIAIS);
                if (clienteJson.DT_ADMISSAO != undefined) {
                    $("#txtDtAdmissao").val(clienteJson.DT_ADMISSAO.slice(0, 10));
                }

                var retorno = await BuscaCep($("#txtCepEntrega"));
                $("#txtCidadeEntrega").val(retorno[0]);
                $("#txtUFEntrega").val(retorno[1]);

                $("#txtCepCobranca").val(clienteJson.CEP_COB);
                $("#txtRuaCobranca").val(clienteJson.END_COB);
                $("#txtNumeroCobranca").val(clienteJson.NUM_COB);
                $("#txtComplementoCobranca").val(clienteJson.COMP_COB);
                $("#txtBairroCobranca").val(clienteJson.BAIRRO_COB);

                var retorno = await BuscaCep($("#txtCepCobranca"));
                $("#txtCidadeCobranca").val(retorno[0]);
                $("#txtUFCobranca").val(retorno[1]);

                $('#rgSemanaMes').val(clienteJson.TIPO_DIAS_VENCTO).change();

                arrDiasCliente.map(item => {
                    if (clienteJson.TIPO_DIAS_VENCTO == 'SEMANA') {
                        $(`#cbSemana${item.DIA}`).prop('checked', true);
                    }
                    if (clienteJson.TIPO_DIAS_VENCTO == 'MES') {
                        $(`#cbDia${item.DIA}`).prop('checked', true);
                    }
                });

                await insereValorPesquisaVarios('txtMoeda', 'CODMOE', 'DESCRICAO', moedas);

            } else {
                $("#cbAtivo").prop("checked", true);
                $("#cbConsumidorFinal").prop("checked", true);
                $("#rgIE").val("9").change();
                $("#txtDataCadastro").val(new Date().toISOString().slice(0, 10));
                $("#txtDataAlteracao").val(new Date().toISOString().slice(0, 10));
                $("#txtDataNascimento").val(
                    new Date("1980-01-01").toISOString().slice(0, 10)
                );
                $("#rgSexo").val("M").change();
            }
            $("#txtNome").val(clienteJson.NOME);
            $("#txtFantasia").val(clienteJson.FANTASIA);
            $("#txtObs").val(obs);
            $("#cbBloqueado").prop("checked", clienteJson.BLOQUEIO == "S");
            $("#txtRG").val(clienteJson.NUM_RG);
            $("#txtEmissor").val(clienteJson.EMI_RG);
            $("#txtIE").val(clienteJson.INSCRICAO);
            $("#txtCep").val(clienteJson.CEP);
            $("#txtPais").val(codigoPais || "[1058] - BRASIL");
            $("#txtRua").val(clienteJson.ENDERECO);
            $("#txtNumero").val(clienteJson.NUMERO);
            $("#txtComplemento").val(clienteJson.COMPLEMENTO);
            $("#txtBairro").val(clienteJson.BAIRRO);

            await BuscaECadastraCep($("#txtCep"));
            var retorno = await BuscaCep($("#txtCep"));
            $("#txtCidade").val(retorno[0]);
            $("#txtUF").val(retorno[1]);

            $("#txtDDD").val(clienteJson.DDD_FONE);
            $("#txtTelefone").val(clienteJson.TELEFONE);
            $("#txtEmail").val(clienteJson.EMAIL);
            $("#txtRepresentante").val(represen);

            $('#txtCreditoGrupo').val(clienteJson.CRED_CONSIGNADO);
            $("#txtLimiteUsado").val(clienteJson.CREDITO_UTILIZADO);
            $("#txtLimiteCredito").val(clienteJson.CREDITO);
            let data = new Date();
            let vAVencer = 0;
            let vVencido = 0;
            let vAnteci = 0;
            let vCheqD = 0;
            let vAberto = 0;
            data = `${data.getUTCFullYear()}-${String(
                data.getUTCMonth() + 1
            ).padStart(2, 0)}-${String(data.getUTCDate()).padStart(2, 0)}`;

            for (let i = 0; i < credito.length; i++) {
                if ((credito[i].DT_VENCTO <= data) && (['DUPL', 'CHEQ'].includes(credito[i].STATUS))) {
                    vVencido = parseFloat(vVencido) + parseFloat(credito[i].SALDO);
                } else if ((credito[i].DT_VENCTO > data) && (['DUPL', 'CHEQ'].includes(credito[i].STATUS))) {
                    vAVencer = parseFloat(vAVencer) + parseFloat(credito[i].SALDO);
                } else if (['ANTE'].includes(credito[i].STATUS)) {
                    vAnteci = parseFloat(vAnteci) + parseFloat(credito[i].SALDO);
                } else if (['CHDE'].includes(credito[i].STATUS)) {
                    vCheqD = parseFloat(vCheqD) + parseFloat(credito[i].SALDO);
                }
            };

            vAberto = parseFloat(vVencido) + parseFloat(vAVencer) + parseFloat(vCheqD) - parseFloat(vAnteci);
            $("#txtLimiteUsado").val(vAberto.toFixed(2));
            $("#txtLimiteDisponivel").val(TruncaDecimaisNova(2, clienteJson.CREDITO - $("#txtLimiteUsado").val()));

            // $("#txtLimiteUsado").val(credito.VALOR);
            // $("#txtLimiteCredito").val(clienteJson.CREDITO);
            // $("#txtLimiteDisponivel").val(TruncaDecimaisNova(2, clienteJson.CREDITO - credito.VALOR));

            $("#txtLimiteFidelidade").val(clienteJson.LIMITE_FID);
            $("#txtLimiteFidelidadeUsado").val(clienteJson.LIMITE_UTIL_FID);
            $("#txtLimiteFidelidadeDisponivel").val($("#txtLimiteFidelidade").val() - $("#txtLimiteFidelidadeUsado").val());

            $("#txtTabela").val(tabPreco);
            $("#txtGrupo").val(grupo);
            $('#txtHistorico').val(historico)
            $("#rgTipoFrete").val(clienteJson.TP_FRETE);
            $("#txtTransportadora").val(transportadora);
            $("#txtClasse").val(classe);
            $('#txtConfXML').val(confXML);
            $("#txtCanalContato").val(tpContato);

            $('#txtCondicaoPagto').val(condicaopagto);

            $("#txtRamoAtividade").val(sitcli);
            $("#txtRegiao").val(regestado);
            $("#txtLocalTrab").val(clienteJson.LOCAL_TRAB);
            $("#rgTributacao").val(clienteJson.SIMPLES);
            $("#txtCodCli").val(clienteJson.CODCLI);
            $("#txtInscCob").val(clienteJson.INSC_COB);
            $("#txtInscEnt").val(clienteJson.INSC_ENT);

            if (clienteJson.TIPO_ENTIDADE.includes('C')) {
                $("#cbTipoCliente").prop("checked", true);
            }
            if (clienteJson.TIPO_ENTIDADE.includes('F')) {
                $("#cbTipoFornecedor").prop("checked", true);
            }
            if (clienteJson.TIPO_ENTIDADE.includes('T')) {
                $("#cbTipoTerceiros").prop("checked", true);
            }
            if (clienteJson.TIPO_ENTIDADE.includes('R')) {
                $("#cbTipoRepresentante").prop("checked", true);
            }
            if (clienteJson.TIPO_ENTIDADE.includes('P')) {
                $("#cbTipoProspecto").prop("checked", true);
            }

            if (clienteJson.TIPO_ENTIDADE.includes('E')) {
                $("#cbTipoFuncionario").prop("checked", true);
            }

        }
        $.LoadingOverlay("hide");
    } catch (error) {
        $.LoadingOverlay("hide");
        msgErro(`Não foi possível buscar os dados do cliente: ${error}`);
    }
}

async function BuscaECadastraCep(cepInput) {
    try {
        $.LoadingOverlay("show");
        try {
            let cep = cepInput.val().replace("-", "").trim();
            let response = await requisicao(
                "GET",
                "/sisplan/cep/v1/CEP?",
                `CEP=${cep}`,
                null
            );
            if (!response) {
                var cidade = "";
                var uf = "";
                var endereco = "";
                var bairro = "";
            } else {
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }
                var cidade = jsonStr.nOMCIDADE;
                var uf = jsonStr.eSTCEP;
                var endereco = jsonStr.nOMCEP;
                var bairro = jsonStr.bAIRRO;
            }
        } catch (error) {
            var cidade = "";
            var uf = "";
        }
        return [cidade, uf, endereco, bairro];
    } finally {
        $.LoadingOverlay("hide");
    }
}


async function importaMenu(path = '') {
    const xhr = new XMLHttpRequest();
    xhr.open('GET', `${path}menu.html`);
    xhr.onload = function () {
        if (xhr.status === 200) {
            // Insere o conteúdo do arquivo modal.html na div #modal-container
            document.getElementById('import-menu').innerHTML = xhr.response;
            const scripts = document.querySelectorAll('#import-menu script');
            for (var i = 0; i < scripts.length; i++) {
                eval(scripts[i].innerHTML);
            }
        } else {
            console.log('Erro ao carregar o menu: ' + xhr.status);
        }
    };
    xhr.send();
}

async function importaFooter(path = '') {
    const xhr = new XMLHttpRequest();
    xhr.open('GET', `${path}footer.html`);
    xhr.onload = function () {

        if (xhr.status === 200) {
            document.getElementById('import-footer').innerHTML = xhr.responseText;
            const scripts = document.querySelectorAll('#import-footer script');
            console.log('total', scripts.length);
            // for (var i = 0; i < scripts.length; i++) {
            //   eval(scripts[i].innerHTML);
            // }
        } else {
            console.log('Erro ao carregar o footer: ' + xhr.status);
        }
    };
    xhr.send();
}

async function insereJavaScriptPagina(sArquivo) {
    (function () {
        let li = document.createElement("script");
        li.type = "text/javascript";
        li.src = sArquivo;
        li.async = true;
        let s = document.getElementsByTagName("script")[0];
        s.parentNode.insertBefore(li, s);
    })();
}

async function salvaCamposObrigatorios(objeto, sTela) {
    let response;
    let campos_object = new Object();
    campos_object.campos_obrigatorios = objeto;
    try {
        response = await fetch(`../salvar_validacao_interna.php?tela=${sTela}`, {
            method: "POST",
            body: `${JSON.stringify(campos_object)}`,
        });
    } catch (error) {
        msgAlerta("Erro ao salvar campos obrigatórios");
    }
    return response;
}

async function salvaArquivoCamposObrigatorios(sTela, sCampo) {
    let campos_obrigatorios = await retornaCamposObrigatorios(sTela);
    if (campos_obrigatorios == undefined) {
        campos_obrigatorios = [];
    }
    if (campos_obrigatorios.indexOf(sCampo) == -1) {
        campos_obrigatorios.push(sCampo);
        toastr.success(`Tornado campo (${sCampo}) obrigatório.`);
    } else {
        campos_obrigatorios.splice(campos_obrigatorios.indexOf(sCampo), 1);
        toastr.warning(`Tornado campo (${sCampo}) opcional.`);
    }
    await salvaCamposObrigatorios(campos_obrigatorios, sTela);
}

async function habilitaCamposObrigatoriosTela(nomeTela) {
    async function ativaCampoObrigatorio(e) {
        if (inputValido(e) && e.ctrlKey && e.key == "F8") {
            // ctrl + b por enquanto
            await salvaArquivoCamposObrigatorios(nomeTela, e.target.id);
            let campos_obrigatorios = await retornaCamposObrigatorios(nomeTela); // pega os campos do json do arquivo
            if (campos_obrigatorios == undefined) {
                campos_obrigatorios = [];
            }
            transformaCamposObrigatorios(campos_obrigatorios, $("input"));
        }
    }

    document.addEventListener("keydown", ativaCampoObrigatorio, false);
    let campos_obrigatorios = await retornaCamposObrigatorios(nomeTela); // pega os campos do json do arquivo
    if (campos_obrigatorios == undefined) {
        campos_obrigatorios = [];
    }
    transformaCamposObrigatorios(campos_obrigatorios, $("input"));
}

function pegaChave(componente, _) {
    if (!componente) {
        return "";
    }
    let campo = "";
    try {
        campo = $(componente).val();
        if (campo == undefined) {
            campo = componente;
        }
    } catch (error) {
        campo = componente;
    }
    return campo.substring(1, campo.indexOf("]"));
}

function pegaDescricao(componente, retorno) {
    let campo = "";
    try {
        campo = $(componente).val();
        if (campo == undefined) {
            campo = componente;
        }
    } catch (error) {
        campo = componente;
    }
    return (retorno = campo.substring(campo.indexOf("]") + 4, campo.length));
}

async function SalvaParametro(param) {
    let response = await requisicao(
        "POST",
        "/Sisplan/Parametro/v1/Loja?",
        "",
        `JSON=${encodeURIComponent(JSON.stringify(param))}`,
        30000
    );

    if (!response) {
        throw "Não foi possível buscar os dados.";
    }

    if (response.status != 200) {
        let jsonStr = await response.json();
        throw new Error(jsonStr.mensagem);
    }
}

function SomAlerta(baseURL = '/sisplan_web', bErro = false) {
    if ($('.somAtivo').hasClass('d-none')) {
        return;
    }
    const som = bErro == false ? 'beep.mp3' : 'erro.mp3';
    const music = new Audio(`${baseURL}/dist/sounds/${som}`);
    music.play();
}

function retornaBotaoOpcoesModalTabelas() {
    return '<div class="divBtnOpcoes"> ' +
        '    <button class="botaoOpcoes btn-excluir" type="button"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
        '   </div>';
}

async function BuscaParametrosLoja() {
    try {
        let empId = getCookie("emp_id");
        if (!empId) {
            window.location.href = `${BASE_URI}/login`;
            return '';
        }
        let url = `/sisplan/funcoes/v1/pesquisa?`;
        let response = await requisicao(
            "GET",
            url,
            `JSON={ "tabela":"LOJA_PARAM", "camposSelect":["VALOR", "POSICAO"], "where": ["EMP_ID = ${empId} AND TIPO = 'VENDA'"], "orderby": ["posicao"]}`,
            null
        );

        if (!response) {
            msgErro("Não foi possível buscar os dados.");
            return;
        }

        let jsonStr = await response.json();

        return jsonStr.RESULT[0];
    } catch (error) {
        console.error(error);
    }
}

async function BuscaParametrosReceber() {
    try {
        let empId = getCookie("emp_id");
        if (!empId) {
            window.location.href = `${BASE_URI}/login`;
            return '';
        }
        let url = `/sisplan/funcoes/v1/pesquisa?`;
        let response = await requisicao(
            "GET",
            url,
            `JSON={ "tabela":"LOJA_PARAM", "camposSelect":["VALOR", "POSICAO"], "where": ["EMP_ID = ${empId} AND TIPO = 'RECEBER'"],"orderby": ["posicao"]}`,
            null
        );

        if (!response) {
            msgErro("Não foi possível buscar os dados.");
            return;
        }

        let jsonStr = await response.json();

        return jsonStr.RESULT[0];
    } catch (error) {
        console.error(error);
    }
}

async function BuscaParametrosFaturamento() {
    try {
        let empId = getCookie("emp_id");
        if (!empId) {
            window.location.href = `${BASE_URI}/login`;
            return '';
        }
        let url = `/sisplan/funcoes/v1/pesquisa?`;
        let response = await requisicao(
            "GET",
            url,
            `JSON={ "tabela":"LOJA_PARAM", "camposSelect":["VALOR", "POSICAO"], "where": ["EMP_ID = ${empId} AND TIPO = 'FATURAMENTO'"],"orderby": ["posicao"]}`,
            null
        );

        if (!response) {
            msgErro("Não foi possível buscar os dados.");
            return;
        }

        let jsonStr = await response.json();

        return jsonStr.RESULT[0];
    } catch (error) {
        console.error(error);
    }
}

async function BuscaParametrosProduto() {
    try {
        let empId = getCookie("emp_id");
        if (!empId) {
            window.location.href = `${BASE_URI}/login`;
            return '';
        }
        let url = `/sisplan/funcoes/v1/pesquisa?`;
        let response = await requisicao(
            "GET",
            url,
            `JSON={ "tabela":"LOJA_PARAM", "camposSelect":["VALOR", "POSICAO"], "where": ["EMP_ID = ${empId} AND TIPO = 'PRODUTO'"],"orderby": ["posicao"]}`,
            null
        );

        if (!response) {
            msgErro("Não foi possível buscar os dados.");
            return;
        }

        let jsonStr = await response.json();

        return jsonStr.RESULT[0];
    } catch (error) {
        console.error(error);
    }
}

async function BuscaParametrosExpedicao() {
    try {
        let empId = getCookie("emp_id");
        if (!empId) {
            window.location.href = `${BASE_URI}/login`;
            return '';
        }
        let url = `/sisplan/funcoes/v1/pesquisa?`;
        let response = await requisicao(
            "GET",
            url,
            `JSON={ "tabela":"LOJA_PARAM", "camposSelect":["VALOR", "POSICAO"], "where": ["EMP_ID = ${empId} AND TIPO = 'EXPEDICAO'"],"orderby": ["posicao"]}`,
            null
        );

        if (!response) {
            msgErro("Não foi possível buscar os dados.");
            return;
        }

        let jsonStr = await response.json();

        return jsonStr.RESULT[0];
    } catch (error) {
        console.error(error);
    }
}

async function BuscaParametrosSistema(apenasValor = 'N') {
    try {
        const parametrosLogin = sessionStorage.getItem('web@parametros') ?? [];
        if (parametrosLogin.length > 0) {
            const parametrosObject = JSON.parse(parametrosLogin);
            const valores = apenasValor == 'S' ? parametrosObject.filter(param => param.TIPO == 'SISTEMA').map(param => param.VALOR)
                : parametrosObject.filter(param => param.TIPO == 'SISTEMA');
            // console.log('params buscaparamsistemas', valores);
            return valores;
        }

        const empId = getCookie("emp_id");
        if (!empId) {
            window.location.href = `${BASE_URI}/login`;
            return '';
        }
        const url = `/sisplan/funcoes/v1/pesquisa?`;
        const response = await requisicao(
            "GET",
            url,
            `JSON={ "tabela":"LOJA_PARAM", "camposSelect":["VALOR", "POSICAO"], "where": ["EMP_ID = ${empId} AND TIPO = 'SISTEMA'"],"orderby": ["posicao"]}`,
            null
        );

        if (!response) {
            msgErro("Não foi possível buscar os dados.");
            return;
        }

        const jsonStr = await response.json();

        if (apenasValor == 'S') {
            if (jsonStr.RESULT[0].length > 0) {
                for (let i = 0; i < jsonStr.RESULT[0].length; i++) {
                    jsonStr.RESULT[0][i] = jsonStr.RESULT[0][i].VALOR;
                }
                // console.log('params buscaparamsistemas2', jsonStr.RESULT[0]);
                return jsonStr.RESULT[0];
            }
            return [];
        } else {
            // console.log('params buscaparamsistemas3', jsonStr.RESULT[0]);
            return jsonStr.RESULT[0];
        }
    } catch (error) {
        console.error(error);
    }
}

async function BuscaParametrosEntidade() {
    try {
        let empId = getCookie("emp_id");
        if (!empId) {
            window.location.href = `${BASE_URI}/login`;
            return '';
        }
        let url = `/sisplan/funcoes/v1/pesquisa?`;
        let response = await requisicao(
            "GET",
            url,
            `JSON={ "tabela":"LOJA_PARAM", "camposSelect":["VALOR", "POSICAO"], "where": ["EMP_ID = ${empId} AND TIPO = 'ENTIDADE'"],"orderby": ["posicao"]}`,
            null
        );

        if (!response) {
            msgErro("Não foi possível buscar os dados.");
            return;
        }

        let jsonStr = await response.json();

        return jsonStr.RESULT[0];

    } catch (error) {
        console.error(error);
    }
}

async function CopiaParametro(sTipo, iPosicao) {

    const parametrosLogin = sessionStorage.getItem('web@parametros') ?? [];
    if (parametrosLogin.length > 0) {
        const parametrosObject = JSON.parse(parametrosLogin);
        const valor = parametrosObject.find(param => param.TIPO == sTipo && param.POSICAO == iPosicao).VALOR;

        // console.log('params copiaparam', valor);
        return valor;
    }


    const emp_id = getCookie("emp_id");
    if (!emp_id) {
        window.location.href = `${BASE_URI}/login`;
        return '';
    }
    const _url = `/sisplan/funcoes/v1/pesquisa?`;
    const response = await requisicao(
        "GET",
        _url,
        `JSON={ "tabela":"loja_param", "camposSelect":["valor"], "where": ["tipo = '${sTipo}'", "posicao = ${iPosicao}", "emp_id = ${emp_id}"]}`,
        null
    );

    if (!response) {
        throw "Não foi possível buscar os dados.";
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
        msgAlerta(jsonStr.RESULT[0].mensagem);
        throw "Não foi possível buscar os dados.";
    }

    if (jsonStr.RESULT[0].length > 0) {
        // console.log('params copiaparam2', jsonStr.RESULT[0][0].VALOR);
        return jsonStr.RESULT[0][0].VALOR;
    }
}

async function BuscaParametrosVenda() {
    const parametrosLogin = sessionStorage.getItem('web@parametros') ?? [];
    if (parametrosLogin.length > 0) {
        const parametrosObject = JSON.parse(parametrosLogin);
        const valores = parametrosObject.filter(param => param.TIPO == 'VENDA').map(param => param.VALOR);
        // console.log('params venda', valores);
        return valores;
    }

    const url = `/sisplan/funcoes/v1/pesquisa?`;
    const empId = getCookie("emp_id");
    if (!empId) {
        window.location.href = `${BASE_URI}/login`;
        return [];
    }
    const response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"loja_param", "camposSelect":["valor"], "where": ["tipo = 'VENDA'", "emp_id = ${empId}"], "orderby": ["POSICAO"]}`,
        null
    );

    if (!response) {
        throw new Error("Não foi possível buscar os dados.");
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
        msgAlerta(jsonStr.RESULT[0].mensagem);
        throw new Error("Não foi possível buscar os dados.");
    }

    if (jsonStr.RESULT[0].length > 0) {
        for (let i = 0; i < jsonStr.RESULT[0].length; i++) {
            jsonStr.RESULT[0][i] = jsonStr.RESULT[0][i].VALOR;
        }

        // console.log('params venda2', jsonStr.RESULT[0]);
        return jsonStr.RESULT[0];
    }
    return [];
}

async function BuscaParametrosPedidoB2B() {
    try {
        let empId = getCookie("emp_id");
        if (!empId) {
            window.location.href = `${BASE_URI}/login`;
            return '';
        }
        let url = `/sisplan/funcoes/v1/pesquisa?`;
        let response = await requisicao(
            "GET",
            url,
            `JSON={ "tabela":"LOJA_PARAM", "camposSelect":["VALOR", "POSICAO"], "where": ["EMP_ID = ${empId} AND TIPO = 'PEDIDOB2B'"],"orderby": ["posicao"]}`,
            null
        );

        if (!response) {
            msgErro("Não foi possível buscar os dados.");
            return;
        }

        let jsonStr = await response.json();

        return jsonStr.RESULT[0];

    } catch (error) {
        console.error(error);
    }
}

function disableselect(e) {
    return false;
}

function reEnable() {
    return true;
}

$('input[type="date"]').keydown(function (e) {
    let data = new Date();
    if (e.keyCode == 84) {
        $(this).val(`${data.getUTCFullYear()}-${String(data.getUTCMonth() + 1).padStart(2, 0)}-${String(data.getUTCDate()).padStart(2, 0)}`);
    } else if (e.keyCode == 82) {
        $(this).val(`1200-01-01`);
    } else if (e.keyCode == 89) {
        $(this).val(`2500-12-31`);
    } else if (e.keyCode === 189 || e.keyCode === 109) {
        let dtAtual = new Date($(this).val());
        dtAtual.setDate(dtAtual.getDate() - 1);
        let newData = dtAtual.toISOString().slice(0, 10);
        $(this).val(newData)
    } else if (e.keyCode === 187 || e.keyCode === 107) {
        let dtAtual = new Date($(this).val());
        dtAtual.setDate(dtAtual.getDate() + 1);
        let newData = dtAtual.toISOString().slice(0, 10);
        $(this).val(newData)
    }
});


// if IE4+
// document.onselectstart = () => false;
document.oncontextmenu = () => false;
// if NS6
if (window.sidebar) {
    document.onmousedown = disableselect;
    document.onclick = reEnable;
}
$.fn.once = function (events, callback) {
    return this.each(function () {
        let myCallback = function (e) {
            callback.call(this, e);
            $(this).off(events, myCallback);
        };
        $(this).on(events, myCallback);
    });
};

async function senhaSupervisor(sMsg, callBack, props, bDesconto = false, callBackDesistir, callbackClose, callBackErro) {
    try {
        $("#modal-supervisor-titulo").html("Senha Supervisor");
        $("#txtSenhaSupervisor").val("");
        $("#modal-supervisor-conteudo").html(
            `${sMsg} <br> Informe uma senha de supervisor para continuar.`
        );
        $("#modal-supervisor-rodape").html(
            `<button type="button" id="btn-supervisor-confirmar" class="btn btn-primary btn-sisp" data-dismiss="modal">Confirmar</button>
         <button type="button" id="btnSupervisorDesistir" class="btn btn-danger btn-sisp" data-dismiss="modal">Desistir</button>`
        );

        $("#modal-supervisor").modal({
            backdrop: "static",
            keyboard: true,
            show: true,
        });

        // <button type="button" class="btn btn-outline-light">Save changes</button>
        $("#modal-supervisor").modal("show");

        $("#btn-supervisor-confirmar").on("click", async function () {
            if ($("#txtSenhaSupervisor").val() == '') {
                msgErro("Senha de supervisor não pode ficar em branco! Impossível continuar.");
                if (callBackErro && callBackErro != '') {
                    callBackErro();
                };
                return;
            }
            let retorno = await requisicaoSenhaSupervisor(
                $("#txtSenhaSupervisor").val(),
                callBack,
                props,
                bDesconto
            );
            if (!retorno.valor) {
                msgErro("Senha de supervisor incorreta, impossível continuar.");
                if (callBackErro && callBackErro != '') {
                    callBackErro();
                };
                return;
            }
        });
        $('#btnSupervisorDesistir').on('click', function () {
            if (callBackDesistir && callBackDesistir != '') {
                callBackDesistir();
            }
        });

        $('#btn-supervisor-close').on('click', function () {
            if (callbackClose && callbackClose != '') {
                callbackClose();
            }
        });

    } finally {
        // return false;
    }
}

$("#modal-supervisor").on("shown.bs.modal", async function () {
    $("#txtSenhaSupervisor").focus();
});

async function setarDataAtual(componente, primeiroDia = false, qtdeDiasParaFrente = 0) {
    let today = new Date();
    today.setDate(today.getDate() + qtdeDiasParaFrente);
    const dy = primeiroDia ? "01" : String(today.getDate()).padStart(2, "0");
    const mt = String(today.getMonth() + 1).padStart(2, "0");
    const yr = today.getFullYear();
    $(`#${componente}`).val(`${yr}-${mt}-${dy}`);
}

async function setarDataPraFrente(componente, today, qtdeDiasParaFrente = 0,) {
    today.setDate(today.getDate() + qtdeDiasParaFrente);
    const dy = String(today.getDate()).padStart(2, "0");
    const mt = String(today.getMonth() + 1).padStart(2, "0");
    const yr = today.getFullYear();
    $(`#${componente}`).val(`${yr}-${mt}-${dy}`);
}

async function fazSelectNaEmpValor(codigo, tabela) {
    try {
        const empID = getCookie("emp_id");
        if (codigo != "") {
            const empValorLogin = sessionStorage.getItem('web@empValor') ?? [];
            if (empValorLogin.length > 0) {
                const empValorObject = JSON.parse(empValorLogin);
                const valores = empValorObject.filter(val => val.TABELA == tabela && val.VALOR == codigo).map(val => ({ EMP_ID: empID }));
                // console.log('consultou por codigo', valores, tabela);
                return valores;
            }
            const url = "/Sisplan/Funcoes/v1/pesquisa?";
            const response = await requisicao(
                "GET",
                url,
                `JSON={ "tabela":"EMP_VALOR", "camposSelect":["EMP_ID"], "where": ["VALOR = '${codigo}' AND TABELA = '${tabela}'"]}`
            );

            if (!response) {
                return [];
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.mensagem);
                return [];
            }
            // console.log('consultou por codigo2', jsonStr.RESULT[0], tabela);
            return jsonStr.RESULT[0];
        }

        const empValorLogin = sessionStorage.getItem('web@empValor') ?? [];
        if (empValorLogin.length > 0) {
            const empValorObject = JSON.parse(empValorLogin);
            const valores = empValorObject.filter(val => val.TABELA == tabela).map(val => ({ EMP_ID: empID, VALOR: val.VALOR }));
            // console.log('consultou sem codigo', valores, tabela);
            return valores;
        }

        const url = "/Sisplan/Funcoes/v1/pesquisa?";
        const response = await requisicao(
            "GET",
            url,
            `JSON={ "tabela":"EMP_VALOR", "camposSelect":["EMP_ID", "VALOR"], "where": ["TABELA = '${tabela}' AND EMP_ID=${getCookie(
                "emp_id"
            )}"]}`
        );

        if (!response) {
            return [];
        }

        const jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return [];
        }
        // console.log('consultou sem codigo2', jsonStr.RESULT[0], tabela);
        return jsonStr.RESULT[0];
    } catch (error) {
        console.error(error);
        msgErro(`Não foi possível buscar as empresas.`);
        return [];
    }
}

function msgErro($mensagem, $callbackOk, $callbackClose) {
    $("#modal-warning-titulo").html("Atenção");
    $("#modal-warning-conteudo").val($mensagem);
    $("#modal-warning-rodape").html(
        `<button type="button" id="btn-msg-alerta" class="btn bg-gradient-success btn-sisp" data-dismiss="modal">Ok <small>(ALT + S)</small></button>`
    );
    // <button type="button" class="btn btn-outline-light" data-dismiss="modal">Close</button>
    // <button type="button" class="btn btn-outline-light">Save changes</button>

    $("#modal-warning").modal({
        backdrop: "static",
        keyboard: true,
        show: true,
    });

    $("#modal-warning").modal("show");
    if ($callbackOk != undefined) {
        $("#btn-msg-alerta").on("click", function () {
            $("#modal-warning").modal("hide");
            $callbackOk();
        });
    }

    if ($callbackClose != undefined) {
        $("#btn-warning-close").on("click", function () {
            $("#modal-warning").modal("hide");
            $callbackClose();
        });
    }

    $("#modal-warning").click();
    $("#btn-msg-alerta").focus();
}

$("#modal-danger").on("shown.bs.modal", function () {
    $("#btn-msg-erro").focus();
});

function sleep(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}

async function buscaDuplicatasEmAberto(codcli, todasEmpresas) {
    try {
        if (codcli == '') {
            return [];
        }
        const url = "/sisplan/receber/v1/receberabertos?";
        const response = await requisicao(
            "GET",
            url,
            `CLIENTE=${codcli}&DUPLICATA=S&ANTECIPACAO=S&CHEQUE=S&CHEQUEDEV=S&TODASEMPRESAS=${todasEmpresas}`,
            null
        );

        if (!response) {
            return;
        }
        if (response.status != 200) {
            msgErro(response.mensagem);
            return;
        }

        const jsonStr = await response.json();

        return jsonStr;
    } catch (error) {
        console.error(error);
    }
}

async function retornaValorCadPadrao(tabela, campo) {
    try {
        const pesquisa = {
            camposSelect: ['VALOR'],
            tabela: 'TABPADRAO',
            where: [`TABELA = '${tabela}' AND CAMPO = '${campo}'`]
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
        return jsonStr[0].VALOR;
    } catch (error) {
        return '';
    }
}

async function msgAlerta($mensagem, $callback, $callbackCancelar, $callbackOk, $callbackClose, bSimNao = false) {
    $("#modal-warning-titulo").html("Atenção");
    $("#modal-warning-conteudo").val($mensagem);
    if ($callback != undefined) {
        $("#modal-warning-rodape").html(
            `<button id="btn-msg-alerta" type="button" class="btn bg-gradient-success btn-sisp">${bSimNao ? "Sim" : "Confirmar"} <small>(ALT + S)</small></button>` +
            `<button type="button" id="btn-msg-cancelar" class="btn bg-gradient-danger btn-sisp" data-dismiss="modal">${bSimNao ? "Não" : "Cancelar"} <small>(ALT + N)</small></button>`
        );
    } else {
        $("#modal-warning-rodape").html(
            '<button data-dismiss="modal" id="btn-msg-alerta" type="button" class="btn bg-gradient-success btn-sisp">Ok <small>(ALT + S)</small></button>'
        );
    }
    // <button type="button" class="btn btn-outline-light" data-dismiss="modal">Close</button>
    // <button type="button" class="btn btn-outline-light">Save changes</button>
    //   $("#modal-warning").modal("show");

    $("#modal-warning").modal({
        backdrop: "static",
        keyboard: true,
        show: true,
    });

    $("#btn-msg-alerta").on("click", async function () {
        $("#modal-warning").modal("hide");
        await sleep(500);
        if ($callback != undefined) {
            $callback();
        }
    });

    if ($callback != undefined && $callbackCancelar != undefined) {
        $("#btn-msg-cancelar").on("click", async function () {
            $("#modal-warning").modal("hide");
            await sleep(500);
            $callbackCancelar();
        });
    }
    if ($callbackOk != undefined) {
        $("#btn-msg-alerta").on("click", async function () {
            $("#modal-warning").modal("hide");
            await sleep(500);
            $callbackOk();
        });
    }
    if ($callbackClose != undefined) {
        $("#btn-warning-close").on("click", async function () {
            $("#modal-warning").modal("hide");
            await sleep(500);
            $callbackClose();
        });
    }
    $("#modal-warning").click();
    $("#modal-warning").focus();
}

function msgAlertaSemConfirmacao($mensagem, $modal) {
    $("#modal-warning-titulo").html("Atenção");
    $("#modal-warning-conteudo").val($mensagem);

    $("#modal-warning-rodape").html(
        '<button data-dismiss="modal" id="btn-msg-alerta" type="button" class="btn bg-gradient-success btn-sisp">Ok</button>'
    );
    // <button type="button" class="btn btn-outline-light" data-dismiss="modal">Close</button>
    // <button type="button" class="btn btn-outline-light">Save changes</button>
    $("#modal-warning").modal("show");
    $(`#${$modal}`).modal("hide");
    $("#btn-msg-alerta").on("click", function () {
        $(`#${$modal}`).modal("hide");
        $("#modal-warning").modal("hide");
    });
}

function msgConfirmacao($mensagem, $callbacks) {
    $("#modal-confirmacao-titulo").html("Atenção");
    $("#modal-confirmacao-conteudo").html($mensagem);
    if ($callbacks != undefined) {
        $("#modal-confirmacao-rodape").html(
            '<button title="Ao abandonar venda, você perderá os dados que estão na tela." id="btn-cfm-abandonar" type="button" class="btn bg-gradient-danger btn-sisp">Abandonar Venda</button>' +
            '<button title="Ao deixar a venda pendente, você irá salvar e poderá continuar futuramente." id="btn-cfm-pendente" type="button" class="btn bg-gradient-success btn-sisp">Deixar Pendente</button>' +
            '<button title="Desistir de sair da venda." type="button" class="btn bg-gradient-secondary btn-sisp" data-dismiss="modal">Voltar</button>'
        );
    }
    $("#modal-confirmacao").modal("show");
    $("#btn-cfm-abandonar").on("click", function () {
        $callbacks[0]();
        $("#modal-confirmacao").modal("hide");
    });
    $("#btn-cfm-pendente").on("click", function () {
        $callbacks[1]();
        $("#modal-confirmacao").modal("hide");
    });
}

function msgSucesso($mensagem) {
    $("#modal-success-titulo").html("Atenção");
    $("#modal-success-conteudo").val($mensagem);
    $("#modal-success-rodape").html(
        `<button type="button" class="btn bg-gradient-success btn-sisp" data-dismiss="modal">Ok</button>`
    );
    // <button type="button" class="btn btn-outline-light" data-dismiss="modal">Close</button>
    // <button type="button" class="btn btn-outline-light">Save changes</button>
    $("#modal-success").modal("show");
}

function ConfirmYesNo(title, msg) {
    let dfd = jQuery.Deferred();
    let $confirm = $("#myModal");
    $confirm.modal("show");
    $("#myModalLabel").html(title);
    $("#myModalText").html(msg);
    $("#btnYes")
        .off("click")
        .click(function () {
            $confirm.modal("hide");
            dfd.resolve(1);
            return 1;
        });
    $("#btnNo")
        .off("click")
        .click(function () {
            $confirm.modal("hide");
            dfd.resolve(0);
            return 0;
        });
    return dfd.promise();
}

function formataData(date) {
    let year = date.getFullYear();

    let month = (1 + date.getMonth()).toString();
    month = month.length > 1 ? month : `0${month}`;

    let day = date.getDate().toString();
    day = day.length > 1 ? day : `0${day}`;

    return `${year}-${month}-${day}`;
}

function formataDataCompleta(date) {
    let year = date.getFullYear();
    let hours = date.getHours();
    let minutes = date.getMinutes();
    let seconds = date.getSeconds();
    // let miliseconds = date.getMilliseconds();

    let month = (1 + date.getMonth()).toString();
    month = month.length > 1 ? month : `0${month}`;

    let day = date.getDate().toString();
    day = day.length > 1 ? day : `0${day}`;

    return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
}

function formataDataBonita(date, anoCompleto = true) {
    const dateParts = date.split("-");
    const dia = dateParts[2].padStart(2, '0');
    const mes = dateParts[1].padStart(2, '0');
    const ano = anoCompleto ? dateParts[0] : dateParts[0].substring(2);

    return dia + "/" + mes + "/" + ano;
}

function formataDateTimeBackEnd(dateString) {
    const parts = dateString.split(' ');
    const datePart = parts[0].split('-');
    let timePart = parts[1].split(':');

    if (timePart[2].length === 1) {
        timePart[2] = '0' + timePart[2];
    }

    const formattedDateString = datePart.join('-') + 'T' + timePart.join(':') + 'Z';

    return formattedDateString;
}

async function GeraRelatorio(sUrl, RequestType, timeOut, result = true, layout = '', body = null) {
    if (RequestType == undefined) RequestType = "GET";

    if (timeOut == undefined) {
        timeOut = 15000;
    }
    let response;
    try {
        // fazer segunda
        // sUrl.split('?')[1].replace(sUrl.split('?')[1].slice(-1), '')

        const urls = sUrl.split("?");
        let parametros = "";
        if (urls.length > 1) {
            parametros = urls[1];
        }

        response = await requisicao(
            RequestType,
            `${urls[0]}?`,
            parametros,
            body,
            timeOut
        );
    } catch (error) {
        console.log(error);
        return;
    }
    if (result) {
        var jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem.mensagem);
            return;
        }
        if (jsonStr.RESULT[0].arquivo != undefined) {
            return jsonStr.RESULT[0].arquivo;
        }
        return jsonStr.RESULT[0];
    }
    var jsonStr = await response.json();
    if (response.status != 200) {
        if (jsonStr.mensagem.mensagem != undefined) {
            msgErro(jsonStr.mensagem.mensagem);
        } else {
            msgErro(jsonStr.mensagem);
        }

        return;
    }
    if (jsonStr.base64Arquivo != undefined) {
        await imprimirAutomatico(jsonStr.base64Arquivo, layout);
    }
    if (jsonStr.arquivo != undefined) {
        return jsonStr.arquivo;
    }
    return jsonStr;
}

async function requisicaoSenhaSupervisor(sSenha, callBack, props, bDesconto = false) {
    let encrypt = btoa(`sISPKJSDLK${sSenha}@klSIp1q34534sS`);
    try {
        try {
            let response = await requisicao(
                "GET",
                "/Sisplan/funcoes/v1/SenhaSupervisor?",
                `senha=${encrypt}`,
                null
            );

            if (!response) {
                return false;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                return false;
            }
            if (!jsonStr.valor) {
                return false;
            }
            if (!bDesconto) {
                if (props != undefined) {
                    callBack(props);
                } else {
                    callBack();
                }
            } else if (props) {
                // quando for desconto ele vai receber uma função de callback no props
                const callbackDesconto = props;
                callBack(jsonStr.usuario, callbackDesconto);
            }
            return jsonStr;
        } finally {
        }
    } catch (error) {
        return false;
    }
}

async function limparRelatorios() {
    try {
        try {
            $.LoadingOverlay("show");
            let response = await requisicao(
                "GET",
                "/Sisplan/funcoes/v1/limparImpressos?",
                "",
                null
            );

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                return;
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    } catch (error) {
        $.LoadingOverlay("hide");
    }
}

async function RetornaDoctoELancto(
    sTipo,
    sTabela,
    sCampo,
    sTamanho,
    bOffline = false
) {
    if (!bOffline) {
        let _url = `/sisplan/funcoes/v1/Proximo?`;
        let _params = `tabela=${sTabela}&campo=${sCampo}&tamanho=${sTamanho}&tipo=${sTipo}`;

        try {
            let response = await requisicao("GET", _url, _params, null);

            if (!response) {
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }
            return jsonStr.json;
        } catch (error) {
            msgErro("Não foi possível buscar o Número de documento.");
        }
    }
}

async function RetornaProximo(sTipo, sTabela, sCampo, sTamanho) {
    let _url = `/sisplan/funcoes/v1/Proximo?`;
    let _params = `tabela=${sTabela}&campo=${sCampo}&tamanho=${sTamanho}&tipo=${sTipo}`;

    try {
        let response = await requisicao("GET", _url, _params, null);

        if (!response) {
            return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
        }
        return jsonStr.json;
    } catch (error) {
        msgErro("Não foi possível buscar o próximo número de venda.");
    }
}

async function deletaRegistro(sTela, _sUsuario, sValor, sUserSistema = "") {
    let url = `/sisplan/controleedicao/v1/controleedicao?`;
    try {
        let response = await requisicao(
            "DELETE",
            url,
            `TELA=${sTela}&VALOR=${sValor}&USUARIOREGISTRO=${sUserSistema}`,
            null
        );

        if (!response) {
            return;
        }

        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
        }
    } catch (error) {
        msgErro("Não foi possível liberar os registros.");
    }
}

function insereValor(componente, codigo, descricao, retornaProximo = false) {
    let valor = '';
    if (typeof (codigo) == 'string' && codigo === '' && !retornaProximo) {
        return;
    }
    if (descricao == undefined) {
        $(componente).val(codigo);
        $(componente).attr("data-chave", codigo);
        $(componente).attr("data-selecionado", true);
    }
    else if (typeof (descricao) == 'object') {
        if (retornaProximo) {
            RetornaProximo(descricao.tipo, descricao.tabela, descricao.campo, descricao.tamanho)
                .then((value => {
                    $(componente).val(value);
                    $(componente).attr("data-chave", value);
                }
                ));
        }
        else {
            buscaValor(descricao.tabela, descricao.campoBusca, descricao.campoWhere, descricao.valorWhere)
                .then((value => {
                    $(componente).val(`[${codigo}] - ${value[Object.keys(value)[0]]}`);
                    $(componente).attr("data-chave", codigo);
                    $(componente).attr("data-desc", value[Object.keys(value)[0]]);
                    $(componente).attr("data-selecionado", true);
                }
                ));
        }
    }
    else {
        $(componente).val(`[${codigo}] - ${descricao}`);
        $(componente).attr("data-chave", codigo);
        $(componente).attr("data-desc", descricao);
        $(componente).attr("data-selecionado", true);
    }
}

function limpaValor(componente) {
    $(componente).val($(componente).attr("type") == "number" ? 0 : "");
    $(componente).val("");
    $(componente).attr("data-selecionado", false);
    $(componente).attr("data-chave", "");
    $(componente).attr("data-desc", "");
}

async function preencheOrdenacaoTela(sTela) {
    const ordens = await retornaOrdensRelatorio(sTela);
    ordens.forEach((ordem) => {
        $("#txtOrdem").append(
            `<option value="${ordem.ORDEM}">${ordem.NOME_ORD_TELA}</option>`
        );
    });
}

// function CriaPesquisaPadrao(numIniciaAutoCompleta = 0, pSeletorInput, pSeletorButton, pPesquisa) {
//     $(pSeletorInput).autocompleta(numIniciaAutoCompleta, pPesquisa);
//     $(pSeletorButton).pesquisa(pSeletorInput, )
//     $('#btnUnidadeVenda').pesquisa('#txtUnidadeVenda', 'UNIDADE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"unidade", "camposSelect":[ "unidade", "descricao"]}`, 'Pesquisa Unidade', 'unidade');

// }

function CriaTabelaPadrao(sSeletor) {
    $(sSeletor).DataTable({
        autoWidth: false,
        destroy: true,
        order: false,
        filter: false,
        paginate: false,
        // scrollY: "300px",
        // scrollX: 'auto',
        key: "true",
        columnDefs: [
            {
                targets: [7, 8],
                visible: false,
            },
        ],
        language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar (geral): ",
            oPaginate: {
                sNext: "Próximo",
                sPrevious: "Anterior",
                sFirst: "Primeiro",
                sLast: "Último",
            },
            oAria: {
                sSortAscending: ": Ordenar colunas de forma ascendente",
                sSortDescending: ": Ordenar colunas de forma descendente",
            },
        },
    });

    $(`${sSeletor} tbody`).on("click", "tr", async function () {
        $(`${sSeletor} tbody tr td`)[0].click();
        $(`${sSeletor} tbody tr.selected`).removeClass("selected");
        $(this).addClass("selected");
    });
}

async function retornaOrdensRelatorio(sTela) {
    const pesquisa = {
        tabela: "ORDEM_TELA",
        camposSelect: ["ORDEM", "NOME_ORD_TELA"],
        where: [`NOME_TELA = '${sTela}'`],
        orderBy: ["ORDEM"],
    };
    const json = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
    return json;
}

async function retornaConsultaWWW(sCNPJ, sCaptcha = '', jsonCaptcha = {}, sUF = '', usaCertificadoA3 = 0) {
    try {
        $.LoadingOverlay("show");
        if (usaCertificadoA3 == '1') {
            const url = '/cliente/consultacnpj?';
            const infoEmpresa = await retornaInformacaoEmpresa();
            const responseLocal = await requisicao_ecf('POST', url, `CNPJ=${sCNPJ}&CAPTCHA=${sCaptcha}&UF=${sUF}&JSON=${encodeURIComponent(JSON.stringify(jsonCaptcha))}`, JSON.stringify(infoEmpresa), 120000);
            if (!responseLocal) {
                msgAlerta('Não foi possível realizar a consulta, atualize o captcha e tente novamente.');
                return;
            }
            if (responseLocal.status == 200) {
                let jsonStr = await responseLocal.json();
                return jsonStr;
            }
            if (responseLocal.status != 200) {
                let jsonStr = await responseLocal.json();
                msgErro(jsonStr.mensagem);
                return;
            };
        } else {
            const url = `/sisplan/cliente/v1/consultawww?`;
            const params = `CNPJ=${sCNPJ}&CAPTCHA=${sCaptcha}&UF=${sUF}`;
            let response = await requisicao("POST", url, params, JSON.stringify(jsonCaptcha), 120000);
            if (!response) {
                msgAlerta('Não foi possível realizar a consulta, atualize o captcha e tente novamente.');
                return;
            }
            if (response.status == 200) {
                let jsonStr = await response.json();
                return jsonStr;
            }
            if (response.status != 200) {
                let jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return;
            }
        }
    } finally {
        $.LoadingOverlay("Hide");
    }
}

async function verificarRegistro(tela, valor) {
    let _url = `/sisplan/controleedicao/v1/controleedicao?`;
    try {
        $.LoadingOverlay("Show");
        try {
            let response = await requisicao(
                "GET",
                _url,
                `TELA=${tela}&VALOR=${valor}`,
                null
            );

            let jsonStr = await response.json();

            if (response.status == 200) {
                if (jsonStr[0].TELA == tela && jsonStr[0].VALOR == valor) {
                    msgAlerta("Registro está sendo alterado");
                    return false;
                }
            }
        } catch (error) {
            return true;
        }
    } finally {
        $.LoadingOverlay("Hide");
    }
};

async function retornaDepositoUsuario(usuario) {
    try {
        $.LoadingOverlay("show");
        try {
            const url = '/Sisplan/Funcoes/v1/pesquisa?';
            const params = `JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":["DEPOSITOS"], "where": ["CODIGO = '${usuario}'"]}`;
            const response = await requisicao('GET', url, params, null);

            if (!response) {
                return 'null';
            }

            const jsonStr = await response.json();

            if (jsonStr.codigo == 400) {
                return 'null';
            }
            const result = jsonStr.RESULT[0][0].DEPOSITOS != '' ? `["CODIGO IN (${jsonStr.RESULT[0][0].DEPOSITOS})"]` : 'null';
            return result;
        } catch (error) {
            console.error(error);
            return 'null';
        }
    } finally {
        $.LoadingOverlay("hide");
    }
};

async function liberarRegistro(sTela, iValor) {
    try {
        $.LoadingOverlay("show");
        let response = await requisicao(
            "POST",
            "/sisplan/controleedicao/v1/controleedicao?",
            `valor=${iValor}&tela=${sTela}`,
            null
        );
        if (!response) {
            $.LoadingOverlay("hide");
            return false;
        }
        let jsonStr = await response.json();
        if (response.status != 200) {
            $.LoadingOverlay("hide");
            msgAlerta(jsonStr.mensagem);
            return false;
        }

        $.LoadingOverlay("hide");
        return true;
    } catch (error) {
        $.LoadingOverlay("hide");
        msgErro(`Não foi possível alterar o registro: ${error}`);
    }
}

function retornaQtdeCasasDecimais(valor) {
    const strValor = String(valor);
    let posicao = strValor.indexOf(".");
    if (posicao == -1) {
        posicao = strValor.indexOf(",");
    }
    if (posicao == -1) {
        return 0;
    }

    return strValor.substr(posicao + 1).length;
}

async function selecionarLinhaTabela(tabela, inputCheck, LinhaSelecionada) {
    let bColunaClique = $(LinhaSelecionada).html().indexOf(inputCheck) > 0;
    if (bColunaClique) {
        if (!$(LinhaSelecionada).closest("tr").hasClass("selected")) {
            $(LinhaSelecionada).closest("tr").addClass("selected");
            $(LinhaSelecionada)
                .closest(LinhaSelecionada)
                .find(`.${inputCheck}`)
                .prop("checked", true);
            $("#btnBaixar").prop("disabled", false);
            $("#btnBaixarComAntecipacao").prop("disabled", false);
            data = $(tabela)
                .DataTable()
                .rows($(LinhaSelecionada).parents(".sorting_1"))
                .data();
        } else {
            $(LinhaSelecionada).closest("tr").removeClass("selected");
            $(LinhaSelecionada)
                .closest(LinhaSelecionada)
                .find(`.${inputCheck}`)
                .prop("checked", false);
        }
    }
}

async function naoPermiteFechar() {
    window.onbeforeunload = function () {
        return "Gostaria mesmo de sair desta página?";
    };
}

async function adicionaHint(componente) {
    tippy(componente, {
        content: $(componente).val(),
    });
}

async function adicionaHintValor(componente, valor) {
    tippy(componente, {
        content: valor,
    });
}

async function verificarBloqueio(cnpj) {
    try {
        if (getCookie("cod_usuario") == "0000") {
            return true;
        }
        const response = await requisicao(
            "GET",
            "/sisplan/funcoes/v1/verificarcnpj?",
            `CNPJ=${cnpj}`,
            null,
            10000
        );

        if (!response) {
            return true;
        }

        const jsonStr = await response.json();

        if (response.status != 200) {
            console.error(jsonStr.mensagem);
            return true;
        }

        if (jsonStr.toString() === "false") {
            return false;
        }
        return true;
    } catch (error) {
        console.error(error);
        return true;
    }
}

async function verificarQuantidadeUsuarios(cnpj, usuario, idMaquina) {
    try {
        if (getCookie("cod_usuario") == "0000") {
            return true;
        }
        let response = await requisicao(
            "GET",
            "/sisplan/funcoes/v1/verificarquantidadeusuarios?",
            `CNPJ=${cnpj}&USUARIO=${usuario}&IDMAQUINA=${idMaquina}&TIPO=WEB`,
            null,
            10000
        );

        if (!response) {
            return true;
        }

        let jsonStr = await response.json();

        if (response.status != 200) {
            console.error(jsonStr.mensagem);
            return true;
        }

        if (jsonStr.toString() === "false") {
            return false;
        }
        return true;
    } catch (error) {
        console.error(error);
        return true;
    }
}

async function loginUsuario() {
    try {
        if (getCookie("cod_usuario") == "0000") {
            return;
        }
        const cnpj = getCookie('g_cnpj_empresa_logada');
        await requisicao(
            "POST",
            "/sisplan/funcoes/v1/quantidadeusuarios?",
            `CNPJ=${cnpj}&IDMAQUINA=${getCookie('idMaquina')}&TIPO=WEB`,
            null,
            10000
        );
    } catch (error) {
        console.error(error);
    }
}

async function logoutUsuario(idMaquina, usuario) {
    try {
        if (getCookie("cod_usuario") == "0000") {
            return;
        }
        const cnpj = getCookie('g_cnpj_empresa_logada');
        await requisicao(
            "DELETE",
            "/sisplan/funcoes/v1/quantidadeusuarios?",
            `CNPJ=${cnpj}&IDMAQUINA=${idMaquina}&USUARIO=${usuario}&TIPO=WEB`,
            null,
            10000
        );
    } catch (error) {
        console.error(error);
    }
}

async function busca_cnpj() {
    try {
        $.LoadingOverlay("show");

        const url = `/sisplan/funcoes/v1/pesquisa?`;
        const response = await requisicao('GET', url,
            `EMPRESA=_001&JSON={ "tabela":"EMPRESA", "camposSelect": ["EMP_CNPJ"], "where": ["emp_pat = '${sessionStorage.getItem('g_empresa_logada')}'"] }`,
            null);

        if (!response) {
            return;
        }

        const jsonStr = await response.json()
        if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem)
            return;
        }
        return jsonStr['RESULT'][0][0].EMP_CNPJ;
    } catch (error) {
        console.error(error);
        msgErro('Não foi possível buscar os dados da empresa logada.');
    } finally {
        $.LoadingOverlay("hide");
    }
};

async function temAcessoTela(tela) {
    try {
        $.LoadingOverlay("show");

        let object = new Object();
        object.resultado = true;
        object.bloqueio = false;
        object.mensagem = "";

        const empid = getCookie("emp_id");
        if (!empid) {
            object.resultado = false;
            object.mensagem = "Acesso negado, Usuário não tem acesso a essa tela!";

            return object;
        }

        if (getCookie("cod_usuario") == "0000") {
            return object;
        }

        try {
            const cnpj = getCookie('g_cnpj_empresa_logada');
            const bloqueio = await verificarBloqueio(cnpj);
            if (!bloqueio) {
                object.resultado = false;
                object.bloqueio = true;
                object.mensagem =
                    "Acesso Bloqueado. Falar com o ADMINISTRADOR da empresa ou contate o SUPORTE da Sisplan Sistemas.";

                return object;
            }

            const codusuario = getCookie("cod_usuario");
            if (!codusuario) {
                object.resultado = false;
                object.mensagem = "Acesso negado, Usuário não tem acesso a essa tela!";

                return object;
            }
            await loginUsuario();
            const response = await requisicao(
                "GET",
                `/Sisplan/AcessoMenu/v1/Acesso?`,
                `codusuario=${codusuario}&tela=${tela}`,
                null,
                60000
            );

            if (!response) {
                object.resultado = false;
                object.mensagem =
                    "Ocorreu um erro ao validar se usuário tem acesso a tela";
                return object;
            }

            let valida = await response.json();
            if (response.status != 200) {
                console.error(valida.RESULT[0].mensagem);

                object.resultado = false;
                object.mensagem =
                    "Ocorreu um erro ao validar se usuário tem acesso a tela";

                return object;
            }

            if (valida.length <= 0) {
                object.resultado = false;
                object.mensagem = `Acesso negado '${tela}', Usuário não tem acesso a essa tela!`;

                return object;
            }

            if (valida[0].CONSULTA == "N") {
                object.resultado = false;
                object.mensagem = `Acesso negado '${tela}', Usuário não tem acesso a essa tela!`;

                return object;
            }
            object.resultado = true;
            object.mensagem = "";

            return object;
        } catch (error) {
            console.error(error);

            object.resultado = false;
            object.mensagem = "Erro ao validar o acesso a tela.";

            return object;
        }
    } finally {
        $.LoadingOverlay("hide");
    }
}

// String.prototype.replaceAll = function(de, para){
//     var str = this;
//     var pos = str.indexOf(de);
//     while (pos > -1){
//     str = str.replace(de, para);
//     pos = str.indexOf(de);
//     }
//     return (str);
// }

function moeda2float(moeda) {
    if (moeda == '' || moeda == undefined) {
        return 0;
    }
    moeda = moeda.replaceAll(".", "");
    moeda = moeda.replace(",", ".");
    return parseFloat(moeda);
}
function float2moeda(number, decimals, dec_point, thousands_sep) {
    if (decimals == undefined) {
        decimals = 2;
    }
    //decimals = casasDecimaisValor;
    dec_point = ',';
    thousands_sep = '.';

    number = (number + '')
        .replace(/[^0-9+\-Ee.]/g, '');
    var n = !isFinite(+number) ? 0 : +number,
        prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
        sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
        dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
        s = '',
        toFixedFix = function (n, prec) {
            var k = Math.pow(10, prec);
            return '' + (Math.round(n * k) / k)
                .toFixed(prec);
        };
    // Fix for IE parseFloat(0.55).toFixed(0) = 0;
    s = (prec ? toFixedFix(n, prec) : '' + Math.round(n))
        .split('.');
    if (s[0].length > 3) {
        s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
    }
    if ((s[1] || '')
        .length < prec) {
        s[1] = s[1] || '';
        s[1] += new Array(prec - s[1].length + 1)
            .join('0');
    }
    return s.join(dec);
}

// $('.mascara-valor')
// .on('keypress', function (e) {
//     if (window.event) {
//         tecla = e.keyCode;
//     } else if (e.which) {
//         tecla = e.which;
//     } else {
//         tecla = 0;
//     }

//     if (tecla == 13) {
//         return false;
//     }

//     if ((tecla >= 48 && tecla <= 57) || (tecla == 8) || (tecla == 44) || (tecla == 46) || (tecla == 45) || e.ctrlKey) {
//         if (tecla == 13) {
//             $(this).blur();
//         }
//         return true;
//     } else {
//         return false;
//     }
// })
// .on('blur', function (e) {
//     valor = $(this).val();
//     if (valor != '') {
//         $(this).val(float2moeda(valor));
//         valor = moeda2float(valor);
//         if ($(this).attr('casas') != undefined) {
//             valor = float2moeda(valor, $(this).attr('casas'));
//         } else {
//             valor = float2moeda(valor);
//         }
//         $(this).val(valor);
//     }
// })
// .on('focus', function () {
//     if ($(this).attr('casas') != undefined) {
//         $(this).attr('placeholder', float2moeda(0, $(this).attr('casas')));
//     } else {
//         $(this).attr('placeholder', float2moeda(0));
//     }
//     campo = $(this);
//     window.setTimeout(function () {
//         campo.select();
//     }, 100);
// })
// .on('blur', function () {
//     $(this).attr('placeholder', '');
// });

function toastrAcesso(objTemAcesso, baseUri) {
    toastr
        .error(objTemAcesso.mensagem, "Erro", {
            toastClass: "alert",
            iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            async onHidden() {
                if (objTemAcesso.bloqueio) {
                    window.location.href = `${baseUri}/login`;
                    return;
                }
                window.location.href = `${baseUri}/index`;
            },
        })
        .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
        });
}

async function TruncaDecimais(decimal, valor, __) {
    if (decimal > 0) {
        valor = (valor * Math.pow(10, decimal)) / Math.pow(10, decimal);
        return Math.round(valor * 100) / 100;
    }
    return valor;
}

function TruncaDecimaisNova(decimal, valor) {
    if (decimal > 0) {
        valor = (valor * Math.pow(10, decimal)) / Math.pow(10, decimal);
        return Math.round(valor * 100) / 100;
    }
    return valor;
}

function ArredondarValor(number, decimalPlaces) {
    // eslint-disable-next-line no-restricted-properties
    const factorOfTen = Math.pow(10, decimalPlaces);
    return Math.round(number * factorOfTen) / factorOfTen;
}

async function AlterarSenha() {
    try {
        $.LoadingOverlay("show");
        try {
            const login = new Login();
            const url = "/sisplan/alterarsenha/v1/alterarsenha?";
            let senhaAntiga = login.encriptografarSenha(
                $("#txtSenhaAntiga").val().toUpperCase()
            );
            let senhaNova = login.encriptografarSenha(
                $("#txtSenhaNova").val().toUpperCase()
            );
            const params = `SENHANOVA=${senhaNova}&SENHAANTIGA=${senhaAntiga}`;

            const response = await requisicao("POST", url, params, 20000);

            if (!response) {
                return;
            }
            const jsonStr = await response.json();
            if (response.status === 200) {
                $("#modalAlterarSenha").modal("hide");
                msgSucesso("Senha alterada com sucesso!");
                $("#txtSenhaAntiga").val("");
                $("#txtSenhaNova").val("");
                $("#txtConfirmarSenha").val("");
                return;
            }
            msgErro(jsonStr.mensagem);
            return;
        } catch (error) {
            console.error(error);
            msgErro("Erro ao alterar senha");
        }
    } finally {
        $.LoadingOverlay("hide");
    }
}

async function ValidaSenhaIgual() {
    try {
        $.LoadingOverlay("show");
        try {
            if ($("#txtSenhaNova").val() != $("#txtConfirmarSenha").val()) {
                msgAlerta("Senhas não conferem");
                return false;
            }

            return true;
        } catch (error) {
            console.error(error);
        }
    } finally {
        $.LoadingOverlay("hide");
    }
}

async function mostrarSenha(input) {
    if (
        $(input).parent().parent().parent().find("input").attr("type") ===
        "password"
    ) {
        $(input).parent().parent().parent().find("input").attr("type", "text");
        $(input).addClass("d-none");
        $($(input).parent().find(".olhoFechado")[0]).removeClass("d-none");
    } else {
        $(input).parent().parent().parent().find("input").attr("type", "password");
        $(input).removeClass("d-none");
        $($(input).parent().find(".olhoAberto")[0]).removeClass("d-none");
        $($(input).parent().find(".olhoFechado")[0]).addClass("d-none");
    }
}

async function verificaPermissoes(sTela) {
    const sUsuario = getCookie("cod_usuario");
    const sEmp_id = getCookie("emp_id");
    try {
        let response = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ "tabela":"PERMISSOES_TELA",
            "camposSelect":["TELA", "ACAO", "PERMISSAO"],
            "where": ["USUARIO = '${sUsuario}' AND EMP_ID = ${sEmp_id} AND TELA = '${sTela}'"]}`,
            null
        );
        if (!response || response.status != 200) {
            return;
        }
        let jsonStr = await response.json();
        for (let i = 0; i < jsonStr.RESULT[0].length; i++) {
            if (jsonStr.RESULT[0][i].PERMISSAO == "N") {
                bloqueiaPermissoes(sTela, jsonStr.RESULT[0][i].ACAO);
            }
        }
    } catch (error) {
        console.error(error);
    }
}

function bloqueiaPermissoes(sTela, sAcao) {
    if (sTela == "LOJA" && sAcao == "VISUALIZA_DASHBOARD") {
        $("#painelLojaTour").addClass("d-none");
    }
    if (sTela == "RECEBER" && sAcao == "VISUALIZA_DASHBOARD") {
        $("#boxDashboard").addClass("d-none");
    }
    if (sTela == "INICIO" && sAcao == "VISUALIZA_GRAFICOS") {
        $(".pnlDashboard").addClass("d-none");
    }
    if (sTela == "FATURAMENTO" && sAcao == "ALTERA_MOV_ESTOQUE") {
        $('#movEstoqueCheck').prop('disabled', true);
    }
}

function gerarGuid() {
    return ([1e7] + 1e3 + 4e3 + 8e3 + 1e11).replace(/[018]/g, (c) =>
        // eslint-disable-next-line no-bitwise
        (
            c ^
            (crypto.getRandomValues(new Uint8Array(1))[0] & (15 >> (c / 4)))
        ).toString(16)
    );
}

function verificaSeTemIdNaMaquina() {
    const idMaquina = getCookie("idMaquina");

    if (
        idMaquina == "" ||
        idMaquina == undefined ||
        idMaquina == null ||
        idMaquina == "undefined" ||
        idMaquina == "null"
    ) {
        setCookie("idMaquina", gerarGuid(), 365);
    }
}


async function retornaJsonPesquisaPadrao(jsonParametro) {
    try {
        const url = "/sisplan/funcoes/v1/pesquisa?";
        const params = `JSON=${jsonParametro}`;

        const response = await requisicao("GET", url, params);

        if (!response) {
            return;
        }

        const jsonPesquisa = await response.json();
        if (response.status != 200) {
            msgErro(jsonPesquisa.RESULT[0].mensagem);
            return;
        }

        return jsonPesquisa.RESULT[0];
    } catch (error) {
        console.error(error);
    }
}

async function buscaVersaoAPI() {
    try {
        const url = "/versao?";
        const response = await requisicao("GET", url, "");
        if (!response) {
            return;
        }

        if (response.status != 200) {
            const jsonPesquisa = await response.json();
            msgErro(jsonPesquisa.mensagem);
            return;
        }

        return response.text();
    } catch (error) {
        console.error(error);
    }
}

async function buscaValor(sTabela, sCampoBusca, sCampoWhere, sCodigo) {
    const dadosSelect = {
        tabela: `${sTabela}`,
        camposSelect: [`${sCampoBusca.toString()}`],
        where: [`${sCampoWhere} = '${sCodigo}'`],
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(
        JSON.stringify(dadosSelect)
    );
    if (!retornoSelect) {
        return;
    }
    return retornoSelect[0];
}

function formataEmReais(valor) {
    return valor.toLocaleString('pt-BR', {
        style: 'currency', currency: 'BRL',
        maximumFractionDigits: 2,
        minimumFractionDigits: 2
    });
}

function criaDataTablePadrao(
    sIdTabela,
    sPaging = true,
    sFilter = true,
    sInfo = true,
    sOrder = true,
    sDestroy = true,
    sScrollX = false,
    sScrollY = false,
    sData = null,
    sColumns = null,
    sColunasInvisiveis = [],
    sColunasDatasFormatadas = [],
    sColunasDinheiro = [],
    sColunasDecimais = [],
    botaoDinamico = {},
    casasDecimais = 2,
    sBotaoColunas = '',
    sBotaoExcel = '',
    sOrdemColunas = false,
    sColunasCentro = []
) {

    const columnDefs = [
        {
            render: render = function (data, type, row) {
                // alert(navigator['userAgent'])
                let isIE = function () {
                    if (/MSIE/i.test(navigator.userAgent) == true || /Edge/i.test(navigator.userAgent) == true) {
                        return true;
                    }
                    return false;

                };
                if (isIE()) {
                    x = data.slice(0, 10).split('-');
                    return `${x[2]}/${x[1]}/${x[0]}`;
                }
                x = data.slice(0, 10).split('-');
                return `${x[2]}/${x[1]}/${x[0]}`;

            },
            targets: sColunasDatasFormatadas,
        },
        {
            targets: sColunasInvisiveis,
            visible: false,
        },
        {
            render(data) {
                return parseFloat(data).toLocaleString("pt-br", {
                    style: "currency",
                    currency: "BRL",
                });
            },
            targets: sColunasDinheiro,
        },
        {
            render(data) {
                return parseFloat(data).toLocaleString("pt-BR", {
                    maximumFractionDigits: casasDecimais,
                    minimumFractionDigits: casasDecimais
                });
            },
            targets: sColunasDecimais,
        },
        {
            className: 'text-center',
            targets: sColunasCentro
        }
    ];

    if (botaoDinamico.targets) {
        columnDefs.push({
            targets: botaoDinamico.targets,
            render: botaoDinamico.funcao
        }
        )
    };

    $(`${sIdTabela}`).DataTable({
        paging: sPaging,
        filter: sFilter,
        info: sInfo,
        order: sOrder ? [[0, 'asc']] : sOrder,
        destroy: sDestroy,
        scrollX: sScrollX,
        scrollY: sScrollY,
        language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            oPaginate: {
                sNext: "Próximo",
                sPrevious: "Anterior",
                sFirst: "Primeiro",
                sLast: "Último",
            },
            oAria: {
                sSortAscending: ": Ordenar colunas de forma ascendente",
                sSortDescending: ": Ordenar colunas de forma descendente",
            },
        },
        colReorder: sOrdemColunas,
        data: sData,
        columns: sColumns,
        columnDefs: columnDefs,
    });


    if (sBotaoColunas != '') {
        $(sIdTabela + '_length').prepend('<button class="buttonColVis" id="' + sBotaoColunas + '"><i class="fas fa-cogs"></i></button>');
        $('#buttonColVis').prop('title', 'Configurar colunas visíveis');
    }
    if (sBotaoExcel != '') {
        $(sIdTabela + '_length').prepend('<button class="buttonExcel" id="' + sBotaoExcel + '"><i class="fas fa-file-excel"></i></button>');
        $('#buttonExcel').prop('title', 'Exportar')
    }

}

async function carregaEmpresasDisponiveis() {
    try {
        $('#cbTodasAsEmpresas').off();
        $('#cbTodasAsEmpresas').on('click', function () {
            $('.empresa_selecionada').toArray().map(input => {
                $(`#${input.id}`).prop('checked', $('#cbTodasAsEmpresas').prop('checked'));
            });
        });

        if ($('.empresa_selecionada').length > 0) {
            $('#modal-empresas').modal('show');
            return;
        }
        const dadosSelect = {
            orderBy: ['EMPRESA.EMP_PAT'],
            tabela: `ACESSO_EMPRESA`,
            leftJoin: [{ "tabela": "EMPRESA", "condicao": "REPLACE(EMPRESA.EMP_PAT,'_','') = ACESSO_EMPRESA.EMPRESA" }],
            camposSelect: ['EMPRESA.EMP_ID', 'ACESSO_EMPRESA.EMPRESA', 'EMPRESA.EMP_NOME'],
            where: [`ACESSO_EMPRESA.USUARIO = '${getCookie('cod_usuario')}'`],
        };
        const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
        if (!retornoSelect) {
            return;
        }
        if (retornoSelect && retornoSelect.length > 0) {
            $('#modal-empresas').modal('show');
            $('#modal-empresas-body').html('');

            for (let index = 0; index < retornoSelect.length; index++) {
                const empresa = retornoSelect[index];
                $('#modal-empresas-body').append(
                    `<div class="form-check">
                        <input id="cbEmpresa-${empresa.EMP_ID}" data-emp-id="${empresa.EMP_ID}" class="form-check-input empresa_selecionada" type="checkbox" ${getCookie('emp_id') == empresa.EMP_ID ? 'checked' : ''}> 
                        <label for="cbEmpresa-${empresa.EMP_ID}">${`${empresa.EMPRESA} - ${empresa.EMP_NOME}`}</label>
                     </div>`
                );
            }
        }
    } finally {

    }
}

async function carregaTodasEmpresas() {
    try {
        $('#modal-empresas-body').html('');
        const dadosSelect = {
            tabela: `EMPRESA`,
            camposSelect: ['EMP_ID', 'EMP_NOME', "REPLACE(EMP_PAT,'_','') EMPRESA"],
            where: null,
        };
        const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
        if (!retornoSelect) {
            return;
        }
        if (retornoSelect && retornoSelect.length > 0) {
            $('#modal-empresas').modal('show');
            $('#modal-empresas-body').html('');
            for (let index = 0; index < retornoSelect.length; index++) {
                const empresa = retornoSelect[index];
                $('#modal-empresas-body').append(
                    `<div class="form-check">
                    <input id="cbEmpresa-${empresa.EMP_ID}" data-emp-id="${empresa.EMP_ID}" class="form-check-input empresa_selecionada" type="checkbox" ${getCookie('emp_id') == empresa.EMP_ID ? 'checked' : ''}> 
                    <label for="cbEmpresa-${empresa.EMP_ID}">${`${empresa.EMPRESA} - ${empresa.EMP_NOME}`}</label>
                 </div>`
                );
            }
        }


    } catch (error) {
        console.error(error);
    }
}

async function criaMensagemErro(sMensagem, $callback) {
    await toastr
        .error(sMensagem, "Erro", {
            toastClass: "alert",
            iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
                $callback();
            },
        })
        .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
        });
}

async function criaMensagemAlerta(sMensagem, $callback) {
    await toastr
        .warning(sMensagem, "Atenção", {
            toastClass: "alert",
            iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
                $callback();
            },
        })
        .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
        });
}

async function criaMensagemSucesso(sMensagem, $callback) {
    await toastr
        .success(sMensagem, "Confirmação", {
            toastClass: "alert",
            iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
                if ($callback != undefined) {
                    $callback();
                }
            },
        })
        .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
        });
}

function gravaIdAba() {
    try {
        let abasLocal = localStorage.getItem('g_abas');

        if (!abasLocal) {
            localStorage.setItem('g_abas', 1);
            sessionStorage.setItem('g_idAba', 1);
            return;
        }

        const novoId = Number(abasLocal) + Number(1);
        abasLocal = novoId;
        localStorage.setItem('g_abas', abasLocal);
        sessionStorage.setItem('g_idAba', novoId);

    } catch (error) {
        console.error(error);
    }
}
async function permissaoAcessos(tela) {
    try {
        $.LoadingOverlay("show");

        let object = new Object();
        object.resultado = true;
        object.mensagem = "";

        if (getCookie("cod_usuario") == "0000") {
            object.ALTERA = "S";
            object.CONSULTA = 'S';
            object.EXCLUI = 'S';
            object.INCLUI = 'S';
            return object;
        }

        try {
            const codusuario = getCookie("cod_usuario");
            const response = await requisicao(
                "GET",
                `/Sisplan/AcessoMenu/v1/Acesso?`,
                `codusuario=${codusuario}&tela=${tela}`,
                null,
                60000
            );

            if (!response) {
                msgErro("Erro ao buscar permissões da tela.");
                return;
            }

            let valida = await response.json();
            if (response.status != 200) {
                console.error(valida.RESULT[0].mensagem);
                msgErro("Erro ao buscar permissões da tela.");
                return;
            }

            if (valida.length <= 0) {
                object.ALTERA = "N";
                object.CONSULTA = 'N';
                object.EXCLUI = 'N';
                object.INCLUI = 'N';
                return object;
            }

            return valida[0];
        } catch (error) {
            console.error(error);
            msgErro("Erro ao buscar permissões da tela.");
        }
    } finally {
        $.LoadingOverlay("hide");
    }
}

async function carregaArquivo(nomedoarquivo) {
    const hostname = `${nomedoarquivo}-${getCookie("idMaquina")}`;
    let response;
    let myHeaders = new Headers();
    myHeaders.append("pragma", "no-cache");
    myHeaders.append("cache-control", "no-cache");
    try {
        response = await fetch(`${hostname}.txt`, {
            headers: myHeaders,
            method: "GET",
            body: null,
        });
    } catch (error) {
        return;
    }
    return response;
}

async function rotinaGeraLog(tela, chave, descricao, operacao) {
    try {
        const url = "/sisplan/log/v1/geralog?";
        const objetoLog = {
            tela,
            chave,
            descricao,
            operacao
        };

        const response = await requisicao(
            "POST",
            url,
            `JSON=${JSON.stringify(objetoLog)}`
        );

    } catch (error) {
        console.error(error);
    }
}

async function salvaArquivo(nomedoarquivo, jsonarquivo) {
    try {
        const response = await fetch(`salvar_arquivo.php?tipo=${nomedoarquivo}`, {
            method: "POST",
            body: `${JSON.stringify(jsonarquivo)}`,
        });

        return response;
    } catch (error) {
        msgAlerta("Erro ao salvar dados digitados!");
    }
}

async function deletaArquivo(nomedoarquivo) {
    const hostname = `${nomedoarquivo}-${getCookie("idMaquina")}`;
    try {
        const response = await fetch(
            `deletar_arquivo.php?nomedoarquivo=${hostname}.txt`,
            {
                method: "GET",
                body: null,
            }
        );
    } catch (error) {
        console.log(error);
    }
}

function bloqueiaCampos(divPrincipal, habilita) {
    $(`.${divPrincipal} :input`).attr("disabled", habilita);
};

async function imprimirAutomatico(arquivo, layout) {
    try {
        const response = await requisicao_ecf('POST', '/arquivo/imprimir?', `RELATORIO=${layout}`, arquivo, 180000);

        if (!response) {
            return;
        }

        if (response.status != 200) {
            return;
        }

    } catch (error) {
        console.log(error);
    }

}

async function verificaImprimirAutomatico(layout) {
    try {
        const response = await requisicao_ecf("GET", "/arquivo/verificaimprimirautomatico?", `RELATORIO=${layout}`, 20000);

        if (!response) {
            return false;
        }

        if (response.status != 200) {
            return false;
        }

        if (await response.text() == 'false') {
            return false;
        } else {
            return true;
        }

    } catch (error) {
        console.log(error);
    }

}

function pegaValor(sComponente) {
    return $(sComponente).val();
}

function isChecked(sComponente) {
    return $(sComponente).is(':checked');
}

function RetornaIdTamFormatado(id, inverso = false) {
    return (!inverso) ? id.replace('/', '_') : id.replace('_', '/');
}

async function retornaCampoList(campo, separador = ",", unico = false) {
    try {
        const response = await requisicao("GET", "/sisplan/funcoes/v1/retornacampolist?", `CAMPO=${campo}&SEPARADOR=${separador}&UNICO=${unico}`, 60000);

        if (!response) {
            return '';
        }

        if (response.status != 200) {
            return '';
        }

        const jsonStr = await response.text();
        return jsonStr;


    } catch (error) {
        console.log(error);
    }
}

async function formataListas(lista) {
    let listaFormatada = '';
    if (lista == '') {
        return '';
    }
    lista = lista.split(',');
    for (let i = 0; i < lista.length; i++) {
        listaFormatada += "'" + lista[i] + "',";
    }
    return listaFormatada.substring(0, listaFormatada.length - 1);
}

function transformaPDFemBase64(url) {
    return fetch(url)
        .then(response => response.blob())
        .then(blob => new Promise(callback => {
            let reader = new FileReader();
            reader.onload = function () {
                callback(this.result)
            };
            reader.readAsDataURL(blob);
        }));
}

async function enviarMensagem(telefone = '', mensagem = '', base64 = false, showSuccess = true) {
    try {
        try {
            const session = getCookie('Session@Whatsapp');
            if (!session || session == '') {
                msgAlerta('Whatsapp não configurado para esse usuário, verifique.');
                return;
            }

            const messageObject = {
                phone: '55' + telefone,
                message: mensagem,
                isGroup: false
            }

            const base64Object = {
                phone: '55' + telefone,
                base64: mensagem,
                isGroup: false,
                filename: 'Relatório'
            }

            const route = base64 ? 'send-file-base64' : 'send-message';
            const objectType = base64 ? base64Object : messageObject;

            const response = await requisicao_wpp('POST', `/api/${session}/${route}`, '', JSON.stringify(objectType));
            if (!response) {
                return;
            }
            if (![200, 201].includes(response.status)) {
                msgErro('Erro ao enviar mensagem via WhatsApp, se o erro persistir, reconecte o aparelho.');
                return false;
            }
            if (showSuccess) {
                toastr.success("Mensagem enviada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });
            }
            return true;
        } catch (error) {
            msgErro('Erro ao enviar mensagem via WhatsApp, se o erro persistir, reconecte o aparelho.');
            console.error(error);
        }
    } finally {
    }
}

function utilizaWhatsapp() {
    return (getCookie('Session@Whatsapp') != '')
        && (getCookie('Session@Whatsapp') != null)
        && (getCookie('Session@Whatsapp') != 'undefined')
}


async function getWhatsapp(codcli) {
    function onlyNumbers(telefone) {
        return telefone.replace(/[^0-9]/g, '');
    }

    function validPhoneNumber(telefone) {
        const validacao = telefone.match(/^\s*(\d{2}|\d{0})[-. ]?(\d{5}|\d{4})[-. ]?(\d{4})[-. ]?\s*$/);
        return ((validacao) && (validacao.length == 4) && (validacao != null))
    }

    try {
        if (codcli == '') {
            return '';
        }

        const pesquisa = {
            camposSelect: ['DDD_FONE DDD', 'TELEFONE'],
            tabela: 'ENTIDADE',
            where: [`CODCLI = '${codcli}'`]
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
        const ddd = onlyNumbers(jsonStr[0].DDD);
        const telefone = onlyNumbers(jsonStr[0].TELEFONE);

        if ((ddd != '')
            && (telefone != '')
            && (ddd.length === 2)
            && (validPhoneNumber(ddd + telefone))) {
            return ddd + telefone;
        }
        return '';
    } catch (err) {
        console.error(err);
        return '';
    }
}

async function vencimentoCertificado() {
    const empId = getCookie('emp_id');

    const pesquisa = {
        camposSelect: ['VALIDADE_CERT'],
        tabela: 'EMPRESA',
        where: [`EMP_ID = ${empId}`]
    }
    const jsonStr = (await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa)))[0];

    if (!jsonStr.VALIDADE_CERT) {
        return;
    }

    $('#txtVencimentoCertificadoDigital').text('Certificado digital válido até ' +
        jsonStr.VALIDADE_CERT.split('-')[2] +
        '/' +
        jsonStr.VALIDADE_CERT.split('-')[1] +
        '/' +
        jsonStr.VALIDADE_CERT.split('-')[0]);
}

async function retornaDatabase() {
    try {
        const response = await requisicao("GET", "/sisplan/funcoes/v1/retornadatabase?", '', '', 60000);

        if (!response) {
            return '';
        }

        if (response.status != 200) {
            return '';
        }

        const jsonStr = await response.text();
        return jsonStr;


    } catch (error) {
        console.log(error);
    }
}

async function setarDataAnoAnterior(componente) {
    const today = new Date();
    $(`#${componente}`).val(`${today.getFullYear() - 1}-${'01'}-${'01'}`);
}

async function insereValorPesquisaVarios(componente, campoChave, campoDescricao, objeto) {
    objeto.forEach(dado => {
        const option = {
            id: dado[campoChave],
            text: `[${dado[campoChave]}] - ${dado[campoDescricao]}`
        }
        const newOption = new Option(option.text, option.id, true, true);
        $(`#${componente}`).append(newOption).trigger('change');
    });
}

async function verificaDepositosEmpresaLogada(empresa) {
    try {
        let response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"EMPRESA", "camposSelect":["EMP_DEPOSITO"], "where": ["EMP_PAT = '${empresa}'"]}`, null);

        if (!response) {
            return '';
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return '';
        }

        return jsonStr.RESULT[0][0].EMP_DEPOSITO;

    } catch (error) {
        console.error(error);
        return '';
    }
}

async function verificaMoedasCliente(codcli) {
    try {
        const moedas = [];
        let response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"ENT_MOEDA", "camposSelect":["CODMOE"], "where": ["CODCLI = '${codcli}'"]}`, null);

        if (!response) {
            return '';
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return '';
        }

        if (jsonStr.RESULT[0].length > 0) {
            jsonStr.RESULT[0].forEach(moeda => {
                moedas.push(moeda.CODMOE);
            });
            return moedas;
        } else {
            return '';
        }

    } catch (error) {
        console.error(error);
        return '';
    }
}

async function pingTEF() {
    try {

        const response = await requisicao_ecf('GET', '/tef/pingtef?', '');

        if (!response) {
            return false;
        }

        if (response.status != 200) {
            return false
        }

        return true;
    } catch (error) {
        console.log(error);
        return false;
    }
}

function preencheDadosCheque(campo) {
    const sLeitura = $(campo).val();
    if (sLeitura.length == 34) {
        const row = $(campo).closest('tr');
        const id = row.index();
        const banco = sLeitura.substring(1, 4);
        const agencia = sLeitura.substring(4, 8);
        const CodBanco = parseInt(banco);
        let digIgnorar;
        switch (CodBanco) {
            case 1:
                digIgnorar = 2;    // 001 - Banco do Brasil
                break;
            case 33:
                digIgnorar = 2;    // 033 - Santander / Banespa
                break
            case 41:
                digIgnorar = 0;    // 041 - Banrisul Obs: Este banco utiliza todo o campo para o número da conta
                break;
            case 85:
                digIgnorar = 2;
                break;
            case 104:
                digIgnorar = 0;    // 104 - CEF. Utiliza apenas 7, mas os 3 primeiros são necessários para calcular o dv
                break;
            case 237:
                digIgnorar = 3;    // 237 - Bradesco
                break;
            case 341:
                digIgnorar = 4;    // 341 - Itau
                break;
            case 389:
                digIgnorar = 1;    // 389 - Mercantil
                break;
            case 399:
                digIgnorar = 4;    // 399 - HSBC
                break;
            //  409: Result := 3;    // 409 - Unibanco
            case 479:
                digIgnorar = 2;    // 479 - Bank of Boston
                break;
            default: digIgnorar = 3;
        }
        const conta = sLeitura.substring(22 + digIgnorar, 32);
        const numero = sLeitura.substring(13, 19);
        insereValor(`#banco_col_${id}_row_2`, banco, banco);
        $($(".campoAgencia")[id]).val(agencia);
        $($(".campoConta")[id]).val(conta);
        $($(".campoNumero")[id]).val(numero);
        return false;
    }
    return true;
}

async function buscaParametroERP(tipo, numero, posicao, len) {
    try {

        const response = await requisicao('GET', '/Sisplan/Funcoes/v1/buscaparametro?', `TIPO=${tipo}&NUMERO=${numero}&POSICAO=${posicao}&LEN=${len}`, 60000)
        if (!response) {
            return false;
        }

        if (response.status != 200) {
            return false;
        }

        let valor = await response.text();

        return valor;

    } catch (error) {
        console.log(error);
        return false;
    }
}

async function retornaInformacaoEmpresa() {
    try {
        let url = `/sisplan/funcoes/v1/pesquisa?`;
        let response = await requisicao('GET', url, `JSON={ 
        "tabela":"empresa", 
        "camposSelect":["emp_estado", "emp_csrt", "emp_csrt_id", "emp_pat", "emp_cert", "emp_crt", "emp_cnpj", "emp_id"], 
        "where": ["emp_id = ${getCookie('emp_id')}"] 
      }`, null);
        if (!response) {
            return;
        }
        let jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
        }
        return jsonStr.RESULT[0][0];
    } catch (error) {
        console.error(error);
        msgErro('Erro ao retornar dados da empresa, Erro: ');
    }
};

function primeiraLetraMaiuscula(texto) {
    return texto.charAt(0).toUpperCase() + texto.slice(1);
}

async function buscaDepositoEmpresaUsuario() {
    let dep;

    dep = await verificaDepositosEmpresaLogada(getCookie('empresa'));

    if (dep == '') {
        dep = await verificaDepositosUsuarioLogado(getCookie('cod_usuario'));
    }

    return dep;
}

async function verificaDepositosUsuarioLogado(usuario) {
    try {
        $.LoadingOverlay("show");
        try {
            const url = '/Sisplan/Funcoes/v1/pesquisa?';
            const params = `JSON={ "tabela":"ACESSO_USUARIOS", "camposSelect":["DEPOSITOS"], "where": ["CODIGO = '${usuario}'"]}`;
            const response = await requisicao('GET', url, params, null);

            if (!response) {
                return 'null';
            }

            const jsonStr = await response.json();

            if (jsonStr.codigo == 400) {
                return 'null';
            }

            return jsonStr.RESULT[0][0].DEPOSITOS;
        } catch (error) {
            console.error(error);
            return 'null';
        }
    } finally {
        $.LoadingOverlay("hide");
    }
};

async function componenteFiltro(tabela, retornaMaisDeUmRegistro = false) {
    try {

        let filtroDeposito;

        if (tabela == 'depositoUsuario') {
            filtroDeposito = await buscaDepositoEmpresaUsuario();
        }
        filtroDeposito = filtroDeposito == '' ? null : `CODIGO IN (${filtroDeposito})`;

        const tabelaTratada = primeiraLetraMaiuscula(tabela);
        const pesquisaTabelas = {
            colecao: { serverSide: false, nomePesquisa: 'Coleção', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'COLECAO', camposSelect: ['CODIGO', 'DESCRICAO'] } },
            entidade: { serverSide: true, nomePesquisa: 'Cliente', tamanhoAutoCompleta: 3, pesquisa: { tabela: 'ENTIDADE', camposSelect: ['CODCLI', 'NOME'] } },
            produto: { serverSide: true, nomePesquisa: 'Produto', tamanhoAutoCompleta: 3, pesquisa: { tabela: 'PRODUTO', camposSelect: ['CODIGO', 'DESCRICAO', 'CODIGO2'] } },
            etiqueta: { serverSide: false, nomePesquisa: 'Etiqueta', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'ETQ_PROD', camposSelect: ['CODIGO', 'DESCRICAO'] } },
            marca: { serverSide: false, nomePesquisa: 'Marca', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'MARCA', camposSelect: ['CODIGO', 'DESCRICAO'] } },
            grupo: { serverSide: false, nomePesquisa: 'Grupo', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'GRUPO_PA', camposSelect: ['CODIGO', 'DESCRICAO'] } },
            linha: { serverSide: false, nomePesquisa: 'Linha', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'TABLIN', camposSelect: ['CODIGO', 'DESCRICAO'] } },
            tabPreco: { serverSide: false, nomePesquisa: 'Tabela de Preço', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'REGIAO', camposSelect: ['REGIAO', 'DESCRICAO'] } },
            cor: { serverSide: false, nomePesquisa: 'Cor', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'CADCOR', camposSelect: ['COR', 'DESCRICAO'] } },
            deposito: { serverSide: false, nomePesquisa: 'Depósito', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'DEPOSITO', camposSelect: ['CODIGO', 'DESCRICAO'] } },
            vendedor: { serverSide: false, nomePesquisa: 'Vendedor', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'REPRESEN', camposSelect: ['CODREP', 'NOME'] } },
            grupoCli: { serverSide: false, nomePesquisa: 'Grupo de Cliente', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'GRUPO_CLI', camposSelect: ['CODIGO', 'DESCRICAO'] } },
            grupoPA: { serverSide: false, nomePesquisa: 'Grupo de Produto', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'GRUPO_PA', camposSelect: ['CODIGO', 'DESCRICAO'] } },
            cliente: { serverSide: true, nomePesquisa: 'Cliente', tamanhoAutoCompleta: 3, pesquisa: { tabela: 'ENTIDADE', camposSelect: ['CODCLI', 'NOME'] } },
            guia: { serverSide: true, nomePesquisa: 'Guia', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'REPRESEN', camposSelect: ['CODREP', 'NOME'], where: ["ATIVO = 'S'", "GRUPO_REP = 'U'"] } },
            tipoVenda: { serverSide: true, nomePesquisa: 'Tipo Venda', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'VENDA_TIPO', camposSelect: ['ID CODIGO', 'DESCRICAO'] } },
            tipoProduto: { serverSide: true, nomePesquisa: 'Tipo Produto', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'CAD_TIPO_PROD', camposSelect: ['CODIGO', 'DESCRICAO'] } },
            fornecedor: { serverSide: true, nomePesquisa: 'Fornecedor', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'ENTIDADE', camposSelect: ['CODCLI', 'NOME'] } },
            usuario: { serverSide: true, nomePesquisa: 'Usuário', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'ACESSO_USUARIOS', camposSelect: ['NOME', 'CODIGO'], where: ["ATIVO = 'S'"] } },
            material: { serverSide: true, nomePesquisa: 'Material', tamanhoAutoCompleta: 3, pesquisa: { tabela: 'MATERIAL', camposSelect: ['CODIGO', 'DESCRICAO', 'CODIGO2'] } },
            grupoMA: { serverSide: true, nomePesquisa: 'Grupo Material', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'GRUPO_MA', camposSelect: ['CODIGO', 'DESCRICAO'] } },
            subGrupo: { serverSide: true, nomePesquisa: 'Grupo Material', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'SUBGRUPO_MA', camposSelect: ['CODIGO', 'DESCRICAO'] } },
            modelo: { serverSide: true, nomePesquisa: 'Modelo Produto', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'MODELO', camposSelect: ['CODIGO', 'DESCRICAO'] } },
            tamanho: { serverSide: true, nomePesquisa: 'Tamanho', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'TABTAM', camposSelect: ['TAM', 'CODIGO2'] } },
            qualidade: { serverSide: true, nomePesquisa: 'Qualidade', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'TABQUL', camposSelect: ['CODIGO', 'DESCRICAO'] } },
            tipoMov: { serverSide: true, nomePesquisa: 'Tipo Movimentação', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'TABBAI', camposSelect: ['CODIGO', 'DESCRICAO'] } },
            depositoUsuario: { serverSide: false, nomePesquisa: 'Depósito', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'DEPOSITO', camposSelect: ['CODIGO', 'DESCRICAO'], where: [filtroDeposito] } },
            venda: { serverSide: false, nomePesquisa: 'Venda', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'VENDA', camposSelect: ['CODVEN', 'NOME_CONSUMIDOR'] } },
            moeda: { serverSide: false, nomePesquisa: 'Moeda', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'MOEDA', camposSelect: ['CODMOE', 'DESCRICAO'] } },
            classe: { serverSide: true, nomePesquisa: 'Classe', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'CLASSE_GER', camposSelect: ['CODIGO', 'DESCRICAO'] } },
            banco: { serverSide: true, nomePesquisa: 'Banco', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'CADBAN', camposSelect: ['BANCO', 'NOME_BANCO'] } },
            situacao: { serverSide: true, nomePesquisa: 'Situação', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'TABSIT', camposSelect: ['CODIGO', 'DESCRICAO'] } },
            historico: { serverSide: true, nomePesquisa: 'Histórico', tamanhoAutoCompleta: 1, pesquisa: { tabela: 'HISTCP', camposSelect: ['HISTORICO', 'DESCRICAO'] } },
        };

        const pesquisa = pesquisaTabelas[tabela];
        const input = $(`#txt${tabelaTratada}`);
        const botao = $(`#btn${tabelaTratada}`);
        const botaoLimpar = $(`#btnLimpa${tabelaTratada}`);

        if (!pesquisa || !input[0] || !botao[0] || !botaoLimpar[0]) {
            throw new Error('algum dos componentes está errado');
        }
        let pesquisaAutoCompleta = {};

        if (retornaMaisDeUmRegistro) {
            pesquisaAutoCompleta = {
                ...pesquisa.pesquisa, camposSelect: [...pesquisa.pesquisa.camposSelect.map((coluna) => coluna)]
            };
            $(input).pesquisa_variosServerside(pesquisa.tamanhoAutoCompleta, `${JSON.stringify(pesquisaAutoCompleta)}`, pesquisa.pesquisa.camposSelect[0], pesquisa.pesquisa.camposSelect[1]);
            $(botao).pesquisa_serversideSel(input, `${JSON.stringify(pesquisa.pesquisa)}`, `Pesquisa ${pesquisa.nomePesquisa}`);
        } else if (pesquisa.serverSide && !retornaMaisDeUmRegistro) {
            pesquisaAutoCompleta = {
                ...pesquisa.pesquisa, camposSelect: [...pesquisa.pesquisa.camposSelect.map((coluna, idx) => idx == 0 ? `${coluna} CHAVE`
                    : `${coluna} DESCRICAO`)]
            };
            $(botao).pesquisa_serverside([input], [...pesquisa.pesquisa.camposSelect.map(coluna => coluna)], [...pesquisa.pesquisa.camposSelect.map(coluna => coluna)], JSON.stringify(pesquisa.pesquisa), `Pesquisa ${pesquisa.pesquisa.tabela}`);
            $(input).pesquisa_variosServerside(pesquisa.tamanhoAutoCompleta, `${JSON.stringify(pesquisaAutoCompleta)}`, pesquisa.pesquisa.camposSelect[0], pesquisa.pesquisa.camposSelect[1]);
        } else {
            const pesquisaAutoCompleta = {
                ...pesquisa.pesquisa, camposSelect: [...pesquisa.pesquisa.camposSelect.map((coluna, idx) => idx == 0 ? `${coluna} CHAVE`
                    : `${coluna} DESCRICAO`)]
            };
            $(input).autocompleta(pesquisa.tamanhoAutoCompleta, `JSON=${JSON.stringify(pesquisaAutoCompleta)}`);
            $(botao).pesquisa(input, pesquisa.pesquisa.camposSelect[0], pesquisa.pesquisa.camposSelect[1], `/sisplan/funcoes/v1/pesquisa?JSON=${JSON.stringify(pesquisa.pesquisa)}`, pesquisa.nomePesquisa, pesquisa.pesquisa.tabela.toUpperCase());
        }

        // switch (pesquisa.serverSide) {
        //     case 'serverSideSel':
        //         pesquisaAutoCompleta = {
        //             ...pesquisa.pesquisa, camposSelect: [...pesquisa.pesquisa.camposSelect.map((coluna) => coluna)]
        //         };
        //         $(input).pesquisa_variosServerside(pesquisa.tamanhoAutoCompleta, `${JSON.stringify(pesquisaAutoCompleta)}`, pesquisa.pesquisa.camposSelect[0], pesquisa.pesquisa.camposSelect[1]);
        //         $(botao).pesquisa_serversideSel(input, `${JSON.stringify(pesquisa.pesquisa)}`, `Pesquisa ${pesquisa.pesquisa.tabela}`);
        //         break;
        //     case 'serverSide':
        //         pesquisaAutoCompleta = {
        //             ...pesquisa.pesquisa, camposSelect: [...pesquisa.pesquisa.camposSelect.map((coluna, idx) => idx == 0 ? `${coluna} CHAVE`
        //                 : `${coluna} DESCRICAO`)]
        //         };
        //         $(botao).pesquisa_serverside([input], [...pesquisa.pesquisa.camposSelect.map(coluna => coluna)], [...pesquisa.pesquisa.camposSelect.map(coluna => coluna)], JSON.stringify(pesquisa.pesquisa), `Pesquisa ${pesquisa.pesquisa.tabela}`);
        //         $(input).autocompleta(pesquisa.tamanhoAutoCompleta, `JSON=${JSON.stringify(pesquisaAutoCompleta)}`);
        //         break;
        //     default:
        //         $(botao).pesquisa(input, pesquisa.pesquisa.camposSelect[0], pesquisa.pesquisa.camposSelect[1], `/sisplan/funcoes/v1/pesquisa?JSON=${JSON.stringify(pesquisa.pesquisa)}`, pesquisa.nomePesquisa, pesquisa.pesquisa.tabela.toUpperCase());
        //         break;
        // }

        $(botaoLimpar).on('click', function () {
            $(input).empty().trigger('change')
            $(input).val('');
            $(input).attr('data-chave', '');
            $(input).attr('data-desc', '');
        });
    } catch (err) {
        console.error('Atenção ! Provavelmente você esqueceu de seguir o padrão de nome do input, botão de pesquisa e botão de limpar, ou ainda não está na lista padronizada, verifique !!!', `tabela: ${tabela}`);
    }
}

function limparFiltros(select = false) {

    if (select) {
        const botaoLimparFiltros = $('#btnLimparFiltros');

        botaoLimparFiltros.on('click', function () {
            const listaInputs = $('#modal-filtros .modal-body input').toArray();
            listaInputs.forEach(input => {
                if (input.type != 'radio') {
                    $(input).val('');
                }
            });

            const listaSelects = $('#modal-filtros .modal-body select').toArray();
            listaSelects.forEach(input => {
                $(input).empty().trigger('change');
            })
        });

        return;
    }

    const botaoLimparFiltros = $('#btnLimparFiltros');

    botaoLimparFiltros.on('click', function () {
        const listaInputs = $('#modal-filtros .modal-body input').toArray();
        listaInputs.forEach(input => {
            if (input.type != 'radio') {
                $(input).val('');
            }
        });
        const listaSelects = $('#modal-filtros .modal-body select').toArray();
        listaSelects.forEach(input => {
            $(input).val('');
        })
    });
}

function adicionaColunas(colunas, invisiveis) {
    $('#colunasInvisiveis').html('');
    colunas.map((coluna, i) => {
        $('#colunasInvisiveis').html(`
            ${$('#colunasInvisiveis').html()}
            <label htmlFor="txt${coluna.data}" class="col-3 labelColunasInvisiveis" title='Coluna ${coluna.title}'>
                <input type="checkbox" value=${i} name="txt${coluna.data}" id="txt${coluna.data}" />
                ${coluna.title}
            </label>
        `);
        if (invisiveis) {
            if (invisiveis.filter((invisivel) => invisivel == coluna.data)[0] == coluna.data) {
                $(`#txt${coluna.data}`).attr('checked', true);
            }
        }
    });
}

function retornaNovasColunasInvisiveis() {
    const colunasInvisiveis = [];
    // const colunas = $($('#colunasInvisiveis'))[0].outerText.split('\n');
    const colunas = $('#colunasInvisiveis label input').map(function () {
        return this.id.replace('txt', '');
    }).get();
    $('#colunasInvisiveis').parent('input');
    colunas.map((coluna) => {
        if (isChecked(`#txt${coluna}`)) {
            colunasInvisiveis.push(coluna)
            return coluna;
        }
    });
    return colunasInvisiveis;
}

async function exportaCSV(url, filtros, pesquisaPadrao, timeout, titulo, tabela, codPersonalizado = '', arrayJson = 999, body = false) {

    try {
        $.LoadingOverlay('show');
        let response;
        try {

            if (body) {
                response = await requisicao('POST', url, '', filtros, timeout);
            } else {
                response = await requisicao('GET', url, filtros, '', timeout);
            }

            if (!response) {
                return;
            }

            let dados;

            if (pesquisaPadrao) {
                dados = (await response.json()).RESULT[0];
            } else {
                dados = await response.json();
            }

            if (arrayJson != 999) {
                dados = dados[arrayJson];
            }

            $(tabela).DataTable().colReorder.reset();

            eval(codPersonalizado);

            const colunasDelete = [];
            const colunasCabecalho = [];
            const arrayFormatar = [];

            $(tabela).DataTable().columns().every(function () {
                if (this.visible() && this.dataSrc().toUpperCase() != 'OPCOES' && this.dataSrc().toUpperCase() != 'SEL') {
                    colunasCabecalho.push(($(this.header()).text()).trim());
                    if (typeof this.dataSrc() == 'string') {
                        arrayFormatar.push(`if (typeof e['${this.dataSrc()}'] == 'string') {e['${this.dataSrc()}'] = (e['${this.dataSrc()}']).replaceAll(',', '').replaceAll(';', '')}`);
                    }
                } else {
                    colunasDelete.push(`delete objeto['${this.dataSrc()}']`)
                }

            });

            dados.map(function (objeto) {
                eval(colunasDelete.toString().replaceAll(',', '; '));
                return objeto;
            })

            let dadosCsv = [];

            dadosCsv.push(colunasCabecalho.join(';'));

            dados.map(e => {
                eval(arrayFormatar.join(';'))
                dadosCsv.push((Object.values(e)).join(';'));
            });

            dadosCsv = dadosCsv.join('\n');

            let arquivoCsv = new Blob(["\ufeff" + dadosCsv], {
                type: "text/csv;charset=utf-8"
            });

            let downloadLink = document.createElement('a');
            downloadLink.download = titulo + '.csv';
            downloadLink.href = window.URL.createObjectURL(arquivoCsv);

            downloadLink.style.display = "none";

            document.body.appendChild(downloadLink);

            downloadLink.click();
            document.body.removeChild(downloadLink);
        } catch (e) {
            console.error(e);
            msgErro(`Não foi possível realizar a exportação: ${e}`);
        }

    } finally {
        $.LoadingOverlay('hide');
    }
}

function StringToFloatDef(string, defaultValue) {
    return string != '' ? parseFloat(string) : defaultValue
}

async function buscaPesoBalanca(sTipoItem, sParametro) {
    try {
        $.LoadingOverlay('show');
        let response = await requisicao_ecf('GET', '/balanca/chamapeso?', `TIPO=${sTipoItem}&PARAMETRO=${sParametro}`, '', 15000);

        response = await response.text();
        if (response == '-9') {
            response = '0';
        }

        return response.replace(',', '.');
    } catch (err) {
        console.log(err)
    } finally {
        $.LoadingOverlay('hide');
    }
}

async function retornaMsgPersonalizadaWpp(tela, objMsgWpp, retornaLista = false, mostraErro = false) {
    try {
        // ALTERADO METODO PARA POST POIS ERA NECESSÁRIO USAR UM BODY PARA ESSA REQUISIÇÃO
        const response = await requisicao('POST', "/sisplan/config_whatsapp/v1/retornarmensagem?", `TELA=${tela}`, JSON.stringify({ LISTAMSGWHATSAPPWEB: objMsgWpp }));

        if (!response) {
            return "";
        }

        const jsonMensagem = await response.json();

        if (response.status != 200) {
            if (mostraErro) {
                msgAlerta(jsonMensagem.mensagem);
            }
            console.error(jsonMensagem.mensagem);
            return "";
        }

        if (retornaLista) {
            return jsonMensagem.listaMsgWhatsappWeb;
        } else {
            return jsonMensagem.listaMsgWhatsappWeb[0].mensagemPersonalizada;
        }

    } catch (error) {
        console.error(error);
    }
}

function encodeEmoticonsMensagem(mensagem) {
    const regexIdentificadorEmoticon = /<([^<>]+)>/g;
    const emoticons = [];
    let match;

    while ((match = regexIdentificadorEmoticon.exec(mensagem)) !== null) {
        emoticons.push(match[1]);
    }

    emoticons.forEach(emoticon => {
        const emoticonCode = emoticon.codePointAt(0).toString(16).toUpperCase();
        mensagem = mensagem.replaceAll(emoticon, emoticonCode);
    })

    return mensagem;

}

function decodeEmoticonsMensagem(mensagem, formataMsg = false) {
    const regexIdentificadorEmoticon = /<([^<>]+)>/g;
    const emoticonsCode = [];
    let match;

    while ((match = regexIdentificadorEmoticon.exec(mensagem)) !== null) {
        emoticonsCode.push(match[1]);
    }

    emoticonsCode.forEach(code => {
        const emoticon = String.fromCodePoint(parseInt(code, 16));
        mensagem = mensagem.replaceAll(code, emoticon);
    })

    if (formataMsg) {
        mensagem = mensagem.replaceAll('<', '');
        mensagem = mensagem.replaceAll('>', '');
    }

    return mensagem;

}

function carregaFuncoesDataTable(pNome, pTabela) {
    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    // aqui so valida se nao existe tem que criar para nao dar erro
    if (colunas == null || colunas[pNome] == undefined) {
        colunas[pNome] = [];
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify(colunas));
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    }

    // confirma as colunas
    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            colunas[pNome] = novasColunas;
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify(colunas));

            $(pTabela).DataTable().columns().visible(true);
            $(pTabela).DataTable().columns().every(
                function () {
                    if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                }
            );

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    });
}

function validaFiltroUsuario(usuario) {
    if (usuario.includes("TODOS")) {
        return '';
    }

    return usuario;
}

function adicionaValorPadraoVarios(element, val, desc) {
    let j = new Option(`[${val}] - ${desc}`, val, true, true);
    $(`#txt${primeiraLetraMaiuscula(element)}`).append(j).trigger('change');
}

async function enviarMsgPersonalizadaWpp(tela, objMsgWpp, arquivo = undefined, callBackNaoEnviados = undefined) {
    const bUtilizaWhatsapp = utilizaWhatsapp();
    const listaNaoEnviados = [];

    try {
        if (!bUtilizaWhatsapp) {
            throw msgAlerta("Não está configurado para envio de mensagens.");
        }

        //   const arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'Venda');
        //   const base64 = await transformaPDFemBase64(`${sUrl}/relatorios_api/pdf/${arquivo}`);
        let retornoMsgPersonalizadaWpp = await retornaMsgPersonalizadaWpp(tela, objMsgWpp, true);

        if (retornoMsgPersonalizadaWpp[0].mensagemPersonalizada != "") {

            for (let i = 0; i < retornoMsgPersonalizadaWpp.length; i++) {
                const ultimoRegistro = i + 1 == retornoMsgPersonalizadaWpp.length;
                retornoMsgPersonalizadaWpp[i].mensagemPersonalizada = decodeEmoticonsMensagem(retornoMsgPersonalizadaWpp[i].mensagemPersonalizada, true);

                if (!await enviarMensagem(retornoMsgPersonalizadaWpp[i].celular, retornoMsgPersonalizadaWpp[i].mensagemPersonalizada, false, ultimoRegistro)) {
                    listaNaoEnviados.push(retornoMsgPersonalizadaWpp[i].parametrosMensagem.split(",")[0] + " - " + retornoMsgPersonalizadaWpp[i].nome);
                }

                if (arquivo != undefined) {
                    await enviarMensagem(celular, base64, true, false);
                }

            }
        }

        if (listaNaoEnviados.length > 0) {
            let mensagemErros = `Não foi possível enviar a mensagem para os seguintes clientes, número inválido ou não cadastrado. Deseja reenviar? `;
            listaNaoEnviados.forEach(naoEnviados => {
                mensagemErros += `\n${naoEnviados}`;
            });
            msgAlerta(mensagemErros,
                callBackNaoEnviados,
                undefined,
                undefined,
                undefined,
                true);
        }

        return listaNaoEnviados;

    } catch (error) {
        console.error(error);
    }

}

function salvarFiltrosCache(keyCache, campos) {
    try {
        let filtros = {};

        campos.forEach(function (campo) {
            filtros[campo] = $('#' + campo).val();
        });

        localStorage.setItem(keyCache, JSON.stringify(filtros));
    } catch (error) {
        console.log(error);
    }
}

async function restaurarFiltrosCache(keyCache, campos) {
    try {
        let filtrosSalvos = localStorage.getItem(keyCache);
        if (filtrosSalvos) {
            filtrosSalvos = JSON.parse(filtrosSalvos);

            campos.forEach(function (campo) {
                $('#' + campo).val(filtrosSalvos[campo]);
            });
        }
    } catch (error) {
        console.log(error);
    }
}

function limparFiltrosCache(keyCache) {
    try {
        localStorage.removeItem(keyCache);
    } catch (error) {
        console.log(error);
    }
}

function replaceVarios(texto, listaCaracteres, valorSubstituicao) {
    listaCaracteres.forEach(caractere => {
        texto = texto.replace(caractere, valorSubstituicao);
    });

    return texto;

}

$('#btnInfoRelatorio').on('click', function () {
    $('#btnInfoRelatorio').css('color', 'rgb(255, 255, 0)');
    $('#modalInfoRelatorio').on('hide.bs.modal', function () {
        $('#btnInfoRelatorio').css('color', 'rgb(255, 255, 255)');
    });

    $('#btnFecharInfo').on('click', function () {
        $('#modalInfoRelatorio').modal('hide');
    })
    $('#modalInfoRelatorio').modal('show');
});

function adicionarConteudoModal(titulo, conteudoArray) {
    $('#tituloModal').text(titulo);

    $('.formCardInfo').empty();

    $.each(conteudoArray, function (index, item) {
        if (item.tipo === 'paragrafo') {
            $('<p>').text(item.valor).appendTo('.formCardInfo');
        } else if (item.tipo === 'lista') {
            var ul = $('<ul>');
            $.each(item.itens, function (index, subItem) {
                $('<li>').text(subItem).appendTo(ul);
            });
            ul.appendTo('.formCardInfo');
        }
    });
};

function adicionaOrdenacao(campo, array) {

    let aEx;
    let tipoOrd;

    if (array.length == 0) {
        array.push(campo + ' ASC');
    } else {
        aEx = array[0].substring(0, array[0].indexOf(' ')) == campo;
        tipoOrd = array[0].substring(array[0].indexOf(' ') + 1, array[0].length);

        array = array.filter(function (e) {
            return e.substring(0, e.indexOf(' ')) != campo
        });

        if (aEx) {
            tipoOrd = tipoOrd == 'ASC' ? 'DESC' : 'ASC';
        } else {
            tipoOrd = 'ASC';
        }

        array.unshift(campo + ' ' + tipoOrd);
    }

    return array;
}

function retornaDataSrcColuna(tabela, inst) {
    return tabela.DataTable().column(inst[0].attributes['data-column-index'].value).dataSrc();
}