$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a consulta.",
          position: "right",
        },
      },
      {
        element: "#btnNovoVendedorCaixa",
        popover: {
          title: "Botão Incluir",
          description: "Clique aqui para iniciar o cadastro de um vendedor ao caixa.",
          position: "right",
        },
      },
      {
        element: "#tabelaCaixa",
        popover: {
          title: "Tabela Caixas",
          description: "Aqui estão os dados dos vendedores cadastrados aos caixas.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("VENDEDORCAIXA");

  // autocompleta
  $("#txtVendedorCaixa").autocompleta(
    1,
    `JSON={ "tabela":"VENDA_CAIXA", "camposSelect":[ "NRCAIXA chave", "USUARIO DESCRICAO"], "where": null}`
  );
  // pesquisa
  $("#btn-VendedorCaixa").pesquisa(
    "#txtVendedorCaixa",
    "NRCAIXA",
    "USUARIO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VENDA_CAIXA", "camposSelect":[ "NRCAIXA", "USUARIO"]}`,
    "Pesquisa Vendedor Caixa",
    "VENDA_CAIXA"
  );
  // limpacampo
  $("#btn-limpa-VendedorCaixa").on("click", function () {
    $("#txtVendedorCaixa").val("");
  });

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  consultaCaixa();

  $("#btnConsultar").on("click", async function () {
    $("#modal-filtros").modal("hide");
    await consultaCaixa();
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtVendedorCaixa").val("");
  });

  async function consultaCaixa() {
    try {
      $.LoadingOverlay("show");
      let response;
      let caixa = pegaChave("#txtVendedorCaixa") != "" ? ` AND NRCAIXA = '${pegaChave("#txtVendedorCaixa")}' AND USUARIO = '${pegaDescricao("#txtVendedorCaixa")}'` : "";
      response = await requisicao(
        "GET",
        "/Sisplan/Funcoes/V1/pesquisa?",
        `JSON={ "tabela":"VENDA_CAIXA", "camposSelect":[ "NRCAIXA", "USUARIO"], "where": ["EMP_ID = ${getCookie('emp_id')} ${caixa}"]}`,
        null
      );

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#tabelaCaixa").DataTable({
        destroy: true,
        lengthChange: false,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },

        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "NRCAIXA",
          },
          {
            data: "USUARIO",
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $('#btnNovoVendedorCaixa').on('click', function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
          window.location.href = "vendedorcaixa/create";
        } else {
          msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
      });



      $("#tabelaCaixa").on("click", "#btn-editar", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
          let data = $("#tabelaCaixa").DataTable().row($(this).parents("tr")).data();
          let dados = btoa(JSON.stringify({ NRCAIXA: data.NRCAIXA, USUARIO: data.USUARIO }))
          window.location.href = `vendedorcaixa/${dados}`;
        } else {
          msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
      });

      $("#tabelaCaixa").on("dblclick", "tr", async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
          let data = $("#tabelaCaixa").DataTable().row($(this)).data();
          let dados = btoa(JSON.stringify({ NRCAIXA: data.NRCAIXA, USUARIO: data.USUARIO }))
          window.location.href = `vendedorcaixa/${dados}`;
        } else {
          msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $("#tabelaCaixa").unbind("click");

  $('#tabelaCaixa').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaCaixa").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/sisplan/cadastros/v1/vendedorcaixa?", `NRCAIXA=${encodeURIComponent(valorLinha.NRCAIXA)}&NOMEUSUARIO=${encodeURIComponent(valorLinha.USUARIO)}&EMP_ID=${getCookie('emp_id')}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});
