$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnIncluir',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma Solicitação.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir as solicitações de compras filtradas.',
          position: 'right'
        }
      },
      {
        element: '#tabelaSolCompra',
        popover: {
          title: 'Tabela Solicitações',
          description: 'Aqui estão os dados das solicitações cadastradas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

async function validaAlteraSolicitacao(sNumero) {
  const dadosSelect = {
    tabela: 'SOL_ITEN',
    camposSelect: ['NUMERO'],
    where: [`NUMERO = '${sNumero}' AND SITUACAO <> 'B'`]
  };
  const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
  if (!retornoSelect) {
    return;
  }
  if (retornoSelect.length > 0) {
    return true;
  }
  return false;
};

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("SOLICITACAO_COMPRA");

  addFuncoesBotoes();
  await consultaSolicitacao();

  $('#btnConsultar').on('click', async function () {
    $('#modal-filtros').modal('hide');
    await consultaSolicitacao();
  });

  $('#txtSolCompraConsulta').on('blur', function () {
    let solCompra = $('#txtSolCompraConsulta').val();
    if (solCompra.includes("[")) {
      solCompra = pegaChave($('#txtSolCompraConsulta'));
    } else {
      solCompra = $('#txtSolCompraConsulta').val();
    }
    solCompra = solCompra.replace('\w', '');
    const listaSolCompra = $('#txtListaSolCompra').val();
    if (solCompra == '') {
      return;
    }
    $('#txtListaSolCompra').val((listaSolCompra == '') ? `'${solCompra}'` : `${listaSolCompra},'${solCompra}'`);
    $('#txtSolCompraConsulta').val('');
    $('#txtSolCompraConsulta').focus();
  });

  $('#txtSolCompraConsulta').on('keydown', async function (event) {
    if (event.key == 'Enter') {
      $('#txtSolCompraConsulta').trigger('blur');
      $('#txtSolCompraConsulta').focus();
    }
  });

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "solicitacao_compra/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#tabelaSolCompra').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaSolCompra').DataTable().row($(this).parents('tr')).data();
      if (await validaAlteraSolicitacao(data[0])) {
        window.location.href = `solicitacao_compra/${btoa(data[0])}`;
      } else {
        msgAlertaSemConfirmacao("Todos os itens já foram baixados. Não é mais permitido Alterar!");  
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaSolCompra').on('click', '#btn-imprimirItem', async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaSolCompra').DataTable().row($(this).parents('tr')).data();
      const url = `/sisplan/impressao/v1/acesso_solicitacao_compra?`;

      const filtros = retornaFiltros(`'${data[0]}'`);
      const ordem = `&TELA_ORDENACAO=acesso_solicitacao_compra&ORDEM_ORDENACAO=1`; 
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelSolicitacaoA');
      let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelSolicitacaoA');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/acesso_solicitacao_compra?`;

        const filtros = retornaFiltros();
        const ordem = `&TELA_ORDENACAO=acesso_solicitacao_compra&ORDEM_ORDENACAO=1`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelSolicitacaoA');
        let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelSolicitacaoA');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#tabelaSolCompra').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaSolCompra').DataTable().row($(this)).data();
      if (await validaAlteraSolicitacao(data[0])) {
        window.location.href = `solicitacao_compra/${btoa(data[0])}`;
      } else {
        msgAlertaSemConfirmacao("Todos os itens já foram baixados. Não é mais permitido Alterar!");  
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaSolCompra').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaSolCompra").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  function retornaBotaoOpcoes() {
    return '<div class="divBtnOpcoes" style="width:60%; max-width:100%;""> ' +
      '    <button class="botaoOpcoes" type="button" title="Editar" id="btn-editar"><span class="fas fa-edit" style="color:green"></span></button>     ' +
      '    <button class="botaoOpcoes" type="button" title="Imprimir" id="btn-imprimirItem"><span class="fas fa-print" style="color:green"></span> </button>  ' +
      '    <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      '    <button class="botaoOpcoes" type="button" title="Anexos" id="btnAnexos"><span class="fas fa-folder-open" style="color:tan;"></span></button>     ' +
      '   </div>';
  };

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Imprimir" id="btn-imprimirItem">Imprimir</button>  ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '    <button class="dropdown-item" type="button" title="Anexos" id="btnAnexos">Anexos</button>     ' +
      '</div>';
    return retorno;
  };


  function retornaFiltros(sNumero = '') {
    const numero = $('#txtListaSolCompra').val();
    const solicitante = pegaChave('#txtSolicitanteConsulta');
    const status = pegaChave('#txtStatus');
    const statusLib = pegaChave('#txtStatusLib');
    const emissaoDe = $("#txtDataEmiDe").val();
    const emissaoAte = $("#txtDataEmiAte").val();

    const filtros = `NUMERO=${sNumero == '' ? numero : sNumero}` +
      `&SOLICITANTE=${solicitante}` +
      `&STATUS=${status}` +
      `&LIBERADO=${statusLib}` +
      `&EMISSAODE=${emissaoDe}` +
      `&EMISSAOATE=${emissaoAte}`;

    return filtros;
  };

  async function consultaSolicitacao() {
    try {
      $.LoadingOverlay("show");
      let where = '';
      where = pegaChave('#txtListaSolCompra') != '' ? ` AND SOL_COMPRA.NUMERO IN (${$('#txtListaSolCompra').val()})` : '';
      where += pegaChave('#txtSolicitanteConsulta') != '' ? ` AND SOL_COMPRA.SOLICITANTE = '${pegaChave('#txtSolicitanteConsulta')}'` : '';
      where += pegaChave('#txtStatus') != '' ? ` AND SOL_COMPRA.STATUS = '${pegaChave('#txtStatus')}'` : '';
      where += pegaChave('#txtStatusLib') != '' ? ` AND SOL_COMPRA.LIBERADO = '${pegaChave('#txtStatusLib')}'` : '';
    
      if ($("#txtDataEmiDe").val() != "01-01-1200" || $$("#txtDataEmiAte").val() != "01-12-2500") {
        where += ` and SOL_COMPRA.DATA >= '${$("#txtDataEmiDe").val()}' and SOL_COMPRA.DATA <= '${$("#txtDataEmiAte").val()}'`;
      }

      $("#tabelaSolCompra").DataTable({
        destroy: true,
        lengthChange: false,
        serverSide: true,
        processing: true,
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "GET",
          headers: { Authorization: BASIC_AUTH },
          data: {
            EMPRESA: getCookie("empresa"),
            JSON: `{ "tabela":"SOL_COMPRA", "camposSelect":["SOL_COMPRA.NUMERO", "PESSOAL.NOME", "SOL_COMPRA.USUARIO"], 
                    "leftjoin": [{"tabela" : "PESSOAL", "condicao" : "PESSOAL.CODIGO = SOL_COMPRA.SOLICITANTE"}],                                 
                    "where": ["1=1 ${where}"]}`,
            CLIENTE: "S",
          },
        },
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  };

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        const valorLinha = data.data();
        const response = await requisicao('DELETE', '/sisplan/solicitacao_compra/v1/solicitacao_compra?', `NUMERO=${encodeURIComponent(valorLinha[0])}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          const jsonStr = await response.json();
          msgAlerta(jsonStr.mensagem);
          return;
        }

        criaMensagemSucesso('Exclusão efetuada com sucesso!', () => { window.location.reload() });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  $("#tabelaSolCompra").on('click', "#btnAnexos", async function () {
    const data = $('#tabelaSolCompra').DataTable().row($(this).parents('tr')).data();

    await abreModalAnexos(data[0], data[1], 'SOLICITACAO_COMPRA');
  })

  function addFuncoesBotoes() {
    $('#btn-limpa-SolCompra').on('click', function () {
      $('#txtListaSolCompra').val('');
    });

    $("#btn-SolCompraConsulta").pesquisa_serverside(["#txtSolCompraConsulta"], ["NUMERO"], ["SOLICITANTE"], `{"tabela":"SOL_COMPRA", "camposSelect":[ "NUMERO", "SOLICITANTE" ]}`, "Pesquisa Solicitação");

    $("#txtSolicitanteConsulta").autocompleta(2, `JSON={ "tabela":"PESSOAL", "camposSelect":["PESSOAL.CODIGO CHAVE, PESSOAL.NOME DESCRICAO"]}`);
    $("#btn-SolicitanteSolCompra").pesquisa_serverside(["#txtSolicitanteConsulta"], ["CODIGO"], ["NOME"], `{"tabela":"PESSOAL", "camposSelect":[ "CODIGO", "NOME" ]}`, "Pesquisa Solicitante");
    $('#btn-limpa-SolicitanteSolCompra').on('click', function () { $('#txtSolicitanteConsulta').val(''); });

    $('#btnFiltros').on('click', function () {
      $('#modal-filtros').modal('show');
    });

    $('#btnLimparFiltros').on('click', async function () {
      $('#txtSolCompraConsulta').val('');
      $('#txtListaSolCompra').val('');
      $('#txtSolicitanteConsulta').val('');
      $("#txtDataEmiDe").val("1200-01-01");
      $("#txtDataEmiAte").val("2500-12-01");
      $("#txtStatusLib").val('');
      $("#txtStatus").val('');
    });
  };

});