<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Relatório de Peças Faturadas</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.231.11.1">

  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.231.11.1">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.231.11.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.231.11.1">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.231.11.1">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.231.11.1">
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.227.20.1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.231.11.1">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.231.11.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.231.11.1">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.234.11.1">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.234.11.1">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.234.11.1">
  <style>
    .bordaCampos {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding-top: 2%;
      padding-bottom: 0%;
    }

    .bordaCampos:first-child {
      display: flex;
      flex-direction: row;
      flex-wrap: wrap;
      justify-content: flex-end;
      align-items: center;
    }

    .border-Field .textoBorda {
      font-size: 1.0em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1.0px solid var(--font-color) !important;
      padding: 0 1.0em 1.0em 1.0em !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      padding-bottom: 0px !important;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <main class="wrapper">

    <?php
    include_once('../../menu.php');
    ?>

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Relatório de Peças Faturadas</h1>
            </div>
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="./index">Início</a></li>
                <li class="breadcrumb-item active">Relatório de Peças Faturadas</li>
              </ol>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <fieldset>
                <div class="row">
                  <div class="col-12">
                    <div class="buttons">
                      <button class="btn btn-success btn-sisp" id="btnFiltrosRel" type="button"><span class="fas fa-filter"></span> Filtros</button>
                      <button id="btnImprimirRel" class="btn-sisp btn btn-danger"><i class="fas fa-print"></i> Imprimir</button>
                    </div>
                  </div>
                </div>
                <div class="card-body">
                  <div class="card">
                    <div class="col-sm-12 table-responsive card-body">
                      <table id="tabelaPecasFaturadas" class="table table-sm table-select table-hover" style="white-space: nowrap" width="100%"></table>
                      <thead>
                        <tr></tr>
                      </thead>
                      <tbody>
                        <tr></tr>
                      </tbody>
                    </div>
                  </div>
                </div>
              </fieldset>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content" id="modalBody">
          <div class="modal-header col-12">
            <h4 class="modal-title">Filtros</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body pb-0">
            <div class="card card-dark card-tabs col-12">
              <div class="card-body pt-0">
                <div class="row">
                  <div class="col-lg-4 col-12">
                    <div class="bordaCampos">
                      <label class="container mb-2">Produto
                        <input type="radio" checked="checked" id="radioProduto" name="tipoItem">
                        <span class="checkmark"></span>
                      </label>
                      <label class="container mb-2">Material
                        <input type="radio" id="radioMaterial" name="tipoItem">
                        <span class="checkmark"></span>
                      </label>
                    </div>
                  </div>
                  <div class="col-lg-4 col-12 mt-lg-0 mt-4">
                    <button id="btnCarregaEmpresas" class="btn btn-danger">Selecionar Empresas</button>
                  </div>
                  <div class="col-lg-12 col-12">
                    <div class="row">
                      <div class="col-lg-2 col-sm-12 col-12">
                        <div class="mt-2 mt-md-">
                          <label style="margin-bottom: .1rem;" for="txtDataEmissaoNFI">Emissão NF de:</label>
                          <div class="relative">
                            <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataEmissaoNFI" name="DataDe">
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-2 col-sm-12 col-12">
                        <div class="mt-2 mt-md-">
                          <label style="margin-bottom: .1rem;" for="txtDataEmissaoNFF">Emissão NF até:</label>
                          <div class="relative">
                            <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataEmissaoNFF" name="DataAte">
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12 mt-2 mt-md-">
                        <label style="margin-bottom: .1rem;" data-error="wrong" id="lblInputCodigo" data-success="right" for="txtCodigo">Produto: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtCodigo" name="txtCodigo" class="form-control" placeholder="Código">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaProduto" name="btnConsultaProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12 mt-2 mt-md-">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtCliente">Cliente: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaCliente" name="btnConsultaCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-lg-4 col-sm-12 col-12 mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtGrupoMat">Grupo Mat: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtGrupoMat" name="txtGrupoMat" class="form-control" placeholder="Grupo Material">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaGrupoMat" name="btnConsultaGrupoMat" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaGrupoMat" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" id="labelSubGrupoMat" for="txtSubgrupoMat">SubGrupo Mat:</label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtSubgrupoMat" name="txtSubgrupoMat" class="form-control" placeholder="SubGrupo Material">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaSubgrupoMat" name="btnConsultaSubgrupoMat" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaSubgrupoMat" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" id="labelRepresen" for="txtRepresentante">Representante: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtRepresentante" name="txtRepresentante" class="form-control" placeholder="Representante">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaRepresen" name="btnConsultaRepresen" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaRepresen" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtGrupoCli">Grupo Cliente: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtGrupoCli" name="txtGrupoCli" class="form-control" placeholder="Grupo Cliente">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaGrupoCli" name="btnConsultaGrupoCli" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaGrupoCli" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtGrupo">Grupo: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtGrupo" name="txtGrupo" class="form-control" placeholder="Grupo">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaGrupoProd" name="btnConsultaGrupoProd" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaGrupoProd" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtComposicao">Composição: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtComposicao" name="txtComposicao" class="form-control" placeholder="Composição">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaComposicao" name="btnConsultaComposicao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaComposicao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtNCM">NCM: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtNCM" name="txtNCM" class="form-control" placeholder="NCM">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaNCM" name="btnConsultaNCM" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaNCM" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtCoord">Coord.: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtCoord" name="txtCoord" class="form-control" placeholder="Coord.">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaCoord" name="btnConsultaCoord" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaCoord" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtDeposito">Depósito: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtDeposito" name="txtDeposito" class="form-control" placeholder="Depósito">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaDeposito" name="btnConsultaDeposito" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaDeposito" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtMoeda">Moeda: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtMoeda" name="txtMoeda" class="form-control" placeholder="Moeda">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaMoeda" name="btnConsultaMoeda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaMoeda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtLinhaMat">Linha Mat.: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtLinhaMat" name="txtLinhaMat" class="form-control" placeholder="Linha Mat.">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaLinhaMat" name="btnConsultaLinhaMat" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaLinhaMat" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtLinha">Linha: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtLinha" name="txtLinha" class="form-control" placeholder="Linha">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaLinha" name="btnConsultaLinha" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaLinha" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtNF">Nota Fiscal: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtNF" name="txtNF" class="form-control" placeholder="Nota Fiscal">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaNF" name="btnConsultaNF" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaNF" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtColecaoProd">Coleção Prod.: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtColecaoProd" name="txtColecaoProd" class="form-control" placeholder="Coleção Produto">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaColecaoProd" name="btnConsultaColecaoProd" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaColecaoProd" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtColecaoPed">Coleção Ped.: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtColecaoPed" name="txtColecaoPed" class="form-control" placeholder="Coleção Pedido">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaColecaoPed" name="btnConsultaColecaoPed" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaColecaoPed" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtTipoVenda">Tipo Venda: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtTipoVenda" name="txtTipoVenda" class="form-control" placeholder="Tipo Venda">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaTipoVenda" name="btnConsultaTipoVenda" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaTipoVenda" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtEstilista">Estilista: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtEstilista" name="txtEstilista" class="form-control" placeholder="Estilista">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaEstilista" name="btnConsultaEstilista" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaEstilista" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtMarca">Marca: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtMarca" name="txtMarca" class="form-control" placeholder="Marca">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaMarca" name="btnConsultaMarca" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaMarca" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtPedido">Pedido: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtPedido" name="txtPedido" class="form-control" placeholder="Pedido">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaPedido" name="btnConsultaPedido" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaPedido" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtEstado">Estado: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtEstado" name="txtEstado" class="form-control" placeholder="Estado">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaEstado" name="btnConsultaEstado" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaEstado" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtNatureza">Natureza: </label>
                        <label style="margin: 2px 2px;">
                          <input type="checkbox" id="cbConsideraNatureza" checked="true" title="Considerar ou desconsiderar natureza">
                          <span class="checkmark"></span></label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtNatureza" name="txtNatureza" class="form-control" placeholder="Natureza">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaNatureza" name="btnConsultaNatureza" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaNatureza" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtPrazoEnt">Prazo Ent.: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtPrazoEnt" name="txtPrazoEnt" class="form-control" placeholder="Prazo Ent.">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaPrazoEnt" name="btnConsultaPrazoEnt" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaPrazoEnt" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-2 col-sm-12 col-12">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtLote">Lote: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtLote" name="txtLote" class="form-control" placeholder="Lote">
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-2 col-sm-12 col-12" style="margin-top: 3%;">
                        <label>
                          <input type="checkbox" id="cbUtilizaPartedoLote">
                          <span class="checkmark">Utiliza Parte do Lote.</span></label>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtMotivo">Motivo: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtMotivo" name="txtMotivo" class="form-control" placeholder="Motivo">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaMotivo" name="btnConsultaMotivo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaMotivo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtCategoria">Categoria: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtCategoria" name="txtCategoria" class="form-control" placeholder="Motivo">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaCategoria" name="btnConsultaCategoria" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaCategoria" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtEtiqueta">Etiqueta: </label>
                        <div class="relative">
                          <div class="input-group">
                            <input type="text" class="input-default focus form-control" id="txtEtiqueta" name="txtEtiqueta" class="form-control" placeholder="Etiqueta">
                            <div class="input-group-append">
                              <button class="btn bg-danger" id="btnConsultaEtiqueta" name="btnConsultaEtiqueta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                              <button class="btn bg-danger" id="btnLimpaEtiqueta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-2">
                        <div class="col-md-6 col-sm-6 col-6">
                          <label data-error="wrong" data-success="right" for="txtCofins">Cofins: (%)</label>
                          <div class="relative">
                            <input type="number" class="input-default focus form-control" id="txtCofins" name="txtCofins" class="form-control" placeholder="Cofins">
                          </div>
                        </div>
                        <div class="col-md-6 col-sm-6 col-6">
                          <label data-error="wrong" data-success="right" for="txtPis">Pis: (%)</label>
                          <div class="relative">
                            <input type="number" class="input-default focus form-control" id="txtPis" name="txtPis" class="form-control" placeholder="Pis">
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-lg-4 col-sm-12 col-12  mt-3 mt-md-3">
                        <div class="form" id="tiposNotas">
                          <fieldset class="form border-Field">
                            <legend class="textoBorda mb-0 pb-0">Notas</legend>
                            <div class="form-row ml-auto pl-3">
                              <div class="form-group form-check col-12">
                                <input type="radio" name="nota" value="0" class="form-check-input" id="cbTodas">
                                <label class="form-check-label" for="cbTodas">Todas</label>
                              </div>
                              <div class="form-group form-check col-12">
                                <input type="radio" name="nota" value="1" checked="true" class="form-check-input " id="cbNormais">
                                <label class="form-check-label" for="cbNormais">Normais</label>
                              </div>
                              <div class="form-group form-check col-12">
                                <input type="radio" name="nota" value="2" class="form-check-input" id="cbNormais-Den-Canc">
                                <label class="form-check-label" for="cbNormais-Den-Canc">Normais/Den/Canc</label>
                              </div>
                              <div class="form-group form-check col-12">
                                <input type="radio" name="nota" value="3" class="form-check-input" id="cbNormais-Den">
                                <label class="form-check-label" for="cbNormais-Den">Normais/Den</label>
                              </div>
                              <div class="form-group form-check col-12">
                                <input type="radio" name="nota" value="4" class="form-check-input" id="cbNormais-Canc">
                                <label class="form-check-label" for="cbNormais-Canc">Normais/Canc</label>
                              </div>
                            </div>
                          </fieldset>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12  mt-0 mt-md-3">
                        <div class="form" id="tiposDups">
                          <fieldset class="form border-Field">
                            <legend class="textoBorda mb-0 pb-0">Duplicatas</legend>
                            <div class="form-row ml-auto pl-3">
                              <div class="form-group form-check col-12">
                                <input type="radio" name="tiposduplicatas" checked="true" value="0" class="form-check-input" id="cbTodasDups">
                                <label class="form-check-label" for="cbTodas">Todas</label>
                              </div>
                              <div class="form-group form-check col-12">
                                <input type="radio" name="tiposduplicatas" value="1" class="form-check-input " id="cbComDups">
                                <label class="form-check-label" for="cbComDups">Com Duplicatas</label>
                              </div>
                              <div class="form-group form-check col-12">
                                <input type="radio" name="tiposduplicatas" value="2" class="form-check-input" id="cbSemDups">
                                <label class="form-check-label" for="cbSemDups">Sem Duplicatas</label>
                              </div>
                            </div>
                          </fieldset>
                        </div>
                        <div>
                          <div class="form" id="tipoInss">
                            <fieldset class="form border-Field col-12">
                              <legend class="textoBorda mb-0 pb-0">Inss</legend>
                              <div class="form-row ml-auto pl-2">
                                <div class="form-group form-check col-4">
                                  <input type="radio" name="inss" value="0" checked="true" class="form-check-input" id="cbTodosInss">
                                  <label class="form-check-label" for="cbTodas">Todos</label>
                                </div>
                                <div class="form-group form-check col-4">
                                  <input type="radio" name="inss" value="1" class="form-check-input " id="cbComInss">
                                  <label class="form-check-label" for="cbNormais">Com</label>
                                </div>
                                <div class="form-group form-check col-4">
                                  <input type="radio" name="inss" value="2" class="form-check-input" id="cbSemInss">
                                  <label class="form-check-label" for="cbNormais-Den-Canc">Sem</label>
                                </div>
                              </div>
                            </fieldset>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12 mt-0 mt-md-3">
                        <div class="form" id="tipoNatureza">
                          <fieldset class="form border-Field">
                            <legend class="textoBorda mb-0 pb-0">Tipo (Natureza)</legend>
                            <div class="form-row ml-auto pl-3">
                              <div>
                                <div class="form-group form-check col-12 checkNatureza" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="V" class="form-check-input " id="cbVendaCompra">
                                  <label class="form-check-label" for="cbVendaCompra">Venda/Compras</label>
                                </div>
                                <div class="form-group form-check col-12 checkNatureza" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="D" class="form-check-input" id="cbDevolucao">
                                  <label class="form-check-label" for="cbDevolucao">Devolução</label>
                                </div>
                                <div class="form-group form-check col-12 checkNatureza" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="R" class="form-check-input" id="cbRemessa">
                                  <label class="form-check-label" for="cbRemessa">Remessa</label>
                                </div>
                                <div class="form-group form-check col-12 checkNatureza" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="O" class="form-check-input" id="cbRetorno">
                                  <label class="form-check-label" for="cbRetorno">Retorno</label>
                                </div>
                                <div class="form-group form-check col-12 checkNatureza" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="C" class="form-check-input" id="cbConsignacao">
                                  <label class="form-check-label" for="cbConsignacao">Consignação</label>
                                </div>
                                <div class="form-group form-check col-12 checkNatureza" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="A" class="form-check-input" id="cbAntecipacao">
                                  <label class="form-check-label" for="cbAntecipacao">Antecipação</label>
                                </div>
                              </div>
                              <div>
                                <div class="form-group form-check col-12 checkNatureza" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="S" class="form-check-input" id="cbServicos">
                                  <label class="form-check-label" for="cbServicos">Serviços</label>
                                </div>
                                <div class="form-group form-check col-12 checkNatureza" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="E" class="form-check-input" id="cbEnergiaTelefone">
                                  <label class="form-check-label" for="cbEnergiaTelefone">Energia/Telefone</label>
                                </div>
                                <div class="form-group form-check col-12 checkNatureza" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="B" class="form-check-input" id="cbBonificacao">
                                  <label class="form-check-label" for="cbBonificacao">Bonificação</label>
                                </div>
                                <div class="form-group form-check col-12 checkNatureza" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="P" class="form-check-input" id="cbPatrimonio">
                                  <label class="form-check-label" for="cbPatrimonio">Patrimônio</label>
                                </div>
                                <div class="form-group form-check col-12 checkNatureza" style="margin-bottom:  0.65rem;">
                                  <input type="checkbox" value="I" class="form-check-input" id="cbEstornoImposto">
                                  <label class="form-check-label" for="cbEstornoImposto">Estorno/Imposto</label>
                                </div>
                              </div>
                            </div>
                          </fieldset>
                        </div>
                      </div>
                    </div>
                    <div class="row">
                      <div class="col-lg-4 col-sm-12 col-12">
                        <div class="form" id="tipoFiltro">
                          <fieldset class="form border-Field">
                            <legend class="textoBorda mb-0 pb-0">Filtro</legend>
                            <div class="form-row ml-auto pl-3">
                              <div class="form-group form-check col-12">
                                <input type="radio" name="filtro" value="0" checked="true" class="form-check-input" id="cbTodosFiltros">
                                <label class="form-check-label" for="cbTodosFiltros">Todos</label>
                              </div>
                              <div class="form-group form-check col-12">
                                <input type="radio" name="filtro" value="1" class="form-check-input " id="cbProduto">
                                <label class="form-check-label" for="cbProduto">Produto</label>
                              </div>
                              <div class="form-group form-check col-12">
                                <input type="radio" name="filtro" value="2" class="form-check-input" id="cbMaterial">
                                <label class="form-check-label" for="cbMaterial">Material</label>
                              </div>
                              <div class="form-group form-check col-12">
                                <input type="radio" name="filtro" value="3" class="form-check-input" id="cbServico">
                                <label class="form-check-label" for="cbServico">Serviço</label>
                              </div>
                            </div>
                          </fieldset>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12">
                        <div class="form" id="tipoCategoria">
                          <fieldset class="form border-Field">
                            <legend class="textoBorda mb-0 pb-0">Categoria</legend>
                            <div class="form-row ml-auto pl-3">
                              <div class="form-group form-check col-12">
                                <input type="checkbox" value="1" class="form-check-input" id="cbCliente">
                                <label class="form-check-label" for="cbCliente">Cliente</label>
                              </div>
                              <div class="form-group form-check col-12">
                                <input type="checkbox" value="2" class="form-check-input " id="cbFornecedor">
                                <label class="form-check-label" for="cbFornecedor">Fornecedor</label>
                              </div>
                              <div class="form-group form-check col-12">
                                <input type="checkbox" value="3" class="form-check-input" id="cbTerceiros">
                                <label class="form-check-label" for="cbTerceiros">Terceiros</label>
                              </div>
                              <div class="form-group form-check col-12">
                                <select class="input-default focus custom-select" style="width: 90%; height: 90%;" id="selectTipoEntidade">
                                  <option value="0">Considerar</option>
                                  <option value="1">Desconsiderar</option>
                                </select>
                              </div>
                            </div>
                          </fieldset>
                        </div>
                      </div>
                      <div class="col-lg-4 col-sm-12 col-12" style="margin-top: 1%">
                        <label>
                          <input type="checkbox" id="cbMostraOuNaoNFEDevolucao">
                          <span class="checkmark">Não mostrar NFe de Devolução.</span></label>
                        <label>
                          <input type="checkbox" id="cbConsideraFatorConversao">
                          <span class="checkmark">Considerar Fator Conversão</span></label>
                        <!-- <label for="selectOrdemRel">Ordem Relatorio:</label>
                        <div class="relative">
                          <select id="selectOrdemRel" class="input-default focus custom-select">
                          </select>
                        </div> -->
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="modal-footer justify-content-start">
            <div class="row col-lg-12 col-12 pl-3">
              <div class="col-lg-4 col-sm-6 col-md-6">
                <label for="selectOrdemRel">Opção de Relatório:</label>
                <div class="relative">
                  <select id="selectOrdemRel" class="input-default focus custom-select">
                  </select>
                </div>
              </div>
              <div class="col-6 col-lg-8 d-flex justify-content-end align-items-end pr-0">
                <div class="d-flex">
                  <button class="btn btn-primary btn-sisp mr-2" id="btnLimpaFiltros" style="background-color: #B22222; border-color: #B22222">
                    <span class="fas fa-trash"></span> Limpar Filtros
                  </button>
                  <button id="btnConsultar" class="btn btn-primary btn-sisp" type="button">
                    <span class="fas fa-search"></span> Consultar
                  </button>
                </div>
              </div>
            </div>
          </div>
          <!-- <div class="modal-footer">
            <div class="row">
              <button class="btn btn-primary btn-sisp" id="btnLimpaFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>   
              <button id="btnConsultar" class='btn btn-primary btn-sisp' type='button'><span class="fas fa-search"></span> Consultar </button>
            </div>
          </div> -->
        </div>
      </div>
    </div>

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark">
      <!-- Control sidebar content goes here -->
    </aside><!-- /.control-sidebar -->
    <?php include_once('../../footer.php'); ?>
  </main><!-- /.wrapper -->

  <script src="plugins/jquery/jquery.min.js?versao=3.237.17.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.237.17.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.237.17.1"></script>
  <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.237.17.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.237.17.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.237.17.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.237.17.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.237.17.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.237.17.1"></script>
  <script src="dist/js/valida_cpf_cnpj.js?versao=3.237.17.1"></script>
  <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.237.17.1"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.237.17.1"></script>
  <script src="dist/js/sisplan.js?versao=3.237.17.1"></script>
  <script src="utils/funcoes.js?versao=3.237.17.1"></script>
  <script src="utils/cookies.js?versao=3.237.17.1"></script>
  <script src="dist/js/driver.min.js?versao=3.237.17.1"></script>
  <script src="config.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="plugins/jszip/jszip.min.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="plugins/pdfmake/pdfmake.min.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="plugins/pdfmake/vfs_fonts.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/dataTables.buttons.min.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="plugins/datatables-buttons/js/buttons.html5.min.js?versao=3.237.17.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.237.17.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('RELPECASFATURADAS');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/relpecasfaturadas/relpecasfaturadas.js?versao=3.231.11.1`;
      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      // nomeTela


      await insereJavaScriptPagina(sArquivo);

      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>

</body>

</html>