$(document).ready(async function () {

    let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

    // aqui so valida se nao existe tem que criar para nao dar erro
    if (colunas == null || colunas.relPecasFaturadas == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPecasFaturadas: ['MATERIAL', 'DESC_MATERIAL'] }));
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
    }

    // confirma as colunas
    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relPecasFaturadas: novasColunas }))

            $('#tabelaPecasFaturadas').DataTable().columns().visible(true);
            // $('#tabelaPrecosProduto').DataTable().columns(novasColunas).visible(false);

            $('#tabelaPecasFaturadas').DataTable().columns().every(
                function () {
                    if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    })

    $('#btnFiltrosRel').on('click', async function () {
        $('#modal-filtros').modal('show');
        limpaFiltros();

        const parametrosVenda = await BuscaParametrosVenda();

        if (parametrosVenda[17] == '1') {
            $('#radioProduto').prop('checked', false);
            $('#radioMaterial').prop('checked', true);
            $('#lblInputCodigo').html('Material:');
            $('#btnCodigo').pesquisa_serverside(['#txtCodigo'], ["CODIGO"], ["DESCRICAO"], `{"tabela":"MATERIAL", "camposSelect":["CODIGO", "DESCRICAO"], "where": ["1=1"]}`, 'Pesquisa de Material');
            $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
            $('#txtCodigo').listaFiltros();
        } else {
            $('#radioProduto').prop('checked', true);
            $('#radioMaterial').prop('checked', false);
            $('#lblInputCodigo').html('Produto:');
            $('#txtCodigo').autocompleta(1, 'JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
            $('#btnConsultaProduto').pesquisa_serverside(['#txtCodigo'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Produto');
            $('#txtCodigo').listaFiltros();
        };

        criaPesquisaAutoCompletaELimpaCampo();
    });

    $('#btnLimpaFiltros').on('click', async function () {
        limpaFiltros();
    });

    $('#btnConsultar').on('click', async function () {
        await fazConsulta();
        $('#modal-filtros').modal('hide');
    });

    $('#radioProduto').on('click', function () {
        $('#lblInputCodigo').html('Produto:');
        $('#txtCodigo').autocompleta(1, 'JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#btnConsultaProduto').pesquisa_serverside(['#txtCodigo'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Produto');
        $('#txtCodigo').prop('placeholder', 'Produto');
        $('#txtCodigo').listaFiltros();
    });

    $('#radioMaterial').on('click', function () {
        $('#lblInputCodigo').html('Material:');
        $('#btnCodigo').pesquisa_serverside(['#txtCodigo'], ["CODIGO"], ["DESCRICAO"], `{"tabela":"MATERIAL", "camposSelect":["CODIGO", "DESCRICAO"], "where": ["1=1"]}`, 'Pesquisa de Material');
        $('#txtCodigo').autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
        $('#txtCodigo').prop('placeholder', 'Material');
        $('#txtCodigo').listaFiltros();
    });

    $('#btnImprimirRel').on('click', async function () {
        try {
            $.LoadingOverlay("show");
            try {
                const filtros = await retornaFiltros();
                const url = `/sisplan/impressao/v1/imprimirrelpecasfat?${filtros}&COD_USUARIO=${getCookie('cod_usuario')}`;
                const bImprimeAutomatico = await verificaImprimirAutomatico('relpecasfaturadas');
                const arquivo = await GeraRelatorio(`${url}`, "GET", 100000, false, 'relpecasfaturadas');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
                    }
                    await limparRelatorios();
                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });


    async function buscaPisECofins() {
        const empresaLogada = getCookie('emp_id');
        const PesquisaParam = {
            tabela: 'EMPRESA',
            camposSelect: ['EMP_COFINS',
                'EMP_PIS'],
            where: [`EMP_ID = ${empresaLogada}`]
        };
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaParam));
        $('#txtPis').val(jsonStr[0].EMP_PIS);
        $('#txtCofins').val(jsonStr[0].EMP_COFINS);
    };

    await buscaPisECofins();

    async function adicionaOrdem() {
        const dadosSelect = {
            tabela: `${"ORDEM_TELA"}`,
            camposSelect: [`${"NOME_ORD_TELA"}`],
            where: [`${"NOME_TELA"} = '${"RelPecasFaturadas"}'`],
        };

        const retornoSelect = await retornaJsonPesquisaPadrao(
            JSON.stringify(dadosSelect)
        );
        if (!retornoSelect) {
            return;
        }

        let index = 0;
        retornoSelect.forEach(function (item) {
            $("#selectOrdemRel").append(
                `<option value= ${index} >${item.NOME_ORD_TELA}</option>`
            );
            index++;
        });
    };

    await adicionaOrdem();


    async function fazConsulta() {

        if ($.fn.DataTable.isDataTable('#tabelaPecasFaturadas')) {
            $('#tabelaPecasFaturadas').DataTable().destroy();
            $('#tabelaPecasFaturadas').empty();
        };

        try {
            $.LoadingOverlay('show');

            const url = `/sisplan/impressao/v1/consultarelpecasafat?`;
            const filtros = await retornaFiltros();
            const response = await requisicao('GET', url, `${filtros}&COD_USUARIO=${getCookie('cod_usuario')}`, '', 360000);

            if (!response) {
                return;
            };

            const jsonStr = await response.json();

            if (response.status != 200) {
                msgAlerta(jsonStr.mensagem);
                return;
            };

            const tipoProd = $('#radioMaterial').is(':checked') ? 'M' : 'P';

            const dataSetCols = [];

            if (tipoProd == 'M') {

                dataSetCols.push({
                    "title": "Fatura",
                    "data": "FATURA"
                });

                dataSetCols.push({
                    "title": "Tipo Fat",
                    "data": "TIPFAT"
                });

                dataSetCols.push({
                    "title": "Data Emissão",
                    "data": "DT_EMISSAO"
                });

                dataSetCols.push({
                    "title": "Data Fatura",
                    "data": "DT_FATURA"
                });

                dataSetCols.push({
                    "title": "Material",
                    "data": "MATERIAL"
                });

                dataSetCols.push({
                    "title": "Desc Material",
                    "data": "DESC_MATERIAL"
                });

                dataSetCols.push({
                    "title": "Cor",
                    "data": "COR"
                });

                dataSetCols.push({
                    "title": "Desc Cor",
                    "data": "DESCCOR"
                });

                dataSetCols.push({
                    "title": "Tam",
                    "data": "TAM"
                });

                dataSetCols.push({
                    "title": "Preço",
                    "data": "PRECO"
                });

                dataSetCols.push({
                    "title": "Valor",
                    "data": "VALOR"
                });

                dataSetCols.push({
                    "title": "Despesas",
                    "data": "DESPESAS"
                });

                dataSetCols.push({
                    "title": "Valor Líq",
                    "data": "VALOR_LIQ"
                });

                dataSetCols.push({
                    "title": "Valor Desc",
                    "data": "VALOR_DESC"
                });

                dataSetCols.push({
                    "title": "Valor ICMS",
                    "data": "VALOR_ICMS"
                });

                dataSetCols.push({
                    "title": "Qtde",
                    "data": "QTDE"
                });

                dataSetCols.push({
                    "title": "Peso L",
                    "data": "PESOL"
                });

                dataSetCols.push({
                    "title": "Peso B",
                    "data": "PESOB"
                });

                dataSetCols.push({
                    "title": "Cliente",
                    "data": "CODCLI"
                });

                dataSetCols.push({
                    "title": "Nome CLiente",
                    "data": "NOME"
                });

                dataSetCols.push({
                    "title": "Fantasia",
                    "data": "FANTASIA"
                });

                dataSetCols.push({
                    "title": "Unidade",
                    "data": "UNIDADE"
                });

                dataSetCols.push({
                    "title": "Tipo",
                    "data": "TIPO"
                });
            } else {
                dataSetCols.push({
                    "title": "Fatura",
                    "data": "FATURA"
                });

                dataSetCols.push({
                    "title": "Tipo Fat",
                    "data": "TIPFAT"
                });

                dataSetCols.push({
                    "title": "Data Emissão",
                    "data": "DT_EMISSAO"
                });

                dataSetCols.push({
                    "title": "Data Fatura",
                    "data": "DT_FATURA"
                });

                dataSetCols.push({
                    "title": "Produto",
                    "data": "CODIGO"
                });

                dataSetCols.push({
                    "title": "Desc Produto",
                    "data": "DESCRICAO"
                });

                dataSetCols.push({
                    "title": "Cor",
                    "data": "COR"
                });

                dataSetCols.push({
                    "title": "Desc Cor",
                    "data": "DESCCOR"
                });

                dataSetCols.push({
                    "title": "Tam",
                    "data": "TAM"
                });

                dataSetCols.push({
                    "title": "Preço",
                    "data": "PRECO"
                });

                dataSetCols.push({
                    "title": "Valor",
                    "data": "VALOR"
                });

                dataSetCols.push({
                    "title": "Despesas",
                    "data": "DESPESAS"
                });

                dataSetCols.push({
                    "title": "Valor Líq",
                    "data": "VALOR_LIQ"
                });

                dataSetCols.push({
                    "title": "Valor Desc",
                    "data": "VALOR_DESC"
                });

                dataSetCols.push({
                    "title": "Valor ICMS",
                    "data": "VALOR_ICMS"
                });

                dataSetCols.push({
                    "title": "Qtde",
                    "data": "QTDE"
                });

                dataSetCols.push({
                    "title": "Peso L",
                    "data": "PESOL"
                });

                dataSetCols.push({
                    "title": "Peso B",
                    "data": "PESOB"
                });

                dataSetCols.push({
                    "title": "Cliente",
                    "data": "CODCLI"
                });

                dataSetCols.push({
                    "title": "Nome CLiente",
                    "data": "NOME"
                });

                dataSetCols.push({
                    "title": "Fantasia",
                    "data": "FANTASIA"
                });

                dataSetCols.push({
                    "title": "Unidade",
                    "data": "UNIDADE"
                });

                dataSetCols.push({
                    "title": "Tipo",
                    "data": "TIPO"
                });
            };

            dataSetCols.push({
                "title": "Val Subst",
                "data": "VAL_SUBST"
            });

            dataSetCols.push({
                "title": "Impresso",
                "data": "IMPRESSO"
            });

            dataSetCols.push({
                "title": "Pedido Cli",
                "data": "PED_CLI"
            });

            dataSetCols.push({
                "title": "Grupo",
                "data": "GRUPO"
            });

            dataSetCols.push({
                "title": "Descrição Grupo Cli",
                "data": "DESCRICAO_GRUPO_CLI"
            });

            dataSetCols.push({
                "title": "Composição",
                "data": "COMPOSICAO"
            });

            dataSetCols.push({
                "title": "Desc Composição",
                "data": "DESC_COMPOSI"
            });

            dataSetCols.push({
                "title": "Pedido",
                "data": "PEDIDO"
            });

            dataSetCols.push({
                "title": "Tipo Item",
                "data": "TIPO_IT"
            });

            dataSetCols.push({
                "title": "Cod QT PisCofins",
                "data": "COD_QT_PISCOFINS"
            });

            dataSetCols.push({
                "title": "Cotação",
                "data": "COTACAO"
            });

            dataSetCols.push({
                "title": "Cod Linha",
                "data": "CODLINHA"
            });

            dataSetCols.push({
                "title": "Desc Linha",
                "data": "DESCLINHA"
            });

            dataSetCols.push({
                "title": "Peso Líq",
                "data": "PESO_LIQ"
            });

            dataSetCols.push({
                "title": "Peso",
                "data": "PESO"
            });

            dataSetCols.push({
                "title": "Custo",
                "data": "CUSTO"
            });

            dataSetCols.push({
                "title": "Descrição 2",
                "data": "DESCRICAO2"
            });

            dataSetCols.push({
                "title": "Código 2",
                "data": "CODIGO2"
            });

            dataSetCols.push({
                "title": "Protótipo",
                "data": "PROTOTIPO"
            });

            dataSetCols.push({
                "title": "Preço Médio",
                "data": "PRECO_MED"
            });

            dataSetCols.push({
                "title": "Desc Pro",
                "data": "DESC_PRO"
            });

            dataSetCols.push({
                "title": "Cod Grupo",
                "data": "CODGRUPO"
            });

            dataSetCols.push({
                "title": "Desc Grupo",
                "data": "DESCGRUPO"
            });

            dataSetCols.push({
                "title": "Qtde Unit.",
                "data": "QTDE_UNI"
            });

            dataSetCols.push({
                "title": "Etiqueta",
                "data": "ETIQUETA"
            });

            dataSetCols.push({
                "title": "Desc Etiqueta",
                "data": "DESC_ETIQUETA"
            });

            dataSetCols.push({
                "title": "Val Frete",
                "data": "VAL_FRETE"
            });

            dataSetCols.push({
                "title": "Valor Item",
                "data": "VALOR_ITEN"
            });

            dataSetCols.push({
                "title": "Custo Nota",
                "data": "CUSTO_NOTA"
            });

            dataSetCols.push({
                "title": "Espécie",
                "data": "ESPECIE"
            });

            dataSetCols.push({
                "title": "Perc ICMS",
                "data": "PERC_ICMS"
            });

            dataSetCols.push({
                "title": "Perc IPI",
                "data": "PERC_IPI"
            });

            dataSetCols.push({
                "title": "Valor IPI",
                "data": "VALOR_IPI"
            });

            dataSetCols.push({
                "title": "Pgto",
                "data": "PGTO"
            });

            dataSetCols.push({
                "title": "Taxa",
                "data": "TAXA"
            });

            dataSetCols.push({
                "title": "Margem",
                "data": "MARGEM"
            });

            dataSetCols.push({
                "title": "Perc Comissão",
                "data": "PERC_COMISSAO"
            });

            dataSetCols.push({
                "title": "Índice",
                "data": "INDICE"
            });

            dataSetCols.push({
                "title": "Natureza",
                "data": "NATUREZA"
            });

            dataSetCols.push({
                "title": "Desc Natureza",
                "data": "DESC_NAT"
            });

            dataSetCols.push({
                "title": "Val Produtos",
                "data": "VAL_PRODUTOS"
            });

            dataSetCols.push({
                "title": "Impostos Ped",
                "data": "IMPOSTOS_PED"
            });

            dataSetCols.push({
                "title": "Pedido Frete",
                "data": "PEDIDO_FRETE"
            });

            dataSetCols.push({
                "title": "Ped. Valor Desc",
                "data": "PEDIDO_VLR_DESC"
            });

            dataSetCols.push({
                "title": "Pedido Numero",
                "data": "PEDIDO_NUMERO"
            });

            dataSetCols.push({
                "title": "Ped. Perc Desc",
                "data": "PEDIDO_PER_DESC"
            });

            dataSetCols.push({
                "title": "E-mail",
                "data": "EMAIL"
            });

            dataSetCols.push({
                "title": "Endereço",
                "data": "ENDERECO"
            });

            dataSetCols.push({
                "title": "Cli End Num.",
                "data": "CLI_END_NUM"
            });

            dataSetCols.push({
                "title": "Complemento",
                "data": "COMPLEMENTO"
            });

            dataSetCols.push({
                "title": "Bairro",
                "data": "BAIRRO"
            });

            dataSetCols.push({
                "title": "Cliente CEP",
                "data": "CLIENTE_CEP"
            });

            dataSetCols.push({
                "title": "Cidade Cod UF",
                "data": "CIDADE_COD_UF"
            });

            dataSetCols.push({
                "title": "Cliente CNPJ",
                "data": "CLI_CNPJ"
            });

            dataSetCols.push({
                "title": "Cliente DDDFone",
                "data": "CLI_DDD_FONE"
            });

            dataSetCols.push({
                "title": "Cliente Telefone",
                "data": "CLI_TELEFONE"
            });

            dataSetCols.push({
                "title": "Cli Fone Compl",
                "data": "CLI_FONE_COMPL"
            });

            dataSetCols.push({
                "title": "Transportadora",
                "data": "TRANSPORT"
            });

            dataSetCols.push({
                "title": "Nome Transp.",
                "data": "NOMETRAN"
            });

            dataSetCols.push({
                "title": "Cif",
                "data": "CIF"
            });

            dataSetCols.push({
                "title": "Volumes",
                "data": "VOLUMES"
            });

            dataSetCols.push({
                "title": "CodRep",
                "data": "CODREP"
            });

            dataSetCols.push({
                "title": "TP Base",
                "data": "TP_BASE"
            });

            dataSetCols.push({
                "title": "Redesp",
                "data": "REDESP"
            });

            dataSetCols.push({
                "title": "Nome Redesp",
                "data": "NOMEREDESP"
            });

            dataSetCols.push({
                "title": "Histórico",
                "data": "HISTORICO"
            });

            dataSetCols.push({
                "title": "Desc Hist",
                "data": "DESC_HIST"
            });

            dataSetCols.push({
                "title": "Total Ped",
                "data": "TOTAL_PED"
            });

            dataSetCols.push({
                "title": "Desc Val NF",
                "data": "DESC_VALNF"
            });

            dataSetCols.push({
                "title": "Valor Ped",
                "data": "VALOR_PED"
            });

            dataSetCols.push({
                "title": "Desc Dupl",
                "data": "DESC_DUPL"
            });

            dataSetCols.push({
                "title": "Data Ini",
                "data": "DATA_INI"
            });

            dataSetCols.push({
                "title": "Data Fim",
                "data": "DATA_FIM"
            });

            dataSetCols.push({
                "title": "Grupo Cor",
                "data": "GRUPO_COR"
            });

            dataSetCols.push({
                "title": "Desc Grupo Cor",
                "data": "DESC_GRUPO_COR"
            });

            dataSetCols.push({
                "title": "Lote",
                "data": "LOTE"
            });

            dataSetCols.push({
                "title": "Cod NCM",
                "data": "COD_NCM"
            });

            dataSetCols.push({
                "title": "Nome NCM",
                "data": "NOME_NCM"
            });

            dataSetCols.push({
                "title": "Tab Fis Tipo",
                "data": "TABFIS_TIPO"
            });

            dataSetCols.push({
                "title": "Gera INSS",
                "data": "GERA_INSS"
            });

            dataSetCols.push({
                "title": "Faixa",
                "data": "FAIXA"
            });

            dataSetCols.push({
                "title": "Marca",
                "data": "MARCA"
            });

            dataSetCols.push({
                "title": "Desc Marca",
                "data": "DESC_MARCA"
            });

            dataSetCols.push({
                "title": "Linha",
                "data": "LINHA"
            });

            dataSetCols.push({
                "title": "Desc Linha",
                "data": "DESC_LINHA"
            });

            dataSetCols.push({
                "title": "Estilista",
                "data": "ESTILISTA"
            });

            dataSetCols.push({
                "title": "Desc Estilista",
                "data": "DESC_ESTILISTA"
            });

            dataSetCols.push({
                "title": "Coleção",
                "data": "COLECAO"
            });

            dataSetCols.push({
                "title": "Valor PIS",
                "data": "PIS"
            });

            dataSetCols.push({
                "title": "Valor COFINS",
                "data": "COFINS"
            });

            dataSetCols.push({
                "title": "Preço Orig",
                "data": "PRECO_ORIG",
            });

            dataSetCols.push({
                "title": "Desc Pedido",
                "data": "DESC_PEDIDO"
            });

            dataSetCols.push({
                "title": "EMP",
                "data": "EMP"
            });

            dataSetCols.push({
                "title": "Unidade Nota",
                "data": "UNIDADE_NOTA"
            });

            dataSetCols.push({
                "title": "Qtde Unit. Nota",
                "data": "QTDE_UNI_NOTA"
            });

            dataSetCols.push({
                "title": "Preço Custo",
                "data": "PRECO_CUSTO"
            });

            dataSetCols.push({
                "title": "Pantone",
                "data": "PANTONE"
            });

            dataSetCols.push({
                "title": "Posição",
                "data": "POSICAO"
            });

            dataSetCols.push({
                "title": "Valor ICMSST",
                "data": "VALOR_ICMSST"
            });

            dataSetCols.push({
                "title": "Desc Coleção",
                "data": "DESC_COLECAO"
            });

            dataSetCols.push({
                "title": "Coleção Ped",
                "data": "COL_PED"
            });

            dataSetCols.push({
                "title": "Desc Col Ped",
                "data": "DESC_COL_PED"
            });

            dataSetCols.push({
                "title": "Coleção Mat.",
                "data": "COLECAO_MAT"
            });

            dataSetCols.push({
                "title": "Desc Coleção Mat",
                "data": "DESC_COLECAO_MAT"
            });

            dataSetCols.push({
                "title": "Peso OB",
                "data": "PESO_OB"
            });

            dataSetCols.push({
                "title": "Valor Prod. Nota",
                "data": "VAL_PRODUTOS_NOTA"
            });

            dataSetCols.push({
                "title": "Valor Desc. Nota",
                "data": "VAL_DESCONTO_NOTA"
            });

            dataSetCols.push({
                "title": "Divisor",
                "data": "DIVISOR"
            });

            dataSetCols.push({
                "title": "Existe Receber",
                "data": "EXISTE_RECEBER"
            });

            dataSetCols.push({
                "title": "Mês",
                "data": "MES"
            });

            dataSetCols.push({
                "title": "Emp PIS",
                "data": "EMP_PIS"
            });

            dataSetCols.push({
                "title": "Emp COFINS",
                "data": "EMP_COFINS"
            });

            dataSetCols.push({
                "title": "SubGrupo",
                "data": "SUB_GRUPO"
            });

            dataSetCols.push({
                "title": "Desc SubGrupo",
                "data": "DESC_SUBGRUPO"
            });

            dataSetCols.push({
                "title": "Com 1",
                "data": "COM1"
            });

            dataSetCols.push({
                "title": "Com 2",
                "data": "COM2"
            });

            dataSetCols.push({
                "title": "Tipo Venda",
                "data": "TP_VENDA"
            });

            dataSetCols.push({
                "title": "Desc TP Venda",
                "data": "DESC_TP_VENDA"
            });

            dataSetCols.push({
                "title": "Motivo",
                "data": "MOTIVO"
            });

            dataSetCols.push({
                "title": "Desc Motivo",
                "data": "DESC_MOTIVO"
            });

            dataSetCols.push({
                "title": "Val ICMS Deson",
                "data": "VAL_ICMS_DESON"
            });

            dataSetCols.push({
                "title": "Depósito",
                "data": "DEPOSITO"
            });


            dataSetCols.push({
                "title": "Desc Depósito",
                "data": "DESC_DEPOSITO"
            });

            dataSetCols.push({
                "title": "CodFis",
                "data": "CODFIS"
            });

            dataSetCols.push({
                "title": "CodMoeda",
                "data": "COD_MOEDA"
            });

            dataSetCols.push({
                "title": "Data Saída",
                "data": "DT_SAIDA"
            });

            dataSetCols.push({
                "title": "Nome Cidade",
                "data": "CIDADE_NOME"
            });

            if (tipoProd == 'P') {
                dataSetCols.push({
                    "title": "Material",
                    "data": "MATERIAL"
                });

                dataSetCols.push({
                    "title": "Desc Material",
                    "data": "DESC_MATERIAL"
                });
            } else {
                dataSetCols.push({
                    "title": "Produto",
                    "data": "CODIGO"
                });

                dataSetCols.push({
                    "title": "Desc Produto",
                    "data": "DESCRICAO"
                });
            }

            $('#tabelaPecasFaturadas').DataTable({
                bPaginate: true,
                destroy: true,
                colReorder: true,
                language: {
                    sEmptyTable: "Nenhum registro encontrado",
                    sInfo: "_TOTAL_ registros",
                    sInfoEmpty: " 0 registros",
                    sInfoFiltered: "(Filtrados de _MAX_ registros)",
                    sInfoPostFix: "",
                    sInfoThousands: ".",
                    sLengthMenu: "_MENU_ resultados",
                    sLoadingRecords: "Carregando...",
                    sProcessing: "Processando...",
                    sZeroRecords: "Nenhum registro encontrado",
                    sSearch: "Pesquisar",
                    oPaginate: {
                        sNext: "Próximo",
                        sPrevious: "Anterior",
                        sFirst: "Primeiro",
                        sLast: "Último",
                    },
                    oAria: {
                        sSortAscending: ": Ordenar colunas de forma ascendente",
                        sSortDescending: ": Ordenar colunas de forma descendente",
                    },
                },
                autoWidth: true,
                columns: dataSetCols,
                data: jsonStr,
                columnDefs: [{
                    type: 'date-br',
                    targets: [2, 3, 94, 95],
                    render(data) {
                        if (data) {
                            return new Intl.DateTimeFormat('pt-BR').format(new Date(`${data.split(' ')[0]} 23:59:59`));
                        } else {
                            return '';
                        }

                    },
                },
                {
                    targets: [9, 10, 11, 12, 13, 14, 38, 42, 49],
                    render(data) {
                        return 'R$ ' + parseFloat(data).toFixed(2).replace('.', ',')
                    }
                }]
            });

            const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

            $('#tabelaPecasFaturadas_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
            $('#tabelaPecasFaturadas_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

            $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
            $('#buttonExcel').prop('title', 'Exportar')

            $('#buttonColVis').on('click', async function () {
                $.LoadingOverlay('show');
                $('#modal-ColunasVisiveis').modal('show');
                $.LoadingOverlay('hide');
            });

            $('#buttonExcel').on('click', async function () {
                const url = `/sisplan/impressao/v1/consultarelpecasafat?`;
                const filtros = await retornaFiltros();
                await exportaCSV(url, filtros, false, null, 'Relatório de Peças Faturadas', '#tabelaPecasFaturadas');
            })

            $('#tabelaPecasFaturadas').DataTable().columns().every(
                function () {
                    if ((colunasInvisiveis.relPecasFaturadas).indexOf(this.dataSrc()) != -1) {
                        this.visible(false);
                    }
                })

        } catch (error) {
            console.error(error)
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaPecasFaturadas').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            })
        });

        adicionaColunas(cols, colunasInvisiveis.relPecasFaturadas ?? ['MATERIAL', 'DESC_MATERIAL'])
    })

    $('#btnCarregaEmpresas').on('click', function () {
        carregaEmpresasDisponiveis();
    });

    async function retornaFiltros() {

        const dataEmissaoNFIni = $('#txtDataEmissaoNFI').val();
        const dataEmissaoNFFim = $('#txtDataEmissaoNFF').val();
        const tipoItemFiltrado = $('#radioMaterial').is(':checked') ? 'M' : 'P';
        const produtoFiltrado = await formataListas($('#listaCodigo').val());
        const clienteFiltrado = await formataListas($('#listaCliente').val());
        const grupoMatFiltrado = await formataListas($('#listaGrupoMat').val());
        const subGrupoMatFiltrado = await formataListas($('#listaSubgrupoMat').val());
        const represenFiltrado = await formataListas($('#listaRepresentante').val());
        const grupoCliFiltrado = await formataListas($('#listaGrupoCli').val());
        const grupoProdFiltrado = await formataListas($('#listaGrupo').val());
        const composicaoFiltrado = await formataListas($('#listaComposicao').val());
        const ncmFiltrado = await formataListas($('#listaNCM').val());
        const coordFiltrado = await formataListas($('#listaCoord').val());
        const depositoFiltrado = await formataListas($('#listaDeposito').val());
        const moedaFiltrado = await formataListas($('#listaMoeda').val());
        const linhaMatFiltrado = await formataListas($('#listaLinhaMat').val());
        const linhaFiltrado = await formataListas($('#listaLinha').val());
        const nfFiltrado = await formataListas($('#listaNF').val());
        const colecaoProdFiltrado = await formataListas($('#listaColecaoProd').val());
        const colecaoPedFiltrado = await formataListas($('#listaColecaoPed').val());
        const tipoVendaFiltrado = await formataListas($('#listaTipoVenda').val());
        const estilistaFiltrado = await formataListas($('#listaEstilista').val());
        const marcaFiltrado = await formataListas($('#listaMarca').val());
        const pedidoFiltrado = await formataListas($('#listaPedido').val());
        const estadoFiltrado = await formataListas($('#listaEstado').val());
        const naturezaFiltrado = await formataListas($('#listaNatureza').val());
        const consideraNatureza = $('#cbConsideraNatureza').is(':checked');
        const prazoEntFiltrado = await formataListas($('#listaPrazoEnt').val());
        const loteFiltrado = $('#txtLote').val();
        const motivoFiltrado = await formataListas($('#listaMotivo').val());
        const categoriaFiltrado = await formataListas($('#listaCategoria').val());
        const etiquetaFiltrado = await formataListas($('#listaEtiqueta').val());
        const percCofins = $('#txtCofins').val();
        const percPis = $('#txtPis').val();
        const consideraCategoria = $('#selectTipoEntidade').val();
        const naoMostraNfeDev = $('#cbMostraOuNaoNFEDevolucao').is(':checked');
        const consideraFatorConv = $('#cbConsideraFatorConversao').is(':checked');
        const empresasFiltradas = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
            : [getCookie('emp_id')];

        const empresasFiltradasFormatada = await formataListas(empresasFiltradas.toString());

        ///Notas
        let tipoNotas;

        if ($('#cbTodas').is(':checked')) {
            tipoNotas = $('#cbTodas').val();
        } else if ($('#cbNormais').is(':checked')) {
            tipoNotas = $('#cbNormais').val();
        } else if ($('#cbNormais-Den-Canc').is(':checked')) {
            tipoNotas = $('#cbNormais-Den-Canc').val();
        } else if ($('#cbNormais-Den').is(':checked')) {
            tipoNotas = $('#cbNormais-Den').val();
        } else if ($('#cbNormais-Canc').is(':checked')) {
            tipoNotas = $('#cbNormais-Canc').val();
        } else {
            tipoNotas = '';
        }

        ///Duplicatas
        let tipoDuplicatas;

        if ($('#cbTodasDups').is(':checked')) {
            tipoDuplicatas = $('#cbTodasDups').val();
        } else if ($('#cbComDups').is(':checked')) {
            tipoDuplicatas = $('#cbComDups').val();
        } else if ($('#cbSemDups').is(':checked')) {
            tipoDuplicatas = $('#cbSemDups').val();
        } else {
            tipoDuplicatas = '';
        }

        //Filtro
        let tipoFiltro;

        if ($('#cbTodosFiltros').is(':checked')) {
            tipoFiltro = $('#cbTodosFiltros').val();
        } else if ($('#cbProduto').is(':checked')) {
            tipoFiltro = $('#cbProduto').val();
        } else if ($('#cbMaterial').is(':checked')) {
            tipoFiltro = $('#cbMaterial').val();
        } else if ($('#cbServico').is(':checked')) {
            tipoFiltro = $('#cbServico').val();
        } else {
            tipoFiltro = '';
        }

        //Inss
        let tipoInss;

        if ($('#cbTodosInss').is(':checked')) {
            tipoInss = $('#cbTodosInss').val();
        } else if ($('#cbComInss').is(':checked')) {
            tipoInss = $('#cbComInss').val();
        } else if ($('#cbSemInss').is(':checked')) {
            tipoInss = $('#cbSemInss').val();
        } else {
            tipoInss = '';
        }

        ///tipos de Natureza
        let tiposNatureza = [];

        if ($('#cbVendaCompra').is(':checked')) {
            tiposNatureza.push($('#cbVendaCompra').val());
        };
        if ($('#cbDevolucao').is(':checked')) {
            tiposNatureza.push($('#cbDevolucao').val());
        };
        if ($('#cbRemessa').is(':checked')) {
            tiposNatureza.push($('#cbRemessa').val());
        };
        if ($('#cbRetorno').is(':checked')) {
            tiposNatureza.push($('#cbRetorno').val());
        };
        if ($('#cbConsignacao').is(':checked')) {
            tiposNatureza.push($('#cbConsignacao').val());
        };
        if ($('#cbAntecipacao').is(':checked')) {
            tiposNatureza.push($('#cbAntecipacao').val());
        };
        if ($('#cbServicos').is(':checked')) {
            tiposNatureza.push($('#cbServicos').val());
        };
        if ($('#cbEnergiaTelefone').is(':checked')) {
            tiposNatureza.push($('#cbEnergiaTelefone').val());
        };
        if ($('#cbBonificacao').is(':checked')) {
            tiposNatureza.push($('#cbBonificacao').val());
        };
        if ($('#cbPatrimonio').is(':checked')) {
            tiposNatureza.push($('#cbPatrimonio').val());
        };
        if ($('#cbEstornoImposto').is(':checked')) {
            tiposNatureza.push($('#cbEstornoImposto').val());
        };

        tiposNatureza = await formataListas(tiposNatureza.toString());



        //tipos de Categoria de Entidade
        let clienteEstaCheck = false;
        let fornecedorEstaCheck = false;
        let terceirosEstaCheck = false;

        if ($('#cbCliente').is(':checked')) {
            clienteEstaCheck = true;
        };

        if ($('#cbFornecedor').is(':checked')) {
            fornecedorEstaCheck = true;
        };

        if ($('#cbTerceiros').is(':checked')) {
            terceirosEstaCheck = true;
        };


        const filtros = `DTEMISSAONFINI=${dataEmissaoNFIni}&` +
            `DTEMISSAONFFIM=${dataEmissaoNFFim}&` +
            `ITEMFILTRADO=${produtoFiltrado}&` +
            `TIPOITEMFILTRADO=${tipoItemFiltrado}&` +
            `CLIENTEFILTRADO=${clienteFiltrado}&` +
            `GRUPOMATFILTRADO=${grupoMatFiltrado}&` +
            `SUBGRUPOMATFILTRADO=${subGrupoMatFiltrado}&` +
            `REPRESENTANTEFILTRADO=${represenFiltrado}&` +
            `GRUPOCLIFILTRADO=${grupoCliFiltrado}&` +
            `GRUPOPRODFILTRADO=${grupoProdFiltrado}&` +
            `COMPOSICAOFILTRADO=${composicaoFiltrado}&` +
            `NCMFILTRADO=${ncmFiltrado}&` +
            `COORDFILTRADO=${coordFiltrado}&` +
            `DEPOSITOFILTRADO=${depositoFiltrado}&` +
            `MOEDAFILTRADO=${moedaFiltrado}&` +
            `LINHAMATFILTRADO=${linhaMatFiltrado}&` +
            `LINHAFILTRADO=${linhaFiltrado}&` +
            `NFFILTRADO=${nfFiltrado}&` +
            `COLECAOPRODFILTRADO=${colecaoProdFiltrado}&` +
            `COLECAOPEDFILTRADO=${colecaoPedFiltrado}&` +
            `TIPOVENDAFILTRADO=${tipoVendaFiltrado}&` +
            `ESTILISTAFILTRADO=${estilistaFiltrado}&` +
            `MARCAFILTRADO=${marcaFiltrado}&` +
            `PEDIDOFILTRADO=${pedidoFiltrado}&` +
            `ESTADOFILTRADO=${estadoFiltrado}&` +
            `NATUREZAFILTRADO=${naturezaFiltrado}&` +
            `CONSIDERANATUREZA=${consideraNatureza}&` +
            `PRAZOENTFILTRADO=${prazoEntFiltrado}&` +
            `LOTEFILTRADO=${loteFiltrado}&` +
            `MOTIVOFILTRADO=${motivoFiltrado}&` +
            `CATEGORIAFILTRADO=${categoriaFiltrado}&` +
            `ETIQUETAFILTRADO=${etiquetaFiltrado}&` +
            `PERCCOFINS=${percCofins}&` +
            `PERCPIS=${percPis}&` +
            `CONSIDERACATEGORIA=${consideraCategoria}&` +
            `NAOMOSTRANFDEV=${naoMostraNfeDev}&` +
            `CONSIDERAFATORCONV=${consideraFatorConv}&` +
            `EMPRESASFILTRADAS=${empresasFiltradasFormatada}&` +
            `TIPONOTASFILTRADO=${tipoNotas}&` +
            `TIPODUPLICATASFILTRADO=${tipoDuplicatas}&` +
            `TIPOFILTROFILTRADO=${tipoFiltro}&` +
            `TIPOINSSFILTRADO=${tipoInss}&` +
            `NATUREZASFILTRADAS=${tiposNatureza.toString()}&` +
            `CLIENTEESTACHECK=${clienteEstaCheck}&` +
            `FORNECEDORESTACHECK=${fornecedorEstaCheck}&` +
            `TERCEIROSESTACHECK=${terceirosEstaCheck}&` +
            `UTILIZAPARTEDOLOTE=${$('#cbUtilizaPartedoLote').is(':checked')}&` +
            `NATDEVOLUCAO=${$('#cbDevolucao').is(':checked')}&` +
            `TODASEMPRESAS=${$('#cbTodasAsEmpresas').is(':checked')}&` +
            `ORDEM_ORDENACAO=${$('#selectOrdemRel').val()}`


        return filtros;

    };




    function criaPesquisaAutoCompletaELimpaCampo() {

        $('#btnConsultaProduto').pesquisa_serverside(['#txtCodigo'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Produto');
        $('#btnConsultaCliente').pesquisa_serverside(['#txtCliente'], ['CODCLI'], ['NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa de Cliente');
        $('#btnConsultaGrupoMat').pesquisa_serverside(['#txtGrupoMat'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"GRUPO_MA", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Grupo de Material');
        $('#btnConsultaSubgrupoMat').pesquisa_serverside(['#txtSubgrupoMat'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"SUBGRUPO_MA", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de SubGrupo de Material');
        $('#btnConsultaRepresen').pesquisa_serverside(['#txtRepresentante'], ['CODREP'], ['NOME'], '{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME"], "where": null}', 'Pesquisa de Representante');
        $('#btnConsultaGrupoCli').pesquisa_serverside(['#txtGrupoCli'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"GRUPO_CLI", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Grupo de Cliente');
        $('#btnConsultaGrupoProd').pesquisa_serverside(['#txtGrupo'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Grupo de Produto');
        $('#btnConsultaComposicao').pesquisa_serverside(['#txtComposicao'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"CADCOMPOSI", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa de Composição');
        $('#btnConsultaNCM').pesquisa_serverside(['#txtNCM'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"TABFIS", "camposSelect":[ "CODIGO", "DESCRICAO", "TIPO"], "where": null}', 'Pesquisa de NCM');
        $('#btnConsultaCoord').pesquisa_serverside(['#txtCoord'], ['CODCLI'], ['NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa de Coord.');
        $('#btnConsultaDeposito').pesquisa_serverside(['#txtDeposito'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"DEPOSITO", "camposSelect":[ "DESCRICAO", "CODIGO"], "where": null}', 'Pesquisa de Depósito');
        $('#btnConsultaMoeda').pesquisa_serverside(['#txtMoeda'], ['CODMOE'], ['DESCRICAO'], '{"tabela":"MOEDA", "camposSelect":[ "DESCRICAO", "CODMOE"], "where": null}', 'Pesquisa de Moeda');
        $('#btnConsultaLinhaMat').pesquisa_serverside(['#txtLinhaMat'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"TABLIN", "camposSelect":[ "DESCRICAO", "CODIGO"], "where": null}', 'Pesquisa de Linha');
        $('#btnConsultaLinha').pesquisa_serverside(['#txtLinha'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"TABLIN", "camposSelect":[ "DESCRICAO", "CODIGO"], "where": null}', 'Pesquisa de Linha');
        $('#btnConsultaNF').pesquisa_serverside(['#txtNF'], ['FATURA'], ['SERIE'], '{"tabela":"NOTA", "camposSelect":[ "FATURA", "SERIE", "DT_EMISSAO"], "where": null}', 'Pesquisa de Nota Fiscal');
        $('#btnConsultaColecaoProd').pesquisa_serverside(['#txtColecaoProd'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"COLECAO", "camposSelect":[ "DESCRICAO", "CODIGO"], "where": null}', 'Pesquisa de Coleção');
        $('#btnConsultaColecaoPed').pesquisa_serverside(['#txtColecaoPed'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"COLECAO", "camposSelect":[ "DESCRICAO", "CODIGO"], "where": null}', 'Pesquisa de Coleção');
        $('#btnConsultaTipoVenda').pesquisa_serverside(['#txtTipoVenda'], ['ID'], ['DESCRICAO'], '{"tabela":"VENDA_TIPO", "camposSelect":[ "DESCRICAO", "ID"], "where": null}', 'Pesquisa de Tipo de Venda');
        $('#btnConsultaEstilista').pesquisa_serverside(['#txtEstilista'], ['CODIGO'], ['NOME'], '{"tabela":"PESSOAL", "camposSelect":[ "CODIGO", "NOME"], "where": null}', 'Pesquisa de Estilista');
        $('#btnConsultaMarca').pesquisa_serverside(['#txtMarca'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"MARCA", "camposSelect":[ "DESCRICAO", "CODIGO"], "where": null}', 'Pesquisa de Marca');
        $('#btnConsultaPedido').pesquisa_serverside(['#txtPedido'], ['NUMERO'], ['CODCLI'], '{"tabela":"PEDIDO", "camposSelect":[ "NUMERO", "CODCLI"], "where": null}', 'Pesquisa de Pedido');
        $('#btnConsultaEstado').pesquisa_serverside(['#txtEstado'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"TABUF", "camposSelect":[ "DESCRICAO", "CODIGO"], "where": null}', 'Pesquisa de Estado');
        $('#btnConsultaNatureza').pesquisa_serverside(['#txtNatureza'], ['NATUREZA'], ['DESCRICAO'], '{"tabela":"NATUREZA", "camposSelect":[ "DESCRICAO", "NATUREZA"], "where": null}', 'Pesquisa de Natureza');
        $('#btnConsultaPrazoEnt').pesquisa_serverside(['#txtPrazoEnt'], ['PRAZO'], ['DESCRICAO'], '{"tabela":"TABPRZ", "camposSelect":[ "DESCRICAO", "PRAZO"], "where": null}', 'Pesquisa de Prazo de Entrega');
        $('#btnConsultaMotivo').pesquisa_serverside(['#txtMotivo'], ['CODMEN'], ['DESCRICAO'], '{"tabela":"MENSAGEM", "camposSelect":[ "DESCRICAO", "CODMEN"], "where": null}', 'Pesquisa de Motivo');
        $('#btnConsultaCategoria').pesquisa_serverside(['#txtCategoria'], ['ID'], ['DESCRICAO'], '{"tabela":"AUXILIAR", "camposSelect":[ "DESCRICAO", "ID"], "where": null}', 'Pesquisa de Categoria');
        $('#btnConsultaEtiqueta').pesquisa_serverside(['#txtEtiqueta'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"ETQ_PROD", "camposSelect":[ "DESCRICAO", "CODIGO"], "where": null}', 'Pesquisa de Etiqueta');

        $('#txtCodigo').autocompleta(1, 'JSON={ "tabela":"PRODUTO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtCliente').autocompleta(1, 'JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}');
        $('#txtGrupoMat').autocompleta(1, 'JSON={ "tabela":"GRUPO_MA", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtSubgrupoMat').autocompleta(1, 'JSON={ "tabela":"SUBGRUPO_MA", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtRepresentante').autocompleta(1, 'JSON={ "tabela":"REPRESEN", "camposSelect":[ "CODREP CHAVE", "NOME DESCRICAO"], "where": null}');
        $('#txtGrupoCli').autocompleta(1, 'JSON={ "tabela":"GRUPO_CLI", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtGrupo').autocompleta(1, 'JSON={ "tabela":"GRUPO_PA", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtComposicao').autocompleta(1, 'JSON={ "tabela":"CADCOMPOSI", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtNCM').autocompleta(1, 'JSON={ "tabela":"TABFIS", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtCoord').autocompleta(1, 'JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}');
        $('#txtDeposito').autocompleta(1, 'JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtMoeda').autocompleta(1, 'JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtLinhaMat').autocompleta(1, 'JSON={ "tabela":"TABLIN", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtLinha').autocompleta(1, 'JSON={ "tabela":"TABLIN", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtNF').autocompleta(1, 'JSON={ "tabela":"NOTA", "camposSelect":[ "FATURA CHAVE", "SERIE DESCRICAO"], "where": null}');
        $('#txtColecaoProd').autocompleta(1, 'JSON={ "tabela":"COLECAO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtColecaoPed').autocompleta(1, 'JSON={ "tabela":"COLECAO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtTipoVenda').autocompleta(1, 'JSON={ "tabela":"VENDA_TIPO", "camposSelect":[ "ID CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtEstilista').autocompleta(1, 'JSON={ "tabela":"PESSOAL", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO"], "where": null}');
        $('#txtMarca').autocompleta(1, 'JSON={ "tabela":"MARCA", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtPedido').autocompleta(1, 'JSON={ "tabela":"PEDIDO", "camposSelect":[ "NUMERO CHAVE", "CODCLI DESCRICAO"], "where": null}');
        $('#txtEstado').autocompleta(1, 'JSON={ "tabela":"TABUF", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtNatureza').autocompleta(1, 'JSON={ "tabela":"NATUREZA", "camposSelect":[ "NATUREZA CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtPrazoEnt').autocompleta(1, 'JSON={ "tabela":"TABPRZ", "camposSelect":[ "PRAZO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtMotivo').autocompleta(1, 'JSON={ "tabela":"MENSAGEM", "camposSelect":[ "CODMEN CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtCategoria').autocompleta(1, 'JSON={ "tabela":"AUXILIAR", "camposSelect":[ "ID CHAVE", "DESCRICAO DESCRICAO"], "where": null}');
        $('#txtEtiqueta').autocompleta(1, 'JSON={ "tabela":"ETQ_PROD", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}');

        $('#txtCliente').listaFiltros();
        $('#txtGrupoMat').listaFiltros();
        $('#txtSubgrupoMat').listaFiltros();
        $('#txtRepresentante').listaFiltros();
        $('#txtGrupoCli').listaFiltros();
        $('#txtGrupo').listaFiltros();
        $('#txtComposicao').listaFiltros();
        $('#txtNCM').listaFiltros();
        $('#txtCoord').listaFiltros();
        $('#txtDeposito').listaFiltros();
        $('#txtMoeda').listaFiltros();
        $('#txtLinhaMat').listaFiltros();
        $('#txtLinha').listaFiltros();
        $('#txtNF').listaFiltros();
        $('#txtColecaoProd').listaFiltros();
        $('#txtColecaoPed').listaFiltros();
        $('#txtTipoVenda').listaFiltros();
        $('#txtEstilista').listaFiltros();
        $('#txtMarca').listaFiltros();
        $('#txtPedido').listaFiltros();
        $('#txtEstado').listaFiltros();
        $('#txtNatureza').listaFiltros();
        $('#txtPrazoEnt').listaFiltros();
        $('#txtMotivo').listaFiltros();
        $('#txtCategoria').listaFiltros();
        $('#txtEtiqueta').listaFiltros();


        $('#btnLimpaProduto').on('click', function () {
            if ($('#txtCodigo').val() == '') {
                $('#listaCodigo').val('');
            }
            $('#txtCodigo').val('');
            $('#txtCodigo').focus();
        });

        $('#btnLimpaCliente').on('click', function () {
            if ($('#txtCliente').val() == '') {
                $('#listaCliente').val('');
            }
            $('#txtCliente').val('');
            $('#txtCliente').focus();
        });

        $('#btnLimpaGrupoMat').on('click', function () {
            if ($('#txtGrupoMat').val() == '') {
                $('#listaGrupoMat').val('');
            }
            $('#txtGrupoMat').val('');
            $('#txtGrupoMat').focus();
        });

        $('#btnLimpaSubgrupoMat').on('click', function () {
            if ($('#txtSubgrupoMat').val() == '') {
                $('#listaSubgrupoMat').val('');
            }
            $('#txtSubgrupoMat').val('');
            $('#txtSubgrupoMat').focus();
        });

        $('#btnLimpaRepresen').on('click', function () {
            if ($('#txtRepresentante').val() == '') {
                $('#listaRepresentante').val('');
            }
            $('#txtRepresentante').val('');
            $('#txtRepresentante').focus();
        });

        $('#btnLimpaGrupoCli').on('click', function () {
            if ($('#txtGrupoCli').val() == '') {
                $('#listaGrupoCli').val('');
            }
            $('#txtGrupoCli').val('');
            $('#txtGrupoCli').focus();
        });

        $('#btnLimpaGrupoProd').on('click', function () {
            if ($('#txtGrupo').val() == '') {
                $('#listaGrupo').val('');
            }
            $('#txtGrupo').val('');
            $('#txtGrupo').focus();
        });

        $('#btnLimpaComposicao').on('click', function () {
            if ($('#txtComposicao').val() == '') {
                $('#listaComposicao').val('');
            }
            $('#txtComposicao').val('');
            $('#txtComposicao').focus();
        });

        $('#btnLimpaNCM').on('click', function () {
            if ($('#txtNCM').val() == '') {
                $('#listaNCM').val('');
            }
            $('#txtNCM').val('');
            $('#txtNCM').focus();
        });

        $('#btnLimpaCoord').on('click', function () {
            if ($('#txtCoord').val() == '') {
                $('#listaCoord').val('');
            }
            $('#txtCoord').val('');
            $('#txtCoord').focus();
        });

        $('#btnLimpaDeposito').on('click', function () {
            if ($('#txtDeposito').val() == '') {
                $('#listaDeposito').val('');
            }
            $('#txtDeposito').val('');
            $('#txtDeposito').focus();
        });

        $('#btnLimpaLinhaMat').on('click', function () {
            if ($('#txtLinhaMat').val() == '') {
                $('#listaLinhaMat').val('');
            }
            $('#txtLinhaMat').val('');
            $('#txtLinhaMat').focus();
        });

        $('#btnLimpaLinha').on('click', function () {
            if ($('#txtLinha').val() == '') {
                $('#listaLinha').val('');
            }
            $('#txtLinha').val('');
            $('#txtLinha').focus();
        });

        $('#btnLimpaNF').on('click', function () {
            if ($('#txtNF').val() == '') {
                $('#listaNF').val('');
            }
            $('#txtNF').val('');
            $('#txtNF').focus();
        });

        $('#btnLimpaColecaoProd').on('click', function () {
            if ($('#txtColecaoProd').val() == '') {
                $('#listaColecaoProd').val('');
            }
            $('#txtColecaoProd').val('');
            $('#txtColecaoProd').focus();
        });

        $('#btnLimpaColecaoPed').on('click', function () {
            if ($('#txtColecaoPed').val() == '') {
                $('#listaColecaoPed').val('');
            }
            $('#txtColecaoPed').val('');
            $('#txtColecaoPed').focus();
        });

        $('#btnLimpaColecaoPed').on('click', function () {
            if ($('#txtColecaoPed').val() == '') {
                $('#listaColecaoPed').val('');
            }
            $('#txtColecaoPed').val('');
            $('#txtColecaoPed').focus();
        });

        $('#btnLimpaColecaoPed').on('click', function () {
            if ($('#txtColecaoPed').val() == '') {
                $('#listaColecaoPed').val('');
            }
            $('#txtColecaoPed').val('');
            $('#txtColecaoPed').focus();
        });

        $('#btnLimpaMarca').on('click', function () {
            if ($('#txtMarca').val() == '') {
                $('#listaMarca').val('');
            }
            $('#txtMarca').val('');
            $('#txtMarca').focus();
        });

        $('#btnLimpaPedido').on('click', function () {
            if ($('#txtPedido').val() == '') {
                $('#listaPedido').val('');
            }
            $('#txtPedido').val('');
            $('#txtPedido').focus();
        });

        $('#btnLimpaNatureza').on('click', function () {
            if ($('#txtNatureza').val() == '') {
                $('#listaNatureza').val('');
            }
            $('#txtNatureza').val('');
            $('#txtNatureza').focus();
        });

        $('#btnLimpaPrazoEnt').on('click', function () {
            if ($('#txtPrazoEnt').val() == '') {
                $('#listaPrazoEnt').val('');
            }
            $('#txtPrazoEnt').val('');
            $('#txtPrazoEnt').focus();
        });


        $('#btnLimpaMotivo').on('click', function () {
            if ($('#txtMotivo').val() == '') {
                $('#listaMotivo').val('');
            }
            $('#txtMotivo').val('');
            $('#txtMotivo').focus();
        });

        $('#btnLimpaCategoria').on('click', function () {
            if ($('#txtCategoria').val() == '') {
                $('#listaCategoria').val('');
            }
            $('#txtCategoria').val('');
            $('#txtCategoria').focus();
        });

        $('#btnLimpaEtiqueta').on('click', function () {
            if ($('#txtEtiqueta').val() == '') {
                $('#listaEtiqueta').val('');
            }
            $('#txtEtiqueta').val('');
            $('#txtEtiqueta').focus();
        });
    };

    ///tem pouco filtro graças a Deus
    function limpaFiltros() {
        $('#txtCodigo').val('');
        $('#listaCodigo').val('');
        $('#txtCodigo').focusout();
        $('#listaCodigo').focusout();
        $('#txtCliente').val('');
        $('#listaCliente').val('');
        $('#txtCliente').focusout();
        $('#listaCliente').focusout();
        $('#txtGrupoMat').val('');
        $('#listaGrupoMat').val('');
        $('#txtGrupoMat').focusout();
        $('#listaGrupoMat').focusout();
        $('#txtSubgrupoMat').val('');
        $('#listaSubgrupoMat').val('');
        $('#txtSubgrupoMat').focusout();
        $('#listaSubgrupoMat').focusout();
        $('#txtRepresentante').val('');
        $('#listaRepresentante').val('');
        $('#txtRepresentante').focusout();
        $('#listaRepresentante').focusout();
        $('#txtGrupoCli').val('');
        $('#listaGrupoCli').val('');
        $('#txtGrupoCli').focusout();
        $('#listaGrupoCli').focusout();
        $('#txtGrupo').val('');
        $('#listaGrupo').val('');
        $('#txtGrupo').focusout();
        $('#listaGrupo').focusout();
        $('#txtComposicao').val('');
        $('#listaComposicao').val('');
        $('#txtComposicao').focusout();
        $('#listaComposicao').focusout();
        $('#txtNCM').val('');
        $('#listaNCM').val('');
        $('#txtNCM').focusout();
        $('#listaNCM').focusout();
        $('#txtCoord').val('');
        $('#listaCoord').val('');
        $('#txtCoord').focusout();
        $('#listaCoord').focusout();
        $('#txtDeposito').val('');
        $('#listaDeposito').val('');
        $('#txtDeposito').focusout();
        $('#listaDeposito').focusout();
        $('#txtMoeda').val('');
        $('#listaMoeda').val('');
        $('#txtMoeda').focusout();
        $('#listaMoeda').focusout();
        $('#txtLinhaMat').val('');
        $('#listaLinhaMat').val('');
        $('#txtLinhaMat').focusout();
        $('#listaLinhaMat').focusout();
        $('#txtLinha').val('');
        $('#listaLinha').val('');
        $('#txtLinha').focusout();
        $('#listaLinha').focusout();
        $('#txtNF').val('');
        $('#listaNF').val('');
        $('#txtNF').focusout();
        $('#listaNF').focusout();
        $('#txtColecaoProd').val('');
        $('#listaColecaoProd').val('');
        $('#txtColecaoProd').focusout();
        $('#listaColecaoProd').focusout();
        $('#txtColecaoPed').val('');
        $('#listaColecaoPed').val('');
        $('#txtColecaoPed').focusout();
        $('#listaColecaoPed').focusout();
        $('#txtTipoVenda').val('');
        $('#listaTipoVenda').val('');
        $('#txtTipoVenda').focusout();
        $('#listaTipoVenda').focusout();
        $('#txtEstilista').val('');
        $('#listaEstilista').val('');
        $('#txtEstilista').focusout();
        $('#listaEstilista').focusout();
        $('#txtMarca').val('');
        $('#listaMarca').val('');
        $('#txtMarca').focusout();
        $('#listaMarca').focusout();
        $('#txtPedido').val('');
        $('#listaPedido').val('');
        $('#txtPedido').focusout();
        $('#listaPedido').focusout();
        $('#txtNatureza').val('');
        $('#listaNatureza').val('');
        $('#txtNatureza').focusout();
        $('#listaNatureza').focusout();
        $('#txtPrazoEnt').val('');
        $('#listaPrazoEnt').val('');
        $('#txtPrazoEnt').focusout();
        $('#listaPrazoEnt').focusout();
        $('#txtMotivo').val('');
        $('#listaMotivo').val('');
        $('#txtMotivo').focusout();
        $('#listaMotivo').focusout();
        $('#txtCategoria').val('');
        $('#listaCategoria').val('');
        $('#txtCategoria').focusout();
        $('#listaCategoria').focusout();
        $('#txtEtiqueta').val('');
        $('#listaEtiqueta').val('');
        $('#txtEtiqueta').focusout();
        $('#listaEtiqueta').focusout();
        $('#txtLote').val('');
        $('#txtDataEmissaoNFI').val('1200-01-01');
        $('#txtDataEmissaoNFF').val('2500-12-01');
        $('#cbVendaCompra').prop('checked', false);
        $('#cbDevolucao').prop('checked', false);
        $('#cbRemessa').prop('checked', false);
        $('#cbRetorno').prop('checked', false);
        $('#cbConsignacao').prop('checked', false);
        $('#cbAntecipacao').prop('checked', false);
        $('#cbServicos').prop('checked', false);
        $('#cbEnergiaTelefone').prop('checked', false);
        $('#cbBonificacao').prop('checked', false);
        $('#cbPatrimonio').prop('checked', false);
        $('#cbEstornoImposto').prop('checked', false);
        $('#cbMostraOuNaoNFEDevolucao').prop('checked', false);
        $('#cbConsideraFatorConversao').prop('checked', false);
        $('#cbConsideraNatureza').prop('checked', true);
        $('#cbTodosInss').prop('checked', true);
        $('#cbComInss').prop('checked', false);
        $('#cbUtilizaPartedoLote').prop('checked', false);
        $('#cbSemInss').prop('checked', false);
        $('#cbCliente').prop('checked', false);
        $('#cbFornecedor').prop('checked', false);
        $('#cbTerceiros').prop('checked', false);
        $('#cbNormais').prop('checked', true);
        $('#cbTodosFiltros').prop('checked', true);
        $('#cbTodasDups').prop('checked', true);
        $('#selectTipoEntidade').val('considerartipoEntidade');
    };








































})













































