<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Relatório de Comparativo Anual</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=2.7.5">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=2.7.5">

  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">

  <link rel="stylesheet" href="dist/css/custom.css?versao=2.7.5">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=2.7.5">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=2.7.5" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=2.7.5">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=2.7.5" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=2.7.5">
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.227.20.1">
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.234.11.1">
  <style>
    #tabelaCashback td {
      padding: 0 !important;
      padding-left: 10px !important;
    }

    .form-check {
      margin-left: 21px;
      margin-bottom: 10px;
    }

    .border-Field .textoBorda {
      font-size: 1.1em !important;
      text-align: left !important;
      width: auto;
      padding: 0 15px;
      border-bottom: none;
    }

    .border-Field {
      border: 1px solid #fff !important;
      /* padding: 0 1.0em 1.0em 1.0em !important; */
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
    }

    .alinharDireita {
      text-align: right;
    }

    table.dataTable tbody tr:hover .hoverFirstTd {
      color: white !important;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../menu.php');
    ?>
    <div id="driver-page-overlay" class="d-none"></div>
    <div class="content-wrapper">
      <section class="content">
        <div class="content-header">
          <div class="container-fluid">
            <div class="row mb-2">
              <div class="col-sm-6 flex">
                <h1 class="m-0 text-dark">Relatório de Comparativo Anual de Vendas</h1>
                <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                  <i class="fas fa-question-circle"></i></button>
                <button id="show-content" class="show-content" style="margin-left:8px;">
                  <i class="fa fa-comment-dots" class="icone" style="font-size: 16px;"></i>
                  <span class="texto">Informativo</span>
                </button>
              </div>
              <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                  <li class="breadcrumb-item"><a href="./index">Início</a></li>
                  <li class="breadcrumb-item active">Relatório de Comparativo Anual de Vendas</li>
                </ol>
              </div>
            </div>
          </div>
          <div class="col-sm-12 mb-3">
            <button class="btn btn-success btn-sisp" id="btnFiltros" type="button"><span class="fas fa-filter"></span> Filtros</button>
            <button class="btn btn-danger btn-sisp" id="btnImprimir"><span style="color: white!important;" class="fas fa-print"></span> Imprimir</button>
          </div>
          <div class="container-fluid" id="divTabelaCashback">
            <div class="row d-flex justify-content-center" id="grafico" style="margin-top: 20px;">
              <div class="col-11 d-none" id="chart0">
              </div>
              <div class="col-11 d-none" id="chart1">
              </div>
              <div class="col-11 d-none" id="chart2">
              </div>
            </div>
            <div class="row card">
              <div class="col-sm-12 table-responsive p-4">
                <h4 id="tituloTabela"></h4>
                <table width="100%" style="width:100%;" id="tabelaDados" class="table table-sm">
                  <tfoot></tfoot>
                </table>
              </div>
            </div>
          </div>
        </div>
      </section>
      <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-xl" role="document">
          <div class="modal-content" id="modalBody">
            <div class="modal-header">
              <h4 class="modal-title">Filtros</h4>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <div class="row p-3">
                <div class="form-group col-md-4 col-12 mb-0">
                  <fieldset class="form border-Field p-0">
                    <legend class="textoBorda mb-0 pb-0">Análise por</legend>
                    <div class="form-row mb-2">
                      <div class="radio-group form-radio">
                        <label class="container escondeRadio">
                          <input type="radio" value="0" name="analisePor">
                          <span class="checkmark"></span>&nbsp;Qtde</label>
                      </div>
                      <div class="radio-group form-radio">
                        <label class="container escondeRadio">
                          <input type="radio" checked="checked" value="1" name="analisePor">
                          <span class="checkmark"></span>&nbsp;Valor</label>
                      </div>
                      <div class="radio-group form-radio">
                        <label class="container escondeRadio">
                          <input type="radio" value="2" name="analisePor">
                          <span class="checkmark"></span>&nbsp;Qtde / Valor</label>
                      </div>
                    </div>
                  </fieldset>
                </div>
                <div class="form-group col-md-6 col-6 col-sm-12 mb-0">
                  <fieldset class="form border-Field p-0">
                    <legend class="textoBorda pb-0 mb-0">Status Venda</legend>
                    <div class="form-row">
                      <div class="form-check mb-0 pb-0">
                        <input class="form-check-input mb-0" type="checkbox" id="cbEmitido" checked> <label for="cbEmitido">Emitido</label>
                      </div>
                      <div class="form-check mb-0 pb-0">
                        <input class="form-check-input mb-0" type="checkbox" id="cbPendente" checked> <label for="cbPendente">Pendente</label>
                      </div>
                      <div class="form-check mb-0 pb-0">
                        <input class="form-check-input mb-0" type="checkbox" id="cbAgrupado" checked> <label for="cbAgrupado">Agrupado</label>
                      </div>
                      <div class="form-check mb-0 pb-0">
                        <input class="form-check-input mb-0" type="checkbox" id="cbDevolvido" checked> <label for="cbDevolvido">Devolvido</label>
                      </div>
                      <div class="form-check mb-0 pb-0">
                        <input class="form-check-input mb-0" type="checkbox" id="cbCancelado" checked> <label for="cbCancelado">Cancelado</label>
                      </div>
                    </div>
                  </fieldset>
                </div>
                <div class="col-md-2 col-2 mt-2 p-1">
                  <button class="btn btn-danger btn-sisp" type='button' id="btnSelecionarEmpresas">Selecionar Empresas</button>
                </div>
                <div class="col-md-4 col-12 form-group">
                  <label data-error="wrong" data-success="right" for="txtDataDe">Período de Análise de/até:</label>
                  <div class="input-group">
                    <input type="number" class="input-default focus form-control" min="1900" max="2099" step="1" value="2020" id="txtDataDe" name="txtDataDe" />
                    <input type="number" class="input-default focus form-control" min="1900" max="2099" step="1" value="2023" id="txtDataAte" name="txtDataAte" />
                  </div>
                </div>
                <div class="col-md-4 col-12 form-group">
                  <label data-error="wrong" data-success="right" for="txtProduto">Produto:</label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtProduto" name="txtProduto" multiple="multiple">
                    </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnProduto" name="btnProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaProduto" name="btnLimpaProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-md-4 col-12 form-group">
                  <label data-error="wrong" data-success="right" for="txtGrupo">Grupo:</label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtGrupo" name="txtGrupo" multiple="multiple"> </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnGrupo" name="btnGrupo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaGrupo" name="btnLimpaGrupo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-md-4 col-12 form-group">
                  <label data-error="wrong" data-success="right" for="txtColecao">Coleção:</label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtColecao" name="txtColecao" multiple="multiple"> </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnColecao" name="btnColecao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaColecao" name="btnLimpaColecao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-md-4 col-12 form-group">
                  <label data-error="wrong" data-success="right" for="txtEtiqueta">Etiqueta:</label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtEtiqueta" name="txtEtiqueta" multiple="multiple"> </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnEtiqueta" name="btnEtiqueta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaEtiqueta" name="btnLimpaEtiqueta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-md-4 col-12 form-group">
                  <label data-error="wrong" data-success="right" for="txtLinha">Linha:</label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtLinha" name="txtLinha" multiple="multiple"> </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnLinha" name="btnLinha" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaLinha" name="btnLimpaLinha" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-md-4 col-12 form-group">
                  <label data-error="wrong" data-success="right" for="txtMarca">Marca:</label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtMarca" name="txtMarca" multiple="multiple"> </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnMarca" name="btnMarca" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaMarca" name="btnLimpaMarca" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-md-4 col-12 form-group">
                  <label data-error="wrong" data-success="right" for="txtModelo">Modelo:</label>
                  <div class="input-group">
                    <select class="js-example-programmatic js-states form-control" id="txtModelo" name="txtModelo" multiple="multiple"> </select>
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnModelo" name="btnModelo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btnLimpaModelo" name="btnLimpaModelo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <div class="row">
                <button class="btn btn-primary btn-sisp mr-2" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>
                <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php
  include_once('../../footer.php');
  include_once('../../informativo.html');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=2.7.5"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=2.7.5"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=2.7.5"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=2.7.5"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=2.7.5"></script>
  <script src="dist/js/adminlte.min.js?versao=2.7.5"></script>
  <script src="dist/js/sisplan.js?versao=2.7.5"></script>
  <script src="utils/funcoes.js?versao=2.7.5"></script>
  <script src="utils/cookies.js?versao=2.7.5"></script>
  <script src="dist/js/requisicoes.js?versao=2.7.5"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=2.7.5"></script>
  <script src="dist/js/driver.min.js?versao=2.7.5"></script>
  <script src="plugins/toastr/toastr.min.js?versao=2.7.5"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=2.1.7"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=2.7.5"></script>
  <script type="text/javascript" src="config.js?versao=2.7.5"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.236.13.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('RELCOMPARATIVOANUAL');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/relcomparativoanual/relcomparativoanual.js?versao=2.7.5`;
      insereJavaScriptPagina(sArquivo);


    });
  </script>
</body>

</html>