$(document).ready(async function () {

  $('#tutorial').on('click', function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: 'Sair',
        closeBtnText: 'Fechar',
        nextBtnText: 'Próximo',
        prevBtnText: 'Anterior',
        allowClose: false
      });
      driver.defineSteps([{
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para abrir os filtros e realizar uma consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir um relatório.',
          position: 'right'
        }
      },
      {
        element: '#divRelatorio',
        popover: {
          title: 'Tabela com os Dados',
          description: 'Aqui, após clicar em consultar ficam os dados filtrados.',
          position: 'bottom'
        }
      }
      ]);
      driver.start();
    });
  });

  let abaAtiva;

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

  if (colunas == null || colunas.relCaixaManual == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relCaixaManual: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.relCaixaVendas == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relCaixaVendas: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  if (colunas == null || colunas.relCaixa == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, relCaixa: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  // confirma as colunas
  $('#btnConfirmarColunas').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const novasColunas = retornaNovasColunasInvisiveis();
      let cols = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      if (abaAtiva == '1') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...cols, relCaixa: novasColunas }))
        $('#tabelaCaixa').DataTable().columns().visible(true);

        $('#tabelaCaixa').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else if (abaAtiva == '2') {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...cols, relCaixaManual: novasColunas }))
        $('#tabelaManual').DataTable().columns().visible(true);

        $('#tabelaManual').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      } else {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...cols, relCaixaVendas: novasColunas }))
        $('#tabelaVendasGrid').DataTable().columns().visible(true);

        $('#tabelaVendasGrid').DataTable().columns().every(
          function () {
            if ((novasColunas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          })
      }

    } finally {
      $.LoadingOverlay('hide');
      $('#modal-ColunasVisiveis').modal('hide');
    }
  })

  const parametrosVenda = await BuscaParametrosVenda();
  const utilizaProcessoCaixaCego = parametrosVenda[64] == '1';

  $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE CHAVE", "DESCRICAO"], "where": null}`);
  $('#txtCaixa').autocompleta(3, `JSON={ "tabela":"CAIXA_LOJA", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO"], "where": null}`);

  $('#btn-Moeda').pesquisa('#txtMoeda', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE CODIGO", "DESCRICAO"]}`, 'Pesquisa Moeda', 'MOEDA');
  $('#btn-Caixa').pesquisa('#txtCaixa', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAIXA_LOJA", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Caixa', 'CAIXA_LOJA');

  $('#btn-limpa-Moeda').on('click', function () {
    $('#txtMoeda').val('');
  });

  $('#btn-limpa-Caixa').on('click', function () {
    $('#txtCaixa').val('');
  });

  $('#btnLimparFiltros').on('click', async function () {
    $('#dtPeriodoDe').val('');
    $('#dtPeriodoAte').val('');
    $('#txtMoeda').val('');
    $('#txtCaixa').val('');
  });

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  async function retornaFiltros() {
    const periodoDe = $('#dtPeriodoDe').val();
    const periodoAte = $('#dtPeriodoAte').val();
    const moeda = pegaChave('#txtMoeda');
    const caixa = pegaChave('#txtCaixa');

    const retorno =
      `PERIODODE=${periodoDe}` +
      `&PERIODOATE=${periodoAte}` +
      `&MOEDA=${moeda}` +
      `&CAIXA=${caixa}`;

    return retorno;
  }

  $('#btnImprimir').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = `/sisplan/impressao/v1/imprimirrelcaixa?`;
        const filtros = await retornaFiltros();
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelCaixa');
        const arquivo = await GeraRelatorio(`${url}${filtros}`, 'GET', 100000, false, 'RelCaixa');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnConsultar').on('click', async function () {
    try {
      if ((!validarData($('#dtPeriodoDe').val())) || (!validarData($('#dtPeriodoAte').val()))) {
        msgAlerta('Necessário informar um período válido.');
        return;
      }

      if (pegaChave('#txtCaixa') == '') {
        msgAlerta('Necessário informar um caixa.');
        return;
      }

      $.LoadingOverlay("show");
      const filtros = await retornaFiltros();
      var response = await requisicao('GET', '/sisplan/impressao/v1/consultarelcaixa?', filtros, null);

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      var jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        alert(jsonStr.mensagem);
        return;
      }

      var table = await criaDataTable(jsonStr[0], jsonStr[1], jsonStr[2]);

      // $('#tabelaCaixa_wrapper').css("width", "100%");
      $('#modal-filtros').modal('hide');
      $.LoadingOverlay("hide");
    } catch (error) {
      console.log(error);
      $.LoadingOverlay("hide");
    }
  });

  function formataColunas(data) {
    if (data == 'CODIGO') {
      return 'Código';
    } else if (data == 'DESCRICAO') {
      return 'Descrição';
    } else if (data == 'CONDICAO') {
      return 'Condição';
    } else if (data == 'SALDO_ANTERIOR') {
      return 'Saldo Anterior';
    } else if (data == 'ENTRADAS') {
      return 'Entradas';
    } else if (data == 'SAIDAS') {
      return 'Saídas';
    } else if (data == 'SALDO_ATUAL') {
      return 'Saldo Atual';
    } else if (data == 'CONFERIDO') {
      return 'Conferido';
    } else if (data == 'DIFERENCA') {
      return 'Diferença';
    } else if (data == 'CODMOE') {
      return 'Cod Moeda';
    } else if (data == 'DESCMOE' || data == 'DESC_MOEDA') {
      return 'Desc Moeda';
    } else if (data == 'VALOR') {
      return 'Valor';
    } else if (data == 'JUROS') {
      return 'Juros';
    } else if (data == 'VALOR_ORIG') {
      return 'Valor Orig';
    } else if (data == 'DT_VENCTO') {
      return 'Data Vencto';
    } else if (data == 'DESCTIPO') {
      return 'Operação';
    } else if (data == 'DUPLICATA') {
      return 'Duplicata';
    } else if (data == 'DESCRICAO') {
      return 'Descrição';
    } else if (data == 'ORDEM') {
      return 'Ordem';
    } else if (data == 'VENDA') {
      return 'Venda';
    } else if (data == 'MOEDA') {
      return 'Moeda';
    } else if (data == 'QUANTIDADE') {
      return 'Quantidade';
    } else if (data == 'VALOR_VENDA') {
      return 'Valor Venda';
    } else if (data == 'DESCONTO') {
      return 'Desconto';
    } else if (data == 'CODCLI') {
      return 'Cod Cli';
    } else if (data == 'NOME_CLI') {
      return 'Nome Cli';
    } else if (data == 'CODREP') {
      return 'Cod Rep';
    } else if (data == 'NOME_REP') {
      return 'Nome Rep';
    } else if (data == 'HORA_VENDA') {
      return 'Hora Venda';
    } else {
      return data;
    }
  }

  $('#tabVendas').on('click', function () {
    $('#divVendas').removeClass('d-none');
  })

  async function criaDataTable(data, data2, data3) {
    try {

      let dsCols = [];
      let dsCols2 = [];
      let dsCols3 = [];
      let colunasInvisiveisPadrao = [];

      let cols;
      data.map(e => {
        delete e['A_RETIRAR'];
        delete e['TROCO'];
        delete e['SALDO_FINAL'];
      })

      cols = Object.keys(data[0]);
      cols.map(e => {
        dsCols.push({
          data: e,
          title: formataColunas(e)
        })
      })

      data2.map(e => {
        delete e['DESCONTO'];
        delete e['LANCAMENTO'];
        delete e['NRCAIXA'];
        delete e['TIPO'];
        delete e['TIPO_ORD'];
      })

      cols = Object.keys(data2[0]);
      cols.map(e => {
        dsCols2.push({
          data: e,
          title: formataColunas(e)
        })
      })

      cols = Object.keys(data3[0]);
      cols.map(e => {
        dsCols3.push({
          data: e,
          title: formataColunas(e)
        })
      })

      if (!utilizaProcessoCaixaCego) {
        colunasInvisiveisPadrao.push(7);
        colunasInvisiveisPadrao.push(8);
      }

      $('#tabelaCaixa').DataTable({
        searching: false,
        paging: true,
        info: true,
        ordering: true,
        destroy: true,
        colReorder: true,
        language: {
          sEmptyTable: 'Nenhum registro encontrado',
          sInfo: '_TOTAL_ registros',
          sInfoEmpty: ' 0 registros',
          sInfoFiltered: '(Filtrados de _MAX_ registros)',
          sInfoPostFix: '',
          sInfoThousands: '.',
          sLengthMenu: '_MENU_ resultados',
          sLoadingRecords: 'Carregando...',
          sProcessing: 'Processando...',
          sZeroRecords: 'Nenhum registro encontrado',
          sSearch: 'Pesquisar',
          oPaginate: {
            sNext: 'Próximo',
            sPrevious: 'Anterior',
            sFirst: 'Primeiro',
            sLast: 'Último',
          },
          oAria: {
            sSortAscending: ': Ordenar colunas de forma ascendente',
            sSortDescending: ': Ordenar colunas de forma descendente',
          },
        },
        data: data,
        columns: dsCols,
        columnDefs: [
          {
            targets: colunasInvisiveisPadrao,
            visible: false
          },
          {
            "render": function (data) {
              return parseFloat(data ?? 0).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              })
            },
            "targets": [3, 4, 5, 6],
          }
        ]
      });

      $('#tabelaManual').DataTable({
        searching: false,
        paging: true,
        info: true,
        ordering: true,
        destroy: true,
        colReorder: true,
        language: {
          sEmptyTable: 'Nenhum registro encontrado',
          sInfo: '_TOTAL_ registros',
          sInfoEmpty: ' 0 registros',
          sInfoFiltered: '(Filtrados de _MAX_ registros)',
          sInfoPostFix: '',
          sInfoThousands: '.',
          sLengthMenu: '_MENU_ resultados',
          sLoadingRecords: 'Carregando...',
          sProcessing: 'Processando...',
          sZeroRecords: 'Nenhum registro encontrado',
          sSearch: 'Pesquisar',
          oPaginate: {
            sNext: 'Próximo',
            sPrevious: 'Anterior',
            sFirst: 'Primeiro',
            sLast: 'Último',
          },
          oAria: {
            sSortAscending: ': Ordenar colunas de forma ascendente',
            sSortDescending: ': Ordenar colunas de forma descendente',
          },
        },
        data: data2,
        columns: dsCols2,
        columnDefs: [
          {
            "render": function (data) {
              return parseFloat(data ?? 0).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              })
            },
            "targets": [2, 3, 4],
          },
          {
            "type": 'date-br',
            "render": function (data) {
              if (data != undefined) {
                x = data.slice(0, 10).split('-');
                return `${x[2]}/${x[1]}/${x[0]}`;
              } else {
                return ''
              }
            },
            "targets": 5
          }
        ]
      });

      $('#tabelaVendasGrid').DataTable({
        searching: false,
        paging: true,
        info: true,
        ordering: true,
        destroy: true,
        colReorder: true,
        language: {
          sEmptyTable: 'Nenhum registro encontrado',
          sInfo: '_TOTAL_ registros',
          sInfoEmpty: ' 0 registros',
          sInfoFiltered: '(Filtrados de _MAX_ registros)',
          sInfoPostFix: '',
          sInfoThousands: '.',
          sLengthMenu: '_MENU_ resultados',
          sLoadingRecords: 'Carregando...',
          sProcessing: 'Processando...',
          sZeroRecords: 'Nenhum registro encontrado',
          sSearch: 'Pesquisar',
          oPaginate: {
            sNext: 'Próximo',
            sPrevious: 'Anterior',
            sFirst: 'Primeiro',
            sLast: 'Último',
          },
          oAria: {
            sSortAscending: ': Ordenar colunas de forma ascendente',
            sSortDescending: ': Ordenar colunas de forma descendente',
          },
        },
        autoWidth: true,
        data: data3,
        columns: dsCols3,
        columnDefs: [
          {
            "render": function (data) {
              return parseFloat(data ?? 0).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              })
            },
            "targets": [9, 10, 11],
          },
          {
            "type": 'date-br',
            "render": function (data) {
              if (data != undefined) {
                x = data.slice(0, 10).split('-');
                y = data.slice(11, 19);
                return `${x[2]}/${x[1]}/${x[0]} ${y}`;
              } else {
                return ''
              }
            },
            "targets": [12]
          }
        ]
      });

      const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      $('#tabelaCaixa_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaCaixa_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show');
        abaAtiva = '1';
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      })

      $('#buttonExcel').on('click', async function () {
        const url = '/sisplan/impressao/v1/consultarelcaixa?';
        const filtros = await retornaFiltros();
        const formataCampos = montaComandosCampos();
        await exportaCSV(url, filtros, false, null, 'Relatório de Caixa', '#tabelaCaixa', formataCampos, 0);
      })

      $('#buttonColVis').prop('title', 'Configurar colunas')
      $('#buttonExcel').prop('title', 'Exportar CSV')

      $('#tabelaCaixa').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.relCaixa).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        }
      )

      $('#tabelaManual_length').prepend('<button class="buttonColVis" id="buttonColVisManual"><i class="fas fa-cogs"></i></button>');
      $('#tabelaManual_length').prepend('<button class="buttonExcel" id="buttonExcelManual"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVisManual').on('click', async function () {
        $.LoadingOverlay('show');
        abaAtiva = '2';
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      })

      $('#buttonExcelManual').on('click', async function () {
        const url = '/sisplan/impressao/v1/consultarelcaixa?';
        const filtros = await retornaFiltros();
        const formataCampos = montaComandosCamposManual();
        await exportaCSV(url, filtros, false, null, 'Relatório de Caixa - Manual', '#tabelaManual', formataCampos, 1);
      })

      $('#buttonColVisManual').prop('title', 'Configurar colunas')
      $('#buttonExcelManual').prop('title', 'Exportar CSV')

      $('#tabelaManual').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.relCaixaManual).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        }
      )

      $('#tabelaVendasGrid_length').prepend('<button class="buttonColVis" id="buttonColVisVendas"><i class="fas fa-cogs"></i></button>');
      $('#tabelaVendasGrid_length').prepend('<button class="buttonExcel" id="buttonExcelVendas"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVisVendas').on('click', async function () {
        $.LoadingOverlay('show');
        abaAtiva = '3';
        $('#modal-ColunasVisiveis').modal('show');
        $.LoadingOverlay('hide');
      })

      $('#buttonExcelVendas').on('click', async function () {
        const url = '/sisplan/impressao/v1/consultarelcaixa?';
        const filtros = await retornaFiltros();
        const formataCampos = montaComandosCamposVendas();
        await exportaCSV(url, filtros, false, null, 'Relatório de Caixa - Vendas', '#tabelaVendasGrid', formataCampos, 2);
      })

      $('#buttonColVisVendas').prop('title', 'Configurar colunas')
      $('#buttonExcelVendas').prop('title', 'Exportar CSV')

      $('#tabelaVendasGrid').DataTable().columns().every(
        function () {
          if ((colunasInvisiveis.relCaixaVendas).indexOf(this.dataSrc()) != -1) {
            this.visible(false);
          }
        }
      )

      $('#tabLancManuais').trigger('click');
      $('#divVendas').addClass('d-none');

    } catch (e) {
      console.log(e);
    }
  }

  function montaComandosCampos() {
    let retorno = `dados = dados.map((key) => {
      let v1 = key.ENTRADAS 
      if (typeof v1 == 'string') {
      v1 = parseFloat(v1.replace(".", "").replace(",", ".")).toFixed(2)
      } else {
      v1 = parseFloat(v1).toFixed(2) }
      let v2 = key.SAIDAS
      if (typeof v2 == 'string') {
      v2 = parseFloat(v2.replace(".", "").replace(",", ".")).toFixed(2)
      } else {
      v2 = parseFloat(v2).toFixed(2) }
      let v3 = key.SALDO_ANTERIOR
      if (typeof v3 == 'string') {
      v3 = parseFloat(v3.replace(".", "").replace(",", ".")).toFixed(2)
      } else {
      v3 = parseFloat(v3).toFixed(2) }
      let v4 = key.SALDO_ATUAL
      if (typeof v4 == 'string') {
      v4 = parseFloat(v4.replace(".", "").replace(",", ".")).toFixed(2)
      } else {
      v4 = parseFloat(v4).toFixed(2) }
      return { ...key, ENTRADAS: v1, SAIDAS: v2, SALDO_ANTERIOR: v3, SALDO_ATUAL: v4 }
      }) \n`

    retorno += `dados.map(e => {
        delete e['A_RETIRAR'];
        delete e['TROCO'];
        delete e['SALDO_FINAL'];
      })`
    return retorno;
  };

  function montaComandosCamposManual() {
    return `dados.map(e => {
      delete e['DESCONTO'];
      delete e['LANCAMENTO'];
      delete e['NRCAIXA'];
      delete e['TIPO'];
      delete e['TIPO_ORD'];
    })`;
  }

  function montaComandosCamposVendas() {
    return 'dados = dados.map((key) => { \n' +
      `let v = key.VALOR \n` +
      `if (typeof v == 'string') { \n` +
      `v = parseFloat(v.replace(".", "").replace(",", ".")).toFixed(2) \n` +
      `} else { \n` +
      `v = parseFloat(v).toFixed(2) } \n` +
      'return { ...key, VALOR: v } \n' +
      '}) \n';
  };

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];

    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    if (abaAtiva == '1') {

      $('#tabelaCaixa').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text().trim(),
          'data': this.dataSrc()
        })
      });

      adicionaColunas(cols, colunasInvisiveis.relCaixa ?? [])
    } else if (abaAtiva == '2') {
      $('#tabelaManual').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text().trim(),
          'data': this.dataSrc()
        })
      });

      adicionaColunas(cols, colunasInvisiveis.relCaixaManual ?? [])
    } else {
      $('#tabelaVendasGrid').DataTable().columns().every(function () {
        cols.push({
          'title': $(this.header()).text().trim(),
          'data': this.dataSrc()
        })
      });

      adicionaColunas(cols, colunasInvisiveis.relCaixaVendas ?? [])
    }
  })

  function validarData(data) {
    try {
      const dia = parseInt(data.substring(8));
      const mes = parseInt(data.substring(5, 7));
      const ano = parseInt(data.substring(0, 4));

      switch (mes) {
        case 1: case 3: case 5: case 7:
        case 8: case 10: case 12:
          if (dia <= 31)
            return true;
          else
            return false;
          break;
        case 4: case 6:
        case 9: case 11:
          if (dia <= 30)
            return true;
          else
            return false;
          break;
        case 2:
          if ((ano % 400 == 0) || (ano % 4 == 0 && ano % 100 != 0))
            if (dia <= 29)
              return true;
            else
              return false;
          else
            if (dia <= 28)
              return true;
            else
              return false;
      }
    } catch {
      return false;
    }
  }
});