<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Cadastro de Regra Fiscal</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.237.17.1">
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.237.17.1">
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>
  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.237.17.1" />
  <link href='../dist/css/bootstrap.min.css?versao=3.237.17.1'>
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.237.17.1">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.237.17.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.237.17.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/responsive.bootstrap.min.css?versao=3.237.17.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" href="../dist/css/cadastro.css?versao=3.237.17.1">
  <!-- Toastr -->
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.237.17.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.237.17.1" />
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.237.17.1">
  <!-- Google Font: Source Sans Pro -->
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
  <style>
    #progressbar li {
      list-style-type: none;
      font-size: 12px;
      width: 33.33333%;
      float: left;
      position: relative
    }

    .labelGeral {
      margin-top: 7px;
      margin-bottom: 3px;
    }

    .labelCheck {
      font-size: 120%;
      /* border-bottom: outset 2px;
            border-left: outset 2px; */
      padding: 0.2%;
      margin-left: 1%;
    }

    .configCheck {
      -ms-transform: scale(1.2);
      -moz-transform: scale(1.2);
      -webkit-transform: scale(1.2);
      -o-transform: scale(1.2);
      transform: scale(1.2);
      padding: 10px;
    }

    .radioTipo {
      font-size: 120%;
    }

    .bTipo {
      position: absolute;
      margin-bottom: 50%;
      font-size: 120%;
      font-weight: bolder;
    }

    .pTipo {
      margin-top: 2%;
      margin-left: -1%;
      margin-bottom: 0%;
    }

    .pCartao {
      margin-left: -1%;
      margin-bottom: 0%;
      margin-top: 2%;
    }

    .valMin {
      margin-top: 2%;
    }

    .frete {
      margin-top: 2%;
      margin-left: 0.1%;
    }

    #contas-wrap {
      margin-top: 0%;
    }

    #labelcontas {
      margin-top: 2%;
    }

    .radioTop {
      margin-left: 2%;
      margin-top: 2%;
      padding-left: 1%;
      padding-top: 1%;
      padding-right: 1%;
      padding-bottom: 0%;
    }

    .labelFonte {
      font-size: 100%;
      margin-top: 20%;
    }

    .radiosStyle {
      margin-top: 0%;
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      margin-left: 0%;
    }

    .checkboxMoeda {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding-top: 1%;
      padding-left: 1.5%;
    }

    .checkboxTipo {
      margin-left: 0.1%;
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding-top: 1%;
      padding-bottom: 0%;
    }

    .labelTipo {
      margin-bottom: 3px;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../../menu.php');
    ?>
    <div id="myModal" class="modal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 id="myModalLabel" class="modal-title"></h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <p id="myModalText"></p>
          </div>
          <div class="modal-footer">
            <button id="btnYes" type="button" class="btn btn-primary">Sim</button>
            <button id="btnNo" type="button" class="btn btn-secondary" data-dismiss="modal">Não</button>
          </div>
        </div>
      </div>
    </div>
    <div class="content-wrapper">
      <section class="content">
        <div class="content-header">
          <div class="container-fluid">
            <div class="row mb-2">
              <div class="col-sm-6 flex">
              </div>
              <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                  <li class="breadcrumb-item"><a href="<?php echo BASE_URI; ?>/index">Início</a></li>
                  <li class="breadcrumb-item"><a href="<?php echo BASE_URI; ?>/reducao">Acesso Redução</a></li>
                  <li class="breadcrumb-item active">Cadastro Regra Fiscal</li>
                </ol>
              </div><!-- /.col -->
            </div><!-- /.row -->
          </div>
          <div class="row justify-content-center mt-0">
            <div class="col-10 text-center p-0 mt-3 mb-2">
              <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
                <div class="card-header text-center flex" style="border: none!important;box-shadow:none!important;">
                  <h2>Cadastro de Regra Fiscal
                    <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                      <i class="fas fa-question-circle"></i>
                    </button>
                  </h2>
                </div>
                <div class="row">
                  <div class="col-md-12 mx-0">
                    <form id="msform">
                      <!-- progressbar -->
                      <ul id="progressbar">
                        <li class="active" id="account"><strong>Geral</strong></li>
                        <li id="payment"><strong>Comparação</strong></li>
                        <li id="personal"><strong>Alterações</strong></li>
                      </ul> <!-- fieldsets -->
                      <p>Preencha os dados e clique em avançar para realizar o cadastro da regra fiscal</p>
                      <fieldset>
                        <div class="form-card" id="formcard1">
                          <h2 class="fs-title">Dados Gerais   
                            <label for="checkAtivo" style="font-size: 50%;"><input type="checkbox" checked id="checkAtivo">  Ativo</label>
                          </h2>
                          <div class="row">
                            <div class="col-lg-6  col-12 form-group">
                              <div class="row">
                                <div class="col-lg-6  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodigo">Código *</label>
                                  <div class="input-group">
                                    <input type="text" readonly class="input-default focus form-control" id="txtCodigo" name="txtCodigo" class="form-control" placeholder="Campo preenchido automaticamente">
                                  </div>
                                </div>
                                <div class="col-lg-6  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtPrioridade">Prioridade *</label>
                                  <div class="input-group">
                                    <input type="number" class="input-default focus form-control" id="txtPrioridade" name="txtPrioridade" class="form-control" placeholder="Prioridade">
                                  </div>
                                </div>
                                <div class="col-lg-12  col-12 form-group">
                                  <label data-error="wrong" data-success="right" for="txtDescricao">Descrição regra *</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtDescricao" name="txtDescricao" class="form-control" placeholder="Descrição da regra">
                                  </div>
                                </div>
                                <div class="col-lg-12  col-12 form-group">
                                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtOperacaoFiscal">Operação fiscal *</label>
                                  <div class="input-group">
                                    <input type="text" class="input-default focus form-control" id="txtOperacaoFiscal" name="txtOperacaoFiscal" class="form-control" placeholder="Operação fiscal">
                                    <div class="input-group-append">
                                      <button class="btn bg-danger" id="btnOperacaoFiscal" name="btnEmpresa" data-button="absolute" type="button">
                                        <i class="m-0 p-0 fas fa-search"></i>
                                      </button>
                                      <button class="btn bg-danger" id="btnAOperacaoFiscal" type="button">
                                        <i class="m-0 p-0 fas fa-trash"></i>
                                      </button>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-6  col-12 form-group">
                              <table id="tabelaEmpresa" class="table table-sm table-hover table-select table-condensed">
                                <thead>
                                  <tr>
                                    <th>Sel</th>
                                    <th>Empresa</th>
                                  </tr>
                                </thead>
                                <tbody>
                                </tbody>
                              </table>
                            </div>
                          </div>
                        </div>
                        <input type="button" name="avancar1" class="btn-sisp next action-button" id="avancar1" value="Avançar" />
                        <button type="button" id="btnVoltar" style="font-size:15px;" class="btn-sisp action-button-previous" data-dismiss="modal">Voltar</button>
                      </fieldset>
                      <fieldset>
                        <div class="form-card">
                          <h2 class="fs-title">Campos de Comparação</h2>
                          <div class="row" id="tourcamposcomparacao">

                            <div class="col-lg-12 col-12 d-flex justify-content-start">
                              <input type="button" name="btnCFOP" class="action-button" value="CFOP" id="btnCFOP">
                              <input type="button" name="btnNCM" class="action-button" value="NCM" id="btnNCM">
                              <input type="button" name="btnEstados" class="action-button" value="ESTADOS" id="btnEstados">
                              <input type="button" name="btnEntidade" class="action-button" value="ENTIDADE" id="btnEntidade">
                              <input type="button" name="btnOrigem" class="action-button" value="ORIG. ITEM" id="btnOrigem">
                              <input type="button" name="btnCodSPED" class="action-button" value="COD. SPED" id="btnCodSPED">
                              <input type="button" name="btnEntidAux" class="action-button" value="ENTID. AUX" id="btnEntidAux">
                              <input type="button" name="btnPresenca" class="action-button" value="PRESENÇA" id="btnPresenca">
                            </div>

                            <div class="col-lg-4  col-12" style="padding-right: 2%;">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="tipoPessoa">Tipo Pessoa</label>
                              <div class="row form-group checkboxMoeda" id="tipoPessoa">
                                <div class="col-lg-12">
                                  <label class="labelCheck" for="checkFisica"><input type="checkbox" class="configCheck" id="checkFisica">  1 - Física</label><br>
                                  <label class="labelCheck" for="checkJuridica"><input type="checkbox" class="configCheck" id="checkJuridica">  2 - Jurídica</label><br>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-4  col-12" style="padding-right: 2%;">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="consFinal">Consumidor Final</label>
                              <div class="row form-group checkboxMoeda" id="consFinal">
                                <div class="col-lg-12">
                                  <label class="labelCheck" for="checkSim"><input type="checkbox" class="configCheck" id="checkSim">  1 - Sim</label><br>
                                  <label class="labelCheck" for="checkNao"><input type="checkbox" class="configCheck" id="checkNao">  2 - Não</label><br>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-4  col-12">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="tipoVenda">Tipo Venda Item</label>
                              <div class="row form-group checkboxMoeda" id="tipoVenda">
                                <div class="col-lg-12">
                                  <label class="labelCheck" for="checkProducao"><input type="checkbox" class="configCheck" id="checkProducao">  0 - Produção</label><br>
                                  <label class="labelCheck" for="checkRevenda"><input type="checkbox" class="configCheck" id="checkRevenda">  1 - Revenda</label><br>
                                </div>
                              </div>
                            </div>
                            <div class="col-lg-12  col-12">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="porteCliente">Porte Cliente</label>
                              <div class="row form-group checkboxMoeda" id="porteCliente">
                                <div class="col-lg-3">
                                  <label class="labelCheck" for="checkSA"><input type="checkbox" class="configCheck" id="checkSA">  SA</label><br>
                                  <label class="labelCheck" for="checkLTDA"><input type="checkbox" class="configCheck" id="checkLTDA">  LTDA</label><br>
                                </div>
                                <div class="col-lg-3">
                                  <label class="labelCheck" for="checkSimples"><input type="checkbox" class="configCheck" id="checkSimples">  Simples</label><br>
                                  <label class="labelCheck" for="checkME"><input type="checkbox" class="configCheck" id="checkME">  ME</label><br>
                                </div>
                                <div class="col-lg-3">
                                  <label class="labelCheck" for="checkEPP"><input type="checkbox" class="configCheck" id="checkEPP">  EPP</label><br>
                                  <label class="labelCheck" for="checkNormal"><input type="checkbox" class="configCheck" id="checkNormal">  Normal</label><br>
                                </div>
                                <div class="col-lg-3">
                                  <label class="labelCheck" for="checkMEI"><input type="checkbox" class="configCheck" id="checkMEI">  MEI</label><br>
                                  <label class="labelCheck" for="checkEireli"><input type="checkbox" class="configCheck" id="checkEireli">  EIRELI</label><br>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <input type="button" name="avancar2" class="next action-button" value="Avançar" id="avancar2" />
                        <input type="button" name="voltar" class="previous action-button-previous" value="Voltar" id="voltar" />
                      </fieldset>
                      <fieldset>
                        <div class="form-card">
                          <h2 class="fs-title">Dados a serem alterados</h2>
                          <div class="row" id="campostouralteracao">
                            <div class="col-lg-12 col-12 d-flex justify-content-start">
                              <input type="button" name="btnICMS" class="action-button" value="ICMS" id="btnICMS">
                              <input type="button" name="btnIPI" class="action-button" value="IPI" id="btnIPI">
                              <input type="button" name="btnPISCOFINS" class="action-button" value="PIS/COFINS" id="btnPISCOFINS">
                            </div>

                            <div class="col-lg-12  col-12" style="margin-top: 1%;">
                              <label class="labelCheck" for="checkAplicaDesc"><input type="checkbox" class="configCheck" id="checkAplicaDesc">  Aplica Desconto</label>  
                              <label class="labelCheck" for="checkGeraDup"><input type="checkbox" class="configCheck" id="checkGeraDup">  Gera Duplicata</label>  
                              <label class="labelCheck" for="checkMVAZerada"><input type="checkbox" class="configCheck" id="checkMVAZerada">  MVA Zerada</label>
                            </div>

                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtReducaoMVA">Redução/MVA</label>
                              <div class="input-group">
                                <input type="text" value="0.0000" class="input-default focus form-control" id="txtReducaoMVA" name="txtReducaoMVA" class="form-control" placeholder="Redução/MVA">
                              </div>
                            </div>
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtAliqInternaUF">Alíq. interna da UF</label>
                              <div class="input-group">
                                <input type="text" value="0.00" class="input-default focus form-control" id="txtAliqInternaUF" name="txtAliqInternaUF" class="form-control" placeholder="Alíquota interna da UF">
                              </div>
                            </div>
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtPercFCP">Percentual FCP</label>
                              <div class="input-group">
                                <input type="text" value="0.00" class="input-default focus form-control" id="txtPercFCP" name="txtPercFCP" class="form-control" placeholder="Percentual FCP">
                              </div>
                            </div>
                            <!-- -->
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCredPresumido">Crédito presumido</label>
                              <div class="input-group">
                                <input type="text" value="0.00" class="input-default focus form-control" id="txtCredPresumido" name="txtCredPresumido" class="form-control" placeholder="Crédito presumido">
                              </div>
                            </div>
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtPercEfetivo">Percentual efetivo</label>
                              <div class="input-group">
                                <input type="text" value="0.00" class="input-default focus form-control" id="txtPercEfetivo" name="txtPercEfetivo" class="form-control" placeholder="Percentual efetivo">
                              </div>
                            </div>
                            <div class="col-lg-4  col-12 form-group">
                              <label data-error="wrong" class="labelGeral" data-success="right" for="txtPercRedBase">Perc. reduzido base ST</label>
                              <div class="input-group">
                                <input type="text" value="0.00" class="input-default focus form-control" id="txtPercRedBase" name="txtPercRedBase" class="form-control" placeholder="Percentual reduzido base ST">
                              </div>
                            </div>

                          </div>
                        </div>
                        <input type="button" name="btnGravar" class="action-button" value="Gravar" id="btnGravar" />
                        <input type="button" name="voltar2" class="previous action-button-previous" value="Voltar" id="voltar2" />
                      </fieldset>
                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  </div>
  <div class="modal fade" id="modalPISCOFINS" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Alterar PIS/COFINS</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group">
            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-9  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstPIS">CST PIS</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtCstPIS" name="txtCstPIS" class="form-control" placeholder="CST PIS">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCstPIS" name="btnCstPIS" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnACstPIS" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-3  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtAliquotaPIS">Alíquota</label>
                  <div class="input-group">
                    <input type="text" value="0.00" class="input-default focus form-control" id="txtAliquotaPIS" name="txtAliquotaPIS" class="form-control" placeholder="Alíquota">
                  </div>
                </div>

                <div class="col-lg-9  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstCOFINS">CST COFINS</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtCstCOFINS" name="txtCstCOFINS" class="form-control" placeholder="CST COFINS">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCstCOFINS" name="btnCstCOFINS" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnACstCOFINS" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-3  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtAliquotaCOFINS">Alíquota</label>
                  <div class="input-group">
                    <input type="text" value="0.00" class="input-default focus form-control" id="txtAliquotaCOFINS" name="txtAliquotaCOFINS" class="form-control" placeholder="Alíquota">
                  </div>
                </div>

                <div class="col-lg-12  col-12">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="configpiscofins">Configuração do valor de base (somar)</label>
                  <div class="row form-group checkboxMoeda" id="configpiscofins" style="margin-left: 0%; margin-right: 0%">
                    <div class="col-lg-6">
                      <label class="labelCheck" for="checkFretePISCOFINS"><input type="checkbox" class="configCheck" id="checkFretePISCOFINS">  Frete</label><br>
                    </div>
                    <div class="col-lg-6">
                      <label class="labelCheck" for="checkDespesaPISCOFINS"><input type="checkbox" class="configCheck" id="checkDespesaPISCOFINS">  Despesa</label><br>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarPISCOFINS" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalIPI" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Alterar IPI</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group">
            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-9  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCstIpi">CST IPI</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtCstIpi" name="txtCstIpi" class="form-control" placeholder="CST IPI">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCstIpi" name="btnCstIpi" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnACstIpi" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-3  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtAliquotaIPI">Alíquota</label>
                  <div class="input-group">
                    <input type="text" value="0.00" class="input-default focus form-control" id="txtAliquotaIPI" name="txtAliquotaIPI" class="form-control" placeholder="Alíquota">
                  </div>
                </div>
                <div class="col-lg-12  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtEnquadraIPI">Enquadramento IPI</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtEnquadraIPI" name="txtEnquadraIPI" class="form-control" placeholder="Enquadramento IPI">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnEnquadraIPI" name="btnEnquadraIPI" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnAEnquadraIPI" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-12  col-12">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="configipi">Configuração do valor de base (somar)</label>
                  <div class="row form-group checkboxMoeda" id="configipi" style="margin-left: 0%; margin-right: 0%">
                    <div class="col-lg-4">
                      <label class="labelCheck" for="checkFreteIPI"><input type="checkbox" class="configCheck" id="checkFreteIPI">  Frete</label><br>
                    </div>
                    <div class="col-lg-4">
                      <label class="labelCheck" for="checkDespesaIPI"><input type="checkbox" class="configCheck" id="checkDespesaIPI">  Despesa</label><br>
                    </div>
                    <div class="col-lg-4">
                      <label class="labelCheck" for="checkSeguroIPI"><input type="checkbox" class="configCheck" id="checkSeguroIPI">  Seguro</label><br>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarIPI" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalICMS" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Alterar ICMS</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group">
            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-3  col-3" style="margin-top: 1%;">
                  <label class="labelCheck" for="checkUsarAliquotaUF"><input type="checkbox" class="configCheck" id="checkUsarAliquotaUF">  Usar alíquota da UF</label>  
                </div>
                <div class="col-lg-3  col-3" style="margin-top: 1%;">
                  <label class="labelCheck" for="checkUsarCstItem"><input type="checkbox" class="configCheck" id="checkUsarCstItem">  Usar CST do item</label>  
                </div>
                <div class="col-lg-6  col-6" style="margin-top: 1%;">
                  <label class="labelCheck" for="descAliqEmp"><input type="checkbox" class="configCheck" id="descAliqEmp">  Desconsiderar Alíquota Empresa</label>  
                </div>
                <div class="col-lg-9  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtNaturezaICMS">Natureza</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtNaturezaICMS" name="txtNaturezaICMS" class="form-control" placeholder="Natureza">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnNaturezaICMS" name="btnNaturezaICMS" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnANaturezaICMS" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-3  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtAliquotaICMS">Alíquota</label>
                  <div class="input-group">
                    <input type="text" value="0.00" class="input-default focus form-control" id="txtAliquotaICMS" name="txtAliquotaICMS" class="form-control" placeholder="Alíquota">
                  </div>
                </div>
                <div class="col-lg-12  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtClatribICMS">Classificação tributária</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtClatribICMS" name="txtClatribICMS" class="form-control" placeholder="Classificação tributária">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnClatribICMS" name="btnClatribICMS" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnAClatribICMS" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-12  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCsosnICMS">CSOSN</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtCsosnICMS" name="txtCsosnICMS" class="form-control" placeholder="CSOSN">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnCsosnICMS" name="btnCsosnICMS" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnACsosnICMS" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-12  col-12">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="configICMS">Configuração do valor de base (somar)</label>
                  <div class="row form-group checkboxMoeda" id="configICMS" style="margin-left: 0%; margin-right: 0%">
                    <div class="col-lg-3">
                      <label class="labelCheck" for="checkIpiIcms"><input type="checkbox" class="configCheck" id="checkIpiIcms">  IPI</label><br>
                    </div>
                    <div class="col-lg-3">
                      <label class="labelCheck" for="checkDespesaICMS"><input type="checkbox" class="configCheck" id="checkDespesaICMS">  Despesa</label><br>
                    </div>
                    <div class="col-lg-3">
                      <label class="labelCheck" for="checkSeguroICMS"><input type="checkbox" class="configCheck" id="checkSeguroICMS">  Seguro</label><br>
                    </div>
                    <div class="col-lg-3">
                      <label class="labelCheck" for="checkFreteICMS"><input type="checkbox" class="configCheck" id="checkFreteICMS">  Frete</label><br>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarICMS" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalCFOP" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar CFOP</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group">
            <div class="col-lg-12">
              <table id="tabelaCFOP" class="table table-sm table-select table-hover">
                <thead>
                  <tr>
                    <th class="th-sm">CFOP</th>
                    <th class="th-sm">Descrição</th>
                    <th class="th-sm">Ações</th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-12  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCFOP">CFOP</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtCFOP" name="txtCFOP" class="form-control" placeholder="CFOP">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnbuscaCFOP" name="btnbuscaCFOP" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnACFOP" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-12 form-group">
                  <button class="btn bg-danger btn-block" id="btnAdicionarCFOP" name="btnAdicionarCFOP" data-button="absolute" type="button">
                    <label class="m-0 p-0">Adicionar</label>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarCFOP" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalCodSPED" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar Código SPED</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group">
            <div class="col-lg-12">
              <table id="tabelaCodSPED" class="table table-sm table-select table-hover">
                <thead>
                  <tr>
                    <th class="th-sm">Cod. SPED</th>
                    <th class="th-sm">Descrição</th>
                    <th class="th-sm">Ações</th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-12  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtCodSPED">Código SPED</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtCodSPED" name="txtCodSPED" class="form-control" placeholder="CodSPED">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnbuscaCodSPED" name="btnbuscaCodSPED" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnACodSPED" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-12 form-group">
                  <button class="btn bg-danger btn-block" id="btnAdicionarCodSPED" name="btnAdicionarCodSPED" data-button="absolute" type="button">
                    <label class="m-0 p-0">Adicionar</label>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarCodSPED" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalEntidAux" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar Entid. Aux</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group">
            <div class="col-lg-12">
              <table id="tabelaEntidAux" class="table table-sm table-select table-hover">
                <thead>
                  <tr>
                    <th class="th-sm">Entid. Aux</th>
                    <th class="th-sm">Descrição</th>
                    <th class="th-sm">Ações</th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-12  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtEntidAux">Entid. Aux</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtEntidAux" name="txtEntidAux" class="form-control" placeholder="EntidAux">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnbuscaEntidAux" name="btnbuscaEntidAux" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnAEntidAux" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-12 form-group">
                  <button class="btn bg-danger btn-block" id="btnAdicionarEntidAux" name="btnAdicionarEntidAux" data-button="absolute" type="button">
                    <label class="m-0 p-0">Adicionar</label>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarEntidAux" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalNCM" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar NCM</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group">
            <div class="col-lg-12">
              <table id="tabelaNCM" class="table table-sm table-select table-hover">
                <thead>
                  <tr>
                    <th class="th-sm">NCM</th>
                    <th class="th-sm">Descrição</th>
                    <th class="th-sm">Ações</th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
            <div class="col-lg-12">
              <div class="row">
                <div class="col-lg-12  col-12 form-group">
                  <label data-error="wrong" class="labelGeral" data-success="right" for="txtNCM">NCM</label>
                  <div class="input-group">
                    <input type="text" class="input-default focus form-control" id="txtNCM" name="txtNCM" class="form-control" placeholder="NCM">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btnbuscaNCM" name="btnbuscaNCM" data-button="absolute" type="button">
                        <i class="m-0 p-0 fas fa-search"></i>
                      </button>
                      <button class="btn bg-danger" id="btnANCM" type="button">
                        <i class="m-0 p-0 fas fa-trash"></i>
                      </button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-12 form-group">
                  <button class="btn bg-danger btn-block" id="btnAdicionarNCM" name="btnAdicionarNCM" data-button="absolute" type="button">
                    <label class="m-0 p-0">Adicionar</label>
                  </button>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarNCM" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalEstados" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar Estados</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group" style="margin-left: 5%;">
            <div class="col-lg-2">
              <label class="labelCheck" for="checkAC"><input type="checkbox" class="configCheck" id="checkAC">  AC</label><br>
              <label class="labelCheck" for="checkAL"><input type="checkbox" class="configCheck" id="checkAL">  AL</label><br>
              <label class="labelCheck" for="checkAM"><input type="checkbox" class="configCheck" id="checkAM">  AM</label><br>
              <label class="labelCheck" for="checkAP"><input type="checkbox" class="configCheck" id="checkAP">  AP</label><br>
              <label class="labelCheck" for="checkBA"><input type="checkbox" class="configCheck" id="checkBA">  BA</label><br>
            </div>
            <div class="col-lg-2">
              <label class="labelCheck" for="checkCE"><input type="checkbox" class="configCheck" id="checkCE">  CE</label><br>
              <label class="labelCheck" for="checkDF"><input type="checkbox" class="configCheck" id="checkDF">  DF</label><br>
              <label class="labelCheck" for="checkES"><input type="checkbox" class="configCheck" id="checkES">  ES</label><br>
              <label class="labelCheck" for="checkEX"><input type="checkbox" class="configCheck" id="checkEX">  EX</label><br>
              <label class="labelCheck" for="checkGO"><input type="checkbox" class="configCheck" id="checkGO">  GO</label><br>
            </div>
            <div class="col-lg-2">
              <label class="labelCheck" for="checkMA"><input type="checkbox" class="configCheck" id="checkMA">  MA</label><br>
              <label class="labelCheck" for="checkMG"><input type="checkbox" class="configCheck" id="checkMG">  MG</label><br>
              <label class="labelCheck" for="checkMS"><input type="checkbox" class="configCheck" id="checkMS">  MS</label><br>
              <label class="labelCheck" for="checkMT"><input type="checkbox" class="configCheck" id="checkMT">  MT</label><br>
              <label class="labelCheck" for="checkPA"><input type="checkbox" class="configCheck" id="checkPA">  PA</label><br>
            </div>
            <div class="col-lg-2">
              <label class="labelCheck" for="checkPB"><input type="checkbox" class="configCheck" id="checkPB">  PB</label><br>
              <label class="labelCheck" for="checkPE"><input type="checkbox" class="configCheck" id="checkPE">  PE</label><br>
              <label class="labelCheck" for="checkPI"><input type="checkbox" class="configCheck" id="checkPI">  PI</label><br>
              <label class="labelCheck" for="checkPR"><input type="checkbox" class="configCheck" id="checkPR">  PR</label><br>
              <label class="labelCheck" for="checkRJ"><input type="checkbox" class="configCheck" id="checkRJ">  RJ</label><br>
            </div>
            <div class="col-lg-2">
              <label class="labelCheck" for="checkRN"><input type="checkbox" class="configCheck" id="checkRN">  RN</label><br>
              <label class="labelCheck" for="checkRO"><input type="checkbox" class="configCheck" id="checkRO">  RO</label><br>
              <label class="labelCheck" for="checkRR"><input type="checkbox" class="configCheck" id="checkRR">  RR</label><br>
              <label class="labelCheck" for="checkRS"><input type="checkbox" class="configCheck" id="checkRS">  RS</label><br>
            </div>
            <div class="col-lg-2">
              <label class="labelCheck" for="checkSC"><input type="checkbox" class="configCheck" id="checkSC">  SC</label><br>
              <label class="labelCheck" for="checkSE"><input type="checkbox" class="configCheck" id="checkSE">  SE</label><br>
              <label class="labelCheck" for="checkSP"><input type="checkbox" class="configCheck" id="checkSP">  SP</label><br>
              <label class="labelCheck" for="checkTO"><input type="checkbox" class="configCheck" id="checkTO">  TO</label><br>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarEstados" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalEntidade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar Tributação da Entidade</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group" style="margin-left: 5%;">
            <div class="col-lg-12">
              <label class="labelCheck" for="checkA"><input type="checkbox" class="configCheck" id="checkA">  A - Normal s/ Substituição</label><br>
              <label class="labelCheck" for="checkN"><input type="checkbox" class="configCheck" id="checkN">  N - Normal c/ Substituição - Regime Normal</label><br>
              <label class="labelCheck" for="checkL"><input type="checkbox" class="configCheck" id="checkL">  L - Normal c/ Substituição - Simples Nacional</label><br>
              <label class="labelCheck" for="checkD"><input type="checkbox" class="configCheck" id="checkD">  D - Diferenciada c/ Substituição</label><br>
              <label class="labelCheck" for="checkS"><input type="checkbox" class="configCheck" id="checkS">  S - Simples</label><br>
              <label class="labelCheck" for="checkR"><input type="checkbox" class="configCheck" id="checkR">  R - Simples s/ Inscrição Estatual</label><br>
              <label class="labelCheck" for="checkC"><input type="checkbox" class="configCheck" id="checkC">  C - Carga Média</label><br>
              <label class="labelCheck" for="checkP"><input type="checkbox" class="configCheck" id="checkP">  P - Substituição com Alíq.Simples</label><br>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarEntidade" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalOrigem" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar Origem do Item</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group" style="margin-left: 5%;">
            <div class="col-lg-12">
              <label class="labelCheck" for="checkNormalOrig"><input type="checkbox" class="configCheck" id="checkNormalOrig">  N - Normal</label><br>
              <label class="labelCheck" for="checkDiferenciada"><input type="checkbox" class="configCheck" id="checkDiferenciada">  D - Diferenciada</label><br>
              <label class="labelCheck" for="check1"><input type="checkbox" class="configCheck" id="check1">  1 - Produto Importado</label><br>
              <label class="labelCheck" for="check2"><input type="checkbox" class="configCheck" id="check2">  2 - Produto Importado Mercado Interno</label><br>
              <label class="labelCheck" for="check3"><input type="checkbox" class="configCheck" id="check3">  3 - Conteúdo de importação maior 40% e inferior ou igual 70%</label><br>
              <label class="labelCheck" for="check4"><input type="checkbox" class="configCheck" id="check4">  4 - Conformidade Processos básicos</label><br>
              <label class="labelCheck" for="check5"><input type="checkbox" class="configCheck" id="check5">  5 - Conteúdo de importação menor ou igual 40%</label><br>
              <label class="labelCheck" for="check6"><input type="checkbox" class="configCheck" id="check6">  6 - Prod. Importdado sem similar nacional</label><br>
              <label class="labelCheck" for="check7"><input type="checkbox" class="configCheck" id="check7">  7 - Adquirido merc. interno sem similar nacional</label><br>
              <label class="labelCheck" for="check8"><input type="checkbox" class="configCheck" id="check8">  8 - Conteúdo de importação superior 70%</label><br>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarOrigem" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal fade" id="modalPresenca" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Selecionar Presença</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row form-group" style="margin-left: 5%;">
            <div class="col-lg-12">
              <label class="labelCheck" for="chkPresenca0"><input type="checkbox" class="configCheck" id="chkPresenca0">  0 - Não se aplica (por exemplo, Nota Fiscal complementar ou de ajuste)</label><br>
              <label class="labelCheck" for="chkPresenca1"><input type="checkbox" class="configCheck" id="chkPresenca1">  1 - Operação presencial</label><br>
              <label class="labelCheck" for="chkPresenca2"><input type="checkbox" class="configCheck" id="chkPresenca2">  2 - Operação não presencial, pela Internet</label><br>
              <label class="labelCheck" for="chkPresenca3"><input type="checkbox" class="configCheck" id="chkPresenca3">  3 - Operação não presencial, Teleatendimento</label><br>
              <label class="labelCheck" for="chkPresenca4"><input type="checkbox" class="configCheck" id="chkPresenca4">  4 - NFC-e em operação com entrega a domicílio</label><br>
              <label class="labelCheck" for="chkPresenca5"><input type="checkbox" class="configCheck" id="chkPresenca5">  5 - Operação presencial, fora do estabelecimento</label><br>
              <label class="labelCheck" for="chkPresenca9"><input type="checkbox" class="configCheck" id="chkPresenca9">  9 - Operação não presencial, outros</label><br>              
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <div class="row">
            <div class="col-sm-12">
              <button id="btnConfirmarPresenca" class="btn btn-danger"> Confirmar </button>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php
  include_once('../../../footer.php');
  ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  </div>

  <!-- jQuery -->
  <script src="../plugins/jquery/jquery.min.js?versao=3.237.17.1"></script>
  <script src="../plugins/jquery-ui/jquery-ui.min.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.237.17.1"></script>
  <!-- SweetAlert2 -->
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.237.17.1"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.237.17.1"></script>

  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>

  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.237.17.1"></script>
  <script src="../dist/js/adminlte.min.js?versao=3.237.17.1"></script>
  <script src="../dist/js/requisicoes.js?versao=3.237.17.1"></script>
  <script src="../dist/js/cliente/entidade.js?versao=3.237.17.1"></script>
  <script src="../dist/js/loadingoverlay.min.js?versao=3.237.17.1"></script>
  <script src="../dist/js/valida_cpf_cnpj.js?versao=3.237.17.1"></script>
  <script src="../plugins/jquery-validation/jquery.validate.min.js?versao=3.237.17.1"></script>
  <script src="../dist/js/sisplan.js?versao=3.237.17.1"></script>
  <script src="../utils/funcoes.js?versao=3.237.17.1"></script>
  <script src="../utils/cookies.js?versao=3.237.17.1"></script>
  <script src="../dist/js/driver.min.js?versao=3.237.17.1"></script>
  <script src="../dist/js/jquery.maskMoney.min.js?versao=3.237.17.1"></script>
  <script src="../dist/js/jquery.mask.min.js?versao=3.237.17.1"></script>
  <script src="../dist/js/dataTables.keyTable2.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="../config.js?versao=3.237.17.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('REGRAFISCAL');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      const permissaoUsuarioLogado = await permissaoAcessos("REGRAFISCAL");

      if (permissaoUsuarioLogado.INCLUI == 'N') {
        await criaMensagemErro("Sem permissão para incluir!", () => {
          window.location.href = `${BASE_URI}/regrafiscal`
        });
        return;
      }

      sArquivo = `${BASE_URI}/pages/reducao/cadastro_reducao/reducao.js?versao=3.237.17.1`;
      insereJavaScriptPagina(sArquivo);

      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>
</body>

</html>