// async function avancarPag() {
//   if ($("#txtCodigo").val() == '') {
//     $("#txtCodigo").val(0);
//   }
//   if ($("#txtMoeda").val() == '') {
//     $("#txtMoeda").val(' ');
//   }
//   if ($("#txtClasse").val() == '') {
//     $("#txtClasse").val(' ');
//   }
//   if ($("#txtHistorico").val() == '') {
//     $("#txtHistorico").val(' ');
//   }
// }

$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
      onNext: (Element) => {
        if ((Element.node.id == 'avancar1')) {
          avancarPag();
          $('#avancar1').trigger('click');
        };
        if ((Element.node.id == 'avancar2')) {
          $('#avancar2').trigger('click');
        };
        if ((Element.node.id == 'avancar3')) {
          $('#avancar3').trigger('click');
        };
      },
      onPrevious: (Element) => {
        if (Element.node.id == 'contas') {
          $('#voltar').trigger('click');
        }
        if (Element.node.id == 'tipoDep') {
          $('#voltar2').trigger('click');
        }
        if (Element.node.id == 'configuracao') {
          $('#voltar3').trigger('click');
        }
        if (Element.node.id == 'datatables') {
          $('#voltar4').trigger('click');
        }
      }
    });

    driver.defineSteps([{
      element: '#formcard1',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para o cadastro.',
        position: 'top'
      }
    },
    {
      element: '#txtCodigo',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtMoeda',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let queryString = window.location.href;
  let parametros = queryString.split('/');
  let codigo = parametros[parametros.length - 1];

  let contaFs = 1;

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('RAMOATIVIDADE', getCookie('usuario'), parametros[5]);
    window.location.href = `${BASE_URI}/ramoatividade`;
  });

  $('#tabelaPerfil').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    autowidth: true,
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "_TOTAL_ registros",
      "sInfoEmpty": " 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    },
  });

  $('#tabelaRamoAtuacao').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    autowidth: true,
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "_TOTAL_ registros",
      "sInfoEmpty": " 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    },
  });

  $('#tabelaGrupoProduto').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    autowidth: true,
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "_TOTAL_ registros",
      "sInfoEmpty": " 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    },
  });

  $('#txtPerfil').autocompleta(1, `JSON={ "tabela":"PERFIL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtRamoAtuacao').autocompleta(1, `JSON={ "tabela":"RAMO_ATUACAO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtGrupoProduto').autocompleta(1, `JSON={ "tabela":"GRUPO_PA", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

  $('#btnPerfil').pesquisa('#txtPerfil', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PERFIL", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conta Cliente', 'PERFIL');
  $('#btnRamoAtuacao').pesquisa('#txtRamoAtuacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"RAMO_ATUACAO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conta Cliente', 'RAMO_ATUACAO');
  $('#btnGrupoProduto').pesquisa('#txtGrupoProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conta Cliente', 'GRUPO_PA');

  // $('#btnAbrirRamoAtuacao').pesquisa_serversideSel('#tabelaRamoAtuacao', `{ "tabela":"RAMO_ATUACAO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}`, 'Pesquisa de Ramo de Atuação');
  $('#btnAbrirRamoAtuacao').on('click', function () {
    $('#modalRamoAtuacao').modal('show');
  });

  $('#btnAbrirGrupoProduto').on('click', function () {
    $('#modalGrupoProduto').modal('show');
  });

  $(document).ready(function () {
    let currentFs; let nextFs; let previousFs;
    let opacity;

    $(".next").click(function () {
      contaFs += 1;

      let validator = $("#msform").validate();
      validator.form();
      let erros = 0;
      erros = validator.numberOfInvalids();

      if (erros == 0) {

        currentFs = $(this).parent();
        nextFs = $(this).parent().next();

        $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

        nextFs.show();
        currentFs.animate({
          opacity: 0
        }, {
          step(now) {
            opacity = 1 - now;

            currentFs.css({
              'display': 'none',
              'position': 'relative'
            });
            nextFs.css({
              'opacity': opacity
            });
          },
          duration: 600
        });
      }
    });

    $('#msform').validate({
      debug: false,
      ignore: "",
      rules: {
        txtDescricao: {
          required: true,
        },
      },
      messages: {
        txtDescricao: {
          required: "Informe uma descrição válida.",
        }

      },
      errorElement: 'span',
      errorPlacement(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-group').append(error);
      },
      highlight(element) {
        $(element).addClass('is-invalid');
      },
      unhighlight(element) {
        $(element).removeClass('is-invalid');
      }
    });

    $(".previous").click(function () {

      contaFs -= 1;

      currentFs = $(this).parent();
      previousFs = $(this).parent().prev();
      $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");
      previousFs.show();
      currentFs.animate({
        opacity: 0
      }, {
        step(now) {
          opacity = 1 - now;
          currentFs.css({
            'display': 'none',
            'position': 'relative'
          });
          previousFs.css({
            'opacity': opacity
          });
        },
        duration: 600
      });
    });

    $(".submit").click(function () {
      return false;
    });
  });

  $('#btnAbrirPerfil').on('click', function () {
    $('#modalPerfil').modal('show');
  });

  if (codigo != '' && codigo != 'create') {
    $('#txtCodigo').attr('disabled', true);
    $.LoadingOverlay("show");
    try {
      $('#account').css('cursor', 'pointer');
      $('#payment').css('cursor', 'pointer');
      $('#personal').css('cursor', 'pointer');
      $('#confirm').css('cursor', 'pointer');

      const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
        `JSON={ "tabela":"SITCLI",
                  "camposSelect":["SITCLI.CODIGO, SITCLI.DESCRICAO"],
                  "where": ["SITCLI.CODIGO = '${codigo}'"]}`, null);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      $('#txtCodigo').val(codigo);
      $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);

      await buscaTipos();

    } catch (error) {
      console.error(error);
      msgErro(`Não foi possível buscar os dados da região: ${error}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function buscaTipos() {
    try {
      const tipos = ["R", "G", "P"];
      let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
        `JSON={ "tabela":"SITCLI_AUX",
                  "camposSelect":["SITCLI_AUX.CODIGO", "SITCLI_AUX.CODIGO_AUX", "PERFIL.DESCRICAO DESC_PERFIL", "RAMO_ATUACAO.DESCRICAO DESC_RAMO", "SITCLI_AUX.TIPO", "GRUPO_PA.DESCRICAO DESC_GRUPO"],
                  "leftJoin": [
                    {"tabela": "PERFIL", "condicao": "(PERFIL.CODIGO = SITCLI_AUX.CODIGO_AUX AND SITCLI_AUX.TIPO='P')"},
                    {"tabela": "RAMO_ATUACAO", "condicao": "(RAMO_ATUACAO.CODIGO = SITCLI_AUX.CODIGO_AUX AND SITCLI_AUX.TIPO='R')"},
                    {"tabela": "GRUPO_PA", "condicao": "(GRUPO_PA.CODIGO = SITCLI_AUX.CODIGO_AUX AND SITCLI_AUX.TIPO='G')"}
                   ],
                  "where": ["SITCLI_AUX.CODIGO = '${codigo}'"]}`, null);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();

      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      if (jsonStr.RESULT[0]) {
        preencheTabelas(tipos, jsonStr.RESULT[0]);
      }

    } catch (error) {
      console.error(error);
      msgErro(`Não foi possível buscar os dados da região: ${error}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#txtCodigo').on('blur', async function () {
    $('#txtCodigo').val(await RetornaProximo('SITCLI', 'SITCLI', 'CODIGO', 2));
    $('#txtCodigo').attr('disabled', true);
  });

  function preencheTabelas(tipos, array) {
    tipos.forEach(function (tipo) {
      let indices = array
        .map(function (e, i) {
          return e.TIPO === tipo ? i : -1;
        })
        .filter(function (i) {
          return i !== -1;
        });

      indices.forEach(function (indice) {
        const valor = array[indice];
        valor.TIPO == 'P' ? preencheTabelaPerfil(valor)
          : valor.TIPO == 'R' ? preencheTabelaRamo(valor)
            : valor.TIPO == 'G' ? preencheTabelaGrupo(valor) : null;
      });
    });
  }

  function preencheTabelaPerfil(dados) {
    $('#tabelaPerfil').DataTable().row.add([
      dados.CODIGO,
      dados.CODIGO_AUX,
      dados.DESC_PERFIL,
      '<div style="text-align:center; display: flex; gap: 2px;"> ' +
      '   <button class="btn btn-info btn-sm" id="btnExcluirPerfil" type="button"> ' +
      '      Excluir' +
      '   </button> ' +
      '</div>'
    ]).draw(false)
  }

  function preencheTabelaRamo(dados) {
    $('#tabelaRamoAtuacao').DataTable().row.add([
      dados.CODIGO,
      dados.CODIGO_AUX,
      dados.DESC_RAMO,
      '<div style="text-align:center; display: flex; gap: 2px;"> ' +
      '   <button class="btn btn-info btn-sm" id="btnExcluirRamo" type="button"> ' +
      '      Excluir' +
      '   </button> ' +
      '</div>'
    ]).draw(false)
  }

  function preencheTabelaGrupo(dados) {
    $('#tabelaGrupoProduto').DataTable().row.add([
      dados.CODIGO,
      dados.CODIGO_AUX,
      dados.DESC_GRUPO,
      '<div style="text-align:center; display: flex; gap: 2px;"> ' +
      '   <button class="btn btn-info btn-sm" id="btnExcluirGrupo" type="button"> ' +
      '      Excluir' +
      '   </button> ' +
      '</div>'
    ]).draw(false)
  }

  $('#btnConfirmaPerfil').on('click', function () {
    $('#tabelaPerfil').DataTable().data().map((item) => {
      if (item[1] === pegaChave('#txtPerfil')) {
        throw msgAlerta('Perfil já existe na tabela. Verifique!')
      }
    })
    array = [{
      CODIGO: $('#txtCodigo').val(),
      CODIGO_AUX: pegaChave('#txtPerfil'),
      DESC_PERFIL: pegaDescricao('#txtPerfil')
    }]
    preencheTabelaPerfil(array[0]);
    $('#txtPerfil').val('');
  });

  $('#btnConfirmaRamoAtuacao').on('click', function () {
    $('#tabelaRamoAtuacao').DataTable().data().map((item) => {
      if (item[1] === pegaChave('#txtRamoAtuacao')) {
        throw msgAlerta('Ramo de Atuação já existe na tabela. Verifique!')
      }
    })
    array = [{
      CODIGO: $('#txtCodigo').val(),
      CODIGO_AUX: pegaChave('#txtRamoAtuacao'),
      DESC_RAMO: pegaDescricao('#txtRamoAtuacao')
    }]
    preencheTabelaRamo(array[0]);
    $('#txtRamoAtuacao').val('')
  });

  $('#btnConfirmarGrupo').on('click', function () {
    $('#tabelaGrupoProduto').DataTable().data().map((item) => {
      if (item[1] === pegaChave('#txtGrupoProduto')) {
        throw msgAlerta('Grupo de Produto já existe na tabela. Verifique!')
      };
    })
    array = [{
      CODIGO: $('#txtCodigo').val(),
      CODIGO_AUX: pegaChave('#txtGrupoProduto'),
      DESC_GRUPO: pegaDescricao('#txtGrupoProduto')
    }]
    preencheTabelaGrupo(array[0]);
    $('#txtGrupoProduto').val('')
  });

  $('#account').on('click', function () {
    if (codigo != 'create') {
      if (contaFs == 2) {
        $('#voltar').trigger('click');
      }
      if (contaFs == 3) {
        $('#voltar3').trigger('click');
        $('#voltar').trigger('click');
      }
      if (contaFs == 4) {
        $('#voltar4').trigger('click');
        $('#voltar3').trigger('click');
        $('#voltar').trigger('click');
      }
    }
  });

  $('#payment').on('click', function () {
    if (codigo != 'create') {
      if (contaFs == 1) {
        $('#avancar1').trigger('click');
      }
      if (contaFs == 3) {
        $('#voltar3').trigger('click');
      }
      if (contaFs == 4) {
        $('#voltar4').trigger('click');
        $('#voltar3').trigger('click');
      }
    }
  });

  $('#personal').on('click', function () {
    if (codigo != 'create') {
      if (contaFs == 1) {
        $('#avancar1').trigger('click');
        $('#avancar2').trigger('click');
        $($('fieldset')[0]).css('display', 'none');
      }
      if (contaFs == 2) {
        $('#avancar2').trigger('click');
      }
      if (contaFs == 4) {
        $('#voltar4').trigger('click');
      }
    }
  });

  $('#confirm').on('click', function () {
    if (codigo != 'create') {
      if (contaFs == 1) {
        $('#avancar1').trigger('click');
        $('#avancar2').trigger('click');
        $('#avancar3').trigger('click');
        $($('fieldset')[0]).css('display', 'none');
        $($('fieldset')[1]).css('display', 'none');
      }
      if (contaFs == 2) {
        $('#avancar2').trigger('click');
        $('#avancar3').trigger('click');
        $($('fieldset')[0]).css('display', 'none');
        $($('fieldset')[1]).css('display', 'none');
      }
      if (contaFs == 3) {
        $('#avancar3').trigger('click');
      }
    }
  });

  function buscaDadosTabelas() {
    let grid = [];

    $('#tabelaPerfil').DataTable().data().toArray().map((item) => {
      let obj = {
        CODIGO: item[0],
        CODIGO_AUX: item[1],
        TIPO: 'P',
      }
      grid.push(obj);
    })
    $('#tabelaRamoAtuacao').DataTable().data().toArray().map((item) => {
      let obj = {
        CODIGO: item[0],
        CODIGO_AUX: item[1],
        TIPO: 'R',
      }
      grid.push(obj);
    });

    $('#tabelaGrupoProduto').DataTable().data().toArray().map((item) => {
      let obj = {
        CODIGO: item[0],
        CODIGO_AUX: item[1],
        TIPO: 'G',
      }
      grid.push(obj);
    })
    return grid;
  }

  $("#gravar").click(async function () {
    try {
      if ($('#txtCodigo').val() == '') {
        throw msgAlerta('Código não informado, verifique!');
      }
      if ($('#txtDescricao').val() == '') {
        throw msgAlerta('Descricao não informada, verifique!');
      }
      $.LoadingOverlay('show');
      try {

        let arr = buscaDadosTabelas();

        item = {
          CODIGO: $('#txtCodigo').val(),
          DESCRICAO: $('#txtDescricao').val(),
          listaSit: arr
        };

        const response = await requisicao('POST', `/sisplan/cadastros/V1/ramoatividade?`, '', `JSON=${JSON.stringify(item)}`, 90000);

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgAlerta(jsonStr.mensagem);
          return;
        }

        toastr
          .success("Cadastro efetuado com sucesso!", "Confirmação", {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              window.location.href = `${BASE_URI}/ramoatividade`;
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });

      } catch (error) {
        console.error(error);
        msgAlerta('Não foi possível gravar os dados!');
      }

    } finally {
      $.LoadingOverlay("hide");
      await deletaRegistro("RAMOATIVIDADE", getCookie("usuario"), codigo);
    }
  });

  $('#tabelaRamoAtuacao').on("click", "#btnExcluirRamo", function () {
    const data = $("#tabelaRamoAtuacao").DataTable().row($(this).parents("tr"));
    data.remove().draw(false);
  });

  $('#tabelaPerfil').on('click', "#btnExcluirPerfil", function () {
    const data = $("#tabelaPerfil").DataTable().row($(this).parents("tr"));
    data.remove().draw(false);
  });

  $('#tabelaGrupoProduto').on('click', "#btnExcluirGrupo", function () {
    const data = $("#tabelaGrupoProduto").DataTable().row($(this).parents("tr"));
    data.remove().draw(false);
  });

});
