/* eslint-disable prefer-destructuring */
$('#tutorial').on('click', function () {
    $('#geral-tab').trigger('click');
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            onHighlightStarted: (Element) => {
                if (Element.node.id == 'geral') {
                    if (!$('#multiCollapseExample1').hasClass('show'));
                    $('#multiCollapseExample1').collapse('show');
                } else if (Element.node.id == 'documentoaba') {
                    if (!$('#collapseFiltros').hasClass('show')) {
                        $('#documento').collapse('show');
                        $('#multiCollapseExample2').collapse('show');
                    }
                } else if (Element.node.id == 'endereco') {
                    if (!$('#multiCollapseExample3').hasClass('show')) {
                        $('#multiCollapseExample3').collapse('show');
                        $('#enderecoGeral').collapse('show');
                    }
                } else if (Element.node.id == 'geral') {
                    if (!$('#collapseFiltros').hasClass('show')) {
                        $('#endereco_geral-tab').trigger('click');
                    }
                } else if (Element.node.id == 'endereco_entrega_geral') {
                    if (!$('#collapseFiltros').hasClass('show')) {
                        $('#enderecoEntrega').collapse('show');
                    }
                } else if (Element.node.id == 'endereco_cobranca_geral') {
                    if (!$('#collapseFiltros').hasClass('show')) {
                        $('#enderecoCobranca').collapse('show');
                    }
                } else if (Element.node.id == 'venda') {
                    if (!$('#collapseFiltros').hasClass('show')) {
                        $('#multiCollapseExample3').collapse('show');
                    }
                } else if (Element.node.id == 'compra') {
                    if (!$('#collapseFiltros').hasClass('show')) {
                        $('#multiCollapseExample4').collapse('show');
                    }
                }
            },
            onPrevious: (Element) => {
                if ((Element.node.id == 'documento-tab') || (Element.node.id == 'documentoaba')) {
                    if (!$('#geral>a').hasClass('collapsed')) {
                        $('#multiCollapseExample2').collapse('show');
                        // $('#geral').addClass('active show');
                    }
                } else if (Element.node.id == 'endereco') {
                    if (!$('#documento>a').hasClass('collapsed')) {
                        $('#documentoaba').collapse('show');
                        // $('#documento').addClass('active show');
                    }
                } else if (Element.node.id == 'endereco_entrega_geral-tab') {
                    if (!$('#endereco_geral').hasClass('active')) {
                        $('#endereco_geral-tab').trigger('click');
                        $('#endereco_geral').addClass('active show');
                    }
                } else if (Element.node.id == 'endereco_cobranca_geral-tab') {
                    if (!$('#endereco_entrega_geral').hasClass('active')) {
                        $('#endereco_entrega_geral-tab').trigger('click');
                        $('#endereco_entrega_geral').addClass('active show');
                    }
                }
            }
        });

        driver.defineSteps([{
            element: '#geral-tab',
            popover: {
                title: 'Aba Geral',
                description: 'Clique aqui para abrir a aba geral.',
                position: 'top'
            }
        },
        {
            element: '#geral',
            popover: {
                title: 'Cadastro Geral',
                description: 'Aqui você pode informar os dados gerais de cadastro do produto.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample1',
            popover: {
                title: 'Dados de Cadastro Geral',
                description: 'Esses são os campos que você informará os dados gerais de cadastro.',
                position: 'top'
            }
        },
        {
            element: '#tourcodigo',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourdesc',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourfaixa',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourund',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourundvenda',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourcolecao',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourgrupo',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourstatus',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourtabelacores',
            popover: {
                title: 'Tabela Cores',
                description: 'Aqui fica a tabela onde você pode inserir as cores.',
                position: 'top'
            }
        },
        {
            element: '#documentoaba',
            popover: {
                title: 'Aba Tributações',
                description: 'Clique aqui para abrir aba tributações.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample2',
            popover: {
                title: 'Dados de Tributações',
                description: 'Aqui ficam os dados de tributações a serem preenchidos.',
                position: 'top'
            }
        },
        {
            element: '#tourncm',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#touricms',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#toursped',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#toureipi',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#toursipi',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#tourposse',
            popover: {
                title: 'Campos Obrigatórios',
                description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#venda',
            popover: {
                title: 'Aba Cadastro de Cores',
                description: 'Aqui você pode adicionar as cores que o produto possui.',
                position: 'top'
            }
        },
        {
            element: '#compra',
            popover: {
                title: 'Aba Cadastro de Tipo de Venda/Regra',
                description: 'Aqui você pode adicionar os tipos de venda/regra ao produto.',
                position: 'top'
            }
        },
        {
            element: '#tourtabelavenda',
            popover: {
                title: 'Tabela Tipo de Venda/Regra',
                description: 'Aqui fica a tabela onde você pode inserir os tipos de venda/regra.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Ao clicar nesse botão você grava os dados inseridos.',
                position: 'left'
            }
        }
        ]);

        driver.start();
    });
});
$(document).ready(async function () {

    $('#txtCodigo').prop('disabled', true);
    $('#txtCodigo').prop('readonly', true);

    $('#checkAtivo').attr('checked', true);

    let tipoVendaPadrao = '';

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('PRODUTO', getCookie('usuario'), parametros[5]);
        window.location.href = `${BASE_URI}/produto`;
    });


    $('#txtPesoLiq').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtPesoMed').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtCusto').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtPrecoCompra').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtPrecoVenda').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtPrecoRepos').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtIpi').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });
    $('#txtIcms').maskMoney({
        decimal: '.',
        thousands: '',
        precision: 2
    });

    $('#tabelaVendaRegra').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        autowidth: true,
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        },
    });

    $('#tabelaFaixaCor').DataTable({
        scrollY: "160px",
        scrollCollapse: true,
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        autowidth: true,
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        }
    });

    $('#tabelaContas').DataTable({
        paging: false,
        filter: false,
        info: false,
        order: false,
        destroy: true,
        autowidth: true,
        "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
                "sNext": "Próximo",
                "sPrevious": "Anterior",
                "sFirst": "Primeiro",
                "sLast": "Último"
            },
            "oAria": {
                "sSortAscending": ": Ordenar colunas de forma ascendente",
                "sSortDescending": ": Ordenar colunas de forma descendente"
            }
        },
    });

    $('.radio-group .radio').click(function () {
        $(this).parent().find('.radio').removeClass('selected');
        $(this).addClass('selected');
    });

    $(".submit").click(function () {
        return false;
    });

    $('#btnTributacoes').on('click', function () {
        $('#modalTrib').modal('show');
    });

    $('#btnFaixaCor').on('click', function () {
        $('#modalFaixaCor').modal('show');
    });

    $('#btnVendaRegra').on('click', function () {
        $('#modalVendaRegra').modal('show');
    });

    // autocompleta
    $('#txtFaixaTam').autocompleta(1, `JSON={ "tabela":"faixa", "camposSelect":[ "codigo chave", "descricao descricao"], "where": ["ativo = 'S'"]}`);
    $('#txtUnidade').autocompleta(1, `JSON={ "tabela":"unidade", "camposSelect":[ "unidade chave", "descricao descricao"], "where": null}`);
    $('#txtUnidadeVenda').autocompleta(1, `JSON={ "tabela":"unidade", "camposSelect":[ "unidade chave", "descricao descricao"], "where": null}`);
    $('#txtUnidadeExp').autocompleta(1, `JSON={ "tabela":"unidade", "camposSelect":[ "unidade chave", "descricao descricao"], "where": null}`);
    $('#txtColecao').autocompleta(1, `JSON={ "tabela":"colecao", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCodFornec').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
    $('#txtStatus').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtGrupo').autocompleta(1, `JSON={ "tabela":"GRUPO_PA", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtMarca').autocompleta(1, `JSON={ "tabela":"MARCA", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtEtiqueta').autocompleta(1, `JSON={ "tabela":"ETQ_PROD", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCodCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
    $('#txtLinha').autocompleta(1, `JSON={ "tabela":"tablin", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtNcm').autocompleta(1, `JSON={ "tabela":"tabfis", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCstIcms').autocompleta(1, `JSON={ "tabela":"TABTRI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCstIpiSaida').autocompleta(1, `JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCstIpiEntrada').autocompleta(1, `JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtSped').autocompleta(1, `JSON={ "tabela":"TABSPED", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtEnqIpi').autocompleta(1, `JSON={ "tabela":"ENQUADRA", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtNatureza').autocompleta(1, `JSON={ "tabela":"NATUREZA", "camposSelect":[ "natureza chave", "descricao descricao"], "where": null}`);
    $('#txtEmpresaRegra').autocompleta(1, `JSON={ "tabela":"empresa", "camposSelect":[ "emp_pat chave, emp_nome descricao" ], "where": null}`);
    $('#txtRegra').autocompleta(1, `JSON={ "tabela":"regra", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtCondPagto').autocompleta(1, `JSON={ "tabela":"cadcor", "camposSelect":[ "cor chave", "descricao descricao"], "where": null}`);

    $('#txtEmpresaRegra').change(async function () {
        valor = $('#txtEmpresaRegra').val();
        $('#txtEmpresaRegra').val(valor.replace('_', ''));
    });

    // abre o pesquisa
    $('#btnNcm').pesquisa('#txtNcm', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABFIS", "camposSelect":[ "codigo", "descricao", "tipo"]}`, 'Pesquisa NCM', 'TABFIS');
    $('#btnCstIcms').pesquisa('#txtCstIcms', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa CST ICMS', 'TABTRI');
    $('#btnCstIpiSaida').pesquisa('#txtCstIpiSaida', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa IPI Saída', 'TABIPI');
    $('#btnCstIpiEntrada').pesquisa('#txtCstIpiEntrada', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABIPI", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa IPI Entrada', 'TABIPI');
    $('#btnSped').pesquisa('#txtSped', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABSPED", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Código SPED', 'TABSPED');
    $('#btnEnqIpi').pesquisa('#txtEnqIpi', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENQUADRA", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Enquadramento IPI', 'ENQUADRA');
    $('#btnNatureza').pesquisa('#txtNatureza', 'NATUREZA', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"NATUREZA", "camposSelect":[ "natureza", "descricao"]}`, 'Pesquisa Natureza', 'NATUREZA');
    $('#btnEmpresaRegra').pesquisa('#txtEmpresaRegra', 'EMP_PAT', 'EMP_NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"empresa", "camposSelect":[ "replace(emp_pat,'_','') as EMP_PAT", "emp_nome"]}`, 'Pesquisa Empresa', 'empresa');
    $('#btnRegra').pesquisa('#txtRegra', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regra", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Regra', 'regra');
    $('#btnCodFornerc').pesquisa('#txtCodFornec', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`, 'Pesquisa Fornecedor', 'entidade');
    $('#btnFaixaTam').pesquisa('#txtFaixaTam', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"faixa", "camposSelect":[ "codigo", "descricao"], "where": ["ativo = 'S'"]}`, 'Pesquisa Faixa de Tamanho', 'faixa');
    $('#btnGrupo').pesquisa('#txtGrupo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_PA", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Grupo', 'GRUPO_PA');
    $('#btnMarca').pesquisa('#txtMarca', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MARCA", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Marca', 'marca');
    $('#btnEtiqueta').pesquisa('#txtEtiqueta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ETQ_PROD", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Etiqueta', 'ETQ_PROD');
    $('#btnCodCliente').pesquisa('#txtCodCliente', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`, 'Pesquisa Fornecedor', 'entidade');
    $('#btnColecao').pesquisa('#txtColecao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"colecao", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Coleção', 'colecao');
    $('#btnLinha').pesquisa('#txtLinha', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tablin", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Linha', 'tablin');
    $('#btnStatus').pesquisa('#txtStatus', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"SITPROD", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Status', 'SITPROD');
    $('#btnTag').pesquisa('#txtTag', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADTAG", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa TAG', 'CADTAG');
    $('#btnFaixaDesc').pesquisa('#txtFaixaDesc', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"FAIXA_DESCONTO", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Faixa Desconto', 'FAIXA_DESCONTO');
    $('#btnUnidade').pesquisa('#txtUnidade', 'UNIDADE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"unidade", "camposSelect":[ "unidade", "descricao"]}`, 'Pesquisa Unidade', 'unidade');
    $('#btnUnidadeVenda').pesquisa('#txtUnidadeVenda', 'UNIDADE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"unidade", "camposSelect":[ "unidade", "descricao"]}`, 'Pesquisa Unidade', 'unidade');
    $('#btnUnidadeExp').pesquisa('#txtUnidadeExp', 'UNIDADE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"unidade", "camposSelect":[ "unidade", "descricao"]}`, 'Pesquisa Unidade', 'unidade');

    // limpa campos
    $('#btnANcm').on('click', function () {
        $('#txtNcm').val('');
    });
    $('#btnACstIcms').on('click', function () {
        $('#txtCstIcms').val('');
    });
    $('#btnACstIpiSaida').on('click', function () {
        $('#txtCstIpiSaida').val('');
    });
    $('#btnACstIpiEntrada').on('click', function () {
        $('#txtCstIpiEntrada').val('');
    });
    $('#btnASped').on('click', function () {
        $('#txtSped').val('');
    });
    $('#btnAEnqIpi').on('click', function () {
        $('#txtEnqIpi').val('');
    });
    $('#btnANatureza').on('click', function () {
        $('#txtNatureza').val('');
    });
    $('#btnAEmpresaRegra').on('click', function () {
        $('#txtEmpresaRegra').val('');
    });
    $('#btnARegra').on('click', function () {
        $('#txtRegra').val('');
    });
    $('#btnACodFornerc').on('click', function () {
        $('#txtCodFornec').val('');
    });
    $('#btnAFaixaTam').on('click', function () {
        $('#txtFaixaTam').val('');
    });
    $('#btnAGrupo').on('click', function () {
        $('#txtGrupo').val('');
    });
    $('#btnAMarca').on('click', function () {
        $('#txtMarca').val('');
    });
    $('#btnAEtiqueta').on('click', function () {
        $('#txtEtiqueta').val('');
    });
    $('#btnACodCliente').on('click', function () {
        $('#txtCodCliente').val('');
    });
    $('#btnAColecao').on('click', function () {
        $('#txtColecao').val('');
    });
    $('#btnALinha').on('click', function () {
        $('#txtLinha').val('');
    });
    $('#btnAStatus').on('click', function () {
        $('#txtStatus').val('');
    });
    $('#btnATag').on('click', function () {
        $('#txtTag').val('');
    });
    $('#btnAFaixaDesc').on('click', function () {
        $('#txtFaixaDesc').val('');
    });
    $('#btnAUnidade').on('click', function () {
        $('#txtUnidade').val('');
    });
    $('#btnAUnidadeVenda').on('click', function () {
        $('#txtUnidadeVenda').val('');
    });
    $('#btnAUnidadeExp').on('click', function () {
        $('#txtUnidadeExp').val('');
    });
    $('#btnAbrirCondicao').on('click', function () {
        $('#modalCondicao').modal('show');
        $('#btn-limpa-CondPagto').trigger('click');
    });
    $('#btnAbrirVendaRegra').on('click', function () {
        $('#modalAdicionarVendaRegra').modal('show');
    });
    $('#btn-limpa-CondPagto').on('click', function () {
        $('#txtCondPagto').val('');
    });

    $('#btnAdicionar').on('click', async function () {
        let desc = $('#txtCondPagto').val();
        if (desc == '') {
            msgAlerta('Campo deve ser preenchido');
            return;
        }
        addValorCond();
        $('#txtCondPagto').val('');
        ;
    });

    async function addValorCond() {
        let codCond = pegaChave('#txtCondPagto');
        let descCond = pegaDescricao('#txtCondPagto');
        $('#tabelaFaixaCor').DataTable().row.add([codCond, descCond,
            '<div style="text-align:start;"> ' +
            '   <button class="btn btn-info btn-sm" id="btnExluirCond" type="button"> ' +
            '      Excluir' +
            '   </button> ' +
            '</div>'
        ]).draw(false);
    };

    $('#tabelaFaixaCor').on('click', '#btnExluirCond', async function () {
        let table = $('#tabelaFaixaCor').DataTable();
        table
            .row($(this).parents('tr'))
            .remove()
            .draw(false);
    });

    $('#tabelaVendaRegra').on('click', '#btnExluirCond', async function () {
        let table = $('#tabelaVendaRegra').DataTable();
        table
            .row($(this).parents('tr'))
            .remove()
            .draw(false);
    });

    $('#btnAdicionarTipoRegra').on('click', async function () {
        let desc = $('#txtTipoVenda').val();
        if (desc == '') {
            msgAlerta('Campo deve ser preenchido!');
            return;
        }
        addTipoRegra();
        $('#txtTipoVenda').val('');
        $('#txtEmpresaRegra').val('');
        $('#txtRegra').val('');
        ;
    });

    async function addTipoRegra() {
        try {
            $.LoadingOverlay('show');
            let tipoVenda = $('#txtTipoVenda').val();
            let empresaTipo = pegaChave('#txtEmpresaRegra');
            let regra = pegaChave('#txtRegra');
            let regraDesc = pegaDescricao('#txtRegra');
            $('#tabelaVendaRegra').DataTable().row.add([tipoVenda, empresaTipo, regra, regraDesc,
                '<div style="text-align:center;"> ' +
                '   <button class="btn btn-info btn-sm" id="btnExluirTipo" type="button"> ' +
                '      Excluir' +
                '   </button> ' +
                '</div>'
            ]).draw(false);

            toastr.success(
                `Registro adicionado com sucesso!`,
                'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 5000,
                fadeOut: 3000
            }
            ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
            });

        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#tabelaVendaRegra').on('click', '#btnExluirTipo', async function () {
        let table = $('#tabelaVendaRegra').DataTable();
        table
            .row($(this).parents('tr'))
            .remove()
            .draw(false);
    });

    $('#msform').validate({
        debug: false,
        ignore: "",
        rules: {
            txtDescricao: {
                required: true,
            },
            txtFaixaTam: {
                required: true,
            },
            txtUnidade: {
                required: true,
            },
            txtUnidadeVenda: {
                required: true,
            },
            txtStatus: {
                required: true,
            },
            txtGrupo: {
                required: true,
            },
            txtNcm: {
                required: true,
            },
            txtCstIcms: {
                required: true,
            },
            txtSped: {
                required: true,
            },
            txtCstIpiEntrada: {
                required: true,
            },
            txtCstIpiSaida: {
                required: true,
            }
        },
        messages: {
            txtDescricao: {
                required: "Informe uma descrição válida.",
            },
            txtFaixaTam: {
                required: "Informe uma faixa de tamanho válida.",
            },
            txtUnidade: {
                required: "Informe uma unidade válida."
            },
            txtUnidadeVenda: {
                required: "Informe uma unidade válida."
            },
            txtStatus: {
                required: "Informe um status válido."
            },
            txtGrupo: {
                required: "Informe um grupo válido."
            },
            txtNcm: {
                required: "Informe um NCM válido."
            },
            txtCstIcms: {
                required: "Informe um CST ICMS válido."
            },
            txtSped: {
                required: "Informe um SPED válido."
            },
            txtCstIpiEntrada: {
                required: "Informe um CST IPI válido."
            },
            txtCstIpiSaida: {
                required: "Informe um CST IPI válido."
            }
        },
        errorElement: 'span',
        errorPlacement(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight(element) {
            $(element).removeClass('is-invalid');
        }
    });

    async function buscaFoto(codigo) {
        try {
            let urlRequisicao = '/Sisplan/Funcoes/v1/FotoItem?';
            let response = await requisicao('GET', urlRequisicao, `codigo=${codigo}`, null);

            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
                $("#infoprodimagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
                return;
            }

            let sBase64 = jsonStr;
            $("#infoprodimagem").attr('src', `data:image/png;base64,${sBase64.mensagem}`);

        } catch (error) {
            console.error(error);
            $("#infoprodimagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        }
    };

    async function verificaSeCorExiste(CorInformada) {
        const PesquisaCor = {
            tabela: 'CADCOR',
            camposSelect: ['CADCOR.COR'],
            where: [`CADCOR.COR = '${CorInformada}'`]
        };

        const jsonStrCor = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaCor));

        if (jsonStrCor.length > 0) {
            return true
        } else {
            return false
        };
    };

    async function verificaSeFaixaExiste(FaixaInformada) {
        const PesquisaFaixa = {
            tabela: 'FAIXA',
            camposSelect: ['CODIGO'],
            where: [`FAIXA.CODIGO = '${FaixaInformada}'`]
        };

        const jsonStrFaixa = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaFaixa));

        if (jsonStrFaixa.length > 0) {
            return true
        } else {
            return false
        };
    };

    $('#fileimagem').change(async function () {

        try {
            $.LoadingOverlay("show");
            const leitorDeArquivos = new FileReader();
            const previaDaImagem = document.querySelector('.imagem');
            const inputArquivo = document.querySelector('.upload');

            let imagemEnviada = inputArquivo.files[0];
            leitorDeArquivos.readAsDataURL(imagemEnviada);
            leitorDeArquivos.addEventListener('loadend', function (load) {
                previaDaImagem.src = load.target.result;
            });

        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btn-CondPagto').pesquisa('#txtCondPagto', 'COR', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadcor", "camposSelect":["cor", "descricao"]}`, 'Pesquisa Cor', 'cadcor');

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let produto = parametros[parametros.length - 1];
    await buscaFoto(produto);

    if (produto != 'create') {
        try {
            let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"produto_ordem",
            "camposSelect":["CODIGO"],
            "where": ["codigo = '${produto}'"]}`, null);
            let jsonStr = await response.json();

            if (jsonStr.RESULT[0] != '') {
                $('#txtFaixaTam').attr('readonly', true);
                $('#btnFaixaTam').addClass('d-none');
                $('#btnAFaixaTam').addClass('d-none');
            }
        } catch (error) {
            console.error(error);
        }

        try {
            response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"pcpft2",
            "camposSelect":["CODIGO"],
            "where": ["codigo = '${produto}'"]}`, null);
            jsonStr = await response.json();

            if (jsonStr.RESULT[0] != '') {
                $('#txtFaixaTam').attr('readonly', true);
                $('#btnFaixaTam').addClass('d-none');
                $('#btnAFaixaTam').addClass('d-none');
            }
        } catch (error) {
            console.error(error);
        }

        $('#txtCodigo').attr('readonly', true);
    }

    if (produto != '' && produto != 'create') {

        // if (await liberarRegistro('PRODUTO', produto) == false) {
        //     window.location.href = '../produto';
        // } else {

        try {
            $.LoadingOverlay("show");
            try {
                let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"produto",
            "camposSelect":["CODIGO", "DESCRICAO", "CODIGO2", "PROTOTIPO", "QTDE_MIN", "COMP1",
                            "PESO_TALHADO", "PESO", "CUSTO", "PRECO_COM", "PRECO", "PRECO_REPOS",
                            "CODEXTIPI", "IPI", "ICMS", "ATIVO", "LIBERADO", "FAIXA", "FORNECEDOR",
                            "GRUPO", "CODCLI", "STATUS", "MARCA", "COLECAO", "ETIQUETA", "LINHA",
                            "FAIXA_DESCONTO", "UNIDADE", "UNI_VENDA", "UNI_EXP", "CODFIS", "CODTRIB", "CODIPI",
                            "CODIPI_ENT", "CODSPED", "NATUREZA", "ENQUADRA", "TIPO_IMPORTACAO", "POSSE",
                            "TRIBUTACAO", "ECF_TRIB"
                            ],
            "where": ["codigo = '${produto}'"]}`, null);

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
                $('#txtCodigo2').val(jsonStr.RESULT[0][0].CODIGO2);
                $('#txtPrototipo').val(jsonStr.RESULT[0][0].PROTOTIPO);
                parseFloat($('#txtEstMin').val(jsonStr.RESULT[0][0].QTDE_MIN));
                $('#txtComplemento').val(jsonStr.RESULT[0][0].COMP1);
                parseFloat($('#txtPesoLiq').val(jsonStr.RESULT[0][0].PESO_TALHADO));
                parseFloat($('#txtPesoMed').val(jsonStr.RESULT[0][0].PESO));
                parseFloat($('#txtCusto').val(jsonStr.RESULT[0][0].CUSTO));
                parseFloat($('#txtPrecoCompra').val(jsonStr.RESULT[0][0].PRECO_COM));
                parseFloat($('#txtPrecoVenda').val(jsonStr.RESULT[0][0].PRECO));
                parseFloat($('#txtPrecoRepos').val(jsonStr.RESULT[0][0].PRECO_REPOS));
                $('#txtExtIpi').val(jsonStr.RESULT[0][0].CODEXTIPI);
                $('#txtIpi').val(jsonStr.RESULT[0][0].IPI);
                parseFloat($('#txtIcms').val(jsonStr.RESULT[0][0].ICMS));

                if (jsonStr.RESULT[0][0].ATIVO == "S") {
                    $('#checkAtivo').prop('checked', true);
                } else {
                    $('#checkAtivo').prop('checked', false);
                }

                if (jsonStr.RESULT[0][0].LIBERADO == "S") {
                    $('#checkLiberado').prop('checked', true);
                } else {
                    $('#checkLiberado').prop('checked', false);
                }

                if (jsonStr.RESULT[0][0].TIPO_IMPORTACAO == "N") {
                    $('#selectImp').val(0);
                }
                if (jsonStr.RESULT[0][0].TIPO_IMPORTACAO == "D") {
                    $('#selectImp').val(1);
                }
                if (jsonStr.RESULT[0][0].TIPO_IMPORTACAO == "I") {
                    $('#selectImp').val(2);
                }

                if (jsonStr.RESULT[0][0].TRIBUTACAO == "N") {
                    $('#selectTrib').val(0);
                }
                if (jsonStr.RESULT[0][0].TRIBUTACAO == "D") {
                    $('#selectTrib').val(1);
                }
                if (jsonStr.RESULT[0][0].TRIBUTACAO == "1") {
                    $('#selectTrib').val(2);
                }
                if (jsonStr.RESULT[0][0].TRIBUTACAO == "2") {
                    $('#selectTrib').val(3);
                }
                if (jsonStr.RESULT[0][0].TRIBUTACAO == "3") {
                    $('#selectTrib').val(4);
                }
                if (jsonStr.RESULT[0][0].TRIBUTACAO == "4") {
                    $('#selectTrib').val(5);
                }
                if (jsonStr.RESULT[0][0].TRIBUTACAO == "5") {
                    $('#selectTrib').val(6);
                }
                if (jsonStr.RESULT[0][0].TRIBUTACAO == "6") {
                    $('#selectTrib').val(7);
                }
                if (jsonStr.RESULT[0][0].TRIBUTACAO == "7") {
                    $('#selectTrib').val(8);
                }
                if (jsonStr.RESULT[0][0].TRIBUTACAO == "8") {
                    $('#selectTrib').val(9);
                }

                if (jsonStr.RESULT[0][0].ECF_TRIB == "I") {
                    $('#selectTribEcf').val(0);
                }
                if (jsonStr.RESULT[0][0].ECF_TRIB == "N") {
                    $('#selectTribEcf').val(1);
                }
                if (jsonStr.RESULT[0][0].ECF_TRIB == "F") {
                    $('#selectTribEcf').val(2);
                }
                if (jsonStr.RESULT[0][0].ECF_TRIB == "T") {
                    $('#selectTribEcf').val(3);
                }
                if (jsonStr.RESULT[0][0].ECF_TRIB == "S") {
                    $('#selectTribEcf').val(4);
                }

                if (jsonStr.RESULT[0][0].POSSE == "0") {
                    $('#selectPosse').val(0);
                }
                if (jsonStr.RESULT[0][0].POSSE == "1") {
                    $('#selectPosse').val(1);
                }
                if (jsonStr.RESULT[0][0].POSSE == "2") {
                    $('#selectPosse').val(2);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"faixa",
                "camposSelect":["DESCRICAO"],
                "where": ["CODIGO = '${jsonStr.RESULT[0][0].FAIXA}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtFaixaTam', jsonStr.RESULT[0][0].FAIXA, jsonStrClasse.RESULT[0][0].DESCRICAO);

                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"entidade",
                "camposSelect":["NOME"],
                "where": ["CODCLI = '${jsonStr.RESULT[0][0].FORNECEDOR}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtCodFornec', jsonStr.RESULT[0][0].FORNECEDOR, jsonStrClasse.RESULT[0][0].NOME);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"GRUPO_PA",
                "camposSelect":["DESCRICAO"],
                "where": ["CODIGO = '${jsonStr.RESULT[0][0].GRUPO}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtGrupo', jsonStr.RESULT[0][0].GRUPO, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"entidade",
                "camposSelect":["NOME"],
                "where": ["CODCLI = '${jsonStr.RESULT[0][0].CODCLI}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtCodCliente', jsonStr.RESULT[0][0].CODCLI, jsonStrClasse.RESULT[0][0].NOME);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"SITPROD",
                "camposSelect":["DESCRICAO"],
                "where": ["CODIGO = '${jsonStr.RESULT[0][0].STATUS}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtStatus', jsonStr.RESULT[0][0].STATUS, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                if (jsonStr.RESULT[0][0].MARCA != '') {
                    try {
                        let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                            `JSON={ "tabela":"MARCA",
                "camposSelect":["DESCRICAO"],
                "where": ["CODIGO = '${jsonStr.RESULT[0][0].MARCA}'"]}`, null);

                        if (!responseClasse) {
                            return;
                        }
                        let jsonStrClasse = await responseClasse.json();
                        if (responseClasse.status != 200) {
                            msgErro(jsonStrClasse.RESULT[0].mensagem);
                            return;
                        }
                        insereValor('#txtMarca', jsonStr.RESULT[0][0].MARCA, jsonStrClasse.RESULT[0][0].DESCRICAO);
                    } catch (error) {
                        console.error(error);
                    }
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"COLECAO",
                "camposSelect":["DESCRICAO"],
                "where": ["CODIGO = '${jsonStr.RESULT[0][0].COLECAO}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtColecao', jsonStr.RESULT[0][0].COLECAO, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"ETQ_PROD",
                "camposSelect":["DESCRICAO"],
                "where": ["CODIGO = '${jsonStr.RESULT[0][0].ETIQUETA}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtEtiqueta', jsonStr.RESULT[0][0].ETIQUETA, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABLIN",
                "camposSelect":["DESCRICAO"],
                "where": ["CODIGO = '${jsonStr.RESULT[0][0].LINHA}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtLinha', jsonStr.RESULT[0][0].LINHA, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"FAIXA_DESCONTO",
                "camposSelect":["DESCRICAO"],
                "where": ["CODIGO = '${jsonStr.RESULT[0][0].FAIXA_DESCONTO}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtFaixaDesc', jsonStr.RESULT[0][0].FAIXA_DESCONTO, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"unidade",
                "camposSelect":["DESCRICAO"],
                "where": ["unidade = '${jsonStr.RESULT[0][0].UNIDADE}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtUnidade', jsonStr.RESULT[0][0].UNIDADE, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"unidade",
                "camposSelect":["DESCRICAO"],
                "where": ["unidade = '${jsonStr.RESULT[0][0].UNI_VENDA}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtUnidadeVenda', jsonStr.RESULT[0][0].UNI_VENDA, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"unidade",
                "camposSelect":["DESCRICAO"],
                "where": ["unidade = '${jsonStr.RESULT[0][0].UNI_EXP}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtUnidadeExp', jsonStr.RESULT[0][0].UNI_EXP, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"tabfis",
                "camposSelect":["DESCRICAO"],
                "where": ["codigo = '${jsonStr.RESULT[0][0].CODFIS}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtNcm', jsonStr.RESULT[0][0].CODFIS, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABTRI",
                "camposSelect":["DESCRICAO"],
                "where": ["codigo = '${jsonStr.RESULT[0][0].CODTRIB}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtCstIcms', jsonStr.RESULT[0][0].CODTRIB, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABIPI",
                "camposSelect":["DESCRICAO"],
                "where": ["codigo = '${jsonStr.RESULT[0][0].CODIPI}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtCstIpiSaida', jsonStr.RESULT[0][0].CODIPI, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABIPI",
                "camposSelect":["DESCRICAO"],
                "where": ["codigo = '${jsonStr.RESULT[0][0].CODIPI_ENT}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtCstIpiEntrada', jsonStr.RESULT[0][0].CODIPI_ENT, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"TABSPED",
                "camposSelect":["DESCRICAO"],
                "where": ["codigo = '${jsonStr.RESULT[0][0].CODSPED}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtSped', jsonStr.RESULT[0][0].CODSPED, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"NATUREZA",
                "camposSelect":["DESCRICAO"],
                "where": ["natureza = '${jsonStr.RESULT[0][0].NATUREZA}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtNatureza', jsonStr.RESULT[0][0].NATUREZA, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    let responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"ENQUADRA",
                "camposSelect":["DESCRICAO"],
                "where": ["codigo = '${jsonStr.RESULT[0][0].ENQUADRA}'"]}`, null);

                    if (!responseClasse) {
                        return;
                    }
                    let jsonStrClasse = await responseClasse.json();
                    if (responseClasse.status != 200) {
                        msgErro(jsonStrClasse.RESULT[0].mensagem);
                        return;
                    }
                    insereValor('#txtEnqIpi', jsonStr.RESULT[0][0].ENQUADRA, jsonStrClasse.RESULT[0][0].DESCRICAO);
                } catch (error) {
                    console.error(error);
                }

                try {
                    response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={
                "tabela":"PA_ITEN",
                "camposSelect":["CADCOR.COR", "CADCOR.DESCRICAO"],
                "innerJoin": [{"tabela": "CADCOR",
                "condicao": "PA_ITEN.COR = CADCOR.COR"}],
                "where": ["PA_ITEN.CODIGO = '${produto}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    let listaCond = jsonStr;
                    let controlador = [];
                    for (let i = 0; i < listaCond.RESULT[0].length; i++) {
                        if (controlador.includes(listaCond.RESULT[0][i].COR) == false) {

                            controlador.push(listaCond.RESULT[0][i].COR);

                            $('#tabelaFaixaCor').DataTable().row.add([
                                listaCond.RESULT[0][i].COR,
                                listaCond.RESULT[0][i].DESCRICAO,
                                '<div style="text-align:start;"> ' +
                                '   <button class="btn btn-info btn-sm d-none" id="btnExluirCond" type="button"> ' +
                                '      Excluir' +
                                '   </button> ' +
                                '</div>'
                            ]).draw(false);
                        }
                    }

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados da região: ${error}`);
                }

                try {
                    response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={
                "tabela":"TPVENDA_REGRA",
                "camposSelect":["TPVENDA_REGRA.TIPO_VENDA", "replace(TPVENDA_REGRA.EMPRESA, '_', '') as EMPRESA", "TPVENDA_REGRA.COD_REGRA", "REGRA.DESCRICAO"],
                "leftJoin": [{"tabela": "REGRA",
                "condicao": "TPVENDA_REGRA.COD_REGRA = REGRA.CODIGO"}],
                "where": ["TPVENDA_REGRA.CODIGO = '${produto}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }
                    let listaCond = jsonStr;
                    for (let i = 0; i < listaCond.RESULT[0].length; i++) {
                        $('#tabelaVendaRegra').DataTable().row.add([
                            listaCond.RESULT[0][i].TIPO_VENDA,
                            listaCond.RESULT[0][i].EMPRESA,
                            listaCond.RESULT[0][i].COD_REGRA,
                            listaCond.RESULT[0][i].DESCRICAO,
                            '<div style="text-align:center;"> ' +
                            '   <button class="btn btn-info btn-sm" id="btnExluirCond" type="button"> ' +
                            '      Excluir' +
                            '   </button> ' +
                            '</div>'
                        ]).draw(false);
                    }
                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados da região: ${error}`);
                }

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados da região: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }
    else {
        await carregaValoresPadroes();
    };

    async function carregaValoresPadroes() {
        const pesquisa = {
            camposSelect: ['CAMPO', 'VALOR'],
            tabela: 'TABPADRAO',
            where: [`TABPADRAO.TABELA = 'PRODUTO'`]
        }
        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        jsonStr.map(async item => {
            switch (item.CAMPO) {
                case 'UNIDADE': {
                    insereValor('#txtUnidade', item.VALOR, 'VALOR PADRÃO');
                    break;
                }
                case 'UNI_VENDA': {
                    insereValor('#txtUnidadeVenda', item.VALOR, 'VALOR PADRÃO');
                    break;
                }
                case 'CODFIS': {
                    insereValor('#txtNcm', item.VALOR, 'VALOR PADRÃO');
                    break;
                }
                case 'ICMS': {
                    insereValor('#txtIcms', item.VALOR);
                    break;
                }
                case 'CODTRIB': {
                    insereValor('#txtCstIcms', item.VALOR, 'VALOR PADRÃO');
                    break;
                }
                case 'CODIPI': {
                    insereValor('#txtCstIpiSaida', item.VALOR, 'VALOR PADRÃO');
                    break;
                }
                case 'CODIPI_ENT': {
                    insereValor('#txtCstIpiEntrada', item.VALOR, 'VALOR PADRÃO');
                    break;
                }
                case 'TRIBUTACAO': {
                    $('#selectTrib').val(item.VALOR).change();
                    break;
                }
                case 'IPI': {
                    insereValor('#txtIpi', item.VALOR);
                    break;
                }
                case 'STATUS': {
                    insereValor('#txtStatus', item.VALOR, 'VALOR PADRÃO');
                    break;
                }
                case 'SPED': {
                    insereValor('#txtSped', item.VALOR, 'VALOR PADRÃO');
                    break;
                }
                case 'GRUPO_PRODUTO': {
                    insereValor('#txtGrupo', item.VALOR, 'VALOR PADRÃO');
                    break;
                }
                case 'ECF_TRIB': {
                    $('#selectTribEcf').val(item.VALOR).change();
                    break;
                }
                case 'NATUREZA': {
                    insereValor('#txtNatureza', item.VALOR, 'VALOR PADRÃO');
                    break;
                }
                case 'ETIQUETA': {
                    insereValor('#txtEtiqueta', item.VALOR, 'VALOR PADRÃO');
                    break;
                }
                case 'LINHA': {
                    insereValor('#txtLinha', item.VALOR, 'VALOR PADRÃO');
                    break;
                }
                case 'COLECAO': {
                    insereValor('#txtColecao', item.VALOR, 'VALOR PADRÃO');
                    break;
                }
                case 'POSSE': {
                    $('#selectPosse').val(item.VALOR).change();
                    break;
                }
                case 'COR': {
                    if (item.VALOR != '' && item.VALOR != undefined && item.VALOR != null) {
                        const existeCor = await verificaSeCorExiste(item.VALOR);
                        if (existeCor) {
                            insereValor('#txtCondPagto', item.VALOR, 'VALOR PADRÃO');
                            addValorCond();
                            break;
                        } else {
                            break;
                        }
                    } else {
                        break;
                    }
                }
                case 'TIPO_VENDA': {
                    if (item.VALOR != '' && item.VALOR != undefined && item.VALOR != null) {
                        tipoVendaPadrao = item.VALOR;
                    };
                    break;
                }
                case 'FAIXA_TAMANHO': {
                    if (item.VALOR != '' && item.VALOR != undefined && item.VALOR != null) {
                        const existeFaixa = await verificaSeFaixaExiste(item.VALOR);
                        if (existeFaixa) {
                            insereValor('#txtFaixaTam', item.VALOR, 'VALOR PADRÃO');
                            break;
                        } else {
                            break;
                        }
                    } else {
                        break;
                    }
                }
            }
        });
    };

    $('#modalAdicionarVendaRegra').on('shown.bs.modal', async function () {
        if (tipoVendaPadrao != '') {
            $('#txtTipoVenda').val(tipoVendaPadrao);
        }
    });

    $("#gravar").click(

        async function () {

            if ($('#tabelaFaixaCor').DataTable().rows().count() < 1) {
                msgAlerta('Insira pelo menos uma cor ao produto.');
                return;
            }

            let validaFaixa = true;
            let adicionarTamanhos = [];

            const existeProduto = $("#txtCodigo").val() != "";

            if (existeProduto) {
                adicionarTamanhos.push('true');
            }

            $('#multiCollapseExample2').collapse('show');
            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {

                try {
                    let faixaAntiga = '';
                    if (existeProduto) {

                        responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                            `JSON={ "tabela": "produto",
                                "camposSelect":["faixa_iten.TAMANHO"],
                                "leftJoin": [{"tabela": "faixa_iten",
                                "condicao": "produto.faixa = faixa_iten.faixa"}],
                                "where":["produto.CODIGO = '${$('#txtCodigo').val()}'"]}`, null);
                        jsonStr = await responseClasse.json();

                        faixaAntiga = jsonStr.RESULT[0];
                    }

                    let novaFaixaCodigo = pegaChave('#txtFaixaTam');

                    responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela": "faixa_iten",
                            "camposSelect":["TAMANHO"],
                            "where":["faixa = '${novaFaixaCodigo}'"]}`, null);
                    jsonStr = await responseClasse.json();

                    let novaFaixa = jsonStr.RESULT[0];

                    let listaNovaFaixa = [];
                    for (let i = 0; i < novaFaixa.length; i++) {
                        listaNovaFaixa.push(novaFaixa[i].TAMANHO);
                    }

                    for (let i = 0; i < faixaAntiga.length; i++) {
                        if (jQuery.inArray(faixaAntiga[i].TAMANHO, listaNovaFaixa) == -1) {
                            validaFaixa = false;
                        }
                    }

                    if (validaFaixa == false) {
                        msgAlerta('Verifique a nova faixa de tamanho informada, ela não contém os tamanhos da anterior. Campo preenchido com a faixa anterior do produto.');

                        responseClasse = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                            `JSON={ "tabela": "produto",
                            "camposSelect":["faixa.codigo", "faixa.descricao"],
                            "leftJoin": [{"tabela": "faixa",
                            "condicao": "produto.faixa = faixa.codigo"}],
                            "where":["produto.CODIGO = '${$('#txtCodigo').val()}'"]}`, null);
                        jsonStr = await responseClasse.json();
                        insereValor('#txtFaixaTam', jsonStr.RESULT[0][0].CODIGO, jsonStr.RESULT[0][0].DESCRICAO);
                    } else {
                        let listaTamanhosAntigos = [];
                        for (let i = 0; i < faixaAntiga.length; i++) {
                            listaTamanhosAntigos.push(faixaAntiga[i].TAMANHO);
                        }
                        for (let i = 0; i < listaNovaFaixa.length; i++) {
                            adicionarTamanhos.push(listaNovaFaixa[i]);
                        }
                    }

                } catch (error) {
                    console.error(error);
                }

                if (validaFaixa) {

                    try {
                        $.LoadingOverlay("show");
                        try {
                            produto = $('#txtCodigo').val();
                            let file = document.querySelector('input[type=file]').files[0];
                            let reader = new FileReader();
                            let baseString;
                            reader.onloadend = function () {
                                baseString = reader.result;
                                console.log();
                            };
                            await reader.readAsDataURL(file);

                            let response = await requisicao('GET', '/sisplan/funcoes/v1/caminhofoto?', null);
                            if (!response) {
                                return;
                            }
                            jsonStr = await response.json();
                            let pastaFoto = jsonStr.mensagem;

                            response = await requisicao('POST', '/sisplan/funcoes/v1/FotoItem?',
                                `PDIRETORIOSALVAR=${pastaFoto
                                }&NOMEARQUIVO=${produto}.jpg`, `SBASE64=${encodeURIComponent(baseString)}`);
                        } catch (error) {
                            console.error(error);
                        }

                        produto = {};

                        produto.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('PRODUTO', 'PRODUTO', 'CODIGO', 6) : $('#txtCodigo').val();
                        $('#txtCodigo').val(produto.CODIGO);
                        produto.DESCRICAO = $('#txtDescricao').val();
                        produto.CODIGO2 = $('#txtCodigo2').val();
                        produto.PROTOTIPO = $('#txtPrototipo').val();
                        produto.QTDE_MIN = parseFloat($('#txtEstMin').val().replace(',', '.'));
                        produto.COMP1 = $('#txtComplemento').val();
                        produto.PESO_TALHADO = parseFloat($('#txtPesoLiq').val().replace(',', '.'));
                        produto.PESO = parseFloat($('#txtPesoMed').val().replace(',', '.'));
                        produto.CUSTO = parseFloat($('#txtCusto').val().replace(',', '.'));
                        produto.PRECO_COM = parseFloat($('#txtPrecoCompra').val().replace(',', '.'));
                        produto.PRECO = parseFloat($('#txtPrecoVenda').val().replace(',', '.'));
                        produto.PRECO_REPOS = parseFloat($('#txtPrecoRepos').val().replace(',', '.'));
                        produto.CODEXTIPI = $('#txtExtIpi').val();
                        produto.IPI = parseFloat($('#txtIpi').val().replace(',', '.'));
                        produto.ICMS = parseFloat($('#txtIcms').val().replace(',', '.'));
                        produto.POSSE = $('#selectPosse').val();

                        if ($('#checkAtivo').prop('checked')) {
                            produto.ATIVO = 'S';
                        } else {
                            produto.ATIVO = 'N';
                        }

                        if ($('#checkLiberado').prop('checked')) {
                            produto.LIBERADO = 'S';
                        } else {
                            produto.LIBERADO = 'N';
                        }

                        produto.FAIXA = pegaChave($('#txtFaixaTam').val(), produto.FAIXA);
                        produto.FORNECEDOR = pegaChave($('#txtCodFornec').val(), produto.FORNECEDOR);
                        produto.GRUPO = pegaChave($('#txtGrupo').val(), produto.GRUPO);
                        produto.CODCLI = pegaChave($('#txtCodCliente').val(), produto.CODCLI);
                        produto.STATUS = pegaChave($('#txtStatus').val(), produto.STATUS);
                        produto.MARCA = pegaChave($('#txtMarca').val(), produto.MARCA);
                        produto.COLECAO = pegaChave($('#txtColecao').val(), produto.COLECAO);
                        produto.ETIQUETA = pegaChave($('#txtEtiqueta').val(), produto.ETIQUETA);
                        produto.LINHA = pegaChave($('#txtLinha').val(), produto.LINHA);
                        produto.UNIDADE = pegaChave($('#txtUnidade').val(), produto.UNIDADE);
                        produto.UNI_VENDA = pegaChave($('#txtUnidadeVenda').val(), produto.UNI_VENDA);
                        produto.UNI_EXP = pegaChave($('#txtUnidadeExp').val(), produto.UNI_EXP);
                        produto.CODFIS = pegaChave($('#txtNcm').val(), produto.CODFIS);
                        produto.CODTRIB = pegaChave($('#txtCstIcms').val(), produto.CODTRIB);
                        produto.CODIPI = pegaChave($('#txtCstIpiSaida').val(), produto.CODIPI);
                        produto.CODIPI_ENT = pegaChave($('#txtCstIpiEntrada').val(), produto.CODIPI_ENT);
                        produto.CODSPED = pegaChave($('#txtSped').val(), produto.CODSPED);
                        produto.NATUREZA = pegaChave($('#txtNatureza').val(), produto.NATUREZA);
                        produto.ENQUADRA = pegaChave($('#txtEnqIpi').val(), produto.ENQUADRA);

                        if ($('#selectImp').val() == 0) {
                            produto.TIPO_IMPORTACAO = "N";
                        }
                        if ($('#selectImp').val() == 1) {
                            produto.TIPO_IMPORTACAO = "D";
                        }
                        if ($('#selectImp').val() == 2) {
                            produto.TIPO_IMPORTACAO = "I";
                        }

                        if ($('#selectTribEcf').val() == 5) {
                            produto.ECF_TRIB = "";
                        }

                        if ($('#selectTribEcf').val() == 0) {
                            produto.ECF_TRIB = "I";
                        }
                        if ($('#selectTribEcf').val() == 1) {
                            produto.ECF_TRIB = "N";
                        }
                        if ($('#selectTribEcf').val() == 2) {
                            produto.ECF_TRIB = "F";
                        }
                        if ($('#selectTribEcf').val() == 3) {
                            produto.ECF_TRIB = "T";
                        }
                        if ($('#selectTribEcf').val() == 4) {
                            produto.ECF_TRIB = "S";
                        }

                        if ($('#selectTrib').val() == 0) {
                            produto.TRIBUTACAO = "N";
                        }
                        if ($('#selectTrib').val() == 1) {
                            produto.TRIBUTACAO = "D";
                        }
                        if ($('#selectTrib').val() == 2) {
                            produto.TRIBUTACAO = "1";
                        }
                        if ($('#selectTrib').val() == 3) {
                            produto.TRIBUTACAO = "2";
                        }
                        if ($('#selectTrib').val() == 4) {
                            produto.TRIBUTACAO = "3";
                        }
                        if ($('#selectTrib').val() == 5) {
                            produto.TRIBUTACAO = "4";
                        }
                        if ($('#selectTrib').val() == 6) {
                            produto.TRIBUTACAO = "5";
                        }
                        if ($('#selectTrib').val() == 7) {
                            produto.TRIBUTACAO = "6";
                        }
                        if ($('#selectTrib').val() == 8) {
                            produto.TRIBUTACAO = "7";
                        }
                        if ($('#selectTrib').val() == 9) {
                            produto.TRIBUTACAO = "8";
                        }

                        try {
                            let responseClasse2 = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                                `JSON={ "tabela":"FAIXA_ITEN",
                                "camposSelect":["TAMANHO"],
                                "where": ["faixa = '${produto.FAIXA}'"]}`, null);

                            if (!responseClasse2) {
                                return;
                            }
                            let jsonStrClasse = await responseClasse2.json();
                            if (responseClasse2.status != 200) {
                                msgErro(jsonStrClasse.RESULT[0].mensagem);
                                return;
                            }

                        } catch (error) {
                            console.error(error);
                        }

                        if (adicionarTamanhos[0] == 'true') {
                            let arrayCores = [];
                            for (let index = 0; index < $('#tabelaFaixaCor').DataTable().rows().count(); index++) {
                                let data = $('#tabelaFaixaCor').DataTable().row(index).data();
                                for (let cont = 1; cont < adicionarTamanhos.length; cont++) {
                                    let cor = {};
                                    cor.CODIGO = $('#txtCodigo').val();
                                    cor.COR = data[0];
                                    cor.TAM = adicionarTamanhos[cont];
                                    arrayCores.push(cor);
                                }
                            }
                            produto.CORES = arrayCores;
                        } else {
                            let arrayCores = [];
                            for (let index = 0; index < $('#tabelaFaixaCor').DataTable().rows().count(); index++) {
                                let data = $('#tabelaFaixaCor').DataTable().row(index).data();
                                for (let cont = 0; cont < adicionarTamanhos.length; cont++) {
                                    let cor = {};
                                    cor.CODIGO = $('#txtCodigo').val();
                                    cor.COR = data[0];
                                    cor.TAM = adicionarTamanhos[cont];
                                    arrayCores.push(cor);
                                }
                            }
                            produto.CORES = arrayCores;
                        }

                        let arrayTipoVendas = [];
                        for (let index = 0; index < $('#tabelaVendaRegra').DataTable().rows().count(); index++) {
                            let data = $('#tabelaVendaRegra').DataTable().row(index).data();
                            let tipovenda = {};
                            tipovenda.CODIGO = $('#txtCodigo').val();;
                            tipovenda.TIPO_VENDA = data[0];
                            tipovenda.EMPRESA = `_${data[1]}`;
                            tipovenda.COD_REGRA = data[2];
                            arrayTipoVendas.push(tipovenda);
                        }
                        produto.TIPOVENDAS = arrayTipoVendas;

                        response1 = await requisicao('POST', '/Sisplan/Cadastros/v1/produto?', `JSON=${encodeURIComponent(JSON.stringify(produto))}`, null);

                        if (!response1) {
                            $.LoadingOverlay("hide");
                            return;
                        };

                        let jsonStr1 = await response1.json();
                        if (response1.status != 200) {
                            $.LoadingOverlay("hide");
                            msgErro(jsonStr1.mensagem);
                            return;
                        }
                        $.LoadingOverlay("hide");
                        toastr.success(
                            `Cadastro efetuado com sucesso!
                            Produto: ${produto.CODIGO}`,
                            'Confirmação', {
                            toastClass: 'alert',
                            iconClasses: {
                                error: 'alert-error',
                                info: 'alert-info',
                                success: 'alert-success',
                                warning: 'alert-warning'
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 5000,
                            fadeOut: 3000,
                            onHidden() {
                                window.location.href = `${BASE_URI}/produto`;
                            }
                        }
                        ).css({
                            "margin-top": "20%",
                            "width": "500px",
                            "max-width": "500px"
                        });

                    } catch (error) {
                        $.LoadingOverlay("hide");
                        console.error(error);
                    }
                }
            }
        }
    );

    $('.collapse').on('shown.bs.collapse', function (e) {
        let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);
        clicked
            .parent()
            .find(".fa-angle-right")
            .removeClass("fa-angle-right")
            .addClass("fa-angle-down");
    })
        .on('hidden.bs.collapse', function (e) {
            let clicked = $(document).find(`[href='#${$(e.target).attr('id')}']`);
            clicked
                .parent()
                .find(".fa-angle-down")
                .removeClass("fa-angle-down")
                .addClass("fa-angle-right");
        });
});