$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([{
            element: '#btn-filtros',
            popover: {
                title: 'Botão Filtros',
                description: 'Clique aqui para abrir os campos disponíveis de filtro.',
                position: 'right'
            }
        },
        {
            element: '#tabelaProduto',
            popover: {
                title: 'Produto',
                description: 'Aqui você tem uma lista de produtos conforme os filtros selecionados no passo anterior.',
                position: 'top'
            }
        }
        ]);
        driver.start();
    });
});

function GoOutFullscreen() {
    if (document.exitFullscreen)
        document.exitFullscreen();
    else if (document.mozCancelFullScreen)
        document.mozCancelFullScreen();
    else if (document.webkitExitFullscreen)
        document.webkitExitFullscreen();
    else if (document.msExitFullscreen)
        document.msExitFullscreen();
}

document.addEventListener('keydown', (event) => {
    const keyName = event.key;

    if (keyName === 'F2') {
        event.preventDefault();
        GoOutFullscreen();
        $('#modalItens').removeClass('modal-fullscreen');
        $('#modalItens').modal('hide');
    }
});

$(document).ready(async function () {
    var parametrosSistema = await BuscaParametrosSistema('S');
    let quantidadeCasasDecimaisParametro = parametrosSistema[1] ?? 0;
    const quantidadeCasasDecimaisCampo = (+quantidadeCasasDecimaisParametro) + 2;
    const filtroDeposito = await retornaDepositoUsuario(getCookie('cod_usuario'));

    const tipoConsulta = ($('#radioMaterialC').is(':checked') ? 'M' : 'P');

    let tipo;
    let controleBarra = false;

    const depositoParam = await CopiaParametro('VENDA', 1);
    $('#txtDeposito').val(depositoParam);
    const tabelaParam = await CopiaParametro('VENDA', 2);
    $('#txtTabPreco').val(tabelaParam);
    const vendeMaterial = await CopiaParametro('VENDA', 17) == '1';
    if (vendeMaterial) {
        $('#radioMaterial').prop('checked', true);
        setTimeout(() => { $('#radioMaterial').trigger('change'); }, 300);
    }


    $('#modal-filtros').modal('hide');
    $('#modalItens').modal('hide');
    $('#txtBarraRapida').focus();


    $('#txtBarra').on('blur', function () {
        $('#btnConsultar').focus();
    });

    $('#btnConsultar').on('keypress', function () {
        $('#btnConsultar').trigger('click');
    });

    try {
        let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"material",
          "camposSelect":["CODIGO"],
          "where": ["1=1"], "limit": 10}`, null);
        let jsonStr = await response.json();

        if (jsonStr.RESULT[0].length < 1) {
            $('.escondeRadio').addClass('d-none');
        }
    } catch (error) {
        console.error(error);
    }

    $('#radioProduto, #radioMaterial').on('change', async function () {

        // $('#tabelaProduto').empty();
        $('#btn-produto-filtro').unbind();
        $('#txtProduto').val('');

        if ($('#radioMaterial').is(':checked')) {
            $("#txtProduto").attr("placeholder", "Material");
            $("#lblProduto").text("Material");
            $('#btn-produto-filtro').pesquisa_serverside(['#txtProduto'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Material');
            $('#txtProduto').autocompleta(3, `JSON={ "tabela":"material", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
        } else {
            $("#txtProduto").attr("placeholder", "Produto");
            $("#lblProduto").text("Produto");
            $('#btn-produto-filtro').pesquisa_serverside(['#txtProduto'],
                ['CODIGO', 'DESCRICAO', 'CODIGO2'], ['CODIGO', 'DESCRICAO', 'CODIGO2'],
                '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2"], "where": null}',
                'Pesquisa Produto');
            $('#txtProduto').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao", "codigo2"], "where": null}`);
        }
    });

    $('#txtBarraRapida').on('keypress', function (event) {
        let regex = new RegExp("^[a-zA-Z0-9 .]+$");
        let key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault(); return false;
        }
    });

    $('#txtBarraRapida').on('change', async function () {
        controleBarra = true;
        let tabela = $('#txtTabPreco').val().substring(1, $('#txtTabPreco').val().indexOf('] - '));
        let deposito = $('#txtDeposito').val().substring(1, $('#txtDeposito').val().indexOf('] - '));
        let barra = $('#txtBarraRapida').val().indexOf('#') > 0 ? $('#txtBarraRapida').val().substring(0, 6) : $('#txtBarraRapida').val();
        let tipoProdRapida = '';
        let codigo = '';


        if (deposito == '') {
            msgAlerta('Informe um depósito');
            return;
        }

        let produto = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={
            "tabela":"PA_ITEN",
            "camposSelect":[ "CODIGO"],
            "where": ["(CODIGO   = '${barra}' 
                  OR BARRA    = '${barra}'
                  OR BARRACLI = '${barra}'
                  OR BARRA28  = '${barra}'
                  OR BARRA28  = '${barra.substring(0, 6)}')
                "]}`, null);

        if (!produto) {
            $.LoadingOverlay("hide");
            return;
        }

        let jsonStrTipo = await produto.json();
        if (produto.status != 200) {
            $.LoadingOverlay("hide");
            msgAlerta(jsonStrTipo.RESULT[0].mensagem);
            return;
        }

        if (jsonStrTipo.RESULT[0].length > 0) {
            codigo = jsonStrTipo.RESULT[0][0].CODIGO;
            tipoProdRapida = 'P';
        } else {
            tipoProdRapida = 'M';
            let material = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={
                "tabela":"MAT_ITEN",
                "camposSelect":[ "CODIGO"],
                "where": ["(LOTE = '${barra}' OR BARRA = '${barra}')
                "]}`, null);

            if (!material) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStrTipoM = await material.json();
            if (material.status != 200) {
                $.LoadingOverlay("hide");
                msgAlerta(jsonStrTipoM.RESULT[0].mensagem);
                return;
            }

            if (jsonStrTipoM.RESULT[0].length > 0) {
                codigo = jsonStrTipoM.RESULT[0][0].CODIGO;
            } else {
                msgAlerta('Código de barras não encontrado!');
                return;
            }
        }
        await buscaFoto(codigo);
        barra = (barra == codigo) ? '' : barra;
        await BuscaPreco(codigo, barra, tipoProdRapida);

        $('#txtBarraRapida').val('');
        $('#txtBarraRapida').focus();
    });

    $('#txtBarraRapida').keydown(function (e) {
        if (e.which === 13) {
            e.preventDefault();
            $('#txtBarraRapida').trigger('blur');
            $('#txtBarraRapida').focus();
        }
    });

    $('#btn-filtros').trigger('click');


    $('#btnConsultar').click(async function () {
        controleBarra = false;
        $('#tabelaProduto').DataTable().clear().draw(false);
        $('#tabelaProduto').empty();
        if ($.fn.DataTable.isDataTable("#tabelaItens")) {
            $('#tabelaItens').DataTable().clear().draw(false);
            $('#tabelaItens').empty();
        }
        $('#modalItens').removeClass('modal-fullscreen');
        if ($('#radioProduto').is(':checked')) {
            tipo = 'P';
        } else {
            tipo = 'M';
        }
        BuscaProduto();
        $('#modal-filtros').modal('hide');
    });

    $('#btn-tabpreco-filtro').pesquisa('#txtTabPreco', 'REGIAO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO"]}', 'Pesquisa Tabela', 'REGIAO');
    $('#btn-limpa-tabela').on('click', function () {
        $('#txtTabPreco').val('');
    });

    $('#txtTabPreco').keydown(function (e) {

        if (e.which == 115) {
            e.preventDefault();
            $('#btn-tabpreco-filtro').click();
        }
    });

    $('#txtTabPreco').autocompleta(1, `JSON={ "tabela":"regiao", "camposSelect":[ "regiao chave", "descricao"], "where": null}`);
    $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"deposito", "camposSelect":[ "codigo chave", "descricao"], "where": ${filtroDeposito}}`);

    $('#txtDeposito').keydown(function (e) {

        if (e.which == 115) {
            e.preventDefault();
            $('#btn-deposito-filtro').click();
        }
    });

    $('#txtGrupoConsultaEstoque').keydown(function (e) {

        if (e.which == 115) {
            e.preventDefault();
            $('#btn-GrupoConsultaEstoque').click();
        }
    })

    $('#txtProdutoConsultaEstoque').keydown(function (e) {

        if (e.which == 115) {
            e.preventDefault();
            $('#btn-ProdutoConsultaEstoque').click();
        }
    })

    $('#btn-filtros').on('click', function () {
        $('#modal-filtros').modal('show');
        $('#modalItens').modal('hide');
        $('#txtBarra').focus();
    });

    $('#btnConsultarPrecoFS').on('click', function (e) {
        $('#modalItens').addClass('modal-fullscreen');
        openFullscreen();
        $('#modalItens').modal('show');
        $('#txtBarraRapida').focus();
    });

    async function FecharModalFullScreen() {
        $('#btnFecharModal').on('click', function (e) {
            $('#modalItens').removeClass('modal-fullscreen');
            GoOutFullscreen();
            $('#modalItens').modal('hide');
        })
    };

    $('#btnFecharModal').on('click')
    FecharModalFullScreen();

    $('#btn-deposito-filtro').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": ${filtroDeposito}}`, 'Pesquisa Tabela', 'CODIGO');
    $('#btn-limpa-deposito').on('click', function () {
        $('#txtDeposito').val('');
    });

    $('#txtProduto').keydown(function (e) {

        if (e.which == 115) {
            e.preventDefault();
            $('#btn-produto-filtro').click();
        }
    });


    function openFullscreen() {
        const elem = document.querySelector('body');
        if (elem.requestFullscreen) {
            elem.requestFullscreen();
        } else if (elem.mozRequestFullScreen) {
            elem.mozRequestFullScreen();
        } else if (elem.webkitRequestFullscreen) {
            elem.webkitRequestFullscreen();
        } else if (elem.msRequestFullscreen) {
            elem.msRequestFullscreen();
        }
    }

    function GoOutFullscreen() {
        try {
            if (document.exitFullscreen)
                document.exitFullscreen();
            else if (document.mozCancelFullScreen)
                document.mozCancelFullScreen();
            else if (document.webkitExitFullscreen)
                document.webkitExitFullscreen();
            else if (document.msExitFullscreen)
                document.msExitFullscreen();
        } catch (error) {

        }
    }

    $('#btn-produto-filtro').pesquisa_serverside(['#txtProduto'],
        ['CODIGO', 'DESCRICAO', 'CODIGO2'], ['CODIGO', 'DESCRICAO', 'CODIGO2'],
        '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2"], "where": null}',
        'Pesquisa Produto');

    $('#txtProduto').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao", "codigo2"], "where": null}`);


    $('#btn-limpa-produto').on('click', function () {
        $('#txtProduto').val('');
    });

    $('#btn-limpa-barra').on('click', function () {
        $('#txtBarra').val('');
    });

    $('#modalItens').on('hidden.bs.modal', function () {
        $('#txtBarraRapida').val('');
    });

    async function buscaFoto(codigo) {
        try {
            let urlRequisicao = '/Sisplan/Funcoes/v1/FotoItem?';
            let response = await requisicao('GET', urlRequisicao, `codigo=${codigo}`, null);

            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
                $("#infoprodimagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
                return;
            }

            let sBase64 = jsonStr;
            $("#infoprodimagem").attr('src', `data:image/png;base64,${sBase64.mensagem}`);

        } catch (error) {
            console.error(error);
            $("#infoprodimagem").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        }
    }

    async function retornaDadosBarra(barra) {
        try {
            $.LoadingOverlay("show");
            try {
                const sTabela = pegaChave("#txtTabPreco");
                const sDeposito = pegaChave("#txtDeposito");
                const iLancamento = 0;
                const sQualidade = 1;
                const url = `/Sisplan/Estoque/v1/barra?`;
                const tipoItem = 'P';

                const params = `lancamento=${iLancamento}&barra=${encodeURIComponent(barra)}&tabpreco=${sTabela}&qualidade=${sQualidade}&tipo=${tipoItem}&deposito=${sDeposito}`;

                const response = await requisicao('GET', url, params, null);

                if (!response) {
                    return;
                }

                const jsonStr = await response.json();

                if (jsonStr.codigo == 400) {
                    msgAlerta(jsonStr.mensagem);
                }

                return jsonStr;
            } catch (error) {
                msgErro('Erro ao buscar dados da barra!');
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    function mostra2Casas(nr) {
        const og = Math.pow(10, 2);
        return Math.floor(nr * og) / og;
    }

    async function BuscaPreco(pCodigo, sBarra = '', sTipo = '') {
        let prodEncontrado;
        if (sBarra != '') {
            const dadosBarra = await retornaDadosBarra(sBarra);
            prodEncontrado = dadosBarra ? dadosBarra.map((dados => ({
                CODIGO: dados.CODIGO,
                COR: dados.COR,
                TAM: dados.TAM
            })))[0] : undefined;
        }
        const tabela = pegaChave($('#txtTabPreco').val());
        const deposito = pegaChave($('#txtDeposito').val());
        const prazo = '00';
        const barra = sBarra == '' ? $('#txtBarra').val() : controleBarra ? sBarra : '';
        const tipoBusca = sTipo != '' ? sTipo : tipo;

        if (deposito == '') {
            msgAlerta('Informe um depósito');
            return;
        }

        try {
            $.LoadingOverlay("show");
            let dataSetCols = [];

            let response = await requisicao('GET', '/sisplan/vendas/v1/precos?', `tabpreco=${tabela}&PRODUTO=${pCodigo}&DEPOSITO=${deposito}&BARRA=${""}&TIPO=${tipoBusca}&PRAZO=${prazo}`, null);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgAlerta(jsonStr.mensagem);
                return;
            }

            let keys = Object.keys(jsonStr[0]);

            let arrayGrade = jsonStr;

            for (let i = 0; i < arrayGrade.length; i++) {
                if (arrayGrade[i].PRECO === 'null' || arrayGrade[i].PRECO === null) {
                    jsonStr[i].PRECO = 0;
                }
                // if (sBarra != '') {
                //     jsonStr[i].BARRA = sBarra;
                // }

            }

            for (let k in keys) {
                dataSetCols.push({
                    'title': keys[k],
                    'data': keys[k],
                    // 'width': '20%'
                });
            }

            $('#tabelaItens').DataTable({
                destroy: true,
                select: true,
                keys: true,
                searching: true,
                paging: false,
                "language": {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar",
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                },

                "autoWidth": true,
                "data": jsonStr,
                "columns": dataSetCols,
                columnDefs: [
                    {
                        "visible": false,
                        "targets": [10, 11]
                    },
                    {
                        "render": function (data) {
                            return parseFloat(data).toLocaleString("pt-BR", {
                                maximumFractionDigits: quantidadeCasasDecimaisCampo,
                                minimumFractionDigits: quantidadeCasasDecimaisCampo
                            })
                        },
                        "targets": [7, 9]
                    }
                ],
            });

            $("#tabelaItens").DataTable().columns.adjust().draw(false);

            $.LoadingOverlay("hide");

            $('#tabelaItens tbody').on('click', 'tr', async function () {
                $('#tabelaItens').DataTable().$('tr.selected').removeClass('selected');
                $(this).addClass('selected');

                let data = $('#tabelaItens').DataTable().row($(this)).data();
                if (parseFloat(data.PRECO_PROMO) > 0) {
                    $('#txtPrecoProduto').text(quantidadeCasasDecimaisCampo > 2 ? moeda2float(float2moeda(data.PRECO_PROMO, quantidadeCasasDecimaisCampo))
                        : mostra2Casas(data.PRECO_PROMO));
                } else {
                    $('#txtPrecoProduto').text(data.PRECO == null ? '0.00' :
                        (quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda(data.PRECO, quantidadeCasasDecimaisCampo))
                            : mostra2Casas(data.PRECO));
                }
                $('#txtQtdeProduto').text(data.QTDE);
                $('#txtDescProduto').text(`${data.DESCRICAO} - ${data.DESC_COR ? data.DESC_COR : ''} - ${data.TAM}`);
                $("#tabelaItens").DataTable().columns.adjust().draw(false);
            });

            if (prodEncontrado) {
                const dados = $("#tabelaItens")
                    .DataTable()
                    .rows()
                    .data()
                    .toArray();

                const indiceEncontrado = dados.findIndex((item) => (item.CODIGO == prodEncontrado.CODIGO &&
                    item.COR == prodEncontrado.COR &&
                    item.TAM == prodEncontrado.TAM));
                $($("#tabelaItens tbody tr")[indiceEncontrado]).click();
                $(".dataTables_scrollBody").scrollTo($("#tabelaItens tbody tr").eq(indiceEncontrado), 200);
            } else {
                $("#tabelaItens tbody tr td")[0].click();
            }

        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }
    }

    async function BuscaProduto() {
        let tabela = pegaChave($('#txtTabPreco').val());
        let produto = pegaChave($('#txtProduto').val());
        let deposito = pegaChave($('#txtDeposito').val());
        let barra = $('#txtBarra').val().indexOf('#') > 0 ? $('#txtBarra').val().substring(0, 6) : $('#txtBarra').val();

        // if (tabela == '') {
        //     msgAlerta('Informe uma tabela de preço');
        //     return;
        // }

        if (deposito == '') {
            msgAlerta('Informe um depósito');
            return;
        }

        try {
            $.LoadingOverlay("show");
            let response;

            if (produto != '') {
                if ($('#radioProduto').is(':checked')) {
                    if (barra == '') {
                        response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={
                        "tabela":"PRODUTO",
                        "camposSelect":[ "DISTINCT PRODUTO.CODIGO", "PRODUTO.DESCRICAO"],
                        "leftjoin": [{"tabela" : "PA_ITEN", "condicao" : "PRODUTO.CODIGO = PA_ITEN.CODIGO"}], 
                        "where": ["PRODUTO.CODIGO = '${produto}'
                        ${$('#txtDeposito').val() != '' ? ` AND PA_ITEN.DEPOSITO = '${pegaChave($('#txtDeposito').val())}'` : ''}               
                        "]}`, null);
                    } else {
                        response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={
                            "tabela":"PRODUTO",
                            "camposSelect":[ "CODIGO", "DESCRICAO"],
                            "where": ["CODIGO = '${produto}' AND CODIGO IN (
                                SELECT CODIGO FROM [PA_ITEN] WHERE (BARRA = '${barra}'
                                 OR BARRACLI = '${barra}'
                                 OR BARRA28  = '${barra}'
                                 OR BARRA28  = '${barra.substring(0, 6)}'
                                 ${$('#txtDeposito').val() != '' ? ` AND DEPOSITO = '${pegaChave($('#txtDeposito').val())}'` : ''}  
                                )
                                )"]}`, null);
                    }
                } else if (barra == '') {
                    response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={
                            "tabela":"MATERIAL",
                            "camposSelect":[ "DISTINCT MATERIAL.CODIGO", "MATERIAL.DESCRICAO"],
                            "leftjoin": [{"tabela" : "MAT_ITEN", "condicao" : "MATERIAL.CODIGO = MAT_ITEN.CODIGO"}], 
                            "where": ["MATERIAL.CODIGO = '${produto}'
                            ${$('#txtDeposito').val() != '' ? ` AND MAT_ITEN.DEPOSITO = '${pegaChave($('#txtDeposito').val())}'` : ''}  
                            "]}`, null);
                } else {
                    response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={
                            "tabela":"MATERIAL",
                            "camposSelect":[ "CODIGO", "DESCRICAO"],
                            "where": ["CODIGO = '${produto}'", "CODIGO IN (SELECT CODIGO FROM [MAT_ITEN] WHERE (LOTE = '${barra}'))",
                            "${$('#txtDeposito').val() != '' ? `CODIGO IN (SELECT CODIGO FROM [MAT_ITEN] WHERE (DEPOSITO = '${pegaChave($('#txtDeposito').val())}'))` : ''}"]}`,
                        null);
                }
            } else if (barra != '') {
                if ($('#radioProduto').is(':checked')) {
                    response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={
                        "tabela":"PRODUTO",
                        "camposSelect":[ "CODIGO", "DESCRICAO"],
                        "where": ["UDF_LEN(CODIGO) > 0",
                        "CODIGO IN (SELECT CODIGO FROM [PA_ITEN]
                             WHERE (BARRA  = '${barra}'
                              OR BARRACLI = '${barra}'
                              OR BARRA28  = '${barra}'
                              OR BARRA28  = '${barra.substring(0, 6)}')
                             ${$('#txtDeposito').val() != '' ? ` AND DEPOSITO = '${pegaChave($('#txtDeposito').val())}'` : ''}  
                             )"]}`, null);
                } else {
                    response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={
                        "tabela":"MATERIAL",
                        "camposSelect":[ "CODIGO", "DESCRICAO"],
                        "where": ["UDF_LEN(CODIGO) > 0",
                        "CODIGO IN (SELECT CODIGO FROM [MAT_ITEN] WHERE (LOTE = '${barra}')
                        ${$('#txtDeposito').val() != '' ? ` AND DEPOSITO = '${pegaChave($('#txtDeposito').val())}'` : ''}  
                        )"]}`, null);
                }
            } else if ($('#radioProduto').is(':checked')) {
                response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={
                        "tabela":"PRODUTO",
                        "camposSelect":[ "DISTINCT PRODUTO.CODIGO", "PRODUTO.DESCRICAO"],
                        "leftjoin": [{"tabela" : "PA_ITEN", "condicao" : "PRODUTO.CODIGO = PA_ITEN.CODIGO"}], 
                        "where": ["UDF_LEN(PRODUTO.CODIGO) > 0 
                        ${$('#txtDeposito').val() != '' ? ` AND PA_ITEN.DEPOSITO = '${pegaChave($('#txtDeposito').val())}'` : ''}  
                        "]}`, null);
            } else {
                response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={
                        "tabela":"MATERIAL",
                        "camposSelect":["DISTINCT MATERIAL.CODIGO", "MATERIAL.DESCRICAO"],
                        "leftjoin": [{"tabela" : "MAT_ITEN", "condicao" : "MATERIAL.CODIGO = MAT_ITEN.CODIGO"}], 
                        "where": ["UDF_LEN(MATERIAL.CODIGO) > 0 
                        ${$('#txtDeposito').val() != '' ? ` AND MAT_ITEN.DEPOSITO = '${pegaChave($('#txtDeposito').val())}'` : ''}  
                        "]}`, null);
            }

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgAlerta(jsonStr.RESULT[0].mensagem);
                return;
            }

            $('#tabelaProduto').DataTable({
                destroy: true,
                select: true,
                keys: true,
                searching: true,
                lengthChange: false,
                scrollCollapse: true,
                paging: true,
                "pagingType": "numbers",
                "language": {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar",
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                },

                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [{
                    "data": "CODIGO"
                },
                {
                    "data": "DESCRICAO"
                },
                ],
            });

            $('#tabelaProduto tbody').on('click', 'tr', async function () {
                $('#tabelaProduto').DataTable().$('tr.selected').removeClass('selected');
                $(this).addClass('selected');

                let data = $('#tabelaProduto').DataTable().row($(this)).data();
                if (data != undefined) {
                    await BuscaPreco(data.CODIGO);
                    await buscaFoto(data.CODIGO);
                }
                $('#modalItens').modal('show');
                // $("#tabelaItens tbody tr td")[0].click();
                $("#txtBarraRapida").focus();
            });

            if (jsonStr.RESULT[0].length == 1) {
                $("#tabelaProduto tbody tr td")[0].click();
            }

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgAlerta(`Não foi possível buscar os dados do cliente: ${error}`);

        }
    }

    criaDataTablePadrao('#tabelaProdutosConsultaEstoque', false, false, false, false, true, true, '200px');

    $('#modalConsultaEstoque').on('hidden.bs.modal', function () {
        // $('#tabelaProdutosConsultaEstoque').empty();
        limpaTabela();
        $('#txtDepositoConsultaEstoque').val('');
        $('#txtProdutoConsultaEstoque').val('');
        $('#txtGrupoConsultaEstoque').val('');
    });

    $('#radioProdutoC, #radioMaterialC').on('change', async function () {

        $('#btn-ProdutoConsultaEstoque').unbind();
        $('#txtProdutoConsultaEstoque').val('');

        const tipoConsulta = ($('#radioMaterialC').is(':checked') ? 'M' : 'P');
        if (tipoConsulta == 'M') {
            $("#txtProdutoConsultaEstoque").attr("placeholder", "Material");
            $("#labelProduto").text("Material");
            $('#btn-ProdutoConsultaEstoque').pesquisa_serverside(['#txtProdutoConsultaEstoque'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}', 'Pesquisa Material');
            $('#txtProdutoConsultaEstoque').autocompleta(1, `JSON={ "tabela":"material", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null }`);
            $('#btn-GrupoConsultaEstoque').pesquisa_serverside(['#txtGrupoConsultaEstoque'], ['CODIGO'], ['DESCRICAO'], '{"tabela": "grupo_ma", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Grupo');
            $('#txtGrupoConsultaEstoque').autocompleta(1, `JSON={ "tabela":"grupo_ma", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null }`);
        } else {
            $("#txtProdutoConsultaEstoque").attr("placeholder", "Produto");
            $("#labelProduto").text("Produto");
            $('#btn-ProdutoConsultaEstoque').pesquisa_serverside(['#txtProdutoConsultaEstoque'],
                ['CODIGO', 'DESCRICAO', 'CODIGO2'], ['CODIGO', 'DESCRICAO', 'CODIGO2'],
                '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2"], "where": null}',
                'Pesquisa Produto');
            $('#txtProdutoConsultaEstoque').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao", "codigo2"], "where": null}`);
            $('#btn-GrupoConsultaEstoque').pesquisa_serverside(['#txtGrupoConsultaEstoque'], ['CODIGO'], ['DESCRICAO'], '{"tabela": "grupo_pa", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Grupo');
            $('#txtGrupoConsultaEstoque').autocompleta(1, `JSON={ "tabela":"grupo_pa", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null }`);
        }
    });

    $('#btnAbrirConsultaEstoque').on('click', function () {
        $('#modalConsultaEstoque').modal('show');
        // $("#tabelaProdutosConsultaEstoque").DataTable().columns.adjust().draw(false);
    });
    $('#txtDepositoConsultaEstoque').autocompleta(1, `JSON={ "tabela":"deposito", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": ${filtroDeposito} }`);
    $('#txtProdutoConsultaEstoque').autocompleta(1, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao", "codigo2"], "where": null}`);
    $('#txtGrupoConsultaEstoque').autocompleta(1, `JSON={ "tabela":"grupo_pa", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null }`);

    $('#btn-DepositoConsultaEstoque').pesquisa('#txtDepositoConsultaEstoque', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"deposito", "camposSelect":[ "codigo", "descricao"], "where": ${filtroDeposito}}`, 'Pesquisa Depósito', 'deposito');
    $('#btn-ProdutoConsultaEstoque').pesquisa_serverside(['#txtProdutoConsultaEstoque'],
        ['CODIGO', 'DESCRICAO', 'CODIGO2'], ['CODIGO', 'DESCRICAO', 'CODIGO2'],
        '{"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO", "CODIGO2"], "where": null}',
        'Pesquisa Produto');
    $('#btn-GrupoConsultaEstoque').pesquisa_serverside(['#txtGrupoConsultaEstoque'], ['CODIGO'], ['DESCRICAO'], '{"tabela": "grupo_pa", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Grupo');

    $('#btn-limpa-DepositoConsultaEstoque').on('click', function () {
        $('#txtDepositoConsultaEstoque').val('');
    });

    $('#btn-limpa-ProdutoConsultaEstoque').on('click', function () {
        $('#txtProdutoConsultaEstoque').val('');
    });

    $('#btn-limpa-GrupoConsultaEstoque').on('click', function () {
        $('#txtGrupoConsultaEstoque').val('');
    })

    async function buscaEstoque(sTipo) {
        try {
            const where = await montaWherePesquisa();
            const campos = await montaCamposSelect(sTipo);
            const tabela = await montaTabela(sTipo);

            let dataSetCols = [];

            $.LoadingOverlay("show");

            for (let i = 0; i < campos.colunas.length; i++) {
                dataSetCols.push({
                    'title': campos.colunas[i],
                    'data': i
                });
            }

            const ajaxData = {
                "EMPRESA": getCookie('empresa'),
                "JSON": `{
                "tabela":"${tabela}", "camposSelect": ${campos.camposSelect},
                "leftJoin": [
                    {"tabela": "CADCOR","condicao": "CADCOR.COR = ${sTipo == 'P' ? 'PA_ITEN' : 'MAT_ITEN'}.COR"},
                    {"tabela": "${sTipo == 'P' ? 'PRODUTO' : 'MATERIAL'}", "condicao": "${sTipo == 'P' ? 'PA_ITEN' : 'MAT_ITEN'}.CODIGO = ${sTipo == 'P' ? 'PRODUTO' : 'MATERIAL'}.CODIGO"}
                    ${sTipo == 'P' ? ',{"tabela": "FAIXA_ITEN","condicao": "FAIXA_ITEN.FAIXA = PRODUTO.FAIXA AND PA_ITEN.TAM = FAIXA_ITEN.TAMANHO"}' : ''}
                ],
                "where": ["1=1 ${where}"]
                ${sTipo == 'P' ? ',"orderby": ["PA_ITEN.CODIGO, PA_ITEN.COR, FAIXA_ITEN.POSICAO"]' : ''}
            }`,
                "CLIENTE": 'N',
            };

            $('#tabelaProdutosConsultaEstoque').DataTable({
                paging: true,
                lengthChange: false,
                filter: false,
                info: true,
                lengthMenu: [8],
                order: false,
                autoWidth: true,
                destroy: true,
                serverSide: true,
                processing: true,
                ajax: {
                    url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
                    type: "GET",
                    headers: {
                        'Authorization': BASIC_AUTH
                    },
                    data: ajaxData,
                },
                "language": {
                    "sEmptyTable": "Nenhuma consulta realizada",
                    "sInfo": "_TOTAL_ registros",
                    "sInfoEmpty": " 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhuma consulta realizada",
                    "sSearch": "Pesquisar",
                    "oPaginate": {
                        "sNext": "Próximo",
                        "sPrevious": "Anterior",
                        "sFirst": "Primeiro",
                        "sLast": "Último"
                    },
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    }
                },
                columns: dataSetCols
            });
        } catch (error) {
            console.log(error)
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $('#btnConsultarEstoque').on('click', async function () {
        const tipoConsulta = ($('#radioMaterialC').is(':checked') ? 'M' : 'P');
        if ($('#tabelaProdutosConsultaEstoque')[0].rows.length > 0) {
            await limpaTabela();
        }
        await buscaEstoque(tipoConsulta);

    });

    async function montaWherePesquisa() {
        const tipoConsulta = ($('#radioMaterialC').is(':checked') ? 'M' : 'P');
        let deposito = pegaChave('#txtDepositoConsultaEstoque') != ''
            ? ` AND ${tipoConsulta == 'P' ? 'PA_ITEN'
                : 'MAT_ITEN'}.DEPOSITO = '${pegaChave('#txtDepositoConsultaEstoque')}'` :
            '';
        if ((deposito != '') && (filtroDeposito.replaceAll('["CODIGO IN (', '').replaceAll(')"]', '') != 'null')) {
            deposito = ` AND ${tipoConsulta == 'P' ? 'PA_ITEN' : 'MAT_ITEN'}.DEPOSITO IN (${filtroDeposito.replaceAll('["CODIGO IN (', '').replaceAll(')"]', '')})`;
        }
        let where = '';
        where += deposito;
        where += pegaChave('#txtProdutoConsultaEstoque') != '' ? ` AND ${tipoConsulta == 'P' ? 'PA_ITEN' : 'MAT_ITEN'}.CODIGO = '${pegaChave('#txtProdutoConsultaEstoque')}'` : '';
        where += pegaChave('#txtGrupoConsultaEstoque') != '' ? ` AND ${tipoConsulta == 'P' ? 'PRODUTO' : 'MATERIAL'}.GRUPO = '${pegaChave('#txtGrupoConsultaEstoque')}'` : '';

        return where;
    }

    async function montaTabela(tipo) {
        let tabela = '';

        if (tipo == 'M') {
            tabela = `MAT_ITEN`
        } else {
            tabela = `PA_ITEN`
        }

        return tabela;
    }

    async function montaCamposSelect(tipo) {
        let camposSelect = [];
        let colunas = [];

        if (tipo == 'M') {

            camposSelect = `["MAT_ITEN.CODIGO", "MAT_ITEN.BARRA", "MAT_ITEN.COR", "CADCOR.DESCRICAO DESC_COR", "MAT_ITEN.QTDE"]`;

            colunas = ["CODIGO", "BARRA", "COR", "DESC_COR", "QTDE"];

        } else {

            camposSelect = `["PA_ITEN.CODIGO", "PA_ITEN.COR", "CADCOR.DESCRICAO DESC_COR", "PA_ITEN.TAM", "PA_ITEN.BARRA", "PA_ITEN.BARRA28", "PA_ITEN.BARRACLI", "PA_ITEN.QUANTIDADE"]`;

            colunas = ["CODIGO", "COR", "DESC_COR", "TAM", "BARRA", "BARRA28", "BARRACLI", "QUANTIDADE"];

        }

        return objeto = {
            camposSelect: camposSelect,
            colunas: colunas
        };

    }

    // async function atualizaQtde(tipo) {
    //     if (tipo == 'M') {
    //         qtde_estoque = 0;
    //         qtde_estoque += $('#tabelaProdutosConsultaEstoque').DataTable().column(3, {}).data().sum();
    //         $('#txtQuantidadeItem').val(qtde_estoque);

    //     } else {
    //         qtde_estoque = 0;
    //         qtde_estoque += $('#tabelaProdutosConsultaEstoque').DataTable().column(6, {}).data().sum();
    //         $('#txtQuantidadeItem').val(qtde_estoque);
    //     }
    // }

    async function limpaTabela() {
        $('#tabelaProdutosConsultaEstoque').DataTable().destroy();
        $('#tabelaProdutosConsultaEstoque').empty();
    };

    $('#btnImprimir').on('click', function () {
        imprimirConsultaPrecosEstoque();
    });

    async function imprimirConsultaPrecosEstoque() {
        const tipo_item = $('#radioProdutoC').prop('checked') ? 'P' : 'M';
        const deposito = pegaChave('#txtDepositoConsultaEstoque');
        const codigo = pegaChave('#txtProdutoConsultaEstoque');
        const grupo = pegaChave('#txtGrupoConsultaEstoque');

        try {
            $.LoadingOverlay('show');

            const url = `/sisplan/impressao/v1/imprimir_consulta_precos_estoque?`;

            const bImprimeAutomatico = await verificaImprimirAutomatico('ConsultaPrecosEstoque');
            const arquivo = await GeraRelatorio(`${url}TIPO_ITEM=${tipo_item}&DEPOSITO=${deposito}&CODIGO=${codigo}&GRUPO=${grupo}`, 'GET', 1000000, false, 'ConsultaPrecosEstoque');
            if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                    window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
                }
                await limparRelatorios();
            }

        } catch (error) {
            console.error(error);
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $('#btnCameraPreco').on('click', function () {
        if (getCookie('protocolo') == 'http') {
            msgAlerta('Funcionalidade não habilitada, entre em contato com o Suporte da Sisplan!');
            return;
        }
        $('#modalCamera').modal('show');
        iniciaCamera();
    });

    if (!navigator.mediaDevices || !navigator.mediaDevices.enumerateDevices) {
        console.log("enumerateDevices() not supported.");
        return;
    }

    var backCamID;

    navigator.mediaDevices.enumerateDevices()
        .then(function (devices) {
            devices.forEach(function (device) {
                if (device.kind == "videoinput" && device.label.match(/back/) != null) {
                    backCamID = device.deviceId;
                }
            });
        })
        .catch(function (err) {
            console.log(err.name + ": " + err.message);
        });

    if (typeof (backCamID) == "undefined") {
        console.log("back camera not found.");
    }

    function iniciaCamera() {
        Quagga.init({
            locate: false,
            numOfWorkers: 2,
            inputStream: {
                name: "Live",
                type: "LiveStream",
                target: document.querySelector('#cam'),
                constraints: {
                    //  width: '100%',
                    //  height: '100%',
                    //  facingMode: "environment"
                    deviceId: backCamID
                },
                area: {
                    // update area if its small mobile
                    top: "32%",
                    right: "10%",
                    left: "10%",
                    bottom: "32%"
                }
            },
            decoder: {
                readers: ["code_128_reader"]
            },
        }, function (err) {
            if (err) {
                msgAlertaSemConfirmacao('Nenhum dispositivo com câmera encontrado para realizar a bipagem, verifique!', 'modalCamera');
                return;
            } else {

                fixiOSVideo();

                if (typeof resolve === "function") {
                    resolve.call(this);
                }
            }
            console.log("Initialization finished. Ready to start");
            Quagga.start();
        });

    }

    Quagga.onDetected(({ codeResult }) => {
        const regexBarra = /[^/\\a-zA-Z0-9]/;
        if (regexBarra.test(codeResult.code)) {
            return;
        }

        if (isValidCode(codeResult)) {
            Quagga.stop();
            $('#txtBarra').val(codeResult.code).trigger('blur');
            $('#modalCamera').modal('hide');
        }

        Quagga.lastScannedCode = codeResult.code;

    });

    Quagga.onProcessed((result) => {
        const drawingCtx = Quagga.canvas.ctx.overlay;

        clearDrow();

        if (result) {
            if (result.boxes) {
                if (!Quagga.drowBox) {
                    Quagga.drowBox = result.boxes[0];
                }

                Quagga.ImageDebug.drawPath(Quagga.drowBox, {
                    x: 0,
                    y: 1
                }, drawingCtx, {
                    color: "green",
                    lineWidth: 3
                });
            }

            const currentTime = Date.now();

            if (!Quagga.lastDetectingTime) {
                Quagga.lastDetectingTime = currentTime;
            }

            if (result.codeResult) {
                Quagga.lastDetectingTime = currentTime;
            } else if ((currentTime - Quagga.lastDetectingTime) / 1000 >= 2) {
                Quagga.lastDetectingTime = currentTime;
            }

            if (result.codeResult && result.codeResult.code) {
                Quagga.ImageDebug.drawPath(
                    result.line, {
                    x: "x",
                    y: "y"
                },
                    drawingCtx, {
                    color: "red",
                    lineWidth: 3
                }
                );
            }
        }
    });

    function clearDrow() {
        const drawingCtx = Quagga.canvas.ctx.overlay;
        const drawingCanvas = Quagga.canvas.dom.overlay;

        drawingCtx.clearRect(0, 0, parseInt(drawingCanvas.width), parseInt(drawingCanvas.height));
    }

    function fixiOSVideo() {
        const videoElement = Quagga.canvas.dom.overlay.parentElement.querySelector("video");

        setTimeout(() => { videoElement.play(); }, 10);
    }

    function isValidCode({ decodedCodes }) {
        const errors = decodedCodes.filter((x) => x.error !== undefined).map((y) => y.error); // TODO: use reduce
        const median = getMedian(errors);

        return median < 0.8;
    }

    function getMedian(arr) {
        const sorted = [...arr].sort((a, b) => a - b);
        const half = Math.floor(sorted.length / 2);

        if (arr.length % 2 === 1) {
            return arr[half];
        }

        return (arr[half - 1] + arr[half]) / 2;
    }

    $('#modalCamera').on('hidden.bs.modal', function () {
        Quagga.stop();
    });

});
