$(document).ready(async () => {
  const queryString = window.location.href;
  const parametros = queryString.split('/');
  const prioridadeProdutoMaterial = parametrosVenda[17] ?? '0';
  const parametrosPedido = await BuscaParametrosPedidoB2B();
  const idUsuario = await retornaIDUsuario();
  let numeroAtendimentoPedido = parametros[parametros.length - 1];
  let pedido = await retornaDadosPedido();

  navigator.geolocation.getCurrentPosition(async (position) => {
    sessionStorage.setItem('latitude', position.coords.latitude);
    sessionStorage.setItem('longitude', position.coords.longitude);
  });

  $('#txtQtdeCoresTotal').inputmask('numeric', {
    min: 0,
    positionCaretOnClick: 'select',
    digits: 2,
  }).on('focus', function () {
    const that = $(this);
    setTimeout(() => {
      that.select();
    }, 1);
  });
  $('#txtPercDescontoItens').inputmask('numeric', {
    min: 0,
    max: 99,
    positionCaretOnClick: 'select',
  }).on('focus', function () {
    const that = $(this);
    setTimeout(() => {
      that.select();
    }, 1);
  });

  if (prioridadeProdutoMaterial == '0') {
    $('#radioProduto').prop('checked', true);
    $('#radioProdutoPreco').prop('checked', true);
    $('#radioProdutoPreco').trigger('change');
  } else {
    $('#radioMaterial').prop('checked', true);
    $('#radioMaterialPreco').prop('checked', true);
    $('#radioProdutoPreco').trigger('change');
  }

  $('#txtDescontoItens').inputmask('numeric', {
    min: 0,
    positionCaretOnClick: 'select',
    digits: 2,
  }).on('focus', function () {
    const that = $(this);
    setTimeout(() => {
      that.select();
    }, 1);
  });

  $('.reacaoAtendimento').on('click', function () {
    $('.reacaoAtendimento').removeClass('selectedReacaoAtendimento');
    $(this).addClass('selectedReacaoAtendimento');
  });

  function msgConfirmacaoCancelarB2B($mensagem, $callbacks) {
    $("#modal-confirmacao-titulo").html("Atenção");
    $("#modal-confirmacao-conteudo").html($mensagem);
    if ($callbacks != undefined) {
      $("#modal-confirmacao-rodape").html(
        '<button title="Ao cancelar o atendimento, você perderá os dados que estão na tela." id="btn-cancelar-b2b" type="button" class="btn bg-gradient-danger btn-sisp">Cancelar Atendimento</button>' +
        '<button title="Desistir de cancelar o atendimento." type="button" class="btn bg-gradient-secondary btn-sisp" data-dismiss="modal">Voltar</button>'
      );
    }
    $("#modal-confirmacao").modal("show");
    $("#btn-cancelar-b2b").on("click", function () {
      if ($('#motivoSaida').val() == '') {
        $(".informeCancelamento").removeClass("d-none");
        return;
      }
      $(".informeCancelamento").addClass("d-none");
      $callbacks[0]();
      $("#modal-confirmacao").modal("hide");
    });
    $("#btn-cfm-pendente").on("click", function () {
      $callbacks[1]();
      $("#modal-confirmacao").modal("hide");
    });
  }

  async function montaJsonPedido() {
    const arquivoPedido = await retornaDadosPedido();
    pedido = {
      ...pedido,
      cliente: {
        codCli: pegaChave('#txtCliente'),
        CNPJ_Consumidor: $('#txtCNPJ').val(),
        nome_Consumidor: pegaDescricao('#txtCliente'),
        limiteCredito: $('#txtLimiteCreditoCli').val() ?? 0,
        limiteCreditoDisponivel: $('#txtLimiteCreditoCliDisp').val() ?? 0,
        creditoGrupo: $('#txtLimiteCreditoConsignado').val() ?? 0,
        creditoGrupoDisponivel: $('#txtLimiteCreditoConsignadoDisp').val() ?? 0,
        classificacao: $('#txtClassificacaoCliente').val(),
        dadosAdicionais: {
          endereco: $('#txtEnderecoInfo').val(),
          barro: $('#txtBairroInfo').val(),
          cep: $('#txtCEPClienteInfo').val(),
          cidade: $('#txtCidadeEstadoInfo').val(),
          telefone: $('#txtTelefoneInfoCliente').val(),
        },
      },
      vendedor: pegaChave('#txtVendedor'),
      designer: pegaChave('#txtDesigner'),
      nome_Vendedor: pegaDescricao('#txtVendedor'),
      responsavel: pegaChave('#txtResponsavel'),
      nome_responsavel: pegaDescricao('#txtResponsavel'),
      coordenador: pegaChave('#txtCoordenador'),
      nome_coordenador: pegaDescricao('#txtCoordenador'),
      formaContato: pegaChave('#txtFormaContato'),
      tabela: pegaChave('#txtTabela'),
      usuario: sessionStorage.getItem('g_usuario_logado'),
      observacao: $('#textDescricaoPedido').val() ? $('#textDescricaoPedido').val().toUpperCase() : '',
      data: `${formataData(new Date())}T00:00:00Z`,
      dataInicio: arquivoPedido ? arquivoPedido.dataInicio && arquivoPedido.dataInicio : `${formataDataCompleta(new Date())}`,
      latitude: sessionStorage.getItem('latitude'),
      longitude: sessionStorage.getItem('longitude'),
      numeroAtendimento: $('#txt_atendimento_atual').html(),
      itens: retornaItensPedido(),
      desistencias: retornaDesistencia(),
      datasPendentes: arquivoPedido ? arquivoPedido.datasPendentes && arquivoPedido.datasPendentes : [],
      statusPedido: arquivoPedido ? arquivoPedido.statusPedido && arquivoPedido.statusPedido : 'A',
      tempo: arquivoPedido ? arquivoPedido.tempo && arquivoPedido.tempo : '00:00:00',
      tiposPedidos: arquivoPedido ? separaItensPorTipo() : {
        programado: {
          numero: '',
          itens: [],
        },
        producao: {
          numero: '',
          itens: [],
        },
        pronta_entrega: {
          numero: '',
          itens: [],
        },
        mais_mix: {
          numero: '',
          itens: [],
        },
      },
    };
  }

  function retornaItensPedido() {
    const table = $('#tabelaItensMesa').DataTable().rows().data().toArray();
    const itens = table.map((data) => {
      const itens = {
        SITUACAO: data.SITUACAO,
        CODIGO: data.CODIGO,
        DESCRICAO: data.DESCRICAO,
        ACOES: data.ACOES,
        PRECO: data.PRECO,
        TIPO_ITEM: data.TIPO_ITEM,
        DATA: data.DATA,
        UNIDADE: data.UNIDADE,
        GRAMATURA: data.GRAMATURA,
        LARGURA: data.LARGURA,
        SITUACAO_CODIGO: data.SITUACAO_CODIGO,
        CORES: retornaCoresSelecionadas(data.CODIGO),
      };

      return itens;
    });

    return itens;
  }

  function retornaDesistencia() {
    const table = $('#tabelaDesistenciaItem').DataTable().rows().data()
      .toArray();
    const itens = table.map((data) => {
      const itens = {
        CODIGO: data.CODIGO,
        CODMEN: data.CODMEN,
        DESCRICAO: data.DESCRICAO,
      };

      return itens;
    });

    return itens;
  }

  function retornaCoresSelecionadas(codigo) {
    const data = $('#tabelaItensCompletos').DataTable().rows().data().toArray();

    const cores = data.filter((cor) => cor.CODIGO_ITEM == codigo);

    return cores;
  }

  async function carregaDadosUsuario() {
    const pesquisaParam = {
      tabela: 'ACESSO_USUARIOS',
      camposSelect: [
        'REPRESEN.CODREP',
        'REPRESEN.NOME NOME_REPRESEN',
        'PESSOAL.CODIGO',
        'PESSOAL.NOME NOME_FUNCIONARIO',
      ],
      leftJoin: [
        { tabela: 'REPRESEN', condicao: 'ACESSO_USUARIOS.CODREP = REPRESEN.CODREP' },
        { tabela: 'PESSOAL', condicao: 'ACESSO_USUARIOS.CODFUN = PESSOAL.CODIGO' },
      ],
      where: [`ACESSO_USUARIOS.CODIGO = '${sessionStorage.getItem('cod_usuario')}'`],
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr[0].CODREP != '') {
      $('#txtResponsavel').val(`[${jsonStr[0].CODREP}] - ${jsonStr[0].NOME_FUNCIONARIO}`);
      $('#txtResponsavel').attr('data-selecionado', true);
      $('#txtResponsavel').attr('disabled', true);
      $('#btn-Responsavel').attr('disabled', true);
      $('#btn-Limpa-Responsavel').attr('disabled', true);
    }
    if (jsonStr[0].CODIGO != '') {
      $('#txtVendedor').val(`[${jsonStr[0].CODIGO}] - ${jsonStr[0].NOME_REPRESEN}`);
      $('#txtVendedor').attr('data-selecionado', true);
      $('#txtVendedor').attr('disabled', true);
      $('#btn-Vendedor').attr('disabled', true);
      $('#btn-Limpa-Vendedor').attr('disabled', true);
    }

    $('#txtVendedor').trigger('change');
  }

  async function carregaDadosPedido() {
    try {
      $.LoadingOverlay('show');
      await carregaDadosUsuario();
      $('#txt_usuario_logado').text(sessionStorage.getItem('g_usuario_logado').toUpperCase());
      if (!pedido) {
        if ((numeroAtendimentoPedido == 'create') || (numeroAtendimentoPedido == 'create#')) {
          numeroAtendimentoPedido = await RetornaProximo('ATENDIMENTOSB2B', 'ATENDIMENTOSB2B', 'NUMERO_ATEND', 5)
          $('#txt_atendimento_atual').html(numeroAtendimentoPedido);
          window.history.pushState('', '', `${BASE_URI}/pedidosb2b/${numeroAtendimentoPedido}`);
        } else {
          $('#txt_atendimento_atual').html(numeroAtendimentoPedido);
        }
        await montaJsonPedido();
        await salvarArquivoPedido();
        await carregaDadosPedido();
        return;
      }
      const sTabela = pedido.tabela;
      const sVendedor = pedido.vendedor;
      const sCodCli = pedido.cliente.codCli;
      const sFormaContato = pedido.formaContato;
      const sResponsavel = pedido.responsavel;
      const sObservacao = pedido.observacao;

      if (pedido.numeroAtendimento == 'Novo') {
        pedido.numeroAtendimento = await RetornaProximo('ATENDIMENTOSB2B', 'ATENDIMENTOSB2B', 'NUMERO_ATEND', 5);
        $('#txt_atendimento_atual').html(pedido.numeroAtendimento);
      } else {
        $('#txt_atendimento_atual').html(pedido.numeroAtendimento);
      }

      mostraContador(pedido.dataInicio ? pedido.dataInicio : formataDataCompleta(new Data()));

      if (sCodCli != '') {
        await preencheDadosCliente(sCodCli);
        await carregaDadosClientes();
      }
      if (sTabela != '') {
        await preencheDadosTabelaPreco(sTabela);
      }
      if (sVendedor != '') {
        await preencheDadosVendedor(sVendedor);
      }
      if (sResponsavel != '') {
        await preencheDadosResponsavel(sResponsavel);
      }
      if (sFormaContato != '') {
        await preencheDadosFormaContato(sFormaContato);
      }

      if (sObservacao != '') {
        $('#textDescricaoPedido').val(sObservacao);
      }
      if (pedido.itens) {
        preencheItens(pedido.itens);
      }

      if (pedido.desistencias) {
        preencheDesistencia(pedido.desistencias);
      }

      $('#txtCliente').focus();
      //  aqui ve se da pra iniciar a tela direto nas ultimas abas ou apenas na aba informação
      if ((sTabela != '') && (sVendedor != '') && (sCodCli != '') && (sFormaContato != '') && (sResponsavel != '')) {
        if (($('#tabelaItensMesa').DataTable().rows().count() == 0) || (pedido.itens.filter((item) => item.CORES.length == 0 && item.SITUACAO_CODIGO == 'A'))) {
          $('#btnItens').trigger('click');
        } else {
          $('#btnFinalizaPedido').trigger('click');
        }
      }
      $('#tabelaItensMesa').DataTable().columns.adjust().draw(false);
      await validaParametros();
      atualizaTotaisPedido();
      await montaJsonPedido();
      pedido.dtAbriu = formataDataCompleta(new Date());
      pedido.statusPedido = 'A';
      await salvarArquivoPedido();
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function carregaTabelaComercial() {
    const jsonStr = await retornaJsonPesquisaPadrao(`
              {"tabela": "REGIAO", 
              "camposSelect": ["REGIAO, DESCRICAO"],
              "where": ["TIPO_TABELA = 'C' "] }
            `);

    if (jsonStr.length == 0) {
      return;
    }

    const regiao = jsonStr[0].REGIAO;
    const descricao = jsonStr[0].DESCRICAO;
    $('#txtTabela').val(`[${regiao}] - ${descricao}`);
    $('#txtTabela').attr('data-selecionado', true);
  }

  async function carregaTabelaRepresentante() {
    const sCodRep = pedido.vendedor == '' ? pegaChave('#txtVendedor') : pedido.vendedor;

    const jsonStr = await retornaJsonPesquisaPadrao(`
              {"tabela": "REPRESEN", 
              "camposSelect": ["REPRESEN.REGIAO, REGIAO.DESCRICAO"],
              "leftJoin": [{"tabela": "REGIAO", "condicao": "REGIAO.REGIAO = REPRESEN.REGIAO"}], 
              "where": ["CODCLI = '${sCodRep}' "] }
            `);

    if (jsonStr.length == 0) {
      return;
    }

    const regiao = jsonStr[0].REGIAO;
    const descricao = jsonStr[0].DESCRICAO;
    $('#txtTabela').val(`[${regiao}] - ${descricao}`);
    $('#txtTabela').attr('data-selecionado', true);
  }
  async function carregaTabelaCliente() {
    const sCodCli = pedido.cliente.codCli == '' ? pegaChave('#txtCliente') : pedido.cliente.codCli;

    const jsonStr = await retornaJsonPesquisaPadrao(`
              {"tabela": "ENTIDADE", 
              "camposSelect": ["ENTIDADE.TABELA, REGIAO.DESCRICAO"],
              "leftJoin": [{"tabela": "REGIAO", "condicao": "REGIAO.REGIAO = ENTIDADE.TABELA"}], 
              "where": ["CODCLI = '${sCodCli}' "] }
            `);

    if (jsonStr.length == 0) {
      return;
    }

    const regiao = jsonStr[0].REGIAO;
    const descricao = jsonStr[0].DESCRICAO;
    $('#txtTabela').val(`[${regiao}] - ${descricao}`);
    $('#txtTabela').attr('data-selecionado', true);
  }

  async function retornaIDUsuario() {
    const pesquisaParam = {
      tabela: 'ACESSO_USUARIOS',
      camposSelect: ['TIPO'],
      where: [`CODIGO = '${sessionStorage.getItem('cod_usuario')}'`],
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    return jsonStr;
  }

  function carregaTabelaPadraoParametro() {
    const tabelaPadrao = parametrosPedido[3].VALOR;
    if (tabelaPadrao == '') {
      msgAlerta('Tabela padrão não informada nos parametros, favor configurar os parametros');
      return
    }
    $('#txtTabela').val(tabelaPadrao)
  }

  async function verificaDeOndeCarregaTabelaDePreco() {
    const parametroCarregarTabelaDePreco = parametrosPedido[4].VALOR;

    if (parametroCarregarTabelaDePreco == 1) {
      await carregaTabelaRepresentante();
    }
    if (parametroCarregarTabelaDePreco == 2) {
      await carregaTabelaComercial();
    }
    if (parametroCarregarTabelaDePreco == 3) {
      await carregaTabelaCliente();
    }
    if (parametroCarregarTabelaDePreco == 4) {
      carregaTabelaPadraoParametro();
    }
  }

  function bloqueiaCamposTabela() {
    const parametroAlterarCampoTabelaPreco = parametrosPedido[2].VALOR;

    if (parametroAlterarCampoTabelaPreco == 0) {
      $('#txtTabela, #btn-tabela, #btn-limpa-tabela').attr('disabled', true);
    } else if (parametroAlterarCampoTabelaPreco == 1) {
      $('#txtTabela, #btn-tabela, #btn-limpa-tabela').attr('disabled', false);
    } else if (parametroAlterarCampoTabelaPreco == 2) {
      if (idUsuario[0].TIPO != 2) {
        $('#txtTabela, #btn-tabela, #btn-limpa-tabela').attr('disabled', true);
      } else {
        $('#txtTabela, #btn-tabela, #btn-limpa-tabela').attr('disabled', false);
      }
    }
  }

  function bloqueiaCamposVendedorResposavel() {
    const parametroBloquearAlterarVendedorResponsavel = parametrosPedido[1].VALOR;

    if (parametroBloquearAlterarVendedorResponsavel == 1) {
      $('#txtVendedor').attr('disabled', false);
      $('#btn-Vendedor').attr('disabled', false);
      $('#btn-Limpa-Vendedor').attr('disabled', false);
      $('#txtResponsavel').attr('disabled', false);
      $('#btn-Responsavel').attr('disabled', false);
      $('#btn-Limpa-Responsavel').attr('disabled', false);
    }
  }

  async function validaParametros() {
    const sTabela = pedido.tabela;
    if (sTabela == '') {
      await verificaDeOndeCarregaTabelaDePreco();
    }
    bloqueiaCamposVendedorResposavel();

    if (pegaChave('#txtTabela') != '') {
      bloqueiaCamposTabela();
    }
  }

  async function retornaDadosPedido() {
    if ((numeroAtendimentoPedido != 'create') && (numeroAtendimentoPedido != 'create#')) {
      if (!await verificaAtendimentoGravados()) {
        const hostname = `JsonPedido-${numeroAtendimentoPedido}`;
        const resp = await carregaPedidoNaoSalvo(hostname);

        if (resp.status != 200) {
          return;
        }

        const jsonStr = await resp.json();

        return jsonStr;
      }
      toastr.success(
        'Atendimento já finalizado. Redirecionando para novo atendimento.',
        'Confirmação',
        {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning',
          },
          positionClass: 'toast-top-center',
          progressBar: true,
          timeOut: 1800,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/pedidosb2b/create`;
          },
        },
      ).css({
        'margin-top': '20%',
        width: '500px',
        'max-width': '500px',
      });
    }
  }

  async function salvarArquivoPedido() {
    try {
      const response = await fetch(`../salvar_arquivo.php?tipo=JsonPedido&num_atendimento=${pedido.numeroAtendimento}`, {
        method: 'POST',
        body: `${JSON.stringify(pedido)}`,
      });
      return response;
    } catch (error) {
      msgAlerta('Erro ao salvar dados digitados!');
    }
  }

  async function deletaDadosNaoSalvos(sNomeMaquina) {
    let response;
    try {
      response = await fetch(`${BASE_URI}/deletar_arquivo.php?nomedoarquivo=${sNomeMaquina}`, {
        method: 'GET',
        body: null,
      });
    } catch (error) {
      return;
    }
    return response;
  }

  async function carregaPedidoNaoSalvo(sNomeMaquina) {
    let response;
    const myHeaders = new Headers();
    myHeaders.append('pragma', 'no-cache');
    myHeaders.append('cache-control', 'no-cache');
    try {
      response = await fetch(`../${sNomeMaquina}.txt`, {
        headers: myHeaders,
        method: 'GET',
        body: null,
      });
    } catch (error) {
      return;
    }
    return response;
  }

  async function preencheDadosVendedor(sCodRep) {
    try {
      const jsonStr = await retornaJsonPesquisaPadrao(`{"tabela": "represen", "camposSelect": ["nome"], "where": ["codrep = '${sCodRep}' "] }`);
      const nome = jsonStr[0].NOME;
      $('#txtVendedor').val(`[${sCodRep}] - ${nome}`);
      $('#txtVendedor').attr('data-selecionado', true);

      await retornaCooerdenador(sCodRep);
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados do vendedor.');
    }
  }

  async function retornaCooerdenador(sCodRep) {
    try {
      const jsonStr = await retornaJsonPesquisaPadrao(`{"tabela": "represen", "camposSelect": ["PESSOAL.CODIGO, PESSOAL.NOME"], "leftJoin": [{"tabela": "PESSOAL", "condicao": "PESSOAL.CODIGO = REPRESEN.COORDENADOR"}], "where": ["REPRESEN.CODREP = '${sCodRep}' "] }`);
      if (jsonStr.length > 0) {
        $('#txtCoordenador').val(`[${jsonStr[0].CODIGO}] - ${jsonStr[0].NOME}`);
        $('#txtCoordenador').attr('data-selecionado', true);
      }
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados do coordenador.');
    }
  }

  async function preencheDadosResponsavel(sCodResponsavel) {
    try {
      const jsonStr = await retornaJsonPesquisaPadrao(`{"tabela": "PESSOAL", "camposSelect": ["NOME"], "where": ["CODIGO = '${sCodResponsavel}' "] }`);
      const nome = jsonStr[0].NOME;
      $('#txtResponsavel').val(`[${sCodResponsavel}] - ${nome}`);
      $('#txtResponsavel').attr('data-selecionado', true);
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados do responsável.');
    }
  }

  async function preencheDadosFormaContato(sCodFormaContato) {
    try {
      const jsonStr = await retornaJsonPesquisaPadrao(`{"tabela": "TIPO_CONTATO", "camposSelect": ["DESCRICAO"], "where": ["CODIGO = '${sCodFormaContato}' "] }`);
      const nome = jsonStr[0].DESCRICAO;
      $('#txtFormaContato').val(`[${sCodFormaContato}] - ${nome}`);
      $('#txtFormaContato').attr('data-selecionado', true);
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados da forma de contato.');
    }
  }

  async function preencheDadosCliente(sCodCli) {
    try {
      const jsonStr = await retornaJsonPesquisaPadrao(`{"tabela": "ENTIDADE", "camposSelect": ["nome","cnpj"], "where": ["codcli = '${sCodCli}' "] }`);
      const nome = jsonStr[0].NOME;
      const cnpj = jsonStr[0].CNPJ;
      $('#txtCliente').val(`[${sCodCli}] - ${nome}`);
      $('#txtCliente').attr('data-selecionado', true);
      $('#txtCNPJ').val(cnpj);
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados do cliente.');
    }
  }

  async function preencheDadosTabelaPreco(sTabela) {
    try {
      const jsonStr = await retornaJsonPesquisaPadrao(`{"tabela": "REGIAO", "camposSelect": ["DESCRICAO"], "where": ["REGIAO = '${sTabela}' "] }`);
      const tabela = jsonStr[0].DESCRICAO;
      $('#txtTabela').val(`[${sTabela}] - ${tabela}`);
      $('#txtTabela').attr('data-selecionado', true);
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar os dados da tabela.');
    }
  }

  function adicionaItensPedido(itens, tabelaCompleta = false) {
    const tabela = tabelaCompleta ? '#tabelaItensCompletos' : '#tabelaItensMesa';
    $(tabela).DataTable().row.add(itens).draw(false);
    const $scrollBody = $($(tabela).DataTable().table().node()).parent();
    $scrollBody.scrollTop($scrollBody.get(0).scrollHeight);
  }

  function adicionaLinhaTabela(dados, tabela) {
    $(tabela).DataTable().row.add(dados).draw(false);
  }

  function preencheItens(itens) {
    itens.forEach((item) => {
      adicionaItensPedido(item);
      if (item.CORES.length > 0) {
        item.CORES.forEach((cor) => {
          adicionaItensPedido(cor, true);
        });
      }
    });
  }

  function preencheDesistencia(itens) {
    itens.forEach((item) => {
      adicionaLinhaTabela(item, '#tabelaDesistenciaItem');
    });
  }

  async function carregaSaldoCreditoCliente(codcli) {
    try {
      const pesquisaParam = {
        tabela: 'RECEBER',
        camposSelect: ['sum(VALOR) VALOR'],
        where: [`STATUS = 'ANTE' AND CODCLI = '${codcli}'`]
      };
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      $('#credito_cliente_saldo').html(jsonStr[0].VALOR);

    } catch (error) {
      console.error(error)
    }
  }

  async function carregaDadosInformativos(codcli) {
    try {
      const url = '/sisplan/pedidob2b/v1/informativos?';

      const response = await requisicao('GET', url, `CODCLI=${codcli}`, '');

      const json = await response.json();
      const valorInformativos = {
        titulosAVencer: json.titulosAVencer ? json.titulosAVencer.reduce((total, titulo) => total + titulo.saldo, 0) : 0,
        titulosVencidos: json.titulosVencidos ? json.titulosVencidos.reduce((total, titulo) => total + titulo.saldo, 0) : 0,
        creditoGrupoAVenc: json.creditoGrupoAVenc ? json.creditoGrupoAVenc.reduce((total, titulo) => total + titulo.saldo, 0) : 0,
        creditoGrupoVencidos: json.creditoGrupoVencidos ? json.creditoGrupoVencidos.reduce((total, titulo) => total + titulo.saldo, 0) : 0,
        creditoEmAberto: json.creditoEmAberto ? json.creditoEmAberto.reduce((total, titulo) => total + titulo.saldo, 0) : 0,
        chequesAVencer: json.chequesAVencer ? json.chequesAVencer.reduce((total, titulo) => total + titulo.saldo, 0) : 0,
        chequesVencidos: json.chequesVencidos ? json.chequesVencidos.reduce((total, titulo) => total + titulo.saldo, 0) : 0,
        pendenteAFaturar: json.pendenteAFaturar ? TruncaDecimaisNova(2, json.pendenteAFaturar.reduce((total, titulo) => total + titulo.saldo, 0)) : 0,
      }
      const credito = parseFloat($('#txtLimiteCreditoCli').val());
      const creditoDisp = TruncaDecimaisNova(2, credito + valorInformativos.creditoEmAberto - (valorInformativos.titulosAVencer + valorInformativos.titulosVencidos + valorInformativos.creditoGrupoAVenc + valorInformativos.creditoGrupoVencidos + valorInformativos.pendenteAFaturar + valorInformativos.chequesVencidos + valorInformativos.chequesAVencer))
      const creditoGrupoDisp = TruncaDecimaisNova(2, parseFloat($('#txtLimiteCreditoConsignado').val()) - valorInformativos.creditoGrupoVencidos)
      $('#txt_titulos_vencer').html(formataEmReais(valorInformativos.titulosAVencer));
      $('#txt_titulos_vencidos').html(formataEmReais(valorInformativos.titulosVencidos));
      $('#txt_titulosGrupo_vencer').html(formataEmReais(valorInformativos.creditoGrupoAVenc));
      $('#txt_titulosGrupo_vencidos').html(formataEmReais(valorInformativos.creditoGrupoVencidos));
      $('#txt_credito_antecipacao').html(formataEmReais(valorInformativos.creditoEmAberto));
      $('#txt_cheques_vencer').html(formataEmReais(valorInformativos.chequesAVencer));
      $('#txt_cheques_vencidos').html(formataEmReais(valorInformativos.chequesVencidos));
      $('#txt_pedidos_pendentes').html(formataEmReais(valorInformativos.pendenteAFaturar));
      $('#txtLimiteCreditoCliDispDisp').val(creditoDisp);
      $('#txtLimiteCreditoConsignadoDisp').val(creditoGrupoDisp);

      $('.collapseInformativos').trigger('click');


    } catch (error) {
      console.error(error)
    }
  }

  $('.collapsePedidos').on('click', function () {
    if ($($(this).find('i')[0]).hasClass('fa-angle-down')) {
      $($(this).find('i')[0]).removeClass('fa-angle-down');
      $($(this).find('i')[0]).addClass('fa-angle-right');
    } else {
      $($(this).find('i')[0]).removeClass('fa-angle-right');
      $($(this).find('i')[0]).addClass('fa-angle-down');
    }
  });

  $('.collapseInformativos').on('click', function () {
    if ($('.mostrarMaisInformativo').html().includes('Mostrar Mais')) {
      $('.mostrarMaisInformativo').html('Mostrar Menos <i class="fas fa-angle-up"></i>')
    } else {
      $('.mostrarMaisInformativo').html('Mostrar Mais <i class="fas fa-angle-down"></i>')
    }
  });

  // $('#btn-mostrar-informativos').on('click', function () {
  //   if ($('.mostrarMaisInformativo').html().include('Mostrar Menos')) {
  //     $('.mostrarMaisInformativo').html('Mostrar Menos <i class="fas fa-angle-up"></i>')
  //   } else {
  //     $('.mostrarMaisInformativo').html('Mostrar Mais <i class="fas fa-angle-down"></i>')
  //   }
  // })

  async function carregaDadosClientes() {
    const url = '/sisplan/funcoes/v1/pesquisa?';
    const sCodCli = pegaChave('#txtCliente');

    if ((!sCodCli) && (sCodCli == '')) {
      return;
    }

    try {
      const response = await requisicao('GET', url, encodeURIComponent(
        `JSON={ 
        "tabela":"entidade", 
        "camposSelect":["ENTIDADE.CLASSIFICA, ENTIDADE.CREDITO, ENTIDADE.BAIRRO, ENTIDADE.CEP, ENTIDADE.ENDERECO, ENTIDADE.TELEFONE, ENTIDADE.COD_PAIS, ENTIDADE.NUMERO, ENTIDADE.CRED_CONSIGNADO, HISTCP.CREDITO_GRUPO, (SUM(RECEBER.VALOR2+RECEBER.JUROS-RECEBER.VALOR_PAGO-RECEBER.VAL_DEV-RECEBER.DESCONTO)) AS ABERTO"], 
        "leftJoin": [
          {"tabela" : "receber", "condicao" : "entidade.codcli = receber.codcli AND RECEBER.STATUS = 'DUPL' AND receber.HISTORICO IN (SELECT HISTCP1.HISTORICO FROM HISTCP_001 HISTCP1 WHERE HISTCP1.LIMITE_CREDITO = 'S')"},
          {"tabela" : "histcp", "condicao" : "entidade.historico = histcp.historico"}
        ],
        "where": ["ENTIDADE.CODCLI = '${sCodCli}'"], 
        "groupBy": ["ENTIDADE.CLASSIFICA, ENTIDADE.CREDITO, ENTIDADE.CRED_CONSIGNADO, HISTCP.CREDITO_GRUPO, ENTIDADE.BAIRRO, ENTIDADE.CEP, ENTIDADE.ENDERECO, ENTIDADE.TELEFONE, ENTIDADE.COD_PAIS, ENTIDADE.NUMERO"]
    }`,
      ), null);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $('#txtTelefoneInfoCliente').val(jsonStr.RESULT[0][0].TELEFONE);
      $('#txtCEPClienteInfo').val(jsonStr.RESULT[0][0].CEP);
      $('#txtBairroInfo').val(jsonStr.RESULT[0][0].BAIRRO);
      $('#txtEnderecoInfo').val(jsonStr.RESULT[0][0].ENDERECO);
      $('#txtCidadeEstadoInfo').val(await BuscaCep(jsonStr.RESULT[0][0].CEP));
      $('#txtClassificacaoCliente').val(jsonStr.RESULT[0][0].CLASSIFICA);


      carregaLimiteCredito(jsonStr.RESULT[0][0]);
      carregaSaldoCreditoCliente(sCodCli);

      if (parametrosPedido[0].VALOR == 1) {
        // await carregaDuplicatas(sCodCli, 'S');
      }
      await carregaDadosInformativos(sCodCli);

    } catch (error) {
      console.error(error);
      $('#txtLimiteCreditoCli').val(0);
      $('#txtLimiteCreditoConsignado').val(0);
    }
  }

  async function carregaLimiteCredito(dados) {
    if (!dados) {
      $('#txtLimiteCreditoCli').val(0);
      $('#txtLimiteCreditoConsignado').val(0);
      return;
    }

    let credConsig = dados.CREDITO_GRUPO == 'S' ? dados.CRED_CONSIGNADO - dados.ABERTO : dados.CRED_CONSIGNADO;

    credConsig = ((dados.CREDITO != 0) && ((dados.CREDITO - dados.ABERTO) < credConsig)) ? dados.CREDITO - dados.ABERTO : credConsig;
    credConsig = (dados.CREDITO == 0) ? dados.CREDITO : credConsig;

    if (dados.CREDITO == 0) {
      $('#txtLimiteCreditoCli').val(0);
      if (dados.CRED_CONSIGNADO == 0) {
        $('#txtLimiteCreditoConsignado').val(parseFloat(credConsig).toFixed(2));
        return;
      }
      $('#txtLimiteCreditoConsignado').val(parseFloat(credConsig).toFixed(2));

      return;
    }
    $('#txtLimiteCreditoCli').val(parseFloat(dados.CREDITO).toFixed(2));

    if (dados.CRED_CONSIGNADO == 0) {
      $('#txtLimiteCreditoConsignado').val(parseFloat(credConsig).toFixed(2));
    } else {
      // $('#txtLimiteCreditoConsignadoDisp').val(parseFloat(dados.CRED_CONSIGNADO - dados.ABERTO).toFixed(2));
      $('#txtLimiteCreditoConsignado').val(parseFloat(dados.CRED_CONSIGNADO).toFixed(2));
    }
  }

  function retornaWhere(campo, valor) {
    const tipoConsulta = localStorage.getItem('@pedido.rgPesquisaTipo') ?? '1';

    const valorSeparado = valor.split(' ');
    const efetuaConsulta = {
      0: () => `${campo} LIKE ('${valor}[PERCENTUAL]')`,
      1: () => `(${valorSeparado.map((valor, i) => `${campo} LIKE ('[PERCENTUAL]${valorSeparado[i]}[PERCENTUAL]')`).toString().replaceAll(',', ' AND ')})`,
      2: () => `${campo} LIKE ('[PERCENTUAL]${valor}[PERCENTUAL]') `,
      3: () => `${campo} = ('${valor}') `,
    };
    return efetuaConsulta[tipoConsulta]();
  }

  async function montaSelectItens(bPesquisandoProduto) {
    const CampoConsulta = $('#txtCampoConsulta').val();
    const TabelaDePreco = pegaChave('#txtTabela');
    const tabelaEstoque = bPesquisandoProduto ? '"PRODUTO"' : '"MATERIAL"';
    let ligacaoTabelaPreco = '';
    const ligacaoGrupoMat = '';

    if (bPesquisandoProduto) {
      ligacaoTabelaPreco = ` {"tabela": "TABPRECO", "condicao": "TABPRECO.CODIGO = PRODUTO.CODIGO AND REGIAO = '${TabelaDePreco}'"}`;
    } else {
      ligacaoTabelaPreco = ` {"tabela": "TABPRECO", "condicao": " TABPRECO.CODIGO = MATERIAL.CODIGO AND REGIAO = '${TabelaDePreco}'"}`;
    }
    const camposSelect = bPesquisandoProduto ? '["PRODUTO.CODIGO, PRODUTO.DESCRICAO, TABPRECO.PRECO_00", "\'P\' TIPO"]'
      : '["MATERIAL.CODIGO, MATERIAL.DESCRICAO, MATERIAL.UNIDADE, TABPRECO.PRECO_00, MATERIAL.GRAMATURA, MATERIAL.LARGURA", "\'M\' TIPO"]';

    const camposWhereServerSide = bPesquisandoProduto ? '["PRODUTO.CODIGO", "PRODUTO.DESCRICAO", "PRODUTO.CODIGO2"]'
      : '["MATERIAL.CODIGO", "MATERIAL.DESCRICAO", "MATERIAL.CODIGO2"]';

    let Where = '';
    let orderby;

    if (bPesquisandoProduto) {
      Where += ' PRODUTO.ATIVO = \'S\'';
    } else {
      Where += ' MATERIAL.ATIVO = \'S\'';
    }

    if (CampoConsulta != '') {
      if (bPesquisandoProduto) {
        switch ($('#selectFiltros').val()) {
          case 'CODIGO':
            Where += ` ${retornaWhere('PRODUTO.CODIGO', CampoConsulta)}`;
            orderby = 'AND PRODUTO.CODIGO';
            break;
          case 'CODIGO2':
            Where += ` AND ${retornaWhere('PRODUTO.CODIGO2', CampoConsulta.toUpperCase())}`;
            orderby = 'PRODUTO.CODIGO2';
            break;
          case 'DESCRICAO':
            Where += ` AND ${retornaWhere('UPPER(PRODUTO.DESCRICAO)', CampoConsulta.toUpperCase())}`;
            orderby = 'PRODUTO.DESCRICAO';
            break;
          default:
            break;
        }
      } else {
        switch ($('#selectFiltros').val()) {
          case 'CODIGO':
            Where += ` AND ${retornaWhere('MATERIAL.CODIGO', CampoConsulta)}`;
            orderby = ' MATERIAL.CODIGO';
            break;
          case 'CODIGO2':
            Where += ` AND ${retornaWhere('MATERIAL.CODIGO2', CampoConsulta)}`;
            orderby = 'MATERIAL.CODIGO2';
            break;
          case 'DESCRICAO':
            Where += ` AND ${retornaWhere('UPPER(MATERIAL.DESCRICAO)', CampoConsulta.toUpperCase())}`;
            orderby = 'MATERIAL.DESCRICAO';
            break;
          default:
            break;
        }
      }
    } else if (bPesquisandoProduto) {
      switch ($('#selectFiltros').val()) {
        case 'CODIGO':
          orderby = 'PRODUTO.CODIGO';
          break;
        case 'CODIGO2':
          orderby = 'PRODUTO.CODIGO2';
          break;
        case 'DESCRICAO':
          orderby = 'PRODUTO.DESCRICAO';
          break;
      }
    } else {
      switch ($('#selectFiltros').val()) {
        case 'CODIGO':
          orderby = 'MATERIAL.CODIGO';
          break;
        case 'CODIGO2':
          orderby = 'MATERIAL.CODIGO2';
          break;
        case 'DESCRICAO':
        default:
          break;
      }
    }

    const ajaxData = {
      EMPRESA: getCookie('empresa'),
      JSON: encodeURIComponent(`{"tabela":${tabelaEstoque}, "camposWhereServerSide": ${camposWhereServerSide}, "camposSelect": ${camposSelect}, "leftJoin": [${ligacaoTabelaPreco}], "where": ["${Where}"], "orderby": ["${orderby}"]}`),
      CLIENTE: 'N',
    };

    return ajaxData;
  }

  async function RotinaCliqueFinalizaPedido() {
    $('#btnItens').prop('disabled', true);
    $('#btnInfo').prop('disabled', false);
    $('#btnFinalizaPedido').prop('disabled', true);
    fs_produtos = $('#fieldset_produto');
    fs_finalizaPedido = $('#fieldset_finalizaPedido');
    fs_info = $('#fieldset_info');

    $('#progressbar li').eq($('fieldset').index(fs_finalizaPedido)).addClass('active');
    fs_finalizaPedido.show();
    fs_produtos.animate({
      opacity: 0,
    }, {
      step(now) {
        opacity = 1 - now;
        fs_produtos.css({
          display: 'none',
          position: 'relative',
        });

        fs_info.css({
          display: 'none',
          position: 'relative',
        });

        fs_finalizaPedido.css({
          opacity,
        });
      },
      duration: 100,
    });

    $('#painelValorParcela').removeClass('col-sm-6');
    $('#painelValorParcela').addClass('col-sm-4');
    $('#PainelDesconto').removeClass('col-sm-6');
    $('#PainelDesconto').addClass('col-sm-4');
    $('#painelValorLiquido').removeClass('col-sm-6');
    $('#painelValorLiquido').addClass('col-sm-4');
  }

  function RotinaCliqueItens() {
    $('#btnItens').prop('disabled', true);
    $('#btnInfo').prop('disabled', false);
    $('#btnFinalizaPedido').prop('disabled', false);

    fs_produtos = $('#fieldset_produto');
    fs_finalizaPedido = $('#fieldset_finalizaPedido');
    fs_info = $('#fieldset_info');

    $('#progressbar li').eq($('fieldset').index(fs_produtos)).addClass('active');
    fs_produtos.show();
    fs_info.animate({
      opacity: 0,
    }, {
      step(now) {
        opacity = 1 - now;
        fs_finalizaPedido.css({
          display: 'none',
          position: 'relative',
        });

        fs_info.css({
          display: 'none',
          position: 'relative',
        });

        fs_produtos.css({
          opacity,
        });
      },
      duration: 100,
    });

    $('#tabelaItensMesa').DataTable().columns.adjust().draw(false);
    atualizaTotaisPedido();
  }

  function RotinaCliqueInfo() {
    $('#btnItens').prop('disabled', false);
    if ($('#collapsePedidos').html() == '') {
      $('#btnItens').prop('disabled', false);
    } else {
      $('#btnItens').prop('disabled', true);
    }
    $('#btnInfo').prop('disabled', true);
    $('#btnFinalizaPedido').prop('disabled', false);

    fs_produtos = $('#fieldset_produto');
    fs_finalizaPedido = $('#fieldset_finalizaPedido');
    fs_info = $('#fieldset_info');

    $('#progressbar li').eq($('fieldset').index(fs_info)).addClass('active');
    fs_info.show();
    fs_finalizaPedido.animate({
      opacity: 0,
    }, {
      step(now) {
        opacity = 1 - now;
        fs_produtos.css({
          display: 'none',
          position: 'relative',
        });

        fs_finalizaPedido.css({
          display: 'none',
          position: 'relative',
        });

        fs_info.css({
          opacity,
        });
      },
      duration: 100,
    });
    $('#txtResponsavel').focus();
  }


  async function consultaDupAberto(codcli, todasEmpresas) {
    let data = new Date();
    let vAVencer = 0;
    let vVencido = 0;
    let vAnteci = 0;
    let vCheqD = 0;
    let vAberto = 0;

    data = `${data.getUTCFullYear()}-${String(
      data.getUTCMonth() + 1
    ).padStart(2, 0)}-${String(data.getUTCDate()).padStart(2, 0)}`;

    const jsonStr = await buscaDuplicatasEmAberto(codcli, todasEmpresas);

    if (!jsonStr || jsonStr.length == 0) {
      return;
    }

    $("#tabela-duplicatas").DataTable().rows().remove().draw(false);

    $("#tabela-duplicatas").DataTable({
      paging: false,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      scrollY: "300px",
      autowidth: true,
      language: {
        sEmptyTable: "Nenhum registro encontrado",
        sInfo: "_TOTAL_ registros",
        sInfoEmpty: " 0 registros",
        sInfoFiltered: "(Filtrados de _MAX_ registros)",
        sInfoPostFix: "",
        sInfoThousands: ".",
        sLengthMenu: "_MENU_ resultados",
        sLoadingRecords: "Carregando...",
        sProcessing: "Processando...",
        sZeroRecords: "Nenhum registro encontrado",
        sSearch: "Pesquisar",
        oPaginate: {
          sNext: "Próximo",
          sPrevious: "Anterior",
          sFirst: "Primeiro",
          sLast: "Último",
        },
        oAria: {
          sSortAscending: ": Ordenar colunas de forma ascendente",
          sSortDescending: ": Ordenar colunas de forma descendente",
        },
      },
    });

    for (let i = 0; i < jsonStr.length; i++) {
      $("#tabela-duplicatas")
        .DataTable()
        .row.add([
          jsonStr[i].NUMERO,
          `${jsonStr[i].DT_EMISSAO.split("-")[2]}/${jsonStr[i].DT_EMISSAO.split("-")[1]
          }/${jsonStr[i].DT_EMISSAO.split("-")[0]}`,
          `${jsonStr[i].DT_VENCTO.split("-")[2]}/${jsonStr[i].DT_VENCTO.split("-")[1]
          }/${jsonStr[i].DT_VENCTO.split("-")[0]}`,
          jsonStr[i].STATUS,
          jsonStr[i].SALDO,
          jsonStr[i].EMP.replace("_", ""),
        ])
        .draw(false);
      if ((jsonStr[i].DT_VENCTO <= data) && (['DUPL', 'CHEQ'].includes(jsonStr[i].STATUS))) {
        vVencido = parseFloat(vVencido) + parseFloat(jsonStr[i].SALDO);
      } else if ((jsonStr[i].DT_VENCTO > data) && (['DUPL', 'CHEQ'].includes(jsonStr[i].STATUS))) {
        vAVencer = parseFloat(vAVencer) + parseFloat(jsonStr[i].SALDO);
      } else if (['ANTE'].includes(jsonStr[i].STATUS)) {
        vAnteci = parseFloat(vAnteci) + parseFloat(jsonStr[i].SALDO);
      } else if (['CHDE'].includes(jsonStr[i].STATUS)) {
        vCheqD = parseFloat(vCheqD) + parseFloat(jsonStr[i].SALDO);
      }
    }

    vAberto = parseFloat(vVencido) + parseFloat(vAVencer) + parseFloat(vCheqD) - parseFloat(vAnteci);
    $("#txtValDupVencer").html(vAVencer.toFixed(2));
    $("#txtValDupVencida").html(vVencido.toFixed(2));
    $("#txtValAntec").html(vAnteci.toFixed(2));
    $("#txtValChequeDevol").html(vCheqD.toFixed(2));
    $("#txtValTotAberto").html(vAberto.toFixed(2));
    $("#txtValDupVencida").css("color", "red");
    $("#txtValAntec").css("color", "green");
    $("#txtValChequeDevol").css("color", "purple");

    setTimeout(() => {
      $("#tabela-duplicatas").DataTable().columns.adjust().draw(false);
    }, 200);
  };

  async function carregaDuplicatas(codcli, todasEmpresas) {
    const bCliente = parametrosVenda[3];
    const bAtraso = parametrosVenda[23];
    if (pegaChave(bCliente) != codcli && bAtraso != '3') {
      try {
        await consultaDupAberto(codcli, todasEmpresas);
      } catch (error) {
        console.error(error);
      }
      if ($('#tabela-duplicatas').DataTable().rows().count() > 0) {
        $('#modal-receberabertos').modal('show');
      }
    }
  }

  $('#btn-confirmarduplicata').on('click', function () {
    $('#modal-receberabertos').modal('hide');
  });

  function retornaDiferencaDatasPendentes() {
    if (pedido.datasPendentes.length > 0) {
      const soma = pedido.datasPendentes.reduce((acumulador, data) => {
        const diferenca = Math.abs(new Date(formatarData(data.fim))) - Math.abs(new Date(formatarData(data.inicio)));
        return acumulador + diferenca;
      }, 0);

      return soma
    }

    return 0;

  }

  function mostraContador(dataInicioPedido) {
    const dataAtual = new Date();
    const dataInicio = new Date(dataInicioPedido);
    const somaPendentes = retornaDiferencaDatasPendentes();
    const diffEmMilissegundos = Math.abs(dataAtual - dataInicio) - somaPendentes;
    const diffEmSegundos = Math.floor(diffEmMilissegundos / 1000);

    iniciarContador(diffEmSegundos);
  }

  function atualizarRelogio(tempoTotal) {
    const segundos = tempoTotal % 60;
    const minutos = Math.floor(tempoTotal / 60) % 60;
    const horas = Math.floor(tempoTotal / 3600);
    const segundosStr = segundos.toString().padStart(2, '0');
    const minutosStr = minutos.toString().padStart(2, '0');
    const horasStr = horas.toString().padStart(2, '0');

    $('#txtContador').val(`${horasStr}:${minutosStr}:${segundosStr}`);
  }

  function iniciarContador(tempoTotal) {
    const intervalo = setInterval(() => {
      tempoTotal++;
      atualizarRelogio(tempoTotal);
    }, 1000);
  }

  async function BuscaCep(cep) {
    try {
      const response = await requisicao(
        'GET',
        '/sisplan/funcoes/v1/pesquisa?',
        `JSON={ "tabela":"CADCEP", "camposSelect":["CIDADE.NOME CIDADE", "CIDADE.COD_UF UF"], "leftJoin": [{"tabela": "CIDADE", "condicao": "CADCEP.CODMUN = CIDADE.CODIGO"}], "where": ["CADCEP.cep = '${cep}'"]}`,
        null,
      );
      if (!response) {
        var cidade = '';
        var uf = '';
      } else {
        const jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay('hide');
          msgErro(jsonStr.RESULT[0].mensagem);
          return;
        }

        return `${jsonStr.RESULT[0][0].CIDADE} / ${jsonStr.RESULT[0][0].UF}`;
      }
    } catch (error) {
      var cidade = '';
      var uf = '';
    }
    return [cidade, uf];
  }

  async function retornaBotaoOpcoes() {
    return (/* html */`
      <div style="text-align:center;"> 
        <div class="dropdown"> 
          <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
          </button> 
          <div class="dropdown-menu"> 
            <!-- <a class="dropdown-item btnInfoAdc" href="">Informações adicionais</a> -->
            <!-- <div class="dropdown-divider"></div> -->
            <a class="dropdown-item btnDesistir">Desistir</a> 
            <div class="dropdown-divider"></div>
            <a class="dropdown-item btn-imprimir-estoque">Imprimir Estoque</a> 
            <!-- <div class="dropdown-divider"></div> -->
            <!-- <a class="dropdown-item btn-imprimir-ft">Imprimir FT</a>  -->
            <!-- <div class="dropdown-divider"></div> -->
          </div>
        </div>
      </div>
    `);
  }

  function atualizaTotaisPedido() {
    const data = $('#tabelaItensMesa').DataTable().rows().data().toArray();
    const totalItensMesa = $('#tabelaItensMesa').DataTable().rows().count();
    const totalCarrinho = $('#tabelaItensCompletos').DataTable().rows().count();
    const itensFechados = data.filter((item) => item.SITUACAO_CODIGO == 'F').length;
    const itensAtendidos = data.filter((item) => item.SITUACAO_CODIGO != 'A').length ?? 0;
    const itensDesistidos = data.filter((item) => item.SITUACAO_CODIGO == 'D').length;
    const subtotal_Pedido = $('#tabelaItensCompletos').DataTable().column(7, {}).data().sum();
    const descontos = $('#tabelaItensCompletos').DataTable().column(3, {}).data().sum();
    const credito_cliente_saldo = $('#credito_cliente_saldo').html();

    $('#comparativoPedido').html(itensFechados);
    $('#comparativoAtendido').html(`${itensAtendidos ?? 0}/${totalItensMesa}`);
    $('#comparativoAproveitamento').html(TruncaDecimaisNova(2, (100 / totalItensMesa) * itensFechados));
    $('#total_itensQuantidades').html(totalCarrinho);
    $('#total_itensCarrinhos').html(totalCarrinho);
    $('#subtotal_Pedido').html(formataEmReais(subtotal_Pedido - descontos));
    $('#total_desc').html(formataEmReais(descontos));
    $('#total_orig').html(formataEmReais(subtotal_Pedido));
    $('#saldo_geral').html(formataEmReais(Number(credito_cliente_saldo) - Number(subtotal_Pedido)));
  }

  function separaItensPorTipo() {
    const itens = $('#tabelaItensCompletos').DataTable().rows().data()
      .toArray()
      .map((item) => ({
        codigo: item.CODIGO_ITEM,
        cor: item.COR,
        tam: 0,
        qtde: item.QTDE,
        qtde_orig: item.QTDE,
        preco: item.PRECO,
        desc_item: item.VALOR_DESC,
        tipo: 'M',
        deposito: item.ESTOQUE,
        ordem: 1,
        ordem_compra: item.ORDEM_COMPRA,
        itemBase: item.CODIGO_BASE,
        comando: item.CODIGO_ITEM
      }));

    const itens_Programado = itens.filter((item) => item.ordem_compra);
    const itens_Producao = itens.filter((item) => item.itemBase != '');
    const itens_Pronta_entrega = itens.filter((item) => item.deposito != '8080' && !item.ordem_compra && item.itemBase == '');
    const itens_Venda_mais_mix = itens.filter((item) => item.deposito == '8080');

    return {
      programado: {
        ...pedido.tiposPedidos.programado,
        itens: itens_Programado,
      },
      producao: {
        ...pedido.tiposPedidos.producao,
        itens: itens_Producao,
      },
      pronta_entrega: {
        ...pedido.tiposPedidos.pronta_entrega,
        itens: itens_Pronta_entrega,
      },
      mais_mix: {
        ...pedido.tiposPedidos.mais_mix,
        itens: itens_Venda_mais_mix,
      },
    };
  }

  // function separaItensPorDepositos() {
  //   try {

  //   } catch (error) {
  //     console.error(error)
  //   }
  // }

  async function selecionaEmpresaDemo() {
    const pesquisaParam = {
      tabela: 'EMPRESA',
      camposSelect: ['EMP_DEMO'],
      where: [`EMP_ID = '${getCookie('emp_id')}'`],
    };
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    return jsonStr;
  }

  async function adicionaEmpresas(tipo) {
    const pesquisaParam = {
      tabela: 'EMPRESA',
      camposSelect: ['EMP_PAT', 'EMP_NOME'],
      where: ['1 = 1'],
    };
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    empDemo = await selecionaEmpresaDemo();
    jsonStr.map((emp) => {
      $(`#selectEmpFaturamento-${tipo}`).append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', ''), null, empDemo ? empDemo[0].EMP_DEMO : emp.EMP_PAT == getCookie('empresa')));
    });
  }

  function desabilitaCamposFinalizaPedido(tipo) {
    $(`#selectEmpFaturamento-${tipo}`).attr('disabled', true);
    $(`#txtGrupoPedido-${tipo}`).attr('disabled', true);
    $(`#txtStatusPedido-${tipo}`).attr('disabled', true);
    $(`#txtTransportadora-${tipo}`).attr('disabled', true);
    $(`#txtDtFaturaFinalizaPedido-${tipo}`).attr('disabled', true);
    $(`#txtTipoPedido-${tipo}`).attr('disabled', true);
    $(`#txtOperacaoFiscal-${tipo}`).attr('disabled', true);
    $(`#textDescricaoPedido-${tipo}`).attr('disabled', true);
    $(`#selectFrete-${tipo}`).attr('disabled', true);
    $(`#txtFrete-${tipo}`).attr('disabled', true);
    $(`#txtDtEntregaPrevFinalizaPedido-${tipo}`).attr('disabled', true);
    $(`#txtDtEntregaPrevFinalizaPedido-${tipo}`).attr('disabled', true);
    $(`#txtMoeda-${tipo}`).attr('disabled', true);
    $(`#txtEntradaPedido-${tipo}`).attr('disabled', true);
    $(`#txtSaldoPedido-${tipo}`).attr('disabled', true);
    $(`#txtCondEspecial-${tipo}`).attr('disabled', true);
    $(`#btnGravarPedido-${tipo}`).attr('disabled', true);
    $(`#txtCondPagamento-${tipo}`).attr('disabled', true);

    $(`#finalizarPedido-${tipo} .collapsePedidos`).trigger('click');
  }

  async function verificaPedidosGravados(tipo) {
    const pedidoGravado = await retornaJsonPesquisaPadrao(`{"tabela": "PEDIDO", "camposSelect": ["NUMERO"], "where": ["NUMERO = '${pedido.tiposPedidos[tipo.toLowerCase()].numero}'"] }`);

    return pedidoGravado.length > 0;
  }

  async function verificaAtendimentoGravados() {
    const atendimentoGravado = await retornaJsonPesquisaPadrao(`{"tabela": "ATENDIMENTOSB2B", "camposSelect": ["NUMERO_ATEND"], "where": ["NUMERO_ATEND = '${numeroAtendimentoPedido}' AND STATUS = 'F'"] }`);
    return atendimentoGravado.length > 0;
  }

  async function carregaInformacaoPedidoGravado(tipo) {
    try {
      if (pedido.tiposPedidos[tipo.toLowerCase()].grupo != '') {
        const grupo = await retornaJsonPesquisaPadrao(`{"tabela": "GRUPO_PED", "camposSelect": ["CODIGO, DESCRICAO"], "where": ["CODIGO = '${pedido.tiposPedidos[tipo.toLowerCase()].grupo}'"] }`);
        insereValor(`#txtGrupoPedido-${tipo}`, grupo[0].CODIGO, grupo[0].DESCRICAO);
      }

      if (pedido.tiposPedidos[tipo.toLowerCase()].status != '') {
        const status = await retornaJsonPesquisaPadrao(`{"tabela": "SITPROD", "camposSelect": ["CODIGO, DESCRICAO"], "where": ["CODIGO = '${pedido.tiposPedidos[tipo.toLowerCase()].status}'"] }`);
        insereValor(`#txtStatusPedido-${tipo}`, status[0].CODIGO, status[0].DESCRICAO);
      }
      if (pedido.tiposPedidos[tipo.toLowerCase()].tab_trans != '') {
        const transportadora = await retornaJsonPesquisaPadrao(`{"tabela": "TABTRAN", "camposSelect": ["CODIGO, NOME"], "where": ["CODIGO = '${pedido.tiposPedidos[tipo.toLowerCase()].tab_trans}'"] }`);
        insereValor(`#txtTransportadora-${tipo}`, transportadora[0].CODIGO, transportadora[0].NOME);
      }
      if (pedido.tiposPedidos[tipo.toLowerCase()].id_tipo != '') {
        const tipoPedido = await retornaJsonPesquisaPadrao(`{"tabela": "TIPO", "camposSelect": ["ID_TIPO, DESCRICAO"], "where": ["ID_TIPO = '${pedido.tiposPedidos[tipo.toLowerCase()].id_tipo}'"] }`);
        insereValor(`#txtTipoPedido-${tipo}`, tipoPedido[0].ID_TIPO, tipoPedido[0].DESCRICAO);
      }
      if (pedido.tiposPedidos[tipo.toLowerCase()].operacao != '') {
        const operacao = await retornaJsonPesquisaPadrao(`{"tabela": "OPER_FISCAL", "camposSelect": ["CODIGO, DESCRICAO"], "where": ["CODIGO = '${pedido.tiposPedidos[tipo.toLowerCase()].operacao}'"] }`);
        insereValor(`#txtOperacaoFiscal-${tipo}`, operacao[0].CODIGO, operacao[0].DESCRICAO);
      }
      if (pedido.tiposPedidos[tipo.toLowerCase()].moeda != '') {
        const moeda = await retornaJsonPesquisaPadrao(`{"tabela": "MOEDA", "camposSelect": ["CODMOE, DESCRICAO"], "where": ["CODMOE = '${pedido.tiposPedidos[tipo.toLowerCase()].moeda}'"] }`);
        insereValor(`#txtMoeda-${tipo}`, moeda[0].CODMOE, moeda[0].DESCRICAO);
      }
      if (pedido.tiposPedidos[tipo.toLowerCase()].cond_pagtos[0].codcond != '') {
        const condPagto = await retornaJsonPesquisaPadrao(`{"tabela": "CONDICAO", "camposSelect": ["CODCOND, DESCRICAO"], "where": ["CODCOND = '${pedido.tiposPedidos[tipo.toLowerCase()].cond_pagtos[0].codcond}'"] }`);
        insereValor(`#txtCondPagamento-${tipo}`, condPagto[0].CODCOND, condPagto[0].DESCRICAO);
      }

      $(`#selectEmpFaturamento-${tipo}`).val(pedido.tiposPedidos[tipo.toLowerCase()].emp_fat);
      $(`#txtDtEntregaPrevFinalizaPedido-${tipo}`).val(pedido.tiposPedidos[tipo.toLowerCase()].entrega);
      $(`#txtDtFaturaFinalizaPedido-${tipo}`).val(pedido.tiposPedidos[tipo.toLowerCase()].dt_fatura);
      $(`#textDescricaoPedido-${tipo}`).val(pedido.tiposPedidos[tipo.toLowerCase()].obs);
      $(`#selectFrete-${tipo}`).val(pedido.tiposPedidos[tipo.toLowerCase()].cif);
      $(`#txtFrete-${tipo}`).val(pedido.tiposPedidos[tipo.toLowerCase()].frete);
      $(`#txtValorPedido-${tipo}`).val(pedido.tiposPedidos[tipo.toLowerCase()].cond_pagtos[0].valor);
      $(`#txtEntradaPedido-${tipo}`).val(pedido.tiposPedidos[tipo.toLowerCase()].val_entrada);

      $('.collapsePedidos').on('click', function () {
        if ($($(this).find('i')[0]).hasClass('fa-angle-down')) {
          $($(this).find('i')[0]).removeClass('fa-angle-down');
          $($(this).find('i')[0]).addClass('fa-angle-right');
        } else {
          $($(this).find('i')[0]).removeClass('fa-angle-right');
          $($(this).find('i')[0]).addClass('fa-angle-down');
        }
      });

      if (pedido.tiposPedidos[tipo.toLowerCase()].statusPedido == 'F') {
        if (await verificaPedidosGravados(tipo)) {
          desabilitaCamposFinalizaPedido(tipo);
        }
      }
    } catch (error) {
      console.error(error);
    }
  }

  async function separaPedidosPorItem() {
    $('#collapsePedidos').html(' ');
    if (pedido.tiposPedidos.programado.itens.length > 0) {
      await geraCardPedidos(pedido.tiposPedidos.programado, 'PROGRAMADO');
      if (pedido.tiposPedidos.programado.statusPedido == 'F') {
        await carregaInformacaoPedidoGravado('PROGRAMADO');
      }
    }
    if (pedido.tiposPedidos.producao.itens.length > 0) {
      await geraCardPedidos(pedido.tiposPedidos.producao, 'PRODUCAO');
      if (pedido.tiposPedidos.producao.statusPedido == 'F') {
        await carregaInformacaoPedidoGravado('PRODUCAO');
      }
    }
    if (pedido.tiposPedidos.pronta_entrega.itens.length > 0) {
      await geraCardPedidos(pedido.tiposPedidos.pronta_entrega, 'PRONTA_ENTREGA');
      if (pedido.tiposPedidos.pronta_entrega.statusPedido == 'F') {
        await carregaInformacaoPedidoGravado('PRONTA_ENTREGA');
      }
    }
    if (pedido.tiposPedidos.mais_mix.itens.length > 0) {
      await geraCardPedidos(pedido.tiposPedidos.mais_mix, 'MAIS_MIX');
      if (pedido.tiposPedidos.mais_mix.statusPedido == 'F') {
        await carregaInformacaoPedidoGravado('MAIS_MIX');
      }
    }
  }

  function formatarData(data) {
    const partes = data.split('T');
    const dataPartes = partes[0].split('-');
    const horaPartes = partes[1].split(':');

    const ano = dataPartes[0];
    const mes = dataPartes[1];
    const dia = dataPartes[2];
    const hora = horaPartes[0].padStart(2, '0');
    const minuto = horaPartes[1].padStart(2, '0');
    const segundo = horaPartes[2];

    return `${ano}-${mes}-${dia}T${hora}:${minuto}:${segundo}`;
  }

  $('#btnDeixarPendente').on('click', async () => {
    try {
      $.LoadingOverlay('show');
      const dataInicio = formataDateTimeBackEnd(pedido.dtAbriu);
      const dataFim = formataDateTimeBackEnd(formataDataCompleta(new Date()));
      pedido.datasPendentes.push({ inicio: dataInicio, fim: dataFim });
      pedido.statusPedido = 'P';
      pedido.tempo = $('#txtContador').val();
      salvarArquivoPedido();
      if (pedido.tiposPedidos.producao.numero != '') {
        await gravaAtendimentoPendente(pedido.tiposPedidos.producao.numero);
      }
      if (pedido.tiposPedidos.programado.numero != '') {
        await gravaAtendimentoPendente(pedido.tiposPedidos.programado.numero);
      }
      if (pedido.tiposPedidos.pronta_entrega.numero != '') {
        await gravaAtendimentoPendente(pedido.tiposPedidos.pronta_entrega.numero);
      }
      if (pedido.tiposPedidos.mais_mix.numero != '') {
        await gravaAtendimentoPendente(pedido.tiposPedidos.mais_mix.numero);
      }
      toastr.success(
        `Atendimento gravado como pendente!`,
        'Confirmação',
        {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning',
          },
          positionClass: 'toast-top-center',
          progressBar: true,
          timeOut: 2000,
          fadeOut: 1000,
          onHidden() {
            window.location.href = `${BASE_URI}/pedidosb2b`;
          },
        },
      ).css({
        'margin-top': '20%',
        width: '500px',
        'max-width': '500px',
      });

    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function retornaValidacaoComercial(item) {
    const desconto = await Promise.all(item.itens.map(async (it) => {
      const [json] = await retornaJsonPesquisaPadrao(`{ "tabela": "tabpreco", "camposSelect": ["DESC_MAX"], "where": ["CODIGO = '${it.codigo}' "] } `);
      const perc_desc = TruncaDecimaisNova(2, (parseFloat(it.desc_item) / (parseFloat(it.preco) * it.qtde)) * 100);

      if (json) {
        return {
          desc_max: json.DESC_MAX,
          perc_desc
        }
      } else {
        return {
          desc_max: 0,
          perc_desc: 0
        }
      }
    }));
    const passouLimiteMaximo = desconto.filter((a) => a.desc_max < a.perc_desc).length > 0

    return passouLimiteMaximo;
  }

  async function retornaPedidoComEntrada(codcli) {
    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "PEDIDO", "camposSelect": ["VAL_ENTRADA"], "where": ["VAL_ENTRADA > 0 AND CODCLI = '${codcli}' "] } `);
    return json.length > 0;
  }

  async function retornaMoedaBoleto(moeda) {
    if (moeda == '') {
      return false
    }
    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "MOEDA", "camposSelect": ["FORMA_PAGTO"], "where": ["CODMOE = '${moeda}' "] } `);

    return json[0].FORMA_PAGTO == 15;
  }

  async function retornaValidacaoMoeda(hist) {
    if (hist == '') {
      return false
    }
    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "HISTCP", "camposSelect": ["CREDITO_GRUPO, LIMITE_CREDITO"], "where": ["HISTORICO = '${hist}' "] } `);

    if (!json) {
      return {
        creditoGrupo: false,
        limiteCredito: false,
      }
    }
    return {
      creditoGrupo: json[0].CREDITO_GRUPO == 'S',
      limiteCredito: json[0].LIMITE_CREDITO == 'S',
    };
  }

  async function retornaHistoricoMoeda(moeda) {
    if (moeda == '') {
      return '';
    }
    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "MOEDA", "camposSelect": ["HISTORICO"], "where": ["CODMOE = '${moeda}' "] } `);

    if (json.length == 0) {
      return '';
    }
    return json[0].HISTORICO;
  }

  async function retornaValidacaoFinanceiro(tipo) {
    const url = '/sisplan/pedidob2b/v1/informativos?';
    const codcli = pegaChave('#txtCliente');
    const response = await requisicao('GET', url, `CODCLI=${codcli}`, '');
    const json = await response.json();
    const pedidosComEntradaAberta = await retornaPedidoComEntrada(codcli);
    const moeda = pegaChave(`#txtMoeda-${tipo}`);
    const hist = await retornaHistoricoMoeda(moeda);
    const validacaoMoeda = await retornaValidacaoMoeda(hist);
    const titulosVencidos = json.titulosVencidos ? json.titulosVencidos.reduce((total, titulo) => total + titulo.saldo, 0) : 0;


    if ((validacaoMoeda.limiteCredito) || (validacaoMoeda.creditoGrupo)) {
      // CLIENTE COM DUPLICATAS VENCIDAS.

      if (validacaoMoeda.limiteCredito) {
        if (titulosVencidos > 0) {
          return true;
        }
      }

      if (validacaoMoeda.creditoGrupo) {
        // PEDIDO QUE FOR DUPLICATAS (BOLETO), SÓ PRECISA VALIDAR LIMITE GLOBAL.
        if ((await retornaMoedaBoleto(moeda)) && (parseFloat($('#txtLimiteCreditoCliDispDisp').val()) <= 0)) {
          return true
        }
        // CLIENTE SEM LIMITE DE CREDITO GLOBAL
        if (parseFloat($('#txtLimiteCreditoCliDispDisp').val()) <= 0) {
          return true
        }
      }
    }
    // PEDIDOS QUE TIVER QUALQUER VALOR DE ENTRADA INFORMADO
    if (pedidosComEntradaAberta) {
      return true
    }

    return false;
  }

  async function validaStatusPedido(item, tipo) {
    // cada tipo de venda tem suas particularidades por isso esses if feio.
    const valorEntrada = parseFloat($(`#txtEntradaPedido-${tipo}`).val());
    const valorPedido = parseFloat($(`#txtValorPedido-${tipo}`).val());
    const percEntrada = TruncaDecimaisNova(2, (valorEntrada / valorPedido) * 100);

    const validacaoComercial = await retornaValidacaoComercial(item);
    const validacaoFinanceiro = await retornaValidacaoFinanceiro(tipo);

    if (validacaoComercial) {
      $(`#txtStatusPedido-${tipo}`).val('[35] - AGUARDANDO LIB. COMERCIAL');
      $(`#txtStatusPedido-${tipo}`).attr('data-selecionado', true);
    } else {
      if (validacaoFinanceiro) {
        $(`#txtStatusPedido-${tipo}`).val('[36] - AGUARDANDO LIB. FINANCEIRO');
        $(`#txtStatusPedido-${tipo}`).attr('data-selecionado', true);
      } else {
        if (tipo == 'PRONTA_ENTREGA') {
          $(`#txtStatusPedido-${tipo}`).val('[40] - LIBERADO PARA EXPEDIÇÃO');
          $(`#txtStatusPedido-${tipo}`).attr('data-selecionado', true);
        }
        if (tipo == 'PROGRAMADO') {
          $(`#txtStatusPedido-${tipo}`).val('[73] - AGUARDANDO PRODUTO O.C');
          $(`#txtStatusPedido-${tipo}`).attr('data-selecionado', true);
        }
        if (tipo == 'MAIS_MIX') {
          $(`#txtStatusPedido-${tipo}`).val('[75] - AGUARDANDO PRODUTO MAIS MIX');
          $(`#txtStatusPedido-${tipo}`).attr('data-selecionado', true);
        }
        if (tipo == 'PRODUCAO') {
          if (percEntrada >= 20) {
            $(`#txtStatusPedido-${tipo}`).val('[37] - LIBERADO PRODUÇÃO');
            $(`#txtStatusPedido-${tipo}`).attr('data-selecionado', true);
            $(`#txtStatusPedido-${tipo}`).attr('disabled', true);
          } else {
            $(`#txtStatusPedido-${tipo}`).val('[55] - AGUARDANDO PAGAMENTO');
            $(`#txtStatusPedido-${tipo}`).attr('data-selecionado', true);
            $(`#txtStatusPedido-${tipo}`).attr('disabled', true);
          }
        }
      }
    }
  }

  async function gravaValores(item, tipo) {

    if (tipo == 'PRONTA_ENTREGA') {
      $(`#txtTipoPedido-${tipo}`).val('[32] - ATACADO PRONTA ENTREGA');
      $(`#txtTipoPedido-${tipo}`).attr('data-selecionado', true);
    }
    if (tipo == 'PROGRAMADO') {
      $(`#txtTipoPedido-${tipo}`).val('[33] - ATACADO PROGRAMADO');
      $(`#txtTipoPedido-${tipo}`).attr('data-selecionado', true);
    }
    if (tipo == 'PRODUCAO') {
      $(`#txtTipoPedido-${tipo}`).val('[34] - ATACADO PRODUÇÃO');
      $(`#txtTipoPedido-${tipo}`).attr('data-selecionado', true);
    }
    if (tipo == 'MAIS_MIX') {
      $(`#txtTipoPedido-${tipo}`).val('[45] - ATACADO MAIS MIX');
      $(`#txtTipoPedido-${tipo}`).attr('data-selecionado', true);
    }

    await adicionaEmpresas(tipo);

    $(`#txtGrupoPedido-${tipo}`).val();
    $(`#txtDtEntregaPrevFinalizaPedido-${tipo}`).val();
    $(`#txtEntradaPedido-${tipo}`).val();
    $(`#selectFrete-${tipo}`).val();
    $(`#txtTransportadora-${tipo}`).val();
    $(`#txtOperacaoFiscal-${tipo}`).val();
    $(`#textDescricaoPedido-${tipo}`).val();
    $('#txtValorTotalPedidos').html(formataEmReais($('#tabelaItensCompletos').DataTable().column(7, {}).data().sum() - $('#tabelaItensCompletos').DataTable().column(3, {}).data().sum()));

    $('.maskDecimais').maskMoney({
      decimal: '.',
      thousands: '',
      precision: 2,
    });
    $('.maskDecimais').on('blur', function () {
      if ($(this).val() == '') {
        $(this).val('0.00');
      }
    });

    if (tipo == 'PROGRAMADO') {
      const json = await retornaJsonPesquisaPadrao(`{"tabela": "COMPRA", "camposSelect": ["DT_ENTREGA"], "where": ["NUMERO = '${item.itens[0].ESTOQUE ? item.itens[0].ESTOQUE : item.itens[0].deposito}'"] }`);
      const dataRecebida = new Date(json[0].DT_ENTREGA);
      dataRecebida.setUTCHours(0);
      const deslocamentoFusoHorario = dataRecebida.getTimezoneOffset();
      dataRecebida.setMinutes(dataRecebida.getMinutes() + deslocamentoFusoHorario);
      setarDataPraFrente('txtDtFaturaFinalizaPedido-PROGRAMADO', dataRecebida, 5);
    } else if (tipo == 'PRONTA_ENTREGA') {
      setarDataAtual('txtDtFaturaFinalizaPedido-PRONTA_ENTREGA', false, 2);
    } else if (tipo == 'PRODUCAO') {
      setarDataAtual('txtDtFaturaFinalizaPedido-PRODUCAO', false, 7);
    } else if (tipo == 'MAIS_MIX') {
      setarDataAtual('txtDtFaturaFinalizaPedido-MAIS_MIX', false, 5);
    }

    const valorPedido = $.map(item.itens, (obj) => (obj.preco * obj.qtde) - parseFloat(obj.desc_item)).reduce((a, b) => a + b, 0);

    $(`#txtValorPedido-${tipo}`).val(TruncaDecimaisNova(2, valorPedido));
    parseFloat($(`#txtEntradaPedido-${tipo}`).val())
    if ($(`#txtEntradaPedido-${tipo}`).val() != '') {
      $(`#txtSaldoPedido-${tipo}`).val(TruncaDecimaisNova(2, valorPedido - parseFloat($(`#txtEntradaPedido-${tipo}`).val())));
    } else {
      $(`#txtSaldoPedido-${tipo}`).val(TruncaDecimaisNova(2, valorPedido));
    }

    if ((!pedido.tiposPedidos[tipo.toLowerCase()].numero) || (pedido.tiposPedidos[tipo.toLowerCase()].numero == '')) {
      pedido.tiposPedidos[tipo.toLowerCase()].numero = await RetornaProximo('PEDIDO', 'PEDIDO', 'NUMERO', 5);
    }

    pedido.tiposPedidos[tipo.toLowerCase()] = {
      ...pedido.tiposPedidos[tipo.toLowerCase()],
      numero: pedido.tiposPedidos[tipo.toLowerCase()].numero,
    };

    await montaJsonPedido();
    await salvarArquivoPedido();
  }

  async function geraCardPedidos(item, tipo) {
    try {
      cardPedidos(tipo);
      await gravaValores(item, tipo);
    } catch (error) {
      console.error(error);
    }
  }

  function cardPedidos(tipo) {
    $('#collapsePedidos').append(/* html */`
          <div class="card card-header collapseHeader" role="tab" id="finalizarPedido-${tipo}">
            <a style="width:100%;" class="collapsePedidos" data-toggle="collapse" data-parent="#collapsePedido-${tipo}" href="#collapsePedido-${tipo}" aria-expanded="true" aria-controls="collapseOne1">
              <div class="row">
                <div class="iconCollapse" style="max-width:20px;margin-top:auto; margin-bottom: auto" class="col-1">
                  <i class="fas fa-angle-down"></i>
                </div>
                <div class="col-11">
                  <h4 class="title-page">
                    Pedido ${tipo === 'PRODUCAO' ? 'Produção' : tipo === 'PRONTA_ENTREGA' ? 'Pronta Entrega' : tipo === 'PROGRAMADO' ? 'Programado' : 'Mais Mix'}
                  </h4>
                </div>
              </div>
            </a>
          </div>
          <div class="collapse show" id="collapsePedido-${tipo}">
            <div class="card card-body">
              
              <div class="row mt-3">
                <div class="col-lg-4 col-12" id="divTipoPedido">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtTipoPedido-${tipo}">Tipo de Pedido</label>
                  <div class="input-group">
                    <input type="text" disabled="true" data-selecionado="false" class="input-default focus form-control txtTipoPedido" id="txtTipoPedido-${tipo}" name="txtTipoPedido-${tipo}" placeholder="Tipo de Pedido">
                    <div class="input-group-append">
                      <button class="btn bg-danger btn-TipoPedido" disabled="true" id="btn-TipoPedido-${tipo}" name="btn-TipoPedido-${tipo}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger btn-limpa-TipoPedido" disabled="true" id="btn-limpa-TipoPedido-${tipo}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-lg-4 col-12" id="divGrupoPedido">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtGrupoPedido-${tipo}">Grupo Pedido
                    </label>
                    <div class="input-group">
                      <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtGrupoPedido-${tipo}" name="txtGrupoPedido-${tipo}" placeholder="Grupo Pedido">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-GrupoPedido-${tipo}" name="btn-GrupoPedido-${tipo}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-GrupoPedido-${tipo}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-lg-4 col-12 d-none" id="divStatusPedido">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtStatusPedido-${tipo}">Status Pedido</label>
                  <div class="input-group">
                    <input disabled="true" type="text" data-selecionado="false" class="input-default focus form-control" id="txtStatusPedido-${tipo}" name="txtStatusPedido-${tipo}" placeholder="Status Pedido">
                    <div class="input-group-append">
                      <button disabled="true" class="btn bg-danger" id="btn-StatusPedido-${tipo}" name="btn-StatusPedido-${tipo}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button disabled="true" class="btn bg-danger" id="btn-limpa-StatusPedido-${tipo}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-lg-4 col-12" id="divOperacaoFiscal">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtOperacaoFiscal-${tipo}">Operação Fiscal
                  </label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtOperacaoFiscal-${tipo}" name="txtOperacaoFiscal-${tipo}" placeholder="Operação Fiscal">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-OperacaoFiscal-${tipo}" name="btn-OperacaoFiscal-${tipo}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-OperacaoFiscal-${tipo}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>
              
              <div class="row mt-2">
                <div class="col-lg-4 col-12 form-group mb-0">
                  <label class="mb-0">Emp. Faturamento</label>
                  <div class="input-group mb-0">
                    <select class="form-control select2 select2-danger focus selectEmpFaturamento" id="selectEmpFaturamento-${tipo}" name="selectEmpFaturamento-${tipo}" data-dropdown-css-class="select2-danger">
                    </select>
                  </div>
                </div>

                <div class="col-lg-4 col-12 form-group mb-0">
                  <label class="mb-0" data-error="wrong" data-success="left" for="selectFrete-${tipo}">Frete por Conta</label>
                  <select style="width:100%;" class="form-control select2 select2-danger focus custom-select focus mb-0" data-dropdown-css-class="select2-danger" id="selectFrete-${tipo}">
                    <option value="">Selecione um transportador</option>
                    <option value="0">0 - Contratação do Frete por conta do Remetente(CIF)</option>
                    <option value="1">1 - Contratação do Frete por conta do Destinatário(FOB)</option>
                    <option value="2">2 - Contratação do Frete por conta de Terceiros </option>
                    <option value="3">3 - Transporte Próprio por conta do Remetente</option>
                    <option value="4">4 - Transporte Próprio por conta do Destinatário </option>
                    <option selected value="9">9 - Sem Ocorrência de Transporte</option>
                  </select>
                </div>

                <div class="col-lg-4 col-12" id="divTransportadora">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtTransportadora-${tipo}">Transportadora</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control" id="txtTransportadora-${tipo}" name="txtTransportadora-${tipo}" placeholder="Transportadora">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Transportadora-${tipo}" name="btn-Transportadora-${tipo}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Transportadora-${tipo}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
              </div>

              <div class="row mt-2 mb-0">
                <div class="col-lg-2 col-4" id="tourValorPedido">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtValorPedido-${tipo}">Valor Pedido
                  </label>
                  <input type="text" class="input-default focus form-control maskDecimais" disabled="true" id="txtValorPedido-${tipo}" aria-describedby="codError" name="txtValorPedido-${tipo}" placeholder="Valor Pedido">
                </div>

                <div class="col-lg-2 col-4" id="tourSaldoPedido">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtSaldoPedido-${tipo}">Saldo
                  </label>
                  <input disabled="true" type="text" class="input-default focus form-control maskDecimais" id="txtSaldoPedido-${tipo}" aria-describedby="codError" name="txtSaldoPedido-${tipo}" placeholder="Saldo">
                </div>

                <div class="col-lg-4 col-4" id="tourEntradaPedido">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtEntradaPedido-${tipo}">Valor Entrada
                  </label>
                  <input type="text" class="input-default focus form-control maskDecimais" id="txtEntradaPedido-${tipo}" aria-describedby="codError" name="txtEntradaPedido-${tipo}" placeholder="Valor Entrada">
                </div>


                <div class="col-lg-4 col-4" id="tourFrete">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtFrete-${tipo}">Valor Frete
                  </label>
                  <input type="text" class="input-default focus form-control maskDecimais" id="txtFrete-${tipo}" aria-describedby="codError" name="txtFrete-${tipo}" placeholder="Valor Frete">
                </div>
              </div>
            
              <div class="row mt-2">
                <div class="col-lg-4 col-6" id="divMoeda">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtMoeda-${tipo}">Moeda</label>
                  <div class="input-group">
                    <input type="text" data-selecionado="false" class="input-default focus form-control txtMoeda" id="txtMoeda-${tipo}" name="txtMoeda-${tipo}" placeholder="Moeda">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Moeda-${tipo}" name="btn-Moeda-${tipo}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Moeda-${tipo}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-lg-4 col-6" id="divCondPagamento">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtCondPagamento-${tipo}">Condição Pagamento
                  </label>
                  <div class="input-group">
                    <input disabled="true" type="text" data-selecionado="false" class="input-default focus form-control" id="txtCondPagamento-${tipo}" name="txtCondPagamento-${tipo}" placeholder="Condição Pagamento">
                    <div class="input-group-append">
                      <button class="btn bg-danger" disabled="true" id="btn-CondPagamento-${tipo}" name="btn-CondPagamento-${tipo}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" disabled="true" id="btn-limpa-CondPagamento-${tipo}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-lg-2 col-4 form-group d-none" id="tourCondEspecial">
                  <label data-error="wrong" class="mb-0" data-success="right" for="txtCondEspecial-${tipo}">
                  </label>
                  <input type="text" class="input-default focus form-control" id="txtCondEspecial-${tipo}" aria-describedby="codError" name="txtCondEspecial-${tipo}" placeholder="Cond. Especial">
                </div>
                
                <div class="col-lg-2 col-4">
                  <label data-error="wrong" data-success="right" for="txtDtFaturaFinalizaPedido-${tipo}" style="margin-bottom: 0px;">Prev. Fatura</label>
                  <input disabled type="date" class="input-default" id="txtDtFaturaFinalizaPedido-${tipo}" name="txtDtFaturaFinalizaPedido-${tipo}">
                </div>
                <div class="col-lg-2 col-4">
                  <label data-error="wrong" data-success="right" for="txtDtEntregaPrevFinalizaPedido-${tipo}" style="margin-bottom: 0px;">Entrega</label>
                  <input type="date" class="input-default" id="txtDtEntregaPrevFinalizaPedido-${tipo}" name="txtDtEntregaPrevFinalizaPedido-${tipo}">
                </div>
              </div>

              <div class="row mt-2">
                <div class="col-12">
                  <label class="mb-0" for="textDescricaoPedido-${tipo}">Observação</label>
                  <textarea name="" class="input-default focus form-control" id="textDescricaoPedido-${tipo}" cols="30" rows="5" placeholder="Descrição Pedido"></textarea>
                </div>
              </div>

              <div class="row mt-2">
                <div class="col-12 d-flex justify-content-end">
                  <button id="btnGravarPedido-${tipo}" type="button" class="btn btn-lg btn-sisp btn-success btnGravarPedido">Confirmar</button>
                </div>
              </div>
            </div>
          </div>
        `);

    $(".focus").bind("keypress", function (e) {
      if (e.keyCode == 13) {
        var inps = $(".focus:not('.d-none')"); //$("input, select, textarea"); //add select too
        for (var x = 0; x < inps.length; x++) {
          if (inps[x] == this) {
            while ((inps[x + 1] !== undefined) && ((inps[x]).id == (inps[x + 1]).id)) {
              x++;
            }
            if (($(inps[x + 1]).prop('disabled') && ((x + 1) < inps.length))) {
              x++;
              if ((x + 1) < inps.length) {

                $(inps[x + 1]).focus();
              } else {
                $(inps[0]).focus();
              }
            } else {
              if ((x + 1) < inps.length) {
                $(inps[x + 1]).focus();
              } else { $(inps[0]).focus(); }
            }
          }
        }
        e.preventDefault();
      }
    });

    $(`#btn-limpa-TipoPedido-${tipo}`).on('click', () => { $(`#txtTipoPedido-${tipo}`).val(''); });
    $(`#btn-TipoPedido-${tipo}`).pesquisa(`#txtTipoPedido-${tipo}`, 'ID_TIPO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TIPO", "camposSelect":[ "ID_TIPO", "DESCRICAO" ], "where": null}', 'Pesquisa Tipo Venda', 'TIPO');
    $(`#txtTipoPedido-${tipo}`).autocompleta(1, 'JSON={ "tabela":"TIPO", "camposSelect":["ID_TIPO CHAVE, DESCRICAO DESCRICAO"], "where": null}');

    $(`#btn-limpa-Transportadora-${tipo}`).on('click', () => { $(`#txtTransportadora-${tipo}`).val(''); });
    $(`#btn-Transportadora-${tipo}`).pesquisa(`#txtTransportadora-${tipo}`, 'CODIGO', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABTRAN", "camposSelect":[ "CODIGO", "NOME" ], "where": null}', 'Pesquisa Transportadora', 'tabtran');
    $(`#txtTransportadora-${tipo}`).autocompleta(1, 'JSON={ "tabela":"TABTRAN", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": null}');

    $(`#txtOperacaoFiscal-${tipo}`).autocompleta(1, 'JSON={ "tabela":"OPER_FISCAL", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}');
    $(`#btn-OperacaoFiscal-${tipo}`).pesquisa(`#txtOperacaoFiscal-${tipo}`, 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"OPER_FISCAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Operação', 'OPER_FISCAL');
    $(`#btn-limpa-OperacaoFiscal-${tipo}`).on('click', () => { $(`#txtOperacaoFiscal-${tipo}`).val(''); });

    $(`#txtGrupoPedido-${tipo}`).autocompleta(1, 'JSON={ "tabela":"GRUPO_PED", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}');
    $(`#btn-GrupoPedido-${tipo}`).pesquisa(`#txtGrupoPedido-${tipo}`, 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"GRUPO_PED", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Grupo Ped', 'GRUPO_PED');
    $(`#btn-limpa-GrupoPedido-${tipo}`).on('click', () => { $(`#txtGrupoPedido-${tipo}`).val(''); });

    $(`#txtStatusPedido-${tipo}`).autocompleta(1, 'JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}');
    $(`#btn-StatusPedido-${tipo}`).pesquisa(`#txtStatusPedido-${tipo}`, 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Status', 'SITPROD');
    $(`#btn-limpa-StatusPedido-${tipo}`).on('click', () => { $(`#txtStatusPedido-${tipo}`).val(''); });

    $(`#txtMoeda-${tipo}`).autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":["MOEDA.CODMOE CHAVE, MOEDA.DESCRICAO DESCRICAO"], "leftJoin": [{"tabela": "ENT_MOEDA", "condicao": "MOEDA.CODMOE = ENT_MOEDA.CODMOE"}],  "where": ["ENT_MOEDA.CODCLI = '${pegaChave('#txtCliente')}'"]}`);
    $(`#btn-Moeda-${tipo}`).pesquisa(`#txtMoeda-${tipo}`, 'CODMOE', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MOEDA", "camposSelect":[ "MOEDA.CODMOE", "MOEDA.DESCRICAO" ], "leftJoin": [{"tabela": "ENT_MOEDA", "condicao": "MOEDA.CODMOE = ENT_MOEDA.CODMOE"}],  "where": ["ENT_MOEDA.CODCLI = '${pegaChave('#txtCliente')}' "]}`, 'Pesquisa Moeda', 'moeda');
    $(`#btn-limpa-Moeda-${tipo}`).on('click', () => {
      $(`#txtMoeda-${tipo}`).val('');
      $(`#txtCondPagamento-${tipo}`).val('');
    });

    $(`#txtEntradaPedido-${tipo}`).on('blur', async function () {
      const valorPedido = $(`#txtValorPedido-${tipo}`).val();
      const saldoPedido = TruncaDecimaisNova(2, parseFloat(valorPedido) - parseFloat($(`#txtEntradaPedido-${tipo}`).val()));

      $(`#txtSaldoPedido-${tipo}`).val(isNaN(saldoPedido) ? 0 : saldoPedido);
    })

    $('.txtMoeda').on('blur', async function () {
      $(`#txtCondPagamento-${tipo}`).val('');
      $(`#txtNrParcelas-${tipo}`).val('0');
      $(`#txtIntervaloDias-${tipo}`).val('0');
      $(`#txtCondPagamento-${tipo}`).unbind('autocompleta');
      $(`#txtCondPagamento-${tipo}`).autocompleta(1, 'JSON={ "tabela":"COND_MOEDA", "camposSelect":["CODCOND CHAVE, CODCOND DESCRICAO"], "where": [] }', [], [], []);
      $(`#btn-CondPagamento-${tipo}`).off();
      $(`#btn-CondPagamento-${tipo}`).unbind('pesquisa');
      $(`#btn-CondPagamento-${tipo}`).pesquisa_array(
        [`#txtCondPagamento-${tipo}`],
        ['CODCOND'],

        ['DESCRICAO'],
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"COND_MOEDA", 
        "camposSelect":[ "COND_MOEDA.CODCOND", "CONDICAO.DESCRICAO" ],
        "innerjoin": [{ "tabela" : "CONDICAO", "condicao" : "COND_MOEDA.CODCOND = CONDICAO.CODCOND" }], 
        "where": ["COND_MOEDA.MOEDA = '${$(this).attr('data-chave')}'"]}`,
        'Pesquisa Condição',
        'COND_MOEDA',
      );
      $(`#txtCondPagamento-${tipo}`).prop('disabled', false);
      $(`#btn-CondPagamento-${tipo}`).prop('disabled', false);
      $(`#btn-limpa-Condicao-${tipo}`).prop('disabled', false);

      await validaStatusPedido(pedido.tiposPedidos[tipo.toLowerCase()], tipo);
    });

    function validaCamposPreenchidos(tipo) {
      // if ($(`#txtTransportadora-${tipo}`).val() == '') {
      //   msgAlerta('Campo Transportadora não preenchido!');
      //   return false;
      // }
      // if ($(`#txtGrupoPedido-${tipo}`).val() == '') {
      //   msgAlerta('Campo Grupo Pedido não preenchido!');
      //   return false;
      // }
      if ($(`#txtDtFaturaFinalizaPedido-${tipo}`).val() == '') {
        msgAlerta('Campo de Fatura Prevista não preenchido!');
        return false;
      }
      // if ($(`#txtDtEntregaPrevFinalizaPedido-${tipo}`).val() == '') {
      //   msgAlerta('Campo de Entrega Prevista não preenchido!');
      //   return false;
      // }
      // if ($(`#txtFrete-${tipo}`).val() == '') {
      //   msgAlerta('Campo Frete não preenchido!');
      //   return false;
      // }
      if ($(`#selectEmpFaturamento-${tipo}`).val() == '') {
        msgAlerta('Campo Empresa Faturamento não preenchido!');
        return false;
      }
      // if ($(`#txtTipoPedido-${tipo}`).val() == '') {
      //   msgAlerta('Campo Tipo do Pedido não preenchido!');
      //   return false;
      // }
      // if ($(`#txtStatusPedido-${tipo}`).val() == '') {
      //   msgAlerta('Campo Status do Pedido não preenchido!');
      //   return false;
      // }
      // if ($(`#txtEntradaPedido-${tipo}`).val() == '') {
      //   msgAlerta('Campo Entrada não preenchido!');
      //   return false;
      // }
      // if ($(`#txtSaldoPedido-${tipo}`).val() == '') {
      //   msgAlerta('Campo Saldo não preenchido!');
      //   return false;
      // }
      // if ($(`#txtValorPedido-${tipo}`).val() == '') {
      //   msgAlerta('Campo Valor Pedido não preenchido!');
      //   return false;
      // }
      if ($(`#txtMoeda-${tipo}`).val() == '') {
        msgAlerta('Campo Moeda não preenchido!');
        return false;
      }
      if ($(`#txtCondPagamento-${tipo}`).val() == '') {
        msgAlerta('Campo Condição de Pagamento não preenchido!');
        return false;
      }
      // if ($(`#txtCondEspecial-${tipo}`).val() == '') {
      //   msgAlerta('Campo Condição especial não preenchido!')
      //   return false;
      // }
      // if ($(`#txtOperacaoFiscal-${tipo}`).val() == '') {
      //   msgAlerta('Campo Operação fiscal não preenchido!')
      //   return false;
      // }
      // if ($(`#textDescricaoPedido-${tipo}`).val() == '') {
      //   msgAlerta('Campo Descrição não preenchido!')
      //   return false;
      // }

      return true;
    }

    function retornaItens(tipo) {
      const itens = pedido.tiposPedidos[tipo.toLowerCase()].itens.map((item) => ({
        codigo: item.codigo,
        cor: item.cor,
        tam: 0,
        qtde: item.qtde,
        qtde_orig: item.qtde_orig,
        preco: item.preco,
        desc_item: item.desc_item,
        tipo: 'M',
        deposito: item.deposito,
        ordem: 1,
      }));

      return itens;
    }

    function retornaCondPagto(tipo) {
      return [{
        dias: '',
        dt_vencto: $(`#txtDtFaturaFinalizaPedido-${tipo}`).val(),
        moeda: pegaChave(`#txtMoeda-${tipo}`),
        codcond: pegaChave(`#txtCondPagamento-${tipo}`),
        valor: $(`#txtValorPedido-${tipo}`).val(),
        tipo: 'P',
        numero: pedido.tiposPedidos[tipo.toLowerCase()].numero,
        ordem: 1,
      }];
    }

    function retornaDepositoDoTipoPedido(tipo) {
      if (tipo == 'MAIS_MIX') {
        return '8080'
      }
      if (tipo == 'PRODUCAO') {
        return pedido.tiposPedidos[tipo.toLowerCase()].itens[0].deposito;
      }
      if (tipo == 'PROGRAMADO') {
        return pedido.tiposPedidos[tipo.toLowerCase()].itens[0].deposito;
      }
      if (tipo == 'PRONTA_ENTREGA') {
        return pedido.tiposPedidos[tipo.toLowerCase()].itens[0].deposito;
      }
    }

    async function pegaValoresPedido(tipo) {
      const pedidos = {
        numero: pedido.tiposPedidos[tipo.toLowerCase()].numero,
        codcli: pedido.cliente.codCli,
        responsavel: pedido.responsavel,
        codrep: pedido.vendedor,
        coordenador: pedido.coordenador,
        designer: pedido.designer,
        id_contato: pedido.formaContato,
        periodo: '00',
        periodoprod: '00',
        colecao: '00',
        tela: 'VenPedSimples4',
        tipo: 'P',
        redesp_cif: 'P',
        qualidade: '1',
        bloqueio: await retornaValidacaoComercial(pedido.tiposPedidos[tipo.toLowerCase()]) ? '0' : '1',
        financeiro: await retornaValidacaoFinanceiro(tipo) ? '0' : '1',
        tab_pre: pedido.tabela,
        emp_id: getCookie('emp_id'),
        historico: await retornaHistoricoMoeda(pegaChave(`#txtMoeda-${tipo}`)),
        deposito: retornaDepositoDoTipoPedido(tipo),
        dt_emissao: pedido.data,
        dtdigita: formataDateTimeBackEnd(pedido.dataInicio),
        dt_inicio: pedido.dataInicio,
        emp_fat: pegaValor(`#selectEmpFaturamento-${tipo}`),
        grupo: pegaChave(`#txtGrupoPedido-${tipo}`),
        status: pegaChave(`#txtStatusPedido-${tipo}`),
        tab_trans: pegaChave(`#txtTransportadora-${tipo}`),
        dt_fatura: pegaValor(`#txtDtFaturaFinalizaPedido-${tipo}`),
        id_tipo: pegaChave(`#txtTipoPedido-${tipo}`),
        operacao: pegaChave(`#txtOperacaoFiscal-${tipo}`),
        obs: pegaValor(`#textDescricaoPedido-${tipo}`),
        cif: pegaValor(`#selectFrete-${tipo}`),
        frete: pegaValor(`#txtFrete-${tipo}`),
        dt_saida: pegaValor(`#txtDtEntregaPrevFinalizaPedido-${tipo}`) == '' ? '1899-12-10' : pegaValor(`#txtDtEntregaPrevFinalizaPedido-${tipo}`),
        entrega: pegaValor(`#txtDtEntregaPrevFinalizaPedido-${tipo}`) == '' ? '1899-12-10' : pegaValor(`#txtDtEntregaPrevFinalizaPedido-${tipo}`),
        moeda: pegaChave(`#txtMoeda-${tipo}`),
        val_entrada: $(`#txtEntradaPedido-${tipo}`).val() == '' ? 0 : parseFloat($(`#txtEntradaPedido-${tipo}`).val()),
        cond_pagtos: retornaCondPagto(tipo),
        itens: pedido.tiposPedidos[tipo.toLowerCase()].itens,
        tipo_venda: 'A',
        codusuario: sessionStorage.getItem('cod_usuario'),
        desconto: 0,
        numatendimento: $('#txt_atendimento_atual').html(),
      };

      return pedidos;
    }

    $(`#btnGravarPedido-${tipo}`).on('click', async () => {
      try {
        $.LoadingOverlay('show');
        const url = '/sisplan/pedidob2b/v1/pedidob2b?';
        if (!validaCamposPreenchidos(tipo)) {
          return;
        }

        await validaStatusPedido(pedido.tiposPedidos[tipo.toLowerCase()], tipo);

        const pedidos = await pegaValoresPedido(tipo);
        pedido.tiposPedidos[tipo.toLowerCase()] = {
          ...pedido.tiposPedidos[tipo.toLowerCase()],
          ...pedidos,
        };
        const response = await requisicao('POST', url, '', JSON.stringify(pedidos));

        if (!response) {
          msgErro('Erro ao gravar o pedido');
          return;
        }

        if (response.status != 200) {
          msgErro('Erro ao gravar o pedido');
          return;
        }

        pedido.tiposPedidos[tipo.toLowerCase()] = {
          ...pedidos,
          statusPedido: 'F',
        };

        toastr.success(
          `Pedido ${tipo === 'PRODUCAO' ? 'Produção' : tipo === 'PRONTA_ENTREGA' ? 'Pronta Entrega' : tipo === 'PROGRAMADO' ? 'Programado' : 'Mais Mix'} gravado com sucesso!`,
          'Confirmação',
          {
            toastClass: 'alert',
            iconClasses: {
              error: 'alert-error',
              info: 'alert-info',
              success: 'alert-success',
              warning: 'alert-warning',
            },
            positionClass: 'toast-top-center',
            progressBar: true,
            timeOut: 2000,
            fadeOut: 1000,
            onHidden() {
              $('#btnItens').attr('disabled', true);
            },
          },
        ).css({
          'margin-top': '20%',
          width: '500px',
          'max-width': '500px',
        });

        await montaJsonPedido();
        await salvarArquivoPedido();
        desabilitaCamposFinalizaPedido(tipo);
      } catch (error) {
        console.error(error);
      } finally {
        $.LoadingOverlay('hide');
      }
    });
  }

  const selectTxtCliente = {
    tabela: 'ENTIDADE',
    camposSelect: ['CODCLI CHAVE', "NOME ||' - '|| CNPJ DESCRICAO", 'CNPJ'],
    where: [`CODREP = '${pegaChave('#txtVendedor')}'`],
  };

  const selectBtnCliente = {
    tabela: 'ENTIDADE',
    camposSelect: ['CODCLI', 'NOME', 'FANTASIA', 'CNPJ'],
    where: [`CODREP = '${pegaChave('#txtVendedor')}'`],
  };

  $('#rodape').addClass('d-none');
  $('#btn-Vendedor').pesquisa('#txtVendedor', 'CODREP', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "represen", "camposSelect": ["codrep", "nome"], "where": ["ativo = \'S\'"] }', 'Pesquisa Representante', 'represen');

  $('#txtVendedor').autocompleta(1, 'JSON={ "tabela": "represen", "camposSelect": ["CODREP CHAVE, NOME DESCRICAO"], "where": ["ativo = \'S\'"] }');
  $('#txtTabela').autocompleta(1, 'JSON={ "tabela": "regiao", "camposSelect": ["regiao chave", "descricao"], "where": null }');
  $('#txtCliente').autocompleta(3, `JSON=${JSON.stringify(selectTxtCliente)} `, ['#txtCNPJ'], ['CNPJ'], ['CNPJ']);
  $('#txtResponsavel').autocompleta(1, 'JSON={ "tabela": "PESSOAL", "camposSelect": ["CODIGO CHAVE", "NOME DESCRICAO"], "where": null }');
  $('#txtFormaContato').autocompleta(1, `JSON={ "tabela": "TIPO_CONTATO", "camposSelect": ["codigo chave", "descricao descricao"], "where": ["TIPO = 'F' "] }`);
  $('#txtTpVenda').autocompleta(1, 'JSON={ "tabela": "TIPO", "camposSelect": ["ID_TIPO CHAVE, DESCRICAO DESCRICAO"], "where": null }');
  $('#txtDesistencia').autocompleta(1, `JSON={ "tabela": "MENSAGEM", "camposSelect": ["CODMEN CHAVE, DESCRICAO DESCRICAO"], "where": ["TIPO = '20' "] }`);

  $('#btn-FormaContato').pesquisa('#txtFormaContato', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "TIPO_CONTATO", "camposSelect": ["codigo", "descricao"], "where": ["TIPO = 'F' "]}`, 'Pesquisa CST PIS', 'TIPO_CONTATO');
  $('#btn-Responsavel').pesquisa('#txtResponsavel', 'CODIGO', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela": "PESSOAL", "camposSelect": ["CODIGO", "NOME"] }', 'Pesquisa Funcionário', 'PESSOAL');
  $('#btn-cliente').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], JSON.stringify(selectBtnCliente), 'Pesquisa Cliente');
  $('#btn-tabela').pesquisa('#txtTabela', 'REGIAO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"regiao", "camposSelect":[ "regiao", "descricao"], "where": null}', 'Pesquisa Tabela', 'regiao', '');
  $('#btn-TpVenda').pesquisa('#txtTpVenda', 'ID_TIPO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TIPO", "camposSelect":[ "ID_TIPO", "DESCRICAO" ], "where": null}', 'Pesquisa Tipo Venda', 'TIPO');
  $('#btn-Desistencia').pesquisa('#txtDesistencia', 'CODMEN', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO" ], "where": ["TIPO = '20' "]}`, 'Pesquisa Desistência', 'TIPO');

  $('#btn-limpa-cliente').on('click', () => {
    $('#txtCliente').val('');
    $('#txtCNPJ').val('');
    $('#txtLimiteCreditoCli').val(0);
    $('#txtLimiteCreditoConsignado').val(0);
    $('#txtCashbackCli').val('');
  });
  $('#btn-limpa-FormaContato').on('click', () => { $('#txtFormaContato').val(''); });
  $('#btn-limpa-vendedor').on('click', () => { $('#txtVendedor').val(''); });
  $('#btn-limpa-tabela').on('click', () => { $('#txtTabela').val(''); });
  $('#btn-limpa-Responsavel').on('click', () => { $('#txtResponsavel').val(''); });
  $('#btn-limpa-TpVenda').on('click', () => { $('#txtTpVenda').val(''); });
  $('#btn-limpa-Desistencia').on('click', () => { $('#txtDesistencia').val(''); });

  const tabelaItensMesa = $('#tabelaItensMesa').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    scrollX: '250px',
    scrollY: '200px',
    language: {
      sEmptyTable: 'Nenhum registro encontrado',
      sInfo: '_TOTAL_ registros',
      sInfoEmpty: ' 0 registros',
      sInfoFiltered: '(Filtrados de _MAX_ registros)',
      sInfoPostFix: '',
      sInfoThousands: '.',
      sLengthMenu: '_MENU_ resultados',
      sLoadingRecords: 'Carregando...',
      sProcessing: 'Processando...',
      sZeroRecords: 'Nenhum registro encontrado',
      sSearch: 'Pesquisar',
      oPaginate: {
        sNext: 'Próximo',
        sPrevious: 'Anterior',
        sFirst: 'Primeiro',
        sLast: 'Último',
      },
      oAria: {
        sSortAscending: ': Ordenar colunas de forma ascendente',
        sSortDescending: ': Ordenar colunas de forma descendente',
      },
    },
    // "data": keys,
    columns: dataSetColsItensMesa,
    columnDefs: [{
      targets: [4, 5, 6, 7, 8, 9, 10],
      visible: false,
    },
    {
      targets: [2],
      width: '250px',
    },
    ],
  });

  $('#tabelaCorAdicionarItem').DataTable({
    destroy: true,
    lengthChange: false,
    info: false,
    order: false,
    paging: false,
    filter: false,
    language: {
      sEmptyTable: 'Nenhum registro encontrado',
      sInfo: '_TOTAL_ registros',
      sInfoEmpty: ' 0 registros',
      sInfoFiltered: '(Filtrados de _MAX_ registros)',
      sInfoPostFix: '',
      sInfoThousands: '.',
      sLengthMenu: '_MENU_ resultados',
      sLoadingRecords: 'Carregando...',
      sProcessing: 'Processando...',
      sZeroRecords: 'Nenhum registro encontrado',
      sSearch: 'Pesquisar Cor',
      oPaginate: {
        sNext: 'Próximo',
        sPrevious: 'Anterior',
        sFirst: 'Primeiro',
        sLast: 'Último',
      },
      oAria: {
        sSortAscending: ': Ordenar colunas de forma ascendente',
        sSortDescending: ': Ordenar colunas de forma descendente',
      },
    },
    autoWidth: true,
    columns: dataSetColsCoresSelecionadas,
    colReorder: true,
    columnDefs: [{
      targets: [5, 6, 7, 8, 9, 10],
      visible: false,
    }],
  });

  const tabelaItensCompletos = $('#tabelaItensCompletos').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    scrollX: '250px',
    scrollY: '200px',
    language: {
      sEmptyTable: 'Nenhum registro encontrado',
      sInfo: '_TOTAL_ registros',
      sInfoEmpty: ' 0 registros',
      sInfoFiltered: '(Filtrados de _MAX_ registros)',
      sInfoPostFix: '',
      sInfoThousands: '.',
      sLengthMenu: '_MENU_ resultados',
      sLoadingRecords: 'Carregando...',
      sProcessing: 'Processando...',
      sZeroRecords: 'Nenhum registro encontrado',
      sSearch: 'Pesquisar',
      oPaginate: {
        sNext: 'Próximo',
        sPrevious: 'Anterior',
        sFirst: 'Primeiro',
        sLast: 'Último',
      },
      oAria: {
        sSortAscending: ': Ordenar colunas de forma ascendente',
        sSortDescending: ': Ordenar colunas de forma descendente',
      },
    },
    columns: dataSetColsCoresItensCompletos,
  });


  $('#tabelaItensCompletos').addClass('d-none');

  const tabelaDesistenciaItem = $('#tabelaDesistenciaItem').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    scrollX: '250px',
    scrollY: '200px',
    language: {
      sEmptyTable: 'Nenhum registro encontrado',
      sInfo: '_TOTAL_ registros',
      sInfoEmpty: ' 0 registros',
      sInfoFiltered: '(Filtrados de _MAX_ registros)',
      sInfoPostFix: '',
      sInfoThousands: '.',
      sLengthMenu: '_MENU_ resultados',
      sLoadingRecords: 'Carregando...',
      sProcessing: 'Processando...',
      sZeroRecords: 'Nenhum registro encontrado',
      sSearch: 'Pesquisar',
      oPaginate: {
        sNext: 'Próximo',
        sPrevious: 'Anterior',
        sFirst: 'Primeiro',
        sLast: 'Último',
      },
      oAria: {
        sSortAscending: ': Ordenar colunas de forma ascendente',
        sSortDescending: ': Ordenar colunas de forma descendente',
      },
    },
    autoWidth: true,
    columns: dataSetColsDesistenciaItem,
  });

  const tabelaCarrinho = $('#tabelaCarrinho').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    scrollX: '250px',
    scrollY: '200px',
    language: {
      sEmptyTable: 'Nenhum registro encontrado',
      sInfo: '_TOTAL_ registros',
      sInfoEmpty: ' 0 registros',
      sInfoFiltered: '(Filtrados de _MAX_ registros)',
      sInfoPostFix: '',
      sInfoThousands: '.',
      sLengthMenu: '_MENU_ resultados',
      sLoadingRecords: 'Carregando...',
      sProcessing: 'Processando...',
      sZeroRecords: 'Nenhum registro encontrado',
      sSearch: 'Pesquisar',
      oPaginate: {
        sNext: 'Próximo',
        sPrevious: 'Anterior',
        sFirst: 'Primeiro',
        sLast: 'Último',
      },
      oAria: {
        sSortAscending: ': Ordenar colunas de forma ascendente',
        sSortDescending: ': Ordenar colunas de forma descendente',
      },
    },
    autoWidth: true,
    columns: dataSetColsCarrinho,
  });

  const tabelaInformativo = $('#tabelaInformativo').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    scrollX: '250px',
    scrollY: '200px',
    language: {
      sEmptyTable: 'Nenhum registro encontrado',
      sInfo: '_TOTAL_ registros',
      sInfoEmpty: ' 0 registros',
      sInfoFiltered: '(Filtrados de _MAX_ registros)',
      sInfoPostFix: '',
      sInfoThousands: '.',
      sLengthMenu: '_MENU_ resultados',
      sLoadingRecords: 'Carregando...',
      sProcessing: 'Processando...',
      sZeroRecords: 'Nenhum registro encontrado',
      sSearch: 'Pesquisar',
      oPaginate: {
        sNext: 'Próximo',
        sPrevious: 'Anterior',
        sFirst: 'Primeiro',
        sLast: 'Último',
      },
      oAria: {
        sSortAscending: ': Ordenar colunas de forma ascendente',
        sSortDescending: ': Ordenar colunas de forma descendente',
      },
    },
    autoWidth: true,
    columns: dataSetColsInformativo,
  });

  async function verificaMaterialBase(codigo) {
    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "CADMATTI", "camposSelect": ["CODIGO"], "where": ["CODIGO2 = '${codigo}' "] } `);

    if (json.length == 0) {
      return '';
    }
    return json[0].CODIGO;
  }

  $('#tabelaCor tbody').on('click', 'td', function () {
    const table = $('#tabelaCor').DataTable();
    const data = table.row($(this).parents('tr')).data();
    const columnIndex = table.column(this).index();
    const columnName = table.column(columnIndex).header().innerText;

    if (columnIndex > 4) {
      if ($(this).hasClass('selectedEstoque')) {
        $(this).removeClass('selectedEstoque');
        table.row($(this).parents('tr')).data({ ...data, ESTOQUE_SELECIONADO: '' }).draw(false);
      } else {
        $(this).parents('tr').addClass('selected');
        $(this).parents('tr').children().each(function () {
          if ($(this).hasClass('selectedEstoque')) {
            table.row($(this).parents('tr')).data({ ...data, ESTOQUE_SELECIONADO: '' }).draw(false);
            $(this).removeClass('selectedEstoque');
          }
        });
        $(this).addClass('selectedEstoque');
        if (columnName.split('_')[0] == 'COMPRA') {
          table.row($(this).parents('tr')).data({ ...data, ESTOQUE_SELECIONADO: columnName }).draw(false);
        } else {
          table.row($(this).parents('tr')).data({ ...data, ESTOQUE_SELECIONADO: columnName.split('_')[1] }).draw(false);
        }
      }
    } else if ($(this).parents('tr').hasClass('selected')) {
      $(this).parents('tr').removeClass('selected');
      $(this).parents('tr').children().each(function () {
        if ($(this).hasClass('selectedEstoque')) {
          $(this).removeClass('selectedEstoque');
          table.row($(this).parents('tr')).data({ ...data, ESTOQUE_SELECIONADO: '' }).draw(false);
        }
      });
    } else {
      $(this).parents('tr').addClass('selected');
      table.row($(this).parents('tr')).data({ ...data, ESTOQUE_SELECIONADO: '' }).draw(false);
    }
  });

  async function carregaInformativos(tipo) {
    const url = '/sisplan/pedidob2b/v1/informativos?';
    const codcli = pegaChave('#txtCliente');

    if ($.fn.DataTable.isDataTable('#tabelaInformativo')) {
      $('#tabelaInformativo').DataTable().rows().remove().draw(false);
    }

    const response = await requisicao('GET', url, `CODCLI=${codcli}`, '');

    const json = await response.json();

    if (json) {

      if (json[tipo]) {
        json[tipo].forEach((itens) => {
          $('#tabelaInformativo').DataTable().row.add(itens).draw(false);
        })
      }
    }
    $('#modal-informativo').modal('show');
    setTimeout(() => {
      $('#tabelaInformativo').DataTable().columns.adjust().draw(false);
    }, 500);
  }

  $('#btn-fecharInformativo').on('click', function () {
    $('#modal-informativo').modal('hide');
  })

  $('#btn-VerInformativoTitulosVencer').on('click', function () {
    carregaInformativos('titulosAVencer');
  })

  $('#btn-VerInformativoTitulosVencidos').on('click', function () {
    carregaInformativos('titulosVencidos');
  })

  $('#btn-VerInformativoGrupoVencer').on('click', function () {
    carregaInformativos('creditoGrupoAVenc');
  })

  $('#btn-VerInformativoGrupoVencidos').on('click', function () {
    carregaInformativos('creditoGrupoVencidos');
  })

  $('#btn-VerInformativoChequesVencer').on('click', function () {
    carregaInformativos('chequesAVencer');
  })

  $('#btn-VerInformativoChequesVencidos').on('click', function () {
    carregaInformativos('chequesVencidos');
  })

  $('#btn-VerInformativoCreditoAntecipacao').on('click', function () {
    carregaInformativos('creditoAEmberto');
  })

  $('#btn-VerInformativoPedidosPendentes').on('click', function () {
    carregaInformativos('pendenteAFaturar');
  })

  async function preencheCampoTipoVenda(cores, codigoBase) {

    $('#txtTpVenda').prop('disabled', true);
    $('#btn-TpVenda').prop('disabled', true);
    $('#btn-limpa-TpVenda').prop('disabled', true);
    // $('#txtTpVenda').attr('disabled', true);
    // $('#btn-TpVenda').attr('disabled', true);
    // $('#btn-limpa-TpVenda').attr('disabled', true);

    if (codigoBase != '') {
      $('#txtTpVenda').val('[34] - ATACADO PRODUÇÃO');
      $('#txtTpVenda').attr('data-selecionado', true);
      setarDataAtual('txtDtEntregaPrev', false, 7);
      return;
    }

    await Promise.all(cores.map(async (cor) => {
      if (cor.ESTOQUE_SELECIONADO.includes('COMPRA')) {
        $('#txtTpVenda').val('[33] - ATACADO PROGRAMADO');
        $('#txtTpVenda').attr('data-selecionado', true);
        const json = await retornaJsonPesquisaPadrao(`{ "tabela": "COMPRA", "camposSelect": ["DT_ENTREGA"], "where": ["NUMERO = '${cor[`CODIGO_${cor.ESTOQUE_SELECIONADO}`]}'"] } `);
        const dataRecebida = new Date(json[0].DT_ENTREGA);
        dataRecebida.setUTCHours(0);
        const deslocamentoFusoHorario = dataRecebida.getTimezoneOffset();
        dataRecebida.setMinutes(dataRecebida.getMinutes() + deslocamentoFusoHorario);
        setarDataPraFrente('txtDtEntregaPrev', dataRecebida, 5);
        return;
      }

      if (cor.ESTOQUE_SELECIONADO == '8080') {
        $('#txtTpVenda').val('[45] - ATACADO - MAIS MIX');
        $('#txtTpVenda').attr('data-selecionado', true);
        return;
      }

      $('#txtTpVenda').val('[32] - ATACADO PRONTA ENTREGA');
      $('#txtTpVenda').attr('data-selecionado', true);

      setarDataAtual('txtDtEntregaPrev', false, 2);
    }));



    // isso tem que achar uma forma melhor pra controlar pois é uma regra exclusiva pra EXC pois foi desenvolvido inicialmente para eles.
    // 32 – ATACADO PRONTA ENTREGA - DATA DEVE SER A ATUAL + 2 DIAS
    // 33 – ATACADO PROGRAMADO - DATA DEVE SER A DATA ENTREGA DA OC + 5 DIAS
    // 34 – ATACADO PRODUÇÃO - DATA DEVE SER ATUAL + 7 DIAS
  }

  $('#btnFinalizarAtendimento').on('click', async () => {
    if (!await finalizaAtendimento()) {
      msgErro('Erro ao finalizar o atendimento!');
      return;
    }

    const hostname = `JsonPedido-${pedido.numeroAtendimento}`;
    await deletaDadosNaoSalvos(`${hostname}.txt`);

    toastr.success(
      'Atendimento Finalizado com Sucesso!',
      'Confirmação',

      {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning',
        },
        positionClass: 'toast-top-center',
        progressBar: true,
        timeOut: 2000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/pedidosb2b`;
        },
      },
    ).css({
      'margin-top': '20%',
      width: '500px',
      'max-width': '500px',
    });
  });

  $('#btnFinalizarPedido').on('click', async () => {
    $('#modalAutoAvaliacao').modal('show');
  });

  async function retornaInformacaoCores(cores) {
    const url = '/sisplan/pedidob2b/v1/infocorselecionada?';
    const response = await requisicao('POST', url, '', JSON.stringify(cores));

    if (!response) {
      msgAlerta('Erro ao buscar informação dos itens!');
      return;
    }

    if (response.status != 200) {
      msgAlerta(response.mensagem);
      return;
    }

    const json = await response.json();

    return json;
  }

  // transferir quase tudo pro backend pois essa regra de quando for digital pegar o estoque do base
  // e diminuir o saldo que tem em aberto na cadmatiti é fudida,
  // pois pode dar pau na hora de fazer a tinturaria desse material digital.
  // essa é a função que a fw não ta dando conta de resolver então deve ser izi resolver
  async function abreModalAdicionarItens() {

    $('#modalAdicionarItem').modal('show');
    const coresSelecionadas = $('#tabelaCor').DataTable().rows('.selected').data().toArray();
    const item = tabelaItensMesa.row('.selected').data();
    const comissao = await retornaJsonPesquisaPadrao(`{ "tabela": "represen", "camposSelect": ["COMISSAO"], "where": ["CODREP = '${pegaChave('#txtVendedor')}' "] } `);
    const jsonStr = await retornaJsonPesquisaPadrao(`{ "tabela": "tabpreco", "camposSelect": ["DESC_MAX"], "where": ["CODIGO = '${item.CODIGO}' "] } `);
    const materialBase = await verificaMaterialBase(item.CODIGO);
    await preencheCampoTipoVenda(coresSelecionadas, materialBase);
    $('#txtPercComissaoItens').val(`${comissao[0].COMISSAO}% `);
    $('#itemCodigoDescricao').html(`${item.CODIGO} - ${item.DESCRICAO} `);
    $('#itemDescMaximo').html(`${jsonStr.length > 0 && jsonStr[0].DESC_MAX ? `${jsonStr[0].DESC_MAX}%` : 'Não Possui'} `);
    const descMax = jsonStr.length > 0 && jsonStr[0].DESC_MAX ? jsonStr[0].DESC_MAX / 100 : 0;
    // if ($.fn.DataTable.isDataTable('#tabelaCor')) {
    //   $('#tabelaItensCompletos').DataTable().rows().remove().draw(false);
    // }

    if ($.fn.DataTable.isDataTable('#tabelaCorAdicionarItem')) {
      $('#tabelaCorAdicionarItem').DataTable().rows().remove()
        .draw(false);
    }
    const selecionadas = {
      Codigo: item.CODIGO,
      CodigoBase: materialBase,
      TabelaPreco: pegaChave('#txtTabela'),
      ItensSelecionados: coresSelecionadas.map((selecionada) => ({
        COR: materialBase != '' ? selecionada.cor : selecionada.COR,
        ESTOQUE_SELECIONADO: selecionada.ESTOQUE_SELECIONADO.startsWith('COMPRA_') ? selecionada[`CODIGO_${selecionada.ESTOQUE_SELECIONADO}`] : selecionada.ESTOQUE_SELECIONADO,
        ORDEM_COMPRA: selecionada.ESTOQUE_SELECIONADO.startsWith('COMPRA_'),
      })),
    };

    const cores = await retornaInformacaoCores(selecionadas);

    cores.itensSelecionados.map((itemCor) => {
      const valorDescMax = TruncaDecimaisNova(2, descMax != 0 ? itemCor.preco * descMax : 0);

      if (cores.codigoBase != '') {
        $('#txtQuantidadeOrig').val(TruncaDecimaisNova(4, itemCor.quantidadeEstoque))
      }

      adicionaCorTabelaCarrinho({
        COR: itemCor.cor,
        DESC_COR: itemCor.descricao,
        QTDE: '<input type="text" class="input-default focus form-control txtQuantidadeCor" style="max-width: 100px;" /> ',
        PRECO: itemCor.preco,
        VALOR_TOTAL: 0,
        QUANTIDADE_SELECIONADA: 0,
        QUANTIDADE_ESTOQUE: TruncaDecimaisNova(4, itemCor.quantidadeEstoque),
        ORDEM_COMPRA: itemCor.ordem_Compra,
        CODIGO_BASE: cores.codigoBase,
        CODIGO_ITEM: cores.codigo,
        ESTOQUE_SELECIONADO: itemCor.estoque_Selecionado,
        PRECO_MIN: TruncaDecimaisNova(2, itemCor.preco - valorDescMax),
      });
    });

    $('.txtQuantidadeCor').inputmask('numeric', {
      min: 0,
      positionCaretOnClick: 'select',
      digits: 2,
    }).on('focus', function () {
      const that = $(this);
      setTimeout(() => {
        that.select();
      }, 1);
    });

    $('.txtQuantidadeCor').unbind('blur');
    $('.txtQuantidadeCor').on('blur', function () {
      SaidaCampoQuantidade(this);
    });
  }

  $('#txtQtdeCoresTotal').on('blur', () => {
    const quantidade = StringToFloatDef($('#txtQtdeCoresTotal').val(), 0);

    if (quantidade < 0) {
      msgAlerta('Quantidade não pode ser negativa!');
      return;
    }

    $('.txtQuantidadeCor').each((i, t) => {
      $('.txtQuantidadeCor').val(quantidade);
      SaidaCampoQuantidade(t);
    });
  });

  function SaidaCampoQuantidade(item) {

    function AtualizaQuantidadeMaterialBase() {
      const dataBase = $('#tabelaCorAdicionarItem').DataTable().rows().data().toArray();
      const totalJaSelecionado = $('#tabelaCorAdicionarItem').DataTable().column(6, {}).data().sum();
      var teste = 0;
      dataBase.forEach((cor, i) => {
        if (data.ESTOQUE_SELECIONADO == cor.ESTOQUE_SELECIONADO) {
          if ((i == 0) || (total == 0)) {
            teste = cor.QUANTIDADE_ESTOQUE + totalJaSelecionado - total
          }
          $('#tabelaCorAdicionarItem').DataTable().row([i]).data({
            ...cor,
            QTDE: `<input type="text" value="${quantidade}" class="input-default focus form-control txtQuantidadeCor" style="max-width: 100px;" /> `,
            QUANTIDADE_ESTOQUE: teste,
            QUANTIDADE_SELECIONADA: data.COR == cor.COR ? quantidade : $('#txtQtdeCoresTotal').val() == '0' && quantidade == 0 ? cor.QUANTIDADE_SELECIONADA : quantidade,
            VALOR_TOTAL: TruncaDecimaisNova(2, cor.PRECO * parseFloat(quantidade))
          }).draw(false);
        }
      })
    }

    function AtualizaQuantidadeMaterial() {
      data.QTDE = `<input type="text" value="${quantidade}" class="input-default focus form-control txtQuantidadeCor" style="max-width: 100px;" /> `;
      data.VALOR_TOTAL = TruncaDecimaisNova(2, data.PRECO * parseFloat(quantidade));
      data.QUANTIDADE_SELECIONADA = quantidade;

      $('#tabelaCorAdicionarItem').DataTable().row($(item).parents('tr')).data(data).draw(false);
    }

    var data = $('#tabelaCorAdicionarItem').DataTable().row($(item).parents('tr')).data();
    var quantidade = StringToFloatDef($(item).val(), 0);
    var total = 0;

    $('.txtQuantidadeCor').each((i, t) => {
      total += parseFloat(t.value == '' ? 0 : t.value);
    });

    if (data.CODIGO_BASE != '') {
      if (total > data.QUANTIDADE_ESTOQUE) {
        msgAlerta(`Quantidade insuficiente no estoque.`);
        $('.txtQuantidadeCor').val(0);
        $('#txtQtdeCoresTotal').val(0);
        return;
      }
    }

    if (data.CODIGO_BASE != '') {
      AtualizaQuantidadeMaterialBase();
    } else {
      AtualizaQuantidadeMaterial();
    }

    if (parseFloat($('#infoprodMedia').val()) == 0) {
      $('#txtVolumePrevItens').val(0);
    } else {
      $('#txtVolumePrevItens').val(TruncaDecimaisNova(2, total / parseFloat($('#infoprodMedia').val())));
    }

    CalculaValorTotalItens();

    $('.txtQuantidadeCor').unbind('blur');
    $('.txtQuantidadeCor').on('blur', function () {
      SaidaCampoQuantidade(this);
    });

    $('.txtQuantidadeCor').inputmask('numeric', {
      min: 0,
      positionCaretOnClick: 'select',
    }).on('focus', function () {
      const that = $(this);
      setTimeout(() => {
        that.select();
      }, 1);
    });
  }

  $('#txtDescontoItens').on('blur', () => {
    const valorDesconto = StringToFloatDef($('#txtDescontoItens').val(), 0);
    const totalItens = $('#txtTotalItens').val();
    const percDesconto = 100 - ((totalItens - valorDesconto) / totalItens) * 100;

    $('#txtPercDescontoItens').val(TruncaDecimaisNova(2, percDesconto));

    CalculaValorTotalItens();
  });

  $('#txtPercDescontoItens').on('blur', () => {
    const percDesconto = StringToFloatDef($('#txtPercDescontoItens').val(), 0) / 100;
    const total = $('#txtTotalItens').val();

    $('#txtDescontoItens').val(TruncaDecimaisNova(2, total * percDesconto));

    CalculaValorTotalItens();
  });

  function CalculaValorTotalItens() {
    const total = $('#tabelaCorAdicionarItem').DataTable().column(5, {}).data().sum();
    const desconto = StringToFloatDef($('#txtDescontoItens').val(), 0);
    const comissao = TruncaDecimaisNova(2, total * (StringToFloatDef($('#txtPercComissaoItens').val().split('%')[0], 0) / 100));

    if (desconto > 0) {
      if (desconto >= total) {
        msgAlerta('Desconto não pode ser igual ou maior o valor do item!');
        return;
      }
    }
    $('#txtTotalItens').val(TruncaDecimaisNova(2, total - desconto));
    $('#txtComissaoItens').val(comissao);
  }

  async function removeCorExistente(data) {
    const itens = $('#tabelaItensCompletos').DataTable();
    const rows = itens.rows().eq(0);

    for (let i = rows.length - 1; i >= 0; i--) {
      const index = rows[i];
      const rowData = itens.row(index).data();

      data.forEach((cor) => {
        if (rowData && rowData.COR === cor.COR) {
          itens.row(index).remove().draw();
        }
      });
    }

    $('#btnGravarItemPedido').trigger('click');
  }

  function adicionaCorTabelaCarrinho(itens) {
    $('#tabelaCorAdicionarItem').DataTable().row.add(itens).draw(false);
    const $scrollBody = $($('#tabelaCorAdicionarItem').DataTable().table().node()).parent();
    $scrollBody.scrollTop($scrollBody.get(0).scrollHeight);
  }

  $('#btnGravarItemPedido').on('click', async () => {
    try {
      $.LoadingOverlay('show');
      const itensExistentes = [];
      const data = tabelaItensMesa.row('.selected').data();
      const dataCorAdd = $('#tabelaCorAdicionarItem').DataTable().rows().data().toArray();
      const dataItensCompletos = $('#tabelaItensCompletos').DataTable().rows().data().toArray();

      const semEstoque = dataCorAdd.filter((estoque) => estoque.QUANTIDADE_ESTOQUE < estoque.QUANTIDADE_SELECIONADA && estoque.CODIGO_BASE == '');
      const codigosSemEstoque = semEstoque.map((cor) => cor.COR).toString();

      dataCorAdd.forEach((cor) => {
        if (dataItensCompletos.filter((item) => item.COR == cor.COR).length > 0) {
          itensExistentes.push(cor);
        }
      });

      if (itensExistentes.length > 0) {
        msgAlerta('Cor já existe na tabela, deseja substituir a quantidade?', async () => {
          await removeCorExistente(dataCorAdd);
        });
      }

      if (semEstoque.length > 0) {
        msgAlerta(`Quantidade insuficiente nas cores: ${codigosSemEstoque}. Selecione outro estoque ou diminua a quantidade.`);
        return;
      }

      await gravaCorItemMesa();
      tabelaItensMesa.row('.selected').data({ ...data, SITUACAO: '<div class="situacaoIcon"> <i class="fas fa-smile"></i></div> ', SITUACAO_CODIGO: 'F' });
      await montaJsonPedido();
      await salvarArquivoPedido(pedido);
      atualizaTotaisPedido();
      $('#modalAdicionarItem').modal('hide');
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function gravaCorItemMesa() {
    try {
      const data = $('#tabelaCorAdicionarItem').DataTable().rows().data()
        .toArray();
      data.forEach((cor) => {
        adicionaItensPedido({
          COR: cor.COR,
          VALOR_TOTAL: cor.VALOR_TOTAL,
          QTDE: cor.QUANTIDADE_SELECIONADA,
          PRECO: cor.PRECO,
          VALOR_DESC: $('#txtDescontoItens').val(),
          PERC_DESC: $('#txtPercDescontoItens').val(),
          VALOR_COMISSAO: $('#txtComissaoItens').val(),
          PERC_COMISSAO: $('#txtPercComissaoItens').val(),
          ESTOQUE: cor.ESTOQUE_SELECIONADO,
          CODIGO_BASE: cor.CODIGO_BASE,
          ORDEM_COMPRA: cor.ORDEM_COMPRA,
          CODIGO_ITEM: cor.CODIGO_ITEM,
        }, true);
      });
    } catch (error) {
      console.error(error);
    }
  }

  $('#modalAdicionarItem').on('show.bs.modal', () => {
    $('#txtTotalItens').val('0.00');
    $('#txtPercComissaoItens').val('0');
    $('#txtComissaoItens').val('0%');
    $('#txtDescontoItens').val('0.00');
    $('#txtQtdeCoresTotal').val('0');
    $('#txtPercDescontoItens').val('0%');
    $('#txtVolumePrevItens').val('0');
    limpaValor('#txtTpVenda');
  });

  $('#modalDesistir').on('show.bs.modal', () => {
    $('#tabelaDesistenciaItem').DataTable().rows().remove().draw(false);
    setTimeout(() => {
      $('#tabelaDesistenciaItem').DataTable().columns.adjust().draw(false);
    }, 500);
  });

  // window.addEventListener('beforeunload', (event) => {
  //   if (pedido.status != 'P') {
  //     const hostname = `JsonPedido-${pedido.numeroAtendimento}`;
  //     deletaDadosNaoSalvos(`${hostname}.txt`);
  //   }
  // });

  $('#btnGravarCor').on('click', async () => {
    try {
      $.LoadingOverlay('show');
      const data = $('#tabelaCor').DataTable().rows('.selected').data().toArray();
      const estoqueVazio = data.filter((cor) => cor.ESTOQUE_SELECIONADO != '').length != data.length;
      const estoqueZerado = data.filter((estoque) => estoque[`EST_${estoque.ESTOQUE_SELECIONADO}`] == 0).length > 0;

      if (estoqueVazio) {
        msgAlerta('Cores com estoques não selecionados. Selecione o estoque clicando na coluna dele.');
        return;
      }

      if (estoqueZerado) {
        msgAlerta('Cores com estoques zerados. Selecione um estoque com quantidade.');
        return;
      }

      if (data.length == 0) {
        msgAlerta('Nenhuma cor selecionada!');
        return;
      }

      await abreModalAdicionarItens();
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#tabelaItensMesa tbody').on('click', 'tr', async function () {
    try {
      $.LoadingOverlay('show');
      tabelaItensMesa.$('tr.selected').removeClass('selected');
      $(this).addClass('selected');
      const data = tabelaItensMesa.row('.selected').data();
      const dados = [data.UNIDADE, data.GRAMATURA, data.PRECO, data.LARGURA, data.CODIGO];
      await preencheCamposInformacaoItem(dados);
      const codigoProdutoBase = await verificaMaterialBase(data.CODIGO);

      if (codigoProdutoBase) {
        await preencheTabelaCorItemBaseDigital(data.CODIGO, codigoProdutoBase);
      } else {
        await preencheTabelaCorItemNormal(data.CODIGO);
      }

    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function retornaCoresItem(codigo, codigoBase) {
    const url = '/sisplan/pedidob2b/v1/coresitem?';
    const response = await requisicao('GET', url, `CODIGO=${codigo}&MATERIALBASE=${codigoBase}`, null);

    if (!response) {
      msgErro('Erro ao retornar estoque do item!');
      return;
    }
    if (response.status != 200) {
      msgErro('Erro ao retornar estoque do item!');
      return;
    }

    const jsonStr = await response.text();
    const json = JSON.parse(jsonStr.replaceAll('\r\n', ''));

    return json
  }

  async function preencheTabelaCorItemBaseDigital(codigo, codigoBase) {
    const json = await retornaCoresItem(codigo, codigoBase);
    const dataSetCols = [];

    if (json.length == 0) {
      if ($.fn.DataTable.isDataTable('#tabelaCor')) {
        $('#tabelaCor').DataTable().rows().remove().draw(false);
        $('#tabelaCor').DataTable().destroy();
      }
      $('#btnGravarCor').addClass('d-none');

      msgAlerta('Item não encontrado em nenhum deposito ou ordem de compra.');
      return;
    }

    if ($.fn.DataTable.isDataTable('#tabelaCor')) {
      $('#tabelaCor').DataTable().rows().remove().draw(false);
      $('#tabelaCor').DataTable().destroy();
      $('#tabelaCor thead tr').html(' ');
    }
    $('#btnGravarCor').removeClass('d-none');
    var cor = await buscaFoto(codigo, true);
    let novoObjeto = [];

    $.each(json, async (index, objeto) => {
      if (objeto.estoques != null) {
        const depositos = objeto.estoques.reduce((resultado, estoque) => {
          resultado[`EST_${estoque.deposito}`] = TruncaDecimaisNova(4, estoque.quantidade);
          return resultado;
        }, {});

        if (objeto.imagem == "000000000") {
          objeto.imagem = `<div class="corBase64" style="background-image: url('${cor}'); background-size: cover; width: 60px; height: 25px;"></div>`
        }
        objeto = $.extend(objeto, depositos);
        delete objeto.estoques;

        novoObjeto.push(objeto);
      }
    });

    if (novoObjeto.length == 0) {
      msgAlerta('Item não encontrado em nenhum deposito ou ordem de compra.');
      return;
    }

    const keys = Object.keys(novoObjeto[0]);

    keys.forEach((k) => {
      dataSetCols.push({
        title: k.toUpperCase(),
        data: k,
      });
    });

    $('#tabelaCor').DataTable({
      destroy: true,
      lengthChange: false,
      info: false,
      order: false,
      paging: false,
      language: {
        sEmptyTable: 'Nenhum registro encontrado',
        sInfo: '_TOTAL_ registros',
        sInfoEmpty: ' 0 registros',
        sInfoFiltered: '(Filtrados de _MAX_ registros)',
        sInfoPostFix: '',
        sInfoThousands: '.',
        sLengthMenu: '_MENU_ resultados',
        sLoadingRecords: 'Carregando...',
        sProcessing: 'Processando...',
        sZeroRecords: 'Nenhum registro encontrado',
        sSearch: 'Pesquisar Cor',
        oPaginate: {
          sNext: 'Próximo',
          sPrevious: 'Anterior',
          sFirst: 'Primeiro',
          sLast: 'Último',
        },
        oAria: {
          sSortAscending: ': Ordenar colunas de forma ascendente',
          sSortDescending: ': Ordenar colunas de forma descendente',
        },
      },
      autoWidth: true,
      colReorder: true,
      data: json,
      columns: dataSetCols,
      columnDefs: [{
        targets: [4],
        visible: false,
      }],
    });
    $($($('#tabelaCor_wrapper')[0]).children()[0]).css({ 'flex-direction': 'row-reverse' });
    $($($($('#tabelaCor_wrapper')[0]).children()[0]).children()[1]).addClass('d-flex justify-content-start');

    $('.corBase64').on('click', function () {
      $('.corMaterialPreview').attr('style', `background-image${$(this).attr('style').split('background-image')[1]}; background-size: cover; width: 100%; height: 100%; min-width: 150px; min-height: 150px;`);
      $('#imagemodal').modal('show');
    });

    $('#imagemodal').on('hidden.bs.modal', () => {
      $('.corMaterialPreview').attr('style', '');

      $('.imagepreview').attr('src', '');
      $('.corBase64').on('click', function () {
        $('.corMaterialPreview').attr('style', `background-image${$(this).attr('style').split('background-image')[1]}; background-size: cover; width: 100%; height: 100%; min-width: 150px; min-height: 150px;`);
        $('#imagemodal').modal('show');
      });
    })
  }

  async function preencheTabelaCorItemNormal(codigo) {
    const json = await retornaCoresItem(codigo, '');
    const dataSetCols = [];

    if (json.length == 0) {
      if ($.fn.DataTable.isDataTable('#tabelaCor')) {
        $('#tabelaCor').DataTable().rows().remove()
          .draw(false);
        $('#tabelaCor').DataTable().destroy();
      }
      $('#btnGravarCor').addClass('d-none');
      return;
    }
    if ($.fn.DataTable.isDataTable('#tabelaCor')) {
      $('#tabelaCor').DataTable().rows().remove()
        .draw(false);
      $('#tabelaCor').DataTable().destroy();
      $('#tabelaCor thead tr').html(' ');
    }

    let novoObjeto = [];
    let colunaInvisivelCorMesa = [4, 5, 6]

    $.each(json, (index, item) => {
      const color = item.imagem.match(/(\d{3})/g).join('-').split('-');
      const novoItem = {
        COR: item.cor,
        DESCRICAO: item.descricao,
        IMAGEM: `<div class="corRGB" style="background-color: RGB(${color[0]},${color[1]}, ${color[2]}); width: 60px; height: 25px;"></div>`,
        TOTAL_EST: 0,
        CODIGO_COMPRA_1: '',
        CODIGO_COMPRA_2: '',
        CODIGO_COMPRA_3: '',
        COMPRA_1: 0,
        COMPRA_2: 0,
        COMPRA_3: 0,
      };

      if (item.ordemCompra != null) {
        $.each(item.ordemCompra, (index, ordem) => {
          novoItem[`COMPRA_${index + 1}`] = ordem.quantidade;
          novoItem[`CODIGO_COMPRA_${index + 1}`] = ordem.deposito;
        });
      }
      if (item.estoques != null) {
        $.each(item.estoques, (index, estoque) => {
          novoItem[`EST_${estoque.deposito}`] = TruncaDecimaisNova(4, estoque.quantidade);
          novoItem.TOTAL_EST = TruncaDecimaisNova(4, estoque.deposito != '8080' ? novoItem.TOTAL_EST + estoque.quantidade : novoItem.TOTAL_EST + 0);
        });
      }
      if ((item.ordemCompra != null) || (item.estoques.filter((qtde) => qtde.quantidade > 0).length > 0)) {
        novoObjeto.push(novoItem);
      }
    });

    const semCompra = novoObjeto.filter((cor) => cor.COMPRA_1 + cor.COMPRA_2 + cor.COMPRA_3 > 0).length == 0;
    const keys = Object.values(novoObjeto);

    if (keys.length == 0) {
      msgAlerta('Item não encontrado em nenhum deposito ou ordem de compra.');
      return;
    }

    const compras = Object.keys(keys[0]).filter((element) => element.startsWith('COMPRA_')); // separa as posições "COMPRA_1", "COMPRA_2" e "COMPRA_3"
    const resto = Object.keys(keys[0]).filter((element) => !element.startsWith('COMPRA_')); // separa o restante do array

    if (semCompra) {
      const keysInvisiveis = Object.keys(keys[0]).length;
      colunaInvisivelCorMesa = [4, 5, 6, keysInvisiveis - 3, keysInvisiveis - 2, keysInvisiveis - 1];
    }

    const titleTable = compras ? resto.concat(compras) : resto; // junta o restante do array com as posições "COMPRA_1", "COMPRA_2" e "COMPRA_3"

    titleTable.forEach((k) => {
      dataSetCols.push({
        title: k,
        data: k,
      });
    });

    $('#tabelaCor').DataTable({
      destroy: true,
      lengthChange: false,
      info: false,
      order: false,
      paging: false,
      language: {
        sEmptyTable: 'Nenhum registro encontrado',
        sInfo: '_TOTAL_ registros',
        sInfoEmpty: ' 0 registros',
        sInfoFiltered: '(Filtrados de _MAX_ registros)',
        sInfoPostFix: '',
        sInfoThousands: '.',
        sLengthMenu: '_MENU_ resultados',
        sLoadingRecords: 'Carregando...',
        sProcessing: 'Processando...',
        sZeroRecords: 'Nenhum registro encontrado',
        sSearch: 'Pesquisar Cor',
        oPaginate: {
          sNext: 'Próximo',
          sPrevious: 'Anterior',
          sFirst: 'Primeiro',
          sLast: 'Último',
        },
        oAria: {
          sSortAscending: ': Ordenar colunas de forma ascendente',
          sSortDescending: ': Ordenar colunas de forma descendente',
        },
      },
      autoWidth: true,
      colReorder: true,
      data: novoObjeto,
      columns: dataSetCols,
      columnDefs: [{
        targets: colunaInvisivelCorMesa,
        visible: false,
      }],
    });
    $($($('#tabelaCor_wrapper')[0]).children()[0]).css({ 'flex-direction': 'row-reverse' });
    $($($($('#tabelaCor_wrapper')[0]).children()[0]).children()[1]).addClass('d-flex justify-content-start');

    $('#btnGravarCor').removeClass('d-none');

    $('.corRGB').on('click', function () {
      $('.corMaterialPreview').attr('style', `${$(this).attr('style').split(';')[0]}; width: 100%; height: 100%; min-width: 150px; min-height: 150px;`);
      $('#imagemodal').modal('show');
    });


    $('#imagemodal').on('hidden.bs.modal', () => {
      $('.corMaterialPreview').attr('style', '');

      $('.imagepreview').attr('src', '');
      $('.corRGB').on('click', function () {
        $('.corMaterialPreview').attr('style', `${$(this).attr('style').split(';')[0]}; width: 100%; height: 100%; min-width: 150px; min-height: 150px;`);
        $('#imagemodal').modal('show');
      });
    })
  }

  $('#tabelaItensMesa tbody').on('dblclick', 'tr', function () {
    event.preventDefault();
    document.firstElementChild.style.zoom = 'reset';
    tabelaItensMesa.$('tr.selected').removeClass('selected');
    $(this).addClass('selected');
    $('#btn_confirmar_item').click();
  });

  const tabelaItens = $('#tabelaItens').dataTable({
    paging: true,
    lengthChange: false,
    filter: true,
    info: true,
    order: true,
    autoWidth: true,
    destroy: true,
    language: {
      sEmptyTable: 'Nenhuma consulta realizada',
      sInfo: '_TOTAL_ registros',
      sInfoEmpty: ' 0 registros',
      sInfoFiltered: '(Filtrados de _MAX_ registros)',
      sInfoPostFix: '',
      sInfoThousands: '.',
      sLengthMenu: '_MENU_ resultados',
      sLoadingRecords: 'Carregando...',
      sProcessing: 'Processando...',
      sZeroRecords: 'Nenhuma consulta realizada',
      sSearch: 'Pesquisa Complementar',
      oPaginate: {
        sNext: 'Próximo',
        sPrevious: 'Anterior',
        sFirst: 'Primeiro',
        sLast: 'Último',
      },
      oAria: {
        sSortAscending: ': Ordenar colunas de forma ascendente',
        sSortDescending: ': Ordenar colunas de forma descendente',
      },
    },
  });

  $('#tabelaItens tbody').on('click', 'tr', function () {
    tabelaItens.$('tr.selected').removeClass('selected');
    $(this).addClass('selected');
  });

  $('.pop').on('click', function () {
    $('.imagepreview').attr('src', $(this).attr('src'));
    $('#imagemodal').modal('show');
  });

  $('#imagemodal').on('hidden.bs.modal', () => {
    $('.imagepreview').attr('src', '');
  })
  async function buscaFoto(codigo, buscaFotoCor = false) {
    try {
      const url = '/sisplan/funcoes/v1/fotoitem?';
      const response = await requisicao('GET', url, `codigo=${codigo}`, null);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (!buscaFotoCor) {
        if (response.status != 200) {
          $('#infoFotoItem').attr('src', `${BASE_URI} /dist/img/prod-1.png`);
          return;
        }

        const sBase64 = jsonStr;
        if ($('#tabelaItensMesa').DataTable().rows().count() == 0) {
          $('#infoFotoItem').attr('src', `${BASE_URI} /dist/img/prod-1.png`);
        } else {
          $('#infoFotoItem').attr('src', `data:image/png;base64,${sBase64.mensagem}`);
        }
      } else {
        if (response.status != 200) {
          return;
        }

        const sBase64 = jsonStr;

        return `data:image/jpg;base64,${sBase64.mensagem}`
      }
    } catch (error) {
      console.error(error);
      $('#infoFotoItem').attr('src', `${BASE_URI} /dist/img/prod-1.png`);
    }
  }

  $('#tabelaItens tbody').on('dblclick', 'tr', function () {
    event.preventDefault();
    document.firstElementChild.style.zoom = 'reset';
    tabelaItens.$('tr.selected').removeClass('selected');
    $(this).addClass('selected');
    $('#btn_confirmar_item').click();
  });

  $('#btn_confirmar_item').on('click', async () => {
    try {
      $.LoadingOverlay('show');

      const data = tabelaItens.api().row('.selected').data();
      await preencheCamposInformacaoItem([data[2], data[4], data[3], data[5], data[0]]);
      await RotinaSaidaCodigo(data);
      atualizaTotaisPedido();

    } finally {
      $.LoadingOverlay('hide');
      $('#modalItem').modal('hide');
    }
  });

  async function preencheCamposInformacaoItem(data) {
    await buscaFoto(data[4]);
    const emp_deposito = await verificaDepositosEmpresaLogada(getCookie('empresa'));
    const json = await retornaJsonPesquisaPadrao(`{ "tabela": "MAT_ITEN", "camposSelect": ["SUM(QTDE) QTDE, COUNT(LOTE) LOTE"], "where": ["CODIGO = '${data[4]}' AND DEPOSITO IN (${emp_deposito}) AND DEPOSITO <> '8080' "] } `);
    const media = json[0].QTDE / json[0].LOTE
    $('#infoprodUnidade').val(data[0]);
    $('#infoprodGramatura').val(data[1]);
    $('#infoprodpreco').val(data[2]);
    $('#infoprodLargura').val(data[3]);
    $('#infoprodMedia').val(TruncaDecimaisNova(2, isNaN(media) ? 0 : media));
  }

  $('#btnConsultarItens').on('click', async () => {
    try {
      try {
        $.LoadingOverlay('show');
        let colunas = [];
        const dataSetCols = [];
        const bPesquisandoProduto = ($('#radioMaterial').is(':checked')) == false;
        const ajaxData = await montaSelectItens(bPesquisandoProduto);

        if (bPesquisandoProduto) {
          colunas = ['CODIGO', 'DESCRICAO', 'PRECO', 'TIPO'];
        } else {
          colunas = ['CODIGO', 'DESCRICAO', 'UNIDADE', 'PRECO', 'GRAMATURA', 'LARGURA', 'TIPO'];
        }

        for (let i = 0; i < colunas.length; i++) {
          dataSetCols.push({
            title: colunas[i],
            data: i,
          });
        }

        const tabelaItens = $('#tabelaItens').DataTable({
          paging: true,
          lengthChange: false,
          filter: true,
          info: true,
          order: true,
          autoWidth: true,
          destroy: true,
          serverSide: true,
          processing: true,
          ajax: {
            url: `${getCookie('protocolo')}://${getCookie('ip_api')}/sisplan/funcoes/v1/pesquisadatatable`,
            type: 'GET',
            headers: {
              Authorization: BASIC_AUTH,
            },
            data: ajaxData,
          },
          language: {
            sEmptyTable: 'Nenhuma consulta realizada',
            sInfo: '_TOTAL_ registros',
            sInfoEmpty: ' 0 registros',
            sInfoFiltered: '(Filtrados de _MAX_ registros)',
            sInfoPostFix: '',
            sInfoThousands: '.',
            sLengthMenu: '_MENU_ resultados',
            sLoadingRecords: 'Carregando...',
            sProcessing: 'Processando...',
            sZeroRecords: 'Nenhuma consulta realizada',
            sSearch: 'Pesquisa Complementar',
            oPaginate: {
              sNext: 'Próximo',
              sPrevious: 'Anterior',
              sFirst: 'Primeiro',
              sLast: 'Último',
            },
            oAria: {
              sSortAscending: ': Ordenar colunas de forma ascendente',
              sSortDescending: ': Ordenar colunas de forma descendente',
            },
          },
          columns: dataSetCols,
        });
      } catch (error) {
        console.error(error);
        msgErro('Não foi possível buscar os dados dos itens.');
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btn-sair').on('click', async () => {
    msgConfirmacaoCancelarB2B(
      /* html */`
        Caso confirmar você irá perder o Pedido. Deseja realmente cancelar?
        <br/>
        <label for="motivoSaida">Informe o motivo do cancelamento</label>
        <textarea name="" class="input-default focus form-control" id="motivoSaida" cols="30" rows="5"></textarea>
        <span style="color: rgb(206, 51, 51); font-size: 14px; margin-top: -4px" class="d-none informeCancelamento">Informe o motivo do cancelamento!</span>
      `,
      [
        async () => {
          await cancelaAtendimento();
        },
      ]
    );
  });

  $('#btn-codigo').on('click', () => {
    $('#modalItem').modal('show');
  });

  $('#txtVendedor').on('change', async () => {
    const sCodRep = pegaChave('#txtVendedor');
    selectTxtCliente.where = [`CODREP = '${sCodRep}'`];
    selectBtnCliente.where = [`CODREP = '${sCodRep}'`];
    $('#txtCliente').unbind('autocompleta');
    $('#txtCliente').autocompleta(3, `JSON=${JSON.stringify(selectTxtCliente)}`, ['#txtCNPJ'], ['CNPJ'], ['CNPJ']);
    $('#btn-cliente').off();
    $('#btn-cliente').unbind('pesquisa_serverside');
    $('#btn-cliente').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], JSON.stringify(selectBtnCliente), 'Pesquisa Cliente');

    $('#txtCliente').on('blur', async () => {
      carregaDadosClientes();
    });

    await retornaCooerdenador(sCodRep);
  });

  $('#txtCliente').on('blur', async () => {
    carregaDadosClientes();
  });

  $('#msform').validate({
    debug: false,
    rules: {
      txtTabela: {
        required: true,
      },
      txtVendedor: {
        required: true,
      },
      txtCliente: {
        required: true,
      },
      txtResponsavel: {
        required: true,
      },
      txtFormaContato: {
        required: true,
      },
    },
    messages: {
      txtTabela: {
        required: 'Informe um tabela de preço válida.',
      },
      txtVendedor: {
        required: 'Informe um vendedor válido.',
      },
      txtCliente: {
        required: 'Informe um cliente válido.',
      },
      txtResponsavel: {
        required: 'Informe um responsável válido.',
      },
      txtFormaContato: {
        required: 'Informe uma forma de contato válida.',
      },
    },
    errorElement: 'span',
    errorPlacement(error, element) {
      error.addClass('invalid-feedback');
      element.closest('.input-group').append(error);
    },
    highlight(element, errorClass, validClass) {
      $(element).addClass('is-invalid');
    },
    unhighlight(element, errorClass, validClass) {
      $(element).removeClass('is-invalid');
    },
  });

  $('#btnFinalizaPedido').on('click', async () => {
    try {
      $.LoadingOverlay('show');
      const coresNaoInformadas = pedido.itens.filter((item) => item.CORES.length == 0 && item.SITUACAO_CODIGO == 'A');
      const codigosNaoInformados = coresNaoInformadas.map((codigo) => codigo.CODIGO).toString();

      if (coresNaoInformadas.length > 0) {
        msgAlerta(`Itens: ${codigosNaoInformados} ainda não foram atendidos!`);
        return;
      }

      await RotinaCliqueFinalizaPedido();
      await montaJsonPedido();
      await separaPedidosPorItem();
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnInfo').on('click', () => {
    RotinaCliqueInfo();
  });

  $('.somAtivo').on('click', function () {
    $(this).addClass('d-none');
    localStorage.setItem('@pedido.somAtivo', false);
    $('.somInativo').removeClass('d-none');
  });

  $('.somInativo').on('click', function () {
    $(this).addClass('d-none');
    localStorage.setItem('@pedido.somAtivo', true);
    $('.somAtivo').removeClass('d-none');
  });

  async function verificaEstoque(data) {
    const codigo = data[0];
    const codigoProdutoBase = await verificaMaterialBase(codigo);
    const cores = await retornaCoresItem(codigo, codigoProdutoBase);
    var temEstoque = false;
    cores.forEach((cor) => {
      if (cor.estoques.filter((estoque) => estoque.quantidade > 0).length > 0) {
        temEstoque = true;
      }
      if (cor.ordemCompra) {
        if (cor.ordemCompra.filter((estoque) => estoque.quantidade > 0).length > 0) {
          temEstoque = true;
        }
      }
    });

    return temEstoque;

  }

  async function RotinaSaidaCodigo(data) {
    const codigo = data[0];
    const itensMesa = $('#tabelaItensMesa').DataTable().rows().data().toArray();
    const itemJaExisteNaMesa = itensMesa.filter((item) => item.CODIGO == codigo).length > 0;
    const temEstoque = await verificaEstoque(data);

    if (itemJaExisteNaMesa) {
      msgAlerta('Item já existe na mesa de atendimento!');
      return;
    }

    if (data[3] == '') {
      msgAlerta('Item sem preço cadastrado, impossível continuar');
      return;
    }

    if (!temEstoque) {
      msgAlerta('Item sem quantidade disponível nos estoques habilitados na empresa, impossível continuar!');
      return;
    }

    adicionaItensPedido({
      SITUACAO: '',
      CODIGO: codigo,
      DESCRICAO: data[1],
      ACOES: await retornaBotaoOpcoes(),
      PRECO: data[3],
      TIPO_ITEM: data[6],
      DATA: `${formataData(new Date())}T00:00:00Z`,
      UNIDADE: data[2],
      GRAMATURA: data[4],
      LARGURA: data[5],
      SITUACAO_CODIGO: 'A',
    });

    await montaJsonPedido();
    await salvarArquivoPedido(pedido);
  }

  async function cancelaAtendimento() {
    const url = '/sisplan/pedidob2b/v1/atendimentob2b?';
    const motivoSaida = $('#motivoSaida').val();
    const contador = $('#txtContador').val();
    const dataFormatada = formataDateTimeBackEnd(pedido.dataInicio);

    const atendimento = {
      Tempo: contador,
      Dt_Inicio: dataFormatada,
      Status: 'C',
      Usuario: sessionStorage.getItem('cod_usuario'),
      Pedido: '',
      AvaliacaoNota: 0,
      AvaliacaoObs: motivoSaida,
      NumAtendimento: pedido.numeroAtendimento,
    };

    const response = await requisicao('POST', url, '', JSON.stringify(atendimento));

    if (!response) {
      return false;
    }

    if (response.status != 200) {
      return false;
    }

    const hostname = `JsonPedido-${pedido.numeroAtendimento}`;
    await deletaDadosNaoSalvos(`${hostname}.txt`);
    window.location.href = `${BASE_URI}/pedidosb2b`;

    return true;

  }

  async function finalizaAtendimento() {
    const url = '/sisplan/pedidob2b/v1/atendimentob2b?';
    const avaliacaoNota = Number($('.selectedReacaoAtendimento').attr('nota'));
    const avaliacaoObs = $('#avaliacao').val();
    const contador = $('#txtContador').val();
    const dataFormatada = formataDateTimeBackEnd(pedido.dataInicio);
    const atendimento = {
      Tempo: contador,
      Dt_Inicio: dataFormatada,
      Status: 'F',
      Usuario: sessionStorage.getItem('cod_usuario'),
      Pedido: '',
      AvaliacaoNota: avaliacaoNota,
      AvaliacaoObs: avaliacaoObs,
      NumAtendimento: pedido.numeroAtendimento,
    };

    const response = await requisicao('POST', url, '', JSON.stringify(atendimento));

    if (!response) {
      return false;
    }

    if (response.status != 200) {
      return false;
    }

    return true;
  }

  async function gravaAtendimentoPendente(numeroPedido) {
    const url = '/sisplan/pedidob2b/v1/atendimentob2b?';
    const dataFormatada = formataDateTimeBackEnd(pedido.dataInicio);
    const atendimento = {
      Tempo: '00:00:00',
      Dt_Inicio: dataFormatada,
      Status: 'P',
      Usuario: sessionStorage.getItem('cod_usuario'),
      Pedido: numeroPedido,
      AvaliacaoNota: 1,
      NumAtendimento: numeroAtendimentoPedido,
    };
    const response = await requisicao('POST', url, '', JSON.stringify(atendimento));

    if (!response) {
      msgAlerta('Erro ao gravar atendimento!');
      return;
    }

    if (response.status != 200) {
      msgAlerta('Erro ao gravar atendimento!');
      return;
    }

    await montaJsonPedido();
    await salvarArquivoPedido(pedido);
  }

  $('#btnItens').on('click', async () => {
    if (($('#msform').validate().element('#txtResponsavel'))
      && ($('#msform').validate().element('#txtVendedor'))
      && ($('#msform').validate().element('#txtCliente'))
      && ($('#msform').validate().element('#txtFormaContato'))
      && ($('#msform').validate().element('#txtTabela'))) {
      RotinaCliqueItens();

      await montaJsonPedido();
      await salvarArquivoPedido(pedido);
    }
  });

  async function montaCarrinho() {
    const url = '/sisplan/pedidob2b/v1/montacarrinho?';
    const itens = {
      Itens: $('#tabelaItensCompletos').DataTable().rows().data()
        .toArray()
        .map((item) => ({
          Codigo: item.CODIGO_ITEM,
          Cor: item.COR,
          Estoque: item.ESTOQUE,
          Ordem_Compra: item.ORDEM_COMPRA,
          Preco: item.PRECO,
          Quantidade: item.QTDE,
          Total: item.VALOR_TOTAL,
        })),
    };

    const response = await requisicao('POST', url, '', JSON.stringify(itens));

    if (!response) {
      msgErro('Erro ao abrir o carrinho!');
      return;
    }

    if (response.status != 200) {
      msgErro('Erro ao abrir o carrinho!');
      return;
    }

    const json = await response.json();

    $('#tabelaCarrinho').DataTable().rows().remove()
      .draw(false);
    json.itens.map((item) => {
      const row = {
        ...item,
        ordem_Compra: item.ordem_Compra ? 'Sim' : 'Não',
      };
      adicionaLinhaTabela(row, '#tabelaCarrinho');
    });
  }

  $('#btnCarrinho').on('click', async () => {
    try {
      $.LoadingOverlay('show');
      $('#modal-carrinho').modal('show');

      await montaCarrinho();

      setTimeout(() => {
        $('#tabelaCarrinho').DataTable().columns.adjust().draw(false);
      }, 200);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#tabelaItensMesa tbody').on('click', 'td>div>div>div a.btnDesistir', async function () {
    try {
      const data = tabelaItensMesa.row($(this).parents('tr')).data();
      const dataDesistencia = tabelaDesistenciaItem.rows().data().toArray();
      $('#txtItemDesistencia').html(data.CODIGO);
      if (pedido.desistencias.length > 0) {
        pedido.desistencias.forEach((desistencia) => {
          if (desistencia.CODIGO == data.CODIGO) {
            if (dataDesistencia.filter((tabelaDesistencia) => desistencia.CODMEN == desistencia.CODMEN).length == 0) {
              adicionaLinhaTabela(desistencia, '#tabelaDesistenciaItem');
            }
          }
        });
      }
      $('#modalDesistir').modal('show');
    } catch (error) {
      console.error(error);
    }
  });

  $('#tabelaItensMesa tbody').on('click', 'td>div>div>div a.btn-imprimir-estoque', async function () {
    try {
      $.LoadingOverlay('show');
      try {
        const url = '/sisplan/impressao/v1/estoque?';
        const data_old = tabelaItensMesa.row($(this).parents('tr')).data();
        const layout = data_old.TIPO_ITEM == 'M' ? 'RelEstoqueMat' : 'RelEstoque';
        const bImprimeAutomatico = await verificaImprimirAutomatico(layout);
        const arquivo = await GeraRelatorio(`${url}CODIGO=${data_old.CODIGO}&TIPOITEM=${data_old.TIPO_ITEM}`, 'GET', 1000000, false, layout);
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#tabelaItensMesa tbody').on('click', 'td>div>div>div a.btn-imprimir-ft', async () => {
    try {
      $.LoadingOverlay('show');
      try {
        const url = '/sisplan/impressao/v1/estoque?';
        const filtros = await retornaFiltros();
        const ordem = `&TELA_ORDENACAO=RelEstoqueMat&ORDEM_ORDENACAO=${$('#txtOrdem').val()}`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelEstoqueMat');
        const arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelEstoqueMat');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnAdicionarDesistencia').on('click', async () => {
    const desistencia = {
      CODIGO: $('#txtItemDesistencia').html(),
      CODMEN: pegaChave('#txtDesistencia'),
      DESCRICAO: pegaDescricao('#txtDesistencia'),
    };
    adicionaLinhaTabela(desistencia, '#tabelaDesistenciaItem');

    limpaValor('#txtDesistencia');
  });

  $('#btnGravarDesistenciaItem').on('click', async () => {
    try {
      $.LoadingOverlay('show');
      const data = tabelaItensMesa.row('.selected').data();
      tabelaItensMesa.row('.selected').data({ ...data, SITUACAO: '<div class="situacaoIcon"><i class="fas fa-frown "></i></div>', SITUACAO_CODIGO: 'D' });

      await montaJsonPedido();
      await salvarArquivoPedido(pedido);
      atualizaTotaisPedido();
      $('#modalDesistir').modal('hide');
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnCancelarDesistenciaItem').on('click', async () => {
    try {
      $.LoadingOverlay('show');
      $("#tabelaDesistenciaItem").DataTable().rows().remove().draw(false);
      limpaValor('#txtDesistencia');
      $('#modalDesistir').modal('hide');
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnCancelarPedido').on('click', () => {
    msgAlerta(
      'Ao clicar em Confirmar você irá perder os dados que não foram salvos. Deseja realmente cancelar ? ',
      async () => {
        const hostname = `JsonPedido-${pedido.numeroAtendimento}`;
        if ((numeroAtendimentoPedido != 'create') && (numeroAtendimentoPedido != 'create#')) {
          await deletaRegistro('LOJA', getCookie('usuario'), numeroAtendimentoPedido);
        }
        await deletaDadosNaoSalvos(`${hostname}.txt`);
        window.location.href = `${BASE_URI}/pedidosb2b/create`;
      },
    );
  });

  $('#abreAjuda').on('click', () => {
    $('.subatalho').trigger('click');
    criaTelaAjuda();
  });

  $('#abrePreco').on('click', async () => {
    $('.subatalho').trigger('click');
    $('#modalPrecos').modal('show');
  });

  RotinaCliqueInfo();
  await carregaDadosPedido();
});
