$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
      onNext: (Element) => {
        if ((Element.node.id == 'avancar1')) {
          if (pegaChave('#txtNumero') == '') {
            insereValor('#txtNumero', ' ', ' ')
          };
          if (pegaChave('#txtCliente') == '') {
            insereValor('#txtCliente', ' ', ' ')
          };
          if (pegaChave('#txtRepresentante') == '') {
            insereValor('#txtRepresentante', ' ', ' ')
          };

          $('#avancar1').trigger('click');
        }
        else if ((Element.node.id == 'avancarComercial')) {
          if (pegaChave('#txtTabelaPreco') == '') {
            insereValor('#txtTabelaPreco', ' ', ' ')
          };
          $('#avancarComercial').trigger('click');
        }
        else if ((Element.node.id == 'avancarItens')) {
          if (pegaChave('#txtDeposito') == '') {
            insereValor('#txtDeposito', ' ', ' ')
          };
          if (pegaChave('#txtStatus') == '') {
            insereValor('#txtStatus', ' ', ' ')
          };
          $('#avancarItens').trigger('click');
        }
        else if ((Element.node.id == 'avancarFinanceiro')) {
          if (pegaChave('#txtTabelaPreco') == '') {
            insereValor('#txtTabelaPreco', ' ', ' ')
          };
          if (pegaChave('#txtMoeda') == '') {
            insereValor('#txtMoeda', ' ', ' ')
          };
          $('#avancarFinanceiro').trigger('click');
        }
        else if ((Element.node.id == 'avancarPagamento')) {
          $('#avancarPagamento').trigger('click');
        }
        else if ((Element.node.id == 'gravar')) {
          $('.driver-next-btn').on('click', location.reload());
        };
      },
      onPrevious: (Element) => {
        if (Element.node.id == 'VoltarGeral') {
          $('#VoltarGeral').trigger('click');
        }
        else if (Element.node.id == 'voltarComercial') {
          $('#voltarComercial').trigger('click');
        }
        else if (Element.node.id == 'ultimoVoltar') {
          $('#ultimoVoltar').trigger('click');
        }
        else if (Element.node.id == 'voltarItens') {
          $('#voltarItens').trigger('click');
        }
      }
    });

    driver.defineSteps([{
      element: '#tourGeral',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os dados gerais do pedido.',
        position: 'top'
      }
    },
    {
      element: '#txtCliente',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtRepresentante',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#avancar1',
      popover: {
        title: 'Botão Avançar',
        description: 'Clique aqui para avançar para a aba Comercial.',
        position: 'left'
      }
    },
    {
      element: '#VoltarGeral',
      popover: {
        title: 'Botão Voltar',
        description: 'Clique aqui para voltar para a aba Geral.',
        position: 'left'
      }
    },
    {
      element: '#tourComercial',
      popover: {
        title: 'Comercial',
        description: 'Aqui estão os dados comerciais do pedido.',
        position: 'left'
      }
    },
    {
      element: '#checkPrecoManual',
      popover: {
        title: 'Preço Manual',
        description: 'Opção para definir a tabela de preço como 999, neste caso é informado o preço manualmente no item.',
        position: 'top'
      }
    },
    {
      element: '#txtTabelaPreco',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#avancarComercial',
      popover: {
        title: 'Botão Avançar',
        description: 'Clique aqui para avançar para a aba Informações.',
        position: 'left'
      }
    },
    {
      element: '#voltarComercial',
      popover: {
        title: 'Botão Voltar',
        description: 'Clique aqui para voltar para a aba Comercial.',
        position: 'left'
      }
    },
    {
      element: '#financeiroFs',
      popover: {
        title: 'Informações',
        description: 'Aqui estão demais dados do pedido.',
        position: 'top'
      }
    },
    {
      element: '#txtDeposito',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtStatus',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#avancarItens',
      popover: {
        title: 'Botão Avançar',
        description: 'Clique aqui para avançar para a aba Itens.',
        position: 'left'
      }
    },
    {
      element: '#ultimoVoltar',
      popover: {
        title: 'Botão Voltar',
        description: 'Clique aqui para voltar para a aba Informações.',
        position: 'left'
      }
    },
    {
      element: '#tabelaItens_wrapper',
      popover: {
        title: 'Itens',
        description: 'Aqui estão os itens do pedido.',
        position: 'top'
      }
    },
    {
      element: '#btnAdicionar',
      popover: {
        title: 'Botão Adicionar',
        description: 'Clique aqui para inserir itens.',
        position: 'top'
      }
    },
    {
      element: '#avancarPagamento',
      popover: {
        title: 'Botão Avançar',
        description: 'Clique aqui para avançar para a aba Pagamento.',
        position: 'top'
      }
    },
    {
      element: '#voltarItens',
      popover: {
        title: 'Botão Voltar',
        description: 'Clique aqui para voltar para a aba Itens.',
        position: 'left'
      }
    },
    {
      element: '#tourFinanceiro',
      popover: {
        title: 'Pagamento',
        description: 'Aqui estão os dados de pagamento.',
        position: 'top'
      }
    },
    {
      element: '#txtCondPagto1',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtMoeda',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#btnLimpar',
      popover: {
        title: 'Botão Limpar',
        description: 'Clique aqui para limpar o grid das condições.',
        position: 'top'
      }
    },
    {
      element: '#btnAtualizar',
      popover: {
        title: 'Botão Atualizar',
        description: 'Clique aqui para atualizar as condições de pagamento. Irá criar as condições com os dados informados nos campos: "Nr. Parcelas", "Intervalo de Dias" e "1º Vencimento"',
        position: 'top'
      }
    },
    {
      element: '#tabelaCondicao',
      popover: {
        title: 'Condições',
        description: 'Aqui estão as condições de pagamento do pedido.',
        position: 'top'
      }
    },
    {
      element: '#gravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar o pedido.',
        position: 'top'
      }
    }
    ]);
    driver.start();
  });
});

async function reqRetornaDesconto(desconto) {
  try {
    const url = "/sisplan/pedido/v1/descpedido?";
    const response = await requisicao(
      "GET",
      url,
      `DESCONTO=${desconto}&CODCLI=${pegaChave('#txtCliente')}`,
      null
    );

    if (!response) {
      return;
    }
    if (response.status != 200) {
      msgErro(response.mensagem);
      return;
    }

    const jsonStr = await response.json();

    return jsonStr;
  } catch (error) {
    console.error(error);
  }
}

$(document).ready(async function () {

  let currentFs, nextFs, previousFs, opacity, produtoPesquisado;

  const parametrosSistema = await BuscaParametrosSistema('S');
  let quantidadeCasasDecimaisParametro = parametrosSistema[1] ?? 0;
  const quantidadeCasasDecimaisCampo = (+quantidadeCasasDecimaisParametro) + 2;
  let temCondicaoEntidade = false;

  adicionaPaginacao();
  adicionaValidacoes();
  adicionaMascaraCampos();
  adicionaPesquisaAutocompleta();
  criaDataTablePadrao('#tabelaItens', false, false, false, false, true, true, '400px', null, null, [], [], [], [5], {}, quantidadeCasasDecimaisCampo);
  criaDataTablePadrao('#tabelaCondicao', false, false, false, false, true, true, '250px', null, null, [], [], [], [4]);

  const BuscaPorCorETam = (await CopiaParametro('PEDIDO', 0));

  await adicionaEmpresas();
  await setaDatas();
  await validaEdicao();

  $('#txtNumero').on('blur', async function () {
    const sNumero = $('#txtNumero').val();
    if (sNumero == '') {
      $('#txtNumero').val(await RetornaProximo('PEDIDO', 'PEDIDO', 'NUMERO', 5));
      bloqueiaCampoNumero();
    } else if (await validaPedidoExistente(sNumero)) {
      window.location.href = btoa(sNumero);
    } else {
      msgAlerta('Número de pedido inexistente, favor verificar.');
      $('#txtNumero').focus();
    }
  });

  $('#txtCliente').on('blur', async function () {
    if ($(window.location.href.split('/')).get(-1) != 'create') {
      return;
    }
    const cliente = pegaChave('#txtCliente');
    if (cliente == '') {
      return;
    }
    await buscaDadosCliente(cliente);
  });

  $('#btnAdicionar').on('click', function () {
    $('#modalItem').modal('show');
  });

  $('#btnAtualizar').on('click', function () {
    geraCondicoes();
  });

  $('#btnLimpar').on('click', function () {
    limparTabelaCondicoes();
    limparCamposCondicoes();
    limparCamposDias();
    $('#dtPrimeiroVencto').val(new Date().toISOString().slice(0, 10));
    $('#txtCondicao').val('');
    $('#txtNrParcelas').prop('disabled', false);
    $('#txtIntervaloDias').prop('disabled', false);
  });

  $('#avancarPagamento').on('click', function () {
    retornaTotal();
  });

  $('#txtDesconto1').on('blur', function () {
    retornaTotal();
  });
  $('#txtDesconto2').on('blur', function () {
    retornaTotal();
  });
  $('#txtDesconto3').on('blur', function () {
    retornaTotal();
  });
  $('#txtDesconto4').on('blur', function () {
    retornaTotal();
  });
  $('#txtDesconto5').on('blur', function () {
    retornaTotal();
  });
  $('#txtDesconto6').on('blur', function () {
    retornaTotal();
  });

  $('#checkPrecoManual').on('click', function () {
    $('#txtTabelaPreco').prop('disabled', $('#checkPrecoManual').prop('checked'));
    $('#txtTabelaPreco').prop('readonly', $('#checkPrecoManual').prop('checked'));
    $('#btn-limpa-TabelaPreco').prop('disabled', $('#checkPrecoManual').prop('checked'));
    $('#btn-limpa-TabelaPreco').prop('readonly', $('#checkPrecoManual').prop('checked'));
    $('#btn-TabelaPreco').prop('disabled', $('#checkPrecoManual').prop('checked'));
    $('#btn-TabelaPreco').prop('readonly', $('#checkPrecoManual').prop('checked'));
    if ($('#checkPrecoManual').prop('checked')) {
      insereValor('#txtTabelaPreco', '999', 'Manual');
    } else {
      $('#txtTabelaPreco').val('');
    }
  });

  $('#tabelaItens').on('click', '.btn-excluir', async function () {
    $('#tabelaItens').DataTable().row($(this).parents('tr')).remove().draw(false);
  });

  $('#tabelaItens').on('click', '.imagem', async function () {
    $('.imagepreview').attr('src', $(this).attr('src'));
    $('#imagemodal').modal('show');
  });

  $('#txtProduto').on('blur', async function () {
    const codigo = pegaChave('#txtProduto');
    if (codigo == '') {
      return;
    };
    await explodeGradeProduto(codigo);
    await buscaQuantidadeEmEstoque(codigo, pegaChave('#txtDeposito'));
  });

  async function buscaQuantidadeEmEstoque(sCodigo, sDeposito) {
    const dadosSelect = {
      tabela: 'PA_ITEN',
      camposSelect: ['PA_ITEN.QUANTIDADE', 'PA_ITEN.COR', 'PA_ITEN.TAM', 'CADCOR.RGB'],
      leftJoin: [{ tabela: 'CADCOR', condicao: 'CADCOR.COR = PA_ITEN.COR' }],
      where: [`PA_ITEN.CODIGO = '${sCodigo}' AND PA_ITEN.DEPOSITO = '${sDeposito}'`]
    };
    const data = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!data) {
      return;
    }
    if (data.length == 0) {
      return;
    }

    produtoPesquisado = data;

    let qtdeTot = 0;
    data.map(item => { qtdeTot += item.QUANTIDADE });
    $('#txtQuantidadeEstoque').val(qtdeTot);

    $('#tabelaGradeProduto').DataTable().rows().data().map((item, index) => {
      const cor = (data.find(cor => { return cor.COR == item.COR })).RGB;
      if (cor.length == 9) {
        item.DESC_COR = `<span title="RGB" style="background-color: RGB(${cor.substr(0, 3)},${cor.substr(3, 3)}, ${cor.substr(6, 3)})">      </span>  ` + item.DESC_COR;
      }
      $('#tabelaGradeProduto').DataTable().row(index).data(item).draw(false);
    });

    $('.camposGrade').on('click', function () {
      const qtdeEst = produtoPesquisado.find(item => { return (item.COR == $(this).attr('cor') && item.TAM == $(this).attr('tam')) });
      if (qtdeEst) {
        insereValor('#txtCorSelecionado', qtdeEst.COR);
        insereValor('#txtTamSelecionado', qtdeEst.TAM);
        insereValor('#txtQtdeSelecionado', qtdeEst.QUANTIDADE);
      }
      $('.itemSelecionado').removeClass('d-none');
      $('#trocaClasse').addClass('d-flex justify-content-end');
    });

    $('.camposGrade').on('focusout', function () {
      $('.itemSelecionado').addClass('d-none');
      $('#trocaClasse').removeClass('d-flex justify-content-end');
    });
  }

  $('#txtMaterial, #txtCor').change(async function () {
    const codigo = pegaChave('#txtMaterial');
    const cor = pegaChave('#txtCor');

    if ((codigo == '') || (cor == '')) {
      return;
    };

    await buscaQuantidadeEmEstoqueMat(codigo, cor, pegaChave('#txtDeposito'));
  });

  async function buscaQuantidadeEmEstoqueMat(sCodigo, sCor, sDeposito) {
    const dadosSelect = {
      tabela: 'MAT_ITEN',
      camposSelect: ['SUM(QTDE) QTDE'],
      where: [`CODIGO = '${sCodigo}' AND COR = '${sCor}' AND DEPOSITO = '${sDeposito}'`]
    };
    const data = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!data) {
      return;
    }
    if (data.length == 0) {
      return;
    }
    $('#txtQuantidadeEstoqueMat').val(data[0].QTDE);
  }

  $('#btnConfirmarItem').on('click', async function () {
    if ($('#dadosMaterial').hasClass('d-none')) {
      confirmaProduto();
    } else {
      confirmaMaterial();
    }
  });

  $('#modalItem').on('hidden.bs.modal', function (_) {
    $('#txtProduto').val('');
    $('#txtValor').val('');
    $('#txtValorMat').val('');
    $('#txtMaterial').val('');
    $('#txtCor').val('');
    $('#txtQtde').val('1');

    if ($.fn.DataTable.isDataTable('#tabelaGradeProduto')) {
      $('#tabelaGradeProduto').DataTable().destroy();
      $('#tabelaGradeProduto').empty();
    };
  });

  $('#gravar').click(async function () {
    if (validaGravar()) {
      await gravaDados();
    }
  });

  $('#voltarAcesso').on('click', function () {
    window.location.href = `${BASE_URI}/pedido`;
  });

  $('#radioProduto, #radioMaterial').on('change', function () {
    if (isChecked('#radioProduto')) {
      $('#dadosProduto').removeClass('d-none');
      $('#dadosMaterial').addClass('d-none');
    } else {
      $('#dadosProduto').addClass('d-none');
      $('#dadosMaterial').removeClass('d-none');
    }
  });

  $('#txtMaterial').on('blur', async function () {
    sMaterial = pegaChave('#txtMaterial');

    if (sMaterial == '') {
      return;
    }

    $('#txtCor').unbind('autocompleta');
    $('#txtCor').autocompleta(1, `JSON={ "tabela":"MAT_ITEN", 
                                          "camposSelect":[ "MAT_ITEN.COR CHAVE", "CADCOR.DESCRICAO" ],
                                          "leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }], 
                                          "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"], 
                                          "where": ["MAT_ITEN.CODIGO = '${sMaterial}'"]}`, [], [], []);
    $('#btn-Cor').off();
    $('#btn-Cor').unbind('pesquisa');
    $('#btn-Cor').pesquisa('#txtCor', 'COR', 'DESCRICAO',
      `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"MAT_ITEN","camposSelect":[ "MAT_ITEN.COR", "CADCOR.DESCRICAO" ],"leftjoin": [{ "tabela" : "CADCOR", "condicao" : "MAT_ITEN.COR = CADCOR.COR" }],  "groupBy": ["MAT_ITEN.COR", "CADCOR.DESCRICAO"],"where": ["MAT_ITEN.CODIGO = '${sMaterial}'"]}`, 'Pesquisa Cor', 'CADCOR');

    if (pegaChave('#txtTabelaPreco') != '999') {
      let preco = '';
      if (BuscaPorCorETam == 1) {
        preco = await retornaPrecoCorTamProduto(pegaChave('#txtTabelaPreco'), sMaterial);
      } else {
        preco = await retornaPrecoProduto(pegaChave('#txtTabelaPreco'), sMaterial);
      }
      if (preco > 0) {
        $('#txtValorMat').val((+quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda(preco, quantidadeCasasDecimaisCampo)) : preco);
      } else {
        msgAlerta('Produto não consta na tabela de preço informada, necessário informar preço manualmente.')
      }
    }
  });

  async function validaEdicao() {
    const sPedido = $(window.location.href.split('/')).get(-1);

    if (sPedido == 'create') {
      await carregaValoresPadroes();
      return;
    };

    bloqueiaCampoNumero();

    $.LoadingOverlay('show');
    try {
      const dados = await retornaDadosPedido(atob(sPedido));
      const itens = await retornaDadosItens(atob(sPedido));
      const condicao = await retornaCondicoes(atob(sPedido));

      insereValor('#txtNumero', dados.NUMERO);
      insereValor('#txtPedCliente', dados.PED_CLI);
      insereValor('#dtDigita', dados.DTDIGITA.slice(0, 10));
      insereValor('#txtCliente', dados.CODCLI, dados.NOME);
      insereValor('#txtComFat', dados.COM1);
      insereValor('#txtComRec', dados.COM2);
      insereValor('#txtRepresentante', dados.CODREP, dados.NOME_REP);
      insereValor('#txtTransportadora', dados.TAB_TRANS, dados.NOME_TRAN);
      insereValor('#txtRedesp', dados.TAB_REDES, dados.NOME_REDES);
      insereValor('#txtResponsavel', dados.RESPONSAVEL, dados.NOME_RESP);
      insereValor('#txtColecao', dados.COLECAO, dados.DESC_COLECAO);
      insereValor('#txtCfop', dados.NATUREZA, dados.DESC_NATUREZA);
      insereValor('#txtPrazoEnt', dados.PERIODO, dados.DESC_PRZENT);
      insereValor('#txtPrazoProd', dados.PERIODOPROD, dados.DESC_PRZPROD);
      insereValor('#dtEmissao', dados.DT_EMISSAO.slice(0, 10));
      insereValor('#dtFatura', dados.DT_FATURA.slice(0, 10));
      insereValor('#dtEntrega', dados.ENTREGA.slice(0, 10));
      insereValor('#dtSaida', dados.DT_SAIDA.slice(0, 10));
      insereValor('#txtTabelaPreco', dados.TAB_PRE, dados.DESC_REGIAO);
      insereValor('#txtMoeda', dados.MOEDA, dados.DESC_MOEDA);
      insereValor('#txtClasseGer', dados.CLASSE_GER, dados.DESC_CLASSE);
      insereValor('#txtHistorico', dados.HISTORICO, dados.DESC_HISTORICO);
      insereValor('#txtTaxa', dados.TAXA);
      insereValor('#txtFrete', dados.FRETE);
      insereValor('#txtBonif', dados.BONIF);
      insereValor('#rgPrazo', dados.TAB_PRE2);
      insereValor('#txtDeposito', dados.DEPOSITO, dados.DESC_DEPOSITO);
      insereValor('#txtComprador', dados.COMPRADOR, dados.NOME_COMPRADOR);
      insereValor('#txtGrupoPed', dados.GRUPO, dados.DESC_GRUPO);
      insereValor('#txtStatus', dados.STATUS, dados.DESC_STATUS);
      insereValor('#txtEspecie', dados.ESPECIE, dados.DESC_ESPECIE);
      insereValor('#txtOperacao', dados.OPERACAO, dados.DESC_OPERACAO);
      insereValor('#txtTpVenda', dados.ID_TIPO, dados.DESC_TIPO);
      insereValor('#txtObservacao', dados.OBS);
      insereValor('#txtDepto', dados.DEPTO);
      insereValor('#txtPrzAdicional', dados.PRZ_DIAS);
      insereValor('#txtOrcamento', dados.ORCAMENTO);
      insereCondicoesPgto(dados.PGTO);
      insereDesconto(dados.DESCONTO);
      $('#selectEmpresa').val(dados.EMP_FAT).change();
      $('#rgTransportador').val(dados.CIF).change();
      $('#radioCIF').prop('checked', dados.REDESP_CIF == '1');
      $('#radioFOB').prop('checked', dados.REDESP_CIF != '1');
      $('#checkBonificacao').prop('checked', dados.BONIFICACAO == 'S');
      $('#checkPrecoManual').prop('checked', dados.TAB_PRE == '999');

      itens.map(item => { addItem(item) });
      condicao.map(item => { addCondicao(item) });
      habilitaCondicoes();
      $('#txtMoeda').trigger('blur');
    } finally {
      $.LoadingOverlay('hide');
    }
    bloqueiaCampoTabela();
  };

  async function carregaValoresPadroes() {
    const pesquisa = {
      camposSelect: ['CAMPO', 'VALOR'],
      tabela: 'TABPADRAO',
      where: [`TABELA = 'PEDIDO'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    jsonStr.map(item => {
      switch (item.CAMPO) {
        case 'DEPOSITO': {
          insereValor('#txtDeposito', item.VALOR, 'VALOR PADRÃO');
          break;
        }
        case 'STATUS': {
          insereValor('#txtStatus', item.VALOR, 'VALOR PADRÃO');
          break;
        }
        case 'TRANSPORTADORA': {
          insereValor('#txtTransportadora', item.VALOR, 'VALOR PADRÃO');
          break;
        }
        case 'HISTORICO': {
          insereValor('#txtHistorico', item.VALOR, 'VALOR PADRÃO');
          break;
        }
        case 'OPER_FISCAL': {
          insereValor('#txtOperacao', item.VALOR, 'VALOR PADRÃO');
          break;
        }
        case 'ITEM_PADRAO': {
          if (item.VALOR == 'M') {
            $('#radioMaterial').trigger('click');
          }
          break;
        }
      }
    });

    if ((!sessionStorage.getItem('g_vendedor_logado')) || (sessionStorage.getItem('g_vendedor_logado') == '')) {
      const usuarioLogado = sessionStorage.getItem('cod_usuario');
      const params = {
        tabela: 'acesso_usuarios',
        camposSelect: ['acesso_usuarios.codrep, represen.nome'],
        LeftJoin: [{
          "tabela": "represen",
          "condicao": "represen.codrep = acesso_usuarios.codrep"
        }],
        where: [`acesso_usuarios.codigo = '${usuarioLogado}'`]
      };

      const response = await retornaJsonPesquisaPadrao(JSON.stringify(params));

      if (!response) {
        return;
      }
      const vendedorDoUsuario = response[0].CODREP;
      const nomeVendedor = response[0].NOME;

      if (vendedorDoUsuario != '') {
        const sCaixa = '[' + vendedorDoUsuario + '] - ' + nomeVendedor;
        sessionStorage.setItem('g_vendedor_logado', sCaixa);

        insereValor('#txtRepresentante', vendedorDoUsuario, nomeVendedor)
      }
    } else {
      insereValor('#txtRepresentante', sessionStorage.getItem('g_vendedor_logado'));
    };
  };

  async function buscaCondicao(sNumero) {
    const dadosSelect = {
      tabela: 'CONDICAO',
      camposSelect: ['CONDICAO.NRPAR', 'CONDICAO.NRDIA'],
      where: [`CONDICAO.CODCOND = '${sNumero}'`]
    };

    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados da condição.');
      return;
    };
    insereValor('#txtNrParcelas', retornoSelect[0].NRPAR);
    insereValor('#txtIntervaloDias', retornoSelect[0].NRDIA);
  }

  async function retornaDadosItens(sNumero) {
    const dadosSelect = {
      tabela: 'PED_ITEN',
      camposSelect: ['PED_ITEN.CODIGO', `CASE WHEN PED_ITEN.TIPO = 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO`, 'PED_ITEN.COR', 'PED_ITEN.TAM', 'PED_ITEN.QTDE', 'PED_ITEN.PRECO', 'PED_ITEN.TIPO'],
      leftJoin: [
        { tabela: 'PRODUTO', condicao: 'PRODUTO.CODIGO = PED_ITEN.CODIGO' },
        { tabela: 'MATERIAL', condicao: 'MATERIAL.CODIGO = PED_ITEN.CODIGO' }
      ],
      where: [`PED_ITEN.NUMERO = '${sNumero}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados dos itens.');
      return;
    }
    return retornoSelect;
  };

  async function buscaDadosCliente(sCliente) {
    const dadosSelect = {
      tabela: 'ENTIDADE',
      camposSelect: ['ENTIDADE.NATUREZA', 'ENTIDADE.CLASSE', 'ENTIDADE.TABELA', 'ENTIDADE.CODREP',
        'NATUREZA.DESCRICAO DESC_NATUREZA', 'CLASSE_GER.DESCRICAO DESC_CLASSE', 'REGIAO.DESCRICAO DESC_TABELA', 'REPRESEN.NOME NOME_REP',
        'ENTIDADE.HISTORICO', 'HISTCP.DESCRICAO DESC_HISTORICO', 'ENTIDADE.MOEDA', 'MOEDA.DESCRICAO DESC_MOEDA', 'ENTIDADE.CONDICAO_PAGAMENTO', 'CONDICAO.DESCRICAO AS DESC_CONDPAGTO'],
      leftJoin: [
        { tabela: 'NATUREZA', condicao: 'NATUREZA.NATUREZA = ENTIDADE.NATUREZA' },
        { tabela: 'CLASSE_GER', condicao: 'CLASSE_GER.CODIGO = ENTIDADE.CLASSE' },
        { tabela: 'REGIAO', condicao: 'REGIAO.REGIAO = ENTIDADE.TABELA' },
        { tabela: 'REPRESEN', condicao: 'REPRESEN.CODREP = ENTIDADE.CODREP' },
        { tabela: 'HISTCP', condicao: 'HISTCP.HISTORICO = ENTIDADE.HISTORICO' },
        { tabela: 'MOEDA', condicao: 'CAST(MOEDA.CODMOE AS VARCHAR(10)) = ENTIDADE.MOEDA' },
        { tabela: 'CONDICAO', condicao: 'CAST(CONDICAO.CODCOND AS VARCHAR(10)) = ENTIDADE.CONDICAO_PAGAMENTO' }
      ],
      where: [`ENTIDADE.CODCLI = '${sCliente}'`]
    };
    const dados = (await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect)))[0];

    insereValor('#txtRepresentante', dados.CODREP, dados.NOME_REP);
    insereValor('#txtCfop', dados.NATUREZA, dados.DESC_NATUREZA);
    insereValor('#txtTabelaPreco', dados.TABELA, dados.DESC_TABELA);
    insereValor('#txtClasseGer', dados.CLASSE, dados.DESC_CLASSE);
    insereValor('#txtHistorico', dados.HISTORICO, dados.DESC_HISTORICO);
    await verificaCondicaoNaMoeda(dados.MOEDA, dados.DESC_MOEDA, dados.CONDICAO_PAGAMENTO, dados.DESC_CONDPAGTO);
  };

  async function verificaCondicaoNaMoeda(sMoeda, sMoedaDesc, sCondicao, sCondicaoDesc) {
    let PesquisaCodCond = '';

    if (sCondicao != '' && sCondicao != null && sMoeda != '' && sMoeda != null) {
      PesquisaCodCond = {
        tabela: 'COND_MOEDA',
        camposSelect: ['COND_MOEDA.MOEDA', 'COND_MOEDA.CODCOND'],
        where: [`COND_MOEDA.MOEDA = '${sMoeda}' AND COND_MOEDA.CODCOND = '${sCondicao}'`]
      };

      if (PesquisaCodCond != '') {
        const retornoPesquisa = await retornaJsonPesquisaPadrao(JSON.stringify(PesquisaCodCond));

        if (retornoPesquisa.length > 0) {
          temCondicaoEntidade = true;
          $('#txtMoeda').val(`[${sMoeda}] - ${sMoedaDesc}`);
          $('#txtCondicao').val(`[${sCondicao}] - ${sCondicaoDesc}`);
          $('#txtMoeda').trigger('blur');
        } else {
          $('#txtMoeda').val(`[${sMoeda}] - ${sMoedaDesc}`);
          $('#txtMoeda').trigger('blur');
        }
      }
    } else if (sMoeda != '' && sMoeda != null) {
      $('#txtMoeda').val(`[${sMoeda}] -  ${sMoedaDesc}`);
      $('#txtMoeda').trigger('blur');
    }
  };

  async function retornaCondicoes(sNumero) {
    const dadosSelect = {
      tabela: 'COND_PAGTO',
      camposSelect: ['COND_PAGTO.DIAS', 'COND_PAGTO.DT_VENCTO', 'COND_PAGTO.MOEDA', 'COND_PAGTO.VALOR', 'COND_PAGTO.CODCOND'],
      where: [`COND_PAGTO.NUMERO = '${sNumero}' AND TIPO = 'P'`],
      orderBy: [`COND_PAGTO.ORDEM`]
    };

    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar as condições de pagamento.');
      return;
    }
    return retornoSelect;
  };

  async function retornaDadosPedido(sNumero) {
    const dadosSelect = {
      tabela: 'PEDIDO',
      camposSelect: [
        'PEDIDO.NUMERO', 'PEDIDO.CODCLI', 'ENTIDADE.NOME', 'PEDIDO.OBS', 'PEDIDO.PED_CLI', 'PEDIDO.DTDIGITA', 'PEDIDO.EMP_FAT',
        'PEDIDO.COM1', 'PEDIDO.COM2', 'PEDIDO.CODREP', 'REPRESEN.NOME NOME_REP', 'PEDIDO.CIF', 'PEDIDO.TAB_TRANS',
        '(SELECT REDESPACHO.NOME FROM [TABTRAN] REDESPACHO WHERE REDESPACHO.CODIGO = PEDIDO.TAB_REDES) NOME_REDES',
        '(SELECT RESPONSAVEL.NOME FROM [ENTIDADE] RESPONSAVEL WHERE RESPONSAVEL.CODCLI = PEDIDO.RESPONSAVEL) NOME_RESP',
        '(SELECT PERIODOPROD.DESCRICAO FROM [TABPRZ] PERIODOPROD WHERE PERIODOPROD.PRAZO = PEDIDO.PERIODOPROD) DESC_PRZPROD',
        'TABTRAN.NOME NOME_TRAN', 'PEDIDO.TAB_REDES', 'PEDIDO.RESPONSAVEL', 'PEDIDO.COLECAO', 'COLECAO.DESCRICAO DESC_COLECAO',
        'PEDIDO.REDESP_CIF', 'PEDIDO.BONIFICACAO', 'PEDIDO.NATUREZA', 'NATUREZA.DESCRICAO DESC_NATUREZA', 'PEDIDO.PERIODO',
        'TABPRZ.DESCRICAO DESC_PRZENT', 'PEDIDO.PERIODOPROD', 'PEDIDO.DT_EMISSAO', 'PEDIDO.DT_FATURA', 'PEDIDO.ENTREGA',
        'PEDIDO.DT_SAIDA', 'PEDIDO.TAB_PRE', 'REGIAO.DESCRICAO DESC_REGIAO', 'PEDIDO.MOEDA', 'MOEDA.DESCRICAO DESC_MOEDA',
        'PEDIDO.CLASSE_GER', 'CLASSE_GER.DESCRICAO DESC_CLASSE', 'PEDIDO.HISTORICO', 'HISTCP.DESCRICAO DESC_HISTORICO',
        'PEDIDO.PGTO', 'PEDIDO.DESCONTO', 'PEDIDO.TAXA', 'PEDIDO.FRETE', 'PEDIDO.BONIF', 'PEDIDO.TAB_PRE2', 'PEDIDO.DEPOSITO',
        'DEPOSITO.DESCRICAO DESC_DEPOSITO', 'PEDIDO.COMPRADOR', 'CONTATO.NOME NOME_COMPRADOR', 'PEDIDO.GRUPO', 'PEDIDO.STATUS',
        'GRUPO_PED.DESCRICAO DESC_GRUPO', 'SITPROD.DESCRICAO DESC_STATUS', 'PEDIDO.ESPECIE', 'ESPECIE.DESCRICAO DESC_ESPECIE',
        'PEDIDO.OPERACAO', 'OPER_FISCAL.DESCRICAO DESC_OPERACAO', 'PEDIDO.DEPTO', 'PEDIDO.PRZ_DIAS', 'PEDIDO.ORCAMENTO',
        'PEDIDO.ID_TIPO', 'TIPO.DESCRICAO DESC_TIPO'
      ],
      leftJoin: [
        { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI       = PEDIDO.CODCLI' },
        { tabela: 'REPRESEN', condicao: 'REPRESEN.CODREP       = PEDIDO.CODREP' },
        { tabela: 'TABTRAN', condicao: 'TABTRAN.CODIGO         = PEDIDO.TAB_TRANS' },
        { tabela: 'COLECAO', condicao: 'COLECAO.CODIGO         = PEDIDO.COLECAO' },
        { tabela: 'NATUREZA', condicao: 'NATUREZA.NATUREZA     = PEDIDO.NATUREZA' },
        { tabela: 'TABPRZ', condicao: 'TABPRZ.PRAZO            = PEDIDO.PERIODO' },
        { tabela: 'REGIAO', condicao: 'REGIAO.REGIAO           = PEDIDO.TAB_PRE' },
        { tabela: 'MOEDA', condicao: 'UDF_CAST(MOEDA.CODMOE AS VARCHAR (10)) = PEDIDO.MOEDA' },
        { tabela: 'CLASSE_GER', condicao: 'CLASSE_GER.CODIGO   = PEDIDO.CLASSE_GER' },
        { tabela: 'HISTCP', condicao: 'HISTCP.HISTORICO        = PEDIDO.HISTORICO' },
        { tabela: 'DEPOSITO', condicao: 'DEPOSITO.CODIGO       = PEDIDO.DEPOSITO' },
        { tabela: 'CONTATO', condicao: 'CONTATO.CODCLI         = PEDIDO.COMPRADOR' },
        { tabela: 'GRUPO_PED', condicao: 'GRUPO_PED.CODIGO     = PEDIDO.GRUPO' },
        { tabela: 'SITPROD', condicao: 'SITPROD.CODIGO         = PEDIDO.STATUS' },
        { tabela: 'ESPECIE', condicao: 'ESPECIE.CODIGO         = PEDIDO.ESPECIE' },
        { tabela: 'OPER_FISCAL', condicao: 'OPER_FISCAL.CODIGO = PEDIDO.OPERACAO' },
        { tabela: 'TIPO', condicao: 'TIPO.ID_TIPO              = PEDIDO.ID_TIPO' }
      ],
      where: [`PEDIDO.NUMERO = '${sNumero}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      msgAlerta('Não foi possível buscar os dados do pedido.');
      return;
    }
    return retornoSelect[0];
  };

  async function retornaPrecoProduto(sTabPreco, sCodProd) {
    const dadosSelect = {
      tabela: 'TABPRECO',
      camposSelect: ['PRECO_00'],
      where: [`REGIAO = '${sTabPreco}' AND CODIGO = '${sCodProd}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      return;
    }
    if (retornoSelect.length == 0) {
      return;
    }
    return retornoSelect[0].PRECO_00;
  };

  async function retornaPrecoCorTamProduto(sTabPreco, sCodProd) {
    const dadosSelect = {
      tabela: 'PRECO_COR_TAM',
      camposSelect: ['PRECO'],
      where: [`REGIAO = '${sTabPreco}' AND CODIGO = '${sCodProd}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      return;
    }
    if (retornoSelect.length == 0) {
      return;
    }
    return retornoSelect[0].PRECO;
  };

  async function habilitaCondicoes() {
    let habilita = await contemCondicao();
    $('#txtCondicao').prop('disabled', habilita);
    $('#btn-Condicao').prop('disabled', habilita);
    $('#btn-limpa-Condicao').prop('disabled', habilita);
    $('#txtNrParcelas').prop('disabled', habilita);
    $('#txtIntervaloDias').prop('disabled', habilita);
    $('#dtPrimeiroVencto').prop('disabled', habilita);
    $('#btnLimpar').prop('disabled', habilita);
    $('#btnAtualizar').prop('disabled', habilita);

    if (habilita) {
      limparTabelaCondicoes();
    }
  };

  async function contemCondicao() {
    const moeda = pegaChave('#txtMoeda');

    if (moeda == '') {
      return true;
    };

    const dadosSelect = {
      tabela: 'CONDICAO',
      camposSelect: ['COND_MOEDA.CODCOND'],
      innerJoin: [{ tabela: 'COND_MOEDA', condicao: 'COND_MOEDA.CODCOND = CONDICAO.CODCOND' }],
      where: [`COND_MOEDA.MOEDA = '${moeda}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      return true;
    }
    if (retornoSelect.length == 0) {
      return true;
    }
    return false;
  };

  function validaGravar() {
    if ($('#tabelaItens').DataTable().data().length == 0) {
      msgAlerta('Nenhum item informado, impossível continuar!');
      $('#voltarItens').trigger('click');
      return
    }
    let validator = $("#msform").validate();
    validator.element("#txtMoeda");
    validator.element("#txtCondPagto1");
    if (!(validator.element("#txtMoeda") && validator.element("#txtCondPagto1"))) {
      return false;
    }
    return true;
  };

  async function gravaDados() {
    $.LoadingOverlay('show');
    try {

      const pedido = {
        NUMERO: pegaValor('#txtNumero'),
        PED_CLI: pegaValor('#txtPedCliente'),
        DTDIGITA: pegaValor('#dtDigita'),
        CODCLI: pegaChave('#txtCliente'),
        COM1: pegaValor('#txtComFat'),
        COM2: pegaValor('#txtComRec'),
        CODREP: pegaChave('#txtRepresentante'),
        TAB_TRANS: pegaChave('#txtTransportadora'),
        TAB_REDES: pegaChave('#txtRedesp'),
        RESPONSAVEL: pegaChave('#txtResponsavel'),
        COLECAO: pegaChave('#txtColecao'),
        NATUREZA: pegaChave('#txtCfop'),
        PERIODO: pegaChave('#txtPrazoEnt'),
        PERIODOPROD: pegaChave('#txtPrazoProd'),
        DT_EMISSAO: pegaValor('#dtEmissao'),
        DT_FATURA: pegaValor('#dtFatura'),
        ENTREGA: pegaValor('#dtEntrega'),
        DT_SAIDA: pegaValor('#dtSaida'),
        TAB_PRE: pegaChave('#txtTabelaPreco'),
        MOEDA: pegaChave('#txtMoeda'),
        CLASSE_GER: pegaChave('#txtClasseGer'),
        HISTORICO: pegaChave('#txtHistorico'),
        TAXA: pegaValor('#txtTaxa'),
        FRETE: pegaValor('#txtFrete'),
        BONIF: pegaValor('#txtBonif'),
        TAB_PRE2: pegaValor('#rgPrazo'),
        DEPOSITO: pegaChave('#txtDeposito'),
        COMPRADOR: pegaChave('#txtComprador'),
        GRUPO: pegaChave('#txtGrupoPed'),
        STATUS: pegaChave('#txtStatus'),
        ESPECIE: pegaChave('#txtEspecie'),
        OPERACAO: pegaChave('#txtOperacao'),
        ID_TIPO: pegaChave('#txtTpVenda'),
        DEPTO: pegaValor('#txtDepto'),
        PRZ_DIAS: pegaValor('#txtPrzAdicional'),
        ORCAMENTO: pegaValor('#txtOrcamento'),
        EMP_FAT: pegaValor('#selectEmpresa'),
        CIF: pegaValor('#rgTransportador'),
        OBS: pegaValor('#txtObservacao'),
        REDESP_CIF: $('#radioCIF').prop('checked') ? '1' : '2',
        BONIFICACAO: $('#checkBonificacao').prop('checked') ? 'S' : 'N',
        EMP_ID: getCookie('emp_id'),
        PGTO: retornaCondicoesPgto(),
        DESCONTO: retornaDesconto(),
        COND_PAGTOS: retornaCondPagto(),
        REC_SIMULA: retornaRecSimula(),
        ITENS: retornaItens()
      };

      const response = await requisicao('POST', '/sisplan/pedido/v1/pedido?', '', JSON.stringify(pedido), 90000);

      if (!response) {
        $.LoadingOverlay('hide');
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay('hide');
        msgErro(jsonStr.mensagem);
        return;
      }

      $.LoadingOverlay('hide');
      msgAlerta('Deseja imprimir o pedido?',
        async () => { await imprimirPedido(pedido.NUMERO); callBack(); },
        () => { callBack(); },
        () => { },
        () => { callBack(); });

      function callBack() {
        criaMensagemSucesso(`Pedido ${pegaValor('#txtNumero')} gravado com sucesso!`, () => { window.location.href = `${BASE_URI}/pedido`; });
      }

    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
      msgErro(`Não foi possível gravar os dados do pedido: ${error}`);
    }
  };

  async function imprimirPedido(numero) {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/impressao/v1/acesso_pedido?`;

        const ordem = `&TELA_ORDENACAO=acesso_pedido&ORDEM_ORDENACAO=1`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelPedidoA');
        let arquivo = await GeraRelatorio(`${url}&NUMERO='${numero}'${ordem}`, 'GET', 1000000, false, 'RelPedidoA');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function validaPedidoExistente(sNumero) {
    const dadosSelect = {
      tabela: 'PEDIDO',
      camposSelect: ['NUMERO'],
      where: [`NUMERO = '${sNumero}'`]
    };
    const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
    if (!retornoSelect) {
      return;
    }
    if (retornoSelect.length == 0) {
      return false;
    }
    return true;
  };

  async function adicionaEmpresas() {
    const pesquisaParam = {
      tabela: 'EMPRESA',
      camposSelect: ['EMP_PAT', 'EMP_NOME'],
      where: ['1 = 1'],
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    jsonStr.map(emp => {
      $("#selectEmpresa").append(new Option(`${emp.EMP_PAT} - ${emp.EMP_NOME}`, emp.EMP_PAT.replace('_', ''), null, emp.EMP_PAT == getCookie('empresa')));
    });
  };

  async function explodeGradeProduto(codigo) {
    $.LoadingOverlay('show');
    try {
      let tam;
      if ($.fn.DataTable.isDataTable('#tabelaGradeProduto')) {
        $('#tabelaGradeProduto').DataTable().destroy();
        $('#tabelaGradeProduto').empty();
      };

      const response = await requisicao('GET', '/sisplan/funcoes/v1/gradeproduto?', `CODIGO=${codigo}`, null);
      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
      }

      for (let i = 0; i < parseInt(jsonStr.length); i++) {
        const colunas = Object.keys(jsonStr[i]);
        const tamanhos = [];
        colunas.forEach((coluna) => {
          if (!['CODIGO', 'COR', 'DESC_COR', 'POSICAO'].includes(coluna)) {
            tamanhos.push(coluna);
          }
        });

        const jsonObject = jsonStr.map(obj => {
          const newObject = { ...obj };
          delete newObject.CODIGO;
          delete newObject.POSICAO;
          Object.keys(obj).forEach(key => {
            tam = RetornaIdTamFormatado(key);
            if (!['CODIGO', 'COR', 'POSICAO', 'DESC_COR'].includes(tam)) {
              newObject[tam] = `<input type="text" class="input-default focus form-control camposGrade" id="${newObject.COR.replace('.', '') + tam}" value="${jsonStr[i][tam]}">`;
              newObject[tam.split('HIFEN')[1]] = `<input type="text" cor="${newObject.COR}" tam="${tam.split('HIFEN')[1]}" style="width: 60px" class="input-default focus form-control camposGrade" id="${newObject.COR.replace('.', 'dot') + tam}" value="0">`;
              delete newObject[tam];
            }
          });
          return { ...newObject };
        });

        if (i == 0) {
          const titulosFixos = ['COR', 'DESC_COR'];
          const titulosGeral = [...titulosFixos, ...tamanhos];
          const titulos = titulosGeral.map(titulo => {
            const coluna = ['COR', 'DESC_COR'].includes(titulo) ? titulo : titulo.split('HIFEN')[1];
            const objeto = { title: coluna, data: RetornaIdTamFormatado(coluna) };
            return objeto;
          });
          criaDataTablePadrao('#tabelaGradeProduto', false, false, false, false, true, true, '250px', jsonObject, titulos);
        }
      }

      if (pegaChave('#txtTabelaPreco') != '999') {
        let preco = '';
        if (BuscaPorCorETam == 1) {
          preco = await retornaPrecoCorTamProduto(pegaChave('#txtTabelaPreco'), codigo);
        } else {
          preco = await retornaPrecoProduto(pegaChave('#txtTabelaPreco'), codigo);
        }
        if (preco > 0) {
          $('#txtValor').val((+quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda(preco, quantidadeCasasDecimaisCampo)) : preco);
        } else {
          msgAlerta('Produto não consta na tabela de preço informada, necessário informar preço manualmente.')
        }
      }

    } finally {
      $.LoadingOverlay('hide');

      $('.camposGrade').on('blur', function () {
        preencheComZero();
      });

      $('.camposGrade').maskMoney({
        decimal: ".",
        thousands: "",
        precision: 0,
      });
      preencheComZero();
      $('#txtValor').focus();
    }
  };

  async function setaDatas() {
    await setarDataAtual('dtDigita');
    await setarDataAtual('dtEmissao');
    await setarDataAtual('dtFatura');
    await setarDataAtual('dtEntrega');
    await setarDataAtual('dtSaida');
    await setarDataAtual('dtPrimeiroVencto');
  };

  function insereCondicoesPgto(sPagto) {
    for (let i = 0; i < 36; i += 3) {
      const id = '#txtCondPagto' + (i == 0 ? 1 : ((i / 3) + 1));
      $(id).val(((sPagto.substring(i, 3 + i)).replace(/^(0+)(\d)/g, "$2")).trim());
    }
  };

  function limparCamposCondicoes() {
    let id;
    for (let i = 1; i <= 12; i++) {
      id = '#txtCondPagto' + i;
      $(id).val('');
    }
  };

  function limparCamposDias() {
    $("#txtNrParcelas, #txtIntervaloDias").val("")
  };

  async function atualizaData() {
    if ($('#txtIntervaloDias').val() !== '0' || $('#txtIntervaloDias').val() !== '') {
      let intervaloDias;
      let condicao;
      if ($('#txtCondicao').val() != '') {
        condicao = pegaChave('#txtCondicao');

        intervaloDias = await buscaValor('CONDICAO', 'PRAZOINI', 'CODCOND', condicao);

        if (intervaloDias != undefined) {
          intervaloDias = intervaloDias.PRAZOINI;
        }
      } else {
        intervaloDias = parseInt($('#txtIntervaloDias').val());
      }

      const dataAtual = new Date();
      const dataVencimento = new Date(dataAtual.setDate(dataAtual.getDate() + intervaloDias));
      $('#dtPrimeiroVencto').val(dataVencimento.toISOString().substr(0, 10));
    } else {
      await setarDataAtual('dtPrimeiroVencto')
    };
  }

  async function geraCondicoes() {
    // await atualizaData();
    const dtVencto = pegaValor('#dtPrimeiroVencto').split('-');
    let dataCondicoes = (new Date().toISOString().slice(0, 10)).split('-');
    let venctoTabela = new Date(dataCondicoes[0], dataCondicoes[1] - 1, dataCondicoes[2], 23, 59, 59);
    let vencto = new Date(dtVencto[0], dtVencto[1] - 1, dtVencto[2], 23, 59, 59);
    if (vencto < new Date()) {
      msgAlerta('Campo "1º Vencimento" menor que a data atual, impossível continuar!');
      return;
    };
    limparTabelaCondicoes();
    limparCamposCondicoes();
    let data = new Date();
    let dias;
    let total = 0;
    let valor = 0;
    let novoVencto = new Date(dtVencto[0], dtVencto[1] - 1, dtVencto[2], 23, 59, 59);
    let novoVenctoTabela = new Date();
    data.setDate(novoVencto.getDate());
    data.setDate(novoVenctoTabela.getDate());
    const parcelas = pegaValor('#txtNrParcelas') == 0 ? 1 : pegaValor('#txtNrParcelas');
    const moeda = pegaChave('#txtMoeda');
    const condicao = pegaChave('#txtCondicao');
    const intervalo = pegaValor('#txtIntervaloDias');
    const valorPed = pegaValor('#txtValorLiq');
    let prazoini = parseFloat($('#txtIntervaloDias').val());
    if ($('#txtCondicao').val() != '') {
      prazoini = await buscaValor('CONDICAO', 'PRAZOINI', 'CODCOND', condicao);
      if (!!prazoini) {
        prazoini = prazoini.PRAZOINI;
      }
    }
    for (let i = 1; i <= parcelas;) {
      // Nesta primeira parte são calculados os dias dos inputs das condições de pagamento (parte superior)
      dias = diferencaDias(venctoTabela, data);
      dias += prazoini;
      valor = TruncaDecimaisNova(2, valorPed / parcelas);
      total += valor;
      if (i == parcelas) {
        valor = TruncaDecimaisNova(2, valor + (valorPed - total));
      };
      const id = '#txtCondPagto' + i;
      i == 1 && --dias;
      $(id).val(dias);
      // Nesta segunda parte são calculados as datas de vencimento a partir do que estiver informado nos campos intervalo de dias, nr. parcelas e 1º vencimento
      // Estas informações são adicionadas na tabela
      $('#tabelaCondicao').DataTable().row.add([
        dias,
        formataData(vencto),
        moeda,
        condicao,
        valor
      ]).draw(false);
      novoVenctoTabela.setDate(venctoTabela.getDate() + parseInt(intervalo));
      venctoTabela = novoVenctoTabela;
      novoVencto.setDate(vencto.getDate() + parseInt(intervalo));
      vencto = novoVencto;
      i++
    }
  };

  $("#txtIntervaloDias").blur(function () {
    atualizaData(); // substitua "minhaFuncao" pelo nome da sua função
  });

  function limparTabelaCondicoes() {
    if ($('#tabelaCondicao').DataTable().rows().count() > 0) {
      $('#tabelaCondicao').empty();
      criaDataTablePadrao('#tabelaCondicao', false, false, false, false, true, true, '250px');
      $("#tabelaCondicao").DataTable().columns.adjust().draw(false);
    };
    // $("#dtPrimeiroVencto").val(ne)
  };

  function diferencaDias(data1, data2) {
    const diferenca = Math.abs(data1.getTime() - data2.getTime());
    const result = Math.ceil(diferenca / (1000 * 60 * 60 * 24));
    return result;
  };

  function retornaCondicoesPgto() {
    let sCondicoes = '';
    for (let i = 1; i <= 12;) {
      if ((sCondicoes.length % 3) != 0) {
        sCondicoes += ' ';
      } else {
        sCondicoes += $('#txtCondPagto' + i).val();
        i++;
      }
    }
    return sCondicoes;
  }

  function insereDesconto(sDesconto) {
    for (let i = 0; i < 30; i += 5) {
      const id = '#txtDesconto' + (i == 0 ? 1 : ((i / 5) + 1));
      $(id).val(((sDesconto.substring(i, 5 + i)).trim()).replaceAll(',', '.'));
    }
  }

  function retornaDesconto() {
    let sDesconto = '';
    for (let i = 1; i <= 6;) {
      if ((sDesconto.length % 5) != 0) {
        sDesconto += ' ';
      } else {
        sDesconto += $('#txtDesconto' + i).val();
        i++;
      }
    }
    return (sDesconto.replaceAll('.', ','));
  }

  function retornaItens() {
    let arrItens = [];
    $('#tabelaItens').DataTable().rows().data().map((item, index) => {
      arrItens.push({
        CODIGO: item[0],
        COR: item[2],
        TAM: item[3],
        QTDE: item[4],
        QTDE_ORIG: item[4],
        PRECO: item[5],
        PRECO_ORIG: item[5],
        TIPO: item[6],
        QUALIDADE: '1',
        ORDEM: 1
      })
    });
    return arrItens;
  };

  function retornaCondPagto() {
    let arrCondicoes = [];
    let i = 1;
    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      arrCondicoes.push({
        DIAS: item[0],
        DT_VENCTO: item[1],
        MOEDA: item[2],
        CODCOND: item[3],
        VALOR: item[4],
        TIPO: 'P',
        NUMERO: pegaValor('#txtNumero'),
        ORDEM: i++
      })
    });
    return arrCondicoes;
  };

  function retornaRecSimula() {
    let arrRec_Simula = [];
    let i = 1;
    $('#tabelaCondicao').DataTable().rows().data().map(item => {
      arrRec_Simula.push({
        PEDIDO: pegaValor('#txtNumero'),
        VENCTO: item[1],
        VALOR_PARCELA: item[4],
        VALOR_TOTAL: pegaValor('#txtValorLiq'),
        NUM_PARCELA: i++,
        DT_FATURA: pegaValor('#dtDigita')
      })
    });
    return arrRec_Simula;
  };

  async function retornaTotal() {
    let total = 0;
    let desconto = 0;
    let desc = '';
    desc = retornaDesconto();
    desconto = await reqRetornaDesconto(desc);
    $('#tabelaItens').DataTable().rows().data().map(item => {
      total += (item[4] * item[5]);
    });
    desconto = (total * (desconto / 100));
    total = total - desconto;
    insereValor('#txtValorLiq', total.toFixed(2))
  };

  function preencheComZero() {
    setTimeout(() => {
      $('.camposGrade').map((index) => {
        if ($($('.camposGrade')[index]).val() == '') {
          $($('.camposGrade')[index]).val('0');
        }
      });
    }, 100);
  };

  function confirmaProduto() {
    try {
      const valorUnit = $('#txtValor').val();

      if ($('#txtProduto').val() == '') {
        msgAlerta('Produto não informado, impossível continuar');
        return;
      }

      if ($('#tabelaGradeProduto').DataTable().rows().count() == 0) {
        $('#modalItem').modal('hide');
        return;
      }

      if ((valorUnit == '') || (valorUnit == 0)) {
        msgAlerta('Preço não informado, impossível continuar.');
        return;
      }

      let grade = [];
      const listaDados = $('#tabelaGradeProduto').DataTable().data().toArray();
      listaDados.forEach(dado => {
        const objeto = Object.entries(dado);
        let coluna;
        const colunas = objeto.map(prop => prop[0]);

        for (let i = 0; i < colunas.length; i++) {
          if ((!['COR', 'DESC_COR'].includes(colunas[i])) && (colunas[i].indexOf('/') == -1)) {
            coluna = RetornaIdTamFormatado(colunas[i], true);
            const idSemFormatacao = dado[colunas[i]].split('id="')[1].replace('"', '');
            const idFormatado = idSemFormatacao.split(" value=")[0];
            const retorno = {
              CODIGO: pegaChave('#txtProduto'),
              DESCRICAO: pegaDescricao('#txtProduto'),
              COR: dado.COR,
              TAM: coluna,
              QTDE: $(`#${idFormatado}`).val(),
              PRECO: valorUnit,
              TIPO: 'P'
            };
            grade.push(retorno);
          }
        }
      });

      grade.map((item) => {
        if (parseFloat(item.QTDE) > 0) {
          addItem(item);
        }
      });

      $('#modalItem').modal('hide');

    } finally {
      $('#txtValor').val('');
    }
  };

  function confirmaMaterial() {
    try {

      if ($('#txtQtde').val() == '') {
        msgAlerta('Quantidade não informada, impossível continuar.');
        return;
      }

      if ($('#txtMaterial').val() == '') {
        msgAlerta('Material não informado, impossível continuar.');
        return;
      }

      if ($('#txtCor').val() == '') {
        msgAlerta('Cor não informada, impossível continuar.');
        return;
      }

      if (($('#txtValorMat').val() == '') || ($('#txtValorMat').val() == 0)) {
        msgAlerta('Preço não informado, impossível continuar.');
        return;
      }

      addItem({
        CODIGO: pegaChave('#txtMaterial'),
        DESCRICAO: pegaDescricao('#txtMaterial'),
        COR: pegaChave('#txtCor'),
        TAM: '0',
        QTDE: $('#txtQtde').val(),
        PRECO: $('#txtValorMat').val(),
        TIPO: 'M'
      });

    } finally {
      $('#modalItem').modal('hide');
    }
  };

  function bloqueiaCampoNumero() {
    $('#txtNumero').prop('disabled', true);
    $('#txtNumero').prop('readonly', true);
  }

  function bloqueiaCampoTabela() {
    if ($('#tabelaItens').DataTable().rows().count() > 0) {
      $('#txtTabelaPreco').prop('disabled', true);
      $('#txtTabelaPreco').prop('readonly', true);
      $('#btn-limpa-TabelaPreco').prop('disabled', true);
      $('#btn-limpa-TabelaPreco').prop('readonly', true);
      $('#btn-TabelaPreco').prop('disabled', true);
      $('#btn-TabelaPreco').prop('readonly', true);
      $('#checkPrecoManual').prop('disabled', true);
      $('#checkPrecoManual').prop('readonly', true);
    }
  }

  function addItem(sItem) {
    $('#tabelaItens').DataTable().row.add(
      [
        sItem.CODIGO,
        sItem.DESCRICAO,
        sItem.COR,
        sItem.TAM,
        sItem.QTDE,
        sItem.PRECO,
        sItem.TIPO,
        retornaFotoProduto(sItem.CODIGO, sItem.COR + sItem.TAM),
        botaoExcluir()
      ]).draw(false);
  };

  function addCondicao(sItem) {
    $('#tabelaCondicao').DataTable().row.add(
      [
        sItem.DIAS,
        sItem.DT_VENCTO,
        sItem.MOEDA,
        sItem.CODCOND,
        sItem.VALOR
      ]).draw(false);
  };

  async function buscaFotoProduto(codigo, ordem) {
    const codigoFormatado = criptografaCodigo('img_prod_' + codigo + '_' + ordem);
    try {
      const urlRequisicao = '/Sisplan/Funcoes/v1/FotoItem?';
      const response = await requisicao('GET', urlRequisicao, `codigo=${codigo}`, null);

      if (!response) {
        return;
      }
      const jsonStr = await response.json();
      if (response.status != 200) {
        $(`#${codigoFormatado}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        return;
      }

      const sBase64 = jsonStr;
      $(`#${codigoFormatado}`).attr('src', `data:image/png;base64,${sBase64.mensagem}`);

    } catch (error) {
      console.error(error);
      $(`#${codigoFormatado}`).attr('src', `${BASE_URI}/dist/img/prod-1.png`);
    }
  };

  function retornaFotoProduto(codigo, ordem) {
    buscaFotoProduto(codigo, ordem);
    const codigoCriptografado = criptografaCodigo('img_prod_' + codigo + '_' + ordem);
    return `<img class="imagem" id="${codigoCriptografado}" src="dist/img/prod-1.png" loading="lazy" alt="" height="75" width="75"/>`
  };

  function criptografaCodigo(codigo) {
    return btoa(codigo).replaceAll('=', '');
  };

  function botaoExcluir() {
    return '<div class="divBtnOpcoes"> ' +
      '       <button class="botaoOpcoes btn-excluir" type="button" title="Excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      '     </div>';
  };

  function adicionaPaginacao() {
    $(".next").click(async function () {
      let validator = $("#msform").validate();
      let liberado = true;

      if ($(this).attr("id") == "avancar1") {
        validator.element("#txtNumero");
        validator.element("#txtCliente");
        validator.element("#txtRepresentante");
        validator.element("#rgTransportador");
        if (!(validator.element("#txtNumero") && validator.element("#txtCliente") && validator.element("#txtRepresentante") && validator.element("#rgTransportador"))) {
          liberado = false;
        }
      }

      if ($(this).attr("id") == "avancarComercial") {
        validator.element("#txtTabelaPreco");
        validator.element("#dtEmissao");
        validator.element("#dtFatura");
        validator.element("#dtEntrega");
        validator.element("#dtSaida");
        if (!(validator.element("#txtTabelaPreco") && validator.element("#dtEmissao") && validator.element("#dtFatura") && validator.element("#dtEntrega") && validator.element("#dtSaida"))) {
          liberado = false;
        }
      }

      if ($(this).attr("id") == "avancarItens") {
        validator.element("#txtDeposito");
        validator.element("#txtStatus");
        if (!(validator.element("#txtDeposito") && validator.element("#txtStatus"))) {
          liberado = false;
        }
      }

      if (liberado) {
        currentFs = $(this).parent();
        nextFs = $(this).parent().next();
        $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");
        nextFs.show();
        currentFs.animate({
          opacity: 0,
        }, {
          step(now) {
            opacity = 1 - now;
            currentFs.css({
              display: "none",
              position: "relative",
            });
            nextFs.css({
              opacity,
            });
          },
          duration: 600,
        });
      }
      $("#tabelaItens").DataTable().columns.adjust().draw(false);
      $("#tabelaCondicao").DataTable().columns.adjust().draw(false);
    });

    $(".previous").click(async function () {
      currentFs = $(this).parent();
      previousFs = $(this).parent().prev();

      $("#progressbar li").eq($("fieldset").index(currentFs)).removeClass("active");

      previousFs.show();

      currentFs.animate({
        opacity: 0,
      }, {
        step(now) {
          opacity = 1 - now;

          currentFs.css({
            display: "none",
            position: "relative",
          });
          previousFs.css({
            opacity,
          });
        },
        duration: 600,
      });
    });
  };

  function adicionaValidacoes() {
    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtNumero: {
          required: true,
        },
        txtCliente: {
          required: true,
        },
        txtRepresentante: {
          required: true,
        },
        rgTransportador: {
          required: true,
        },
        txtTabelaPreco: {
          required: true,
        },
        txtMoeda: {
          required: true,
        },
        dtEmissao: {
          required: true,
        },
        dtFatura: {
          required: true,
        },
        dtEntrega: {
          required: true,
        },
        dtSaida: {
          required: true,
        },
        txtCondPagto1: {
          required: true,
        },
        txtDeposito: {
          required: true,
        },
        txtStatus: {
          required: true,
        }
      },
      messages: {
        txtNumero: {
          required: "Informe um número.",
        },
        txtCliente: {
          required: "Informe um cliente.",
        },
        txtRepresentante: {
          required: "Informe um representante.",
        },
        rgTransportador: {
          required: "Informe um transportador.",
        },
        txtTabelaPreco: {
          required: "Informe uma tabela de preço.",
        },
        txtMoeda: {
          required: "Informe uma moeda.",
        },
        dtEmissao: {
          required: "Informe uma data.",
        },
        dtFatura: {
          required: "Informe uma data.",
        },
        dtEntrega: {
          required: "Informe uma data.",
        },
        dtSaida: {
          required: "Informe uma data.",
        },
        txtCondPagto1: {
          required: "Informe um vencimento.",
        },
        txtDeposito: {
          required: "Informe um depósito.",
        },
        txtStatus: {
          required: "Informe um status.",
        }
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });
  };

  function adicionaMascaraCampos() {
    $('.maskDecimais').maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    $('.maskDecimaisParametro').maskMoney({
      decimal: ".",
      thousands: "",
      precision: quantidadeCasasDecimaisCampo > 2 ? quantidadeCasasDecimaisCampo : 2,
    });

    $('.maskDecimais').on('blur', function () {
      if ($(this).val() == "") {
        $(this).val('0.00');
      }
    });

    $('.maskDecimaisParametro').on('blur', function () {
      if ($(this).val() == '' && quantidadeCasasDecimaisCampo > 2) {
        const zero = 0;
        $(this).val(zero.toFixed(quantidadeCasasDecimaisCampo));
      } else if ($(this).val() == "") {
        $(this).val('0.00');
      }
    });
  };


  function adicionaPesquisaAutocompleta() {
    $('#txtCliente').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`, ['#txtCNPJ'], ['CNPJ'], ['CNPJ']);
    $('#btn-cliente').pesquisa_serverside(['#txtCliente', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, 'Pesquisa Cliente');
    $('#btn-limpa-cliente').on('click', function () { $('#txtCliente').val('') });

    $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE, NOME DESCRICAO"], "where": null}`);
    $('#btn-representante').pesquisa('#txtRepresentante', 'CODREP', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ], "where": null}', 'Pesquisa Representante', 'represen');
    $('#btn-limpa-representante').on('click', function () { $('#txtRepresentante').val('') });

    $('#txtTransportadora').autocompleta(1, `JSON={ "tabela":"TABTRAN", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": null}`);
    $('#btn-transportadora').pesquisa('#txtTransportadora', 'CODIGO', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABTRAN", "camposSelect":[ "CODIGO", "NOME" ], "where": null}', 'Pesquisa Transportadora', 'tabtran');
    $('#btn-limpa-transportadora').on('click', function () { $('#txtTransportadora').val('') });

    $('#txtRedesp').autocompleta(1, `JSON={ "tabela":"TABTRAN", "camposSelect":["CODIGO CHAVE, NOME DESCRICAO"], "where": null}`);
    $('#btn-Redesp').pesquisa('#txtRedesp', 'CODIGO', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABTRAN", "camposSelect":[ "CODIGO", "NOME" ], "where": null}', 'Pesquisa Redesp', 'tabtran');
    $('#btn-limpa-Redesp').on('click', function () { $('#txtRedesp').val('') });

    $('#txtResponsavel').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO, CNPJ"], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"] }`, ['#txtCNPJ'], ['CNPJ'], ['CNPJ']);
    $('#btn-Responsavel').pesquisa_serverside(['#txtResponsavel', '#txtCNPJ'], ['CODCLI', 'CNPJ'], ['NOME', 'CNPJ'], `{"tabela":"entidade", "camposSelect":[ "CODCLI", "NOME", "FANTASIA", "CNPJ" ], "where": ["nome <> 'CONSUMIDOR FINAL' and ativo = 'S'"]}`, 'Pesquisa Responsável');
    $('#btn-limpa-Responsavel').on('click', function () { $('#txtResponsavel').val('') });

    $('#txtPrazoEnt').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-PrazoEnt').pesquisa('#txtPrazoEnt', 'PRAZO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABPRZ", "camposSelect":[ "PRAZO", "DESCRICAO" ], "where": null}', 'Pesquisa Prazo', 'tabprz');
    $('#btn-limpa-PrazoEnt').on('click', function () { $('#txtPrazoEnt').val('') });

    $('#txtPrazoProd').autocompleta(1, `JSON={ "tabela":"TABPRZ", "camposSelect":["PRAZO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-PrazoProd').pesquisa('#txtPrazoProd', 'PRAZO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABPRZ", "camposSelect":[ "PRAZO", "DESCRICAO" ], "where": null}', 'Pesquisa Prazo', 'tabprz');
    $('#btn-limpa-PrazoProd').on('click', function () { $('#txtPrazoProd').val('') });

    $('#txtColecao').autocompleta(1, `JSON={ "tabela":"COLECAO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Colecao').pesquisa('#txtColecao', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Coleção', 'colecao');
    $('#btn-limpa-Colecao').on('click', function () { $('#txtColecao').val('') });

    $('#txtTabelaPreco').autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":["REGIAO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-TabelaPreco').pesquisa('#txtTabelaPreco', 'REGIAO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ], "where": null}', 'Pesquisa Tabela de Preço', 'REGIAO');
    $('#btn-limpa-TabelaPreco').on('click', function () { $('#txtTabelaPreco').val('') });

    $('#txtMoeda').autocompleta(1, `JSON={ "tabela":"MOEDA", "camposSelect":["CODMOE CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Moeda').pesquisa('#txtMoeda', 'CODMOE', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO" ], "where": null}', 'Pesquisa Moeda', 'moeda');
    $('#btn-limpa-Moeda').on('click', function () { $('#txtMoeda').val('') });

    $('#txtCondicao').on('focusout', async function () {
      // geraCondicoes();

      let habilita = pegaChave('#txtCondicao') != '';
      if (habilita) {
        await buscaCondicao(pegaChave('#txtCondicao'));
      };
      $('#txtNrParcelas').prop('disabled', habilita);
      $('#txtNrParcelas').prop('disabled', habilita);
      $('#txtIntervaloDias').prop('disabled', habilita);
      atualizaData();
      // $('#btnAtualizar').trigger('click');
    });

    $('#txtMoeda').on('blur', async function () {
      if (temCondicaoEntidade) {
        temCondicaoEntidade = false;
      } else {
        $('#txtCondicao').val('');
      };
      $('#txtNrParcelas').val('0');
      $('#txtIntervaloDias').val('0');
      await atualizaData();
      $('#txtCondicao').unbind('autocompleta');
      $('#txtCondicao').autocompleta(1, `JSON={ "tabela":"COND_MOEDA", "camposSelect":["CODCOND CHAVE, CODCOND DESCRICAO"], "where": [] }`, [], [], []);
      $('#btn-Condicao').off();
      $('#btn-Condicao').unbind('pesquisa');
      $('#btn-Condicao').pesquisa_array(['#txtCondicao'], ['CODCOND'], ['DESCRICAO'],
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"COND_MOEDA", 
                                    "camposSelect":[ "COND_MOEDA.CODCOND", "CONDICAO.DESCRICAO" ],
                                    "innerjoin": [{ "tabela" : "CONDICAO", "condicao" : "COND_MOEDA.CODCOND = CONDICAO.CODCOND" }], 
                                    "where": ["COND_MOEDA.MOEDA = '${pegaChave('#txtMoeda')}'"]}`, 'Pesquisa Condição', 'COND_MOEDA');
      habilitaCondicoes();
    });

    $('#btn-limpa-Condicao').on('click', function () {
      $('#txtCondicao').val('');
      $('#txtNrParcelas').prop('disabled', false);
      $('#txtIntervaloDias').prop('disabled', false);
    });

    $('#txtClasseGer').autocompleta(1, `JSON={ "tabela":"CLASSE_GER", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-ClasseGer').pesquisa('#txtClasseGer', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CLASSE_GER", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Classe Gerencial', 'CLASSE_GER');
    $('#btn-limpa-ClasseGer').on('click', function () { $('#txtClasseGer').val('') });

    $('#txtHistorico').autocompleta(1, `JSON={ "tabela":"HISTCP", "camposSelect":["HISTORICO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Historico').pesquisa('#txtHistorico', 'HISTORICO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"HISTCP", "camposSelect":[ "HISTORICO", "DESCRICAO" ], "where": null}', 'Pesquisa Histórico', 'HISTCP');
    $('#btn-limpa-Historico').on('click', function () { $('#txtHistorico').val('') });

    $('#txtDeposito').autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Deposito').pesquisa('#txtDeposito', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Depósito', 'DEPOSITO');
    $('#btn-limpa-Deposito').on('click', function () { $('#txtDeposito').val('') });

    $('#txtComprador').autocompleta(1, `JSON={ "tabela":"CONTATO", "camposSelect":["CODCLI CHAVE, NOME DESCRICAO"], "where": null}`);
    $('#btn-Comprador').pesquisa('#txtComprador', 'CODCLI', 'NOME', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CONTATO", "camposSelect":[ "CODCLI", "NOME" ], "where": null}', 'Pesquisa Comprador', 'contato');
    $('#btn-limpa-Comprador').on('click', function () { $('#txtComprador').val('') });

    $('#txtGrupoPed').autocompleta(1, `JSON={ "tabela":"GRUPO_PED", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-GrupoPed').pesquisa('#txtGrupoPed', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"GRUPO_PED", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Grupo Ped', 'GRUPO_PED');
    $('#btn-limpa-GrupoPed').on('click', function () { $('#txtGrupoPed').val('') });

    $('#txtStatus').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Status').pesquisa('#txtStatus', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Status', 'SITPROD');
    $('#btn-limpa-Status').on('click', function () { $('#txtStatus').val('') });

    $('#txtEspecie').autocompleta(1, `JSON={ "tabela":"ESPECIE", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Especie').pesquisa('#txtEspecie', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"ESPECIE", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Espécie', 'ESPECIE');
    $('#btn-limpa-Especie').on('click', function () { $('#txtEspecie').val('') });

    $('#txtOperacao').autocompleta(1, `JSON={ "tabela":"OPER_FISCAL", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Operacao').pesquisa('#txtOperacao', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"OPER_FISCAL", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Operação', 'OPER_FISCAL');
    $('#btn-limpa-Operacao').on('click', function () { $('#txtOperacao').val('') });

    $('#txtProduto').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    // $('#btn-Produto').pesquisa('#txtProduto', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Produto', 'PRODUTO');
    $("#btn-Produto").pesquisa_serverside(["#txtProduto"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "CODIGO2", "DESCRICAO" ]}`, "Pesquisa Produto");
    $('#btn-limpa-Produto').on('click', function () { $('#txtProduto').val('') });

    $('#txtCfop').autocompleta(1, `JSON={ "tabela":"NATUREZA", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Cfop').pesquisa('#txtCfop', 'NATUREZA', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"NATUREZA", "camposSelect":[ "NATUREZA", "DESCRICAO" ], "where": null}', 'Pesquisa Natureza', 'Natureza');
    $('#btn-limpa-Cfop').on('click', function () { $('#txtCfop').val('') });

    $('#txtTpVenda').autocompleta(1, `JSON={ "tabela":"TIPO", "camposSelect":["ID_TIPO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-TpVenda').pesquisa('#txtTpVenda', 'ID_TIPO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TIPO", "camposSelect":[ "ID_TIPO", "DESCRICAO" ], "where": null}', 'Pesquisa Tipo Venda', 'TIPO');
    $('#btn-limpa-TpVenda').on('click', function () { $('#txtTpVenda').val('') });

    $('#txtMaterial').autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Material').pesquisa('#txtMaterial', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO", "UNI_COM" ], "where": null}', 'Pesquisa Material', 'MATERIAL');
    $('#btn-limpa-Material').on('click', function () { $('#txtMaterial').val('') });

    $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Cor').pesquisa('#txtCor', 'COR', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO" ], "where": null}', 'Pesquisa Cor', 'CADCOR');
    $('#btn-limpa-Cor').on('click', function () { $('#txtCor').val('') });
  };

});