$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta.',
          position: 'right'
        }
      },
      {
        element: '#btnIncluir',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de um pedido.',
          position: 'right'
        }
      },
      {
        element: '#btnImprimir',
        popover: {
          title: 'Botão Imprimir',
          description: 'Clique aqui para imprimir os pedidos filtrados.',
          position: 'right'
        }
      },
      {
        element: '#tabelaPedido',
        popover: {
          title: 'Tabela Pedidos',
          description: 'Aqui estão os dados dos pedidos cadastrados.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {

  var ultimaColunaOrdenada = {
    nome: '',
    ordenacao: 'ASC'
  };

  const permissaoUsuarioLogado = await permissaoAcessos("PEDIDO");
  const paramVen54 = await CopiaParametro('VENDA', 54);
  await VinculaCaixaComUsuario();
  await setarDataAnoAnterior('txtDataEmiDe');
  await carregaValoresPadroes();
  let sEmpID = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
    : [getCookie('emp_id')];

  addFuncoesBotoes();
  preencheOrdenacaoTela('RelPedidoA');
  await buscaDados();

  $("#txtCaixa").val(sessionStorage.getItem('g_caixa_logado'));

  $('#txtValor').maskMoney({
    decimal: '.',
    thousands: '',
    precision: 2
  });

  async function buscaDados(colunaOrdenacao = '') {
    ultimaColunaOrdenada.nome = colunaOrdenacao.replaceAll(' ASC', '').replaceAll(' DESC', '');
    ultimaColunaOrdenada.ordenacao = colunaOrdenacao.indexOf(' ASC') > -1 ? 'ASC' : 'DESC';

    $('#modal-filtros').modal('hide');

    const orderBy = colunaOrdenacao == '' ? '[]' : `["${colunaOrdenacao}"]`;
    try {
      $.LoadingOverlay("show");
      let where = '';
      where = pegaChave('#txtListaPedidos') != '' ? ` AND PEDIDO.NUMERO IN (${$('#txtListaPedidos').val()})` : '';
      where += pegaChave('#txtClienteConsulta') != '' ? ` AND PEDIDO.CODCLI = '${pegaChave('#txtClienteConsulta')}'` : '';
      where += pegaChave('#txtRepresentanteConsulta') != '' ? ` AND PEDIDO.CODREP = '${pegaChave('#txtRepresentanteConsulta')}'` : '';
      where += pegaChave('#txtTabPrecoConsulta') != '' ? ` AND PEDIDO.TAB_PRE = '${pegaChave('#txtTabPrecoConsulta')}'` : '';
      where += pegaChave('#txtColecaoConsulta') != '' ? ` AND PEDIDO.COLECAO = '${pegaChave('#txtColecaoConsulta')}'` : '';
      where += pegaChave('#txtStatusConsulta') != '' ? ` AND PEDIDO.STATUS = '${pegaChave('#txtStatusConsulta')}'` : '';
      where += pegaChave('#txtGrupoPedConsulta') != '' ? ` AND PEDIDO.GRUPO = '${pegaChave('#txtGrupoPedConsulta')}'` : '';
      where += pegaChave('#txtGrupoProdConsulta') != '' ? ` AND PRODUTO.GRUPO = '${pegaChave('#txtGrupoProdConsulta')}'` : '';
      where += pegaChave('#txtTipoProdConsulta') != '' ? ` AND PRODUTO.TIPO = '${pegaChave('#txtTipoProdConsulta')}'` : '';
      where += pegaChave('#txtBloqComConsulta') != '' ? ` AND PEDIDO.BLOQUEIO = '${pegaChave('#txtBloqComConsulta')}'` : '';
      where += pegaChave('#txtBloqFinConsulta') != '' ? ` AND PEDIDO.FINANCEIRO = '${pegaChave('#txtBloqFinConsulta')}'` : '';
      where += pegaChave('#txtSituacaoConsulta') == 'P' ? ` AND PED_ITEN.QTDE > 0` :
        pegaChave('#txtSituacaoConsulta') == 'F' ? ` AND PED_ITEN.QTDE_F > 0` : ``;
      where += ` AND PEDIDO.EMP_ID IN (${sEmpID})`

      if ($("#txtDataEmiDe").val() != "01-01-1200" || $$("#txtDataEmiAte").val() != "01-12-2500") {
        where += ` and PEDIDO.DT_EMISSAO >= '${$("#txtDataEmiDe").val()}' and PEDIDO.DT_EMISSAO <= '${$("#txtDataEmiAte").val()}'`;
      }
      if ($("#txtDataEntregaDe").val() != "01-01-1200" || $$("#txtDataEntregaAte").val() != "01-12-2500") {
        where += ` and PEDIDO.ENTREGA >= '${$("#txtDataEntregaDe").val()}' and PEDIDO.ENTREGA <= '${$("#txtDataEntregaAte").val()}'`;
      }
      if ($("#txtDataFaturaDe").val() != "01-01-1200" || $$("#txtDataFaturaAte").val() != "01-12-2500") {
        where += ` and PEDIDO.DT_FATURA >= '${$("#txtDataFaturaDe").val()}' and PEDIDO.DT_FATURA <= '${$("#txtDataFaturaAte").val()}'`;
      }
      if ($("#txtDataSaidaDe").val() != "01-01-1200" || $$("#txtDataSaidaAte").val() != "01-12-2500") {
        where += ` and PEDIDO.DT_SAIDA >= '${$("#txtDataSaidaDe").val()}' and PEDIDO.DT_SAIDA <= '${$("#txtDataSaidaAte").val()}'`;
      }

      $("#tabelaPedido").DataTable({
        destroy: true,
        lengthChange: false,
        serverSide: true,
        processing: true,
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "GET",
          headers: { Authorization: BASIC_AUTH },
          data: {
            EMPRESA: getCookie("empresa"),
            JSON: `{ "tabela":"PEDIDO", "camposSelect":["PEDIDO.NUMERO AS Pedido", "ENTIDADE.NOME AS Cliente", "REPRESEN.NOME AS Representante", "TABTRAN.NOME AS Transportadora", "PEDIDO.DT_EMISSAO AS Data_Emissao", "PEDIDO.ENTREGA AS Data_Entrega", "PEDIDO.PED_CLI AS Ped_Cliente"], 
                      "leftjoin": [{"tabela" : "ENTIDADE", "condicao" : "PEDIDO.CODCLI = ENTIDADE.CODCLI"},
                                   {"tabela" : "PED_ITEN", "condicao" : "PED_ITEN.NUMERO = PEDIDO.NUMERO"},
                                   {"tabela" : "PRODUTO", "condicao"  : "PRODUTO.CODIGO = PED_ITEN.CODIGO"},
                                   {"tabela" : "REPRESEN", "condicao" : "PEDIDO.CODREP = REPRESEN.CODREP" },
                                   {"tabela" : "TABTRAN", "condicao"  : "PEDIDO.TAB_TRANS = TABTRAN.CODIGO"}], 
                                   "where": ["1=1 ${where}"], 
                                   "groupby": ["PEDIDO.NUMERO", "ENTIDADE.NOME", "REPRESEN.NOME", "TABTRAN.NOME", "PEDIDO.DT_EMISSAO", "PEDIDO.ENTREGA", "PEDIDO.PED_CLI"], 
                                   "orderby": ${orderBy}}`,
            CLIENTE: "S",
          },
        },
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        columnDefs: [
          {
            render(row) {
              return retornaBotaoOpcoes(row);
            },
            targets: [0],
          },
        ],
      });

      $.LoadingOverlay("hide");
      $('#tabelaPedido th').unbind('click');
      $('#tabelaPedido th').on('click', async function () {
        const nomeColuna = $(this).html();
        const novaOrdenacao = ultimaColunaOrdenada.ordenacao == 'ASC' ? 'DESC' : 'ASC';
        const ordenacao = ultimaColunaOrdenada.nome == nomeColuna ? novaOrdenacao : 'ASC';
        await buscaDados(nomeColuna + ' ' + ordenacao);
      });
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }

  };

  $('#txtPedidoConsulta').on('blur', function () {
    let pedido = $('#txtPedidoConsulta').val();
    if (pedido.includes("[")) {
      pedido = pegaChave($('#txtPedidoConsulta'));
    } else {
      pedido = $('#txtPedidoConsulta').val();
    }
    pedido = pedido.replace('\w', '');
    const listaPedidos = $('#txtListaPedidos').val();
    if (pedido == '') {
      return;
    }
    $('#txtListaPedidos').val((listaPedidos == '') ? `'${pedido}'` : `${listaPedidos},'${pedido}'`);
    $('#txtPedidoConsulta').val('');
    $('#txtPedidoConsulta').focus();
  });

  $('#txtPedidoConsulta').on('keydown', async function (event) {
    if (event.key == 'Enter') {
      $('#txtPedidoConsulta').trigger('blur');
      $('#txtPedidoConsulta').focus();
    }
  });

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "pedido/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#tabelaPedido').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaPedido').DataTable().row($(this).parents('tr')).data();
      window.location.href = `pedido/${btoa(data[0])}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaPedido').on('click', '#btn-imprimirItem', async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaPedido').DataTable().row($(this).parents('tr')).data();
      const url = `/sisplan/impressao/v1/acesso_pedido?`;

      const filtros = retornaFiltros(`'${data[0]}'`);
      const ordem = `&TELA_ORDENACAO=RelPedidoA&ORDEM_ORDENACAO=${$('#txtOrdemImpressao').val()}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelPedidoA');
      let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}&`, 'GET', 1000000, false, 'RelPedidoA');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#tabelaPedido').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      const data = $('#tabelaPedido').DataTable().row($(this)).data();
      window.location.href = `pedido/${btoa(data[0])}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaPedido').on('click', '#btnAntecipacao', async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaPedido').DataTable().row($(this).parents('tr')).data();

      const pesquisaParam = {
        tabela: 'PEDIDO',
        camposSelect: ['PEDIDO.CODCLI', 'PEDIDO.CLASSE_GER', 'CLASSE_GER.DESCRICAO DESC_CLASSE', 'PEDIDO.CODREP', 'REPRESEN.NOME NOME_REPRESEN',
          'PEDIDO.NUMERO', 'ENTIDADE.NOME', `(SELECT SUM(QTDE * PRECO) FROM [PED_ITEN] WHERE NUMERO = '${data[0]}') VALOR_TOTAL`],
        leftJoin: [
          { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = PEDIDO.CODCLI' },
          { tabela: 'CLASSE_GER', condicao: 'CLASSE_GER.CODIGO = PEDIDO.CLASSE_GER' },
          { tabela: 'REPRESEN', condicao: 'REPRESEN.CODREP = PEDIDO.CODREP' },
        ],
        where: [`PEDIDO.NUMERO = '${data[0]}'`]
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      $('#txtDTvencimento').val('');
      insereValor('#txtPedidoAnte', jsonStr[0].NUMERO);
      insereValor('#txtClienteAnte', jsonStr[0].CODCLI, jsonStr[0].NOME);
      insereValor('#txtRepresenAnte', jsonStr[0].CODREP, jsonStr[0].NOME_REPRESEN);
      insereValor('#txtClasseGer', jsonStr[0].CLASSE_GER, jsonStr[0].DESC_CLASSE);
      insereValor('#txtValor', ArredondarValor(jsonStr[0].VALOR_TOTAL, 2));
      setarDataAtual('txtDTemissao');
      $('#txtDTemissao').prop('disabled', true);
      $('#txtDTemissao').prop('readonly', true);
    } finally {
      $.LoadingOverlay('hide');
      $('#modalAntecipacao').modal('show');
    }
  });

  $('#txtDTvencimento').on('blur', function () {
    const dtVencto = $('#txtDTvencimento').val();
    const dtEmissao = $('#txtDTemissao').val();

    if (dtVencto == '') {
      return;
    }

    if (new Date(dtVencto) < new Date(dtEmissao)) {
      msgAlerta('Data de vencimento menor que a data de emissão, favor verificar.');
      $('#txtDTvencimento').val('');
      return;
    }
  });

  $('#txtMoeda').on('blur', async function () {
    if (pegaValor('#txtMoeda') == '') {
      return;
    }

    const moeda = pegaChave('#txtMoeda');

    const pesquisaParam = {
      tabela: 'MOEDA',
      camposSelect: ['MOEDA.HISTORICO', 'HISTCP.DESCRICAO', 'MOEDA.TIPO'],
      leftJoin: [{ tabela: 'HISTCP', condicao: 'MOEDA.HISTORICO = HISTCP.HISTORICO' },],
      where: [`MOEDA.CODMOE = '${moeda}'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    $('#cartao').addClass('d-none');
    $('#cbNaoLancaCc').prop('checked', false);
    $('#labelNaoLancaCc').addClass('d-none');
    $('#cbNaoLancaCc').addClass('d-none');
    if (jsonStr[0].TIPO == '3') {
      $('#labelNaoLancaCc').removeClass('d-none');
      $('#cbNaoLancaCc').removeClass('d-none');
      $('#cartao').removeClass('d-none');
      await addBandeira();
    }

    insereValor('#txtHistorico', jsonStr[0].HISTORICO, jsonStr[0].DESCRICAO);
  });

  $('#txtConta').on('blur', async function () {
    if (pegaValor('#txtConta') == '') {
      return;
    }

    const conta = pegaChave('#txtConta');

    const pesquisaParam = {
      tabela: 'CADCONTA',
      camposSelect: ['CADCONTA.BANCO', 'CADBAN.NOME_BANCO'],
      leftJoin: [{ tabela: 'CADBAN', condicao: 'CADCONTA.BANCO = CADBAN.BANCO' },],
      where: [`CADCONTA.CONTA = '${conta}'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    insereValor('#txtBanco', jsonStr[0].BANCO, jsonStr[0].NOME_BANCO);
  });

  $('#tabelaPedido').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaPedido").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
      msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }
  });

  $('#btnImprimir').on('click', async function () {
    msgAlerta('Tem certeza que deseja imprimir os pedidos listados?', () => { imprimirPedidos(); })
  });

  async function imprimirPedidos() {
    try {
      $.LoadingOverlay('show');
      try {
        let url = `/sisplan/impressao/v1/acesso_pedido?`;

        const filtros = retornaFiltros();
        const ordem = `&TELA_ORDENACAO=acesso_pedido&ORDEM_ORDENACAO=1`;
        const bImprimeAutomatico = await verificaImprimirAutomatico('RelPedidoA');
        let arquivo = await GeraRelatorio(`${url}${filtros}${ordem}`, 'GET', 1000000, false, 'RelPedidoA');
        if (arquivo != undefined) {
          if (!bImprimeAutomatico) {
            window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
          }
          await limparRelatorios();
        }

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  $('#btnConfirmarAnte').on('click', async function gravaReceber() {
    if ((pegaValor('#txtMoeda') == '') || (pegaValor('#txtHistorico') == '') || (pegaValor('#txtClasseGer') == '') || (pegaValor('#txtSituacao') == '') || (pegaValor('#txtConta') == '') ||
      (pegaValor('#txtBanco') == '') || (pegaValor('#txtDTemissao') == '') || (pegaValor('#txtDTvencimento') == '') || (pegaValor('#txtCaixa') == '') || (pegaValor('#txtValor') == '')) {
      msgAlerta('Necessário preencher todos os campos para gravar a antecipação, favor verificar.')
      return;
    }

    $.LoadingOverlay('show');
    try {
      const receberClass = {
        VALOR: parseFloat(pegaValor('#txtValor')),
        VALOR2: parseFloat(pegaValor('#txtValor')),
        DT_EMISSAO: `${$('#txtDTemissao').val()}T00:00:00Z`,
        DT_VENCTO: `${$('#txtDTvencimento').val()}T00:00:00Z`,
        STATUS: 'ANTE',
        OBS: `Antecipação do pedido ${pegaValor('#txtPedidoAnte')}.`,
        CODREP: pegaChave('#txtRepresenAnte'),
        CODCLI: pegaChave('#txtClienteAnte'),
        SITUACAO: pegaChave('#txtSituacao'),
        CLASSE: pegaChave('#txtClasseGer'),
        BANCO: pegaChave('#txtBanco'),
        NRCAIXA: pegaChave('#txtCaixa'),
        MOEDA: pegaChave('#txtMoeda'),
        HISTORICO: pegaChave('#txtHistorico'),
        CONTA_CH: pegaChave('#txtConta'),
        CONTA_CHEQUE: pegaChave('#txtConta'),
        PEDIDO: pegaValor('#txtPedidoAnte'),
        GERACAIXALOJA: false, //necessário fazer a negação, pois foi alterado o backend dia 06/03/23 pendencia 239227, para não duplicar o caixa quando for lançamento de cheque que gere antecipação
        NAO_LANCA_CC: isChecked('#cbNaoLancaCc')
      };

      let response = await requisicao('POST', '/Sisplan/receber/V1/Receber?', '', `JSON=${encodeURIComponent(JSON.stringify(receberClass))}`);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();

      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      const lancamento = jsonStr.lancamento;
      const numero = jsonStr.numero;
      if (pegaValor('#txtStatus') != '') {
        await alteraStatus(pegaChave('#txtStatus'), receberClass.PEDIDO);
      }

      const tipo = await buscaValor('MOEDA', 'TIPO', 'CODMOE', pegaChave('#txtMoeda'));

      if (tipo.TIPO == '3') {
        let sCodCli = await retornaOperadora(pegaChave('#txtMoeda'));
        let novoPrazo = new Date();
        let arrayVencimentos;
        if (pegaChave('#txtCondicaoDePagamento') != '') {
          arrayVencimentos = await RetornaVencimentos(pegaChave('#txtCondicaoDePagamento'));
        }
        if (typeof arrayVencimentos == "undefined") {
          arrayVencimentos = [];
          arrayVencimentos.push(formataData(novoPrazo));
        }
        const valorTotal = parseFloat($('#txtValor').val());
        const nr_parcelas = pegaChave('#txtNrParcelas');
        const moeda = await buscaValor('MOEDA', 'BANCO, BAIXA, HISTORICO, CODSIT', 'CODMOE', pegaChave('#txtMoeda'));
        const conta = await RetornaConta(pegaChave('#txtMoeda'));

        let valorParcela = parseFloat(parseFloat(valorTotal / nr_parcelas).toFixed(2));
        let guardaValor = valorParcela;
        let diferenca = 0;
        if (valorTotal > valorParcela * nr_parcelas || valorTotal < valorParcela * nr_parcelas) {
          diferenca = parseFloat(parseFloat(valorTotal - valorParcela * nr_parcelas).toFixed(2));
        }

        for (let i = 0; i < nr_parcelas; i++) {
          if (diferenca > 0 && i == 0) {
            valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
            diferenca = 0;
          } else {
            valorParcela = guardaValor;
          }
          if (diferenca < 0 && i == nr_parcelas - 1) {
            valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
          }
          const receberClass = {
            VALOR: valorParcela,
            VALOR2: valorParcela,
            DT_EMISSAO: formataData(novoPrazo),
            DT_VENCTO: arrayVencimentos[i],
            STATUS: 'DUPL',
            OBS: `Duplicata gerada pela antecipação ${numero} paga com cartão`,
            CODREP: pegaChave('#txtRepresenAnte'),
            CODCLI: sCodCli,
            SITUACAO: pegaChave('#txtSituacao'),
            CLASSE: pegaChave('#txtClasseGer'),
            BANCO: moeda.BANCO,
            NRCAIXA: pegaChave('#txtCaixa'),
            MOEDA: pegaChave('#txtMoeda'),
            CONTA_CH: conta,
            CARTAO_NSU: $('#txtNSU').val(),
            BANDEIRA: $('#select_bandeira').val(),
            LANCAMENTO: lancamento,
            PARCELA: i + 1,
            TAXACARTAO: true,
            CONDICAO: pegaChave('#txtCondicaoDePagamento'),
            QTDEPARCELAS: pegaChave('#txtNrParcelas'),
            HISTORICO: moeda.HISTORICO,
            SITUACAO: moeda.CODSIT
          };

          response = await requisicao('POST', '/Sisplan/receber/V1/Receber?', '', `JSON=${encodeURIComponent(JSON.stringify(receberClass))}`);

          if (!response) {
            return;
          }

          let jsonStr = await response.json();

          if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
          }

          const numeroB = jsonStr.numero;
          const taxaBandeira = jsonStr.taxa_bandeira;

          if (moeda.BAIXA == '1') {
            const receberBClass = await pegaValoresBaixa(numeroB, taxaBandeira, valorParcela, sCodCli);

            response = await requisicao('POST', '/Sisplan/receber/V1/BaixaReceber?', '', `JSON=${encodeURIComponent(JSON.stringify(receberBClass[0]))}`);

            if (!response) {
              return;
            }

            let jsonStr = await response.json();

            if (response.status != 200) {
              msgErro(jsonStr.RESULT[0].mensagem);
              return;
            }
          }
        }
      }

      criaMensagemSucesso('Antecipação gravada com sucesso.', () => { window.location.reload() });
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  async function alteraStatus(pStatus, pPedido) {
    try {
      const response = await requisicao('GET', '/sisplan/pedido/v1/alterastatus?', `PEDIDO=${pPedido}&STATUS=${pStatus}`);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        return;
      }
    } catch (error) {
      console.error(error);
    }
  }

  function retornaFiltros(sNumero = '') {
    const numero = $('#txtListaPedidos').val();
    const codcli = pegaChave('#txtClienteConsulta');
    const codrep = pegaChave('#txtRepresentanteConsulta');
    const tab_pre = pegaChave('#txtTabPrecoConsulta');
    const colecao = pegaChave('#txtColecaoConsulta');
    const grupo_ped = pegaChave('#txtGrupoPedConsulta');
    const grupo_prod = pegaChave('#txtGrupoProdConsulta');
    const tipo = pegaChave('#txtTipoProdConsulta');
    const bloqueio = pegaChave('#txtBloqComConsulta');
    const financeiro = pegaChave('#txtBloqFinConsulta');
    const emissaoDe = $("#txtDataEmiDe").val();
    const emissaoAte = $("#txtDataEmiAte").val();
    const entregaDe = $("#txtDataEntregaDe").val();
    const entregaAte = $("#txtDataEntregaAte").val();
    const faturaDe = $("#txtDataFaturaDe").val();
    const faturaAte = $("#txtDataFaturaAte").val();
    const saidaDe = $("#txtDataSaidaDe").val();
    const saidaAte = $("#txtDataSaidaAte").val();
    const status = pegaChave('#txtStatusConsulta');
    const situacao = pegaChave('#txtSituacaoConsulta');

    const filtros = `NUMERO=${sNumero == '' ? numero : sNumero}` +
      `&CODCLI=${codcli}` +
      `&CODREP=${codrep}` +
      `&TAB_PRE=${tab_pre}` +
      `&COLECAO=${colecao}` +
      `&PEDIDOGRUPO=${grupo_ped}` +
      `&PRODUTOGRUPO=${grupo_prod}` +
      `&TIPO=${tipo}` +
      `&BLOQUEIO=${bloqueio}` +
      `&FINANCEIRO=${financeiro}` +
      `&EMISSAODE=${emissaoDe}` +
      `&EMISSAOATE=${emissaoAte}` +
      `&ENTREGADE=${entregaDe}` +
      `&ENTREGAATE=${entregaAte}` +
      `&FATURADE=${faturaDe}` +
      `&FATURAATE=${faturaAte}` +
      `&SAIDADE=${saidaDe}` +
      `&SAIDAATE=${saidaAte}` +
      `&STATUS=${status}` +
      `&EMP_ID=${sEmpID}` +
      `&SITUACAO=${situacao}`;

    return filtros;
  };



  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        const valorLinha = data.data();
        const response = await requisicao('DELETE', '/sisplan/pedido/v1/pedido?', `NUMERO=${encodeURIComponent(valorLinha[0])}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          const jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        criaMensagemSucesso('Exclusão efetuada com sucesso!', () => { window.location.reload() });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  };

  async function VinculaCaixaComUsuario() {
    const _url = '/sisplan/funcoes/v1/pesquisa?';
    const nomeUsuario = getCookie('cod_usuario') == '0000' ? 'SISPLAN' : getCookie('usuario');
    const _usuarioCaixa =
      `JSON={"tabela": "VENDA_CAIXA", 
      "camposSelect": ["VENDA_CAIXA.NRCAIXA", "VENDA_CAIXA.USUARIO", "CAIXA_LOJA.DESCRICAO", "VENDA_CAIXA.DEPOSITO", "DEPOSITO.DESCRICAO AS DESC_DEPOSITO", "VENDA_CAIXA.REGIAO", "REGIAO.DESCRICAO AS DESC_REGIAO"], 
      "where": ["VENDA_CAIXA.USUARIO = '${nomeUsuario}'"],
      "innerjoin": [{"tabela" : "CAIXA_LOJA", "condicao" : "CAIXA_LOJA.CODIGO = VENDA_CAIXA.NRCAIXA"}],
      "leftjoin": [{"tabela" : "DEPOSITO", "condicao" : "DEPOSITO.CODIGO = VENDA_CAIXA.DEPOSITO"},
                   {"tabela" : "REGIAO", "condicao" : "REGIAO.REGIAO = VENDA_CAIXA.REGIAO"}]}`;
    try {
      const response = await requisicao('GET', _url, _usuarioCaixa, null);
      if (!response) {
        msgErro('Erro ao buscar caixas vinculados ao usuário.');
        return;
      }

      if (response.status == 200) {
        var jsonStr = await response.json();
        if (jsonStr['RESULT'][0].length >= 1) {

          if (paramVen54 == '2') { //consultar apenas os caixas vinculados ao usuário
            $('#btn-caixa').pesquisa(
              '#txtCaixa',
              'CODIGO',
              'DESCRICAO',
              `/sisplan/funcoes/v1/pesquisa?JSON={ 
                "tabela":"caixa_loja", 
                "camposSelect":[ "caixa_loja.codigo", "caixa_loja.descricao"], 
                "leftjoin":[{"tabela" : "venda_caixa", "condicao" : "venda_caixa.nrcaixa = caixa_loja.codigo"}],
                "where": ["VENDA_CAIXA.USUARIO = '${nomeUsuario}'", "VENDA_CAIXA.EMP_ID = ${getCookie('emp_id')}"]
              }`,
              'Pesquisa Caixa',
              'caixa_loja'
            );

            $('#txtCaixa').autocompleta(
              2,
              `JSON={ 
                "tabela":"caixa_loja", 
                "camposSelect":[ "caixa_loja.codigo CHAVE", "caixa_loja.descricao"],
                "leftjoin":[{"tabela" : "venda_caixa", "condicao" : "venda_caixa.nrcaixa = caixa_loja.codigo"}], 
                "where": ["VENDA_CAIXA.USUARIO = '${nomeUsuario}'", "VENDA_CAIXA.EMP_ID = ${getCookie('emp_id')}"]
              }`
            );
          }

        }
      } else {
        return;
      }
    } catch (error) {
      console.error(error);
      return;
    }
  }

  async function carregaValoresPadroes() {
    const pesquisa = {
      camposSelect: ['CAMPO', 'VALOR'],
      tabela: 'TABPADRAO',
      where: [`TABELA = 'PEDIDO'`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    jsonStr.map(item => {
      switch (item.CAMPO) {
        case 'STATUS_ANTECIPACAO': {
          insereValor('#txtStatus', item.VALOR, 'VALOR PADRÃO');
          break;
        }
      }
    });
  };

  function addFuncoesBotoes() {
    $('#btn-limpa-PedidoConsulta').on('click', function () {
      $('#txtListaPedidos').val('');
    });

    $("#btn-PedidoConsulta").pesquisa_serverside(["#txtPedidoConsulta"], ["NUMERO"], ["CODCLI"], `{"tabela":"PEDIDO", "camposSelect":[ "NUMERO", "CODCLI", "PED_CLI" ], "where":["EMP_ID IN (${sEmpID})"]}`, "Pesquisa Pedido");

    $("#txtClienteConsulta").autocompleta(2, `JSON={ "tabela":"ENTIDADE", "camposSelect":["ENTIDADE.CODCLI CHAVE, ENTIDADE.NOME DESCRICAO"]}`);
    $("#btn-ClienteConsulta").pesquisa_serverside(["#txtClienteConsulta"], ["CODCLI"], ["NOME"], `{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME" ]}`, "Pesquisa Cliente");
    $('#btn-limpa-ClienteConsulta').on('click', function () { $('#txtClienteConsulta').val(''); });

    $('#txtCondicaoDePagamento').autocompleta(1, `JSON={ "tabela":"condicao", "camposSelect":[ "codcond CHAVE", "descricao", "nrpar"], "where": null}`, ['#txtNrParcelas'], ['NRPAR'], ['NRPAR']);
    $('#btn-CondicaoDePagamento').pesquisa_array(['#txtCondicaoDePagamento', '#txtNrParcelas'], ['CODCOND', 'NRPAR'], ['DESCRICAO', 'NRPAR'], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"condicao", "camposSelect":[ "codcond", "descricao", "nrpar"], "where": null}', 'Pesquisa Condição de Pagamento', 'condicao');
    $('#btn-limpa-condicao').on('click', function () {
      $('#txtCondicaoDePagamento').val('');
      $('#txtNrParcelas').val('1');
    });

    $("#txtRepresentanteConsulta").autocompleta(2, `JSON={ "tabela":"REPRESEN", "camposSelect":["REPRESEN.CODREP CHAVE, REPRESEN.NOME DESCRICAO"]}`);
    $("#btn-RepresentanteConsulta").pesquisa_serverside(["#txtRepresentanteConsulta"], ["CODREP"], ["NOME"], `{"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME" ]}`, "Pesquisa Representante");
    $('#btn-limpa-RepresentanteConsulta').on('click', function () { $('#txtRepresentanteConsulta').val(''); });

    $("#txtTabPrecoConsulta").autocompleta(2, `JSON={ "tabela":"REGIAO", "camposSelect":["REGIAO.REGIAO CHAVE, REGIAO.DESCRICAO"]}`);
    $("#btn-TabPrecoConsulta").pesquisa_serverside(["#txtTabPrecoConsulta"], ["REGIAO"], ["DESCRICAO"], `{"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO" ]}`, "Pesquisa Tabela de Preço");
    $('#btn-limpa-TabPrecoConsulta').on('click', function () { $('#txtTabPrecoConsulta').val(''); });

    $("#txtColecaoConsulta").autocompleta(2, `JSON={ "tabela":"COLECAO", "camposSelect":["COLECAO.CODIGO CHAVE, COLECAO.DESCRICAO"]}`);
    $("#btn-ColecaoConsulta").pesquisa_serverside(["#txtColecaoConsulta"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Coleção");
    $('#btn-limpa-ColecaoConsulta').on('click', function () { $('#txtColecaoConsulta').val(''); });

    $("#txtGrupoPedConsulta").autocompleta(2, `JSON={ "tabela":"GRUPO_PED", "camposSelect":["GRUPO_PED.CODIGO CHAVE, GRUPO_PED.DESCRICAO"]}`);
    $("#btn-GrupoPedConsulta").pesquisa_serverside(["#txtGrupoPedConsulta"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"GRUPO_PED", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Grupo Pedido");
    $('#btn-limpa-GrupoPedConsulta').on('click', function () { $('#txtGrupoPedConsulta').val(''); });

    $("#txtGrupoProdConsulta").autocompleta(2, `JSON={ "tabela":"GRUPO_PA", "camposSelect":["GRUPO_PA.CODIGO CHAVE, GRUPO_PA.DESCRICAO"]}`);
    $("#btn-GrupoProdConsulta").pesquisa_serverside(["#txtGrupoProdConsulta"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Grupo Produto");
    $('#btn-limpa-GrupoProdConsulta').on('click', function () { $('#txtGrupoProdConsulta').val(''); });

    $("#txtTipoProdConsulta").autocompleta(2, `JSON={ "tabela":"CAD_TIPO_PROD", "camposSelect":["CAD_TIPO_PROD.CODIGO CHAVE, CAD_TIPO_PROD.DESCRICAO"]}`);
    $("#btn-TipoProdConsulta").pesquisa_serverside(["#txtTipoProdConsulta"], ["CODIGO"], ["DESCRICAO"], `{"tabela":"CAD_TIPO_PROD", "camposSelect":[ "CODIGO", "DESCRICAO" ]}`, "Pesquisa Tipo Produto");
    $('#btn-limpa-TipoProdConsulta').on('click', function () { $('#txtTipoProdConsulta').val(''); });

    $("#txtMoeda").autocompleta(1, `JSON={ "tabela":"moeda", "camposSelect":["codmoe CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Moeda").pesquisa("#txtMoeda", "CODMOE", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": null}', "Pesquisa Moeda", "moeda");
    $("#btn-limpa-Moeda").on("click", function () { $("#txtMoeda").val(""); });

    $("#txtHistorico").autocompleta(1, `JSON={ "tabela":"histcp", "camposSelect":["HISTORICO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Historico").pesquisa("#txtHistorico", "HISTORICO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"histcp", "camposSelect":[ "historico", "descricao" ], "where": null}', "Pesquisa Histórico", "histcp");
    $("#btn-limpa-Historico").on("click", function () { $("#txtHistorico").val(""); });

    $("#txtClasseGer").autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-ClasseGer").pesquisa("#txtClasseGer", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Classe Gerencial", "classe_ger");
    $("#btn-limpa-ClasseGer").on("click", function () { $("#txtClasseGer").val(""); });

    $("#txtSituacao").autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Situacao").pesquisa("#txtSituacao", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Situação", "tabsit");
    $("#btn-limpa-Situacao").on("click", function () { $("#txtSituacao").val(""); });

    $("#txtBanco").autocompleta(1, `JSON={ "tabela":"cadban", "camposSelect":["BANCO CHAVE, NOME_BANCO DESCRICAO"], "where": [] }`);
    $("#btn-Banco").pesquisa("#txtBanco", "BANCO", "NOME_BANCO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco" ], "where": null}', "Pesquisa Banco", "cadban");
    $("#btn-limpa-Banco").on("click", function () { $("#txtBanco").val(""); });

    $("#txtConta").autocompleta(1, `JSON={ "tabela":"cadconta", "camposSelect":["CONTA CHAVE, DESCRICAO"], "where": [] }`);
    $("#btn-Conta").pesquisa("#txtConta", "CONTA", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadconta", "camposSelect":[ "CONTA", "DESCRICAO" ], "where": null}', "Pesquisa Conta", "cadconta");
    $("#btn-limpa-Conta").on("click", function () { $("#txtConta").val(""); });

    $('#txtStatus').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-Status').pesquisa('#txtStatus', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Status', 'SITPROD');
    $('#btn-limpa-Status').on('click', function () { $('#txtStatus').val('') });

    $('#txtStatusConsulta').autocompleta(1, `JSON={ "tabela":"SITPROD", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": null}`);
    $('#btn-StatusConsulta').pesquisa('#txtStatusConsulta', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"SITPROD", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Status', 'SITPROD');
    $('#btn-limpa-StatusConsulta').on('click', function () { $('#txtStatusConsulta').val('') });

    if (paramVen54 != '2') {
      $('#btn-caixa').pesquisa('#txtCaixa', 'CODIGO', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo", "descricao"], "where": null}', 'Pesquisa Caixa', 'caixa_loja');
      $('#txtCaixa').autocompleta(2, `JSON={ "tabela":"caixa_loja", "camposSelect":[ "codigo CHAVE", "descricao"], "where": null}`);
    }
    $("#btn-limpa-caixa2").on("click", function () { $("#txtCaixa").val(""); });

    $('#btnFiltros').on('click', function () {
      $('#modal-filtros').modal('show');
    });

    $('#btnLimparFiltros').on('click', async function () {
      $('#txtPedidoConsulta').val('');
      $('#txtListaPedidos').val('');
      $('#txtClienteConsulta').val('');
      $('#txtRepresentanteConsulta').val('');
      $('#txtTabPrecoConsulta').val('');
      $('#txtColecaoConsulta').val('');
      $('#txtGrupoPedConsulta').val('');
      $('#txtGrupoProdConsulta').val('');
      $('#txtTipoProdConsulta').val('');
      $("#txtDataEmiDe").val("1200-01-01");
      $("#txtDataEntregaDe").val("1200-01-01");
      $("#txtDataFaturaDe").val("1200-01-01");
      $("#txtDataSaidaDe").val("1200-01-01");
      $("#txtDataEmiAte").val("2500-12-01");
      $("#txtDataEntregaAte").val("2500-12-01");
      $("#txtDataFaturaAte").val("2500-12-01");
      $("#txtDataSaidaAte").val("2500-12-01");
      $('#txtBloqFinConsulta').val('');
      $('#txtBloqComConsulta').val('');
      $('#txtSituacaoConsulta').val('');
      $('#txtStatusConsulta').val('');
    });

    $('#txtSituacao').on('focusout', async function () {
      const contaCor = await buscaValor('TABSIT', 'GERA_CONTACOR', 'CODIGO', pegaChave(this));
      $('#cbNaoLancaCc').prop('checked', contaCor.GERA_CONTACOR == 'S');
    });
  };

  $("#tabelaPedido").on('click', "#btnAnexos", async function () {
    const data = $('#tabelaPedido').DataTable().row($(this).parents('tr')).data();

    await abreModalAnexos(data[0], data[1], 'PEDIDO');
  });

  function retornaBotaoOpcoes(pedido) {
    var retorno = '<div style="text-align:center;"> ' +
      '   <div class="dropdown" style="position: initial"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + pedido + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button id="btn-editar" type="button" class="dropdown-item">Alterar</button>' +
      '    <button id="btn-imprimirItem" type="button" class="dropdown-item">Imprimir</button>' +
      '    <button id="btn-excluir" type="button" class="dropdown-item">Excluir</button>' +
      '    <button id="btnAnexos" type="button" class="dropdown-item">Anexos</button>' +
      '    <button id="btnAntecipacao" type="button" class="dropdown-item">Antecipação</button>';
    retorno += '</div>' +
      '  </div>' +
      '</div>';
    return retorno;
  }

  $('#btnSelecionarEmpresas').on('click', function () {
    carregaEmpresasDisponiveis();
  });


  $('#modal-empresas').on('hide.bs.modal', function () {
    sEmpID = $('.empresa_selecionada:checked').toArray().length > 0 ? $('.empresa_selecionada:checked').toArray().map(input => input.id.substring(input.id.indexOf('-') + 1, input.id.length))
      : [getCookie('emp_id')];
    $("#btn-PedidoConsulta").pesquisa_serverside(["#txtPedidoConsulta"], ["NUMERO"], ["CODCLI"], `{"tabela":"PEDIDO", "camposSelect":[ "NUMERO", "CODCLI" ], "where":["EMP_ID IN (${sEmpID})"]}`, "Pesquisa Pedido");
  });

  async function addBandeira() {
    $("#select_bandeira").empty();
    const dados = await RetornaBandeiras();
    for (const bandeira of dados) {
      const optionText = bandeira.DESCRICAO;
      const optionValue = bandeira.DESCRICAO;
      $('#select_bandeira').append(`<option value="${optionValue}">
                                                 ${optionText}
                                              </option>`);

    }
  }

  async function retornaOperadora(moeda) {
    const url = `/sisplan/funcoes/v1/pesquisa?`;
    let retorno = pegaChave('#txtClienteAnte');
    try {
      let response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"MOEDA", "camposSelect":[ "USA_ADM_CARTAO", "CODCLI"], "where": ["CODMOE = ${moeda}"] }`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }
      if ((jsonStr.RESULT[0][0].CODCLI != '') && (jsonStr.RESULT[0][0].USA_ADM_CARTAO = 'S')) {
        retorno = jsonStr.RESULT[0][0].CODCLI;
      }
      return retorno;
      // alert(jsonStr['RESULT'][0]);
      // return jsonStr;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados dos vencimentos.");
    }
  }

  async function RetornaVencimentos(iCodCondicao) {
    let url = `/sisplan/funcoes/v1/pesquisa?`;
    let arrVencimentos = [];
    try {
      let response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"cond_item", "camposSelect":[ "parcela", "prazo"], "where": ["codcond = ${iCodCondicao}"] }`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      let nrParcelas = jsonStr.RESULT[0].length;
      let dataAtual = new Date();
      for (let index = 0; index < nrParcelas; index++) {
        let novoPrazo = new Date();
        let nrDia = jsonStr.RESULT[0][index].PRAZO;
        novoPrazo.setDate(dataAtual.getDate() + nrDia);
        arrVencimentos.push(formataData(novoPrazo));
      }
      if (typeof arrVencimentos == "undefined") {
        let novoPrazo = new Date();
        arrVencimentos.push(formataData(novoPrazo));
      }

      return arrVencimentos;
      // alert(jsonStr['RESULT'][0]);
      // return jsonStr;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados dos vencimentos.");
    }
  }

  async function RetornaConta(moeda) {
    const url = `/sisplan/funcoes/v1/pesquisa?`;
    try {
      let response = await requisicao(
        "GET",
        url,
        `JSON={ "tabela":"MOEDA_CONTA", "camposSelect":[ "CONTA"], "where": ["MOEDA = ${moeda} AND EMPRESA = ${getCookie('empresa').substring(1, 4)}"] }`,
        null
      );

      if (!response) {
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      return jsonStr.RESULT[0][0].CONTA;
      // alert(jsonStr['RESULT'][0]);
      // return jsonStr;
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível buscar os dados dos vencimentos.");
    }
  }

  async function RetornaBandeiras() {
    const _url = `/Sisplan/Funcoes/v1/pesquisa?`;
    const _params = `JSON={ "tabela":"bandeira", "camposSelect":["id_bandeira", "descricao"], "where": ["ativo = 'S'"], "orderby": ["ordem","descricao"]}`;

    try {
      const response = await requisicao('GET', _url, _params, null);

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr['RESULT'][0].mensagem)
        return;
      }
      return jsonStr['RESULT'][0];
    } catch (error) {
      console.error(error);
      msgErro('Não foi possível buscar as bandeiras de cartões');
    }
  }

  async function pegaValoresBaixa(numeroB, taxaBandeira, valorParcela, sCodCli) {
    try {
      let valores = [];
      let objeto = {};

      objeto = {
        VALOR_PAGO: valorParcela - parseFloat(((valorParcela * taxaBandeira) / 100).toFixed(2)),
        DESCONTO: 0,
        JUROS: 0,
        CODCLI: sCodCli,
        CODREP: pegaChave('#txtRepresenAnte'),
        DT_EMISSAO: new Date().toISOString().slice(0, 10),
        DT_VENCTO: new Date().toISOString().slice(0, 10),
        EMP_ID: getCookie('emp_id'),
        DESP_COBRANCA: parseFloat(((valorParcela * taxaBandeira) / 100).toFixed(2)),
        NUMERO: numeroB,
        VALOR: valorParcela,
        VALOR2: valorParcela,
        DT_PAGTO: new Date().toISOString().slice(0, 10),
        DT_CONT: new Date().toISOString().slice(0, 10),
        MOEDA: pegaChave("#txtMoeda"),
        NSU: $("#txtNSU").val(),
        BANDEIRA: $('#select_bandeira').val()
      };

      valores.push(objeto);
      objeto = {};

      return valores;
    } catch (error) {
      console.error(error);
      msgErro("Erro ao pegar os dados da baixa");
    }
  }

  $('#btnConsultar').on('click', async function () {
    await buscaDados();
  });

});