$("#tutorial").on("click", function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: "Sair",
            closeBtnText: "Fechar",
            nextBtnText: "Próximo",
            prevBtnText: "Anterior",
            allowClose: false,
        });
        driver.defineSteps([

        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    const queryString = window.location.href;
    const parametros = queryString.split('/');
    const data = parametros[parametros.length - 1];

    let bAlteracao = false;
    let objTela = {};

    $("#txtTela").on("change", function () {
        $.LoadingOverlay("show");
        try {
            retornaInfosTela();
            montaDivOpcoes();
            
            

        } finally {
            $.LoadingOverlay("hide");
        }
    })

    $("#btnGravar").on("click", async function () {
        $("#btnGravar").prop("disabled", true);
        $.LoadingOverlay("show");
        try {
            await gravarMensagem();
        } finally {
            $("#btnGravar").prop("disabled", false);
            $.LoadingOverlay("hide");
        }
    })

    $("#btnVoltar").on("click", function () {
        window.location.href = `${BASE_URI}/msg_whatsapp`;
    })

    $("#btnTestar").on("click", async function () {
        $.LoadingOverlay("show");
        try {
            if (bAlteracao) {
                throw msgAlerta("Alterações foram feitas na mensagem ou no SQL, necessário gravar para realizar a ação!");
            }

            await testarMensagem();
        } finally {
            $.LoadingOverlay("hide");
        } 
    })

    $("#btnConfirmarValores").on("click", async function () {
        const tela = $("#txtTela").val().toString();
        const parametrosMensagem = [];
        $(".divValor").toArray().forEach(elemento => {
            const campo = $(elemento).find("label").html();
            const val = pegaChave($(elemento).find("input"));
            if (val == "") {
                throw msgAlerta(`Necessário informar um valor para o campo ${campo}.`);
            }
            parametrosMensagem.push(`${campo}: ${val}`);
        });
        const objMsgWpp = [{CELULAR: 'teste', PARAMETROSMENSAGEM: parametrosMensagem.toString(), MENSAGEMPERSONALIZADA: ""}];
        let mensagem = await retornaMsgPersonalizadaWpp(tela, objMsgWpp, false);
        mensagem = decodeEmoticonsMensagem(mensagem, true);
        if (mensagem != "") {
            msgAlerta(mensagem);
        }
    })

    $("#btnExemplo").on("click", function () {
        montaExemplo();
    })

    $("#txtMensagem").on("change", function () {
        bAlteracao = true;
    })

    $("#txtSQL").on("change", function () {
        bAlteracao = true;
    })

    async function iniciaTela() {

        $('#txtTela').select2({
            placeholder: "Selecione ou digite uma nova opção",
            tags: true,
            allowClear: true,
            language: {
                maximumSelected: function (limit) {
                    return "Você pode selecionar apenas uma tela";
                },
                noResults: function () {
                    return ''
                }
            },
            maximumSelectionLength: 1,

        });

        if (data != "create") {
            $('#txtID').val(data);
            const dados = await buscaDados(data);
            if (dados.length > 0) {
                preencheCampos(dados[0]);
                return;
            }
        }

        $("#txtTela").val("VENDA");
        $("#txtTela").trigger("change");

    }

    async function gravarMensagem() {
        const id = $('#txtID').val() == ''? await RetornaProximo("ID", "MSGWHATSAPPWEB", "ID", 2) : $('#txtID').val();
        const tela = $("#txtTela").val().toString();
        let mensagem = $("#txtMensagem").val();
        const SQL = $("#txtSQL").val();

        if (tela == "") {
            throw msgAlerta("Necessário informar a tela para prosseguir!");
        }

        if (mensagem == "") {
            throw msgAlerta("Necessário informar uma mensagem para prosseguir!");
        }

        mensagem = encodeEmoticonsMensagem(mensagem);

        const response = await requisicao("POST", "/sisplan/config_whatsapp/v1/salvarmensagem?", "", `ID=${id}&TELA=${tela}&MENSAGEM=${encodeURIComponent(mensagem)}&SQL=${encodeURIComponent(SQL)}`, 120000);

        if (!response) {
            throw msgAlerta("Não foi possível cadastrar a mensagem, verifique!");
        }

        if (response.status != 200) {
            throw msgAlerta("Não foi possível cadastrar a mensagem, verifique!");
        }

        criaMensagemSucesso("Mensagem cadastrada com sucesso", () => { window.location.href = `${BASE_URI}/msg_whatsapp` });

    }

    async function buscaDados(id) {
        const pesquisa = {
            tabela: "MSGWHATSAPPWEB",
            camposSelect: ["TELA", "MENSAGEM", "SQL"],
            where: [`ID = ${id}`]
        }

        const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

        return jsonStr;

    }

    function preencheCampos(dados) {
        $("#txtTela").val(dados.TELA);
        $("#txtTela").trigger("change");
        dados.MENSAGEM = dados.MENSAGEM.replaceAll('&#013;', '\r\n');
        dados.MENSAGEM = decodeEmoticonsMensagem(dados.MENSAGEM);
        $("#txtMensagem").val(dados.MENSAGEM);
        $("#txtSQL").val(dados.SQL.replaceAll('&#013;', '\r\n'));
    }

    async function testarMensagem() {
        const id = $("#txtID").val();
        const tela = $("#txtTela").val().toString();
        let mensagem = $("#txtMensagem").val();
        const sql = $("#txtSQL").val();
        
        if (id == "") {
            throw msgAlerta("Não é possível testar com uma configuração nova, grave as alterações para prosseguir!");
        }

        if (tela == "") {
            throw msgAlerta("Necessário informar uma tela para prosseguir!");
        }

        if (mensagem == "") {
            throw msgAlerta("Necessário informar uma mensagem para prosseguir!");
        }

        if (sql != "") {
            montaModalValores();
            $("#modalValores").modal("show");
        } else {
            msgAlerta(mensagem);
        }
    }

    function montaModalValores() {
        let html = ""
        objTela.camposChave.forEach((campo, index) => {
            html += `<div class="divValor">
                        <label data-error="wrong" class="labelGeral" data-success="right" for="txtValor${campo}">${campo}</label>
                        <div class="input-group">
                            <input type="text" class="input-default focus form-control" aria-describedby="ufError" id="txtValor${campo}" name="txtValor${campo}" class="form-control" placeholder="${campo}">
                            <div class="input-group-append">
                                 <button class="btn bg-danger" id="btnValor${campo}" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                                 <button class="btn bg-danger" id="btnLimpaValor${campo}" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                             </div>
                        </div>
                    </div>`
        });
        $("#bodyModalValores").html(html);

        objTela.autocompleta.forEach(autocompleta => {
            eval(autocompleta);
        })
        objTela.pesquisa.forEach(pesquisa => {
            eval(pesquisa);
        })
        objTela.limpaCampo.forEach(limpaCampo => {
            eval(limpaCampo);
        })
    }

    function retornaInfosTela() {
        switch ($("#txtTela").val().toString()) {
            case "VENDA":
                objTela.camposChave = ["VENDA", "EMP_ID"];
                objTela.autocompleta = ['$("#txtValorVENDA").autocompleta(1, `JSON={ "tabela":"VENDA", "camposSelect":[ "VENDA.CODVEN CHAVE", "ENTIDADE.NOME DESCRICAO"], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = VENDA.CODCLI"}]}`);', 
                                        '$("#txtValorEMP_ID").autocompleta(1, `JSON={ "tabela":"EMPRESA", "camposSelect":[ "EMP_ID chave", "EMP_NOME descricao"]}`);'];
                objTela.pesquisa = ['$("#btnValorVENDA").pesquisa("#txtValorVENDA", "CODVEN", "CLIENTE", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VENDA", "camposSelect":[ "VENDA.CODVEN", "ENTIDADE.NOME CLIENTE"], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = VENDA.CODCLI"}]}`, "Pesquisa Venda", "VENDA");',
                                    '$("#btnValorEMP_ID").pesquisa("#txtValorEMP_ID", "EMP_ID", "EMP_NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"empresa", "camposSelect":[ "EMP_ID", "EMP_NOME"]}`, "Pesquisa Empresa", "empresa");'];
                objTela.limpaCampo =  ['$("#btnLimpaValorVENDA").on("click", function () { $("#txtValorVENDA").val(""); });',
                                       '$("#btnLimpaValorEMP_ID").on("click", function () { $("#txtValorEMP_ID").val(""); })'];
                break;
            case "DEVOLUCAO":
                objTela.camposChave = ["VENDA", "EMP_ID"];
                objTela.autocompleta = ['$("#txtValorVENDA").autocompleta(1, `JSON={ "tabela":"VENDA", "camposSelect":[ "VENDA.CODVEN CHAVE", "ENTIDADE.NOME DESCRICAO"], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = VENDA.CODCLI"}]}`);', 
                                        '$("#txtValorEMP_ID").autocompleta(1, `JSON={ "tabela":"EMPRESA", "camposSelect":[ "EMP_ID chave", "EMP_NOME descricao"]}`);'];
                objTela.pesquisa = ['$("#btnValorVENDA").pesquisa("#txtValorVENDA", "CODVEN", "CLIENTE", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VENDA", "camposSelect":[ "VENDA.CODVEN", "ENTIDADE.NOME CLIENTE"], "leftjoin":[{"tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = VENDA.CODCLI"}]}`, "Pesquisa Venda", "VENDA");',
                                    '$("#btnValorEMP_ID").pesquisa("#txtValorEMP_ID", "EMP_ID", "EMP_NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"empresa", "camposSelect":[ "EMP_ID", "EMP_NOME"]}`, "Pesquisa Empresa", "empresa");'];
                objTela.limpaCampo =  ['$("#btnLimpaValorVENDA").on("click", function () { $("#txtValorVENDA").val(""); });',
                                       '$("#btnLimpaValorEMP_ID").on("click", function () { $("#txtValorEMP_ID").val(""); })'];
                break;
            case "RELANIVERSARIO":
                objTela.camposChave = ["CODCLI", "EMP_ID"];
                objTela.autocompleta = ['$("#txtValorCODCLI").autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"]}`);', 
                                        '$("#txtValorEMP_ID").autocompleta(1, `JSON={ "tabela":"EMPRESA", "camposSelect":[ "EMP_ID chave", "EMP_NOME descricao"]}`);'];
                objTela.pesquisa = ['$("#btnValorCODCLI").pesquisa("#txtValorCODCLI", "CODCLI", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}`, "Pesquisa Cliente", "ENTIDADE");',
                                    '$("#btnValorEMP_ID").pesquisa("#txtValorEMP_ID", "EMP_ID", "EMP_NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"EMPRESA", "camposSelect":[ "EMP_ID", "EMP_NOME"]}`, "Pesquisa Empresa", "EMPRESA");'];
                objTela.limpaCampo =  ['$("#btnLimpaValorCODCLI").on("click", function () { $("#txtValorCODCLI").val(""); });',
                                       '$("#btnLimpaValorEMP_ID").on("click", function () { $("#txtValorEMP_ID").val(""); })'];
                break;

        }
    }

    function montaDivOpcoes() {
        let html = "Opções disponíveis para se utilizar no SQL:<br>";
        objTela.camposChave.forEach(campo => {
            html += `   :${campo}   ->   Irá substituir o campo ":${campo}" dentro do SQL, pelo(a) ${campo} em questão. <br>`
        })
        $("#divOpcoes").html(html);
    }

    function montaExemplo() {
        $("#txtTela").val("VENDA");
        $("#txtMensagem").val("Olá #NOME_CLIENTE#! Obrigado por comprar na nossa loja, sua compra no valor de R$#VALOR#, na condição de pagamento #DESC_MOEDA# foi finalizada com sucesso.");
        $("#txtSQL").val(`SELECT
        ENTIDADE.NOME AS NOME_CLIENTE, 
        VENDA.VALOR AS VALOR,
        MOEDA.DESCRICAO AS DESC_MOEDA 
        FROM [VENDA] VENDA
        LEFT JOIN [ENTIDADE] ENTIDADE ON ENTIDADE.CODCLI = VENDA.CODCLI
        LEFT JOIN [CONDIVENDA] CONDIVENDA ON CONDIVENDA.CDVENDA = VENDA.CODVEN
        LEFT JOIN [MOEDA] MOEDA ON MOEDA.CODMOE = CONDIVENDA.CDMOEDA
        WHERE VENDA.CODVEN = :VENDA`);
        msgAlerta("Atenção, o exemplo montado é específico para a tela de VENDA!");
    }


    await iniciaTela();

});
