$("#tutorial").on("click", function () {
    $(document).ready(async function () {
      const driver = new Driver({
        doneBtnText: "Sair",
        closeBtnText: "Fechar",
        nextBtnText: "Próximo",
        prevBtnText: "Anterior",
        allowClose: false,
      });
      driver.defineSteps([]);
      driver.start();
    });
  });
  
  $(document).ready(async function () {
    const permissaoUsuarioLogado = await permissaoAcessos("MSG_WHATSAPP");
  
    function retornaBotaoOpcoes(data) {
      var retorno = '<div style="text-align:start;"> ' +
        '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
        '      ' + data + ' ' +
        '    </button> ' +
        '    <div class="dropdown-menu"> ' +
        '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
        '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
        '</div>';
      return retorno;
    };
  
  
    $("#btnNovaMensagem").on("click", async function () {
      if (permissaoUsuarioLogado.INCLUI == "S") {
        window.location.href = "msg_whatsapp/create";
      } else {
        msgAlertaSemConfirmacao("Sem permissão para incluir!");
      }
    });
  
    async function buscarDados() {
      try {
        $.LoadingOverlay("show");
  
        const objetoPesquisa = {
          tabela: "MSGWHATSAPPWEB",
          camposSelect: ["ID", "MENSAGEM", "TELA"],
          where: [`1=1`],
          orderBy: ["ID"]
        };
  
        const response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON=${JSON.stringify(objetoPesquisa)}`,
          null
        );
        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }
  
        const jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgAlerta(jsonStr.RESULT[0].mensagem);
          return;
        }
  
        $("#tabelaCadastros").DataTable({
          destroy: true,
          lengthChange: false,
          order: false,
          search: false,
          language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            oPaginate: {
              sNext: "Próximo",
              sPrevious: "Anterior",
              sFirst: "Primeiro",
              sLast: "Último",
            },
            oAria: {
              sSortAscending: ": Ordenar colunas de forma ascendente",
              sSortDescending: ": Ordenar colunas de forma descendente",
            },
          },
  
          autoWidth: true,
          data: jsonStr.RESULT[0],
          columns: [
            {
              data: "ID",
            },
            {
              data: "TELA",
            },
            {
              data: "MENSAGEM",
            }
          ],
          columnDefs: [
            {
              targets: [0], render: function (data) {
                return retornaBotaoOpcoes(data);
              }
            },
            {
              targets: [2], render: function (data) {
                return decodeEmoticonsMensagem(data);
              }
            }
          ],
        });
  
        $("#tabelaCadastros").on("click", "#btn-editar", async function () {
          if (permissaoUsuarioLogado.ALTERA == "S") {
            const data = $("#tabelaCadastros").DataTable().row($(this).parents("tr")).data();
            const id = data.ID;
            window.location.href = `msg_whatsapp/${id}`;
          } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
          }
        });
  
        $("#tabelaCadastros").on("dblclick", "tr", async function () {
          if (permissaoUsuarioLogado.ALTERA == "S") {
            const data = $("#tabelaCadastros").DataTable().row($(this)).data();
            const id = data.ID;
            window.location.href = `msg_whatsapp/${id}`;
          } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
          }
        });
  
        $("#tabelaCadastros").on("click", "#btn-excluir", async function () {
          if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta("Você realmente deseja excluir esse registro?", async () => {
              const data = $("#tabelaCadastros").DataTable().row($(this).parents("tr")).data();
              await excluiRegistro(data.ID);
            }
            );
          } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
          }
        });
  
        $.LoadingOverlay("hide");
      } catch (error) {
        console.error(error);
        $.LoadingOverlay("hide");
      }
    }
  
    await buscarDados();
    async function excluiRegistro(id) {
      try {
        $.LoadingOverlay("show");
        try {
          let response = await requisicao(
            "DELETE",
            "/sisplan/config_whatsapp/v1/deletarmensagem?",
            `ID=${id}`,
            ''
          );
          if (!response) {
            return;
          }
          if (response.status != 200) {
            let jsonStr = await response.json();
            msgErro(jsonStr.mensagem);
            return;
          }
  
          toastr
            .success("Exclusão efetuada com sucesso!", "Confirmação", {
              toastClass: "success",
              iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              onHidden() {
                window.location.reload();
              },
            })
            .css({
              "margin-top": "20%",
              width: "500px",
              "max-width": "500px",
            });
        } catch (error) {
          console.error(error);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }
  });
  