/* eslint-disable no-unused-vars */
/* eslint-disable prefer-destructuring */
/* eslint-disable no-param-reassign */

let parametrosVenda = [];
let listaBarrasBipadas = [];
let listaBarrasBipadasEPC = [];
let listaBarrasForamBipadasEPC = [];
let listaLogsVenda = [];
let codven_devolucao = '';

$(`[name="selectFiltros"][value="${localStorage.getItem("@venda.selectFiltros") ?? '1'}"]`).click();

$('[name="selectFiltros"]').on('change', function () {
  const valorSelecionado = $(this).val();
  localStorage.setItem("@venda.selectFiltros", valorSelecionado);
});

$(`[name="rgPesquisaTipo"][value="${localStorage.getItem("@venda.rgPesquisaTipo") ?? '1'}"]`).click();

$('[name="rgPesquisaTipo"]').on('change', function () {
  const valorSelecionado = $(this).val();
  localStorage.setItem("@venda.rgPesquisaTipo", valorSelecionado);
});

$("#btn-reconectar").on("click", async function () {
  try {
    $.LoadingOverlay("show");
    await conectaECF(ipInterno, ipExterno, basicAuth);
    await buscaStatusImpressora();
  } finally {
    $.LoadingOverlay("hide");
  }
});

function formataNumerico(valor) {
  return parseFloat(valor.replace(",", "."));
}

async function BuscaEstadoEmpresa() {
  const url = "/sisplan/menufiscal/v1/menufiscal?";
  const response = await requisicao("GET", url, "", null, 15000);

  if (!response) {
    return;
  }

  const jsonStr = await response.text();
  if (response.status != 200) {
    msgErro("Erro ao buscar as informações");
    return;
  }
  return jsonStr;
}

async function controlaECF() {
  const bUsaECF = parametrosVenda[8];
  const bUsaNFCE = parametrosVenda[6];
  const estado = await BuscaEstadoEmpresa();

  if (bUsaECF == "1" || (estado == "SC" && bUsaNFCE == 1)) {
    if (await maquinaTemImpressora()) {
      await habilitaPanelImpressora(true);
      await buscaStatusImpressora();
      window.setInterval(async function () {
        await buscaStatusImpressora();
      }, 15000);
      window.setInterval(async function () {
        if (
          $("#txtStatusECF").html() == " Offline " ||
          $("#txtEstadoECF").html() == "Desconectado"
        ) {
          conectaECF(ipInterno, ipExterno, basicAuth);
        }
      }, 60000);
    }
  } else {
    await habilitaPanelImpressora(false);
  }
}

async function habilitaPanelImpressora(bHabilita) {
  if (bHabilita) {
    $("#panel_ecf").removeClass("d-none");
    $("#menu_fiscal").removeClass("d-none");
    $("#menu_fiscal").removeClass("d-md-none");
    $("#menu_fiscal").addClass("d-md-block");
  } else {
    $("#panel_ecf").addClass("d-none");
    $("#menu_fiscal").addClass("d-none");
    $("#menu_fiscal").removeClass("d-md-block");
    $("#menu_fiscal").addClass("d-md-none");
  }
}

// async function SalvarRetornoCupom(jsonRetornoCupom) {
//     var url = `SalvarRetornoCupom?`;

//     try {
//         var response = await requisicao_ecf('POST', url, `JSON=${encodeURIComponent(JSON.stringify(jsonRetornoCupom))}`, null);
//         if (!response) {
//             return false;
//         }

//         var jsonStr = await response.json();
//         if (response.status != 200) {
//             return false;
//         } else {
//             return true;
//         }
//     } catch (error) {
//         return false;
//     }
// }

async function RetornaCondicaoImprimeCupomGerencial(venda) {
  try {
    const empId = getCookie("emp_id");
    const params = {
      tabela: "MOEDA",
      camposSelect: ["IMP_GERENCIAL"],
      where: [
        `CODMOE IN (SELECT DISTINCT CDMOEDA FROM [CONDIVENDA] WHERE CDVENDA = ${venda} AND EMP_ID = ${empId}) AND IMP_GERENCIAL = 'S'`,
      ],
    };

    const response = await retornaJsonPesquisaPadrao(JSON.stringify(params));

    if (!response) {
      return false;
    }

    return response.length > 0;
  } catch (error) {
    console.error(error);
    return false;
  }
}

async function ImprimirCupomGerencial(venda, cupom) {
  const url = `/cupom/imprimircupomgerencial?`;
  let sRelParam = "";
  const bTemCupomGerencial = parametrosVenda[11];
  const bCondicaoImprimeCupomGerencial =
    await RetornaCondicaoImprimeCupomGerencial(venda);

  if (
    bTemCupomGerencial == "0" ||
    bTemCupomGerencial == "" ||
    !bCondicaoImprimeCupomGerencial
  ) {
    return;
  }
  if (bTemCupomGerencial == "1") {
    sRelParam = "RECEBIMENTO";
  } else if (bTemCupomGerencial == "2") {
    sRelParam = "ITENS";
  } else {
    sRelParam = "COMPLETO";
  }
  const params = `NRCUPOM=${cupom}&NRVENDA=${venda}&TIPO_REL_GERENCIAL=${sRelParam}`;

  try {
    let response = await requisicao_ecf("GET", url, params, "", 30000);

    if (!response) {
      return;
    }

    // pegar dados pra update
    if (response.status != 200) {
      msgErro("Erro ao imprimir cupom gerencial.");
      return;
    }
    return;
  } catch (error) {
    console.error(error);
    msgErro("Erro ao imprimir cupom gerencial.");
  }
}

async function ImprimirCupomTroca(venda, tipo, lista) {
  const url = `/cupom/imprimircupomtroca?`;
  const params = `NRCUPOM=1&NRVENDA=${venda}&LISTA=${lista}&TIPO=${tipo}`;

  try {
    let response = await requisicao_ecf("POST", url, params, "", 30000);

    if (!response) {
      msgErro("Erro ao imprimir cupom de troca.");
      return;
    }

    // pegar dados pra update
    if (response.status != 200) {
      msgErro("Erro ao imprimir cupom de troca.");
      return;
    }
    return;
  } catch (error) {
    console.error(error);
    msgErro("Erro ao imprimir cupom de troca.");
  }
}

async function ImprimirCupomFiscal(jsonVenda, objeto) {
  let url = `/cupom/imprimircupom?`;
  let objetoParametro = objeto;
  try {
    const response = await requisicao_ecf("POST", url, "", jsonVenda, 3000000);

    if (!response) {
      return false;
    }

    if (response.status != 200) {
      return false;
    }
    const jsonStr = await response.json();
    objetoParametro.nrCupom = jsonStr.nrCupom;
    objetoParametro.erroCupom = jsonStr.erroCupom;
    const bRetorno = jsonStr;
    if (jsonStr.erroCupom == true) {
      setCookie("erro_impressao_cupom", jsonStr.mensagemErro);
      return false;
    }
    return bRetorno;
  } catch (error) {
    console.error(error);
    const numero_venda = $('#txtCodVen').val();
    await rotinaGeraLog('TVENDALOJA', numero_venda, `Erro ao imprimir cupom fiscal - ${numero_venda}`, 'Inclusão');
    return false;
  }
}

async function AtualizarCupom(jsonObject) {
  try {
    const url = '/sisplan/cupom/v1/atualizarcupom?';
    const params = `JSON=${encodeURIComponent(JSON.stringify(jsonObject))}`;
    const response = await requisicao("POST", url, params, null);
    if (!response) {
      msgErro("erro ao atualizar cupom");
      return;
    }

    if (response.status != 200) {
      msgErro("erro ao atualizar cupom");
      return;
    }
  }
  catch (err) {
    console.error('erro ao atualizar cupom', err);
  }
}

async function AtualizarDadosTef(jsonObject) {
  try {
    const url = '/sisplan/vendas/v1/atualizardadostef?';
    const params = `JSON=${encodeURIComponent(JSON.stringify(jsonObject))}`;
    const response = await requisicao("POST", url, '', params, 120000);
    if (!response) {
      msgErro("Erro ao atualizar os dados TEF");
      return;
    }

    if (response.status != 200) {
      msgErro("Erro ao atualizar os dados TEF");
      return;
    }
  }
  catch (err) {
    console.error('Erro ao atualizar os dados TEF', err);
  }
}

async function FinalizarCupomFiscal(jsonVenda, jsonCupom) {
  const url = `/cupom/finalizarcupom?`;

  try {
    const response = await requisicao_ecf("POST", url, "", jsonVenda, 3000000);

    if (!response) {
      return false;
    }

    // pegar dados pra update
    if (response.status != 200) {
      return false;
    }
    const jsonStr = await response.json();
    if (jsonStr.erroCupom == false) {
      await AtualizarCupom(jsonStr);
      return true;
    }
    setCookie("erro_impressao_cupom", jsonStr.mensagemErro);
    return false;
  } catch (error) {
    console.error(error);
    return false;
  }
}

async function realizaLeituraX() {
  const url = `/cupom/leiturax?`;

  msgAlerta(`Tem certeza que deseja efetuar a Leitura X?`, async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const response = await requisicao_ecf("POST", url, "", "", null);

        if (!response) {
          return;
        }

        // let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro("Não foi possível emitir a Leitura X, tente novamente.");
          return;
        }
      } catch (error) {
        console.error(error);
        msgErro("Não foi possível emitir a Leitura X, tente novamente.");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });
}

async function ParametrosConfiguracao() {
  const url = `/cupom/parametrosconfiguracao?`;

  try {
    $.LoadingOverlay("show");
    try {
      const response = await requisicao_ecf("GET", url, "", "", 40000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro(
          "Não foi possível emitir os Parametros de Configuração ECF, tente novamente."
        );
        return;
      }
    } catch (error) {
      console.error(error);
      msgErro(
        "Não foi possível emitir os Parametros de Configuração, tente novamente."
      );
    }
  } finally {
    $.LoadingOverlay("hide");
  }
}

async function registroPAF() {
  // 127.0.0.1:211/RegistroVendas?ano=2021&mes=02&cnpjs=&empresa=_001.
  const url = `/sisplan/cupom/v1/RegistroPAF?`;
  const sDataInicial = moment($("#txtVendasDataDe").val()).format("DD/MM/YYYY");
  const sDataFinal = moment($("#txtVendasDataAte").val()).format("DD/MM/YYYY");

  const totalPRODs = $("#tabela_prods").DataTable().rows().count();
  lista = "";
  for (let index = 0; index < totalPRODs; index++) {
    const codigo = $("#tabela_prods").DataTable().row(index).data()[0];
    lista += lista == "" ? `${codigo}` : `','${codigo}`;
  }
  const sProds = `'${lista}'`; // pegar do datatable;
  const params = `data_inicial=${sDataInicial}&data_final=${sDataFinal}&produtos=${sProds}`;

  try {
    $.LoadingOverlay("show");
    try {
      const response = await requisicao("GET", url, params, "", 40000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro("Não foi possível emitir o RegistroPAF ECF, tente novamente.");
        return;
      }

      const jsonStr = await response.json();
      msgSucesso(
        `Arquivo gerado com sucesso, caminho: ${jsonStr.RESULT[0].mensagem}`
      );
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível emitir o RegistroPAF ECF, tente novamente.");
    }
  } finally {
    $("#modal-reg").modal("hide");
    $.LoadingOverlay("hide");
  }
}

async function registroVendas() {
  // 127.0.0.1:211/RegistroVendas?ano=2021&mes=02&cnpjs=&empresa=_001.
  const url = `/cupom/registrovendas?`;
  const sAno = $("#txtVendasAno").val();
  const sMes = $("#txtVendasMes").val();

  const totalCNPJs = $("#tabela_cnpjs").DataTable().rows().count();
  lista = "";
  for (let i = 0; i < totalCNPJs; i++) {
    const cnpj = $("#tabela_cnpjs").DataTable().row(i).data()[0];
    lista += lista == "" ? `${cnpj}` : `','${cnpj}`;
  }
  const sCNPJ = `'${lista}'`; // pegar do datatable;
  const params = `ano=${sAno}&mes=${sMes}&cnpjs=${sCNPJ}`;

  try {
    $.LoadingOverlay("show");
    try {
      let response = await requisicao_ecf("GET", url, params, "", 40000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro(
          "Não foi possível emitir a identificaPAF ECF, tente novamente."
        );
        return;
      }
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível emitir a identificaPAF ECF, tente novamente.");
    }
  } finally {
    $("#modal-vendas").modal("hide");
    $.LoadingOverlay("hide");
  }
}

$("#btn_confirmar_identificacao").on("click", async function () {
  $("#modal-identificao").modal("hide");
});

$("#btn_confirmar_mesaAberta").on("click", async function () {
  $("#modal-mesaAberta").modal("hide");
});

async function MesasAbertas() {
  $("#modal-mesaAberta").modal("show");
}

async function identificaPAF() {

  const parametroVenda8 = (parametrosVenda[8]) == 0;

  if (parametroVenda8) {
    $("#modal-identificao").modal("show");
  } else {
    const url = `/cupom/identificapaf?`;

    try {
      $.LoadingOverlay("show");
      try {
        const response = await requisicao_ecf("GET", url, "", "", 40000);

        if (!response) {
          return;
        }

        if (response.status != 200) {
          msgErro(
            "Não foi possível emitir a identificaPAF ECF, tente novamente."
          );
          return;
        }
      } catch (error) {
        console.error(error);
        msgErro(
          "Não foi possível emitir a identificaPAF ECF, tente novamente."
        );
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
}

async function abreVendas() {
  $("#modal-vendas").modal("show");
}

$("#btn_confirmar_lmf").on("click", async function () {
  if ($("#modalLMF-titulo").html().indexOf("17/04") > 0) {
    await confirmaEspelho();
  } else {
    await confirmaLMF();
  }
});

$("#btn_confirmar_reg").on("click", async function () {
  if ($("#txtVendasDataDe").val() == "" || $("#txtVendasDataAte").val() == "") {
    msgErro("Informe as datas para continuar.");
    return;
  }
  registroPAF();
});

$('input[name="rgTipo"]').on("click", function () {
  $("#txtDataLMFDe").prop("disabled", $(this).val() == "1");
  $("#txtDataLMFAte").prop("disabled", $(this).val() == "1");
  $("#txtIntDe").prop("disabled", $(this).val() == "0");
  $("#txtIntAte").prop("disabled", $(this).val() == "0");
});

async function confirmaEspelho() {
  sTipoEmissao = $('input[name="rgTipoEmissao"]:checked').val();
  sTipo = $('input[name="rgTipo"]:checked').val();
  sDtIni = moment($("#txtDataLMFDe").val()).format("DD/MM/YYYY");
  sDtFim = moment($("#txtDataLMFAte").val()).format("DD/MM/YYYY");
  sIntIni = $("#txtIntDe").val();
  sIntFim = $("#txtIntAte").val();

  if (sTipo == "0" && (sDtIni == "" || sDtFim == "")) {
    msgErro("Necessário filtrar as datas.");
    return;
  }
  if (sTipo == "1" && (sIntIni == "" || sIntFim == "")) {
    msgErro("Necessário filtrar os intervalos.");
    return;
  }

  const url = `/cupom/espelho?`;
  const params = `DATA_INICIAL=${sDtIni}&DATA_FINAL=${sDtFim}&tipo=${sTipo}&tipo_emissao=${sTipoEmissao}&COO_INICIAL=${sIntIni}&COO_FINAL=${sIntFim}`;

  try {
    $.LoadingOverlay("show");
    try {
      const response = await requisicao_ecf("POST", url, params, "", 40000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro(
          "Não foi possível emitir o Arquivo MFD AC 17/04, tente novamente."
        );
        return;
      }
    } catch (error) {
      console.error(error);
      msgErro(
        "Não foi possível emitir o Arquivo MFD AC 17/04, tente novamente."
      );
    }
  } finally {
    $.LoadingOverlay("hide");
  }
}

async function confirmaLMF() {
  sTipoEmissao = $('input[name="rgTipoEmissao"]:checked').val();
  sTipoData = $('input[name="rgTipo"]:checked').val();
  sDtIni = moment($("#txtDataLMFDe").val()).format("DD/MM/YYYY");
  sDtFim = moment($("#txtDataLMFAte").val()).format("DD/MM/YYYY");
  sIntIni = $("#txtIntDe").val();
  sIntFim = $("#txtIntAte").val();
  bSimples = $("#modalLMF-titulo").html().indexOf("Simples") > 0;

  if (sTipoData == "0" && (sDtIni == "" || sDtFim == "")) {
    msgErro("Necessário filtrar as datas.");
    return;
  }
  if (sTipoData == "1" && (sIntIni == "" || sIntFim == "")) {
    msgErro("Necessário filtrar os intervalos.");
    return;
  }

  const url = `/cupom/leituramemoriafiscal?`;
  const params = `dt_inicial=${sDtIni}&dt_final=${sDtFim}&tipo_mf=${bSimples ? "S" : "C"
    }&tipo=${sTipoData}&tipo_emissao=${sTipoEmissao}&int_inicial=${sIntIni}&int_final=${sIntFim}`;

  try {
    $.LoadingOverlay("show");
    try {
      const response = await requisicao_ecf("GET", url, params, "", 40000);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro(
          "Não foi possível emitir a identificaPAF ECF, tente novamente."
        );
        return;
      }
    } catch (error) {
      console.error(error);
      msgErro("Não foi possível emitir a identificaPAF ECF, tente novamente.");
    }
  } finally {
    $.LoadingOverlay("hide");
  }
}

async function abreLMF(sTipo) {
  $("#modalLMF-titulo").html(
    sTipo == "simples"
      ? "Leitura de Memória Fiscal - Simples"
      : "Leitura de Memória Fiscal - Completa"
  );
  $("#espelho_dll").css("display", "none");
  $("#rgTipoEmissao").html("Tipo Emissão");
  $("#rgTipoEmissao1").html("Arquivo/Serial");
  $("#rgTipoEmissao2").html("Impresso");
  $("#modal-lmf").modal("show");
}

async function abreArqMFD() {
  $("#modalLMF-titulo").html("Arquivo MFD AC 17/04");
  $("#espelho_dll").css("display", "visible");
  $("#rgTipoEmissao").html("Tipo Emissão");
  $("#rgTipoEmissao1").html("Arquivo");
  $("#rgTipoEmissao2").html("Espelho");
  $("#modal-lmf").modal("show");
}

async function geraArquivo(sTipo) {
  const url =
    sTipo == "MF" ? "/cupom/gerararquivomf?" : "/cupom/gerararquivomfd?";

  msgAlerta(
    `Tem certeza que deseja gerar o arquivo ${sTipo}?`,
    async function () {
      try {
        $.LoadingOverlay("show");
        try {
          const response = await requisicao_ecf("GET", url, "", "", null);
          if (!response) {
            return;
          }
          if (response.status != 200) {
            msgErro(
              `Não foi possível gerar o arquivo ${sTipo}, tente novamente.`
            );
            return;
          }
        } catch (error) {
          console.error(error);
          msgErro(
            `Não foi possível gerar o arquivo ${sTipo}, tente novamente.`
          );
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }
  );
}
async function AbreREG() {
  $("#modal-reg").modal("show");
}

async function preencheSelectImpressoras() {
  try {
    const json = await retornaJsonPesquisaPadrao(
      `{"tabela": "VENDA_REDZ", "camposSelect": ["DISTINCT SERIE_ECF"], "where": ["emp_id = '${getCookie(
        "emp_id"
      )}'"] }`
    );

    if (json) {
      for (let i = 0; i < json.length; i++) {
        $("#selectImpressoras").append(
          `<option value="${json[i].SERIE_ECF}">${json[i].SERIE_ECF}</option>`
        );
      }
    }
    return json;
  } catch (error) {
    console.error();
  }
}

async function AbreArqBlocoX(sTipo) {
  $("#modal-blocox-titulo").html(
    sTipo == "RZ"
      ? "Gerar Arquivos Bloco X - Redução Z"
      : "Gerar Arquivos Bloco X - Estoque"
  );
  $("#tabela-blocox-redz").DataTable().rows().remove().draw(false);

  await preencheSelectImpressoras();

  $("#modal-blocox").modal("show");
}

$("#btn_confirmar_titp").on("click", function () {
  $("#modal-titp").modal("hide");
});

// async function preencheSelectImpressoras() {
//     try {
//         if (codMoeda != '') {
//             const json = await retornaJsonPesquisaPadrao(`{"tabela": "moeda", "camposSelect": ["descmax"], "where": ["codmoe = '${codMoeda}'"] }`);
//             if (json) {
//                 return parseFloat(json[0].DESCMAX);
//             }
//         }

//     } catch (error) {
//         console.error(error);
//     }
// }

async function AbreTITP(sTipo) {
  if (sTipo != undefined) {
    $("#modaltitp-titulo").html("Requisições Externas Registradas");
    $("#modaltitp-conteudo").html(
      `Este PAF­ECF não recebe requisições externas.`
    );
  } else {
    $("#modaltitp-titulo").html("Tab. Indíce Técnico de Produção");
    $("#modaltitp-conteudo")
      .html(`Este PAF-ECF não executa funções de baixa de estoque com base
                                       em índices técnicos de produção, não podendo ser utilizado
                                       por estabelecimento que necessite deste recurso.`);
  }
  $("#modal-titp").modal("show");
}

async function retornaRegistrosEst() {
  const url = "/sisplan/cupom/v1/BlocoXEstoque?";
  const sDtInicio = moment($("#txtBlocoXInicio").val()).format("DD/MM/YYYY");
  const sDtFim = moment($("#txtBlocoXFim").val()).format("DD/MM/YYYY");
  const sStatus = $("input[name=rg_status_bloco_x]:checked").val();

  const params = `DT_INICIO=${sDtInicio}&DT_FIM=${sDtFim}&STATUS=${sStatus}`;
  let dataSet = [];
  let dataSetCols = [];
  try {
    try {
      $.LoadingOverlay("show");
      let response = await requisicao("GET", url, params, null);

      if (!response) {
        msgErro("Erro ao buscar registros do Estoque");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro("Erro ao buscar registros do Estoque");
        return;
      }
      dataSet = jsonStr;
      if (!$.isEmptyObject(dataSet[0])) {
        // preciso dinamicamente ter a relação com o nome das colunas para tabela
        let keys = Object.keys(dataSet[0]);
        for (let k in keys) {
          dataSetCols.push({ title: keys[k], data: keys[k] });
        }

        $("#tabela-blocox-redz").DataTable({
          columns: dataSetCols,
          data: dataSet,
          paging: false,
          filter: false,
          info: false,
          order: false,
          destroy: true,
          autowidth: true,
          language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            oPaginate: {
              sNext: "Próximo",
              sPrevious: "Anterior",
              sFirst: "Primeiro",
              sLast: "Último",
            },
            oAria: {
              sSortAscending: ": Ordenar colunas de forma ascendente",
              sSortDescending: ": Ordenar colunas de forma descendente",
            },
          },
        });

        $("#tabela-blocox-redz tbody").on("click", "tr", function () {
          if ($(this).hasClass("selected")) {
            $(this).removeClass("selected");
            $("#btn_blocox_transmitir").addClass("d-none");
            $("#btn_blocox_consultar").addClass("d-none");
          } else {
            $("#tabela-blocox-redz")
              .DataTable()
              .$("tr.selected")
              .removeClass("selected");
            $(this).addClass("selected");
            $("#btn_blocox_transmitir").removeClass("d-none");
            $("#btn_blocox_consultar").removeClass("d-none");
          }
        });
      } else {
        dataSet = [];
        dataSetCols = [];
        $("#tabela-blocox-redz").DataTable().rows().remove().draw(false);
      }
    } catch (error) {
      console.error(error);
      msgErro("Erro ao buscar registros da Redução Z");
      return;
    }
  } finally {
    $.LoadingOverlay("hide");
  }
}

async function CancelaUltimoCupom() {
  const url = "/cupom/cancelarultimocupom?";
  try {
    let response = await requisicao_ecf("GET", url, "", null);
    if (!response) {
      return false;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      return false;
    }
    if (jsonStr.status == 0) {
      return true;
    }
    return false;
  } catch (error) {
    console.error(error);
    return false;
  }
}

async function validaCancelamento(obs, venda, cupom) {
  try {
    let response = await requisicao(
      "POST",
      "/Sisplan/Vendas/V1/ValidaCancelamento?",
      `OBS=${obs}&CODVEN=${venda}&NRCUPOM=${cupom}`
    );
    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.mensagem);
      return false;
    }
    return true;
  } catch (error) {
    console.error(error);
  }
}

async function ValidaUltimoCupom(sCupomAtual) {
  const url = "/sisplan/cupom/v1/ValidarNrCupom?";
  const serieECF = getCookie("serie_ecf");
  const numeroCupom = await RetornaUltimoCupomImpressora();

  if (numeroCupom != sCupomAtual) {
    return false;
  }

  const params = `SERIE_ECF=${serieECF}&NRCUPOM=${numeroCupom}`;
  try {
    let response = await requisicao("GET", url, params, null);
    if (!response) {
      return false;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      return false;
    }
    return true; // retorna se é o ultimo cupom gravado no banco...
  } catch (error) {
    console.error(error);
    return false;
  }
}

async function RetornaItensCupom(iVenda) {
  const empId = getCookie("emp_id");
  const url = `/sisplan/funcoes/v1/pesquisa?`;
  let params;

  if ((parametrosVenda[17]) == "0") {
    params = `JSON={"tabela":"itvenda", "camposSelect":["itvenda.coditven", "itvenda.codigo", "produto.descricao", "itvenda.cor", "cadcor.descricao desc_cor", "itvenda.tam", "itvenda.quantidade", "itvenda.presente"],
      "leftjoin": [{ "tabela" : "produto", "condicao" : "itvenda.codigo = produto.codigo" }, { "tabela" : "faixa_iten", "condicao" : "faixa_iten.faixa = produto.faixa and faixa_iten.tamanho = itvenda.tam" }, { "tabela" : "cadcor", "condicao" : "cadcor.cor = itvenda.cor" }], 
      "where": ["itvenda.codven = ${iVenda} and itvenda.emp_id = ${empId}"], 
      "orderby": ["itvenda.coditven", "itvenda.codigo", "itvenda.cor", "faixa_iten.posicao"]}`;
  } else {
    params = `JSON={"tabela":"itvenda", "camposSelect":["itvenda.coditven", "itvenda.codigo", "produto.descricao", "itvenda.cor", "cadcor.descricao desc_cor", "itvenda.tam", "itvenda.quantidade", "itvenda.presente"],
      "leftjoin": [{ "tabela" : "produto", "condicao" : "itvenda.codigo = produto.codigo" }, { "tabela" : "faixa_iten", "condicao" : "faixa_iten.faixa = produto.faixa and faixa_iten.tamanho = itvenda.tam" }, { "tabela" : "cadcor", "condicao" : "cadcor.cor = itvenda.cor" }], 
      "where": ["itvenda.codven = ${iVenda} and itvenda.emp_id = ${empId}"], 
      "orderby": ["itvenda.coditven", "itvenda.codigo", "itvenda.cor", "faixa_iten.posicao"]}`;
  }
  try {
    const response = await requisicao("GET", url, params, null);

    if (!response) {
      return "";
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return "";
    }

    return jsonStr.RESULT[0];
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível buscar os dados da venda.");
    return "";
  }
}

async function abreCupomTroca() {
  $("#venda-cupom-troca").val("");
  $("#tabela-itens-cupom-troca").DataTable().rows().remove().draw(false);
  $("#modal-cupom-troca").modal("show");
}

async function rotinaSaidaVendaCupomTroca() {
  if (
    $("#venda-cupom-troca").val() == "" ||
    $("#venda-cupom-troca").attr("disabled") == true
  ) {
    // nao faz nada ...
  } else {
    $("#tabela-itens-cupom-troca").DataTable().rows().remove().draw(false);
    const venda = pegaChave("#venda-cupom-troca");
    await buscaItensCupomTroca(parseInt(venda));
  }
}

$("#modal-cupom-troca").on("shown.bs.modal", function () {
  $("#tabela-itens-cupom-troca").DataTable().columns.adjust().draw(false);
  if (
    $("#venda-cupom-troca").attr("disabled") != "disabled" &&
    $("#venda-cupom-troca").val() == ""
  ) {
    $("#venda-cupom-troca").focus();
  }
});

async function RotinaConfirmarPrecoManual(sTabela, sBarra, pPreco, pIdItem) {
  try {
    try {
      $.LoadingOverlay("show");
      const url = `/Sisplan/Vendas/V1/PrecoTabela?`;

      if ($("#radioMaterial").is(":checked")) {
        tipoItem = "M";
      }
      if ($("#radioProduto").is(":checked")) {
        tipoItem = "P";
      }

      const params = `tabela=${sTabela}&barra=${encodeURIComponent(sBarra)}&idItem=${pIdItem}&TIPO=${tipoItem}&PRECO=${pPreco}&PRAZO=${pegaValor('#rgPrazo')}`;
      let response = await requisicao("POST", url, params, null);
      if (!response) {
        msgErro("Erro ao consultar gravar preço");
        return;
      }

      if (response.status != 200) {
        msgErro("Erro ao gravar preço");
        return false;
      }

      $("#modalCadPreco").modal("hide");
      $("#txtCodigo").val(sBarra);
      $("#txtIdItem").val(pIdItem);
      $("#txtCodigo").trigger("blur");
    } catch (error) {
      console.error(error);
      msgErro("Erro ao gravar preço");
      return;
    }
  } finally {
    $.LoadingOverlay("hide");
  }
}

async function buscaItensCupomTroca(iVenda) {
  const dataSet = await RetornaItensCupom(iVenda);
  for (let i = 0; i < dataSet.length; i++) {
    let data = [
      `<center><input type="checkbox" class="checkCupom" id="cb_itens_troca_${i}"></center>`,
      dataSet[i].CODITVEN,
      dataSet[i].CODIGO,
      dataSet[i].DESCRICAO,
      dataSet[i].COR,
      dataSet[i].DESC_COR,
      dataSet[i].TAM,
      dataSet[i].QUANTIDADE,
    ];
    $("#tabela-itens-cupom-troca").DataTable().row.add(data).draw(false);
  }
  for (let i = 0; i < $(".checkCupom").length; i++) {
    const element = $($(".checkCupom")[i]).closest("td");
    if (dataSet[i].PRESENTE == "S") {
      selecionarLinhaTabela("#tabela-itens-cupom-troca", "checkCupom", element);
    }
  }
}

async function RetornaUltimoCupomImpressora() {
  // caso retornar -1 significa que não deu certo a comunicação.
  const url = "/cupom/retornanrultimocupom?";
  try {
    const response = await requisicao_ecf("GET", url, "", null);
    if (!response) {
      return -1;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      return -1;
    }
    if (jsonStr.status == 0) {
      return jsonStr.valor;
    }
    return -1;
  } catch (error) {
    console.error(error);
    return -1;
  }
}

async function verificaDuplicatasEmAberto(valorAntecipacao) {
  try {
    $.LoadingOverlay("show");
    try {
      let dataSet = [];
      let dataSetCols = [];
      const jsonStr = await buscaDuplicatasEmAberto(pegaChave("#txtCliente"));
      $("#txtValorAntecipacaoAberta").html(
        ArredondarValor(valorAntecipacao, 2)
      );
      if (!$.isEmptyObject(jsonStr)) {
        dataSet = jsonStr;
        if (!$.isEmptyObject(dataSet[0])) {
          const keys = Object.keys(dataSet[0]);
          dataSetCols[0] = { title: "SELECIONAR", data: "SELECIONAR" };
          keys.forEach((key) => {
            dataSetCols.push({ title: key, data: key });
          });

          dataSetCols[0].render = function (data, type, row, meta) {
            return (
              `${'<div class="group-default form-group">' +
              '<div class="relative">' +
              '<input style="height:20px" type="checkbox" id="check_col_'
              }${[meta.row]}_row_${[
                meta.col,
              ]}" class="input-default focus form-control validate campoCheck"> ` +
              `</div>` +
              `</div>`
            );
          };

          $("#tabelaDuplicatasEmAberto").DataTable({
            columns: dataSetCols,
            data: dataSet,
            paging: false,
            filter: false,
            info: false,
            order: false,
            destroy: true,
            autowidth: true,
            language: {
              sEmptyTable: "Nenhum registro encontrado",
              sInfo: "_TOTAL_ registros",
              sInfoEmpty: " 0 registros",
              sInfoFiltered: "(Filtrados de _MAX_ registros)",
              sInfoPostFix: "",
              sInfoThousands: ".",
              sLengthMenu: "_MENU_ resultados",
              sLoadingRecords: "Carregando...",
              sProcessing: "Processando...",
              sZeroRecords: "Nenhum registro encontrado",
              sSearch: "Pesquisar",
              oPaginate: {
                sNext: "Próximo",
                sPrevious: "Anterior",
                sFirst: "Primeiro",
                sLast: "Último",
              },
              oAria: {
                sSortAscending: ": Ordenar colunas de forma ascendente",
                sSortDescending: ": Ordenar colunas de forma descendente",
              },
            },
          });

          $(".campoCheck").on("change", function () {
            if (this.checked) {
              $(this).addClass("selecionado");
            } else {
              $(this).removeClass("selecionado");
            }
          });
        }

        const tableData = $("#tabelaDuplicatasEmAberto")
          .DataTable()
          .column(7, {})
          .data()
          .sum();
        if (tableData > valorAntecipacao) {
          return true;
        }
      }

      return false;
    } catch (error) {
      console.error(error);
    }
  } finally {
    $.LoadingOverlay("hide");
  }
}

async function retornaRegistrosRedZ() {
  const url = "/sisplan/cupom/v1/BlocoX?";
  const sDtInicio = moment($("#txtBlocoXInicio").val()).format("DD/MM/YYYY");
  const sDtFim = moment($("#txtBlocoXFim").val()).format("DD/MM/YYYY");
  const sSerieECF = $("#selectImpressoras").val();
  const sStatus = $("input[name=rg_status_bloco_x]:checked").val();

  const params = `DT_INICIO=${sDtInicio}&DT_FIM=${sDtFim}&STATUS=${sStatus}&SERIE_ECF=${sSerieECF}`;
  let dataSet = [];
  let dataSetCols = [];
  try {
    $.LoadingOverlay("show");
    try {
      const response = await requisicao("GET", url, params, null);

      if (!response) {
        msgErro("Erro ao buscar registros da Redução Z");
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        msgErro("Erro ao buscar registros da Redução Z");
        return;
      }
      dataSet = jsonStr;
      if (!$.isEmptyObject(dataSet[0])) {
        // preciso dinamicamente ter a relação com o nome das colunas para tabela
        let keys = Object.keys(dataSet[0]);
        for (let k in keys) {
          dataSetCols.push({ title: keys[k], data: keys[k] });
        }

        dataSet.map((item) => {
          item.EMITIDO = (item.RECIBO != '') && (item.EMITIDO == 'N') ? 'A' : item.EMITIDO
        });

        $("#tabela-blocox-redz").DataTable({
          columns: dataSetCols,
          data: dataSet,
          paging: false,
          filter: false,
          info: false,
          order: false,
          destroy: true,
          autowidth: true,
          language: {
            sEmptyTable: "Nenhum registro encontrado",
            sInfo: "_TOTAL_ registros",
            sInfoEmpty: " 0 registros",
            sInfoFiltered: "(Filtrados de _MAX_ registros)",
            sInfoPostFix: "",
            sInfoThousands: ".",
            sLengthMenu: "_MENU_ resultados",
            sLoadingRecords: "Carregando...",
            sProcessing: "Processando...",
            sZeroRecords: "Nenhum registro encontrado",
            sSearch: "Pesquisar",
            oPaginate: {
              sNext: "Próximo",
              sPrevious: "Anterior",
              sFirst: "Primeiro",
              sLast: "Último",
            },
            oAria: {
              sSortAscending: ": Ordenar colunas de forma ascendente",
              sSortDescending: ": Ordenar colunas de forma descendente",
            },
          },
        });

        $("#tabela-blocox-redz tbody").on("click", "tr", function () {
          if ($(this).hasClass("selected")) {
            $(this).removeClass("selected");
            $("#btn_blocox_transmitir").addClass("d-none");
            $("#btn_blocox_consultar").addClass("d-none");
          } else {
            $("#tabela-blocox-redz")
              .DataTable()
              .$("tr.selected")
              .removeClass("selected");
            $(this).addClass("selected");
            $("#btn_blocox_transmitir").removeClass("d-none");
            $("#btn_blocox_consultar").removeClass("d-none");
          }
        });
      } else {
        dataSet = [];
        dataSetCols = [];
        $("#tabela-blocox-redz").DataTable().rows().remove().draw(false);
      }
    } catch (error) {
      console.error(error);
      msgErro("Erro ao buscar registros da Redução Z");
      return;
    }
  } finally {
    $.LoadingOverlay("hide");
  }
}

$(document).ready(async function () {
  parametrosVenda = await BuscaParametrosVenda();
  parametrosSistema = await BuscaParametrosSistema('S');
  quantidadeCasasDecimaisParametro = parametrosSistema[1] ?? 0;
  quantidadeCasasDecimaisCampo = (+quantidadeCasasDecimaisParametro) + 2;

  $("#collapseMenu").on("shown.bs.collapse", function (e) {
    $(".subatalho .fa-angle-down")
      .removeClass("fa-angle-down")
      .addClass("fa-angle-up");
  });
  $("#collapseMenu").on("hidden.bs.collapse", function (e) {
    $(".subatalho .fa-angle-up")
      .removeClass("fa-angle-up")
      .addClass("fa-angle-down");
  });
  let empId = getCookie("emp_id");

  $("#venda-cupom-troca").autocompleta(2, `JSON={ "tabela":"venda", "camposSelect":[ "venda.codven chave", "venda.codven descricao" ], "where": ["venda.emp_id = ${empId}"]}`);
  $("#txtGrupo").autocompleta(1, `JSON={ "tabela":"GRUPO_CLI", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $("#txtPais").autocompleta(1, `JSON={ "tabela":"cadpais", "camposSelect":[ "codigo chave", "nome descricao"], "where": null}`);
  $('#txtNaturezaCFe').autocompleta(1, `JSON={ "tabela":"natureza", "camposSelect":["NATUREZA CHAVE, DESCRICAO DESCRICAO"], "where": [] }`);
  $('#txtTransportadoraModal').autocompleta(1, `JSON={ "tabela":"TABTRAN", "camposSelect":[ "CODIGO CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtConfXMLModal').autocompleta(1, `JSON={ "tabela":"FATCONF_XML", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $("#txtOperacaoCFe").autocompleta(1, `JSON={ "tabela":"oper_fiscal", "camposSelect":["CODIGO CHAVE, DESCRICAO DESCRICAO"], "where": [] }`);

  $("#btn-venda-cupom-troca").pesquisa("#venda-cupom-troca", "CODVEN", "CODVEN", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"VENDA", "camposSelect":[ "venda.codven", "venda.codcli", "entidade.nome"], "leftjoin":[{"tabela" : "entidade", "condicao" : "entidade.codcli = venda.codcli"}], "where": ["venda.emp_id = ${empId}"], "orderby": ["venda.codven desc"]}`, "Pesquisa Venda", "venda");
  $("#btn-Grupo").pesquisa("#txtGrupo", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"GRUPO_CLI", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Grupo", "GRUPO_CLI");
  $("#btn-pais-entidade").pesquisa("#txtPais", "CODIGO", "NOME", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadpais", "camposSelect":[ "codigo", "nome"]}`, "Pesquisa País", "cadpais");
  $('#btn-NaturezaCFe').pesquisa('#txtNaturezaCFe', 'NATUREZA', 'DESCRICAO', '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"natureza", "camposSelect":[ "natureza", "descricao" ], "where": null}', 'Pesquisa Natureza', 'natureza');
  $('#btnPesquisaTransportadoraModal').pesquisa('#txtTransportadoraModal', 'CODIGO', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABTRAN", "camposSelect":[ "CODIGO", "NOME"]}`, 'Pesquisa Transportadora', 'TABTRAN');
  $('#btnConfXMLModal').pesquisa('#txtConfXMLModal', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"FATCONF_XML", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Conf XML', 'FATCONF_XML');
  $("#btnOperacaoCFe").pesquisa("#txtOperacaoCFe", "CODIGO", "DESCRICAO", '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"oper_fiscal", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Operação", "oper_fiscal");

  $("#btn-limpa-venda-cupom-troca").on("click", function () {
    limpaValor("#venda-cupom-troca");
  });

  $("#btn-AGrupo").on("click", function () {
    $("#txtGrupo").val("");
  });

  $("#btn-limpar-pais-entidade").on("click", function () {
    $("#txtPais").val("");
  });

  $("#btnAOperacaoCFe").on("click", function () {
    $("#txtOperacaoCFe").val("");
  });

  $('#btn-limpa-NaturezaCFe').on('click', function () {
    $('#txtNaturezaCFe').val('');
  });

  $("#btnLimpaTransportadoraModal").on('click', function () {
    $('#txtTransportadoraModal').val('');
  });

  $("#btnLimpaConfXMLModal").on('click', function () {
    $('#txtConfXMLModal').val('');
  });

  $("#venda-cupom-troca").on("blur", async function () {
    await rotinaSaidaVendaCupomTroca();
  });

  $("#tabela-itens-cupom-troca").DataTable({
    destroy: true,
    order: false,
    filter: false,
    paginate: false,
    search: false,
    autoWidth: true,
    scrollY: "220px",
    scrollCollapse: true,
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar (geral): ",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
  });

  $("#confirmar-cupom-troca").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const existeLayoutCookie = getCookie("serie_ecf");
        let lista = "";
        const tipo = $('input[name="tipo"]:checked').val();
        for (let i = 0; i < $("#tabela-itens-cupom-troca").DataTable().rows().count(); i++) {
          let data = $("#tabela-itens-cupom-troca").DataTable().row(i).data();
          if ($(`#cb_itens_troca_${i}`).prop("checked")) {
            lista += `${data[1]},`;
          }
        }
        lista = lista.substr(0, lista.length - 1);
        if (lista.length == 0) {
          msgErro("Nenhum item selecionado, verifique");
          return;
        }
        if (existeLayoutCookie == "") {
          await imprimirCupomTrocaSemECF(pegaChave('#venda-cupom-troca'), $('#tabela-itens-cupom-troca').DataTable().data());
        } else {
          const nrVenda = pegaChave("#venda-cupom-troca");

          if ($("#venda-cupom-troca").val() == "") {
            msgErro("Nenhuma venda informada, verifique");
            return;
          }

          await ImprimirCupomTroca(nrVenda, tipo, lista);
        }
        $("#modal-cupom-troca").modal("hide");
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $("#tabela-itens-cupom-troca").on("click", "td", function () {
    selecionarLinhaTabela("#tabela-itens-cupom-troca", "checkCupom", this);
  });

  $("#btn_blocox_transmitir").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const url = "/sisplan/cupom/v1/BlocoXReducao?";
        const tr = $("#tabela-blocox-redz tr.selected")[0];
        const data = $("#tabela-blocox-redz").DataTable().row($(tr)).data();
        const dataMov = moment(data.DATA_MOV).format("DD/MM/YYYY");
        const params = `DATA_MOV=${dataMov}&SERIE_ECF=${data.SERIE_ECF}`;

        if (data.EMITIDO == "S" && data.RECIBO != "") {
          msgSucesso(
            "Arquivo com Informações da Redução Z do PAF-ECF já Emitido."
          );
          return;
        }

        const response = await requisicao("POST", url, params, null, 90000);
        if (!response) {
          msgErro("Erro ao transmitir dados do Bloco X");
          return;
        }

        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        const message = await response.text();
        if (message != '') {
          msgAlerta(message);
        }

        return;
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $("#btn_blocox_consultar").on("click", async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const url = "/sisplan/cupom/v1/blocoxreducao?";
        const tr = $("#tabela-blocox-redz tr.selected")[0];
        const data = $("#tabela-blocox-redz").DataTable().row($(tr)).data();
        if (data.RECIBO == "") {
          msgErro("Registro selecionado não possui recibo para consultar.");
          return;
        }
        const dataMov = moment(data.DATA_MOV).format("DD/MM/YYYY");

        const params = `DATA_MOV=${dataMov}&SERIE=${data.SERIE_ECF}&RECIBO=${data.RECIBO}`;

        const response = await requisicao("GET", url, params, null);

        if (!response) {
          msgErro("Erro ao consultar dados do Bloco X");
          return;
        }
        if (response.status != 200) {
          msgErro("Erro ao consultar dados do Bloco X");
          return;
        }

        const json = await response.text();
        if (json != '') {
          msgAlerta(json);
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $('#btnConfiguracaoBlocoX').on('click', function () {
    $('#modal-ConfigBlocoX').modal('show');
  });

  $('#btnConfirmarConfig').on('click', async function () {
    try {

      const url = "/sisplan/ini/v1/blocox?";
      const params = `AMBIENTE=${$('#txtAmbiente').val()}`;
      const response = await requisicao('PUT', url, params, null);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        const jsonStr = await response.json();
        msgErro(jsonStr.mensagem);
        return;
      }

      await criaMensagemSucesso('Gravado com sucesso!');
      $('#modal-ConfigBlocoX').modal('hide');

    } catch (error) {
      console.error(error);
    }

  });

  $('#modal-ConfigBlocoX').on('shown.bs.modal', async function () {

    async function carregaDadosIni() {
      try {
        const url = "/sisplan/ini/v1/blocox?";
        const response = await requisicao('GET', url, `NUMEROSERIE=${$('#selectImpressoras').val()}`, null);

        if (!response) {
          return;
        }
        const jsonStr = await response.text();
        if (response.status != 200) {
          msgErro(jsonStr.mensagem);
          return;
        }

        return jsonStr;

      } catch (error) {
        console.error(error);
      }

    }

    try {
      $.LoadingOverlay('show');

      const ambiente = await carregaDadosIni();

      $('#txtAmbiente').val(ambiente);

      if (ambiente == '0') {
        $('#txtTipoAmbiente').html('HOMOLOGAÇÃO');
      } else {
        $('#txtTipoAmbiente').html('PRODUÇÃO');
      }

    } finally {
      $.LoadingOverlay('hide');
    }
  });


  $("#btn_blocox_fechar").on("click", (_) => {
    $("#modal-blocox").modal("hide");
  });

  tabela = $("#tabela-blocox-redz").DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    autowidth: true,
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
  });

  $("#btn_consultar_blocox").on("click", function () {
    if ($("#txtBlocoXInicio").val() == "") {
      msgErro("Informe uma data de início para continuar.");
      return;
    }
    if ($("#txtBlocoXFim").val() == "") {
      msgErro("Informe uma data final para continuar.");
      return;
    }
    if ($("#modal-blocox-titulo").html().indexOf("Estoque") > 0) {
      retornaRegistrosEst();
    } else {
      retornaRegistrosRedZ();
    }
  });

  $("#btn_confirmar_vendas").on("click", function () {
    if ($("#txtVendasAno").val() == "") {
      msgErro("Informe um ano para continuar.");
      return;
    }
    if ($("#txtVendasMes").val() == "") {
      msgErro("Informe um mês para continuar.");
      return;
    }
    registroVendas();
  });

  $("#tabela_cnpjs").DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: false,
    autowidth: true,
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
  });

  async function addDataTable() {
    const CNPJ = $("#txtListaCNPJ").val();
    $("#txtListaCNPJ").val("");
    const dados = [CNPJ];
    $("#tabela_cnpjs").DataTable().row.add(dados).draw(false);
  }
  $("#btn_limpa_cnpj").on("click", function () {
    $("#tabela_cnpjs").DataTable().rows().remove().draw(false);
  });

  $("#btn_filtra_cnpj").pesquisa(
    "#txtListaCNPJ",
    "CNPJ",
    "CNPJ",
    '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "CNPJ"], "where": null}',
    "Pesquisa CNPJ",
    "entidade",
    true,
    addDataTable
  );

  //
  $("#tabela_prods").DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: false,
    autowidth: true,
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
  });

  async function addDataTableProd() {
    const codigo = $("#txtListaPRODS").attr("data-chave");
    const descricao = $("#txtListaPRODS").attr("data-desc");
    limpaValor("#txtListaPRODS");
    const dados = [codigo, descricao];
    $("#tabela_prods").DataTable().row.add(dados).draw(false);
  }
  $("#btn_limpa_prods").on("click", function () {
    $("#tabela_prods").DataTable().rows().remove().draw(false);
  });

  $("#btn_filtra_prods").pesquisa(
    "#txtListaPRODS",
    "CODIGO",
    "DESCRICAO",
    '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO"], "where": null}',
    "Pesquisa Produtos",
    "produto",
    true,
    addDataTableProd
  );
  //
});

async function AtualizarReducaoZ(jsonObject) {
  try {
    const url = '/sisplan/cupom/v1/reducaoz?';
    const params = `JSON=${encodeURIComponent(JSON.stringify(jsonObject))}`;
    const response = await requisicao("POST", url, params, null, 900000);
    if (!response) {
      msgErro("erro ao atualizar dados reducao z");
      return;
    }

    if (response.status != 200) {
      msgErro("erro ao atualizar dados reducao z");
      return;
    }
  }
  catch (err) {
    console.error('erro ao atualizar dados reducao z', err);
  }
}

async function realizaReducaoZ() {
  const url = `/cupom/reducaoz?`;

  msgAlerta(`Tem certeza que deseja efetuar a Redução Z?`, async function () {
    try {
      $.LoadingOverlay("show");
      try {
        const response = await requisicao_ecf("GET", url, "", "", 900000);

        if (!response) {
          return;
        }

        if (response.status != 200) {
          msgErro("Não foi possível emitir a Redução Z, tente novamente.");
          return;
        }

        const jsonStr = await response.json();
        await AtualizarReducaoZ(jsonStr);

      } catch (error) {
        console.error(error);
        msgErro("Não foi possível emitir a Redução Z, tente novamente.");
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });
}

async function maquinaTemImpressora() {
  // faz uma requisicao de teste na porta da impressora.
  try {
    const serieCookie = getCookie("serie_ecf");
    if (serieCookie && serieCookie !== "") {
      return true;
    }

    const porta = getCookie("porta_api_local");
    if (porta == "") {
      return false;
    }
    const response = await requisicao_ecf("GET", "/conexao/conexao?", ``, 1000);
    if (!response) {
      return false;
    }
    if (response.status == 200) {
      return true;
    }
    return false;
  } catch (error) {
    console.error(error);
    return false;
  }
}

async function conectaECF(ipInterno, ipExterno, chave) {
  try {
    const ipPorta = getCookie("conexao") == "interna" ? ipInterno : ipExterno;
    const url = `/cupom/conectaecf?`;

    const response = await requisicao_ecf(
      "POST",
      url,
      `ip_porta=${ipPorta}&chave=${chave}`,
      "",
      null
    );

    if (!response) {
      return;
    }

    const jsonStr = await response.json();
    if (jsonStr.valor.toUpperCase() != "TRUE" && jsonStr.valor.toUpperCase() != "FALSE")
      setCookie("serie_ecf", jsonStr.valor);
    if (response.status != 200) {
      msgErro("Não foi possível conectar com a ECF, tente novamente.");
      return;
    }
    if (jsonStr.status == 0) {
      await buscaStatusImpressora();
    } else {
      msgErro("Não foi possível conectar com a ECF, tente novamente.");
      return;
    }
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível conectar com a ECF, tente novamente.");
  }
}

async function buscaStatusImpressora() {
  const url = `/cupom/estado?`;

  try {
    let response = await requisicao_ecf("GET", url, "", "", null);

    if (!response) {
      $("#txtStatusECF").css("background-color", "red");
      $("#txtStatusECF").html(" Offline ");
      $("#txtEstadoECF").html("Desconectado");
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      // msgErro(jsonStr['RESULT'][0].mensagem);
      $("#txtStatusECF").css("background-color", "red");
      $("#txtStatusECF").html(" Offline ");
      $("#txtEstadoECF").html("Desconectado");
      return;
    }
    if (jsonStr.status == 0) {
      $("#txtStatusECF").css("background-color", "green");
      $("#txtStatusECF").html(" Online ");
      $("#txtEstadoECF").html(jsonStr.valor);

      if (jsonStr.valor == 'Requer Z') {
        msgAlerta('Impressora com Redução Z pendente, para emitir, utilize o menu fiscal localizado a direita.');
        return;
      }
    } else {
      $("#txtStatusECF").css("background-color", "green");
      $("#txtStatusECF").html(" Online ");
      $("#txtEstadoECF").html(
        jsonStr.valor != "" ? jsonStr.valor : "Desconectado"
      );
      if (jsonStr.valor == 'Requer Z') {
        msgAlerta('Impressora com Redução Z pendente, para emitir, utilize o menu fiscal localizado a direita.');
        return;
      }
    }
  } catch (error) {
    console.error(error);
    $("#txtStatusECF").css("background-color", "red");
    $("#txtStatusECF").html(" Offline ");
    $("#txtEstadoECF").html("Desconectado");
    // msgErro('Não foi possível buscar o status da Impressora Fiscal.');
  }
}

$("#modal-cliente").on("shown.bs.modal", function () {
  $("#txtCNPJModalCli").focus();
});

async function PreencheDescDeposito(sDeposito) {
  let url = `/sisplan/funcoes/v1/pesquisa?`;

  try {
    let response = await requisicao(
      "GET",
      url,
      `JSON={ "tabela":"deposito", "camposSelect":["descricao"], "where": ["codigo = '${sDeposito}'"] }`,
      null
    );

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }
    let deposito = jsonStr.RESULT[0][0].DESCRICAO;
    $("#txtDeposito").val(`[${sDeposito}] - ${deposito}`);
    $("#txtDeposito").attr("data-selecionado", true);
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível buscar os dados do depósito.");
  }
}

async function PreencheDescStatus(sStatus) {
  let url = `/sisplan/funcoes/v1/pesquisa?`;

  try {
    let response = await requisicao(
      "GET",
      url,
      `JSON={ "tabela":"sitprod", "camposSelect":["descricao"], "where": ["codigo = '${sStatus}'"] }`,
      null
    );

    if (!response) {
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }
    const descStatus = jsonStr.RESULT[0][0].DESCRICAO;
    $("#txtStatus").val(`[${sStatus}] - ${descStatus}`);
    $("#txtStatus").attr("data-selecionado", true);
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível buscar os dados do depósito.");
  }
}

async function PreencheDescRegra(codRegra) {
  let url = `/sisplan/funcoes/v1/pesquisa?`;

  try {
    let response = await requisicao(
      "GET",
      url,
      `JSON={ "tabela":"regra_promocao", "camposSelect":["desc_regra"], "where": ["regra = '${codRegra}'"] }`,
      null
    );

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }

    let descRegra = jsonStr.RESULT[0][0].DESC_REGRA;
    $("#txtRegraPromocao").val(`[${codRegra}] - ${descRegra}`);
    $("#txtRegraPromocao").attr("data-selecionado", true);
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível buscar os dados da Regra.");
  }
}

async function PreencheDescVendedor(sCodRep) {
  let url = `/sisplan/funcoes/v1/pesquisa?`;

  try {
    let response = await requisicao(
      "GET",
      url,
      `JSON={ "tabela":"represen", "camposSelect":["nome"], "where": ["codrep = '${sCodRep}'"] }`,
      null
    );

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }
    let nome = jsonStr.RESULT[0][0].NOME;
    $("#txtVendedor").val(`[${sCodRep}] - ${nome}`);
    $("#txtVendedor").attr("data-selecionado", true);
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível buscar os dados do vendedor.");
  }
}

async function PreencheDescTransportadora(sCodTrans) {
  const url = `/sisplan/funcoes/v1/pesquisa?`;
  if (sCodTrans === '') { return; }

  try {
    const response = await requisicao(
      "GET",
      url,
      `JSON={ "tabela":"tabtran", "camposSelect":["nome"], "where": ["codigo = '${sCodTrans}'"] }`,
      null
    );

    if (!response) {
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }
    const nome = jsonStr.RESULT[0][0].NOME;
    insereValor('#txtTransportadora', sCodTrans, nome);
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível buscar os dados da transportadora");
  }
}

async function PreencheDescGuia(sCodRep2) {
  if (sCodRep2 == "") {
    return;
  }

  let url = `/sisplan/funcoes/v1/pesquisa?`;
  try {
    let response = await requisicao(
      "GET",
      url,
      `JSON={ "tabela":"represen", "camposSelect":["nome"], "where": ["codrep = '${sCodRep2}'"] }`,
      null
    );

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }
    let nome = jsonStr.RESULT[0][0].NOME;
    $("#txtGuia").val(`[${sCodRep2}] - ${nome}`);
    $("#txtGuia").attr("data-selecionado", true);
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível buscar os dados do guia.");
  }
}

async function PreencheDescTabela(sTabela) {
  let url = `/sisplan/funcoes/v1/pesquisa?`;

  try {
    let response = await requisicao(
      "GET",
      url,
      `JSON={ "tabela":"regiao", "camposSelect":["descricao"], "where": ["regiao = '${sTabela}'"] }`,
      null
    );

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }
    let tabela = jsonStr.RESULT[0][0].DESCRICAO;
    $("#txtTabela").val(`[${sTabela}] - ${tabela}`);
    $("#txtTabela").attr("data-selecionado", true);
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível buscar os dados da tabela de preço.");
  }
}

async function PreencheNomeECNPJ(sCodCli) {
  let url = `/sisplan/funcoes/v1/pesquisa?`;

  try {
    let response = await requisicao(
      "GET",
      url,
      `JSON={ "tabela":"entidade", "camposSelect":["nome","cnpj"], "where": ["codcli = '${sCodCli}'"] }`,
      null
    );

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }
    let nome = jsonStr.RESULT[0][0].NOME;
    let cnpj = jsonStr.RESULT[0][0].CNPJ;
    $("#txtCliente").val(`[${sCodCli}] - ${nome}`);
    $("#txtCliente").attr("data-selecionado", true);
    $("#txtCNPJ").val(cnpj);
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível buscar os dados do cliente.");
  }
}

async function liberarVenda(iCodVen) {
  try {
    $.LoadingOverlay("show");
    let response = await requisicao(
      "POST",
      "/sisplan/controleedicao/v1/controleedicao?",
      `valor=${iCodVen}&tela=LOJA`,
      null
    );

    if (!response) {
      $.LoadingOverlay("hide");
      return false;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      $.LoadingOverlay("hide");
      return false;
    }
    $.LoadingOverlay("hide");
    return true;
  } catch (error) {
    console.error(error);
    $.LoadingOverlay("hide");
  }
}

function retornaCodigosEPC(CodigoVenda, bUsaIntegraçãoITAG) {
  if (bUsaIntegraçãoITAG) {
    const objeto = {
      Numero: CodigoVenda,
      Id: '',
      CodigosEPC:
        listaBarrasBipadasEPC.map((lista) => {
          const objeto = {
            EPC: lista
          }
          return objeto
        }),
    }
    return objeto;
  } else {
    const objeto = {
      Numero: CodigoVenda,
      Id: '',
      CodigosEPC: []
    }
    return objeto
  }
}

async function montaJsonVenda(objetoVenda, numeroVenda, tipoVenda, bOlharCondicoesDePagamento = false, usaCupom = false) {
  const parametroUsaProduto = parametrosVenda[17];
  const bUsaIntegraçãoITAG = parametrosVenda[60] == 1 || parametrosVenda[60] == 2;

  let totalBruto = 0;
  let venda = objetoVenda;
  let total = $("#tabelaItens").DataTable().column(7, {}).data().sum();
  for (let i = 0; i < $("#tabelaItens").DataTable().rows().count(); i++) {
    const item = $("#tabelaItens").DataTable().row(i).data();
    totalBruto += await TruncaDecimais(2, item[2] * item[3]);
  }
  if (numeroVenda != "create" && numeroVenda != "create#") {
    venda.codVen = numeroVenda;
  } else {
    venda.codVen = null;
  }

  const utilizaBarraLog = (parametrosVenda[46]) == "1";

  let valorDesconto = $("#tabelaCondicoesDePagamento").DataTable().column(11, {}).data().sum();
  venda.codCli = pegaChave("#txtCliente", venda.codcli);
  venda.data = `${formataData(new Date())}T00:00:00Z`;
  venda.codRep = pegaChave("#txtVendedor", venda.codRep);
  venda.status = pegaChave("#txtStatus", venda.status);
  venda.codRep2 = $('#txtGuia').val() != undefined ? pegaChave("#txtGuia", venda.codRep2) : '';
  venda.fechada = !!(bOlharCondicoesDePagamento && $("#tabelaCondicoesDePagamento").DataTable().rows().count() > 0);
  venda.tabela = pegaChave("#txtTabela", venda.tabela);
  venda.nrCaixa = pegaChave(sessionStorage.getItem("g_caixa_logado"), venda.NRCAIXA);
  venda.devolucao = tipoVenda == "D";
  venda.usuario = sessionStorage.getItem("g_usuario_logado");
  venda.cNPJ_Consumidor = $("#txtCNPJ").val();
  venda.nome_Consumidor = pegaDescricao("#txtCliente", venda.NOME_CONSUMIDOR);
  venda.base_desc = total;
  venda.desconto = valorDesconto;
  if (!venda.devolucao) {
    venda.regra = pegaChave($("#txtRegraPromocao").val());
    venda.acres = $("#txtValorAcrescMoedaSalvo").val() != "" ? $("#txtValorAcrescMoedaSalvo").val() : 0;
    venda.Valor_Frete = $("#txtFrete").val();
    venda.Venda_Tipo = $("#txtTipoVenda").val();
    venda.DebitaDuplicatas = false;
    venda.transportadora = pegaChave('#txtTransportadora');
    venda.volumes = $('#txtVolumes').val();
    venda.fretePor = $('#rgTransportador').val();
    venda.cupomDesconto = $('#txtCupomDesconto').val();
  } else {
    venda.regra = 0;
    venda.Valor_Frete = 0;
    venda.Venda_Tipo = 1;
    venda.acres = 0;
    venda.cupomDesconto = '';
  }
  venda.valor = total + parseFloat(venda.acres) - valorDesconto;
  venda.valor_Bruto = totalBruto;
  venda.hr_Venda = `${formataData(new Date())}T00:00:00Z`; // tratar na api
  venda.valor_Promo = 0;
  venda.observacao = "";
  venda.itens = tipoVenda == "D" ? await listaItensDev(parametroUsaProduto, utilizaBarraLog) : await listaItens(parametroUsaProduto, utilizaBarraLog);
  venda.condicao = await listaCondicoes();
  venda.prazo = pegaValor('#rgPrazo');
  venda.preVenda = ""; // tratar na api para caso for put a requisição nao pegar daqui e manter da propria venda..
  venda.dt_Orig = `${formataData(new Date())}T00:00:00Z`;
  venda.lancamento = $("#txtLancamento").val();
  venda.observacao = $("#textDescricaoVenda").val() != undefined ? $("#textDescricaoVenda").val().toUpperCase() : "";
  venda.VendaReceber = usaCupom;
  venda.epc = retornaCodigosEPC(numeroVenda, bUsaIntegraçãoITAG);
  return venda;
}
async function adicionaParcelasCondicao(arrayParcelas) {
  try {
    $("#tabelaParcelasGeradas").DataTable().row.add(arrayParcelas).draw(false);
    let $scrollBody = $($("#tabelaParcelasGeradas").DataTable().table().node()).parent();
    $scrollBody.scrollTop($scrollBody.get(0).scrollHeight);
  } catch (error) {
    console.error(error);
  }
}

async function carregaParcelas(arrayParcelas, indiceCondicao) {
  for (let index = 0; index < arrayParcelas.length; index++) {
    const parcela = arrayParcelas[index];
    if (parcela.nomeSacado != undefined) {
      adicionaParcelasCondicao([
        indiceCondicao,
        parcela.nomeSacado,
        parcela.cPFSacado,
        parcela.banco,
        parcela.nrAgencia,
        parcela.nrConta,
        parcela.numero,
        parcela.vencimento.split("T")[0],
        parcela.valor,
        parcela.valorPago,
      ]);
    } else {
      adicionaParcelasCondicao([
        indiceCondicao,
        parcela.NOMESACADO,
        parcela.CPFSACADO,
        parcela.BANCO,
        parcela.NRAGENCIA,
        parcela.NRCONTA,
        parcela.NUMERO,
        parcela.VENCIMENTO.split("T")[0],
        parcela.VALOR,
        parcela.VALORPAGO,
      ]);
    }
  }
}

async function barraJaEstaBipada(sBarra) {
  try {
    if (listaBarrasBipadas.find(item => item.barra === sBarra)) {
      msgErro(`Barra ${sBarra} já lida, verifique.`);
      return true;
    }
    return false;
  } catch (error) {
    console.error('barra_log', error);
    msgErro('Erro ao processar barra log.');
    return false;
  }
}

async function retornaBarraLogLida(sBarra) {
  try {
    const url = `/sisplan/barralog/v1/validarbarra?`;
    const params = `barra=${encodeURIComponent(sBarra)}`;
    const response = await requisicao('GET', url, params, 15000);

    if (!response) {
      return;
    }

    jsonStr = await response.json();
    if (response.status != 200) {
      return jsonStr.mensagem;
    }

    return jsonStr.mensagem;
  } catch (error) {
    console.error(error);
  }
}

async function adicionaBarraBipada(objItem) {
  try {
    const retornoBarraLog = await retornaBarraLogLida(objItem.barra);
    if (['barra_log'].includes(retornoBarraLog)) {
      listaBarrasBipadas.push(objItem);
      return true;
    }
  } catch (error) {
    console.error(error);
  }
}

async function estornaBarraBipada(sBarra) {
  try {
    listaBarrasBipadas = [...listaBarrasBipadas.filter(item => item.barra !== sBarra)];
  } catch (error) {
    console.error(error);
  }
}

async function removeItemListaBarra(sCodigo, sCor, sTam) {
  try {
    listaBarrasBipadas = [...listaBarrasBipadas.filter(item => item.codigo !== sCodigo && item.cor !== sCor && item.tam !== sTam)];
  } catch (error) {
    console.error(error);
  }
}


async function carregaDadosItens(arrayDeItens, tipo, origemArquivo = false) {
  const utilizaBarraLog = parametrosVenda[46] == '1';
  for (let index = 0; index < arrayDeItens.length; index++) {
    if (tipo == 'D') {
      const produto = arrayDeItens[index];
      adicionaItens([
        produto.codigo,
        `${produto.codigo} - ${produto.descricao} - ${produto.cor} - ${produto.desc_Cor} - ${produto.tam}`,
        produto.quantidade,
        produto.preco_Liq,
        produto.valor,
        produto.perc_Desc,
        produto.desconto,
        produto.total_Liq,
        produto.barra,
        produto.cor,
        produto.tam,
        produto.desc_Cor,
        produto.qualidade,
        produto.iD_Estoque,
        produto.codVenDev != undefined ? produto.codVenDev : 0,
        await retornaBotaoOpcoes(),
        `${produto.codigo} - ${produto.cor} - ${produto.tam} - ${produto.qualidade}`,
        produto.presente,
        produto.lote,
        produto.tipo,
        produto.codRep,
        produto.unidade,
        produto.promocao
      ]);
      if ((utilizaBarraLog) && (produto.barras_log)) {
        produto.barras_log.forEach(async barra => {
          await adicionaBarraBipada(
            {
              codigo: produto.codigo,
              cor: produto.cor,
              tam: produto.tam,
              barra
            }
          );
        });
      }
    } else {
      const produto = arrayDeItens[index];
      const agrupamentoItem = produto.tipo != 'M' ? `${produto.codigo} - ${produto.cor} - ${produto.tam} - ${produto.codRep} - ${produto.qualidade}`
        : `${produto.codigo} - ${produto.cor} - ${produto.tam} - ${produto.codRep} - ${produto.qualidade} - ${produto.lote}`

      adicionaItens([
        produto.codigo,
        `${produto.codigo} - ${produto.descricao} - ${produto.cor} - ${produto.desc_Cor} - ${produto.tam}`,
        produto.quantidade,
        produto.valor,
        produto.preco_Liq,
        produto.perc_Desc,
        produto.desconto,
        origemArquivo ? produto.total_Liq : produto.total_Liq + produto.valor_Desc,
        await retornaBotaoOpcoes(),
        produto.barra,
        produto.cor,
        produto.tam,
        produto.desc_Cor,
        produto.qualidade,
        produto.iD_Estoque,
        produto.codVenDev != undefined ? produto.codVenDev : 0,
        agrupamentoItem,
        produto.presente,
        produto.lote,
        produto.tipo,
        produto.ValorDesc_RegraPromo != undefined ? produto.ValorDesc_RegraPromo : 0,
        produto.BaseDesc_RegraPromo != undefined ? produto.BaseDesc_RegraPromo : 0,
        produto.PercDesc_RegraPromo != undefined ? produto.PercDesc_RegraPromo : 0,
        produto.pedido,
        produto.ordem_ped,
        produto.caixa,
        produto.codRep,
        produto.dt_Inclusao,
        produto.unidade,
        produto.promocao
      ]);
      if ((utilizaBarraLog) && (produto.barras_log)) {
        produto.barras_log.forEach(async barra => {
          await adicionaBarraBipada(
            {
              codigo: produto.codigo,
              cor: produto.cor,
              tam: produto.tam,
              barra
            }
          );
        });
      }
    }
  }
}

async function carregaDescricaoCondicaoEMoeda(arrayDeCondicoes) {
  try {
    const url = `/sisplan/funcoes/v1/pesquisa?`;
    let arrayDescricoes = arrayDeCondicoes;
    for (let index = 0; index < arrayDescricoes.length; index++) {
      if (arrayDescricoes[index].descricaoCondicao == undefined) {
        await carregaParcelas(arrayDescricoes[index].parcelas, index);
        let params = `JSON={ "tabela":"CONDICAO", "camposSelect":[ "CODCOND", "DESCRICAO"], 
                                   "where" : ["CODCOND = '${arrayDescricoes[index].codCondicao}'"]}`;

        let response = await requisicao("GET", url, params);

        if (!response) {
          return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.mensagem);
          return;
        }
        arrayDescricoes[index].descricaoCondicao =
          jsonStr.RESULT[0][0].DESCRICAO;

        params = `JSON={ "tabela":"MOEDA", "camposSelect":[ "CODMOE", "TIPO", "DESCRICAO"], 
                                   "where" : ["CODMOE = '${arrayDescricoes[index].codMoeda}'"]}`;

        response = await requisicao("GET", url, params);

        if (!response) {
          return;
        }

        jsonStr = await response.json();
        if (response.status != 200) {
          msgErro(jsonStr.mensagem);
          return;
        }

        arrayDescricoes[index].descricaoMoeda = jsonStr.RESULT[0][0].DESCRICAO;
        arrayDescricoes[index].tipomoeda = jsonStr.RESULT[0][0].TIPO;
      }
    }
  } catch (error) {
    console.error(error);
  }
}

async function carregaDadosCondicoesPagamento(arrayDeCondicoes) {
  for (let index = 0; index < arrayDeCondicoes.length; index++) {
    const condicao = arrayDeCondicoes[index];
    const valor = condicao.parcelas[0].valor
      ? ArredondarValor(
        condicao.parcelas.reduce((total, old) => total + old.valor, 0),
        2
      )
      : ArredondarValor(
        condicao.parcelas.reduce((total, old) => total + old.VALOR, 0),
        2
      );
    const valorPago = condicao.parcelas[0].valorPago
      ? ArredondarValor(
        condicao.parcelas.reduce((total, old) => total + old.valorPago, 0),
        2
      )
      : ArredondarValor(
        condicao.parcelas.reduce((total, old) => total + old.VALORPAGO, 0),
        2
      );
    adicionaCondicoesDePagamento([
      index,
      condicao.parcelas[0].valorPago
        ? `${condicao.codMoeda} - ${condicao.descricaoMoeda}`
        : condicao.descricaoMoeda,
      condicao.parcelas[0].valorPago
        ? `${condicao.codCondicao} - ${condicao.descricaoCondicao}`
        : condicao.descricaoCondicao,
      valor,
      valorPago,
      valor / condicao.parcelas.length,
      condicao.codMoeda,
      condicao.codCondicao,
      condicao.parcelas,
      condicao.antecipacoes,
      condicao.perc_Desconto,
      condicao.valor_Desc,
      condicao.nsu,
      condicao.bandeira,
      condicao.antecipacoesPresente,
      condicao.tipomoeda,
      condicao.adicional.autorizacao,
      await retornaBotaoOpcoes()
    ]);
  }
}

function CriaRegistrosTabelaParcelas() {
  // tabela por trás para controlar as condições de pagamentos e alterções de data/valor feito pelo usuario.
  let totalParcelas = $("#tabelaParcelas").DataTable().rows().count();
  for (let index = 0; index < totalParcelas; index++) {
    const parcela = $("#tabelaParcelas").DataTable().row(index).data();
    let valorParcelas = parseFloat(
      parseFloat($($(".campoValor")[index]).val()).toFixed(2)
    );
    let vencimentosParcelas = $($(".campoVencimento")[index]).val();
    let nome =
      $($(".campoNome")[index]).val() != undefined
        ? $($(".campoNome")[index]).val()
        : "";
    let cpfCnpj =
      $($(".campoCPFCNPJ")[index]).val() != undefined
        ? $($(".campoCPFCNPJ")[index]).val()
        : "";
    let banco =
      $($(".campoBanco")[index]).val() != undefined
        ? $($(".campoBanco")[index]).val()
        : "";
    let agencia =
      $($(".campoAgencia")[index]).val() != undefined
        ? $($(".campoAgencia")[index]).val()
        : "";
    let conta =
      $($(".campoConta")[index]).val() != undefined
        ? $($(".campoConta")[index]).val()
        : "";
    let numero =
      $($(".campoNumero")[index]).val() != undefined
        ? $($(".campoNumero")[index]).val()
        : "";
    let dados = [
      parcela.Ordem,
      nome,
      cpfCnpj,
      banco,
      agencia,
      conta,
      numero,
      vencimentosParcelas,
      valorParcelas,
      "",
    ];
    $("#tabelaParcelasGeradas").DataTable().row.add(dados).draw(false);
  }
}

async function RetornaVencimentos(iCodCondicao) {
  let url = `/sisplan/funcoes/v1/pesquisa?`;
  let arrVencimentos = [];
  try {
    let response = await requisicao(
      "GET",
      url,
      `JSON={ "tabela":"cond_item", "camposSelect":[ "parcela", "prazo"], "where": ["codcond = ${iCodCondicao}"] }`,
      null
    );

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }

    let nrParcelas = jsonStr.RESULT[0].length;
    let dataAtual = new Date();
    for (let index = 0; index < nrParcelas; index++) {
      let novoPrazo = new Date();
      let nrDia = jsonStr.RESULT[0][index].PRAZO;
      novoPrazo.setDate(dataAtual.getDate() + nrDia);
      arrVencimentos.push(formataData(novoPrazo));
    }
    return arrVencimentos;
    // alert(jsonStr['RESULT'][0]);
    // return jsonStr;
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível buscar os dados dos vencimentos.");
  }
}

async function temCondicoesEspecificas(iMoeda) {
  let url = `/sisplan/funcoes/v1/pesquisa?`;
  try {
    let response = await requisicao(
      "GET",
      url,
      `JSON={ "tabela":"COND_MOEDA", "camposSelect":["CODCOND"], "where": ["moeda = ${iMoeda}"] }`,
      null
    );

    if (!response) {
      return false;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return false;
    }
    let bTemCondicoes = jsonStr.RESULT[0].length > 0;
    return bTemCondicoes;
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível buscar os dados da moeda.");
    return false;
  }
}

async function moedaPresente(iMoeda) {
  let url = `/sisplan/funcoes/v1/pesquisa?`;

  try {
    let response = await requisicao(
      "GET",
      url,
      `JSON={ "tabela":"moeda", "camposSelect":["CARTAO_PRESENTE"], "where": ["codmoe = ${iMoeda}"] }`,
      null
    );

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }
    const cartaoPresente = jsonStr.RESULT[0][0].CARTAO_PRESENTE;
    return cartaoPresente;
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível buscar os dados da moeda.");
  }
}

async function RetornaInformacoesMoeda(iMoeda) {
  let url = `/sisplan/funcoes/v1/pesquisa?`;

  try {
    let response = await requisicao(
      "GET",
      url,
      `JSON={ "tabela":"moeda", "camposSelect":["TEF", "DESC_AUTO", "MAX_PARCELAS"], "where": ["codmoe = ${iMoeda}"] }`,
      null
    );

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }
    let tef = jsonStr.RESULT[0][0].TEF;
    let descAuto =
      jsonStr.RESULT[0][0].DESC_AUTO == null
        ? 0
        : parseFloat(jsonStr.RESULT[0][0].DESC_AUTO);
    let maxNrParcelas =
      jsonStr.RESULT[0][0].MAX_PARCELAS == null
        ? 0
        : parseFloat(jsonStr.RESULT[0][0].MAX_PARCELAS);
    return [tef, descAuto, maxNrParcelas];
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível buscar os dados da moeda.");
  }
}

async function RetornaDadosMoeda(iMoeda) {
  let url = `/sisplan/funcoes/v1/pesquisa?`;

  try {
    let response = await requisicao(
      "GET",
      url,
      `JSON={ "tabela":"moeda", "camposSelect":["MOEDA.CDCONDI", "CONDICAO.DESCRICAO DESC_CONDI", "MOEDA.BAIXA_ANTE", "MOEDA.TEF", "CONDICAO.NRPAR","MOEDA.ATIVO"], "leftjoin": [{"tabela" : "condicao", "condicao" : "condicao.codcond = moeda.cdcondi"}], "where": ["moeda.codmoe = ${iMoeda}"] }`,
      null
    );

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }
    return jsonStr;
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível buscar os dados de pagamento da moeda.");
  }
}

async function RetornaCNPJ(sCodCli) {
  try {
    let url = `/sisplan/funcoes/v1/pesquisa?`;
    let response = await requisicao(
      "GET",
      url,
      `JSON={ "tabela":"entidade", "camposSelect":["cnpj"], "where": ["codcli = '${sCodCli}'"] }`,
      null
    );

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.mensagem);
      return;
    }

    let cnpj = jsonStr.RESULT[0][0].CNPJ;
    return cnpj;
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível buscar os dados do cliente.");
  }
}

async function retornaCidade() {
  const url = `/sisplan/funcoes/v1/pesquisa?`;
  const sEmpresa = getCookie("empresa");

  try {
    let response = await requisicao(
      "GET",
      url,
      `JSON={ "tabela":"empresa", "camposSelect":["emp_cidade"], "where": ["emp_pat = '${sEmpresa}'"] }`,
      null
    );

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }
    let cidade = jsonStr.RESULT[0][0].EMP_CIDADE;
    return cidade;
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível buscar os dados da empresa.");
  }
}

async function CalculaDesconto(campoAlterado) {
  try {
    const listaCamposValores = [
      "#txtPrecoDesc",
      "#txtPercDesconto",
      "#txtValorDesconto",
    ];


    const qtdeProduto = parseFloat($("#txtQuantidadeDesc").val());
    const precoProduto = parseFloat($("#txtPrecoOrig").val().replace(',', ''));
    const valBruto = parseFloat($("#txtValBruto").val().replace(',', ''));
    const percentualDesconto = parseFloat($("#txtPercDesconto").val());
    const precoAtual = $("#txtPrecoDesc").val();
    // const valorAtual = $(campoAlterado);
    // { limpar os demais campos para não influenciarem no cálculo }
    for (let i = 0; i < listaCamposValores.length; i++) {
      const campo = listaCamposValores[i];
      if (campo != campoAlterado) {
        $(campo).val(0);
      }
    }

    let precoLiq = 0;
    let percDesc = 0;
    let totalLiq = 0;
    let valDesc = 0;

    switch (campoAlterado) {
      case "#txtPercDesconto":
        $("#txtValorDesconto").val(
          ArredondarValor((percentualDesconto / 100) * precoProduto * qtdeProduto, 2).toLocaleString("en-US", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2
          })
        );
        valDesc = parseFloat($("#txtValorDesconto").val().replace(',', ''));
        precoLiq = quantidadeCasasDecimaisCampo > 2 ? moeda2float(float2moeda(precoProduto - valDesc / qtdeProduto, quantidadeCasasDecimaisCampo)) : ArredondarValor(precoProduto - valDesc / qtdeProduto, 2);
        $("#txtPrecoLiqDesconto").val(precoLiq.toLocaleString("en-US", {
          maximumFractionDigits: quantidadeCasasDecimaisCampo,
          minimumFractionDigits: quantidadeCasasDecimaisCampo
        }));
        $("#txtPrecoDesc").val(precoLiq.toLocaleString("en-US", {
          maximumFractionDigits: quantidadeCasasDecimaisCampo,
          minimumFractionDigits: quantidadeCasasDecimaisCampo
        }));
        totalLiq = ArredondarValor(ArredondarValor(parseFloat(valBruto), 2) - ArredondarValor(valDesc, 2), 2);
        $("#txtTotalLiq").val(totalLiq.toLocaleString("en-US", {
          maximumFractionDigits: 2,
          minimumFractionDigits: 2
        }));
        break;
      case "#txtPrecoDesc":
        if (parseFloat($("#txtPrecoDesc").val()) != precoProduto) {
          if (parseFloat($("#txtPrecoDesc").val()) > precoProduto) {
            $("#txtPrecoLiqDesconto").val(parseFloat($("#txtPrecoDesc").val()).toLocaleString("en-US", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            }));
            $("#txtTotalLiq").val(ArredondarValor(parseFloat($("#txtPrecoLiqDesconto").val()) * qtdeProduto, 2).toLocaleString("en-US", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            }));
            $("#txtValorDesconto").val(0);
            $("#txtPercDesconto").val(0);
          } else {
            $("#txtValorDesconto").val(
              ArredondarValor(
                precoProduto * qtdeProduto -
                parseFloat($("#txtPrecoDesc").val()) * qtdeProduto,
                2
              ).toLocaleString("en-US", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              })
            );
            valDesc = parseFloat($("#txtValorDesconto").val().replace(',', ''));
            percDesc = ArredondarValor(
              (valDesc /
                valBruto) *
              100,
              2
            ).toLocaleString("en-US", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            });
            $("#txtPercDesconto").val(percDesc.toLocaleString("en-US", {
              maximumFractionDigits: 2,
              minimumFractionDigits: 2
            }));



            if (parseFloat($("#txtPrecoDesc").val()) <= precoProduto) {
              precoLiq = quantidadeCasasDecimaisCampo > 2 ? moeda2float(float2moeda(precoProduto - valDesc / qtdeProduto, quantidadeCasasDecimaisCampo)) : ArredondarValor(precoProduto - valDesc / qtdeProduto, 2);
              $("#txtPrecoLiqDesconto").val(precoLiq.toLocaleString("en-US", {
                maximumFractionDigits: quantidadeCasasDecimaisCampo,
                minimumFractionDigits: quantidadeCasasDecimaisCampo
              }));
              const soma = + precoLiq * qtdeProduto;
              const maisDeDoisCaracteresDecimal = String(soma).substr(String(soma).indexOf('.') + 1, String(soma).length).length > 2;
              const calculoTotal = utilizaImpressoraFiscal && maisDeDoisCaracteresDecimal ? mantemDuasCasasDecimais(soma, 3) : await TruncaDecimais(2, parseFloat(soma));
              $("#txtTotalLiq").val(parseFloat(calculoTotal).toLocaleString("en-US", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              }));
            }
          }
        } else {
          const soma = + precoProduto * qtdeProduto;
          const maisDeDoisCaracteresDecimal = String(soma).substr(String(soma).indexOf('.') + 1, String(soma).length).length > 2;
          const calculoTotal = utilizaImpressoraFiscal && maisDeDoisCaracteresDecimal ? mantemDuasCasasDecimais(soma, 3) : await TruncaDecimais(2, parseFloat(soma));
          $("#txtTotalLiq").val(parseFloat(calculoTotal).toLocaleString("en-US", {
            maximumFractionDigits: 2,
            minimumFractionDigits: 2
          }));
        }
        break;

      case "#txtValorDesconto":
        valDesc = parseFloat($("#txtValorDesconto").val().replace(',', ''));
        percDesc = ArredondarValor(
          (valDesc /
            valBruto) *
          100,
          2
        );
        $("#txtPercDesconto").val(percDesc.toLocaleString("en-US", {
          maximumFractionDigits: 2,
          minimumFractionDigits: 2
        }));
        precoLiq = quantidadeCasasDecimaisCampo > 2 ? moeda2float(float2moeda(precoProduto - valDesc / qtdeProduto, quantidadeCasasDecimaisCampo))
          : ArredondarValor(precoProduto - valDesc / qtdeProduto, 2);
        $("#txtPrecoLiqDesconto").val(precoLiq.toLocaleString("en-US", {
          maximumFractionDigits: quantidadeCasasDecimaisCampo,
          minimumFractionDigits: quantidadeCasasDecimaisCampo
        }));
        $("#txtPrecoLiqDesconto").val(precoLiq.toLocaleString("en-US", {
          maximumFractionDigits: quantidadeCasasDecimaisCampo,
          minimumFractionDigits: quantidadeCasasDecimaisCampo
        }));
        $("#txtPrecoDesc").val(precoLiq.toLocaleString("en-US", {
          maximumFractionDigits: quantidadeCasasDecimaisCampo,
          minimumFractionDigits: quantidadeCasasDecimaisCampo
        }));
        totalLiq = ArredondarValor(
          ArredondarValor(valBruto, 2) -
          ArredondarValor(valDesc, 2),
          2
        );
        $("#txtTotalLiq").val(totalLiq.toLocaleString("en-US", {
          maximumFractionDigits: 2,
          minimumFractionDigits: 2
        }));
        break;
      default:
        break;
    }
  } finally {
    $.LoadingOverlay("hide");
  }
}

async function verificaDescontoMaximoSupervisor(nome, callBack) {
  try {

    const json = await retornaJsonPesquisaPadrao(`{"tabela": "ACESSO_USUARIOS", "camposSelect": ["DESC_MAX"], "where": ["NOME = '${nome}'"] }`);
    if (json) {
      if ((parseFloat($("#txtPercDescontoMoeda").val()) > json[0].DESC_MAX) || (parseFloat($("#txtPercDesconto").val()) > json[0].DESC_MAX)) {
        msgAlerta('Desconto aplicado é maior que o permitido para o supervisor!');
        return false;
      }

      adicionaLogVenda('TVENDALOJA', '', `Autorizado dar desconto pelo usuario ${nome}`, 'Inclusão')
      return callBack();
    }

  } catch (error) {
    console.error(error);
  }
}

async function CalculaDescontoMoeda(
  campoAlterado,
  dPrecoOrig,
  dPercentualDesconto,
  dValorDesconto,
  dPrecoNovo,
  dQuantidade
) {

  const desconto = {
    perc_desconto: dPercentualDesconto,
    val_desconto: dValorDesconto,
    preco_novo: dPrecoNovo,
    preco_orig: dPrecoOrig,
    quantidade: dQuantidade
  };

  const paramCfe = parametrosVenda[19];
  if (paramCfe == "0" || paramCfe != undefined || paramCfe != null) {
    $("#txtValorAcrescMoeda").prop("disabled", true);
    $("#txtPercAcrescMoeda").prop("disabled", true);
  }

  try {
    let response = await requisicao("GET", "/Sisplan/Vendas/V1/Desconto?", `JSON=${encodeURIComponent(JSON.stringify(desconto))}`, null);

    if (!response) {
      $.LoadingOverlay("hide");
      return;
    }

    if (response.status != 200) {
      $.LoadingOverlay("hide");
      msgErro(jsonStr.mensagem);
      return;
    }

    const jsonStr = await response.json();
    const descontoUsuario = await retornaDescontoMaximoUsuario();
    const descontoMoeda = await retornaDescontoMaximoMoeda(
      pegaChave("#txtMoeda")
    );
    if (parseFloat(descontoMoeda ?? 0) > parseFloat(descontoUsuario ?? 0)) {
      if (jsonStr.perc_desconto > descontoMoeda) {
        msgAlerta("Desconto maior que o desconto máximo da moeda!");
        $("#txtValorDescontoMoeda").val("");
        $("#txtPercDescontoMoeda").val("");
        return false;
      }
    }

    if (campoAlterado != "txtValorDescontoMoeda") {
      $("#txtValorDescontoMoeda").val(parseFloat(jsonStr.val_desconto).toFixed(2));
      $("#txtPercDescontoMoeda").val(parseFloat(jsonStr.perc_desconto.toFixed(2)));
    }
    if (campoAlterado != "txtPercDescontoMoeda") {
      $("#txtPercDescontoMoeda").val(parseFloat(jsonStr.perc_desconto.toFixed(2)));
      $("#txtValorDescontoMoeda").val(parseFloat(jsonStr.val_desconto.toFixed(2)));

    }
    let novoValLiquido = ArredondarValor(
      parseFloat(jsonStr.total_liq) +
      parseFloat($("#txtValorAcrescMoeda").val()),
      2
    );

    if (isNaN(novoValLiquido)) {
      $("#txtValorLiquidoMoeda").val(0);
      msgErro("Erro ao calcular valor líquido, tente novamente");
    } else {
      $("#txtValorLiquidoMoeda").val(novoValLiquido, 2);
      $.LoadingOverlay("hide");
    }
  } catch (error) {
    console.error(error);
    $("#txtValorAcrescMoeda").prop("disabled", false);
    $("#txtPercAcrescMoeda").prop("disabled", false);
    $.LoadingOverlay("hide");
  }
}

async function MontaTabelaParcelas(sTipo, sNome, sCnpj, iNumParcelas, valorTotal, fValorPago, iCodCondicao, bAlteracao, bMostraTela, ordemAlteracao) {

  if ($.fn.DataTable.isDataTable('#tabelaParcelas')) {
    $('#tabelaParcelas').DataTable().destroy();
    $('#tabelaParcelas').empty();
  };

  let dataSet = [];
  let dataSetCols = [];
  let columnKeys = ["Nome", "CPF_CNPJ", "Banco", "Agência", "Conta", "Número", "Vencimento", "Valor", "Ordem", "Impressao", "Ler_Cheque"];
  let valorParcela = parseFloat(parseFloat(valorTotal / iNumParcelas).toFixed(2));
  let guardaValor = valorParcela;
  let diferenca = 0;
  let arrayVencimentos;

  if (valorTotal > valorParcela * iNumParcelas || valorTotal < valorParcela * iNumParcelas) {
    diferenca = parseFloat(parseFloat(valorTotal - valorParcela * iNumParcelas).toFixed(2));
  }

  if (bAlteracao != "alteracao") {
    arrayVencimentos = await RetornaVencimentos(iCodCondicao);
  }
  let idColunaValor = 7;
  let idColunaVencimento = 6;
  let arrayColunasInvisiveis = [];
  let bloqNomeCpf = '';
  $("#txt_cred_modo").val(bAlteracao);
  $("#txt_cred_valor_total").val(valorTotal);
  $("#txt_cred_valor_pago").val(fValorPago);

  if (sTipo == "cheque") {
    $("#modalParcelas-titulo").html("Manutenção Cheques");
    arrayColunasInvisiveis.push(8);
  } else {
    $("#modalParcelas-titulo").html("Manutenção Crediário");
    arrayColunasInvisiveis.push(2, 3, 4, 5, 8, 9, 10);
    bloqNomeCpf = 'readonly enabled'
  }

  for (let k in columnKeys) {
    dataSetCols.push({
      title: columnKeys[k],
      data: columnKeys[k],
    });
  }

  dataSetCols[0].render = function (data, type, row) {
    return `<input type="text" value="${data}" class="input-default focus form-control campoNome required" ${bloqNomeCpf} style="min-width: 200px;">`;
  };
  dataSetCols[1].render = function (data, type, row) {
    return `<input type="text" value="${data}" class="input-default focus form-control campoCPFCNPJ required" ${bloqNomeCpf} style="min-width: 150px;">`;
  };
  dataSetCols[2].render = function (data, type, row, meta) {
    return `<input type="text" placeholder="Banco" id="banco_col_${[
      meta.row,
    ]}_row_${[
      meta.col,
    ]}" class="input-default focus form-control validate campoBanco" required="required" readonly> `;
  };
  dataSetCols[3].render = function (data, type, row) {
    return `<input type="text" value="${data}" class="input-default focus form-control campoAgencia required">`;
  };
  dataSetCols[4].render = function (data, type, row) {
    return `<input type="text" value="${data}" class="input-default focus form-control campoConta required">`;
  };
  dataSetCols[5].render = function (data, type, row) {
    return `<input type="text" value="${data}" class="input-default focus form-control campoNumero required">`;
  };

  dataSetCols[9].render = function (data, type, row) {
    return '<button title="Imprimir na impressora de cheque" class="btn btn-primary btnCheque"><i class="fas fa-print"></i></button>';
  };

  dataSetCols[10].render = function (data, type, row) {
    return '<button title="Ler cheque" class="btn btn-primary btnLerCheque"><i class="fas fa-download"></i></button>';
  };

  dataSetCols[idColunaVencimento].type = "date-br";
  dataSetCols[idColunaVencimento].render = function (data, type, row) {
    return `<input type="date" max="2500-12-31" value="${data}" class="input-default focus form-control campoVencimento required">`;
  };

  dataSetCols[idColunaValor].render = function (data, type, row) {
    return `<input type="number" step="0.01" value="${parseFloat(data).toFixed(
      2
    )}" class="input-default focus form-control campoValor required">`;
  };

  if (bAlteracao == "alteracao") {
    // tabela por trás para controlar as condições de pagamentos e alterções de data/valor feito pelo usuario.
    let totalParcelas = $("#tabelaParcelasGeradas").DataTable().rows().count();

    for (let index = 0; index < totalParcelas; index++) {
      const parcela = $("#tabelaParcelasGeradas").DataTable().row(index).data();
      if (parcela[0] == ordemAlteracao) {
        dataSet.push({
          Nome: parcela[1],
          CPF_CNPJ: parcela[2],
          Banco: parcela[3],
          Agência: parcela[4],
          Conta: parcela[5],
          Número: parcela[6],
          Vencimento: parcela[7],
          Valor: parcela[8],
          Ordem: ordemAlteracao,
          Impressao: "",
        });
      }
    }
  } else {
    for (let i = 0; i < iNumParcelas; i++) {
      if (diferenca > 0 && i == 0) {
        valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
        diferenca = 0;
      } else {
        valorParcela = guardaValor;
      }
      if (diferenca < 0 && i == iNumParcelas - 1) {
        valorParcela = (valorParcela + parseFloat(diferenca)).toFixed(2);
      }
      let indice = $("#tabelaCondicoesDePagamento").DataTable().rows().count();
      while (
        $("#tabelaCondicoesDePagamento")
          .DataTable()
          .column(0)
          .data()
          .indexOf(indice) >= 0
      ) {
        indice += 1;
      }
      dataSet.push({
        Nome: sNome,
        CPF_CNPJ: sCnpj,
        Banco: "",
        Agência: "",
        Conta: "",
        Número: "",
        Vencimento: arrayVencimentos[i],
        Valor: valorParcela,
        Ordem: indice,
        Impressao: "",
      });
    }
  }

  let tabelaParcelas = $("#tabelaParcelas").DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    autowidth: true,
    columnDefs: [
      {
        targets: arrayColunasInvisiveis,
        visible: false,
      },
    ],
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
    columns: dataSetCols,
    data: dataSet,
  });

  if (bMostraTela) {
    $("#modalParcelas").modal("show");
  } else {
    $("#btn_confirmar_cred").trigger("click");
  }
  // faz o rateio dos totais das outros
  $(".campoValor").on("change", function () {
    $(this).addClass("alterado");
    let qtdeParaRatear =
      $(".campoValor").length - $(".campoValor.alterado").length;
    let valorAlterado = 0;
    for (let i = 0; i < $(".campoValor.alterado").length; i++) {
      valorAlterado =
        parseFloat(valorAlterado.toFixed(2)) +
        parseFloat(
          parseFloat($($(".campoValor.alterado")[i]).val()).toFixed(2)
        );
    }
    if (valorAlterado > parseFloat($("#txt_cred_valor_total").val())) {
      msgAlerta("valor da parcela não pode ser maior que o valor total.");
      $("#btn_dividir_valor").trigger("click");
    } else {
      valorParaRatear = $("#txt_cred_valor_total").val() - valorAlterado;
      let valorRateio = parseFloat(valorParaRatear / qtdeParaRatear).toFixed(2);
      for (let i = 0; i < $(".campoValor").length; i++) {
        if (!$($(".campoValor")[i]).hasClass("alterado")) {
          $($(".campoValor")[i]).val(valorRateio);
        }
      }
    }
  });

  for (let i = 0; i < $(".campoBanco").length; i++) {
    $(`#banco_col_${i}_row_2`).pesquisa(
      `#banco_col_${i}_row_2`,
      "BANCO",
      "NOME_BANCO",
      '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"], "where": null}',
      "Pesquisa Banco",
      "cadban"
    );
  }

  $(".campoBanco").on("blur", function () {
    for (let i = 0; i < $(".campoBanco").length; i++) {
      if ($($(".campoBanco")[i]).val() == "") {
        $($(".campoBanco")[i]).val($(this).val());
      }
    }
  });

  $(".campoAgencia").on("blur", function () {
    const bLeu = preencheDadosCheque(this);
    if (bLeu) {
      for (let i = 0; i < $(".campoAgencia").length; i++) {
        if ($($(".campoAgencia")[i]).val() == "") {
          $($(".campoAgencia")[i]).val($(this).val());
        }
      }
    }
  });

  $('.campoAgencia').keydown(function (e) {
    if (e.which === 13) {
      e.preventDefault();
      $('.campoAgencia').trigger('blur');
    }
  });

  $(".campoConta").on("blur", function () {
    const bLeu = preencheDadosCheque(this);
    if (bLeu) {
      for (let i = 0; i < $(".campoConta").length; i++) {
        if ($($(".campoConta")[i]).val() == "") {
          $($(".campoConta")[i]).val($(this).val());
        }
      }
    }
  });

  $('.campoConta').keydown(function (e) {
    if (e.which === 13) {
      e.preventDefault();
      $('.campoConta').trigger('blur');
    }
  });

  $(".campoNumero").on("blur", function () {
    const bLeu = preencheDadosCheque(this);
    if (bLeu) {
      if ($(this).val == "") {
        return;
      }
      for (let i = 0; i < $(".campoNumero").length; i++) {
        if ($($(".campoNumero")[i]).val() == "") {
          $($(".campoNumero")[i]).val(parseInt($(this).val()) + i);
        }
      }
    }
  });

  $('.campoNumero').keydown(function (e) {
    if (e.which === 13) {
      e.preventDefault();
      $('.campoNumero').trigger('blur');
    }
  });

  $(".btnCheque").on("click", async function () {
    try {
      try {
        $(this).attr("disabled", "true");
        $.LoadingOverlay("show");
        const posicao = $(this).parents("tr")[0].rowIndex - 1;
        await imprimirCheque(posicao);
      } finally {
        $.LoadingOverlay("hide");
        $(this).removeAttr("disabled");
      }
    } catch (error) {
      msgErro("Erro ao imprimir cheque.");
      $(this).removeAttr("disabled");
    }
  });

  $(".btnLerCheque").on("click", async function () {
    try {
      try {
        $(this).attr("disabled", "true");
        $.LoadingOverlay("show");
        const posicao = $(this).parents("tr")[0].rowIndex - 1;
        await LerCheque(posicao);
      } finally {
        $.LoadingOverlay("hide");
        $(this).removeAttr("disabled");
      }
    } catch (error) {
      msgErro("Erro ao ler cheque.");
      $(this).removeAttr("disabled");
    }
  });

  // async function imprimirCheque(posicao) {
  //   const url = `/ImprimirCheque?`;
  //   const sBanco = pegaChave($(".campoBanco")[posicao]);
  //   const sCidade = await retornaCidade();
  //   const sFavorecido = sessionStorage
  //     .getItem("g_nome_empresa_logada")
  //     .substring(6);
  //   let sValor = $($(".campoValor")[posicao]).val().replace(".", ",");
  //   const sData = moment($($(".campoVencimento")[posicao]).val()).format(
  //     "DD/MM/YYYY"
  //   );
  //   const params = `BANCO=${sBanco}&CIDADE=${sCidade}&FAVORECIDO=${sFavorecido}&VALOR=${sValor}&DATA=${sData}`;
  //   try {
  //     let response = await requisicao_ecf("POST", url, params, "", null);

  //     if (!response) {
  //       msgErro("Não foi possível imprimir o cheque.");
  //       return;
  //     }

  //     if (response.status != 200) {
  //       msgErro("Não foi possível imprimir o cheque.");
  //       return;
  //     }
  //   } catch (error) {
  //     console.error(error);
  //     msgErro("Não foi possível imprimir o cheque.");
  //   }
  // }

  setTimeout(() => {
    $("#tabelaParcelas").DataTable().columns.adjust().draw(false);
  }, 200);
}

async function retornaBotaoOpcoes() {
  const permiteAlterarPreco = parametrosVenda[43] == 2;
  const bUsaIntegraçãoITAG = parametrosVenda[60] == 1;
  return (
    '<div style="text-align:center;"> ' +
    '   <div class="dropdown"> ' +
    '    <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
    "    </button> " +
    '    <div class="dropdown-menu"> ' +
    '       <a class="dropdown-item btnInfoAdc" href="">Informações adicionais</a>' +
    '       <div class="dropdown-divider"></div>' +
    '       <a class="dropdown-item btnDesconto" href="">Desconto</a> ' +
    '       <div class="dropdown-divider"></div>' +
    `${(parametrosVenda[35]) == 1
      ? '       <a class="dropdown-item btnQuantidade" href="">Quantidade</a> ' +
      '       <div class="dropdown-divider"></div>'
      : ""
    }` +
    `${permiteAlterarPreco
      ? '       <a class="dropdown-item btnAlterarPreco" href="">Alterar Preço</a> ' +
      '       <div class="dropdown-divider"></div>'
      : ""
    }` +
    // `${!bUsaIntegraçãoITAG
    //   ?
    '       <a class="dropdown-item btnExcluir" href="">Excluir</a>' +
    "    </div>" +
    "  </div>" +
    "</div>"
    //   :
    //   ""
    // }`
  );
}

function retornaBotaoOpcoesCondicao(iTipoMoeda) {
  let botao =
    '<div style="text-align:center;"> ' +
    '   <div class="dropdown"> ' +
    '    <button class="btn btn-info btn-sm dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
    "      Opções" +
    "    </button> " +
    '    <div class="dropdown-menu"> ';
  if (iTipoMoeda == "1" || iTipoMoeda == "2") {
    // cheque e crediário
    botao =
      `${botao}<a class="dropdown-item btn-alterar-parcelas" href="" >Alterar Parcelas</a>` +
      `<div class="dropdown-divider"></div>`;
  }
  botao =
    `${botao} <a class="dropdown-item btnExcluir" href="">Excluir</a>` +
    `    </div>` +
    `  </div>` +
    `</div>`;
  return botao;
}

function adicionaItens(arrayDeItens) {
  // tratar NaN por garantia, houve caso que tinha desconto nan...
  arrayDeItens[5] = arrayDeItens[5] || 0;
  arrayDeItens[6] = arrayDeItens[6] || 0;

  let table = $('#tabelaItens').DataTable();

  if (arrayDeItens[29]) {
    const newRow = table.row.add(arrayDeItens).draw(false).node();
    $(newRow).addClass('linha-promocao');
  } else {
    table.row.add(arrayDeItens).draw(false);
  }

  // $("#tabelaItens").DataTable().row.add(arrayDeItens).draw(false);
  let $scrollBody = $($("#tabelaItens").DataTable().table().node()).parent();
  $scrollBody.scrollTop($scrollBody.get(0).scrollHeight);
}

function adicionaCondicoesDePagamento(arrayCondicoesPagamentos) {
  try {
    $("#tabelaCondicoesDePagamento")
      .DataTable()
      .row.add(arrayCondicoesPagamentos)
      .draw(false);
    let $scrollBody = $(
      $("#tabelaCondicoesDePagamento").DataTable().table().node()
    ).parent();
    $scrollBody.scrollTop($scrollBody.get(0).scrollHeight);
  } catch (error) {
    console.error(error);
  }
}

function listaParcelasCondicao(iOrdem) {
  let arrayParcelasCondicao = [];
  for (
    let index = 0;
    index < $("#tabelaParcelasGeradas").DataTable().rows().count();
    index++
  ) {
    let data = $("#tabelaParcelasGeradas").DataTable().row(index).data();
    if (data[0] == iOrdem) {
      const parcela = {
        CPFSACADO: data[2], // verificar aqui se está pegando do lugar correto
        NOMESACADO: data[1],
        NRCONTA: data[5],
        VENCIMENTO: `${data[7]}T00:00:00Z`,
        BANCO: pegaChave(data[3]),
        NRAGENCIA: data[4],
        NUMERO: data[6],
        VALOR: data[8],
        VALORPAGO: data[8],
      };
      arrayParcelasCondicao.push(parcela);
    }
  }
  return arrayParcelasCondicao;
}

function listaFormaPgto() {
  let arrayCondicoes = [];
  for (
    let index = 0;
    index < $("#tabelaCondicoesDePagamento").DataTable().rows().count();
    index++
  ) {
    const data = $("#tabelaCondicoesDePagamento").DataTable().row(index).data();
    const condicao = {
      CodMoedaECF: "1", // PEGAR DO BANCO
      DescricaoMoeda: $("#tabelaCondicoesDePagamento")
        .DataTable()
        .row(0)
        .data()[1]
        .substring(
          $("#tabelaCondicoesDePagamento")
            .DataTable()
            .row(0)
            .data()[1]
            .indexOf("- ") + 3
        ),
      Valor: data[3],
      ImprimeGR: false,
    };
    arrayCondicoes.push(condicao);
  }
  return arrayCondicoes;
}

async function listaCondicoes() {
  let arrayCondicoes = [];
  for (
    let index = 0;
    index < $("#tabelaCondicoesDePagamento").DataTable().rows().count();
    index++
  ) {
    const data = $("#tabelaCondicoesDePagamento").DataTable().row(index).data();
    const condicao = {
      condiVenda: 0,
      codCondicao: data[7],
      codMoeda: data[6],
      perc_Desconto: data[10],
      perc_Juros: 0,
      valor_Desc: data[11],
      valor_Juros: 0,
      nsu: data[13],
      dados_Tef: "",
      bandeira: data[12],
      antecipacoes: data[9],
      antecipacoesPresente: data[14],
      parcelas: listaParcelasCondicao(data[0]),
      descricaoMoeda: data[1],
      descricaoCondicao: data[2],
      valor: data[3],
      valorPago: data[4],
      tipomoeda: data[15],
      adicional: {
        autorizacao: data[16]
      }
    };
    arrayCondicoes.push(condicao);
  }
  return arrayCondicoes;
}

async function listaItensDev(parametroUsaProduto, utilizaBarraLog) {
  let arrayItens = [];
  for (let index = 0; index < $('#tabelaItens').DataTable().rows().count(); index++) {
    const data = $('#tabelaItens').DataTable().row(index).data();
    let itens = {};

    itens.codigo = data[0];
    itens.descricao = data[1];
    itens.barra = data[8];
    itens.cor = data[9];
    itens.desc_Cor = data[11];
    itens.tam = data[10];
    itens.deposito = pegaChave('#txtDeposito', itens.DEPOSITO);
    itens.lote = data[19] == 'P' ? '000000' : data[18]; // verifica se usa material se nao usa lote padrão
    itens.qualidade = data[12];
    itens.promocao = false;
    itens.tipo = data[19];
    itens.codRep = data[20];
    itens.dt_Inclusao = `${formataData(new Date())}T00:00:00Z`;
    itens.quantidade = parseFloat(data[2]);
    // itens.valor = await TruncaDecimais(2, data[3]);
    itens.valor = (+quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda(data[3], quantidadeCasasDecimaisCampo))
      : await TruncaDecimais(2, data[3]);
    itens.total = await TruncaDecimais(2, data[2] * data[3]);
    itens.total_Liq = parseFloat(data[7]);
    itens.valor_Desc = parseFloat(data[6]);
    itens.desconto = itens.total - itens.total_Liq;
    itens.perc_Icms = 0;
    itens.preco_Liq = parseFloat(data[4]);
    itens.perc_Desc = parseFloat(data[5]);
    itens.preco_Custo = 0;
    itens.iD_Estoque = data[13];
    itens.codVenDev = data[14];
    itens.concatenacao = `${data[0]} - ${data[9]} - ${data[10]} - ${data[12]}`;
    itens.presente = data[17];
    itens.lote = data[18];
    itens.barras_log = await retornaBarraLog(data[0], data[9], data[10], utilizaBarraLog);
    itens.unidade = data[21];

    arrayItens.push(itens);
  }
  return arrayItens;
};

async function rotinaCliqueConfirmarCFE(bFinalizaVenda = true, codcli, codven) {
  let bErro = false;
  let sErro = [];
  const bAutomatico = parametrosVenda[18];

  if ($('#txtCpfCFe').val() == '') {
    if ((bFinalizaVenda) && ((bAutomatico == 3) || (bAutomatico == 4))) {
      bErro = true;
      sErro.push('Necessário informar um CPF/CNPJ.');
    } else {
      msgAlerta('Necessário informar um CPF/CNPJ.');
      return;
    }
  }

  if ($('#txtNaturezaCFe').val() == '' && $('#txtOperacaoCFe').val() == '') {
    if ((bFinalizaVenda) && ((bAutomatico == 3) || (bAutomatico == 4))) {
      bErro = true;
      sErro.push('Necessário informar uma natureza ou operação fiscal.');
    } else {
      msgAlerta('Necessário informar uma natureza ou operação fiscal.');
      return;
    }
  }

  if (bFinalizaVenda) {
    await RotinaFinalizarVenda(false, true, false, false);
  }

  async function retornaObjetoCfe(sId) {
    try {
      let objeto = await buscaCFEVenda(sId);
      return objeto[0];
    } catch (error) {
      msgErro('Erro ao retornar objeto ');
    }
  }

  try {
    $.LoadingOverlay("show");
    // finaliza venda
    try {
      if (!await testeConexao()) {
        msgAlerta('Não está conectado a Api Local!');
        return;
      }
      let natureza = pegaChave('#txtNaturezaCFe');
      const operacao = pegaChave('#txtOperacaoCFe');
      let cpf = $('#txtCpfCFe').val();
      let obs = $('#txtInfoAdicionaisCFe').val();
      let caixa = pegaChave(sessionStorage.getItem('g_caixa_logado'));
      let codvenda = codven;
      let codcliente = codcli;
      let url = '/Sisplan/cfe/v1/converterVenda?';
      let params = `CNPJ=${cpf}&NATUREZA=${natureza}&MENSAGEM=${obs}&COD_VEN=${codvenda}&CAIXA=${caixa}&CODCLI=${codcliente}&OPERACAO=${operacao}`;
      let response = await requisicao('POST', url, params, '', 30000);

      let jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }
      // pega o objeto para enviar para o sat
      let objeto = await retornaObjetoCfe(jsonStr);

      // transmite pro sat e gera chave
      let bSucesso = await TransmiteCfe(objeto);

      if (bSucesso) {
        setTimeout(() => {
          if (bFinalizaVenda) {
            RotinaFinalizarVenda();
          }
          window.location.href = `${BASE_URI}/cfe`;
        }, 6000);
      } else {
        toastr.error(
          `Erro ao gerar CFe`,
          'Erro', {
          toastClass: 'alert',
          iconClasses: {
            error: 'alert-error',
            info: 'alert-info',
            success: 'alert-success',
            warning: 'alert-warning'
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() { }
        }
        ).css({
          "margin-top": "20%",
          "width": "500px",
          "max-width": "500px"
        });
      }
    } catch (error) {
      console.error(error);
    }
  } finally {
    $.LoadingOverlay("hide");
  }
}

$('#btn_confirmar_cfe').on('click', async function () {
  await rotinaCliqueConfirmarCFE();
});

async function listaItens(parametroUsaProduto, utilizaBarraLog) {
  let arrayItens = [];
  const utilizaImpressoraFiscal = parametrosVenda[8];
  for (
    let index = 0;
    index < $("#tabelaItens").DataTable().rows().count();
    index++
  ) {
    let data = $("#tabelaItens").DataTable().row(index).data();
    let itens = {};
    itens.codigo = data[0];
    itens.descricao = data[1].split(" - ")[1];
    itens.barra = data[9];
    itens.cor = data[10];
    itens.desc_Cor = data[12];
    itens.tam = data[11];
    itens.deposito = pegaChave("#txtDeposito");
    itens.lote = data[19] == "P" ? "000000" : data[18]; // verifica se usa material se nao usa lote padrão
    itens.qualidade = data[13];
    itens.promocao = data[29];
    itens.tipo = data[19];
    itens.codRep = data[26];
    itens.dt_Inclusao = `${formataData(new Date())}T00:00:00Z`;
    itens.quantidade = parseFloat(data[2]);
    itens.valor = (+quantidadeCasasDecimaisCampo > 2) ? moeda2float(float2moeda(data[3], quantidadeCasasDecimaisCampo))
      : await TruncaDecimais(2, data[3]);
    // itens.valor = quantidadeCasasDecimaisParametro > 2 ? 
    //                                                    : await TruncaDecimais(2, data[3]);

    const soma = +(data[2] * data[3]).toFixed(4);
    const maisDeDoisCaracteresDecimal = String(soma).substr(String(soma).indexOf('.') + 1, String(soma).length).length > 2;
    itens.total = utilizaImpressoraFiscal == '1' && maisDeDoisCaracteresDecimal ? mantemDuasCasasDecimais(soma, 3) : TruncaDecimaisNova(2, parseFloat(soma));

    // itens.total = await TruncaDecimais(2, data[2] * data[3]);
    itens.total_Liq = await TruncaDecimais(2, data[7]);
    itens.valor_Desc = parseFloat(data[6]);
    itens.desconto =
      itens.total - itens.total_Liq <= 0 ? 0 : itens.total - itens.total_Liq;
    itens.perc_Icms = 0;
    itens.preco_Liq = parseFloat(data[4]);
    itens.perc_Desc = parseFloat(data[5]);
    itens.preco_Custo = 0;
    itens.iD_Estoque = data[14];
    itens.codVenDev = data[15];
    itens.concatenacao = `${data[0]} - ${data[10]} - ${data[11]}`;
    itens.presente = data[17];
    itens.ValorDesc_RegraPromo = data[20] != undefined ? data[20] : 0;
    itens.BaseDesc_RegraPromo = data[21] != undefined ? data[21] : 0;
    itens.PercDesc_RegraPromo = data[22] != undefined ? data[22] : 0;
    itens.pedido = data[23];
    itens.ordem_ped = data[24];
    itens.caixa = data[25];
    itens.dt_Inclusao = data[27];
    itens.unidade = data[28];
    itens.barras_log = await retornaBarraLog(data[0], data[10], data[11], utilizaBarraLog);
    itens.precoOrigOld = data[30]
    arrayItens.push(itens);
  }
  return arrayItens;
}

async function retornaBarraLog(sCodigo, sCor, sTam, utilizaBarraLog) {
  const barras = utilizaBarraLog
    ? listaBarrasBipadas
      .filter(
        (item) =>
          item.codigo == sCodigo && item.cor == sCor && item.tam == sTam
      )
      .map((item) => item.barra)
    : [];
  return barras;
}

async function AplicaDescontoVenda(descontoDeCupom = -1) {
  $.LoadingOverlay("show");
  try {
    const descontoMaximoUsuario = await retornaDescontoMaximoUsuario();
    let table = $("#tabelaItens").DataTable();
    let data = table.rows()[0].length;
    let percDesconto = (descontoDeCupom >= 0) ? descontoDeCupom
      : $("#txtDesconto").val();
    let soma = 0;
    let valor = 0;
    let somaPreco = 0;
    let total = 0;
    let totalQtd = 0;
    let valorDesconto = $('#txtValDesconto').val();
    let precoItem = $('#txtPrecoItem').val();
    let arrayData = [];
    let valorTotal = ArredondarValor($("#tabelaItens").DataTable().column(4, {}).data().sum(), 2);

    if (parseFloat(percDesconto) > 99) {
      msgAlerta("Desconto não pode ser maior que 99%");
      return;
    }

    if (parseFloat(percDesconto) < 0) {
      msgAlerta("Desconto não pode ser menor que 0%");
      return;
    }

    async function aplicaValoresOriginais(i) {
      arrayData = table.row(i).data();
      arrayData[3] = arrayData[30];
      arrayData[4] = arrayData[3];
      arrayData[7] = arrayData[4] * arrayData[2];
      arrayData[5] = 0;
      arrayData[6] = 0;
      table.row(i).data(arrayData);
    }
    let exibirMensagem = true;
    for (let i = 0; i < data; i++) {
      if (percDesconto == 0 && valorDesconto == 0 && precoItem == 0) {
        if (exibirMensagem) {
          await new Promise((resolve) => {
            msgAlerta('Nenhum desconto aplicado, ao confirmar, os itens receberão seus valores originais. Deseja continuar?', async () => {
              await aplicaValoresOriginais(i);
              resolve();
            }, () => { $.LoadingOverlay('hide') });
          });
          exibirMensagem = false;
        } else {
          await aplicaValoresOriginais(i);
        }
      } else if (valorDesconto != 0) {
        async function AplicaDescontoItem() {
          arrayData = table.row(i).data();
          let valorOriginal = arrayData[3];

          if (valorDesconto == valorTotal) {
            await aplicaValoresOriginais(i);
            return msgAlerta(`Valor de desconto não pode ser o valor integral dos itens, verifique!`)
          }

          soma = valorOriginal - valorDesconto;


          if (valorDesconto > valorTotal || soma < 0) {
            await aplicaValoresOriginais(i);
            return msgAlerta(`Existem valores de desconto maiores que os valores dos itens, impossível aplicar o desconto de R$${valorDesconto}!`)
          }
          total = soma * arrayData[2];
          percDesconto = ((valorDesconto * 100)) / valorOriginal;
          arrayData[3] = valorOriginal > soma ? arrayData[3] : soma;
          arrayData[4] = arrayData[3] - valorDesconto;
          arrayData[5] = total;
          arrayData[6] = valorDesconto;
          arrayData[7] = total;
          $("#tabelaItens").DataTable().row(i).data(arrayData).draw(false);
        }

        if (parseFloat(percDesconto) > parseFloat(descontoMaximoUsuario) && descontoMaximoUsuario > 0) {
          await senhaSupervisor(
            `Desconto de ${percDesconto}% no item, máximo do usuário é de ${descontoMaximoUsuario}%.`,
            verificaDescontoMaximoSupervisor,
            AplicaDescontoItem,
            true,
          );
        } else {
          let bSenhaSupervisor = parametrosVenda[9];
          if (bSenhaSupervisor == "1") {
            await senhaSupervisor(
              `Desconto de R$ ${valorDesconto} aplicado.`,
              AplicaDescontoItem
            );
          } else {
            await AplicaDescontoItem();
          }
        }
      } else if (precoItem != 0) {
        const arrayData = table.row(i).data();
        if (parametrosVenda[43] == '2') {
          arrayData[3] = await TruncaDecimais(2, precoItem); // preço orig
        }
        arrayData[4] = await TruncaDecimais(2, precoItem); // novo preço
        arrayData[5] = 0;

        arrayData[6] = ($('#txtValDesconto').val() / arrayData[3] * 100);
        arrayData[7] = parseFloat(parseFloat(arrayData[4] * arrayData[2]).toFixed(2)); // novo total
        table.row(i).data(arrayData).draw(false);
      } else {
        valor = table.row(i).data()[3];
        soma = parseFloat(valor) - (parseFloat(valor) * percDesconto) / 100;
        arrayData = table.row(i).data();

        total = soma * arrayData[2];

        totalQtd = await TruncaDecimais(2, total, totalQtd);
        somaPreco = quantidadeCasasDecimaisCampo > 2 ? moeda2float(float2moeda(soma, quantidadeCasasDecimaisCampo))
          : await TruncaDecimais(2, soma, somaPreco);

        arrayData[4] = somaPreco;
        arrayData[7] = totalQtd;
        arrayData[5] = percDesconto;
        arrayData[6] = (valor - soma) * arrayData[2];
        table.row(i).data(arrayData);
      }
    }
  } catch (error) {
    msgErro("Erro ao aplicar desconto!");
    console.error(error);
  } finally {
    await atualizaTotalVenda();
    atualizaSaldoAPagar();
    atualizaTotaisPagto();
    $('[data-toggle="tooltip"]').tooltip();
    $("#modalDescontoTotal").modal("hide");
    $.LoadingOverlay("hide");
  }
}

$("#btnDescontoTotal").on("click", async function () {
  let total = $("#tabelaItens").DataTable().column(7, {}).data().sum();
  if ($('#txtCupomDesconto').val() !== '') {
    msgAlerta("Venda com cupom de Desconto aplicado, impossível aplicar desconto.");
    return;
  }
  if (parametrosVenda[43] != '0') {
    $("#txtPrecoItem").attr("disabled", false).attr("readonly", false);
  } else {
    $("#txtPrecoItem").attr("disabled", true).attr("readonly", true);
  }
  $("#txtValorTotal").val(total.toFixed(2));
  $("#modalDescontoTotal").modal("show");
});

$('#modalDescontoTotal').on('shown.bs.modal', function () {
  $("#txtDesconto").attr("disabled", false).attr("readonly", false);
  $("#txtValDesconto").attr("disabled", false).attr("readonly", false);
})

$("#btnAplicaDesconto").on("click", async function () {
  $('#txtPrecoItem').trigger('blur');
  let bSenhaSupervisor = parametrosVenda[9];
  if (bSenhaSupervisor == "1") {
    let valorDesconto =
      parseFloat($("#subtotal_venda").html().split(";")[1].replace(",", ".")) -
      parseFloat($("#txtValorTotal").val());
    await senhaSupervisor(
      `Desconto de R$${valorDesconto.toFixed(2)} aplicado.`,
      AplicaDescontoVenda
    );
  } else {
    const percDesconto = $("#txtDesconto").val();
    const descontoMaximoUsuario = await retornaDescontoMaximoUsuario();
    if (descontoMaximoUsuario != "" && descontoMaximoUsuario > 0) {
      if (parseFloat(percDesconto) > parseFloat(descontoMaximoUsuario)) {
        await senhaSupervisor(
          `Desconto de ${percDesconto}% na venda, máximo do usuário é de ${descontoMaximoUsuario}%.`,
          verificaDescontoMaximoSupervisor, AplicaDescontoVenda, true
        );
      } else {
        await AplicaDescontoVenda();
      }
    } else {
      await AplicaDescontoVenda();
    }
  }
});

async function atualizaTotalVenda() {
  let valorTotal = 0;

  utilizaImpressoraFiscal = parametrosVenda[8];

  $("#tabelaItens")
    .DataTable()
    .data()
    .toArray()
    .forEach((item) => {
      const soma = +(item[3] * item[2]).toFixed(4);
      const maisDeDoisCaracteresDecimal = String(soma).substr(String(soma).indexOf('.') + 1, String(soma).length).length > 2;
      valorTotal += utilizaImpressoraFiscal == 1 && maisDeDoisCaracteresDecimal ? mantemDuasCasasDecimais(soma, 3) : parseFloat(parseFloat(soma).toFixed(2));
    });
  let totalQuantidade = $("#tabelaItens")
    .DataTable()
    .column(2, {})
    .data()
    .sum();
  let totalLiquido = parseFloat($("#tabelaItens").DataTable().column(7, {}).data().sum());

  try {
    let totalAntecipacao =
      $("#tabelaAntecipacoes").length > 0
        ? parseFloat(
          parseFloat(
            $("#tabelaAntecipacoes").DataTable().column(4, {}).data().sum()
          ).toFixed(2)
        )
        : 0;
    let totalAntecipacaoPago =
      $("#tabelaAntecipacoes").length > 0
        ? parseFloat(
          parseFloat(
            $("#tabelaAntecipacoes").DataTable().column(5, {}).data().sum()
          ).toFixed(2)
        )
        : 0;
    let valorTotalItens = $("#tabelaItens")
      .DataTable()
      .column(7, {})
      .data()
      .sum();
    let saldoAntecipacao = totalAntecipacao - totalAntecipacaoPago;
    let saldoGeral = valorTotalItens - saldoAntecipacao;
    if (saldoGeral < 0) {
      saldoGeral = 0;
    }
    $("#credito_cliente").html(
      parseFloat(saldoAntecipacao).toLocaleString("pt-BR", {
        style: "currency",
        currency: "BRL",
      })
    );

    const creditoClienteSaldo = saldoAntecipacao - totalLiquido >= 0 ? saldoAntecipacao - totalLiquido : 0;
    $("#credito_cliente_saldo").html(parseFloat(creditoClienteSaldo).toLocaleString('pt-BR', {
      style: 'currency',
      currency: 'BRL'
    }));

    atualizaCreditoConformeUltimaDevolucao();

    $("#saldo_geral").html(
      parseFloat(saldoGeral).toLocaleString("pt-BR", {
        style: "currency",
        currency: "BRL",
      })
    );
  } catch (error) {
    console.error(error);
  }

  $("#subtotal_venda").html(
    parseFloat(totalLiquido).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  totalQuantidade = ArredondarValor(totalQuantidade, 2);

  let total_original = 0;
  let total_desconto = 0;

  const soma = $('#tabelaItens').DataTable().data().toArray().reduce((total, item) => total + parseFloat(item[3] * item[2]), 0);
  const maisDeDoisCaracteresDecimal = String(soma).substr(String(soma).indexOf('.') + 1, String(soma).length).length > 2;
  total_original += utilizaImpressoraFiscal == 1 && maisDeDoisCaracteresDecimal ? mantemDuasCasasDecimais(soma, 3) : parseFloat(parseFloat(soma).toFixed(2));

  total_desconto = ArredondarValor($('#tabelaItens').DataTable().data().toArray().reduce(
    (total, item) =>
      total +
      parseFloat(item[3] * item[2]) - (item[4] * item[2]),
    0), 2) *
    -1;

  $("#total_desc").html(
    parseFloat(isNaN(total_desconto) || total_desconto > 0 ? 0 : total_desconto).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#total_orig").html(
    parseFloat(isNaN(total_original) ? 0 : total_original).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#total_itens").html(totalQuantidade);

  $("#txtTotalQtde").html(totalQuantidade);

  $("#txtTotalVenda").html(
    parseFloat(valorTotal).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  if ($("#tabelaItens").DataTable().rows()[0].length > 0) {
    $("#btnDescontoTotal").removeClass("d-none");
  }
}

async function atualizaCreditoConformeUltimaDevolucao() {
  const trazerApenasUltimaAntecipacao = parametrosVenda[48] == '1';
  const vendaDevolvida = codven_devolucao;
  if (trazerApenasUltimaAntecipacao && vendaDevolvida != '') {
    const totalDevolvido = $('#tabelaAntecipacoes').DataTable().data().toArray().reduce((total, antecipacao) => total += antecipacao.NRO_CUPOM == vendaDevolvida ? antecipacao.VALOR : 0, 0);
    $("#credito_cliente").html(parseFloat(totalDevolvido).toLocaleString('pt-BR', {
      style: 'currency',
      currency: 'BRL'
    }));

    const valorTotalItens = $("#tabelaItens")
      .DataTable()
      .column(7, {})
      .data()
      .sum();
    let saldoGeral = valorTotalItens - totalDevolvido;
    if (saldoGeral < 0) {
      saldoGeral = 0;
    }

    const creditoClienteSaldo = totalDevolvido - valorTotalItens >= 0 ? totalDevolvido - valorTotalItens : 0;
    $("#credito_cliente_saldo").html(parseFloat(creditoClienteSaldo).toLocaleString('pt-BR', {
      style: 'currency',
      currency: 'BRL'
    }));

    $("#saldo_geral").html(parseFloat(saldoGeral).toLocaleString('pt-BR', {
      style: 'currency',
      currency: 'BRL'
    }));
  }
}

function atualizaTotaisPagto() {
  let total = $("#tabelaCondicoesDePagamento").DataTable().column(3, {}).data().sum();
  let totalPagamento = $("#tabelaCondicoesDePagamento").DataTable().column(4, {}).data().sum();
  let totalDesconto = $("#tabelaCondicoesDePagamento").DataTable().column(11, {}).data().sum() + $("#tabelaItens").DataTable().column(6, {}).data().sum();
  let saldo = totalPagamento - total;

  $("#txtTotaisPagamentos").html(
    parseFloat(totalPagamento).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#txtTotaisDesconto").html(
    parseFloat(totalDesconto).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#txtTotaisTroco").html(
    parseFloat(saldo).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#txtTotaisTotal").html(
    parseFloat(total).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );
}

function atualizaSaldoAPagar() {
  const valFrete = parseFloat($("#txtFrete").val());
  const saldoItens = parseFloat($("#subtotal_venda").html().substring(8).replace(".", "").replace(",", ".")) + valFrete;
  const valPagtos = $("#tabelaCondicoesDePagamento").DataTable().column(3, {}).data().sum();
  const valDesconto = $("#tabelaCondicoesDePagamento").DataTable().column(11, {}).data().sum();

  let saldo = saldoItens - (valPagtos + valDesconto);
  if (saldo < 0) {
    saldo = 0;
  }

  $("#txtsaldo_a_pagar").html(
    parseFloat(saldo).toLocaleString("pt-BR", {
      style: "currency",
      currency: "BRL",
    })
  );

  $("#txtValorParcela").val($("#txtsaldo_a_pagar").html().substring(8).replace(".", "").replace(",", "."));
  $("#txtValorParcela").trigger("change");
  if (saldo == 0) {
    // não deixa mais colocar formas de pagto.
    $("#txtMoeda").prop("disabled", true);
    $("#txtBaixaAntecipacao").prop("disabled", true);
    $("#txtTipoMoeda").prop("disabled", true);
    $("#txtCondicaoDePagamento").prop("disabled", true);
    $("#txtValorParcela").prop("disabled", true);
    $("#txtNrParcelas").prop("disabled", true);
    $("#btn-moeda").prop("disabled", true);
    $("#btn-CondicaoDePagamento").prop("disabled", true);
    $("#txtPercDescontoMoeda").prop("disabled", true);
    $("#txtValorDescontoMoeda").prop("disabled", true);
    $("#txtPercAcrescMoeda").prop("disabled", true);
    $("#txtValorAcrescMoeda").prop("disabled", true);
    $("#txtValorLiquidoMoeda").prop("disabled", true);
    $("#btn-limpa-moeda").prop("disabled", true);
    $("#btn-limpa-condicao").prop("disabled", true);
  } else {
    // habilita novamente as formas de pagtos.
    $("#txtMoeda").prop("disabled", false);
    $("#txtBaixaAntecipacao").prop("disabled", false);
    $("#txtTipoMoeda").prop("disabled", false);
    $("#txtCondicaoDePagamento").prop("disabled", false);
    $("#txtValorParcela").prop("disabled", false);
    $("#txtNrParcelas").prop("disabled", false);
    $("#btn-moeda").prop("disabled", false);
    $("#btn-CondicaoDePagamento").prop("disabled", false);
    $("#txtPercDescontoMoeda").prop("disabled", false);
    $("#txtValorDescontoMoeda").prop("disabled", false);
    $("#txtPercAcrescMoeda").prop("disabled", false);
    $("#txtValorAcrescMoeda").prop("disabled", false);
    $("#txtValorLiquidoMoeda").prop("disabled", false);
    $("#btn-limpa-moeda").prop("disabled", false);
    $("#btn-limpa-condicao").prop("disabled", false);
  }
}

function confirmExit() {
  return "Deseja realmente sair desta página?";
}

function criaTelaAjuda() {
  $("#pesquisaModalLabel").text("Teclas de atalho");
  $("#pesquisaModalBody").html(
    '<table class="table table-sm table-hover">' +
    "<thead>" +
    "<tr><th>Teclas</th>" +
    "<th>Função</th></tr>" +
    "</thead>" +
    "<tbody>" +
    "<tr><td>F1</td>" +
    "<td>Mostra as teclas de atalho do módulo.</td>" +
    "</tr>" +
    "<tr><td>F4</td>" +
    "<td>Pesquisar nos campos com a lupa.</td>" +
    "</tr>" +
    "<tr><td>F11</td>" +
    "<td>Tela cheia.</td>" +
    "</tr>" +
    "<tr><td>Tab</td>" +
    "<td>Pular para o próximo campo.</td>" +
    "</tr>" +
    "<tr><td>Ctrl + B</td>" +
    "<td>Focar no campo de código de barras.</td>" +
    "</tr>" +
    "<tr><td>Ctrl + Q</td>" +
    "<td>Focar no campo de Quantidade.</td>" +
    "</tr>" +
    "<tr><td>Quantidade <b>*</b> código de barra</td>" +
    "<td>Adiciona n vezes quantidade do mesmo produto bipado. <small>Exemplo: 15*5556448779932</small></td>" +
    "</tr>" +
    "<tr><td><b>-</b> código de barra</td>" +
    "<td>Remove 1 produto dos itens bipados. <small>Exemplo: -5556448779932</small></td>" +
    "</tr>" +
    "<tr><td>ALT + F</td>" +
    "<td>Sair do PDV.</td>" +
    "</tr>" +
    "<tr><td>ALT + S</td>" +
    "<td>Botão confirmar em mensagens de confirmação.</td>" +
    "</tr>" +
    "<tr><td>ALT + N</td>" +
    "<td>Botão cancelar em mensagens de confirmação.</td>" +
    "</tr>" +
    "<tr><td>F2</td>" +
    "<td>Abre cadastro de cliente.</td>" +
    "</tr>" +
    "<tr><td>ALT + F6</td>" +
    "<td>Abre consulta de preços.</td>" +
    "</tr>" +
    "</tbody>" +
    "</table>"
  );
  $("#pesquisaModal").modal("show");
  $("#pesquisaModalSelecionar").hide();
  $("#pesquisaModalConfirmar").hide();
}

async function retornaCondicaoDinheiro() {
  let url = `/sisplan/funcoes/v1/pesquisa?`;
  try {
    let response = await requisicao(
      "GET",
      url,
      `JSON={ "tabela":"condicao", "camposSelect":[ "min(codcond) codcond", "descricao"], "groupby": ["descricao"], "where": ["1=1"] }`,
      null
    );

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }

    return `[${jsonStr.RESULT[0][0].CODCOND}] - ${jsonStr.RESULT[0][0].DESCRICAO}`;
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível buscar os dados do produto.");
  }
}

async function buscaInfoAdc(sCodigo, sCor, sTam) {
  const url = `/sisplan/funcoes/v1/pesquisa?`;
  const pesquisa = {
    tabela: "pa_iten",
    camposSelect: ["produto.colecao",
      "colecao.descricao desc_colecao",
      "produto.marca",
      "marca.descricao desc_marca",
      "produto.linha",
      "tablin.descricao desc_linha",
      "produto.grupo",
      "grupo_pa.descricao desc_grupo",
      "produto.etiqueta",
      "etq_prod.descricao desc_etiqueta",
      "pa_iten.barra",
      "pa_iten.barra28",
      "pa_iten.barracli"],
    leftjoin: [
      { "tabela": "produto", "condicao": "produto.codigo = pa_iten.codigo" },
      { "tabela": "tablin", "condicao": "tablin.codigo = produto.linha" },
      { "tabela": "grupo_pa", "condicao": "grupo_pa.codigo = produto.grupo" },
      { "tabela": "colecao", "condicao": "colecao.codigo= produto.colecao" },
      { "tabela": "marca", "condicao": "marca.codigo = produto.marca" },
      { "tabela": "etq_prod", "condicao": "etq_prod.codigo = produto.etiqueta" }
    ],
    where: [`pa_iten.codigo = '${sCodigo}' and pa_iten.cor = '${sCor}' and pa_iten.tam = '${sTam}'`]
  };
  try {
    const response = await requisicao(
      "GET",
      url,
      `JSON=${JSON.stringify(pesquisa)}`,
      null
    );

    if (!response) {
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }

    return jsonStr;
  } catch (error) {
    console.error(error);
    msgErro("Não foi possível buscar os dados do produto.");
  }
}

async function telaInicial() {
  let obrigaGuia = false;
  if (!$("#GuiaInfoTour").hasClass("d-none")) {
    if ((getCookie('vai_para_aba_itens') != 'true') && ($("#txtGuia").val() == "")) {
      obrigaGuia = true;
    }
  }
  if (($("#tabelaCondicoesDePagamento").DataTable().rows().count() > 0)) {
    fsVenda = $("#fieldset_venda");
    fsPagamento = $("#fieldset_pagamento");
    fsInfo = $("#fieldset_info");

    fsPagamento.css({
      display: "none",
      position: "relative",
    });

    fsInfo.css({
      display: "none",
      position: "relative",
    });

    fsVenda.css({
      opacity: 1,
    });
    fsPagamento.show();
    $("#btnPagamento").prop("disabled", true);
    $("#btnInfo").prop("disabled", false);
    $("#btnVenda").prop("disabled", false);
  } else if (
    $("#txtCliente").val() != "" &&
    $("#txtDeposito").val() != "" &&
    $("#txtTabela").val() != "" &&
    $("#txtVendedor").val() != "" &&
    !obrigaGuia
  ) {
    fsVenda = $("#fieldset_venda");
    fsPagamento = $("#fieldset_pagamento");
    fsInfo = $("#fieldset_info");

    fsPagamento.css({
      display: "none",
      position: "relative",
    });

    fsInfo.css({
      display: "none",
      position: "relative",
    });

    fsVenda.css({
      opacity: 1,
    });
    fsVenda.show();
    $("#btnVenda").prop("disabled", true);
    $("#btnInfo").prop("disabled", false);
    $("#btnPagamento").prop("disabled", false);
    focaCampo();
  } else {
    fsVenda = $("#fieldset_venda");
    fsPagamento = $("#fieldset_pagamento");
    fsInfo = $("#fieldset_info");

    fsInfo.show();
    fsPagamento.css({
      display: "none",
      position: "relative",
    });

    fsVenda.css({
      display: "none",
      position: "relative",
    });

    fsInfo.css({
      opacity: 1,
    });

    $("#btnVenda").prop("disabled", false);
    $("#btnInfo").prop("disabled", true);
    $("#btnPagamento").prop("disabled", false);
  }
  deleteCookie('vai_para_aba_itens');
}

async function corrigeCamposPedido(arrItens, iQtde) {
  const itensFormatados = arrItens.filter((item) => {
    if (iQtde === 'F') {
      return item.qtde_f !== 0;
    } else if (iQtde === 'P') {
      return item.qtde !== 0;
    } else if (iQtde === 'T') {
      return true;
    }
  }).map((item) => ({
    codigo: `<div class="icheck-primary d-inline"><span class="fas fa-times-circle" style="color:#EEAD2D"></span></div>  ${item.codigo}`,
    descricao: item.descricao,
    cor: item.cor,
    descCor: item.descCor,
    tam: item.tam,
    qtde: item.qtde_orig - item.qtde_f < 0 ? 0 : item.qtde_orig - item.qtde_f,
    qtde_f: item.qtde_f,
    preco: item.preco,
    tipo: item.tipo,
    id_Estoque: item.id_Estoque,
    qtde_conf: 0,
    barra: item.barra,
    barra28: item.barra28,
    barraCli: item.barraCli,
    ordem: item.ordem_Ped,
    qtde_orig: item.qtde_orig,
    zero: 0,
    qualidade: item.qualidade,
  }));
  return itensFormatados;
};

async function imprimirRomaneio(sVenda, sUrl) {
  try {
    $.LoadingOverlay("show");
    let url = `/sisplan/impressao/v1/venda?codven=${sVenda}`;
    try {
      const bImprimeAutomatico = await verificaImprimirAutomatico('Venda');
      const arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'Venda');

      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${sUrl}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error);
    }
  } finally {
    $.LoadingOverlay("hide");
  }
}

async function verificaVendaFinalizadaEEnviaWhatsApp(sUrl, codven, tela) {
  try {
    if ((String(codven).toUpperCase() == 'CREATE')
      || (String(codven).toUpperCase() == 'CREATE#')
      || (String(codven).toUpperCase() == 'VENDAPENDENTE')
      || (String(codven) == '')) {
      return;
    }
    const bUtilizaWhatsapp = utilizaWhatsapp();
    if (!bUtilizaWhatsapp) {
      return;
    }

    const empId = getCookie('emp_id');

    const pesquisa = {
      camposSelect: ['VENDA.FECHADA', 'VENDA.VALOR', 'VENDA.CODCLI', 'ENTIDADE.NOME', "VENDA.DEVOLUCAO"],
      tabela: 'VENDA',
      leftJoin: [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = VENDA.CODCLI' }],
      where: [`VENDA.CODVEN = '${codven}' AND VENDA.EMP_ID = ${empId}`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
    const vendaFechada = jsonStr[0].FECHADA == '1';
    const vendaDevolucao = jsonStr[0].DEVOLUCAO == '1';
    const nome = jsonStr[0].NOME;
    const valor = jsonStr[0].VALOR;
    const codcli = jsonStr[0].CODCLI;

    if (nome.indexOf('CONSUMIDOR FINAL') >= 0) {
      return;
    }

    if (vendaFechada || vendaDevolucao) {
      const telefone = await getWhatsapp(codcli);
      if (telefone != '') {
        await enviarRomaneioWpp(codven, telefone, nome, valor, sUrl, tela.toUpperCase());
      }
    }
    return;
  } catch (err) {
    console.error(err);
    return;
  }
}

async function excluiVendaIShopp(codven) {
  try {
    const bIntegracaIShopp = parametrosVenda[68] == 1 || parametrosVenda[68] == 2;
    if (!bIntegracaIShopp) {
      return;
    }

    const empId = getCookie('emp_id');

    const pesquisa = {
      camposSelect: ['VENDA.NR_INTEGRACAO', 'ENTIDADE.CNPJ', 'VENDA.DATA', 'VENDA.VALOR'],
      tabela: 'VENDA',
      leftJoin: [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = VENDA.CODCLI' }],
      where: [`VENDA.CODVEN = '${codven}' AND VENDA.EMP_ID = ${empId}`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));

    let venda = {};
    venda.cnpj = jsonStr[0].CNPJ;
    venda.data = jsonStr[0].DATA;
    venda.valor = jsonStr[0].VALOR;
    venda.nr_integracao = jsonStr[0].NR_INTEGRACAO;

    response = await requisicao_ecf('DELETE', '/ishopp/exclusaovenda?', "", JSON.stringify(venda));

    return;
  } catch (err) {
    console.error(err);
    return;
  }
}

async function geraVendaIShopp(codven) {
  try {
    if ((String(codven).toUpperCase() == 'CREATE')
      || (String(codven).toUpperCase() == 'CREATE#')
      || (String(codven).toUpperCase() == 'VENDAPENDENTE')
      || (String(codven) == '')) {
      return;
    }

    const bIntegracaIShopp = parametrosVenda[68] == 1 || parametrosVenda[68] == 2;
    if (!bIntegracaIShopp) {
      return;
    }

    const empId = getCookie('emp_id');
    const empresa = getCookie('empresa');

    const pesquisa = {
      camposSelect: ['VENDA.FECHADA', 'ENTIDADE.CNPJ', 'VENDA.DATA', 'VENDA.VALOR', 'REPRESEN.NOME NOMEREP', 'VENDA.CODREP2', 'ENTIDADE.INTEGRA_SHOPP'],
      tabela: 'VENDA',
      leftJoin: [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = VENDA.CODCLI' },
      { tabela: 'REPRESEN', condicao: 'VENDA.CODREP = REPRESEN.CODREP' }],
      where: [`VENDA.CODVEN = '${codven}' AND VENDA.EMP_ID = ${empId}`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
    const vendaFechada = jsonStr[0].FECHADA == '1';
    const guia = jsonStr[0].CODREP2;

    if ((!vendaFechada) || (jsonStr[0].INTEGRA_SHOPP == 'N')) {
      return;
    }

    if (guia == '') {
      if (parametrosVenda[68] != 2) {
        await gravaVendaIshopp();
      }
    } else {
      await gravaVendaIshopp();
    }

    async function gravaVendaIshopp() {
      let venda = {};
      venda.cnpj = jsonStr[0].CNPJ;
      venda.data = jsonStr[0].DATA;
      venda.valor = jsonStr[0].VALOR;
      venda.nomerep = jsonStr[0].NOMEREP;
      venda.codven = codven;
      venda.emp_id = empId;
      venda.empresa = empresa;
      venda.condicao = await retornaCondicao(codven, empId);

      if (vendaFechada) {
        response = await requisicao_ecf('POST', '/ishopp/geravenda?', "", JSON.stringify(venda));

        if (!response) {
          return;
        }

        if (response.status != 200) {
          msgErro("Erro integrar venda com o sistema iShopp (iBASi).");
          return;
        }
      }
    };

    return;
  } catch (err) {
    console.error(err);
    return;
  }
}

async function imprimirCheque(posicao) {
  try {
    const empId = getCookie('emp_id');

    const pesquisa = {
      camposSelect: ['EMPRESA.EMP_CIDADE'],
      tabela: 'EMPRESA',
      where: [`EMPRESA.EMP_ID = ${empId}`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
    const cidade = jsonStr[0].EMP_CIDADE;

    const cheque = {
      banco: $($('.campoBanco')[posicao]).val().substring(1, $($('.campoBanco')[posicao]).val().indexOf("]")),
      cidade: cidade,
      data: $($(".campoVencimento")[posicao]).val(),
      valor: $($('.campoValor')[posicao]).val()
    };

    if (cheque.banco == '') {
      msgAlerta('Necessário informar o banco.')
      return;
    }

    response = await requisicao_ecf('POST', '/cheque/imprimircheque?', "", JSON.stringify(cheque), 120000);

    if (!response) {
      return;
    }

    if (response.status != 200) {
      const mensagemErro = await response.text();
      msgErro(`Erro ao imprimir cheque. ${mensagemErro}`);
      return;
    }

    response = await response.json();
    insereValor($(".campoBanco")[posicao], response.banco, response.banco);
    $($(".campoAgencia")[posicao]).val(response.agencia);
    $($(".campoConta")[posicao]).val(response.conta);
    $($(".campoNumero")[posicao]).val(response.numero);

    return;
  } catch (err) {
    console.error(err);
    return;
  }
}

async function LerCheque(posicao) {
  try {

    let response = await requisicao_ecf('GET', '/cheque/imprimircheque?', "", "", 120000);

    if (!response) {
      msgErro("Não foi possível comunicar com a apiLocal.");
      return;
    }

    if (response.status != 200) {
      const mensagemErro = await response.text();
      msgErro(`Erro ao Ler cheque. ${mensagemErro}`);
      return;
    }

    response = await response.json();
    insereValor($(".campoBanco")[posicao], response.banco, response.banco);
    $($(".campoAgencia")[posicao]).val(response.agencia);
    $($(".campoConta")[posicao]).val(response.conta);
    $($(".campoNumero")[posicao]).val(response.numero);

    return;
  } catch (err) {
    console.error(err);
    return;
  }
}

async function geraVendaNetShopping(codven, codGuia) {
  try {
    if ((String(codven).toUpperCase() == 'CREATE')
      || (String(codven).toUpperCase() == 'CREATE#')
      || (String(codven).toUpperCase() == 'VENDAPENDENTE')
      || (String(codven) == '')) {
      return;
    }

    const bIntegracaIShopp = parametrosVenda[69] == 1;
    if (!bIntegracaIShopp) {
      return;
    }

    const empId = getCookie('emp_id');

    const pesquisa = {
      camposSelect: ['VENDA.FECHADA', 'ENTIDADE.CNPJ', 'VENDA.DATA', 'VENDA.VALOR', 'REPRESEN.NOME NOMEREP', 'ENTIDADE.INTEGRA_SHOPP'],
      tabela: 'VENDA',
      leftJoin: [{ tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = VENDA.CODCLI' },
      { tabela: 'REPRESEN', condicao: 'VENDA.CODREP = REPRESEN.CODREP' }],
      where: [`VENDA.CODVEN = '${codven}' AND VENDA.EMP_ID = ${empId}`]
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
    const vendaFechada = jsonStr[0].FECHADA == '1';
    if ((!vendaFechada) || (jsonStr[0].INTEGRA_SHOPP == 'N')) {
      return;
    }
    let venda = {};
    venda.CPFCNPJCliente = jsonStr[0].CNPJ;
    venda.Guia = codGuia;
    venda.CodVen = codven;
    venda.Emp_Id = empId;
    venda.condicao = await retornaCondicaoNetShopping(codven, empId);

    const param = `JSON=${JSON.stringify(venda)}`;
    if (vendaFechada) {
      response = await requisicao('POST', '/sisplan/vendas/v1/netshopping?', "", param);

      if (!response) {
        return;
      }

      if (response.status != 200) {
        msgErro("Erro integrar venda com o sistema NetShopping.");
        return;
      }
      let jsonStr = await response.json();
      if (jsonStr.situacao == 'RESTRICAO') {
        msgAlerta(`Restrição: ${jsonStr.situacao}\nDescrição: ${jsonStr.ds_situacao}`);
        sleep(30000);
      }
      // else { COMENTADO POIS DE INICIO SÓ SERÁ INFORMADO A MENSAGEM QUANDO CONTER ALGUMA RESTRIÇÃO
      //   // jsonStr.condVenda.map(cond => {console.log(cond.cd_movimentacao)}) necessario validar como será retornado a mensagem para o usuário
      //   // mensagem = 
      //   // `Guia: ${jsonStr.cd_guia}\nNome guia: ${jsonStr.nm_guia}\nLiberado compra cheque: ${jsonStr.fl_liberado_compra_cheque}\nLiberado para compra: ${jsonStr.fl_bloqueado_para_compra}\nSaldo: ${jsonStr.saldo.replaceAll('.',',')}`;
      //   // insereValor('#txtCodGuiaIntegracao', jsonStr.cd_guia, jsonStr.nm_guia);
      // }

    }
  } catch (err) {
    console.error(err);
    return;
  }
}

async function retornaCondicaoNetShopping(codven, emp_id) {
  let result = [];
  const pesquisa = {
    camposSelect: [
      'ITCONDIVENDA.VALOR', 'RECEBER.AGENCIA_CH', 'MOEDA.TIPO AS TIPO_MOEDA', 'ITCONDIVENDA.CDBANCO', 'ITCONDIVENDA.NRCONTA', 'RECEBER.NUMERO_CH', 'ITCONDIVENDA.NMSACADO',
      'ITCONDIVENDA.CPFSACADO', 'ITCONDIVENDA.VENCIMENTO'
    ],
    tabela: 'CONDIVENDA',
    innerJoin: [{ tabela: 'MOEDA', condicao: 'MOEDA.CODMOE = CONDIVENDA.CDMOEDA' },
    { tabela: 'ITCONDIVENDA', condicao: 'ITCONDIVENDA.CDCONDIVENDA = CONDIVENDA.CDCONDIVENDA AND ITCONDIVENDA.CDVENDA = CONDIVENDA.CDVENDA AND ITCONDIVENDA.EMP_ID = CONDIVENDA.EMP_ID' }],
    leftJoin: [{ tabela: 'RECEBER', condicao: `RECEBER.NRO_CUPOM = CONDIVENDA.CDVENDA AND RECEBER.STATUS = 'CHEQ' AND RECEBER.NUMERO = ITCONDIVENDA.NRDOCTO AND RECEBER.EMP_ID = CONDIVENDA.EMP_ID AND RECEBER.NRO_CUPOM = ${codven}` }],
    where: [`CONDIVENDA.CDVENDA = '${codven}' AND CONDIVENDA.EMP_ID = ${emp_id}`]
  }
  const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
  jsonStr.map(item => {
    const condicao = {
      valor: item.VALOR,
      tipo_moeda: item.TIPO_MOEDA,
      banco: item.CDBANCO,
      agencia: item.AGENCIA_CH,
      conta: item.NRCONTA,
      num_cheque: item.NUMERO_CH,
      nmsacado: item.NMSACADO,
      vencimento: item.VENCIMENTO
    };
    result.push(condicao);
  })
  return result;
}

async function retornaCondicao(codven, emp_id) {
  let result = [];
  const pesquisa = {
    camposSelect: [
      'ITCONDIVENDA.VALOR', 'RECEBER.AGENCIA_CH', 'MOEDA.TIPO AS TIPO_MOEDA', 'ITCONDIVENDA.CDBANCO', 'ITCONDIVENDA.NRCONTA', 'RECEBER.NUMERO_CH', 'ITCONDIVENDA.NMSACADO',
      'ITCONDIVENDA.CPFSACADO', 'ITCONDIVENDA.VENCIMENTO'
    ],
    tabela: 'CONDIVENDA',
    innerJoin: [{ tabela: 'MOEDA', condicao: 'MOEDA.CODMOE = CONDIVENDA.CDMOEDA' },
    { tabela: 'ITCONDIVENDA', condicao: 'ITCONDIVENDA.CDCONDIVENDA = CONDIVENDA.CDCONDIVENDA AND ITCONDIVENDA.CDVENDA = CONDIVENDA.CDVENDA AND ITCONDIVENDA.EMP_ID = CONDIVENDA.EMP_ID' }],
    leftJoin: [{ tabela: 'RECEBER', condicao: `RECEBER.NRO_CUPOM = CONDIVENDA.CDVENDA AND RECEBER.STATUS = 'CHEQ' AND RECEBER.NUMERO = ITCONDIVENDA.NRDOCTO AND RECEBER.EMP_ID = CONDIVENDA.EMP_ID AND RECEBER.NRO_CUPOM = ${codven}` }],
    where: [`CONDIVENDA.CDVENDA = '${codven}' AND CONDIVENDA.EMP_ID = ${emp_id}`]
  }
  const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisa));
  jsonStr.map(item => {
    const condicao = {
      valor: item.VALOR,
      tipo_moeda: item.TIPO_MOEDA,
      cdbanco: item.CDBANCO,
      agencia_ch: item.AGENCIA_CH,
      nrconta: item.NRCONTA,
      numero_ch: item.NUMERO_CH,
      nmsacado: item.NMSACADO,
      cpfsacado: item.CPFSACADO,
      vencimento: item.VENCIMENTO
    };
    result.push(condicao);
  })
  return result;
}

async function enviarRomaneioWpp(sVenda, telefone, nome, valor, sUrl, tela) {
  try {
    const url = `/sisplan/impressao/v1/venda?codven=${sVenda}`;
    try {
      if (telefone == '') {
        return;
      }
      const arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'Venda');
      const base64 = await transformaPDFemBase64(`${sUrl}/relatorios_api/pdf/${arquivo}`);
      const valorFormatado = new Intl.NumberFormat('pt-BR', { style: 'currency', currency: 'BRL' }).format(valor);
      const parametrosMensagem = [`VENDA: ${sVenda}`, `EMP_ID: ${getCookie("emp_id")}`];
      const objMsgWpp = [{ CELULAR: telefone, PARAMETROSMENSAGEM: parametrosMensagem.toString(), MENSAGEMPERSONALIZADA: "" }];
      let mensagemPersonalizada = await retornaMsgPersonalizadaWpp(tela, objMsgWpp);
      mensagemPersonalizada = decodeEmoticonsMensagem(mensagemPersonalizada, true);
      const mensagem = `Olá *${nome}*! \r\nObrigado por comprar conosco 🙌 \r\n\r\nVocê efetuou uma compra no valor de *${valorFormatado}*.\r\nSegue abaixo uma cópia do relatório da venda *${sVenda}*. \r\nTenha um ótimo dia 😊🎉`;
      if (arquivo != undefined) {
        await enviarMensagem(telefone, mensagemPersonalizada != "" ? mensagemPersonalizada : mensagem);
        await enviarMensagem(telefone, base64, true, false);
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error);
    }
  } finally {
  }
}

async function imprimirCarne(sVenda, sUrl) {
  try {
    $.LoadingOverlay("show");
    let url = `/sisplan/impressao/v1/carne?CODVEN=${sVenda}`;
    try {
      const bImprimeAutomatico = await verificaImprimirAutomatico('Carne');
      let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'Carne');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${sUrl}/relatorios_api/pdf/${arquivo}`, "_blank");
        }
        await limparRelatorios();
      }
    } catch (error) {
      console.error(error);
    }
  } finally {
    $.LoadingOverlay("hide");
  }
}

async function salvarBackupVenda(objeto) {
  try {
    const empId = getCookie("emp_id");
    const hora = new Date()
      .toISOString()
      .slice(0, 19)
      .replaceAll("T", "_")
      .replaceAll(":", "");
    const response = await fetch(
      `../salvar_bkp.php?nome_arquivo=${objeto.codVen}_${empId}_${hora}`,
      {
        method: "POST",
        body: `${JSON.stringify(objeto)}`,
      }
    );

    return response;
  } catch (error) {
    msgAlerta("Erro ao salvar dados digitados!");
  }
}

async function toastrFinalizarVenda(mensagem, callBack) {
  await toastr
    .success(mensagem, "Confirmação", {
      toastClass: "alert",
      iconClasses: {
        error: "alert-error",
        info: "alert-info",
        success: "alert-success",
        warning: "alert-warning",
      },
      positionClass: "toast-top-center",
      progressBar: true,
      timeOut: 3000,
      fadeOut: 1000,
      async onHidden() {
        await callBack();
      },
    })
    .css({
      "margin-top": "20%",
      width: "500px",
      "max-width": "500px",
    });
}

async function criaTelaInfoAdc(id) {
  sCodigo = { Codigo: $("#tabelaItens").DataTable().row(id).data()[0], Cor: $("#tabelaItens").DataTable().row(id).data()[10], Tam: $("#tabelaItens").DataTable().row(id).data()[11] };
  const jsonStr = await buscaInfoAdc(sCodigo.Codigo, sCodigo.Cor, sCodigo.Tam);
  const sColecao = jsonStr.RESULT[0][0].COLECAO;
  const sDescColecao = jsonStr.RESULT[0][0].DESC_COLECAO;
  const sGrupo = jsonStr.RESULT[0][0].GRUPO;
  const sDescGrupo = jsonStr.RESULT[0][0].DESC_GRUPO;
  const sMarca = jsonStr.RESULT[0][0].MARCA;
  const sDescMarca = jsonStr.RESULT[0][0].DESC_MARCA;
  const sEtiqueta = jsonStr.RESULT[0][0].ETIQUETA;
  const sDescEtiqueta = jsonStr.RESULT[0][0].DESC_ETIQUETA;
  const sLinha = jsonStr.RESULT[0][0].LINHA;
  const sDescLinha = jsonStr.RESULT[0][0].DESC_LINHA;
  const sBarra = jsonStr.RESULT[0][0].BARRA;
  const sBarra28 = jsonStr.RESULT[0][0].BARRA28;
  const sBarraCli = jsonStr.RESULT[0][0].BARRACLI;

  $("#pesquisaModalLabel").text("Informações Adicionais");
  $("#pesquisaModalBody").html(
    `${'<table class="table table-sm table-hover">' +
    "<thead>" +
    "<tr><th>Campo</th>" +
    "<th>Descrição</th></tr>" +
    "</thead>" +
    "<tbody>" +
    "<tr><td>Coleção</td>" +
    "<td>"
    }${sColecao} - ${sDescColecao}</td>` +
    `</tr>` +
    `<tr><td>Grupo</td>` +
    `<td>${sGrupo} - ${sDescGrupo}</td>` +
    `</tr>` +
    `<tr><td>Marca</td>` +
    `<td>${sMarca} - ${sDescMarca}</td>` +
    `</tr>` +
    `<tr><td>Etiqueta</td>` +
    `<td>${sEtiqueta} - ${sDescEtiqueta}</td>` +
    `</tr>` +
    `<tr><td>Linha</td>` +
    `<td>${sLinha} - ${sDescLinha}</td>` +
    `</tr>` +
    `<tr><td>Barra</td>` +
    `<td>${sBarra}</td>` +
    `</tr>` +
    `<tr><td>Barra28</td>` +
    `<td>${sBarra28}</td>` +
    `</tr>` +
    `<tr><td>Barra Cliente</td>` +
    `<td>${sBarraCli}</td>` +
    `</tr>` +
    `</tbody>` +
    `</table>`
  );
  $("#pesquisaModal").modal("show");
  $("#pesquisaModalSelecionar").hide();
  $("#pesquisaModalConfirmar").hide();
}

async function criaTelaDesconto(id) {
  const permiteAlterarPreco43 = (parametrosVenda[43]) == 1;
  const utilizaImpressoraFiscal = parametrosVenda[8] == 1;
  if ($('#txtCupomDesconto').val() !== '') {
    msgAlerta("Venda com cupom de Desconto aplicado, impossível aplicar desconto.");
    return;
  }
  let arrDados = $("#tabelaItens").DataTable().row(id).data();
  $("#pesquisaDescontoLabel").text("Desconto");
  $("#txtPercDesconto").attr("disabled", false).attr("readonly", false);
  $("#txtValorDesconto").attr("disabled", false).attr("readonly", false);

  if (!permiteAlterarPreco43) {
    $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);
  } else {
    $("#txtPrecoDesc").attr("disabled", false).attr("readonly", false);

    $("#txtPrecoDesc").unbind("blur");
    $("#txtPrecoDesc").on("blur", function () {
      if ($(this).val() != "" && parseInt($(this).val()) > 0) {
        $("#txtPercDesconto").attr("disabled", true).attr("readonly", true);
        $("#txtValorDesconto").attr("disabled", true).attr("readonly", true);
        CalculaDesconto("#txtPrecoDesc");
      } else {
        $("#txtPercDesconto").attr("disabled", false).attr("readonly", false);
        $("#txtValorDesconto").attr("disabled", false).attr("readonly", false);
        $("#txtPrecoDesc").val($("#txtPrecoOrig").val());
        $("#txtPrecoLiqDesconto").val($("#txtPrecoOrig").val());
        $("#txtTotalLiq").val($("#txtPrecoOrig").val() * $("#txtQuantidadeDesc").val());
      }
    });
  }

  $("#txtPercDesconto").unbind("blur");
  $("#txtPercDesconto").on("blur", function () {
    if ($(this).val() != "" && parseInt($(this).val()) > 0) {
      $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);
      $("#txtValorDesconto").attr("disabled", true).attr("readonly", true);
      CalculaDesconto("#txtPercDesconto");
    } else {
      if (!permiteAlterarPreco43) {
        $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);
      } else {
        $("#txtPrecoDesc").attr("disabled", false).attr("readonly", false);
      }
      $("#txtValorDesconto").attr("disabled", false).attr("readonly", false);
      $("#txtPrecoDesc").val(0);
      $("#txtValorDesconto").val(0);
      $("#txtPrecoDesc").val($("#txtPrecoOrig").val());
      $("#txtPrecoLiqDesconto").val($("#txtPrecoOrig").val());
      $("#txtTotalLiq").val($("#txtPrecoOrig").val() * $("#txtQuantidadeDesc").val()
      );
    }
  });

  $("#txtValorDesconto").unbind("blur");
  $("#txtValorDesconto").on("blur", function () {
    if ($(this).val() != "" && parseFloat($(this).val()) > 0.01) {
      $("#txtPercDesconto").attr("disabled", true).attr("readonly", true);
      $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);
      CalculaDesconto("#txtValorDesconto");
    } else {
      if (!permiteAlterarPreco43) {
        $("#txtPrecoDesc").attr("disabled", true).attr("readonly", true);
      } else {
        $("#txtPrecoDesc").attr("disabled", false).attr("readonly", false);
      }
      $("#txtPercDesconto").attr("disabled", false).attr("readonly", false);
      $("#txtPercDesconto").val(0);
      $("#txtPrecoDesc").val($("#txtPrecoOrig").val());
      $("#txtPrecoLiqDesconto").val(
        parseFloat($("#txtPrecoDesc").val()) *
        parseFloat($("#txtQuantidadeDesc").val())
      );
      $("#txtTotalLiq").val(parseFloat($("#txtPrecoDesc").val()) * parseFloat($("#txtQuantidadeDesc").val()));
    }
  });

  $("#pesquisaDesconto").modal("show");
  $("#txtPercDesconto")
    .inputmask("numeric", {
      min: 0,
      max: 99,
      positionCaretOnClick: "select",
    })
    .on("focus", function () {
      let that = $(this);
      setTimeout(function () {
        that.select();
      }, 1);
    });
  $("#txtPrecoDesc")
    .inputmask("numeric", {
      min: 0,
      positionCaretOnClick: "select",
      digits: quantidadeCasasDecimaisCampo,
    })
    .on("focus", function () {
      let that = $(this);
      setTimeout(function () {
        that.select();
      }, 1);
    });

  $("#txtValorDesconto")
    .inputmask("numeric", {
      min: 0,
      positionCaretOnClick: "select",
      digits: quantidadeCasasDecimaisCampo,
    })
    .on("focus", function () {
      let that = $(this);
      setTimeout(function () {
        that.select();
      }, 1);
    });

  $("#txtTotalLiq")
    .inputmask("numeric", {
      min: 0,
      positionCaretOnClick: "select",
      digits: 2,
    })
    .on("focus", function () {
      let that = $(this);
      setTimeout(function () {
        that.select();
      }, 1);
    });

  $("#txtPrecoLiqDesconto")
    .inputmask("numeric", {
      min: 0,
      positionCaretOnClick: "select",
      digits: quantidadeCasasDecimaisCampo,
    })
    .on("focus", function () {
      let that = $(this);
      setTimeout(function () {
        that.select();
      }, 1);
    });

  $("#txtProdutoDesc").val(arrDados[1]);
  $("#txtPrecoDesc").val(parseFloat(arrDados[4]).toLocaleString("en-US", {
    maximumFractionDigits: quantidadeCasasDecimaisCampo,
    minimumFractionDigits: quantidadeCasasDecimaisCampo
  }));
  $("#txtPrecoOrig").val(parseFloat(arrDados[3]).toLocaleString("en-US", {
    maximumFractionDigits: quantidadeCasasDecimaisCampo,
    minimumFractionDigits: quantidadeCasasDecimaisCampo
  }));
  $("#txtQuantidadeDesc").val(parseFloat(arrDados[2]));
  $("#txtPercDesconto").val(parseFloat(arrDados[5]).toLocaleString("en-US", {
    maximumFractionDigits: 2,
    minimumFractionDigits: 2
  }));
  $("#txtValorDesconto").val(parseFloat(arrDados[6]).toLocaleString("en-US", {
    maximumFractionDigits: quantidadeCasasDecimaisCampo,
    minimumFractionDigits: quantidadeCasasDecimaisCampo
  }));
  $("#txtTotalLiq").val(parseFloat(arrDados[7]).toLocaleString("en-US", {
    maximumFractionDigits: 2,
    minimumFractionDigits: 2
  }));
  // fazer a tratativa de arredondamento
  const soma = +(arrDados[3]) * parseFloat(arrDados[2]).toFixed(4);
  const maisDeDoisCaracteresDecimal = String(soma).substr(String(soma).indexOf('.') + 1, String(soma).length).length > 2;
  const calculoTotal = utilizaImpressoraFiscal && maisDeDoisCaracteresDecimal ? mantemDuasCasasDecimais(soma, 3) : ArredondarValor(parseFloat(soma), 2);

  $("#txtValBruto").val(parseFloat(calculoTotal).toLocaleString("en-US", {
    maximumFractionDigits: quantidadeCasasDecimaisCampo,
    minimumFractionDigits: quantidadeCasasDecimaisCampo
  }));
  $("#txtPrecoLiqDesconto").val(parseFloat(arrDados[4]).toLocaleString("en-US", {
    maximumFractionDigits: quantidadeCasasDecimaisCampo,
    minimumFractionDigits: quantidadeCasasDecimaisCampo
  }));

  $("#pesquisaDescontoConfirmar").unbind("click");
  $("#pesquisaDescontoConfirmar").on("click", async function () {
    const descontoMaximoUsuario = await retornaDescontoMaximoUsuario();

    if (parseFloat($("#txtPrecoDesc").val()) <= 0) {
      msgErro("Preço deve ser maior que 0, verifique.");
      return;
    }
    if (parseFloat($("#txtPercDesconto").val()) > 99) {
      msgErro("Perc. de desconto deve ser menor que 99, verifique.");
      return;
    }

    const percDesconto = $("#txtPercDesconto").val();
    const valorDesconto = $("#txtValorDesconto").val();

    async function AplicaDescontoItem() {
      const arrDados = $("#tabelaItens").DataTable().row(id).data();
      arrDados[3] =
        arrDados[3] > parseFloat($("#txtPrecoDesc").val())
          ? arrDados[3]
          : $("#txtPrecoDesc").val();
      arrDados[4] = $("#txtPrecoDesc").val();
      arrDados[5] = $("#txtPercDesconto").val();
      arrDados[6] = $("#txtValorDesconto").val();
      arrDados[7] = $("#txtTotalLiq").val();

      $("#tabelaItens").DataTable().row(id).data(arrDados).draw(false);
      $("#pesquisaDesconto").modal("hide");
      await atualizaTotalVenda();
      $('[data-toggle="tooltip"]').tooltip();
    }

    if (parseFloat(percDesconto) > parseFloat(descontoMaximoUsuario) && descontoMaximoUsuario > 0) {
      await senhaSupervisor(
        `Desconto de ${percDesconto}% no item, máximo do usuário é de ${descontoMaximoUsuario}%.`,
        verificaDescontoMaximoSupervisor,
        AplicaDescontoItem,
        true,
      );
    } else {
      let bSenhaSupervisor = parametrosVenda[9];
      if (bSenhaSupervisor == "1") {
        await senhaSupervisor(
          `Desconto de R$ ${valorDesconto} aplicado.`,
          AplicaDescontoItem
        );
      } else {
        await AplicaDescontoItem();
      }
    }
  });
}

$('#modalItemPreco').on("shown.bs.modal", function () {
  $("#txtItemPrecoNovo").focus();
});

async function criaTelaAlterarPreco(id) {
  try {
    const arrDados = $("#tabelaItens").DataTable().row(id).data();

    $("#txtItemPrecoAtual").val(arrDados[3]);
    $("#txtItemPrecoNovo").val(arrDados[3]);
    $("#txtIdLinhaItemPreco").val(id);
    $("#modalItemPreco").modal("show");
  } catch (error) {
    console.error(error);
  }
}

async function criaTelaQuantidade(id, bDevolucao = false) {
  try {
    let arrDados = $("#tabelaItens").DataTable().row(id).data();

    $("#txtItemQuantidadeAtual").val(arrDados[2]);
    $("#txtItemQuantidade").val(arrDados[2]);
    $("#txtItemQuantidadeDiferenca").val(arrDados[2]);
    $("#txtBarraQuantidadeNova").val(bDevolucao ? arrDados[13] : arrDados[14]);
    $("#txtItemCodQuantidade").val(arrDados[1]);
    $("#txtIdLinhaItemQuantidade").val(id);
    $("#txtCodigoAlteraQuantidade").val(arrDados[0]);

    $("#txtItemQuantidade").trigger("blur");

    $("#modalQuantidade").modal("show");
  } catch (error) {
    console.error(error);
  }
}

async function retornaCodigoItem() {
  try {
    let response;
    const barra = $('#txtBarra').val().indexOf('#') > 0 ? $('#txtBarra').val().substring(0, 6) : $('#txtBarra').val();
    if ((parametrosVenda[17]) == 0) {
      response = await requisicao(
        "GET",
        "/Sisplan/Funcoes/v1/pesquisa?",
        `JSON={ "tabela":"pa_iten", "camposSelect":["codigo"], "where": ["barra = '${barra}' or barra28 = '${barra}' or barracli = '${barra}' or barra28 = '${barra.substr(0, 6)}'"]}`,
        null
      );
    } else {
      response = await requisicao(
        "GET",
        "/Sisplan/Funcoes/v1/pesquisa?",
        `JSON={ "tabela":"mat_iten", "camposSelect":["codigo"], "where": ["lote = '${barra}'"]}`,
        null
      );
    }
    if (!response) {
      return;
    }
    const jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }

    return jsonStr.RESULT[0][0].CODIGO;
  } catch (error) {
    console.error(error);
    msgErro("Erro ao Retornar o código do item!");
  }
}

async function buscaPreco(bBarra = false) {
  try {
    $.LoadingOverlay("show");
    limpaInfoProdutosPesquisaPreco();
    try {
      // const parametroUsaProduto = await CopiaParametro('VENDA', 17);
      const codigoItem = bBarra ? await retornaCodigoItem() : pegaChave("#txtCodigoProd");
      let tabela = pegaChave($("#txtTabela").val());
      let deposito = pegaChave($("#txtDeposito").val());
      let prazo = $('#rgPrazoPrecos').val() != '' ? $('#rgPrazoPrecos').val() : '00';
      let dataSet = [];
      let dataSetCols = [];
      let tipo;
      let barra = $('#txtBarra').val().indexOf('#') > 0 ? $('#txtBarra').val().substring(0, 6) : $('#txtBarra').val();

      let responseCodigo;

      if ($("#radioMaterialPreco").is(":checked")) {
        tipo = "M";
      }
      if ($("#radioProdutoPreco").is(":checked")) {
        tipo = "P";
      }

      if ($("#tabelaEstPrec").hasClass("d-none")) {
        $("#tabelaEstPrec").removeClass("d-none");
      }

      let response = await requisicao(
        "GET",
        "/sisplan/vendas/v1/precos?",
        `tabpreco=${tabela}&PRODUTO=${codigoItem}&DEPOSITO=${deposito}&BARRA=${""}&TIPO=${tipo}&PRAZO=${prazo}`,
        null
      );

      if (!response) {
        return;
      }

      const jsonStr = await response.json();
      jsonStr.map((item) => {
        if (!item.PRECO) {
          item.PRECO = 0;
        }
      })

      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        $('#txtBarra').val('');
        return;
      }

      dataSet = jsonStr;
      let keys = Object.keys(dataSet[0]);
      for (let k in keys) {
        dataSetCols.push({
          title: keys[k],
          data: keys[k],
        });
      }

      $("#tabelaEstoquePreco").DataTable({
        destroy: true,
        select: true,
        keys: true,
        searching: false,
        lengthChange: false,
        scrollY: "300px",
        scrollCollapse: true,
        paging: false,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        autoWidth: true,
        columns: dataSetCols,
        data: dataSet,
        columnDefs: [
          {
            "targets": [9, 10, 11],
            "visible": false
          },
          {
            "render": function (data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: quantidadeCasasDecimaisCampo,
                minimumFractionDigits: quantidadeCasasDecimaisCampo
              })
            },
            "targets": [7, 8],
          }
        ]
      });


      if (barra != '') {
        if (tipo == "P") {
          responseCodigo = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ "tabela":"pa_iten", "camposSelect":["PA_ITEN.CODIGO","PA_ITEN.COR","PA_ITEN.TAM"],
                     "where": [" 1=1
                     ${barra != ""
              ? `AND (PA_ITEN.BARRA = '${barra}'
                      OR PA_ITEN.BARRA28 = '${barra}'
                      OR PA_ITEN.BARRACLI = '${barra}'
                      OR PA_ITEN.BARRA28 = '${barra.substr(0, 6)}')`
              : ""
            }
                      ${deposito != ""
              ? `AND PA_ITEN.DEPOSITO = '${deposito}'`
              : ""
            }
            "]}`,
            null
          );
        } else {
          responseCodigo = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ "tabela":"MAT_ITEN", "camposSelect":["MAT_ITEN.CODIGO","MAT_ITEN.COR"], "where": ["MAT_ITEN.LOTE = '${barra}'"]}`,
            null
          );

          responseCodigo = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ "tabela":"MAT_ITEN", "camposSelect":["MAT_ITEN.CODIGO","MAT_ITEN.COR"],
                     "where": [" 1=1
                     ${barra != ""
              ? `AND (MAT_ITEN.BARRA = '${$("#txtBarra").val()}')`
              : ""
            }
                      ${deposito != ""
              ? `AND MAT_ITEN.DEPOSITO = '${deposito}'`
              : ""
            }
            "]}`,
            null
          );
        }

        if (!responseCodigo) {
          return;
        }

        const jsonStrCodigo = await responseCodigo.json();
        if (responseCodigo.status != 200) {
          msgErro(jsonStrCodigo.mensagem);
          return;
        }

        let posicao = "";

        if (jsonStrCodigo.RESULT[0].length == 0) {
          $("#txtBarra").val("");
          $("#txtCodigoProd").val("");
          return;
        }
        let codigo = jsonStrCodigo.RESULT[0][0].CODIGO;
        let cor = jsonStrCodigo.RESULT[0][0].COR;

        for (
          let i = 0;
          i < $("#tabelaEstoquePreco").DataTable().rows().data().length;
          i++
        ) {
          if (tipo == "P") {
            let tam = jsonStrCodigo.RESULT[0][0].TAM;
            if (
              codigo ==
              $("#tabelaEstoquePreco").DataTable().rows().data()[i].CODIGO &&
              tam == $("#tabelaEstoquePreco").DataTable().rows().data()[i].TAM &&
              cor == $("#tabelaEstoquePreco").DataTable().rows().data()[i].COR
            ) {
              posicao = i;
            }
          } else if (
            codigo ==
            $("#tabelaEstoquePreco").DataTable().rows().data()[i].CODIGO &&
            cor == $("#tabelaEstoquePreco").DataTable().rows().data()[i].COR
          ) {
            posicao = i;
          }
        }
        setTimeout(() => {
          $("#tabelaEstoquePreco tbody tr")[posicao].click();
        }, 100);
      }

      $("#txtCodigoProd").val("");
      $("#txtBarra").val("");
    } catch (error) {
      console.error(error);
      msgErro("Código ou barra incorreta, favor verificar.");
      $("#txtBarra").val("");
      $("#txtCodigoProd").val("");
    }

    $("#tabelaEstoquePreco tbody").on("click", "tr", async function () {
      // $("#tabelaEstoquePreco tbody tr td")[0].click();
      $("#tabelaEstoquePreco")
        .DataTable()
        .$("tr.selected")
        .removeClass("selected");
      $(this).addClass("selected");

      let data = $("#tabelaEstoquePreco").DataTable().row($(this)).data();
      await buscaFotoProdPreco(data.CODIGO);
      $("#txtPrecoProduto").text(
        data.PRECO_PROMO > 0 ? data.PRECO_PROMO : data.PRECO
      );
      $("#txtQtdeProduto").text(data.QTDE);
      $("#txtDescProduto").text(
        `${data.DESCRICAO.split("-")[0]} - ${data.DESC_COR ? data.DESC_COR : ''} - ${data.TAM}`
      );
    });
  } finally {
    $.LoadingOverlay("hide");
    $(this).focus();
  }
}

function limpaInfoProdutosPesquisaPreco() {
  $('#txtDescProduto').text('Descrição do produto');
  $('#txtPrecoProduto').text('R$ 0,00');
  $('#txtQtdeProduto').text('0');
}

async function buscaFotoProdPreco(codigo) {
  try {
    let url = "/Sisplan/Funcoes/v1/FotoItem?";
    let response = await requisicao("GET", url, `codigo=${codigo}`, null);

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      $("#infoprodimagem").attr(
        "src",
        "<?php echo BASE_URI; ?>/dist/img/prod-1.png"
      );
      return;
    }

    let sBase64 = jsonStr;
    if ($("#tabelaEstoquePreco").DataTable().rows().count() == 0) {
      $("#fotoPrecoProdutoMaterial").attr(
        "src",
        "<?php echo BASE_URI; ?>/dist/img/prod-1.png"
      );
    } else {
      $("#fotoPrecoProdutoMaterial").attr(
        "src",
        `data:image/png;base64,${sBase64.mensagem}`
      );
    }
  } catch (error) {
    console.error(error);
    $("#fotoPrecoProdutoMaterial").attr(
      "src",
      "<?php echo BASE_URI; ?>/dist/img/prod-1.png"
    );
  }
}

$("#pesquisaDesconto").on("shown.bs.modal", function () {
  $("#pesquisaDesconto .modal-body").trigger("click").focus();
});

$("#modalPrecos").on("shown.bs.modal", function () {
  $("#txtBarra").focus();
});

async function focaCampo() {
  const paramFoco = parametrosVenda[21];
  if (paramFoco == 1) {
    $("#txtQuantid").focus();
  }
  if (paramFoco == 2) {
    $("#txtCodigo").focus();
  } else {
    $("#txtCodigo").focus();
  }
}

async function retornaDescontoMaximoMoeda(codMoeda) {
  try {
    if (codMoeda != "") {
      const json = await retornaJsonPesquisaPadrao(
        `{"tabela": "moeda", "camposSelect": ["descmax"], "where": ["codmoe = '${codMoeda}'"] }`
      );
      if (json) {
        return parseFloat(json[0].DESCMAX);
      }
    }

    msgAlerta("Nenhuma moeda selecionada!");
    return;
  } catch (error) {
    console.error(error);
  }
}

async function retornaDescontoMaximoUsuario() {
  try {
    const url = "/sisplan/funcoes/v1/pesquisa?";
    let desconto;
    let usuario;
    if (getCookie("cod_usuario") === "0000") {
      usuario = "SISPLAN";
    } else {
      usuario = getCookie("usuario");
    }
    const response = await requisicao(
      "GET",
      url,
      `JSON={ "tabela":"acesso_usuarios", "camposSelect": ["desc_max"], "where": ["NOME = '${usuario}'"]}`,
      null
    );

    if (!response) {
      return;
    }

    const jsonStr = await response.json();

    if (
      jsonStr.RESULT[0][0].DESC_MAX != "" &&
      jsonStr.RESULT[0][0].DESC_MAX != null &&
      jsonStr.RESULT[0][0].DESC_MAX != undefined
    ) {
      desconto = jsonStr.RESULT[0][0].DESC_MAX;
    } else {
      desconto = 0;
    }

    return desconto;
  } catch (error) {
    console.error(error);
  }
}

async function retornaValoresDesconto() {
  try {
    const table = $("#tabelaItens").DataTable().rows();
    let somaValorTotalVenda = 0;

    let somaDescontoTotalVenda = $("#tabelaItens")
      .DataTable()
      .column(6, {})
      .data()
      .sum();
    for (let i = 0; i < table[0].length; i++) {
      somaValorTotalVenda += table.data()[i][2] * table.data()[i][3];
    }

    $("#somaDescontoTotalVenda").val(somaDescontoTotalVenda);
    $("#somaValorTotalVenda").val(somaValorTotalVenda);
  } catch (error) {
    console.error(error);
  }
}

async function verificaTotalDescontoUsuario() {
  try {
    const descontoTotalUsuario = await retornaDescontoMaximoUsuario();
    if (descontoTotalUsuario > 0) {
      if ($("#txtPercDescontoMoeda").val() > descontoTotalUsuario) {
        let descontoTotal =
          parseFloat($("#txtPercDescontoMoeda").val()) +
          parseFloat($("#txtPercDescontoMoeda").val());
        await senhaSupervisor(
          `Desconto de ${descontoTotal.toFixed(
            2
          )} % na venda, máximo do usuário é de ${descontoMaximoUsuario}%.`,
          verificaDescontoMaximoSupervisor, AplicaDescontoItem, true
        );
      }
    }
  } catch (error) {
    console.error(error);
  }
}

async function pegaDescontoOutrasMoedas() {
  try {
    const table = $("#tabelaCondicoesDePagamento").DataTable().rows();
    let somaDescontoTotalmMoeda = 0;
    for (let i = 0; i < table[0].length; i++) {
      somaDescontoTotalmMoeda += table.data()[i][11];
    }
    return somaDescontoTotalmMoeda;
  } catch (error) {
    console.error(error);
  }
}

async function verificaUsuarioPodeGravarCondicoes() {
  try {
    const url = `/sisplan/funcoes/v1/pesquisa?`;

    let usuario = "";
    if (getCookie("cod_usuario") === "0000") {
      usuario = "SISPLAN";
    } else {
      usuario = getCookie("usuario");
    }

    const response = await requisicao(
      "GET",
      url,
      `JSON={"tabela": "acesso_usuarios", "camposSelect": ["grava_condicao"], "where": ["NOME = '${usuario}'"] }`,
      null
    );

    if (!response) {
      return false;
    }

    const jsonStr = await response.json();

    if (jsonStr.RESULT[0][0].GRAVA_CONDICAO == "S") {
      return true;
    }
    return false;
  } catch (error) {
    console.error(error);
    return false;
  }
}

async function buscaDuplicatasEmAberto(codcli, todasEmpresas) {
  try {
    const url = "/sisplan/receber/v1/receberabertos?";
    const response = await requisicao(
      "GET",
      url,
      `CLIENTE=${codcli}&DUPLICATA=S&ANTECIPACAO=S&CHEQUE=S&CHEQUEDEV=S&TODASEMPRESAS=${todasEmpresas}`,
      null
    );

    if (!response) {
      return;
    }
    if (response.status != 200) {
      msgErro(response.mensagem);
      return;
    }

    const jsonStr = await response.json();

    return jsonStr;
  } catch (error) {
    console.error(error);
  }
}

async function carregaDuplicatas(codcli, todasEmpresas) {
  let bCliente = parametrosVenda[3];
  let bAtraso = parametrosVenda[23];
  if (pegaChave(bCliente) != codcli && bAtraso != "3") {
    try {
      await consultaDupAberto(codcli, todasEmpresas);
    } catch (error) {
      console.error(error);
    }
    if ($("#tabela-duplicatas").DataTable().rows().count() > 0) {
      $("#modal-receberabertos").modal("show");
    }
  }
};

async function consultaDupAberto(codcli, todasEmpresas) {
  let data = new Date();
  let vAVencer = 0;
  let vVencido = 0;
  let vAnteci = 0;
  let vCheqD = 0;
  let vAberto = 0;

  data = `${data.getUTCFullYear()}-${String(
    data.getUTCMonth() + 1
  ).padStart(2, 0)}-${String(data.getUTCDate()).padStart(2, 0)}`;

  const jsonStr = await buscaDuplicatasEmAberto(codcli, todasEmpresas);

  if (!jsonStr || jsonStr.length == 0) {
    return;
  }

  $("#tabela-duplicatas").DataTable().rows().remove().draw(false);

  $("#tabela-duplicatas").DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    scrollY: "300px",
    autowidth: true,
    language: {
      sEmptyTable: "Nenhum registro encontrado",
      sInfo: "_TOTAL_ registros",
      sInfoEmpty: " 0 registros",
      sInfoFiltered: "(Filtrados de _MAX_ registros)",
      sInfoPostFix: "",
      sInfoThousands: ".",
      sLengthMenu: "_MENU_ resultados",
      sLoadingRecords: "Carregando...",
      sProcessing: "Processando...",
      sZeroRecords: "Nenhum registro encontrado",
      sSearch: "Pesquisar",
      oPaginate: {
        sNext: "Próximo",
        sPrevious: "Anterior",
        sFirst: "Primeiro",
        sLast: "Último",
      },
      oAria: {
        sSortAscending: ": Ordenar colunas de forma ascendente",
        sSortDescending: ": Ordenar colunas de forma descendente",
      },
    },
  });

  for (let i = 0; i < jsonStr.length; i++) {
    $("#tabela-duplicatas")
      .DataTable()
      .row.add([
        jsonStr[i].NUMERO,
        `${jsonStr[i].DT_EMISSAO.split("-")[2]}/${jsonStr[i].DT_EMISSAO.split("-")[1]
        }/${jsonStr[i].DT_EMISSAO.split("-")[0]}`,
        `${jsonStr[i].DT_VENCTO.split("-")[2]}/${jsonStr[i].DT_VENCTO.split("-")[1]
        }/${jsonStr[i].DT_VENCTO.split("-")[0]}`,
        jsonStr[i].SALDO,
        jsonStr[i].EMP.replace("_", ""),
      ])
      .draw(false);
    if ((jsonStr[i].DT_VENCTO <= data) && (['DUPL', 'CHEQ'].includes(jsonStr[i].STATUS))) {
      vVencido = parseFloat(vVencido) + parseFloat(jsonStr[i].SALDO);
    } else if ((jsonStr[i].DT_VENCTO > data) && (['DUPL', 'CHEQ'].includes(jsonStr[i].STATUS))) {
      vAVencer = parseFloat(vAVencer) + parseFloat(jsonStr[i].SALDO);
    } else if (['ANTE'].includes(jsonStr[i].STATUS)) {
      vAnteci = parseFloat(vAnteci) + parseFloat(jsonStr[i].SALDO);
    } else if (['CHDE'].includes(jsonStr[i].STATUS)) {
      vCheqD = parseFloat(vCheqD) + parseFloat(jsonStr[i].SALDO);
    }
  }

  vAberto = parseFloat(vVencido) + parseFloat(vAVencer) + parseFloat(vCheqD) - parseFloat(vAnteci);
  $("#txtValDupVencer").html(vAVencer.toFixed(2));
  $("#txtValDupVencida").html(vVencido.toFixed(2));
  $("#txtValAntec").html(vAnteci.toFixed(2));
  $("#txtValChequeDevol").html(vCheqD.toFixed(2));
  $("#txtValTotAberto").html(vAberto.toFixed(2));
  $("#txtValDupVencida").css("color", "red");
  $("#txtValAntec").css("color", "green");
  $("#txtValChequeDevol").css("color", "purple");

  setTimeout(() => {
    $("#tabela-duplicatas").DataTable().columns.adjust().draw(false);
  }, 200);
};

async function verificaMoedaCarne(arrayMoeda) {
  let url = `/Sisplan/Funcoes/v1/pesquisa?`;
  let params = `JSON={ "tabela":"moeda", "camposSelect":["CODMOE","IMP_CARNE"], 
                                    "where": ["CODMOE IN (${arrayMoeda.toString()}) AND IMP_CARNE = 'S'"]}`;

  try {
    let response = await requisicao("GET", url, params, null);

    if (!response) {
      return;
    }

    let jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }
    if (jsonStr.RESULT[0].length == 0) {
      return false;
    }
    if (jsonStr.RESULT[0][0].IMP_CARNE == "S") {
      return true;
    }
    return false;
  } catch (error) {
    console.error(error);
  }
}

async function calculaAcrescimoVenda(
  campoAlterado,
  valorAcrescimo,
  percAcrescimo,
  valorBruto
) {
  try {
    $("#txtPercDescontoMoeda").prop("disabled", true);
    $("#txtValorDescontoMoeda").prop("disabled", true);

    if (campoAlterado === "txtPercAcrescMoeda") {
      valorAcrescimo =
        (valorBruto - parseFloat($("#txtValorDescontoMoeda").val())) *
        (percAcrescimo / 100);
      if (valorAcrescimo != undefined) {
        $("#txtValorAcrescMoeda").val(ArredondarValor(valorAcrescimo, 2));
        $("#txtPercAcrescMoeda").val(ArredondarValor(percAcrescimo, 2));
        $("#txtValorLiquidoMoeda").val(
          ArredondarValor(
            valorBruto -
            parseFloat($("#txtValorDescontoMoeda").val()) +
            valorAcrescimo,
            2
          )
        );
        $("#txtsaldo_a_pagar").html(
          parseFloat($("#txtValorLiquidoMoeda").val()).toLocaleString("pt-BR", {
            style: "currency",
            currency: "BRL",
          })
        );
        return;
      }
    }

    if (campoAlterado === "txtValorAcrescMoeda") {
      percAcrescimo =
        (valorAcrescimo / valorBruto -
          parseFloat($("#txtValorDescontoMoeda").val())) *
        100;

      if (valorAcrescimo != undefined) {
        $("#txtValorAcrescMoeda").val(ArredondarValor(valorAcrescimo, 2));
        $("#txtPercAcrescMoeda").val(ArredondarValor(percAcrescimo, 2));
        $("#txtValorLiquidoMoeda").val(
          ArredondarValor(
            valorBruto -
            parseFloat($("#txtValorDescontoMoeda").val()) +
            valorAcrescimo,
            2
          )
        );
        $("#txtsaldo_a_pagar").html(
          parseFloat($("#txtValorLiquidoMoeda").val()).toLocaleString("pt-BR", {
            style: "currency",
            currency: "BRL",
          })
        );
        return;
      }
    }
  } catch (error) {
    console.error(error);
    $("#txtPercDescontoMoeda").prop("disabled", false);
    $("#txtValorDescontoMoeda").prop("disabled", false);
  }
}

async function abreCadastroCepVenda() {
  $("#modal-CEP").css("z-index", 99999);
  $("#modal-CEP").modal("show");
  if ($("#modal-cliente").hasClass("modal show")) {
    if (
      $("#txtCep").val() != "" ||
      $("#txtCep").val() != undefined ||
      $("#txtCep").val() != null
    ) {
      $("#txt_Cep").val(
        `${$("#txtCep").val().substr(0, 5)}-${$("#txtCep").val().substr(-3)}`
      );
    }
  }
}

async function possuiTef(venda) {
  const emp_id = getCookie("emp_id");
  const url = `/Sisplan/Funcoes/v1/pesquisa?`;
  const params = `JSON={"tabela":"CONDIVENDA", "camposSelect":["OPERADOR", "NSU", "TEF_FINALIZACAO", "VLVENDA"], 
                        "where": ["CDVENDA = ${venda} AND EMP_ID = ${emp_id}"]}`;
  try {
    let response = await requisicao("GET", url, params, null);

    if (!response) {
      return false;
    }

    let jsonStr = await response.json();

    if (response.status != 200) {
      return false;
    }

    if (jsonStr.RESULT[0].length == 0) {
      return false;
    }

    if (
      jsonStr.RESULT[0][0].OPERADOR == "" ||
      jsonStr.RESULT[0][0].NSU == "" ||
      jsonStr.RESULT[0][0].TEF_FINALIZACAO == ""
    ) {
      return false;
    }

    return jsonStr.RESULT[0][0];
  } catch (error) {
    console.error(error);
    return false;
  }
}

async function verificaECancelaTEF(venda, cupom, tef) {

  const rede = tef.OPERADOR;
  const nsu = tef.NSU;
  const finalizado = tef.TEF_FINALIZACAO;
  const vlvenda = tef.VLVENDA;

  const url = `/tef/cancelartef?`;
  const params = `REDE=${rede}&NSU=${nsu}&FINALIZADO=${finalizado}&NRCUPOM=${cupom}&VALOR=${String(
    vlvenda
  ).replace(".", ",")}`;

  try {
    let response = await requisicao_ecf("GET", url, params, "", 300000);

    if (!response) {
      msgErro("Erro ao imprimir cupom de troca.");
      return [false];
    }

    const resp = await response.text();
    if (response.status != 200) {
      msgAlerta(resp != '' ? resp : 'TEF não foi cancelado.');
      return [false];
    }

    if (resp != '') {
      return [true, resp];
    }

    return [true];
  } catch (error) {
    console.error(error);
  }
}

async function RecalculaRegraPromocao(regras) {
  let sWhere;
  let sOrderBy;
  if (parametrosVenda[29] == 2) {
    const dataAtual = `${formataData(new Date())}`;
    sWhere = `REGRA_PROMOCAO.DT_INICIAL [MENORQUE] '${dataAtual}' AND REGRA_PROMOCAO.DT_FINAL [MAIORQUE] '${dataAtual}' AND REGRA_PROMOCAO.REGIAO ='${pegaChave("#txtTabela")}'`;
    sOrderBy = 'VALOR';
  } else {
    sWhere = `REGRA = '${regras}'`;
    sOrderBy = 'VALOR DESC';
  }
  const data = `${formataData(new Date())} 00:00:00`;
  const url = "/Sisplan/funcoes/v1/pesquisa?";
  const params = `JSON={ "tabela":"REGRA_PROMOCAO", "camposSelect":["REGRA", "SEQ", "VALOR", "DESCONTO", "TIPO", "CAMPO", "CHAVE", "OPERACAO", "MODELO",  "DT_INICIAL", "DT_FINAL", "EMPRESA", "REGIAO" ],
    "where": ["${sWhere}"],
    "orderby": ["${sOrderBy}"]}`;

  const response = await requisicao("GET", url, params, "", 15000);

  if (!response) {
    return;
  }

  let jsonRegra = await response.json();

  if (response.status != 200) {
    msgErro(jsonRegra.RESULT[0].mensagem);
    return;
  }

  let regra = jsonRegra.RESULT[0];

  // validacao
  if (parametrosVenda[29] == 2) {
    regra = regra.filter(function (obj) {
      const empresas = obj.EMPRESA.split(',');
      return empresas.includes(getCookie('emp_id'));
    });
  } else {
    for (let i = 0; i < regra.length; i++) {
      if (
        new Date(`${regra[i].DT_FINAL.substring(0, 10)} 00:00:00`) <
        new Date(data)
      ) {
        msgAlerta("Data da regra expirada!");
        $("#txtRegraPromocao").val("");
        SaidaCampoRegra();
        desbloqueiaTabela();
        return;
      }
      if (
        new Date(`${regra[i].DT_INICIAL.substring(0, 10)} 00:00:00`) >
        new Date(data)
      ) {
        msgAlerta("Data inicial da regra não vigente!");
        $("#txtRegraPromocao").val("");
        SaidaCampoRegra();
        desbloqueiaTabela();
        return;
      }
      if (regra[i].REGIAO != pegaChave("#txtTabela")) {
        msgAlerta("Tabela de preço não se usa essa regra!");
        $("#txtRegraPromocao").val("");
        SaidaCampoRegra();
        desbloqueiaTabela();
        return;
      }

      if (!regra[i].EMPRESA.includes(sessionStorage.getItem("emp_id"))) {
        msgAlerta("Essa empresa não tem acesso a essa regra!");
        $("#txtRegraPromocao").val("");
        SaidaCampoRegra();
        desbloqueiaTabela();
        return;
      }
    }
  }

  if (regra) {
    if (($("#tabelaItensRegraPromocao").DataTable().rows().count() > 0) && (parametrosVenda[29] != 2)) {
      if (
        $("#tabelaItensRegraPromocao").DataTable().rows().data()[0][0].REGRA !=
        regra[0].REGRA
      ) {
        $("#tabelaItensRegraPromocao").DataTable().rows().clear().draw(false);
        $("#tabelaItensUtilizamRegra").DataTable().rows().clear().draw(false);
        await montaTabelaItensRegra(regra);
      }
    } else {
      await montaTabelaItensRegra(regra);
    }
    await AplicaRegraPromocao(regra);
  }
}

function SaidaCampoRegra() {
  $("#btnRecalcularRegra").trigger("click");
}

function desbloqueiaTabela() {
  $("#txtTabela").prop("disabled", false);
  $("#btn-tabela").prop("disabled", false);
  $("#btn-limpa-tabela").prop("disabled", false);
}

async function montaTabelaItensRegra(regra) {
  try {
    let sWhere;
    if (parametrosVenda[29] == 2) {
      const valores = regra.map(function (obj) { return obj.REGRA }).join(',');
      if (valores == '') {
        return;
      }
      sWhere = `REGRA IN (${valores})`;
    } else {
      sWhere = `REGRA = '${pegaChave('#txtRegraPromocao')}'`;
    }
    const url = '/Sisplan/funcoes/v1/pesquisa?';
    const params = `JSON={ "tabela":"REGRA_PROMOCAOI", "camposSelect": ["REGRA", "CODIGO", "TIPO", "OPERACAO", "VALOR", "COR", "TAM"], "where": ["${sWhere}"]}`;
    const response = await requisicao('GET', url, params, '', 15000);
    let dataSet = [];
    let dataSetCols = [];

    if (!response) {
      return;
    }
    const jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }

    dataSet = jsonStr.RESULT;

    let keys = Object.keys(dataSet[0]);

    // keys.map((k) => {
    //   dataSetCols.push({
    //     'title': keys[k],
    //     'data': keys[k]
    //   });
    // });
    for (let k in keys) {
      dataSetCols.push({
        'title': keys[k],
        'data': keys[k]
      });
    }

    let tabelaItensRegraPromocao = $('#tabelaItensRegraPromocao').DataTable();
    tabelaItensRegraPromocao.clear().draw();

    tabelaItensRegraPromocao.rows.add(dataSet).draw();

    // $('#tabelaItensRegraPromocao').DataTable({
    //   paging: false,
    //   filter: false,
    //   info: false,
    //   order: false,
    //   destroy: true,
    //   autowidth: true,
    //   "language": {
    //     "sEmptyTable": "Nenhum registro encontrado",
    //     "sInfo": "_TOTAL_ registros",
    //     "sInfoEmpty": " 0 registros",
    //     "sInfoFiltered": "(Filtrados de MAX registros)",
    //     "sInfoPostFix": "",
    //     "sInfoThousands": ".",
    //     "sLengthMenu": "_MENU_ resultados",
    //     "sLoadingRecords": "Carregando...",
    //     "sProcessing": "Processando...",
    //     "sZeroRecords": "Nenhum registro encontrado",
    //     "sSearch": "Pesquisar",
    //     "oPaginate": {
    //       "sNext": "Próximo",
    //       "sPrevious": "Anterior",
    //       "sFirst": "Primeiro",
    //       "sLast": "Último"
    //     },
    //     "oAria": {
    //       "sSortAscending": ": Ordenar colunas de forma ascendente",
    //       "sSortDescending": ": Ordenar colunas de forma descendente"
    //     }
    //   },
    //   "columns": dataSetCols,
    //   "data": dataSet
    // });

    $('#tabelaItensUtilizamRegra').DataTable({
      paging: false,
      filter: false,
      info: false,
      order: false,
      destroy: true,
      autowidth: true,
      "language": {
        "sEmptyTable": "Nenhum registro encontrado",
        "sInfo": "_TOTAL_ registros",
        "sInfoEmpty": " 0 registros",
        "sInfoFiltered": "(Filtrados de MAX registros)",
        "sInfoPostFix": "",
        "sInfoThousands": ".",
        "sLengthMenu": "_MENU_ resultados",
        "sLoadingRecords": "Carregando...",
        "sProcessing": "Processando...",
        "sZeroRecords": "Nenhum registro encontrado",
        "sSearch": "Pesquisar",
        "oPaginate": {
          "sNext": "Próximo",
          "sPrevious": "Anterior",
          "sFirst": "Primeiro",
          "sLast": "Último"
        },
        "oAria": {
          "sSortAscending": ": Ordenar colunas de forma ascendente",
          "sSortDescending": ": Ordenar colunas de forma descendente"
        }
      },
    });

    $('#tabelaItensUtilizamRegra').DataTable().rows().clear().draw(false);

  } catch (error) {
    console.error(error);
  }
}

async function AplicaRegraPromocao(regra) {
  try {
    const itens = $("#tabelaItens").DataTable().rows().data();
    const itensRegra = $("#tabelaItensRegraPromocao").DataTable().rows().data();
    let itensUtilizamRegra = $("#tabelaItensUtilizamRegra")
      .DataTable()
      .rows()
      .data();

    let recordCount = 1;
    if (parametrosVenda[29] == 2) {
      recordCount = regra.length;
    }
    for (let j = 0; j < recordCount; j++) {
      let Quantidade = 0;
      let ValorItens = 0;
      let percDesconto = 0;
      let valorDesconto = 0;
      let itemEncontrado = 0;
      let itemNaoExisteNaRegra = 0;
      let regraP = 0;
      let ItemEstaNaRegra = 0;
      if (regra[j].MODELO == 1 || regra[j].MODELO == 3) {
        itens.each((item) => {
          if (regra[j].MODELO == 3) {
            itemEncontrado = itensRegra[0].filter(
              (itemRegra) =>
                itemRegra.REGRA === regra[j].REGRA &&
                itemRegra.CODIGO === item[0] &&
                itemRegra.COR === item[10] &&
                itemRegra.TAM === item[11]
            )[0];
          } else {
            itemEncontrado = itensRegra[0].filter(
              (itemRegra) => itemRegra.CODIGO === item[0] && itemRegra.REGRA === regra[j].REGRA
            )[0];
          }
          if (
            itemEncontrado != undefined &&
            itemEncontrado != null &&
            itemEncontrado != ""
          ) {
            itemNaoExisteNaRegra =
              itensUtilizamRegra.length > 0
                ? itensUtilizamRegra.filter(
                  (itemUtilizaRegra) => itemUtilizaRegra[0] === item[0]
                )[0]
                : true;
            if (itemNaoExisteNaRegra) {
              $("#tabelaItensUtilizamRegra")
                .DataTable()
                .row.add([
                  itemEncontrado.CODIGO,
                  itemEncontrado.COR,
                  itemEncontrado.OPERACAO,
                  itemEncontrado.REGRA,
                  itemEncontrado.TAM,
                  itemEncontrado.TIPO,
                  itemEncontrado.VALOR,
                ])
                .draw(false);
            }
            Quantidade += item[2];
            ValorItens += item[3];
          } else {
            // nao acontece nada feijoada
          }
        });

        // agora vai aplicar a regra nos itens
        if (regra[j].TIPO == "V") {
          if (parametrosVenda[29] == 2) {
            regraP = regra[j].VALOR <= ValorItens ? regra[j] : 0;
          } else {
            regraP = regra.find((regras) => regras.VALOR <= ValorItens);
          }
        } else {
          if (parametrosVenda[29] == 2) {
            regraP = regra[j].VALOR <= Quantidade ? regra[j] : 0;
          } else {
            regraP = regra.find((regras) => regras.VALOR <= Quantidade);
          }
        }

        if (itens.length > 0) {
          itensUtilizamRegra = $("#tabelaItensUtilizamRegra")
            .DataTable()
            .rows()
            .data();
          itens.each((item, i) => {
            if (regraP.MODELO == 1) {
              itemEncontrado = itensRegra[0].filter(
                (itemVenda) => itemVenda.CODIGO === item[0] && itemVenda.REGRA === regra[j].REGRA
              )[0];
            } else {
              itemEncontrado = itensRegra[0].filter(
                (itemVenda) =>
                  itemVenda.REGRA === regra[j].REGRA &&
                  itemVenda.CODIGO === item[0] &&
                  itemVenda.COR === item[10] &&
                  itemVenda.TAM === item[11]
              )[0];
            }

            if (
              itemEncontrado != undefined &&
              itemEncontrado != null &&
              itemEncontrado != ""
            ) {
              if (itensUtilizamRegra.length > 0) {
                ItemEstaNaRegra = itensUtilizamRegra.filter(
                  (itemExisteNaRegra) =>
                    itemExisteNaRegra[0] == itemEncontrado.CODIGO
                );
              }
              if (
                ItemEstaNaRegra != undefined &&
                ItemEstaNaRegra != null &&
                ItemEstaNaRegra != ""
              ) {
                if (itemEncontrado.VALOR > 0) {
                  if (itemEncontrado.OPERACAO == "D") {
                    percDesconto = itemEncontrado.VALOR;
                  } else if (item[3] > itemEncontrado.VALOR) {
                    percDesconto = 100 - ((itemEncontrado.VALOR / item[3]) * 100);
                  }
                } else {
                  percDesconto = regraP.DESCONTO;
                }

                // pega % desconto
                item[5] = ArredondarValor(percDesconto, 2);
                valorDesconto = quantidadeCasasDecimaisCampo > 2 ? moeda2float(float2moeda(item[3] * (percDesconto / 100), quantidadeCasasDecimaisCampo))
                  : ArredondarValor(item[3] * (percDesconto / 100), 2);
                // pega valor Desconto
                item[6] = valorDesconto;
                // ajusta o preco do item
                item[4] = quantidadeCasasDecimaisCampo > 2 ? moeda2float(float2moeda(item[3] - valorDesconto, quantidadeCasasDecimaisCampo))
                  : ArredondarValor(item[3] - valorDesconto, 2);
                // ajusta valor total dos itens
                item[7] = ArredondarValor(item[4] * item[2], 2);
                item[20] = valorDesconto;
                item[21] = item[3];
                item[22] = percDesconto;

                $("#tabelaItens").DataTable().row(i).data(item);
              }
            } else {
              if (parametrosVenda[29] != 2) {
                item[4] = item[3];
                item[5] = 0;
                item[6] = 0;
                item[7] = ArredondarValor(item[3] * item[2], 2);
                item[20] = 0;
                item[21] = 0;
                item[22] = 0;
                $("#tabelaItens").DataTable().row(i).data(item);
              }
            }
          });

          await atualizaTotalVenda();
        }
      } else {
        itens.each((item) => {
          if (regra[0].MODELO == 3) {
            itemEncontrado = itensRegra[0].filter(
              (itemRegra) =>
                itemRegra.REGRA === regra[j].REGRA &&
                itemRegra.CODIGO === item[0] &&
                itemRegra.COR === item[10] &&
                itemRegra.TAM === item[11]
            )[0];
          } else {
            itemEncontrado = itensRegra[0].filter(
              (itemRegra) => itemRegra.CODIGO === item[0] && itemRegra.REGRA === regra[j].REGRA
            )[0];
          }
          if (
            itemEncontrado != undefined &&
            itemEncontrado != null &&
            itemEncontrado != ""
          ) {
            itemNaoExisteNaRegra =
              itensUtilizamRegra.length > 0
                ? itensUtilizamRegra.filter(
                  (itemUtilizaRegra) => itemUtilizaRegra[0] === item[0]
                )[0]
                : true;
            if (itemNaoExisteNaRegra) {
              $("#tabelaItensUtilizamRegra")
                .DataTable()
                .row.add([
                  itemEncontrado.CODIGO,
                  itemEncontrado.COR,
                  itemEncontrado.OPERACAO,
                  itemEncontrado.REGRA,
                  itemEncontrado.TAM,
                  itemEncontrado.TIPO,
                  itemEncontrado.VALOR,
                ])
                .draw(false);
            }
            Quantidade += item[2];
            ValorItens += item[3];
          } else {
            // nao acontece nada feijoada
          }
        });

        // agora vai aplicar a regra nos itens
        if (regra[j].TIPO == "V") {
          if (parametrosVenda[29] == 2) {
            regraP = regra[j].VALOR <= ValorItens ? regra[j] : undefined;
          } else {
            regraP = regra.filter((regras) => regras.VALOR <= ValorItens);
          }
        } else {
          if (parametrosVenda[29] == 2) {
            regraP = regra[j].VALOR <= Quantidade ? regra[j] : undefined;
          } else {
            regraP = regra.filter((regras) => regras.VALOR <= Quantidade);
          }
        }

        switch (regra[j].OPERACAO) {
          case ">":
            if (regra[j].TIPO && ValorItens > regra[j].VALOR) {
              bCalculaRegra = true;
            } else if (Quantidade > regra[j].VALOR) {
              bCalculaRegra = true;
            }
            break;
          case "<":
            if (regra[j].TIPO && ValorItens > regra[j].VALOR) {
              bCalculaRegra = true;
            } else if (Quantidade > regra[j].VALOR) {
              bCalculaRegra = true;
            }
            break;
          case ">=":
            if (regra[j].TIPO && ValorItens > regra[j].VALOR) {
              bCalculaRegra = true;
            } else if (Quantidade > regra[j].VALOR) {
              bCalculaRegra = true;
            }
            break;
          case "<=":
            if (regra[j].TIPO && ValorItens > regra[j].VALOR) {
              bCalculaRegra = true;
            } else if (Quantidade > regra[j].VALOR) {
              bCalculaRegra = true;
            }
            break;
          case "=":
            if (regra[j].TIPO && ValorItens > regra[j].VALOR) {
              bCalculaRegra = true;
            } else if (Quantidade > regra[j].VALOR) {
              bCalculaRegra = true;
            }
            break;

          default:
            break;
        }
        itensUtilizamRegra = $("#tabelaItensUtilizamRegra")
          .DataTable()
          .rows()
          .data();

        itensUtilizamRegra.each((item, i) => {
          percDesconto = regraP.DESCONTO;

          // pega % desconto
          item[5] = ArredondarValor(percDesconto, 2);
          valorDesconto = ArredondarValor(item[3] * (percDesconto / 100), 2);
          // pega valor Desconto
          item[6] = valorDesconto;
          // ajusta o preco do item
          item[4] = ArredondarValor(item[3] - valorDesconto, 2);
          // ajusta valor total dos itens
          item[7] = ArredondarValor(item[4] * item[2], 2);
          item[20] = valorDesconto;
          item[21] = item[3];
          item[22] = percDesconto;

          $("#tabelaItens").DataTable().row(i).data(item);
        });
      }
    }
  } catch (error) {
    console.error(error);
  }
}

async function BuscaTiposVenda(id) {
  try {
    const url = "/sisplan/funcoes/v1/pesquisa?";
    let params;
    if (id != "") {
      params = `JSON={ "tabela":"VENDA_TIPO", "camposSelect":["ID", "DESCRICAO", "FECHA_VENDA", "ESTOQUE", "EXCLUSAO_ITEM"], "where": ["id = ${id}"], "orderby": ["ID"]}`;
    } else {
      params = `JSON={ "tabela":"VENDA_TIPO", "camposSelect":["ID", "DESCRICAO", "FECHA_VENDA", "ESTOQUE", "EXCLUSAO_ITEM"], "where": null, "orderby": ["ID"]}`;
    }
    const response = await requisicao("GET", url, params);

    if (!response) {
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.mensagem);
    }

    return jsonStr.RESULT[0];
  } catch (error) {
    console.error(error);
  }
}

async function criaSelectTiposVenda() {
  try {
    let tipoVendaPadrao = '';
    try {
      tipoVendaPadrao = parametrosVenda[71] != undefined ? parametrosVenda[71].substring(1, parametrosVenda[71].indexOf("]")) : '';
    } catch (error) {
      console.error(error)
    }
    const tipos = await BuscaTiposVenda("");
    $("#vendaMovimentaEstoque").prop("checked", true);

    tipos.forEach((tipo) => {
      $("#txtTipoVenda").append(
        `<option value="${tipo.ID}"> [${tipo.ID}] - ${tipo.DESCRICAO}</option>`
      );
    });

    if (tipoVendaPadrao != '') {
      $('#txtTipoVenda').val(tipoVendaPadrao);
    }
  } catch (error) {
    console.error(error);
  }
}

async function ExisteGuiaVendedor(CodRep) {
  const dadosSelect = {
    Tabela: "rep_guia",
    CamposSelect: ["rep_guia.guia"],
    Where: [`rep_guia.codrep = '${CodRep}'`],
  };

  const response = await retornaJsonPesquisaPadrao(
    encodeURIComponent(JSON.stringify(dadosSelect))
  );

  if (!response) {
    return;
  }
  const jsonStr = response;
  if (parseInt(jsonStr.length) <= 0) {
    return false;
  }
  return true;
}

async function validaCondPagto(codCond) {
  if (codCond == "") {
    return;
  }

  const url = `/sisplan/funcoes/v1/pesquisa?`;
  let validaCond = Boolean;
  try {
    const response = await requisicao(
      "GET",
      url,
      `JSON={ "tabela":"cond_item", "camposSelect":[ "parcela", "prazo"], "where": ["codcond = ${codCond}"] }`,
      null
    );

    if (!response) {
      return;
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      return false;
    }

    validaCond = jsonStr.RESULT[0].length > 0;

    if (!validaCond) {
      msgAlerta(
        `Prazos não configurados, favor verificar a condição de pagamento. \r\n Código da Condição: ${codCond}`
      );
      $("#btn-limpa-moeda").trigger("click");
    }

    return validaCond;
  } catch (error) {
    return false;
  }
}

async function validaCondicaoMoeda(codMoeda, codCond) {

  if (codCond == "" || codMoeda == "") {
    msgAlerta("Necessário informar uma moeda e uma condição de pagamento!");
    return;
  }

  const url = `/sisplan/funcoes/v1/pesquisa?`;
  try {
    const response = await requisicao("GET", url, `JSON={ "tabela":"COND_MOEDA", "camposSelect":["CODCOND"], "where": ["MOEDA = ${codMoeda}"] }`, null);

    if (!response) {
      return;
    }

    const jsonStr = await response.json();

    if (response.status != 200) {
      return;
    }

    const itemEncontrado = jsonStr.RESULT[0].filter((item) => item.CODCOND == codCond);

    if (itemEncontrado.length == 0) {
      msgAlerta("Condição não cadastrada na moeda selecionada!");
      return false;
    }
    return true;


  } catch (error) {
    return false;
  }
}

async function imprimirCupomTrocaSemECF(NumeroVenda, tabela, bImpressaoVenda = false) {
  let dadosBackEnd = {};
  let arrayDados = [];
  let cupomUnico = '';


  if (bImpressaoVenda) {
    for (let i = 0; i < tabela.length; i++) {
      if (tabela[i][17] == true) {
        dadosBackEnd = {
          SEL: $(`#cb_itens_troca_${i}`).prop('checked') ? 'S' : 'N',
          VENDA: NumeroVenda,
          ORDEM: +i,
          CODIGO: tabela[i][0],
          DESCRICAO: tabela[i][1],
          COR: tabela[i][10],
          DESC_COR: tabela[i][12],
          TAM: tabela[i][1],
          QTDE: tabela[i][2],
          CUPOMUNICO: true
        }; imprimirCupomTrocaSemECF
        arrayDados.push(dadosBackEnd);
      }
    }
  } else {
    for (let i = 0; i < tabela.length; i++) {
      if ($(`#cb_itens_troca_${i}`).prop("checked") == true) {
        dadosBackEnd = {
          SEL: $(`#cb_itens_troca_${i}`).prop('checked') ? 'S' : 'N',
          VENDA: pegaChave("#venda-cupom-troca"),
          ORDEM: +tabela[i][1],
          CODIGO: tabela[i][2],
          DESCICAO: tabela[i][3],
          COR: tabela[i][4],
          DESC_COR: tabela[i][5],
          TAM: tabela[i][6],
          QTDE: tabela[i][7],
          CUPOMUNICO: $('#inputCupomUnico').prop('checked')
        };
        arrayDados.push(dadosBackEnd);
      }
    }
  }

  if (arrayDados.length != 0) {
    const url = `/sisplan/cupom/v1/imprimircupomtroca?`;
    const params = `JSON=${JSON.stringify(arrayDados)}&VENDACUPOM=${NumeroVenda}`;
    const response = await requisicao("GET", url, params, null);
    const arquivo = await response.text();

    if (arquivo != undefined) {
      window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
      await limparRelatorios();
    }
  }
}

function mantemDuasCasasDecimais(valor, quantidadeCaracteres) {
  if (valor.toString().indexOf('.') > -1) {
    return parseFloat(valor.toString().substring(0, valor.toString().indexOf('.') + quantidadeCaracteres));
  }
  return valor;
}

async function validaRegrasMontadasVenda(bCliente) {
  try {

    if (bCliente) {
      await executaRegraCliente();
    }

  } catch (error) {
    console.error(error);
  }
}

async function verificaRegrasMontadas(bCliente = true) {

  async function verificaSeExisteRegraParaOtipoDaVenda() {
    try {
      const tipoVenda = $('#txtTipoVenda').val();
      const json = await retornaJsonPesquisaPadrao(`{"tabela": "REGRA_VENDA", "camposSelect": ["VENDA_TIPO"], "where": ["VENDA_TIPO = '${tipoVenda}'"] }`);


      if (json) {
        return true;
      }

      return false;

    } catch (error) {
      console.error(error);
    }
  }

  try {
    const regras = await verificaSeExisteRegraParaOtipoDaVenda();

    if (regras) {

      await validaRegrasMontadasVenda(bCliente);

    }

  } catch (error) {
    console.error(error);
  }
}

async function executaRegraCliente() {
  try {
    const sCodcli = pegaChave('#txtCliente');
    const tipoVenda = $('#txtTipoVenda').val();
    const url = '/sisplan/regrasmontadasvenda/v1/regrasmontadasvenda?';
    const parametros = window.location.href.split('/');
    const numero_venda = parametros[parametros.length - 1];
    const params = `CODCLI=${sCodcli}&TIPOVENDA=${tipoVenda}&CODVEN=${numero_venda}`;
    const response = await requisicao("GET", url, params, null);

    if (!response) {
      return;
    }

    if (response.status != 200) {
      return;
    }

    const jsonStr = await response.json();

    if (jsonStr.tipo_msg == 'S') {
      senhaSupervisor(jsonStr.mensagem,
        () => { }, '', false,
        () => { $('#txtCliente').val(''); },
        () => { $('#txtCliente').val(''); },
        () => { $('#txtCliente').val(''); });
      return;
    }

    if (jsonStr.tipo_msg == 'B') {
      msgErro(jsonStr.mensagem);
      $('#txtCliente').val('');
      return;
    }

    if (jsonStr.tipo_msg == 'A') {
      msgAlerta(jsonStr.mensagem);
      return;
    }

  } catch (error) {
    console.error(error);
  }
}

async function estornaReceberErroCupom(venda) {
  try {
    const url = '/sisplan/vendas/v1/estornarecebererrocupom?';
    const response = await requisicao('POST', url, `CODVENDA=${venda.codVenda}`, `JSON=${encodeURIComponent(JSON.stringify(venda))}`, 30000);
    if ((!response) || (response.status != 200)) {
      return;
    }

    if (response.status != 200) {
      return;
    }

  } catch (error) {
    console.error(error);
  }
}

async function permiteVenda(grupo) {
  try {
    const pesquisaParam = {
      tabela: 'GRUPO_MA',
      camposSelect: ['GRUPO_MA.PERMITEVENDA'],
      where: [`GRUPO_MA.CODIGO = '${grupo}'`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr[0].PERMITEVENDA == 'S') {
      return true;
    } else {
      return false;
    }

  } catch (error) {
    console.log(error)
  }
}

function adicionaLogVenda(tela, chave, descricao, operacao) {
  const objetoLog = {
    tela,
    chave,
    descricao,
    operacao,
  };

  listaLogsVenda.push(objetoLog);
}

async function gravaLogsVenda(codven) {
  if (listaLogsVenda.length > 0) {
    listaLogsVenda.forEach(async (log) => {
      await rotinaGeraLog(log.tela, codven, log.descricao, log.operacao)
    })
  }

  listaLogsVenda = [];
}

async function buscaVendedorCliente(codCli) {
  try {
    if (($('#txtVendedor').val() != '') || (codCli == '')) {
      return;
    }
    const pesquisaParam = {
      tabela: 'ENTIDADE',
      camposSelect: ['ENTIDADE.CODREP, REPRESEN.NOME'],
      leftJoin: [{ "tabela": "represen", "condicao": "represen.codrep = entidade.codrep" }],
      innerJoin: [{ "tabela": "EMP_VALOR", "condicao": `ENTIDADE.CODREP = EMP_VALOR.VALOR AND EMP_VALOR.TABELA = 'REPRESEN' AND EMP_VALOR.EMP_ID = ${getCookie("emp_id")}` }],
      where: [`ENTIDADE.CODCLI = '${codCli}'`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr.length <= 0) {
      return;
    }

    if (jsonStr[0].CODREP != '') {
      insereValor('#txtVendedor', jsonStr[0].CODREP, jsonStr[0].NOME);
      $('#txtVendedor').trigger('blur');
    }
    return;
  } catch (error) {
    console.log(error)
  }
}

async function buscaGuiaCliente(codCli, utilizaGuia) {
  try {
    if (($('#txtGuia').val() != '') || (codCli == '') || utilizaGuia != '3') {
      return;
    }
    const pesquisaParam = {
      tabela: 'ENTIDADE',
      camposSelect: ['ENTIDADE.CODREP, REPRESEN.NOME'],
      leftJoin: [{ "tabela": "represen", "condicao": "represen.codrep = entidade.codrep" }],
      where: [`ENTIDADE.CODCLI = '${codCli}'`]
    };

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    if (jsonStr[0].CODREP != '') {
      insereValor('#txtGuia', jsonStr[0].CODREP, jsonStr[0].NOME);
      $('#txtGuia').trigger('blur');
    }
    return;
  } catch (error) {
    console.log(error)
  }
}
