<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Caixa</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.237.17.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.237.17.1">
  <!-- Google Font: Source Sans Pro -->
  <!-- <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet"> -->
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.237.17.1" />

  <link href='../dist/css/bootstrap.min.css?versao=3.237.17.1'>
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.237.17.1">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.237.17.1">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.237.17.1">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.237.17.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.237.17.1" />
  <link rel="stylesheet" href="plugins/datatables-colreorder/css/colReorder.bootstrap4.min.css?versao=3.234.11.1">
  <!-- AutoComplete -->
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.237.17.1">

  <style>
    .troco_off {
      border: none !important;
    }

    .ui-autocomplete-loading {
      background: white url("./dist/img/ui-anim_basic_16x16.gif") center center no-repeat;
    }


    .input-group button,
    .input-group input {
      height: 40px;
    }

    .input-group button {
      min-width: 45px;
    }

    .btn.bg-danger {
      border: 1px solid white;
    }

    th {
      white-space: nowrap;
    }
    #tabelaVendasGrid thead, #tabelaVendasGrid tbody {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    /* th, td {
    border-top: 1px solid #dddddd;
    border-bottom: 1px solid #dddddd;
    border-right: 1px solid #dddddd;
  } */

    th:first-child {
      border-left: 1px solid #dddddd;
    }

    .info-box-text {
      font-size: 20px;
      font-weight: bold;
      color: grey;
    }

    #tabelaVendas th,
    #tabelaVendas td,
    #tabelaManual th,
    #tabelaManual td {
      min-height: 40px !important;
      border-top: none !important;
      border-bottom: 0px;
      border-right: 0px;
      border-left: 0px;
    }

    #cardPrincipal {
      min-height: 400px;
      display: flex;
      justify-content: center;
    }
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../menu.php');
    ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Fechamento de Caixa</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i>
              </button>
            </div><!-- /.col -->
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="./index">Início</a></li>
                <li class="breadcrumb-item"><a href="./loja">Loja</a></li>
                <li class="breadcrumb-item active">Fechamento de Caixa</li>
              </ol>
            </div><!-- /.col -->
          </div><!-- /.row -->

          <div class="row mt-4">
            <div class="col-md-3 col-sm-3 col-12">
              <div class="info-box">
                <span class="info-box-icon bg-info"><i class="fas fa-history"></i></span>
                <div class="info-box-content">
                  <span class="info-box-text">Total Saldo Anterior</span>
                  <span class="info-box-number" id="txt_val_saldo_anterior">0.00</span>
                </div>
              </div>
            </div>
            <div class="col-md-3 col-sm-3 col-12">
              <div class="info-box">
                <span class="info-box-icon bg-info"><i class="fas fa-coins"></i></span>
                <div class="info-box-content">
                  <span class="info-box-text">Total Entradas</span>
                  <span class="info-box-number" id="txt_val_entradas">0.00</span>
                </div>
              </div>
            </div>
            <div class="col-md-3 col-sm-3 col-12">
              <div class="info-box">
                <span class="info-box-icon bg-success"><i class="fas fa-money-bill"></i></span>

                <div class="info-box-content">
                  <span class="info-box-text">Total Saídas</span>
                  <span class="info-box-number" id="txt_val_saidas">0.00</span>
                </div>
              </div>
            </div>
            <div class="col-md-3 col-sm-3 col-12">
              <div class="info-box">
                <span class="info-box-icon bg-danger"><i class="fas fa-dollar-sign"></i></span>

                <div class="info-box-content">
                  <span class="info-box-text">Total Saldo</span>
                  <span class="info-box-number" id="txt_val_saldo">0.00</span>
                </div>
              </div>
            </div>
          </div>
          <!-- final dos info box -->

          <div class="card" id="cardPrincipal">
            <div class="row ml-2 mt-3 mr-2" id="tourbotoes">
              <div class="col-sm-12 mt-12">
                <div class="row">
                  <div class="col-lg-4 col-12">
                    <label data-error="wrong" data-success="right" for="txtCaixa">Caixa</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtCaixa" name="txtCaixa" class="form-control" placeholder="Caixa" disabled>
                      <div class="input-group-append">
                        <button class="btn bg-danger d-none" id="btn-impostor" name="btn-impostor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-caixa" name="btn-caixa" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-4 col-12">
                    <div class="group-default form-group">
                      <label for="dtIni">Data:</label>
                      <div class="relative">
                        <input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDataDe" name="txtDataDe">
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-sm-6 mt-3">
                <button id="btn-relatorio" class="btn-sisp btn btn-secondary"><i class="fas fa-print"></i>
                  Relatório</button>
                <button class="btn btn-primary btn-sisp" data-toggle="modal" id="btnSangria" data-target=".bd-sangria-modal-sm">Sangria</button>
                <button class="btn btn-primary btn-sisp" data-toggle="modal" id="btnSuprimento" data-target=".bd-suprimento-modal-sm">Suprimento</button>
              </div>
            </div>

            <div class="card-body">
              <div class="card" id="tourlancamentosmanuais">
                <div class="modal-body">
                  <nav>
                    <div class="nav nav-tabs justify-content-center" id="nav-tab" role="tablist" style="text-decoration: none">
                      <a class="nav-link abaLink active" id="tabLancManuais" data-toggle="tab" href="#divLancManuais" role="tab" aria-controls="divLancManuais" aria-selected="true">Lançamentos Manuais</a>
                      <a class="nav-link abaLink" id="tabVendas" data-toggle="tab" href="#divVendas" role="tab" aria-controls="divVendas" aria-selected="false">Vendas</a>
                    </div>
                  </nav>
                  <div class="tab-content" id="nav-tabContent">

                    <div class="tab-pane fade show active" id="divLancManuais" role="tabpanel" aria-labelledby="tabLancManuais">
                      <div class="card-body">
                        <div class="row pt-2 escondeCampos">
                          <div class="form-group col-sm-2">
                            <label>Operação</label>
                            <select id="rgOperacao" class="custom-select">
                              <option value="E" selected>Entrada</option>
                              <option value="S">Saída</option>
                            </select>
                          </div>
                          <div class="form-group col-sm-4">
                            <label>Observação</label>
                            <input type="text" class="form-control" id="txtObs" maxlength="60">
                          </div>
                          <div class="form-group col-sm-4">
                            <label>Valor</label>
                            <input type="text" class="form-control" id="txtValor">
                          </div>
                          <div class="form-group col-sm-2">
                            <label>Moeda</label>
                            <select id="rgMoeda" class="custom-select">
                            </select>
                          </div>
                        </div>
                        <div class="row escondeCampos d-flex" id="botoesTabelaManual">
                          <!-- <div class="form-group col-sm-12"> -->
                          <input id="btnIncluir" type="submit" style="font-size:15px;" class="ml-auto btn btn-danger btn-lg action-button btn-sisp" value="Incluir">
                          <!-- </div> -->
                        </div>
                        <div class="row pt-2">
                          <div class="col-sm-12 table-responsive">
                            <table id="tabelaManual" class="table table-sm table-select table-hover" width="100%">
                              <thead>
                                <tr>
                                  <th class="th-sm">Código
                                  </th>
                                  <th class="th-sm">Moeda
                                  </th>
                                  <th class="th-sm">Valor
                                  </th>
                                  <th class="th-sm">Juros
                                  </th>
                                  <th class="th-sm">Valor Orig
                                  </th>
                                  <th class="th-sm">Data Vencto
                                  </th>
                                  <th class="th-sm">Operação
                                  </th>
                                  <th class="th-sm">Duplicata
                                  </th>
                                  <th class="th-sm">Observação
                                  </th>
                                  <th class="th-sm">Ordem
                                  </th>
                                  <th class="th-sm">Opções
                                  </th>
                                </tr>
                              </thead>
                            </table>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="tab-pane fade show active" id="divVendas" role="tabpanel" aria-labelledby="tabVendas">
                      <div class="card-body">
                        <div class="row d-flex" id="botoesTabelaVendas">
                        </div>
                        <div class="row pt-2">
                          <div class="col-sm-12 table-responsive">
                            <table id="tabelaVendasGrid" class="table table-sm table-select table-hover" width="100%">
                              <thead>
                                <!-- <tr>
                                  <th class="th-sm">Venda
                                  </th>
                                  <th class="th-sm">Forma Pagto.
                                  </th>
                                  <th class="th-sm">Condição
                                  </th>
                                  <th class="th-sm">Quantidade
                                  </th>
                                  <th class="th-sm">Valor Bruto
                                  </th>
                                  <th class="th-sm">Valor
                                  </th>
                                </tr> -->
                              </thead>
                            </table>
                          </div>
                        </div>
                      </div>
                    </div>

                  </div>
                </div>
              </div>
            </div>

            <!-- <div class="card-body">
              <div class="card" id="tourlancamentosmanuais">
                <div class="card-body">
                  <div class="row">
                    <div class="col-12">
                      <h5><b> Lançamentos Manuais</b></h5>
                    </div>
                  </div>
                  <div class="row pt-2 escondeCampos">
                    <div class="form-group col-sm-2">
                      <label>Operação</label>
                      <select id="rgOperacao" class="custom-select">
                        <option value="E" selected>Entrada</option>
                        <option value="S">Saída</option>
                      </select>
                    </div>
                    <div class="form-group col-sm-4">
                      <label>Observação</label>
                      <input type="text" class="form-control" id="txtObs" maxlength="60">
                    </div>
                    <div class="form-group col-sm-4">
                      <label>Valor</label>
                      <input type="text" class="form-control" id="txtValor">
                    </div>
                    <div class="form-group col-sm-2">
                      <label>Moeda</label>
                      <select id="rgMoeda" class="custom-select">
                      </select>
                    </div>
                  </div>
                  <div class="row escondeCampos">
                    <div class="form-group col-sm-12">
                      <input id="btnIncluir" type="submit" style="font-size:15px;" class="float-right btn btn-danger btn-lg action-button btn-sisp" value="Incluir">
                    </div>
                  </div>
                  <div class="row pt-2">
                    <div class="col-sm-12 table-responsive">
                      <table id="tabelaManual" class="table table-sm table-select table-hover" width="100%">
                        <thead>
                          <tr>
                            <th class="th-sm">Código
                            </th>
                            <th class="th-sm">Moeda
                            </th>
                            <th class="th-sm">Valor
                            </th>
                            <th class="th-sm">Juros
                            </th>
                            <th class="th-sm">Valor Orig
                            </th>
                            <th class="th-sm">Data Vencto
                            </th>
                            <th class="th-sm">Operação
                            </th>
                            <th class="th-sm">Duplicata
                            </th>
                            <th class="th-sm">Observação
                            </th>
                            <th class="th-sm">Ordem
                            </th>
                            <th class="th-sm">Opção
                            </th>
                          </tr>
                        </thead>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
            </div> -->

            <div class="card-body" id="caixatour" style="margin-top: -2.5rem;">
              <div class="card">
                <div class="card-body">
                  <div class="row">
                    <div class="col-12">
                      <h5><b>Caixa</b></h5>
                    </div>
                  </div>
                  <div class="row d-flex" id="botoesTabelaCaixa">
                  </div>
                  <div class="row pt-2">
                    <div class="col-sm-12 table-responsive">
                      <table id="tabelaVendas" class="table table-sm table-select table-hover shadow-sm  p-3 mb-5 bg-body rounded" width="100%">
                        <thead>
                          <tr>
                            <th class="th-sm">Código
                            </th>
                            <th class="th-sm">Descrição
                            </th>
                            <th class="th-sm">Condição
                            </th>
                            <th class="th-sm">Saldo Anterior
                            </th>
                            <th class="th-sm">Entradas
                            </th>
                            <th class="th-sm">Saídas
                            </th>
                            <th class="th-sm">Saldo Atual
                            </th>
                            <th class="th-sm">Troco
                            </th>
                            <th class="th-sm">A Retirar
                            </th>
                            <th class="th-sm">Saldo Final
                            </th>
                          </tr>
                        </thead>
                      </table>
                    </div>
                  </div>

                  <div class="float-right mt-2">
                    <input id="btnGravar" type="submit" style="font-size:15px;" class="btn btn-danger btn-lg action-button  btn-sisp mt-2" value="Fechar Caixa">
                    <input id="btnAbrir" type="submit" style="font-size:15px;" class="btn btn-danger btn-lg action-button  btn-sisp mt-2" value="Reabrir Caixa">
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <button id="btnConsultar" class='btn btn-primary btn-sisp d-none' type='button'><span class="fas fa-search"></span>Consultar </button>

  <?php
  include_once('../../footer.php');
  ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->

  <!-- jQuery -->
  <script src="plugins/jquery/jquery.min.js?versao=3.237.17.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.237.17.1"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.237.17.1"></script>
  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    if ($('[type="date"]').prop('type') != 'date') {
      $('[type="date"]').datepicker();
    }
    $.widget.bridge('uibutton', $.ui.button)
  </script>

  <!-- Bootstrap 4 -->
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.237.17.1"></script>
  <script src="dist/js/sisplan.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="utils/funcoes.js?versao=3.237.17.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="dist/js/loadingoverlay.min.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.237.17.1"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.237.17.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.237.17.1"></script>
  <script src="utils/cookies.js?versao=3.237.17.1"></script>
  <!-- SweetAlert2 -->
  <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.235.30.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.235.30.1"></script>
  <script src="pages/loja/js/rotinas.js?versao=3.235.30.1"></script>
  <script src="dist/js/driver.min.js?versao=3.235.30.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.235.30.1"></script>
  <script type="text/javascript" src="config.js?versao=3.235.30.1"></script>
  <script src="plugins/datatables-colreorder/js/dataTables.colReorder.min.js?versao=3.237.17.1"></script>
  <script>
    $('#tutorial').on('click', function() {
      $(document).ready(async function() {
        const driver = new Driver({
          doneBtnText: 'Sair',
          closeBtnText: 'Fechar',
          nextBtnText: 'Próximo',
          prevBtnText: 'Anterior',
          allowClose: false,
        });
        driver.defineSteps([{
            element: '.mt-4',
            popover: {
              title: 'Totais do Caixa',
              description: 'Aqui você poderá ver os valores totais do caixa.',
              position: 'bottom'
            }
          },
          {
            element: '#tourbotoes',
            popover: {
              title: 'Botões',
              description: 'Aqui estão os botões do caixa, onde você poderá filtrar sua busca, imprimir um relatório, fazer uma sangria ou um suprimento.',
              position: 'bottom'
            }
          },
          {
            element: '#tourlancamentosmanuais',
            popover: {
              title: 'Lançamentos Manuais',
              description: 'Aqui você poderá ver e criar lançamentos manuais para o caixa.',
              position: 'top'
            }
          },
          {
            element: '#caixatour',
            popover: {
              title: 'Dados Caixa',
              description: 'Aqui você poderá verificar os valores de cada moeda, sendo possível adicionar o valor de troco nas moedas que possuem essa opção.',
              position: 'top'
            }
          },
          {
            element: '#btnGravar',
            popover: {
              title: 'Botão Fechar Caixa',
              description: 'Clicando aqui você efetua o fechamento de caixa, após verificar os dados do passo anterior.',
              position: 'left'
            }
          }
        ]);
        //iniciar tour
        driver.start();
      });
    });

    $(document).ready(async function() {

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      const temAcesso = await temAcessoTela('LOJA_CAIXA');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      if (await CopiaParametro('VENDA', 66) == 1) {
        await senhaSupervisor('', () => {}, '', false, () => {
          window.location.href = 'index'
        }, () => {
          window.location.href = 'index'
        }, () => {
          window.location.href = 'caixa'
        });
      }

      const parametrosVenda = await BuscaParametrosVenda();
      const utilizaProcessoCaixaCego = parametrosVenda[64] == '1';

      if (utilizaProcessoCaixaCego) {
        window.location.href = `${BASE_URI}/contagem_caixa`;
        return;
      }

      await setarDataAtual('txtDataDe');

      $('#txtDataDe').on('blur', async function() {
        $('#btnConsultar').trigger('click');
      });

      async function usuarioMasterOuSupervisor() {
        try {
          const usuario = await retornaJsonPesquisaPadrao(`{"tabela": "ACESSO_USUARIOS", "camposSelect": ["TIPO"], "WHERE": ["CODIGO = '${getCookie('cod_usuario')}'"] }`) ?? 0;

          return usuario[0].TIPO != 0;

        } catch (error) {
          console.error(error);
        }
      }

      function changeCaixa() {
        if ($('#txtCaixa').val() == '') {
          $('#btn-caixa').trigger('click');
          return;
        }
        $('#btnConsultar').trigger('click');
      }

      sEmpresa = getCookie('empresa');

      let abaAtiva;

      let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

      if (colunas == null || colunas.fechamentoCaixaManual == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({
          ...colunas,
          fechamentoCaixaManual: []
        }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
      }

      if (colunas == null || colunas.fechamentoCaixaVendas == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({
          ...colunas,
          fechamentoCaixaVendas: []
        }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
      }

      if (colunas == null || colunas.fechamentoCaixa == undefined) {
        localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({
          ...colunas,
          fechamentoCaixa: []
        }))
        colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
      }

      $('#btnConfirmarColunas').on('click', async function() {
        try {
          $.LoadingOverlay('show');

          const novasColunas = retornaNovasColunasInvisiveis();
          let cols = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

          if (abaAtiva == '1') {
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({
              ...cols,
              fechamentoCaixa: novasColunas
            }))
            $('#tabelaVendas').DataTable().columns().visible(true);

            $('#tabelaVendas').DataTable().columns().every(
              function() {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                  this.visible(false);
                }
              })
          } else if (abaAtiva == '2') {
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({
              ...cols,
              fechamentoCaixaManual: novasColunas
            }))
            $('#tabelaManual').DataTable().columns().visible(true);

            $('#tabelaManual').DataTable().columns().every(
              function() {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                  this.visible(false);
                }
              })
          } else {
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({
              ...cols,
              fechamentoCaixaVendas: novasColunas
            }))
            $('#tabelaVendasGrid').DataTable().columns().visible(true);

            $('#tabelaVendasGrid').DataTable().columns().every(
              function() {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                  this.visible(false);
                }
              })
          }

        } finally {
          $.LoadingOverlay('hide');
          $('#modal-ColunasVisiveis').modal('hide');
        }
      })

      var bUsaECF = await CopiaParametro('VENDA', 8);
      $("#txtMoedaSangria").pesquisa("#txtMoedaSangria", "CODMOE", "DESCRICAO",
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": ["DESCRICAO LIKE '[PERCENTUAL]DINHEIRO[PERCENTUAL]'"]}`,
        "Pesquisa Moeda", "moeda");
      $("#txtMoedaSuprimento").pesquisa("#txtMoedaSuprimento", "CODMOE", "DESCRICAO",
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": ["DESCRICAO LIKE '[PERCENTUAL]DINHEIRO[PERCENTUAL]'"]}`,
        "Pesquisa Moeda", "moeda");
      $('#txtCaixa').pesquisa('#txtCaixa', 'CODIGO', 'DESCRICAO',
        '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAIXA_LOJA", "camposSelect":[ "CODIGO", "descricao"]}',
        'Pesquisa Caixa', 'CAIXA_LOJA', null, changeCaixa);
      $('#btn-caixa').pesquisa('#txtCaixa', 'CODIGO', 'DESCRICAO',
        '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CAIXA_LOJA", "camposSelect":[ "CODIGO", "descricao"]}',
        'Pesquisa Caixa', 'CAIXA_LOJA', null, changeCaixa);
      $("#btn-MoedaSangria").pesquisa("#txtMoedaSangria", "CODMOE", "DESCRICAO",
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": ["DESCRICAO LIKE '[PERCENTUAL]DINHEIRO[PERCENTUAL]'"]}`,
        "Pesquisa Moeda", "moeda");
      $("#btn-MoedaSuprimento").pesquisa("#txtMoedaSuprimento", "CODMOE", "DESCRICAO",
        `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"moeda", "camposSelect":[ "codmoe", "descricao" ], "where": ["DESCRICAO LIKE '[PERCENTUAL]DINHEIRO[PERCENTUAL]'"]}`,
        "Pesquisa Moeda", "moeda");

      $("#btn-limpa-MoedaSangria").on("click", function() {
        $("#txtMoedaSangria").val("");
      });
      $("#btn-limpa-MoedaSuprimento").on("click", function() {
        $("#txtMoedaSuprimento").val("");
      });

      $('#btnLancaManual').on('click', function() {
        $('#modal-lancamento').modal('show');
      });


      function NaoTemCaixaVinculado() {
        return !sessionStorage.getItem('g_caixa_logado') || sessionStorage.getItem('g_caixa_logado') == 'undefined';
      }

      async function VinculaCaixaComUsuario() {
        const _url = '/sisplan/funcoes/v1/pesquisa?';
        const nomeUsuario = getCookie('cod_usuario') == '0000' ? 'SISPLAN' : getCookie('usuario');
        const _usuarioCaixa =
          `JSON={"tabela": "VENDA_CAIXA", 
          "camposSelect": ["VENDA_CAIXA.NRCAIXA", "VENDA_CAIXA.USUARIO", "CAIXA_LOJA.DESCRICAO", "VENDA_CAIXA.EMP_ID"], 
          "where": ["VENDA_CAIXA.USUARIO = '${nomeUsuario}'"],
          "innerjoin": [{"tabela" : "CAIXA_LOJA", "condicao" : "CAIXA_LOJA.CODIGO = VENDA_CAIXA.NRCAIXA"}]}`;
        try {
          const response = await requisicao('GET', _url, _usuarioCaixa, nomeUsuario, null);
          if (!response) {
            msgErro('Erro ao buscar caixas vinculados ao usuário.');
            return;
          }

          if (response.status == 200) {
            var jsonStr = await response.json();
            if (jsonStr['RESULT'][0].length >= 1) {
              const dados = jsonStr.RESULT[0];
              const dadosFiltrados = dados.filter(dado => dado.EMP_ID == getCookie('emp_id'));
              const possuiVinculoEmpresaLogada = dadosFiltrados.length > 0;
              if (possuiVinculoEmpresaLogada) {
                const caixa = '[' + dadosFiltrados[0].NRCAIXA + '] - ' + dadosFiltrados[0].DESCRICAO;
                sessionStorage.setItem('g_caixa_logado', caixa);
              } else {
                const sCaixa = '[' + jsonStr['RESULT'][0][0].NRCAIXA + '] - ' + jsonStr['RESULT'][0][0].DESCRICAO;
                sessionStorage.setItem('g_caixa_logado', sCaixa);
              }
              $('#btn-impostor').removeClass('d-none');
              $('#btn-caixa').addClass('d-none');
            }
          } else {
            msgErro('Erro ao buscar caixas vinculados ao usuário.');
            return;
          }
        } catch (error) {
          console.error(error);
          msgErro('Erro ao buscar caixas vinculados ao usuário.');
          return;
        }

      }

      await VinculaCaixaComUsuario();

      await VerificaCaixa();


      $('#btn-impostor').on('click', async function() {
        function abrePesquisaCaixa() {
          $('#btn-caixa').trigger('click');
        }
        await senhaSupervisor(
          `Usuário com caixa vinculado.`,
          abrePesquisaCaixa);
      });

      async function VerificaCaixa() {
        try {
          if (sessionStorage.getItem('g_caixa_logado') == '' || (sessionStorage.getItem('g_caixa_logado') == null) || (sessionStorage.getItem('g_caixa_logado') == 'undefined') || (sessionStorage.getItem('g_caixa_logado') == undefined)) {
            let response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?',
              'JSON={ "tabela":"CAIXA_LOJA", "camposSelect":[ "CODIGO", "descricao"]}', null);

            if (!response) {
              return;
            }

            let jsonStr = await response.json();

            if (jsonStr.RESULT[0].length > 1) {
              $('#btn-caixa').trigger('click');
            } else {
              $('#txtCaixa').val(`[${jsonStr.RESULT[0][0].CODIGO}] - ${jsonStr.RESULT[0][0].DESCRICAO}`);
            }
          } else {
            $("#txtCaixa").val(sessionStorage.getItem('g_caixa_logado'));
          }
        } catch (error) {
          msgErro('Erro ao buscar caixa!');
          $('#btn-caixa').trigger('click');
          console.error(error);
        }
      }

      async function VerificaUnicoRegistro() {
        const _url = '/sisplan/funcoes/v1/pesquisa?';
        const _paramsCaixa =
          `JSON={ "tabela":"CAIXA_LOJA", "camposSelect":["CODIGO", "DESCRICAO"], "where": null}`;
        try {
          const response = await requisicao('GET', _url, _paramsCaixa, null);
          if (!response) {
            msgErro('Erro ao buscar caixas disponíveis.');
            return;
          }

          if (response.status == 200) {
            var jsonStr = await response.json();
            if (jsonStr['RESULT'][0].length == 1) {
              const sCaixa = '[' + jsonStr['RESULT'][0][0].CODIGO + '] - ' + jsonStr['RESULT'][0][0].DESCRICAO;
              sessionStorage.setItem('g_caixa_logado', sCaixa);
            } else {
              sessionStorage.setItem('g_caixa_logado', '');
            }
          } else {
            msgErro('Erro ao buscar caixas disponíveis.');
            return;
          }
        } catch (error) {
          console.error(error);
          msgErro('Erro ao buscar caixas disponíveis.');
          return;
        }
      }

      try {
        $.LoadingOverlay("show");
        var response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?',
          'JSON={"tabela":"MOEDA", "camposSelect":[ "CODMOE", "DESCRICAO"], "orderBy": ["CODMOE"]}', null);

        if (!response) {
          $.LoadingOverlay("hide");
          return;
        }

        var jsonStr = await response.json();
        if (response.status != 200) {
          $.LoadingOverlay("hide");
          msgErro(jsonStr['RESULT'][0].mensagem);
          return;
        }

        for (const moeda of jsonStr['RESULT'][0]) {
          var opcao = new Option(`${moeda.CODMOE+' - '+moeda.DESCRICAO}`, `${moeda.CODMOE}`);
          /// jquerify the DOM object 'o' so we can use the html method
          $(opcao).html(`${moeda.CODMOE+' - '+moeda.DESCRICAO}`);
          $("#rgMoeda").append(opcao);
        }
        $.LoadingOverlay("hide");
      } catch (error) {
        $.LoadingOverlay("hide");
        console.log(error);
        msgErro('Não foi possível buscar as empresas cadastradas.');
      }


      async function ValidaStatusCaixa() {
        if (await CaixaFechado() == true) {
          $('#btnAbrir').removeClass('d-none');
          $('#btnGravar').addClass('d-none');
          $('#btnSangria').addClass('d-none');
          $('#btnSuprimento').addClass('d-none');
          $('#btnIncluir').addClass('d-none');
          $('.txtDINHEIRO').prop('disabled', true);
          $('.btnOpcao').prop('disabled', true);
          $('.escondeCampos').addClass('d-none');
        } else {
          $('#tabelaVendas').DataTable().rows()[0].length > 0 ? $('#btnGravar').removeClass('d-none') : $(
            '#btnGravar').addClass('d-none');
          $('#btnAbrir').addClass('d-none');
          $('#btnSangria').removeClass('d-none');
          $('#btnSuprimento').removeClass('d-none');
          $('#btnIncluir').removeClass('d-none');
          $('.txtDINHEIRO').prop('disabled', false);
          $('.btnOpcao').prop('disabled', false);
          $('.escondeCampos').removeClass('d-none');
        }

      }

      async function CaixaFechado() {
        try {
          $.LoadingOverlay('show');
          try {
            var caixa = pegaChave('#txtCaixa');
            var data = $('#txtDataDe').val();

            let response = await requisicao('GET', '/Sisplan/vendas/V1/VerificaStatusCaixa?',
              `CAIXA=${caixa}&DATA=${data}`, null);

            if (!response) {
              return false;
            }

            var jsonStr = await response.json();
            if (response.status != 200) {
              msgErro(jsonStr.mensagem);
              return false;
            }

            if (jsonStr == "true") {
              return true;
            }

          } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgErro('Erro ao verificar se o caixa está fechado ou aberto!');
          }
        } finally {
          $.LoadingOverlay('hide');
        }
      }

      function retornaBotaoOpcoes(tipo) {

        if (tipo != 'V') {
          return '<div style="text-align: start;"> ' +
            '   <div class="dropdown"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnOpcao" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      Opções' +
            '    </button> ' +
            '    <div class="dropdown-menu" style="min-width: 2rem;"> ' +
            '    <a class="dropdown-item estornarLancamentoManual" href="#" data-toggle="modal" data-target=".bd-visualizar-modal-lg">Estornar</a>' +
            '    <a class="dropdown-item reciboLancamentoManual" href="#" data-toggle="modal" data-target=".bd-visualizar-modal-lg">Emitir Recibo</a>' +
            '    </div>' +
            '  </div>' +
            '</div>';
        } else {
          return '<div style="text-align: start;"> ' +
            '   <div class="dropdown"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnOpcao" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" disabled> ' +
            '      Opções' +
            '    </button> ' +
            '  </div>' +
            '</div>';
        }
      };

      $('#modal-filtros').on('hidden.bs.modal', function(e) {
        $('#btnConsultar').trigger('click');
      })

      async function criaDataTable(data, data2, data3) {
        let dataSetCols = [];
        let datasetCols2 = [];
        let datasetCols3 = [];

        dataSetCols.push({
          "data": "CODIGO"
        });
        dataSetCols.push({
          "data": "DESCRICAO"
        });
        dataSetCols.push({
          "data": "CONDICAO"
        });
        dataSetCols.push({
          "data": "SALDO_ANTERIOR"
        });
        dataSetCols.push({
          "data": "ENTRADAS"
        });
        dataSetCols.push({
          "data": "SAIDAS"
        });
        dataSetCols.push({
          "data": "SALDO_ATUAL"
        });
        dataSetCols.push({
          "data": "TROCO"
        });
        dataSetCols.push({
          "data": "A_RETIRAR"
        });
        dataSetCols.push({
          "data": "SALDO_FINAL"
        });

        dataSetCols[7].render = function(data, type, row) {
          if ((row['DESCRICAO'].toUpperCase().split(' ')[0] == 'DINHEIRO')) {
            return `<input type="text" value='${row["TROCO"]}' id="txtMoeda-${row['CODIGO']}" placeholder="Troco" class="input-default focus form-control validate txt${row['DESCRICAO'].toUpperCase().split(' ')[0]}" style="min-width:100px; height: 30px;" min="0">`
          } else {
            return `<input type="text" value='${row["TROCO"]}' id="txtMoeda-${row['CODIGO']}" placeholder="Troco" class="input-default focus form-control validate troco_off" style="min-width:100px; height: 30px;" readonly>`
          }
        }

        datasetCols2.push({
          "data": "CODMOE"
        });
        datasetCols2.push({
          "data": "DESCMOE"
        });
        datasetCols2.push({
          "data": "VALOR"
        });
        datasetCols2.push({
          "data": "JUROS"
        });
        datasetCols2.push({
          "data": "VALOR_ORIG"
        });
        datasetCols2.push({
          "data": "DT_VENCTO"
        });
        datasetCols2.push({
          "data": "DESCTIPO"
        });
        datasetCols2.push({
          "data": "DUPLICATA"
        });
        datasetCols2.push({
          "data": "DESCRICAO"
        });
        datasetCols2.push({
          "data": "ORDEM"
        });
        datasetCols2.push({
          "data": "OPCOES"
        });
        datasetCols2[10].render = function(data, type, row) {
          let tipo = row['TIPO'];
          return retornaBotaoOpcoes(tipo);
        };

        datasetCols3.push({
          "data": "VENDA",
          "title": "Venda"
        });
        datasetCols3.push({
          "data": "MOEDA",
          "title": "Moeda"
        });
        datasetCols3.push({
          "data": "DESC_MOEDA",
          "title": "Desc Moeda"
        });
        datasetCols3.push({
          "data": "CONDICAO",
          "title": "Condição"
        });
        datasetCols3.push({
          "data": "CODCLI",
          "title": "Codcli"
        });
        datasetCols3.push({
          "data": "NOME_CLI",
          "title": "Nome Cli"
        });
        datasetCols3.push({
          "data": "CODREP",
          "title": "Codrep"
        });
        datasetCols3.push({
          "data": "NOME_REP",
          "title": "Nome Rep"
        });
        datasetCols3.push({
          "data": "QUANTIDADE",
          "title": "Quantidade"
        });
        datasetCols3.push({
          "data": "VALOR_VENDA",
          "title": "Valor Bruto"
        });
        datasetCols3.push({
          "data": "VALOR",
          "title": "Valor Venda"
        });
        datasetCols3.push({
          "data": "DESCONTO",
          "title": "Desconto"
        });
        datasetCols3.push({
          "data": "HORA_VENDA",
          "title": "Data Venda"
        });

        let table3 = $('#tabelaVendasGrid').DataTable({
          searching: false,
          ordering: true,
          paging: false,
          info: true,
          destroy: true,
          colReorder: true,
          "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
              "sNext": "Próximo",
              "sPrevious": "Anterior",
              "sFirst": "Primeiro",
              "sLast": "Último"
            },
            "oAria": {
              "sSortAscending": ": Ordenar colunas de forma ascendente",
              "sSortDescending": ": Ordenar colunas de forma descendente"
            }
          },
          "autoWidth": true,
          "data": data3,
          "columns": datasetCols3,
          "columnDefs": [{
            "render": function(data) {
              return parseFloat(data ?? 0).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              })
            },
            "targets": [9, 10, 11],
          },
          {
            "type": 'date-br',
            "render": function (data) {
              if (data != undefined) {
                x = data.slice(0, 10).split('-');
                y = data.slice(11, 19);
                return `${x[2]}/${x[1]}/${x[0]} ${y}`;
              } else {
                return ''
              }
            },
            "targets": [12]
          }]
        });

        $('#tabVendas').trigger('click');

        const colunasNumericas = utilizaProcessoCaixaCego ? [3, 4, 5, 6, 8, 9, 10, 11] : [3, 4, 5, 6, 8, 9]

        let table = $('#tabelaVendas').DataTable({
          ordering: true,
          searching: false,
          paging: false,
          info: true,
          destroy: true,
          colReorder: true,
          "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
              "sNext": "Próximo",
              "sPrevious": "Anterior",
              "sFirst": "Primeiro",
              "sLast": "Último"
            },
            "oAria": {
              "sSortAscending": ": Ordenar colunas de forma ascendente",
              "sSortDescending": ": Ordenar colunas de forma descendente"
            }
          },
          "columnDefs": [{
            "render": function(data) {
              return parseFloat(data ?? 0).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              })
            },
            "targets": colunasNumericas,
          }],
          "autoWidth": true,
          "data": data,
          "columns": dataSetCols,
        });

        $('#tabelaVendas tbody').on('change', 'tr', function(e) {
          var rowArray = table.row(this).data();

          if (rowArray) {
            if ($(`#txtMoeda-${rowArray['CODIGO']}`).val() < 0) {
              msgAlerta('Valor informado negativo');
              $(`#txtMoeda-${rowArray['CODIGO']}`).val(0);
            }

            if ((parseFloat($(`#txtMoeda-${rowArray['CODIGO']}`).val()) > rowArray['SALDO_ATUAL']) && (
                rowArray['SALDO_ATUAL'] > 0)) {
              msgAlerta('Valor informado superior ao saldo atual');
              $(`#txtMoeda-${rowArray['CODIGO']}`).val(0);
            }

            rowArray['TROCO'] = Number($(`#txtMoeda-${rowArray['CODIGO']}`).val());
            rowArray['A_RETIRAR'] = rowArray['SALDO_ATUAL'] - rowArray['TROCO'];
            rowArray['A_RETIRAR'] = Number(rowArray['A_RETIRAR'].toFixed(2));

            rowArray['SALDO_FINAL'] = Number(rowArray['SALDO_ATUAL'] - rowArray['A_RETIRAR']);
            rowArray['SALDO_FINAL'] = Number(rowArray['SALDO_FINAL'].toFixed(2));

            table.row(this).invalidate();
            $(function() {
              $('.txtDINHEIRO').maskMoney({
                decimal: '.',
                thousands: '',
                precision: 2
              });
            })
          }
        });

        $(function() {
          $('.txtDINHEIRO').maskMoney({
            decimal: '.',
            thousands: '',
            precision: 2
          });
        })

        let table2 = $('#tabelaManual').DataTable({
          ordering: true,
          searching: false,
          paging: false,
          info: true,
          destroy: true,
          colReorder: true,
          "language": {
            "sEmptyTable": "Nenhum registro encontrado",
            "sInfo": "_TOTAL_ registros",
            "sInfoEmpty": " 0 registros",
            "sInfoFiltered": "(Filtrados de _MAX_ registros)",
            "sInfoPostFix": "",
            "sInfoThousands": ".",
            "sLengthMenu": "_MENU_ resultados",
            "sLoadingRecords": "Carregando...",
            "sProcessing": "Processando...",
            "sZeroRecords": "Nenhum registro encontrado",
            "sSearch": "Pesquisar",
            "oPaginate": {
              "sNext": "Próximo",
              "sPrevious": "Anterior",
              "sFirst": "Primeiro",
              "sLast": "Último"
            },
            "oAria": {
              "sSortAscending": ": Ordenar colunas de forma ascendente",
              "sSortDescending": ": Ordenar colunas de forma descendente"
            }
          },
          "autoWidth": true,
          "data": data2,
          "columns": datasetCols2,
          "columnDefs": [{
              "type": 'date-br',
              "render": function(data) {
                if (data != undefined) {
                  x = data.slice(0, 10).split('-');
                  return `${x[2]}/${x[1]}/${x[0]}`;
                } else {
                  return ''
                }
              },
              "targets": 5,
            },
            {
              "render": function(data) {
                return parseFloat(data ?? 0).toLocaleString("pt-BR", {
                  maximumFractionDigits: 2,
                  minimumFractionDigits: 2
                })
              },
              "targets": [2, 3, 4],
            }
          ]
        });

        const colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));

        if ($('#botoesTabelaManual').find('#buttonColVisManual').length <= 0) {
          $('#botoesTabelaManual').prepend('<button class="buttonColVis" id="buttonColVisManual"><i class="fas fa-cogs"></i></button>');
          $('#botoesTabelaManual').prepend('<button class="buttonExcel" id="buttonExcelManual"><i class="fas fa-file-excel"></i></button>');

          $('#buttonColVisManual').on('click', async function() {
            $.LoadingOverlay('show');
            abaAtiva = '2';
            $('#modal-ColunasVisiveis').modal('show');
            $.LoadingOverlay('hide');
          })

          $('#buttonExcelManual').on('click', async function() {
            var codusuario = getCookie('cod_usuario');
            var caixa = $('#txtCaixa').val().substring(1, $('#txtCaixa').val().indexOf('] - '));
            const filtros = `caixa=${caixa}&CODUSUARIO=${codusuario}&DATA=${$('#txtDataDe').val()}`;
            const url = '/sisplan/vendas/v1/fechamentocaixa?';
            const formataCampos = montaComandosCamposManual();
            await exportaCSV(url, filtros, false, null, 'Fechamento de Caixa - Manual', '#tabelaManual', formataCampos, 1);
          })

          $('#buttonColVisManual').prop('title', 'Configurar colunas')
          $('#buttonExcelManual').prop('title', 'Exportar CSV')
        }

        if ($('#botoesTabelaVendas').find('#buttonColVisVendas').length <= 0) {
          $('#botoesTabelaVendas').prepend('<button class="buttonColVis" id="buttonColVisVendas"><i class="fas fa-cogs"></i></button>');
          $('#botoesTabelaVendas').prepend('<button class="buttonExcel" id="buttonExcelVendas"><i class="fas fa-file-excel"></i></button>');

          $('#buttonColVisVendas').on('click', async function() {
            $.LoadingOverlay('show');
            abaAtiva = '3';
            $('#modal-ColunasVisiveis').modal('show');
            $.LoadingOverlay('hide');
          })

          $('#buttonExcelVendas').on('click', async function() {
            var codusuario = getCookie('cod_usuario');
            var caixa = $('#txtCaixa').val().substring(1, $('#txtCaixa').val().indexOf('] - '));
            const filtros = `caixa=${caixa}&CODUSUARIO=${codusuario}&DATA=${$('#txtDataDe').val()}`;
            const url = '/sisplan/vendas/v1/fechamentocaixa?';
            const formataCampos = montaComandosCamposVendas();
            await exportaCSV(url, filtros, false, null, 'Fechamento de Caixa - Vendas', '#tabelaVendasGrid', formataCampos, 2);
          })

          $('#buttonColVisVendas').prop('title', 'Configurar colunas')
          $('#buttonExcelVendas').prop('title', 'Exportar CSV')

        }

        if ($('#botoesTabelaCaixa').find('#buttonColVisCaixa').length <= 0) {
          $('#botoesTabelaCaixa').prepend('<button class="buttonColVis" id="buttonColVisCaixa"><i class="fas fa-cogs"></i></button>');
          $('#botoesTabelaCaixa').prepend('<button class="buttonExcel" id="buttonExcelCaixa"><i class="fas fa-file-excel"></i></button>');

          $('#buttonColVisCaixa').on('click', async function() {
            $.LoadingOverlay('show');
            abaAtiva = '1';
            $('#modal-ColunasVisiveis').modal('show');
            $.LoadingOverlay('hide');
          })

          $('#buttonExcelCaixa').on('click', async function() {
            var codusuario = getCookie('cod_usuario');
            var caixa = $('#txtCaixa').val().substring(1, $('#txtCaixa').val().indexOf('] - '));
            const filtros = `caixa=${caixa}&CODUSUARIO=${codusuario}&DATA=${$('#txtDataDe').val()}`;
            const url = '/sisplan/vendas/v1/fechamentocaixa?';
            const formataCampos = montaComandosCamposCaixa();
            await exportaCSV(url, filtros, false, null, 'Fechamento de Caixa', '#tabelaVendas', formataCampos, 0);
          })

          $('#buttonColVisCaixa').prop('title', 'Configurar colunas')
          $('#buttonExcelCaixa').prop('title', 'Exportar CSV')

        }

        $('#tabelaManual').DataTable().columns().every(
          function() {
            if ((colunasInvisiveis.fechamentoCaixaManual).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          }
        )

        $('#tabelaVendasGrid').DataTable().columns().every(
          function() {
            if ((colunasInvisiveis.fechamentoCaixaVendas).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          }
        )

        $('#tabelaVendas').DataTable().columns().every(
          function() {
            if ((colunasInvisiveis.fechamentoCaixa).indexOf(this.dataSrc()) != -1) {
              this.visible(false);
            }
          }
        )

        $('.reciboLancamentoManual').unbind('click');
        $('.reciboLancamentoManual').on('click', async function() {
          try {
            $.LoadingOverlay('show');
            try {
              const table = $('#tabelaManual').DataTable();
              const data = table.row($(this).parents('tr')).data();
              const caixa = pegaChave('#txtCaixa');
              const dataDe = $('#txtDataDe').val();
              const lancamento = data.LANCAMENTO;
              const ordem = data.ORDEM;
              const tipo = data.TIPO;

              const url = `/sisplan/impressao/v1/recibocaixa?NRCAIXA=${caixa}&TIPO=${tipo}&ORDEM=${ordem}&DATA=${dataDe}`;
              const bImprimeAutomatico = await verificaImprimirAutomatico('ReciboCaixa');
              const arquivo = await GeraRelatorio(`${url}&`, 'GET', 15000, false, 'ReciboCaixa');
              if (arquivo != undefined) {
                if (!bImprimeAutomatico) {
                  window.open(`<?php echo BASE_URI; ?>/relatorios_api/pdf/${arquivo}`, '_blank');
                }
                await limparRelatorios();
              }
            } catch (error) {
              console.error(error);
              msgErro('Não foi possível emetir recibo', error)
            }
          } finally {
            $.LoadingOverlay('hide');
          }
        });


        $('.estornarLancamentoManual').unbind('click');
        $('.estornarLancamentoManual').on('click', async function() {
          try {
            $.LoadingOverlay('show');
            try {
              let table = $('#tabelaManual').DataTable();
              let data = table.row($(this).parents('tr')).data();
              var caixa = pegaChave('#txtCaixa');
              let dataDe = $('#txtDataDe').val();
              let lancamento = data.LANCAMENTO;
              let ordem = data.ORDEM;
              let tipo = data.TIPO;
              let response;
              let jsonStr;

              response = await requisicao('DELETE', '/Sisplan/vendas/V1/Estornar?',
                `CAIXA=${caixa}&DATA=${dataDe}&ORDEM=${ordem}&LANCAMENTO=${lancamento}&TIPO=${tipo}`, null
              );

              if (!response) {
                return;
              }

              if (response.status != 200) {
                jsonStr = await response.json();
                msgErro(jsonStr.mensagem);
                return false;
              }

              toastr.success(
                'Lançamento manual estornado com sucesso!',
                'Confirmação', {
                  toastClass: 'alert',
                  iconClasses: {
                    error: 'alert-error',
                    info: 'alert-info',
                    success: 'alert-success',
                    warning: 'alert-warning'
                  },
                  positionClass: "toast-top-center",
                  progressBar: true,
                  timeOut: 3000,
                  fadeOut: 1000,
                  onHidden: function() {
                    $('#btnConsultar').trigger('click');
                  }
                }
              ).css({
                "margin-top": "20%",
                "width": "500px",
                "max-width": "500px"
              });
            } catch (error) {
              console.error(error);
              msgErro('Não foi possível estornar venda', error)
            }
          } finally {
            $.LoadingOverlay('hide');
          }
        });
        atualizaTotais();
        setTimeout(() => {
          $('#tabLancManuais').trigger('click');
        }, 200);
      }

      function montaComandosCamposManual() {
        let retorno = `dados.map(e => {
          delete e['DESCONTO'];
          delete e['LANCAMENTO'];
          delete e['NRCAIXA'];
          delete e['TIPO'];
          delete e['TIPO_ORD'];
        });
        `;

        retorno += `dados = dados.map((key) => {
          let v1 = key.VALOR 
          if (typeof v1 == 'string') {
          v1 = parseFloat(v1.replace(".", "").replace(",", ".")).toFixed(2)
          } else {
          if (v1 == null) {
            v1 = 0;
          }
          v1 = parseFloat(v1).toFixed(2) }
          let v2 = key.JUROS
          if (typeof v2 == 'string') {
          v2 = parseFloat(v2.replace(".", "").replace(",", ".")).toFixed(2)
          } else {
          if (v2 == null) {
            v2 = 0;
          }
          v2 = parseFloat(v2).toFixed(2) }
          let v3 = key.VALOR_ORIG
          if (typeof v3 == 'string') {
          v3 = parseFloat(v3.replace(".", "").replace(",", ".")).toFixed(2)
          } else {
          if (v3 == null) {
            v3 = 0;
          }
          v3 = parseFloat(v3).toFixed(2) }
          
          return { ...key, VALOR: v1, JUROS: v2, VALOR_ORIG: v3 }
          }) \n`
        return retorno;
      }

      function montaComandosCamposCaixa() {
        let retorno = `dados.map(e => {
          delete e['DIFERENCA'];
          delete e['CONFERIDO'];
        })
        `;

        retorno += `dados = dados.map((key) => {
          let v1 = key.ENTRADAS 
          if (typeof v1 == 'string') {
          v1 = parseFloat(v1.replace(".", "").replace(",", ".")).toFixed(2)
          } else {
          v1 = parseFloat(v1).toFixed(2) }
          let v2 = key.SAIDAS
          if (typeof v2 == 'string') {
          v2 = parseFloat(v2.replace(".", "").replace(",", ".")).toFixed(2)
          } else {
          v2 = parseFloat(v2).toFixed(2) }
          let v3 = key.SALDO_ANTERIOR
          if (typeof v3 == 'string') {
          v3 = parseFloat(v3.replace(".", "").replace(",", ".")).toFixed(2)
          } else {
          v3 = parseFloat(v3).toFixed(2) }
          let v4 = key.SALDO_ATUAL
          if (typeof v4 == 'string') {
          v4 = parseFloat(v4.replace(".", "").replace(",", ".")).toFixed(2)
          } else {
          v4 = parseFloat(v4).toFixed(2) }
          let v5 = key.A_RETIRAR
          if (typeof v5 == 'string') {
          v5 = parseFloat(v5.replace(".", "").replace(",", ".")).toFixed(2)
          } else {
          v5 = parseFloat(v5).toFixed(2) }
          let v6 = key.SALDO_FINAL
          if (typeof v6 == 'string') {
          v6 = parseFloat(v6.replace(".", "").replace(",", ".")).toFixed(2)
          } else {
          v6 = parseFloat(v6).toFixed(2) }
          let v7 = key.TROCO
          if (typeof v7 == 'string') {
          v7 = parseFloat(v7.replace(".", "").replace(",", ".")).toFixed(2)
          } else {
          v7 = parseFloat(v7).toFixed(2) }
          return { ...key, ENTRADAS: v1, SAIDAS: v2, SALDO_ANTERIOR: v3, SALDO_ATUAL: v4, A_RETIRAR: v5, SALDO_FINAL: v6, TROCO: v7 }
          }) \n`
        return retorno;
      }

      function montaComandosCamposVendas() {
        let retorno = `dados = dados.map((key) => {
          let v1 = key.VALOR 
          if (typeof v1 == 'string') {
          v1 = parseFloat(v1.replace(".", "").replace(",", ".")).toFixed(2)
          } else {
          v1 = parseFloat(v1).toFixed(2) }
          let v2 = key.VALOR_VENDA
          if (typeof v2 == 'string') {
          v2 = parseFloat(v2.replace(".", "").replace(",", ".")).toFixed(2)
          } else {
          v2 = parseFloat(v2).toFixed(2) }
          let v3 = key.DESCONTO
          if (typeof v3 == 'string') {
          v3 = parseFloat(v3.replace(".", "").replace(",", ".")).toFixed(2)
          } else {
          v3 = parseFloat(v3).toFixed(2) }
          let v4 = key.HORA_VENDA
          let x = v4.slice(0, 10).split('-');
          let y = v4.slice(11, 19);` +
          'v4 = `${x[2]}/${x[1]}/${x[0]} ${y}`;' +
          'return { ...key, VALOR: v1, VALOR_VENDA: v2, DESCONTO: v3, HORA_VENDA: v4 }' +
        '});'
        return retorno;
      }

      $('#modal-ColunasVisiveis').on('show.bs.modal', function() {
        const cols = [];

        let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        if (abaAtiva == '1') {

          $('#tabelaVendas').DataTable().columns().every(function() {
            cols.push({
              'title': $(this.header()).text().trim(),
              'data': this.dataSrc()
            })
          });

          adicionaColunas(cols, colunasInvisiveis.fechamentoCaixa ?? [])
        } else if (abaAtiva == '2') {
          $('#tabelaManual').DataTable().columns().every(function() {
            cols.push({
              'title': $(this.header()).text().trim(),
              'data': this.dataSrc()
            })
          });

          adicionaColunas(cols, colunasInvisiveis.fechamentoCaixaManual ?? [])
        } else {
          $('#tabelaVendasGrid').DataTable().columns().every(function() {
            cols.push({
              'title': $(this.header()).text().trim(),
              'data': this.dataSrc()
            })
          });

          adicionaColunas(cols, colunasInvisiveis.fechamentoCaixaVendas ?? [])
        }
      })

      $('#btnSangria').on('click', async function() {
        $('#txtSangria').val('0.0');
        const moeda = await buscaValor('MOEDA', ['DESCRICAO', 'CODMOE'], 'DESCRICAO', 'DINHEIRO');
        insereValor('#txtMoedaSangria', moeda.CODMOE, moeda.DESCRICAO);
        // $('#txtMoedaSangria').val('[0] - DINHEIRO');
      });
      $('#btnSuprimento').on('click', async function() {
        $('#txtSuprimento').val('0.0');
        const moeda = await buscaValor('MOEDA', ['DESCRICAO', 'CODMOE'], 'DESCRICAO', 'DINHEIRO');
        insereValor('#txtMoedaSuprimento', moeda.CODMOE, moeda.DESCRICAO);
        // $('#txtMoedaSuprimento').val('[0] - DINHEIRO');
      });

      async function SangriaCupom(valor) {
        const _url = '/cupom/sangria?';
        try {
          var response = await requisicao_ecf('POST', _url, `VALOR=${(valor)}`, null);
          if (!response) {
            return false;
          }

          var jsonStr = await response.json();
          if (response.status != 200) {
            return false;
          } else {
            if (jsonStr.status == 0) {
              return true;
            } else {
              return false;
            }
          }
          await ValidaStatusCaixa();
        } catch (error) {
          console.error(error);
          return false;
        }
      }

      async function SuprimentoCupom(valor) {
        const _url = '/cupom/suprimento?';
        try {
          var response = await requisicao_ecf('POST', _url, `VALOR=${(valor)}`, null);
          if (!response) {
            return false;
          }

          var jsonStr = await response.json();
          if (response.status != 200) {
            return false
          } else {
            if (jsonStr.status == 0) {
              return true;
            } else {
              return false;
            }
          }
          await ValidaStatusCaixa();
        } catch (error) {
          console.error(error);
          return false;
        }
      }

      async function InsereSuprimentoCaixa(valor, data, caixa) {
        var Suprimento = new Object();

        Suprimento.VALOR = parseFloat(valor);
        Suprimento.DESCRICAO = 'SUPRIMENTO';
        Suprimento.TIPO = 'E';
        Suprimento.MOEDA = pegaChave($('#txtMoedaSuprimento'));
        Suprimento.DATA = data;
        Suprimento.NRCAIXA = caixa;
        try {
          let response = await requisicao('POST', '/sisplan/vendas/v1/Suprimento?',
            `JSON=${encodeURIComponent(JSON.stringify(Suprimento))}`);

          if (!response) {
            return
          }
          let jsonStr = await response.json()

          if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem);
            return;
          }

          toastr.success(
            'Suprimento Cadastrada com sucesso!',
            'Confirmação', {
              toastClass: 'alert',
              iconClasses: {
                error: 'alert-error',
                info: 'alert-info',
                success: 'alert-success',
                warning: 'alert-warning'
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              onHidden: function() {
                $("#btnConsultar").trigger("click");
                $('.bd-suprimento-modal-sm').modal('hide');
              }
            }
          ).css({
            "margin-top": "20%",
            "width": "500px",
            "max-width": "500px"
          });;

        } catch (error) {
          console.error(error);
          msgErro('Erro ao inserir o Suprimento.');
          return;
        }
      }

      async function InsereSangriaCaixa(valor, data, caixa) {
        var Sangria = new Object();

        Sangria.VALOR = parseFloat(valor);
        Sangria.DESCRICAO = 'SANGRIA';
        Sangria.TIPO = 'S';
        Sangria.MOEDA = pegaChave($('#txtMoedaSangria'));
        Sangria.DATA = data;
        Sangria.NRCAIXA = caixa;
        try {
          let response = await requisicao('POST', '/sisplan/vendas/v1/Sangria?',
            `JSON=${encodeURIComponent(JSON.stringify(Sangria))}`);
          if (!response) {
            return
          }
          let jsonStr = await response.json()

          if (response.status != 200) {
            msgErro(jsonStr['RESULT'][0].mensagem);
            return;
          }
          toastr.success(
            'Sangria Cadastrada com sucesso!',
            'Confirmação', {
              toastClass: 'alert',
              iconClasses: {
                error: 'alert-error',
                info: 'alert-info',
                success: 'alert-success',
                warning: 'alert-warning'
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              onHidden: function() {
                $("#btnConsultar").trigger("click");
                $('.bd-sangria-modal-sm').modal('hide');
              }
            }
          ).css({
            "margin-top": "20%",
            "width": "500px",
            "max-width": "500px"
          });;
        } catch (error) {
          console.error(error);
          msgErro('Erro ao inserir sangria.');
          return;
        }
      }

      function validaValorSaida(moeda, valor) {
        const dados = $('#tabelaVendas').DataTable().rows().data().toArray();
        const indice = dados.findIndex((item) => item.CODIGO == moeda);
        if (valor > dados[indice].SALDO_ATUAL) {
          return false;
        }
        return true;
      }

      $('#btnConfirmaSangria').on('click', async function() {
        try {
          $.LoadingOverlay("show");
          try {
            var caixa = pegaChave('#txtCaixa');
            var valor = parseFloat($('#txtSangria').val().replace('.', '').replace(',', '.'));
            var data = $('#txtDataDe').val();
            const moeda = pegaChave($('#txtMoedaSangria'));

            if ($('#txtMoedaSangria').val() == '') {
              msgAlerta('Moeda não pode estar vazia!');
              return;
            }

            if (!validaValorSaida(moeda, valor)) {
              msgAlerta('Valor de sangria é maior que o saldo para essa moeda, impossível continuar.');
              return;
            }

            if ((bUsaECF != 0) && (valor > 0)) {
              if (await SangriaCupom(String(valor).replaceAll('.', ','))) {
                await InsereSangriaCaixa(valor, data, caixa);
              } else {
                msgErro('Não foi possível realizar Sangria na impressora fiscal.');
                return;
              }
            } else {
              if (valor > 0) {
                await InsereSangriaCaixa(valor, data, caixa);
              } else {
                msgAlerta('Valor da Sangria precisa ser maior que 0')
              }
            }
          } catch (error) {
            msgErro('Não foi possivel cadastrar a sangria');
          }
        } finally {
          $.LoadingOverlay('hide')
        }
      });

      //retirado replace pois ao confirmar a sangria, dizia que o valor tinha que ser acima de 0

      $('#btnConfirmaSuprimento').on('click', async function() {
        try {
          $.LoadingOverlay("show");
          try {
            var caixa = pegaChave('#txtCaixa');
            var valor = parseFloat($('#txtSuprimento').val().replace('.', '').replace(',', '.'));
            var data = $('#txtDataDe').val();

            if ($('#txtMoedaSuprimento').val() == '') {
              msgAlerta('Moeda não pode estar vazia!');
              return;
            }

            if ((bUsaECF != 0) && (valor > 0)) {
              if (await SuprimentoCupom(String(valor).replaceAll('.', ','))) {
                await InsereSuprimentoCaixa(valor, data, caixa);
              } else {
                msgErro('Não foi possível realizar Suprimento na impressora fiscal.');
                return;
              }
            } else {
              if (valor > 0) {
                await InsereSuprimentoCaixa(valor, data, caixa);
              } else {
                msgAlerta('Valor do Suprimento precisa ser maior que 0.');
              }
            }
          } catch (error) {
            msgErro('Não foi possivel cadastrar o Suprimento');
          }
        } finally {
          $.LoadingOverlay('hide');
        }
      });

      $('#btnConsultar').click(async function() {
        try {
          $.LoadingOverlay("show");
          var codusuario = getCookie('cod_usuario');
          var caixa = $('#txtCaixa').val().substring(1, $('#txtCaixa').val().indexOf('] - '));
          var response = await requisicao('GET', '/sisplan/vendas/v1/fechamentocaixa?',
            `caixa=${caixa}&CODUSUARIO=${getCookie('cod_usuario')}&DATA=${$('#txtDataDe').val()}`, null);
          $('#numeroCaixa').html(caixa);
          $('#dataCaixa').html($('#txtDataDe').val());
          // 
          if (!response) {
            $.LoadingOverlay("hide");
            return;
          }

          var jsonStr = await response.json();
          if (response.status != 200) {
            $.LoadingOverlay("hide");
            alert(jsonStr.mensagem);
            return;
          }

          var table = criaDataTable(jsonStr[0], jsonStr[1], jsonStr[2]);

          $('#tabelaVendas_wrapper').css("width", "100%");
          $('#modal-filtros').modal('hide');
          await ValidaStatusCaixa();
          $.LoadingOverlay("hide");
        } catch (error) {
          console.log(error);
          $.LoadingOverlay("hide");
        }
      });
      if (NaoTemCaixaVinculado()) {
        await VerificaUnicoRegistro();
      }
      if ($('#txtCaixa').val() != '') {
        $('#btnConsultar').trigger('click');
      }


      $("#btn-relatorio").on('click', async function() {
        try {
          $.LoadingOverlay("show");
          var caixa = pegaChave('#txtCaixa');
          if (caixa == '') {
            msgErro('Caixa não informado, necessário informar para impressão.');
            return;
          }
          var data = $('#txtDataDe').val();
          var url = `/sisplan/impressao/v1/caixa?NR_CAIXA=${caixa}&DATA=${data}`;
          const bImprimeAutomatico = await verificaImprimirAutomatico('Caixa');
          var arquivo = await GeraRelatorio(url + '&', 'GET', 300000, false, 'Caixa');
          if (arquivo != undefined) {
            if (!bImprimeAutomatico) {
              window.open('./relatorios_api/pdf/' + arquivo, '_blank');
            }
            await limparRelatorios();
          }
        } finally {
          $.LoadingOverlay("hide");
        }
      });



      $('#btnGravar').click(async function() {
        let caixa = $('#txtCaixa').val().substring(1, $('#txtCaixa').val().indexOf('] - '));
        if (caixa == "") {
          msgAlerta("Caixa não informado");
          return;
        }

        try {
          $.LoadingOverlay("show");

          let jsonVendas = JSON.stringify($('#tabelaVendas').DataTable().rows({
            search: 'applied'
          }).data().toArray());

          let response = await requisicao('POST', '/sisplan/vendas/v1/fechamentocaixa?',
            `caixa=${caixa}&CODUSUARIO=${getCookie('cod_usuario')}&DATA=${$('#txtDataDe').val()}`, `JSON=${jsonVendas}`);
          if (!response) {
            $.LoadingOverlay("hide");
            return;
          }

          if (response.status != 200) {
            let jsonStr = await response.json()
            $.LoadingOverlay("hide");
            msgErro(jsonStr.mensagem);
            return;
          } else {
            toastr.success(
              'Fechamento efetuado com sucesso!',
              'Confirmação', {
                toastClass: 'alert',
                iconClasses: {
                  error: 'alert-error',
                  info: 'alert-info',
                  success: 'alert-success',
                  warning: 'alert-warning'
                },
                positionClass: "toast-top-center",
                progressBar: true,
                timeOut: 3000,
                fadeOut: 1000,
                onHidden: function() {
                  $("#btnConsultar").trigger("click");
                }
              }
            ).css({
              "margin-top": "20%",
              "width": "500px",
              "max-width": "500px"
            });;
          }

          $.LoadingOverlay("hide");
        } catch (error) {
          console.log(error);
          $.LoadingOverlay("hide");
        }
      });

      $('#btnAbrir').click(async function() {

        let caixa = $('#txtCaixa').val().substring(1, $('#txtCaixa').val().indexOf('] - '));
        if (caixa == "") {
          msgAlerta("Caixa não informado");
          return;
        }

        await senhaSupervisor('', reabreCaixa);

      });

      async function reabreCaixa() {
        try {
          $.LoadingOverlay("show");

          let caixa = $('#txtCaixa').val().substring(1, $('#txtCaixa').val().indexOf('] - '));
          let response = await requisicao('POST', '/sisplan/vendas/v1/fechamentocaixa?',
            `caixa=${caixa}&CODUSUARIO=${getCookie('cod_usuario')}&DATA=${$('#txtDataDe').val()}&REABRIR=True`, null);
          if (!response) {
            $.LoadingOverlay("hide");
            return;
          }

          if (response.status != 200) {
            let jsonStr = await response.json();
            $.LoadingOverlay("hide");
            msgErro(jsonStr.mensagem);
            return;
          }
          await ValidaStatusCaixa();

          $('#btnConsultar').trigger('click');
          $.LoadingOverlay("hide");
        } catch (error) {
          console.log(error)
          $.LoadingOverlay("hide");
        }
      }

      function atualizaTotais() {
        const val_anterior = $('#tabelaVendas').DataTable().column(3, {
          search: 'none'
        }).data().sum();
        const val_entradas = $('#tabelaVendas').DataTable().column(4, {
          search: 'none'
        }).data().sum();
        const val_saidas = $('#tabelaVendas').DataTable().column(5, {
          search: 'none'
        }).data().sum();

        const val_saldo = val_entradas + val_anterior - val_saidas;

        $("#txt_val_entradas").html(parseFloat(val_entradas).toLocaleString('pt-BR', {
          style: 'currency',
          currency: 'BRL'
        }));

        $("#txt_val_saidas").html(parseFloat(val_saidas).toLocaleString('pt-BR', {
          style: 'currency',
          currency: 'BRL'
        }));

        $("#txt_val_saldo").html(parseFloat(val_saldo).toLocaleString('pt-BR', {
          style: 'currency',
          currency: 'BRL'
        }));

        $("#txt_val_saldo_anterior").html(parseFloat(val_anterior).toLocaleString('pt-BR', {
          style: 'currency',
          currency: 'BRL'
        }));
      }

      $('#btnIncluir').click(async function() {
        let caixa = $('#txtCaixa').val().substring(1, $('#txtCaixa').val().indexOf('] - '));
        if (caixa == "") {
          msgAlerta("Caixa não informado");
          return;
        }

        try {
          $.LoadingOverlay("show");
          $('#txtValor').val();
          let obj = {
            moeda: Number($('#rgMoeda').val()),
            valor: parseFloat($('#txtValor').val().replace('.', '').replace(',', '.')),
            descricao: `${$('#txtObs').val()}`,
            tipo: `${$('#rgOperacao').val()}`,
            nrcaixa: caixa,
            data: $('#txtDataDe').val() + 'T00:00:00Z',
            dt_fechamento: $('#txtDataDe').val() + 'T00:00:00Z',
            duplicata: '',
            lancamento: 0,
            manual: 'S',
          }

          if ((obj.tipo == 'S') && (!validaValorSaida(obj.moeda, obj.valor))) {
            msgAlerta('Valor de saída é maior que o saldo para essa moeda, impossível continuar.');
            $.LoadingOverlay('hide');
            return;
          }

          let jsonVendas = encodeURIComponent(JSON.stringify(obj));

          let response = await requisicao('POST', '/sisplan/vendas/v1/fechamentocaixa?',
            `caixa=${caixa}&CODUSUARIO=${getCookie('cod_usuario')}&DATA=${$('#txtDataDe').val()}&MANUAL=True`, `JSON=${jsonVendas}`)

          if (!response) {
            $.LoadingOverlay("hide");
            return;
          }

          if (response.status != 200) {
            let jsonStr = await response.json();
            $.LoadingOverlay("hide");
            msgErro(jsonStr.mensagem);
            return;
          }

          $('#txtObs').val('');
          $('#txtValor').val('');
          $('#rgMoeda').val(obj.moeda);
          $('#rgOperacao').val('E');
          $("#btnConsultar").trigger("click");

          $.LoadingOverlay("hide");
        } catch (error) {
          console.log(error);
          $.LoadingOverlay("hide");
        }
      });

      $(function() {
        $('#txtValor').maskMoney({
          decimal: ',',
          thousands: '.',
          precision: 2,
          allowZero: true,
          defaultZero: true
        });
        $(function() {
          $('#txtSangria').maskMoney({
            decimal: ',',
            thousands: '.',
            precision: 2,
            allowZero: true,
            defaultZero: true
          });
        });
        $(function() {
          $('#txtSuprimento').maskMoney({
            decimal: ',',
            thousands: '.',
            precision: 2,
            allowZero: true,
            defaultZero: true,
            reversed: true
          });
        })
      })
    })
  </script>
</body>

</html>