<?php include_once('../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | GNRE</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../plugins/fontawesome-free/css/all.min.css?versao=3.237.17.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="../dist/css/adminlte.min.css?versao=3.237.17.1">
  <!-- Google Font: Source Sans Pro -->
  <!-- <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet"> -->
  <link rel="stylesheet" type="text/css" href="../dist/css/dataTables.bootstrap4.min.css?versao=3.237.17.1" />

  <link href='../dist/css/bootstrap.min.css?versao=3.237.17.1'>
  <link rel="stylesheet" href="../plugins/toastr/toastr.min.css?versao=3.237.17.1">
  <link rel="shortcut icon" href="../favicon.ico">
  <link rel="stylesheet" href="../dist/css/sisplan.css?versao=3.237.17.1">
  <link rel="stylesheet" href="../dist/css/custom.css?versao=3.237.17.1">
  <link rel="stylesheet" type="text/css" href="../plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.237.17.1">
  <link rel="stylesheet" type="text/css" href="../dist/css/driver.min.css?versao=3.237.17.1" />
  <!-- AutoComplete -->
  <link rel="stylesheet" href="../dist/css/jquery-ui.css?versao=3.237.17.1">

  <style>
    .input-group button,
    .input-group input {
      height: 40px;
    }

    .input-group button {
      min-width: 45px;
    }

    .btn.bg-danger {
      border: 1px solid white;
    }

    .info-box-text {
      font-size: 20px;
      font-weight: bold;
      color: grey;
    }

    #cardPrincipal {
      min-height: 400px;
      display: flex;
      justify-content: center;
      padding-bottom: 11px;
    }

    .botoesMenu {
      height: 100%;
      padding-left: auto;
      padding-right: auto;
      color: white !important;
      min-width: 150px;
      font-weight: bold;
      margin-left: -4px !important;
      font-size: 1rem !important;
      background-color: #343a40;
      cursor: pointer !important;
    }

    #btnConfig {
      margin-top: 10px;
      margin-left: 15px;
    }
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../menu.php');
    ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">GNRE</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i>
              </button>
            </div><!-- /.col -->
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="../index">Início</a></li>
                <li class="breadcrumb-item active">GNRE</li>
              </ol>
            </div><!-- /.col -->
          </div><!-- /.row -->

          <div class="card" id="cardPrincipal">
            <div class="row pb-2">
              <div class="col-sm-12 d-flex justify-content-between">
                <div>
                  <button id="btnConfig" class=" btn btn-danger text-white btn-sisp">
                    <span class="fas fa-cogs"></span> Config.
                  </button>
                </div>
                <div>
                  <p id="txtVencimentoCertificadoDigital" style="color: red; padding-top: 3.1%; "></p>
                </div>
                <div style="padding-top: .6%">
                  <span id="txtAmbienteInf" style="color: red"></span>
                </div>
              </div>
            </div>
            <div class="row ml-2 mt-3 mr-2" id="tourbotoes">
              <div class="col-sm-12 mt-12">
                <div class="row">
                  <div class="col-lg-6 col-12">
                    <label data-error="wrong" data-success="right" for="txtChaveNfe">Chave NF-e *</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtChaveNfe" name="txtChaveNfe" class="form-control" required placeholder="Chave NF-e" enabled readonly>
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-ChaveNfe" name="btn-ChaveNfe" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-limpar-ChaveNfe" name="btn-limpar-ChaveNfe" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-6 col-12">
                    <label data-error="wrong" data-success="right" for="txtNome">Nome</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtNome" name="txtNome" class="form-control" disabled>
                    </div>
                  </div>
                  <div class="col-lg-6 col-12">
                    <label data-error="wrong" data-success="right" for="txtEstado">Estado</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtEstado" name="txtEstado" class="form-control">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btn-Estado" name="btn-Estado" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btn-limpar-Estado" name="btn-limpar-Estado" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-12">
                    <label data-error="wrong" data-success="right" for="txtValorNF">Valor NF</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control maskDecimais" id="txtValorNF" name="txtValorNF" class="form-control" disabled>
                    </div>
                  </div>
                  <div class="col-lg-3 col-12">
                    <label data-error="wrong" data-success="right" for="txtIEDestinatario">IE Destinatário</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtIEDestinatario" name="txtIEDestinatario" class="form-control" disabled>
                    </div>
                  </div>
                  <div class="col-lg-3 col-12">
                    <label data-error="wrong" data-success="right" for="txtCNPJCPF">CNPJ/CPF Destinatário</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtCNPJCPF" name="txtCNPJCPF" class="form-control" disabled>
                    </div>
                  </div>
                  <div class="col-lg-3 col-12">
                    <label data-error="wrong" data-success="right" for="txtMunDest">Mun. Dest.</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtMunDest" name="txtMunDest" class="form-control" disabled>
                    </div>
                  </div>
                  <div class="col-lg-3 col-12">
                    <label data-error="wrong" data-success="right" for="txtMunEmit">Mun. Emit.</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtMunEmit" name="txtMunEmit" class="form-control" disabled>
                    </div>
                  </div>
                  <div class="col-lg-3 col-12">
                    <label data-error="wrong" data-success="right" for="txtDocumento">Documento</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtDocumento" name="txtDocumento" class="form-control" disabled>
                    </div>
                  </div>
                  <div class="col-lg-3  col-12 form-group">
                    <label data-error="wrong" data-success="right" for="dtEmissaoNF">Emissão NF</label>
                    <div class="input-group">
                      <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtEmissaoNF" name="dtEmissaoNF">
                    </div>
                  </div>
                  <div class="col-lg-3  col-12 form-group">
                    <label data-error="wrong" data-success="right" for="dtVencimento">Data Vencimento</label>
                    <div class="input-group">
                      <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtVencimento" name="dtVencimento">
                    </div>
                  </div>
                  <div class="col-lg-3  col-12 form-group">
                    <label data-error="wrong" data-success="right" for="dtPagamento">Data Pagamento</label>
                    <div class="input-group">
                      <input type="date" max="2500-12-31" class="input-default focus form-control" id="dtPagamento" name="dtPagamento">
                    </div>
                  </div>
                  <div class="col-lg-3 col-12">
                    <div class="input-group">
                      <input type="hidden" class="input-default focus form-control" id="txtFatura" name="txtFatura" class="form-control" disabled>
                      <input type="hidden" class="input-default focus form-control" id="txtSerie" name="txtSerie" class="form-control" disabled>
                    </div>
                  </div>
                  <div class="col-lg-3 col-12">
                    <label data-error="wrong" data-success="right" for="txtValorDifal">Valor Difal</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control maskDecimais" id="txtValorDifal" name="txtValorDifal" class="form-control" disabled>
                    </div>
                  </div>
                  <div class="col-lg-3 col-12">
                    <label data-error="wrong" data-success="right" for="txtCodReceitaDifal">Cód. Receita Difal</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtCodReceitaDifal" name="txtCodReceitaDifal" class="form-control">
                    </div>
                  </div>
                  <div class="col-lg-3 col-12">
                    <label data-error="wrong" data-success="right" for="txtDetalheDifal">Detalhe Difal</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtDetalheDifal" name="txtDetalheDifal" class="form-control">
                    </div>
                  </div>
                  <div class="col-lg-3 col-12">
                    <label data-error="wrong" data-success="right" for="txtProdutoDifal">Produto Difal</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtProdutoDifal" name="txtProdutoDifal" class="form-control">
                    </div>
                  </div>
                  <div class="col-lg-3 col-12">
                    <label data-error="wrong" data-success="right" for="txtValorPobreza">Valor Pobreza</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control maskDecimais" id="txtValorPobreza" name="txtValorPobreza" class="form-control" disabled>
                    </div>
                  </div>
                  <div class="col-lg-3 col-12">
                    <label data-error="wrong" data-success="right" for="txtCodReceitaPobreza">Cód. Receita Pobreza</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtCodReceitaPobreza" name="txtCodReceitaPobreza" class="form-control">
                    </div>
                  </div>
                  <div class="col-lg-3 col-12">
                    <label data-error="wrong" data-success="right" for="txtDetalhePobreza">Detalhe Pobreza</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtDetalhePobreza" name="txtDetalhePobreza" class="form-control">
                    </div>
                  </div>
                  <div class="col-lg-3 col-12">
                    <label data-error="wrong" data-success="right" for="txtProdutoPobreza">Produto Pobreza</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtProdutoPobreza" name="txtProdutoPobreza" class="form-control">
                    </div>
                  </div>
                  <div class="col-lg-3 col-12">
                    <label data-error="wrong" data-success="right" for="txtValorST">Valor ST</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control maskDecimais" id="txtValorST" name="txtValorST" class="form-control" disabled>
                    </div>
                  </div>
                  <div class="col-lg-3 col-12">
                    <label data-error="wrong" data-success="right" for="txtCodReceitaST">Cód. receita ST</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtCodReceitaST" name="txtCodReceitaST" class="form-control">
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="col-12 text-center">
            <div class="btn-group flex-wrap btn-group-justified btn-group-lg" role="group" aria-label="Basic example">
              <button id="btnGerar" class="btn btn-secondary text-white btn-sisp botoesMenu">
                <span class="fas fa-cogs pr-1"></span> Gerar
              </button>
              <button id="btnImprimir" class="btn btn-secondary text-white btn-sisp botoesMenu">
                <span class="fas fa-print pr-1" style="color: white!important"></span> Imprimir</button>
              <button id="btnGerarAP" class=" btn btn-secondary text-white btn-sisp botoesMenu">
                <span class="fas fa-dollar-sign pr-1"></span> Gerar AP</button>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modal-config">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 id="modal-Configuração-title" class="modal-title">Configurações GNRE</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="collapse show" id="nfe">
            <div class="card card-body">
              <div class="row">
                <div class="col-6">
                  <label for="txtAmbiente">Ambiente</label>
                  <select style="width:100%;" class="form-control select2 select2-danger focus" data-dropdown-css-class="select2-danger" id="txtAmbiente" class="custom-select focus">
                    <option value="1">Produção</option>
                    <option value="2">Homologação</option>
                  </select>
                </div>
              </div>
              <div class="row">
                <div class="col-12">
                  <label for="txtDiretorioLog">
                    Diretorio Log
                  </label>
                  <div class="relative">
                    <input type="text" class="input-group input-default" id="txtDiretorioLog">
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer float-right">
          <button id="btnConfirmarConfigGNRE" type="button" class="btn bg-gradient-danger btn-sisp">Gravar INI</button>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="modal-pagar">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h4 id="modal-pagar-title" class="modal-title">Gerar Pagar</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="collapse show" id="nfe">
            <div class="card card-body">
              <div class="form-row">
                <div class="form-group col-md-4 col-12" id="NotaFiscalInfoTour">
                  <label>Nota Fiscal *</label>
                  <div class="relative">
                    <input type="text" maxlength="10" autocomplete="off" value="" class="input-default focus form-control validate" required="required" pattern="[0-9]+$" id="txtNotaFiscal" name="txtNotaFiscal">
                  </div>
                </div>

                <div class="form-group group-default col-md-4 col-12">
                  <label>Data de Emissão</label>
                  <div class="relative" id="DataEmissao">
                    <input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDTemissao" name="txtDTemissao">
                  </div>
                </div>

                <div class="form-group group-default col-md-4 col-12">
                  <label>Data de Vencimento</label>
                  <div class="relative">
                    <input type="date" max="2500-12-31" class="input-default focus form-control validate" id="txtDTvencimento" name="txtDTvencimento">
                  </div>
                </div>

                <div class="form-group col-12" id="FornecedorInfoTour">
                  <label data-error="wrong" data-success="right" for="txtFornecedor">Fornecedor *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtFornecedor" name="txtFornecedor" class="form-control" placeholder="Fornecedor">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Fornecedor" name="btn-Fornecedor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Fornecedor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="form-group group-default col-md-4 col-12" id="ValorInfoTour">
                  <label>Valor *</label>
                  <div class="relative">
                    <input type="text" autocomplete="off" maxlength="10" value="" class="input-default focus form-control validate" id="txtValor" name="txtValor" disabled>
                  </div>
                </div>

                <div class="d-none">
                  <input type="text" autocomplete="off" maxlength="13" value="" class="input-default focus form-control validate" id="txtValorPago" name="txtValorPago">
                </div>

                <div class="form-group group-default col-md-4 col-12">
                  <label for="Sstatus">Status</label>
                  <div class="relative">
                    <select id="txtStatus" name="txtStatus" class="input-default focus form-control validate">
                      <option value="" selected>Selecione uma opção</option>
                      <option value="DUPL" id="1">Duplicata</option>
                      <option value="ANTE" id="2">Antecipação</option>
                      <option value="ORCA" id="3">Orçamento</option>
                    </select>
                  </div>
                </div>
                <div class="col-md-4 col-12" id="ClasseInfoTour">
                  <label data-error="wrong" data-success="right" for="txtClasse">Classe *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" required class="input-default focus form-control" id="txtClasse" name="txtClasse" class="form-control" placeholder="Classe">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Classe" name="btn-Classe" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Classe" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-md-4 col-12 form-group" id="BancoInfoTour">
                  <label data-error="wrong" data-success="right" for="txtBanco">Banco *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtBanco" name="txtBanco" class="form-control" placeholder="Banco">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Banco" name="btn-Banco" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Banco" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>

                <div class="col-md-4 col-12 form-group" id="ContaInfoTour">
                  <label data-error="wrong" data-success="right" for="txtConta">Conta *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtConta" name="txtConta" class="form-control" placeholder="Conta">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Conta" name="btn-Conta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Conta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="col-md-4 col-12 form-group" id="SituacaoInfoTour">
                  <label data-error="wrong" data-success="right" for="txtSituacao">Situação *</label>
                  <div class="input-group">
                    <input type="text" autocomplete="off" class="input-default focus form-control" id="txtSituacao" name="txtSituacao" class="form-control" placeholder="Situação">
                    <div class="input-group-append">
                      <button class="btn bg-danger" id="btn-Situacao" name="btn-Situacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                      <button class="btn bg-danger" id="btn-limpa-Situacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                    </div>
                  </div>
                </div>
                <div class="form-group group-default col-12">
                  <label>Observação</label>
                  <textarea style="resize: none" id="txtObs" placeholder="Observação" class="input-default focus form-control validate" rows="4"></textarea>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer float-right">
          <button id="btnGravarPagar" type="button" class="btn bg-gradient-danger btn-sisp">Gravar</button>
        </div>
      </div>
    </div>
  </div>

  <?php
  include_once('../../footer.php');
  ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->

  <!-- jQuery -->
  <script src="plugins/jquery/jquery.min.js?versao=3.237.17.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.237.17.1"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.237.17.1"></script>
  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    if ($('[type="date"]').prop('type') != 'date') {
      $('[type="date"]').datepicker();
    }
    $.widget.bridge('uibutton', $.ui.button)
  </script>

  <!-- Bootstrap 4 -->
  <script src="../plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.237.17.1"></script>
  <script src="../dist/js/sisplan.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="../utils/funcoes.js?versao=3.237.17.1"></script>
  <script src="../dist/js/adminlte.min.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="../dist/js/jquery.dataTables.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="../dist/js/loadingoverlay.min.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="../dist/js/dataTables.bootstrap4.min.js?versao=3.237.17.1"></script>
  <script src="../dist/js/dataTables.keyTable.js?versao=3.237.17.1"></script>
  <script src="../dist/js/requisicoes.js?versao=3.237.17.1"></script>
  <script src="../utils/cookies.js?versao=3.237.17.1"></script>
  <!-- SweetAlert2 -->
  <script src="../plugins/sweetalert2/sweetalert2.min.js?versao=3.237.17.1"></script>
  <script src="../plugins/toastr/toastr.min.js?versao=3.237.17.1"></script>
  <script src="../dist/js/driver.min.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="../dist/js/sum().js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="../config.js?versao=3.237.17.1"></script>
  <script>
    $(document).ready(async function() {

      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('GNRE');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/gnre/gnre.js?versao=3.237.17.1`;
      insereJavaScriptPagina(sArquivo);
    });
  </script>

</body>

</html>