$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description:
            "Clique aqui para ter acesso aos filtros e iniciar uma consulta dos funcionários.",
          position: "right",
        },
      },
      {
        element: "#btn-novoFuncionario",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de um funcionário.",
          position: "right",
        },
      },
      {
        element: "#tabelaFuncionario",
        popover: {
          title: "Tabela Funcionários",
          description: "Aqui estão os dados dos funcionários.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("FUNCIONARIO");

  $('#txtEntidade').autocompleta(1, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
  $('#btnEntidade').pesquisa('#txtEntidade', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`, 'Pesquisa Entidade', 'entidade');

  $('#btnAEntidade').on('click', async function () {
    $('#txtEntidade').val('');
  })

  $("#btnFiltros").on("click", function () {
    $("#modal-filtros").modal("show");
  });

  $("#btn-novoFuncionario").on("click", function () {
    $("#modal-entidade").modal("show");
  });

  $('#btnConfirmarEntidade').on('click', async function () { 

    const codcli = pegaChave('#txtEntidade');

    if (codcli == '') {
      msgAlerta('É necessário informar uma entidade válida.');
      return;
    }

    const pesquisaCodcli = {
      camposSelect: ['CODCLI', 'CNPJ'],
      tabela: 'ENTIDADE',
      where: [`CODCLI = '${codcli}'`]
    };

    const validaCodcli = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaCodcli));

    if (validaCodcli.length == 0) {
      msgAlerta('É necessário informar uma entidade válida.');
      return;
    }

    if (validaCodcli[0].CNPJ.length > 14) {
      msgAlerta('Não é possível cadastrar pessoa jurídica como funcionário.')
      return;
    }

    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = `funcionario/${codcli}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $("#txtFuncionario").autocompleta(
    1,
    'JSON={ "tabela":"pessoal", "camposSelect":[ "codigo chave", "nome descricao"], "where": null}'
  );

  $("#btnFuncionario").pesquisa_serverside(
    ["#txtFuncionario"],
    ["CODIGO", "CPF"],
    ["NOME", "CPF"],
    '{"tabela":"pessoal", "camposSelect":[ "CODIGO", "NOME", "CPF" ], "where": null}',
    "Pesquisa Funcionário"
  );

  // $("#tabelaFuncionario").on('click', "#btnAnexos", async function () {
  //   const data = $('#tabelaFuncionario').DataTable().row($(this).parents('tr')).data();

  //   await abreModalAnexos(data[0], data[1], 'ENTIDADE');
  // })

  $("#btnAFuncionario").on("click", function () {
    $("#txtFuncionario").val("");
  });

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" title="Editar" id="btn-editar">Editar</button>     ' +
      // '    <button class="dropdown-item" title="Imprimir" id="btn-imprimir">Imprimir</button>     ' +
      // '    <button class="dropdown-item"" title="Anexos" id="btnAnexos">Anexos</button>     ' +
      '</div>';
    return retorno;
  };

  await consultaFuncionarios();

  // $("#tabelaFuncionario").on("click", "#btn-imprimir", async function () {
  //   try {
  //     $.LoadingOverlay("show");

  //     let data = $("#tabelaFuncionario")
  //       .DataTable()
  //       .row($(this).parents("tr"))
  //       .data();
  //     let url = `/sisplan/impressao/v1/cliente?codcli=${data[0]}`;
  //     const bImprimeAutomatico = await verificaImprimirAutomatico('Cliente');
  //     let arquivo = await GeraRelatorio(`${url}&`, "GET", 15000, false, 'Cliente');
  //     if (arquivo != undefined) {
  //       if (!bImprimeAutomatico) {
  //         window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
  //       }
  //       await limparRelatorios();
  //     }
  //   } finally {
  //     $.LoadingOverlay("hide");
  //   }
  // });

  $("#btnConsultar").on("click", async function () {
    await consultaFuncionarios(true);
    $("#modal-filtros").modal("hide");
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtDataDe").val("1200-01-01");
    $("#txtDataAte").val("2500-12-01");
    $("#txtAtivo").val("");
    $("#txtFuncionario").val("");
  });

  async function consultaFuncionarios(bBotao = false) {
    try {
      // let response;
      $.LoadingOverlay("show");
      let dataCadastro = '';
      let params;

      if (
        $("#txtDataDe").val() != "01-01-1200" ||
        $$("#txtDataAte").val() != "01-12-2500"
      ) {
        dataCadastro = ` and DATA_CAD >= '${$("#txtDataDe").val()}' and DATA_CAD <= '${$("#txtDataAte").val()}'`;
      }

      let ativo =
        $("#txtAtivo").val() == ""
          ? ""
          : ` and ATIVO = '${$("#txtAtivo").val()}'`;

      let codfuncionario =
        pegaChave("#txtFuncionario") == ""
          ? ""
          : ` AND CODIGO = '${pegaChave("#txtFuncionario")}'`;

      if (bBotao) {
        params = '[" 1=1 ';
        if (codfuncionario != '') {
          params += codfuncionario;
        }

        if (ativo != '') {
          params += ativo;
        }

        if (dataCadastro != '') {
          params += dataCadastro;
        }

        params += ' "]';

        // params = `["1=1 ${codcliente}, ${ativo}, ${bloqueado}, ${dataCadastro == "" ? "" : dataCadastro}, ${dataAniver == "" ? "" : dataAniver} "]`;

      } else {
        params = "";
      }

      $("#tabelaFuncionario").DataTable({
        destroy: true,
        lengthChange: false,
        serverSide: true,
        processing: true,
        ajax: {
          url: `${getCookie('protocolo')}://${getCookie("ip_api")}/sisplan/funcoes/v1/pesquisadatatable`,
          type: "GET",
          headers: { Authorization: BASIC_AUTH },
          data: {
            EMPRESA: getCookie("empresa"),
            JSON: `{"tabela":"pessoal", "camposSelect":[ "codigo", "nome"], "where": ${params == "" ? "null" : params}}`,
            CLIENTE: "S",
          },
        },
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            },
          },
        ],
      });
      $("input[type='search']").focus();
      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
      msgErro(`Não foi possível buscar os dados do funcionário: ${error}`);
    }
  }

  $("#tabelaFuncionario").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaFuncionario").DataTable().row($(this).parents("tr")).data();
      let clienteLiberado = await liberarRegistro("FUNCIONARIO", data[0]);
      if (clienteLiberado) {
        window.location.href = `funcionario/${data[0]}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("#tabelaFuncionario").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaFuncionario").DataTable().row($(this)).data();
      let clienteLiberado = await liberarRegistro("FUNCIONARIO", data[0]);
      if (clienteLiberado) {
        window.location.href = `funcionario/${data[0]}`;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $("input[type='search']").on("keydown", function () {
    if (window.event.which === 13) {
      $("#btn-editar").trigger("click");
    }
  });
});
