// $("#tutorial").on("click", function () {
//   $(document).ready(async function () {
//     const driver = new Driver({
//       doneBtnText: "Sair",
//       closeBtnText: "Fechar",
//       nextBtnText: "Próximo",
//       prevBtnText: "Anterior",
//       allowClose: false,
//     });
//     driver.defineSteps([
//       {
//         element: "#btnFiltros",
//         popover: {
//           title: "Botão Filtros",
//           description: "Clique aqui para filtrar a consulta dos CEPs.",
//           position: "right",
//         },
//       },
//       {
//         element: "#btnNovoPreco",
//         popover: {
//           title: "Botão Incluir",
//           description: "Clique aqui para iniciar o cadastro de um CEP.",
//           position: "right",
//         },
//       },
//       {
//         element: "#tabelaRegiao",
//         popover: {
//           title: "Tabela CEPs",
//           description: "Aqui estão todos os CEPs cadastrados.",
//           position: "top",
//         },
//       },
//     ]);
//     driver.start();
//   });
// });

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("EMPRESA");


  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '</div>';
    return retorno;
  };


  ConsultaEmpresas();

  async function ConsultaEmpresas() {
    try {
      $.LoadingOverlay("show");

      let response;
      response = await requisicao(
        "GET",
        "/sisplan/funcoes/v1/pesquisa?",
        `JSON={ "tabela":"empresa", "camposSelect":["replace(emp_pat, '_', '') emp_pat", "emp_nome", "emp_fantasia", "emp_cnpj", "emp_id"]}`,
        null
      );
      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#tabelaEmpresas").DataTable({
        destroy: true,
        lengthChange: false,
        serverside: true,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },

        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "EMP_PAT",
          },
          {
            data: "EMP_NOME",
          },
          {
            data: "EMP_FANTASIA",
          },
          {
            data: "EMP_CNPJ",
          },
          {
            data: "EMP_ID",
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      console.log(error);
    }
  }

  $("#tabelaEmpresas").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaEmpresas").DataTable().row($(this).parents("tr")).data();
      window.location.href = `empresa/${data.EMP_ID}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#btnNovaEmpresa').on('click', function () {
    if (getCookie('cod_usuario') == '0000') {
      window.location.href = `empresa/create`;
    } else {
      msgAlertaSemConfirmacao("Apenas usuários SISPLAN podem incluir uma nova empresa.");
    }
  });

  $("#tabelaEmpresas").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaEmpresas").DataTable().row($(this)).data();
      window.location.href = `empresa/${data.EMP_ID}`;
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });
});
