async function avancarPag() {
  if ($("#txtCodigo").val() == "") {
    $("#txtCodigo").val(0);
  }
  if ($("#txtDeposito").val() == "") {
    $("#txtDeposito").val(" ");
  }
  if ($("#selectPosse").val() == "") {
    $("#selectPosse").val(0);
  }

  currentFs = $(this).parent();
  nextFs = $(this).parent().next();

  $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

  nextFs.show();
  currentFs.animate(
    {
      opacity: 0,
    },
    {
      step(now) {
        opacity = 1 - now;

        currentFs.css({
          display: "none",
          position: "relative",
        });
        nextFs.css({
          opacity,
        });
      },
      duration: 600,
    }
  );
}

$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
      animate: true,
      onNext: (Element) => {
        if (Element.node.id == "avancar1") {
          avancarPag();
          $("#avancar1").trigger("click");
        }
        if (Element.node.id == "avancar2") {
          $("#avancar2").trigger("click");
        }
      },
      onPrevious: (Element) => {
        if (Element.node.id == "configDep") {
          $("#voltar").trigger("click");
        }
        if (Element.node.id == "tipoDep") {
          $("#voltar2").trigger("click");
        }
      },
    });

    driver.defineSteps([
      {
        element: "#formcard1",
        popover: {
          title: "Dados Gerais",
          description: "Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtCodigo",
        popover: {
          title: "Código",
          description:
            "O campo de código é preenchido automaticamente após gravar o registro.",
          position: "top",
        },
      },
      {
        element: "#txtDeposito",
        popover: {
          title: "Descrição do depósito",
          description:
            "Neste campo adicionamos a descrição para o registro que estamos criando ou alterando.",
          position: "top",
        },
      },
      {
        element: "#btnVoltar",
        popover: {
          title: "Botão Voltar",
          description:
            "Ao clicar nesse botão você retorna para a tela de consulta.",
          position: "left",
        },
      },
      {
        element: "#avancar1",
        popover: {
          title: "Botão Avançar",
          description: "Clique aqui para ir para a próxima aba.",
          position: "left",
        },
      },
      {
        element: "#configDep",
        popover: {
          title: "Opções",
          description: "Aqui estão as configurações do depósito.",
          position: "top",
        },
      },
      {
        element: "#avancar2",
        popover: {
          title: "Botão Avançar",
          description: "Clique aqui para ir para a próxima aba.",
          position: "left",
        },
      },
      {
        element: "#tipoDep",
        popover: {
          title: "Tipo da Região",
          description: "Aqui você selecionará algumas opções do depósito.",
          position: "top",
        },
      },
      {
        element: "#btnGravar",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar o depósito.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let queryString = window.location.href;
  let parametros = queryString.split("/");
  let depositoUrl = parametros[parametros.length - 1];

  let contaFs = 1;

  $("#txtCodigo").prop("disabled", true);

  $("#btnVoltar").on("click", async function () {
    await deletaRegistro("DEPOSITO", getCookie("usuario"), parametros[5]);
    window.location.href = `${BASE_URI}/deposito`;
  });

  $(document).ready(function () {
    $("#txtMarkup").maskMoney({
      decimal: ".",
      thousands: "",
      precision: 2,
    });

    let currentFs;
    let nextFs;
    let previousFs; // fieldsets
    let opacity;

    $(".next").click(function () {
      contaFs += 1;

      let validator = $("#msform").validate();
      validator.form();
      let erros = 0;
      erros = validator.numberOfInvalids();

      if (erros == 0) {
        currentFs = $(this).parent();
        nextFs = $(this).parent().next();

        $("#progressbar li").eq($("fieldset").index(nextFs)).addClass("active");

        nextFs.show();
        currentFs.animate(
          {
            opacity: 0,
          },
          {
            step(now) {
              opacity = 1 - now;

              currentFs.css({
                display: "none",
                position: "relative",
              });
              nextFs.css({
                opacity,
              });
            },
            duration: 600,
          }
        );
      }
    });

    $("#msform").validate({
      debug: false,
      ignore: "",
      rules: {
        txtDeposito: {
          required: true,
        },
        selectPosse: {
          required: true,
        },
      },
      messages: {
        txtDeposito: {
          required: "Informe uma descrição válida.",
        },
        selectPosse: {
          required: "Selecione uma posse.",
        },
      },
      errorElement: "span",
      errorPlacement(error, element) {
        error.addClass("invalid-feedback");
        element.closest(".form-group").append(error);
      },
      highlight(element) {
        $(element).addClass("is-invalid");
      },
      unhighlight(element) {
        $(element).removeClass("is-invalid");
      },
    });

    $(".previous").click(function () {
      contaFs -= 1;

      currentFs = $(this).parent();
      previousFs = $(this).parent().prev();
      $("#progressbar li")
        .eq($("fieldset").index(currentFs))
        .removeClass("active");
      previousFs.show();
      currentFs.animate(
        {
          opacity: 0,
        },
        {
          step(now) {
            opacity = 1 - now;
            currentFs.css({
              display: "none",
              position: "relative",
            });
            previousFs.css({
              opacity,
            });
          },
          duration: 600,
        }
      );
    });

    $(".radio-group .radio").click(function () {
      $(this).parent().find(".radio").removeClass("selected");
      $(this).addClass("selected");
    });

    $(".submit").click(function () {
      return false;
    });
  });
  // autocompleta
  $("#txtEmpresa").autocompleta(
    1,
    `JSON={ "tabela":"empresa", "camposSelect":[ "replace(emp_pat, '_', '') chave", "EMP_NOME descricao"], "where": null}`
  );
  $("#txtSetor").autocompleta(
    1,
    `JSON={ "tabela":"cadfluxo", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );
  $("#txtCliente").autocompleta(
    3,
    `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`
  );
  // pesquisa
  $("#btnEmpresa").pesquisa(
    "#txtEmpresa",
    "EMP_PAT",
    "EMP_NOME",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"empresa", "camposSelect":[ "replace(emp_pat, '_', '') EMP_PAT", "emp_nome"]}`,
    "Pesquisa Empresa",
    "empresa"
  );
  $("#btnSetor").pesquisa(
    "#txtSetor",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadfluxo", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa Setor",
    "cadfluxo"
  );
  $("#btnCliente").pesquisa(
    "#txtCliente",
    "CODCLI",
    "NOME",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`,
    "Pesquisa Cliente",
    "entidade"
  );
  // limpa campo
  $("#btnExcluiEmpresa").on("click", function () {
    $("#txtEmpresa").val("");
  });

  $("#btnExcluiSetor").on("click", function () {
    $("#txtSetor").val("");
  });

  $("#btnExcluiCliente").on("click", function () {
    $("#txtCliente").val("");
  });

  try {
    let response = await requisicao(
      "GET",
      "/Sisplan/Funcoes/v1/pesquisa?",
      `JSON={ "tabela":"DEPOSITO", 
                "camposSelect":["count(CODIGO) as CONTAGEM"], 
                "where": ["1 = 1"]}`,
      null
    );
    let jsonStr = await response.json();
    $("#txtOrdem").val(jsonStr.RESULT[0][0].CONTAGEM + 1);
  } catch (error) {
    console.error(error);
  }

  if (depositoUrl != "" && depositoUrl != "create") {
    $("#account").css("cursor", "pointer");
    $("#payment").css("cursor", "pointer");
    $("#personal").css("cursor", "pointer");

    if ((await liberarRegistro("DEPOSITO", depositoUrl)) == false) {
      window.location.href = "../deposito";
    } else {
      try {
        $.LoadingOverlay("show");
        try {
          let responseStr = await requisicao(
            "GET",
            "/Sisplan/Funcoes/v1/pesquisa?",
            `JSON={ "tabela":"DEPOSITO", "camposSelect":["REPLICACAO", "CONTR_TERC", "ENFESTO", "LIBERADO", 
                                                         "RESERVA_PEDIDO", "ABATIMENTO_PI", "LOTE_MINIMO", "ABATIMENTO",
                                                         "EXP_PLASTICO", "ECOMMERCE", "EXP_METALURGICO", "ENT_BAIXA_OF", "BAIXA_CONSUMOS", 
                                                         "LOJA", "EXPEDICAO", "SAI_TECEL", "SAI_TINTUR", "VENDA", "PRIORIDADE", "USA_PROG", 
                                                         "PROD_ACABADO", "BENEF", "ENT_COMPRA", "ENT_TECEL", "ENT_TINTUR", "FAT_ESTOQUE_NEG", 
                                                         "ATIVO", "CODCLI", "SETOR", "POSSE", "ORDEM", "CODIGO", "MARKUP", "DESCRICAO", "EMPRESA", 
                                                         "ORDEM"], "where": ["CODIGO = '${depositoUrl}'"]}`,
            null
          );
          if (!responseStr) {
            return;
          }
          let jsonStrTal = await responseStr.json();
          if (responseStr.status != 200) {
            msgErro(jsonStrTal.RESULT[0].mensagem);
            return;
          }

          $("#txtCodigo").attr("readonly", true);

          $("#txtCodigo").val(jsonStrTal.RESULT[0][0].CODIGO);
          $("#txtDeposito").val(jsonStrTal.RESULT[0][0].DESCRICAO);
          parseFloat($("#txtMarkup").val(jsonStrTal.RESULT[0][0].MARKUP));
          parseFloat($("#txtOrdem").val(jsonStrTal.RESULT[0][0].ORDEM));
          $("#selectPosse").val(jsonStrTal.RESULT[0][0].POSSE);

          try {
            let responseOperadora = await requisicao(
              "GET",
              "/Sisplan/Funcoes/v1/pesquisa?",
              `JSON={ "tabela":"empresa", 
                        "camposSelect":["emp_nome"], 
                        "where": ["emp_pat = '_${jsonStrTal.RESULT[0][0].EMPRESA}'"]}`,
              null
            );

            if (!responseOperadora) {
              return;
            }
            let jsonStrOperadora = await responseOperadora.json();
            if (responseOperadora.status != 200) {
              msgErro(jsonStrClasse.RESULT[0].mensagem);
              return;
            }

            insereValor(
              "#txtEmpresa",
              jsonStrTal.RESULT[0][0].EMPRESA,
              jsonStrOperadora.RESULT[0][0].EMP_NOME
            );
          } catch (error) {
            console.error(error);
          }

          try {
            let responseOperadora = await requisicao(
              "GET",
              "/Sisplan/Funcoes/v1/pesquisa?",
              `JSON={ "tabela":"cadfluxo", 
                        "camposSelect":["descricao"], 
                        "where": ["codigo = '${jsonStrTal.RESULT[0][0].SETOR}'"]}`,
              null
            );

            if (!responseOperadora) {
              return;
            }
            let jsonStrOperadora = await responseOperadora.json();
            if (responseOperadora.status != 200) {
              msgErro(jsonStrClasse.RESULT[0].mensagem);
              return;
            }

            insereValor(
              "#txtSetor",
              jsonStrTal.RESULT[0][0].SETOR,
              jsonStrOperadora.RESULT[0][0].DESCRICAO
            );
          } catch (error) {
            console.error(error);
          }

          try {
            let responseOperadora = await requisicao(
              "GET",
              "/Sisplan/Funcoes/v1/pesquisa?",
              `JSON={ "tabela":"entidade", 
                        "camposSelect":["nome"], 
                        "where": ["CODCLI = '${jsonStrTal.RESULT[0][0].CODCLI}'"]}`,
              null
            );

            if (!responseOperadora) {
              return;
            }
            let jsonStrOperadora = await responseOperadora.json();
            if (responseOperadora.status != 200) {
              msgErro(jsonStrClasse.RESULT[0].mensagem);
              return;
            }

            insereValor(
              "#txtCliente",
              jsonStrTal.RESULT[0][0].CODCLI,
              jsonStrOperadora.RESULT[0][0].NOME
            );
          } catch (error) {
            console.error(error);
          }

          if (jsonStrTal.RESULT[0][0].ATIVO == "S") {
            $("#checkAtivo").prop("checked", true);
          } else {
            $("#checkAtivo").prop("checked", false);
          }

          if (jsonStrTal.RESULT[0][0].FAT_ESTOQUE_NEG == "N") {
            $("#inputNaoFatNeg").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].FAT_ESTOQUE_NEG == "S") {
            $("#inputFatNeg").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].FAT_ESTOQUE_NEG == "M") {
            $("#inputFatMsg").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].ENT_TINTUR == "S") {
            $("#checkETinturaria").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].ENT_TECEL == "S") {
            $("#checkETecelagem").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].ENT_COMPRA == "S") {
            $("#checkECompras").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].BENEF == "S") {
            $("#checkBeneficiamento").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].PROD_ACABADO == "S") {
            $("#checkProdAcabado").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].USA_PROG == "S") {
            $("#checkConsProg").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].PRIORIDADE == "1") {
            $("#checkPadrao").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].VENDA == "S") {
            $("#checkHabVendas").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].SAI_TINTUR == "S") {
            $("#checkSTinturaria").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].SAI_TECEL == "S") {
            $("#checkSTecelagem").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].EXPEDICAO == "S") {
            $("#checkExpedicao").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].LOJA == "S") {
            $("#checkLoja").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].BAIXA_CONSUMOS == "S") {
            $("#checkBaixaCons").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].ENT_BAIXA_OF == "S") {
            $("#checkBaixaOF").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].EXP_METALURGICO == "S") {
            $("#checkExpMetalurgico").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].ECOMMERCE == "S") {
            $("#checkHabECom").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].EXP_PLASTICO == "S") {
            $("#checkExpPlas").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].ABATIMENTO == "S") {
            $("#checkAbatimento").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].LOTE_MINIMO == "S") {
            $("#checkLoteMin").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].ABATIMENTO_PI == "S") {
            $("#checkAbatimentoPI").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].RESERVA_PEDIDO == "S") {
            $("#checkResPed").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].LIBERADO == "S") {
            $("#checkLiberado").prop("checked", true);
          } else {
            $("#checkLiberado").prop("checked", false);
          }

          if (jsonStrTal.RESULT[0][0].ENFESTO == "S") {
            $("#checkEnfesto").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].CONTR_TERC == "S") {
            $("#checkControleTerc").prop("checked", true);
          }

          if (jsonStrTal.RESULT[0][0].REPLICACAO == "S") {
            $("#checkReplicacao").prop("checked", true);
          }
        } catch (error) {
          console.error(error);
          msgErro(`Não foi possível buscar os dados do depósito: ${error}`);
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    }
  }

  $("#account").on("click", function () {
    if (depositoUrl != "create") {
      if (contaFs == 2) {
        $("#voltar").trigger("click");
      }
      if (contaFs == 3) {
        $("#voltar2").trigger("click");
        $("#voltar").trigger("click");
      }
    }
  });

  $("#payment").on("click", function () {
    if (depositoUrl != "create") {
      if (contaFs == 1) {
        $("#avancar1").trigger("click");
      }
      if (contaFs == 3) {
        $("#voltar2").trigger("click");
      }
    }
  });

  $("#personal").on("click", function () {
    if (depositoUrl != "create") {
      if (contaFs == 1) {
        $("#avancar1").trigger("click");
        $("#avancar2").trigger("click");
      }
      if (contaFs == 2) {
        $("#avancar2").trigger("click");
      }
    }
  });

  $("#txtCodigo").change(async function () {
    try {
      $.LoadingOverlay("show");
      try {
        let response3 = await requisicao(
          "GET",
          "/Sisplan/Funcoes/v1/pesquisa?",
          `JSON={ "tabela":"deposito", 
                "camposSelect":["codigo"], 
                "where": ["codigo = '${$("#txtCodigo").val()}'"]}`,
          null
        );

        if (!response3) {
          return;
        }
        let jsonStr1 = await response3.json();
        if (jsonStr1.RESULT[0].length > 0) {
          msgAlerta("Depósito já cadastrado.");
          $("#txtCodigo").val("");
        }
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  $("#btnGravar").click(async function () {
    try {
      $.LoadingOverlay("show");

      let deposito = {};

      deposito.CODIGO =
        $("#txtCodigo").val() == ""
          ? await RetornaProximo("DEPOSITO", "DEPOSITO", "CODIGO", 4)
          : $("#txtCodigo").val();
      deposito.DESCRICAO = $("#txtDeposito").val().toUpperCase();
      deposito.EMPRESA = pegaChave('#txtEmpresa');
      deposito.MARKUP = parseFloat($("#txtMarkup").val().replace(",", "."));
      deposito.ORDEM = parseFloat($("#txtOrdem").val());
      deposito.SETOR = pegaChave($("#txtSetor").val(), deposito.SETOR);
      deposito.CODCLI = pegaChave($("#txtCliente").val(), deposito.CODCLI);
      deposito.POSSE = $("#selectPosse").val();

      if ($("#checkAtivo").prop("checked")) {
        deposito.ATIVO = "S";
      } else {
        deposito.ATIVO = "N";
      }

      if ($("#checkReplicacao").prop("checked")) {
        deposito.REPLICACAO = "S";
      } else {
        deposito.REPLICACAO = "N";
      }

      if ($("#inputFatNeg").prop("checked")) {
        deposito.FAT_ESTOQUE_NEG = "S";
      }
      if ($("#inputNaoFatNeg").prop("checked")) {
        deposito.FAT_ESTOQUE_NEG = "N";
      }
      if ($("#inputFatMsg").prop("checked")) {
        deposito.FAT_ESTOQUE_NEG = "M";
      }

      if ($("#checkETinturaria").prop("checked")) {
        deposito.ENT_TINTUR = "S";
      } else {
        deposito.ENT_TINTUR = "N";
      }

      if ($("#checkETecelagem").prop("checked")) {
        deposito.ENT_TECEL = "S";
      } else {
        deposito.ENT_TECEL = "N";
      }

      if ($("#checkECompras").prop("checked")) {
        deposito.ENT_COMPRA = "S";
      } else {
        deposito.ENT_COMPRA = "N";
      }

      if ($("#checkBeneficiamento").prop("checked")) {
        deposito.BENEF = "S";
      } else {
        deposito.BENEF = "N";
      }

      if ($("#checkProdAcabado").prop("checked")) {
        deposito.PROD_ACABADO = "S";
      } else {
        deposito.PROD_ACABADO = "N";
      }

      if ($("#checkConsProg").prop("checked")) {
        deposito.USA_PROG = "S";
      } else {
        deposito.USA_PROG = "N";
      }

      if ($("#checkPadrao").prop("checked")) {
        deposito.PRIORIDADE = "1";
      } else {
        deposito.PRIORIDADE = "0";
      }

      if ($("#checkHabVendas").prop("checked")) {
        deposito.VENDA = "S";
      } else {
        deposito.VENDA = "N";
      }

      if ($("#checkSTinturaria").prop("checked")) {
        deposito.SAI_TINTUR = "S";
      } else {
        deposito.SAI_TINTUR = "N";
      }

      if ($("#checkSTecelagem").prop("checked")) {
        deposito.SAI_TECEL = "S";
      } else {
        deposito.SAI_TECEL = "N";
      }

      if ($("#checkExpedicao").prop("checked")) {
        deposito.EXPEDICAO = "S";
      } else {
        deposito.EXPEDICAO = "N";
      }

      if ($("#checkLoja").prop("checked")) {
        deposito.LOJA = "S";
      } else {
        deposito.LOJA = "N";
      }

      if ($("#checkBaixaCons").prop("checked")) {
        deposito.BAIXA_CONSUMOS = "S";
      } else {
        deposito.BAIXA_CONSUMOS = "N";
      }

      if ($("#checkBaixaOF").prop("checked")) {
        deposito.ENT_BAIXA_OF = "S";
      } else {
        deposito.ENT_BAIXA_OF = "N";
      }

      if ($("#checkExpMetalurgico").prop("checked")) {
        deposito.EXP_METALURGICO = "S";
      } else {
        deposito.EXP_METALURGICO = "N";
      }

      if ($("#checkHabECom").prop("checked")) {
        deposito.ECOMMERCE = "S";
      } else {
        deposito.ECOMMERCE = "N";
      }

      if ($("#checkExpPlas").prop("checked")) {
        deposito.EXP_PLASTICO = "S";
      } else {
        deposito.EXP_PLASTICO = "N";
      }

      if ($("#checkAbatimento").prop("checked")) {
        deposito.ABATIMENTO = "S";
      } else {
        deposito.ABATIMENTO = "N";
      }

      if ($("#checkLoteMin").prop("checked")) {
        deposito.LOTE_MINIMO = "S";
      } else {
        deposito.LOTE_MINIMO = "N";
      }

      if ($("#checkAbatimentoPI").prop("checked")) {
        deposito.ABATIMENTO_PI = "S";
      } else {
        deposito.ABATIMENTO_PI = "N";
      }

      if ($("#checkResPed").prop("checked")) {
        deposito.RESERVA_PEDIDO = "S";
      } else {
        deposito.RESERVA_PEDIDO = "N";
      }

      if ($("#checkLiberado").prop("checked")) {
        deposito.LIBERADO = "S";
      } else {
        deposito.LIBERADO = "N";
      }

      if ($("#checkEnfesto").prop("checked")) {
        deposito.ENFESTO = "S";
      } else {
        deposito.ENFESTO = "N";
      }

      if ($("#checkControleTerc").prop("checked")) {
        deposito.CONTR_TERC = "S";
      } else {
        deposito.CONTR_TERC = "N";
      }

      let responseGravacao = await requisicao(
        "POST",
        "/Sisplan/Cadastros/v1/deposito?",
        `JSON=${encodeURIComponent(JSON.stringify(deposito))}`,
        null
      );

      if (!responseGravacao) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStrGrava = await responseGravacao.json();
      if (responseGravacao.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStrGrava.mensagem, () =>  { window.location.reload() });
        return;
      }
      $.LoadingOverlay("hide");
      toastr
        .success(
          `Cadastro efetuado com sucesso!
                    Depósito: ${deposito.CODIGO}`,
          "Confirmação",
          {
            toastClass: "alert",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 5000,
            fadeOut: 3000,
            onHidden() {
              window.location.href = `${BASE_URI}/deposito`;
            },
          }
        )
        .css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });
    } catch (error) {
      $.LoadingOverlay("hide");
      msgErro(`Não foi possível gravar os dados do depósito: ${error}`);
    }
  });
});
