$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([

    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  let queryString = window.location.href;
  let parametros = queryString.split('/');
  let data = parametros[parametros.length - 1];
  if (data != "create") {
    $('#txtId').val(data);
    await buscaDados(data);
  }

  $('#btnToken').on('click', async function () {
    try {
      const session = $('#txtNomeDispositivo').val();
      const secretKey = 'SECURETOKENBYSISPLANSISTEMAS';
      const response = await requisicao_wpp('POST', `/api/${session}/${secretKey}/generate-token`, '');
      if (!response) {
        return;
      }
      if (![200, 201].includes(response.status)) {
        msgErro('Erro ao gerar token, tente novamente.');
        return;
      }
      const jsonStr = await response.json();
      $('#txtToken').val(jsonStr.token);
    } catch (error) {
      msgErro('Erro ao gerar token, tente novamente.');
      console.error(error);
    }
  });

  $('#btnConectar').on('click', async function () {
    try {
      const session = $('#txtNomeDispositivo').val();
      const token = $('#txtToken').val();
      const response = await requisicao_wpp('POST', `/api/${session}/start-session`, '', JSON.stringify({
        webhook: null,
        waitQrCode: true
      }), null, token);
      if (!response) {
        return;
      }
      if (![200, 201].includes(response.status)) {
        msgAlerta('Não foi possível gerar o qr-code de conexão, tente novamente.');
        return;
      }
      const jsonStr = await response.json();
      if (jsonStr.status != 'QRCODE') {
        msgAlerta('QrCode sendo gerado, tente novamente em alguns segundos...');
        return;
      }
      if (jsonStr.qrcode && jsonStr.qrcode != '' && jsonStr.qrcode != 'null' && jsonStr.qrcode != null) {
        const qrCode = jsonStr.qrcode.indexOf('data:image') >= 0 ? jsonStr.qrcode : 'data:image/png;base64,'+jsonStr.qrcode; 
        $('#qrcode').attr('src', `${qrCode}`);
        $('#qrcode').removeClass('d-none');
      } else {
        if (jsonStr.status == 'CONNECTED') {
          msgAlerta('Dispositivo já conectado.');
          return;
        }
        msgAlerta('Não foi possível gerar o qr-code de conexão, tente novamente.');
      }
    } catch (error) {
      msgAlerta('Não foi possível gerar o qr-code de conexão, tente novamente.');
      console.error(error);
    }
  });

  async function buscaDados(id) {
    try {
      $.LoadingOverlay('show');
      const pesquisa = {
        tabela: "WHATSAPPWEB",
        camposSelect: ["ID", "NOME", "TELEFONE", "TOKEN"],
        where: [`ID = '${id}'`]
      }

      const response = await requisicao("GET", "/Sisplan/Funcoes/V1/pesquisa?", `JSON=${JSON.stringify(pesquisa)}`, null);
      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      const dados = jsonStr.RESULT[0][0];
      $('#txtId').val(dados.ID);
      $('#txtNomeDispositivo').val(dados.NOME);
      $('#txtTelefone').val(dados.TELEFONE);
      $('#txtToken').val(dados.TOKEN);

    } finally {
      $.LoadingOverlay('hide');
    }
  };

  function validaGravacao() {
    const bNomeValido = $('#txtNomeDispositivo').val() != '';
    const bTelefone = $('#txtTelefone').val() != '';
    const bToken = $('#txtToken').val() != '';

    return bNomeValido && bTelefone && bToken;
  }

  async function gravaDados() {
    const url = `/sisplan/config_whatsapp/v1/salvar?`;
    if (!validaGravacao()) {
      msgAlerta('Campos não preenchidos, verifique.');
      return;
    }
    msgAlerta(`Tem certeza que deseja gravar as Configurações de WhatsApp?`, async function () {
      try {
        try {
          $.LoadingOverlay("show");
          const objeto = {
            id: $('#txtId').val() != '' ? $('#txtId').val() : null,
            nome: $('#txtNomeDispositivo').val(),
            telefone: $('#txtTelefone').val(),
            token: $('#txtToken').val()
          }
          const response = await requisicao("POST", url, "", JSON.stringify(objeto), 120000);

          if (!response) {
            msgErro("Não foi possível efetuar a gravação dos dados, tente novamente.");
            return;
          }

          // let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro("Não foi possível efetuar a gravação dos dados, tente novamente.");
            return;
          }
          toastr
            .success("Gravação efetuada com sucesso", "Confirmação", {
              toastClass: "alert",
              iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              async onHidden() {
                window.location.href = `${BASE_URI}/config_whatsapp`;
              },
            })
            .css({
              "margin-top": "20%",
              width: "500px",
              "max-width": "500px",
            });

        } catch (error) {
          console.error(error);
          msgErro("Não foi possível efetuar a gravação dos dados, tente novamente.");
          return;
        }
      } finally {
        $.LoadingOverlay("hide");
      }
    });
  }

  $('#btnVoltar').on('click', function () {
    window.location.href = `${BASE_URI}/config_whatsapp`;
  });

  $('#btnGravar').on('click', function () {
    gravaDados();
  });

  $('#txtNomeDispositivo').focus();


});
