$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("CONFIG_WHATSAPP");

  $("#btnConsultar").on("click", async function () {
    await buscarDados();
  });

  function retornaBotaoOpcoes() {
    return (
      '<div class="divBtnOpcoes"> ' +
      '    <button class="botaoOpcoes" type="button" title="Editar" id="btn-editar"><span class="fas fa-edit" style="color:green"></span></button>     ' +
      '    <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      "</div>"
    );
  }

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };


  $("#btnNovoTemplate").on("click", async function () {
    if (permissaoUsuarioLogado.INCLUI == "S") {
      window.location.href = "config_whatsapp/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  async function buscarDados() {
    try {
      $.LoadingOverlay("show");

      const objetoPesquisa = {
        tabela: "WHATSAPPWEB",
        camposSelect: ["ID", "NOME", "TELEFONE", "'' ACOES"],
        where: [`1=1`],
      };

      const response = await requisicao(
        "GET",
        "/Sisplan/Funcoes/v1/pesquisa?",
        `JSON=${JSON.stringify(objetoPesquisa)}`,
        null
      );
      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      const jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgAlerta(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#tabelaCadastros").DataTable({
        destroy: true,
        lengthChange: false,
        order: false,
        search: false,
        language: {
          sEmptyTable: "Nenhum registro encontrado",
          sInfo: "_TOTAL_ registros",
          sInfoEmpty: " 0 registros",
          sInfoFiltered: "(Filtrados de _MAX_ registros)",
          sInfoPostFix: "",
          sInfoThousands: ".",
          sLengthMenu: "_MENU_ resultados",
          sLoadingRecords: "Carregando...",
          sProcessing: "Processando...",
          sZeroRecords: "Nenhum registro encontrado",
          sSearch: "Pesquisar",
          oPaginate: {
            sNext: "Próximo",
            sPrevious: "Anterior",
            sFirst: "Primeiro",
            sLast: "Último",
          },
          oAria: {
            sSortAscending: ": Ordenar colunas de forma ascendente",
            sSortDescending: ": Ordenar colunas de forma descendente",
          },
        },

        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "ID",
          },
          {
            data: "NOME",
          },
          {
            data: "TELEFONE",
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $("#tabelaCadastros").on("click", "#btn-editar", async function () {
        if (permissaoUsuarioLogado.ALTERA == "S") {
          const data = $("#tabelaCadastros").DataTable().row($(this).parents("tr")).data();
          const id = data.ID;
          window.location.href = `config_whatsapp/${id}`;
        } else {
          msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
      });

      $("#tabelaCadastros").on("dblclick", "tr", async function () {

        if (permissaoUsuarioLogado.ALTERA == "S") {
          const data = $("#tabelaCadastros").DataTable().row($(this)).data();
          const id = data.ID;
          window.location.href = `config_whatsapp/${id}`;
        } else {
          msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
      });

      $("#tabelaCadastros").on("click", "#btn-excluir", async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
          msgAlerta("Você realmente deseja excluir esse registro?", async () => {
            const data = $("#tabelaCadastros").DataTable().row($(this).parents("tr"));
            await excluiRegistro(data);
          }
          );
        } else {
          msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  buscarDados();
  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        const valorLinha = data.data();
        const objeto = {
          id: valorLinha.ID,
        };
        let response = await requisicao(
          "POST",
          "/sisplan/config_whatsapp/v1/deletar?",
          ``,
          JSON.stringify(objeto)
        );
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr
          .success("Exclusão efetuada com sucesso!", "Confirmação", {
            toastClass: "success",
            iconClasses: {
              error: "alert-error",
              info: "alert-info",
              success: "alert-success",
              warning: "alert-warning",
            },
            positionClass: "toast-top-center",
            progressBar: true,
            timeOut: 3000,
            fadeOut: 1000,
            onHidden() {
              data.remove().draw(false);
            },
          })
          .css({
            "margin-top": "20%",
            width: "500px",
            "max-width": "500px",
          });
      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});
