<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Cliente</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.237.17.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.237.17.1">

  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>


  <link rel="stylesheet" href="dist/css/custom.css?versao=3.237.17.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.237.17.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.237.17.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.237.17.1" />
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.237.17.1">
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.237.17.1">
  <style>
    #tabelaClientes td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaClientes td {
      padding: 0 !important;
      padding-left: 10px !important;
    }
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <?php
    include_once('../../../menu.php');
    ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Cadastro de Clientes</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div><!-- /.col -->
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="index">Início</a></li>
                <li class="breadcrumb-item active">Cadastro de Clientes</li>
              </ol>
            </div><!-- /.col -->
          </div><!-- /.row -->
          <!-- Small boxes (Stat box) -->
          <div class="row">
            <div class="col-md-4 col-sm-4 col-12">
              <div id="totalclientes" class="info-box">
                <span class="info-box-icon bg-info"><i class="fas fa-users"></i></span>

                <div class="info-box-content">
                  <span class="info-box-text">Total Clientes</span>
                  <span class="info-box-number" id="txt_val_total">0.00</span>
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            <div id="totalativos" class="col-md-4 col-sm-4 col-12">
              <div class="info-box">
                <span class="info-box-icon bg-success"><i class="fas fa-user-plus"></i></span>

                <div class="info-box-content">
                  <span class="info-box-text">Total Ativos</span>
                  <span class="info-box-number" id="txt_val_ativos">0.00</span>
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            <div id="totalbloqueados" class="col-md-4 col-sm-4 col-12">
              <div class="info-box">
                <span class="info-box-icon bg-danger"><i class="fas fa-user-times"></i></span>

                <div class="info-box-content">
                  <span class="info-box-text">Total Bloqueados</span>
                  <span class="info-box-number" id="txt_val_bloqueados">0.00</span>
                </div>
                <!-- /.info-box-content -->
              </div>
              <!-- /.info-box -->
            </div>
            <!-- /.col -->
          </div>
          <!-- right col -->
        </div>
        <div class="container-fluid">
          <div class="row card">
            <div class="col-sm-12 mt-3">
              <!-- <div class="btn-group ml-3"> -->
              <button class="btn btn-success btn-sisp" id="btnFiltros" type="button"><span class="fas fa-filter"></span>
                Filtros</button>
              <button class="btn btn-danger btn-sisp" id="btn-novoClientes"><span class="fas fa-plus"></span> Incluir</button>
              <!-- </div> -->
            </div>
            <div class="col-sm-12 table-responsive card-body" id="tabelaClientesForne">
              <h5>Lista de Clientes</h5>
              <table id="tabelaClientes" class="table table-sm table-select table-hover" width="100%">
                <thead>
                  <tr>
                    <th class="th-sm">Cliente
                    </th>
                    <th class="th-sm">Nome
                    </th>
                    <th class="th-sm">Fantasia
                    </th>
                    <th class="th-sm">CPF/CNPJ
                    </th>
                    <th class="th-sm">Ativo
                    </th>
                  </tr>
                </thead>
                <tbody>

                </tbody>
              </table>
            </div>
          </div>
        </div>
        <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
          <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content" id="modalBody">
              <div class="modal-header">
                <h4 class="modal-title">Filtros</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">

                <div class="row">
                  <div class="col-sm-12 col-lg-12">
                    <label data-error="wrong" class="labelGeral" data-success="right" for="txtCliente">Cliente</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button">
                          <i class="m-0 p-0 fas fa-search"></i>
                        </button>
                        <button class="btn bg-danger" id="btnACliente" type="button">
                          <i class="m-0 p-0 fas fa-trash"></i>
                        </button>
                      </div>
                    </div>
                  </div>

                  <div class="col-sm-12 col-lg-12" style="margin-top: 5px;">
                    <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtGrupo">Grupo de cliente:</label>
                    <div class="relative" style="margin-top: 5px;">
                      <div class="input-group">
                        <input type="text" class="input-default focus form-control" id="txtGrupo" name="txtGrupo" class="form-control" placeholder="Grupo de cliente:">
                        <div class="input-group-append">
                          <button class="btn bg-danger" id="btn-grupo-filtro" name="btn-grupo-filtro" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                          <button class="btn bg-danger" id="btn-limpa-grupo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>

                <div class="row" style="margin-top: 1.4%;">
                  <div class="col-sm-12 col-lg-6">
                    <div class="group-default form-group">
                      <label for="dtEmiIni">Data Cadastro De: </label>
                      <div class="relative">
                        <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataDe" name="DataDe">
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-12 col-lg-6">
                    <div class="group-default form-group">
                      <label for="dtEmifim">Até: </label>
                      <div class="relative">
                        <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataAte" name="DataAte">
                      </div>
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-sm-12 col-lg-6">
                    <div class="group-default form-group">
                      <label for="txtDataAniverDe">Data Nascimento De: </label>
                      <div class="relative">
                        <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataAniverDe" name="txtDataAniverDe">
                      </div>
                    </div>
                  </div>
                  <div class="col-sm-12 col-lg-6">
                    <div class="group-default form-group">
                      <label for="txtDataAniverAte">Até: </label>
                      <div class="relative">
                        <input type="date" max="2500-12-31" value="2500-12-01" class="input-default focus form-control validate" id="txtDataAniverAte" name="txtDataAniverAte">
                      </div>
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="group-default form-group col-sm-12 col-lg-6">
                    <label for="">Ativo: </label>
                    <div class="relative">
                      <select name="" id="txtAtivo" value="" class="form-group input-default">
                        <option value="">Todos</option>
                        <option value="S">Sim</option>
                        <option value="N">Não</option>
                      </select>
                    </div>
                  </div>
                  <div class="group-default form-group col-sm-12 col-lg-6">
                    <label for="">Bloqueado: </label>
                    <div class="relative">
                      <select name="" id="txtBloqueado" value="" class="form-group input-default">
                        <option value="">Todos</option>
                        <option value="S">Sim</option>
                        <option value="N">Não</option>
                      </select>
                    </div>
                  </div>
                </div>
              </div>

              <div class="modal-footer">
                <div class="row">
                  <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar
                    Filtros</button>     
                  <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span>
                    Consultar</button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <?php
  include_once('../../../footer.php');
  include_once('../../../modals/modal_anexos.html');
  ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->
  <script src="plugins/jquery/jquery.min.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.237.17.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.237.17.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.237.17.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.237.17.1"></script>
  <script src="dist/js/sisplan.js?versao=3.237.17.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.237.17.1"></script>
  <script src="utils/cookies.js?versao=3.237.17.1"></script>
  <script src="utils/funcoes.js?versao=3.237.17.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.237.17.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.237.17.1"></script>
  <script src="dist/js/driver.min.js?versao=3.237.17.1"></script>
  <script src="plugins/moment/moment.min.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="config.js?versao=3.237.17.1"></script>
  <script type="text/javascript" src="modals/modal_anexos.js?versao=3.237.17.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('ENTIDADE');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/cliente/acesso_cliente/acesso_cliente.js?versao=3.237.17.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>