$('#tutorial').on('click', function () {
  $('#geral-tab').trigger('click');
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      onHighlightStarted: (Element) => {
        if (Element.node.id == 'geral') {
          if (!$('#DadosGerais').hasClass('show'));
          $('#DadosGerais').collapse('show');
        }
      },
    });

    driver.defineSteps([{
      element: '#txtNumero',
      popover: {
        title: 'Número do Pedido',
        description: 'Aqui consta o número do pedido, caso seja uma inclusão o número inserido irá ser consultado.',
        position: 'top'
      }
    },
    {
      element: '#DadosGerais',
      popover: {
        title: 'Dados e Ações do Cancelamento',
        description: 'Esses são os campos que você irá preencher para realizar a gravação do cancelamento do pedido.',
        position: 'bottom'
      }
    },
    {
      element: '#cbBaixarEstoque',
      popover: {
        title: 'Baixar Estoque',
        description: 'Ao ser selecionado, irá baixar o estoque de toda a quantidade que está sendo cancelada e/ou faturada.',
        position: 'bottom'
      }
    },
    {
      element: '#cbExcluirReserva',
      popover: {
        title: 'Excluir Reserva',
        description: 'Ao ser selecionado, irá excluir toda a quantidade em expedição reserva.',
        position: 'bottom'
      }
    },
    {
      element: '#cbVoltaExpedicao',
      popover: {
        title: 'Volta Expedição',
        description: 'Ao ser selecionado, voltará toda a quantidade em expedição.',
        position: 'bottom'
      }
    },
    {
      element: '#opcoesQtde',
      popover: {
        title: 'Opções',
        description: 'Aqui existem algumas opções para manipular as quantidades de cancelamento e faturamento desse pedido.',
        position: 'bottom'
      }
    },
    {
      element: '#cbCancelarTotal',
      popover: {
        title: 'Cancelamento Total das Quantidades',
        description: 'Está primeira opção ao ser selecionada, passa para cancelado toda a quantidade pendente do grid.',
        position: 'bottom'
      }
    },
    {
      element: '#cbFatTotal',
      popover: {
        title: 'Faturamento Total das Quantidades',
        description: 'Está segunda opção ao ser selecionada, passa para faturada toda a quantidade pendente do grid.',
        position: 'bottom'
      }
    },
    {
      element: '#cbFatExpedicao',
      popover: {
        title: 'Faturamento Total das Quantidades',
        description: 'Está terceira opção ao ser selecionada, passa para faturada toda a quantidade pendente em expedição do grid.',
        position: 'bottom'
      }
    },
    {
      element: "#btnVoltar",
      popover: {
        title: "Botão Voltar",
        description:
          "Ao clicar nesse botão você retorna para a tela de consulta.",
        position: "left",
      },
    },
    {
      element: '#btnGravar',
      popover: {
        title: 'Botão Gravar',
        description: 'Ao clicar nesse botão você grava os dados inseridos.',
        position: 'left'
      }
    }
    ]);

    driver.start();
  });
});


$(document).ready(async function () {
  // linhaC = 1; 
  $('#txtCliente').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtGrupoProd').autocompleta(1, `JSON={ "tabela":"GRUPO_PA", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtMarca').autocompleta(1, `JSON={ "tabela":"MARCA", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtMotivo').autocompleta(1, `JSON={ "tabela":"MENSAGEM", "camposSelect":["CODMEN CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $("#txtDeposito").autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtTipoMvto').autocompleta(1, `JSON={ "tabela":"TABBAI", "camposSelect":["COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtQualidade').autocompleta(1, `JSON={ "tabela":"TABQUL", "camposSelect":["CODIGO CODIGO", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtEtiqueta').autocompleta(1, `JSON={ "tabela":"ETQ_PROD", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

  // $('#btnCliente').pesquisa_serverside(['#txtCliente'], ['CODCLI'], ['NOME'], `{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}`, 'Pesquisa de Cliente');
  $('#btnCliente').pesquisa_serverside(['#txtCliente'], ['CODCLI'], ['NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa Cliente');
  $('#btnGrupoProd').pesquisa('#txtGrupoProd', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Grupo Produto', 'GRUPO_PA');
  $('#btnMarca').pesquisa('#txtMarca', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MARCA", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Marca', 'MARCA');
  $('#btnMotivo').pesquisa('#txtMotivo', 'CODMEN', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO"]}`, 'Pesquisa Motivo', 'MENSAGEM');
  $("#btnDeposito").pesquisa("#txtDeposito", "CODIGO", "DESCRICAO", `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, "Pesquisa Depósito", "DEPOSITO");
  $('#btnTipoMvto').pesquisa('#txtTipoMvto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Colecao', 'COLECAO');
  $('#btnQualidade').pesquisa('#txtQualidade', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABQUL", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Cor', 'CADCOR');
  $('#btnEtiqueta').pesquisa('#txtEtiqueta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"ETQ_PROD", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Etiqueta', 'ETQ_PROD');


  $('#btnLimpaCliente').on('click', function () {
    $('#txtCliente').val('');
  });

  $('#btnLimpaDeposito').on('click', function () {
    $('#txtDeposito').val('');
  });

  $('#btnLimpaMotivo').on('click', function () {
    $('#txtMotivo').val('');
  });

  $('#btnLimpaTipoMvto').on('click', function () {
    $('#txtTipoMvto').val('');
  });

  $('#btnLimpaQualidade').on('click', function () {
    $('#txtQualidade').val('');
  });

  $('#btnLimpaEtiqueta').on('click', function () {
    $('#txtEtiqueta').val('');
  });

  let queryString = window.location.href;
  let parametros = queryString.split('/');
  let pedido = parametros[parametros.length - 1];

  $('#tabelaPedido').DataTable({
    paging: false,
    filter: false,
    info: false,
    order: true,
    destroy: true,
    "language": {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "_TOTAL_ registros",
      "sInfoEmpty": " 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    }
  });

  if (pedido == 'create') {
    $('#txtNumero').on('blur', async function () {
      let data = await buscaDadosPedidos($('#txtNumero').val());
      await insereDados(data);
    });
  }

  if (pedido != '' && pedido != 'create') {
    $('#txtNumero').val(pedido);
    try {
      $.LoadingOverlay("show");
      try {
        let data = await buscaDadosPedidos(pedido);
        // let reserva = await buscaQuantidadeReservada(data);
        await insereDados(data)
      } catch (error) {
        console.error(error);
        msgErro(`Não foi possível buscar os dados do tamanho: ${error}`);
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  async function insereDados(data) {
    data.RESULT[0].map(item => {
      let linha = $('#tabelaPedido').DataTable().data().toArray().length > 0 ? $('#tabelaPedido').DataTable().data().toArray().length : 0;
      $('#tabelaPedido').DataTable().row.add([
        item.CODIGO,
        item.DESC_PRODUTO,
        item.COR,
        item.DESC_COR,
        item.TAM,
        item.QTDE_ORIG,
        item.QTDE,
        `<input id="txtCancelar_${linha}" type="number" class="inputTable inputsCancelar focus input-default form-control">`,
        `<input id="txtFaturada_${linha}" type="number" class="inputTable inputsFaturada focus input-default form-control">`,
        item.QTDE_CANC,
        item.QTDE_F,
        item.ID_ITEM_PED,
        item.ORDEM,
        item.RESERVADA,
        item.QTDE_RES_B,
        item.QUALIDADE,
        item.TIPO
      ]).draw(false);
    });
  }

  $('#cbCancelarTotal').on('click', function () {
    $(`.inputsFaturada`).val('');
    for (let i = 0; i < $('#tabelaPedido').DataTable().data().length; i++) {
      $(`#txtCancelar_${i}`).val($('#tabelaPedido').DataTable().data()[i][6])
    }
  });

  $('#cbFatTotal').on('click', function () {
    $(`.inputsCancelar`).val('');
    for (let i = 0; i < $('#tabelaPedido').DataTable().data().length; i++) {
      $(`#txtFaturada_${i}`).val($('#tabelaPedido').DataTable().data()[i][6])
    }
  });

  $("#msform").validate({
    async submitHandler(form, event) {
      event.preventDefault();
      try {
        $.LoadingOverlay("show");
        try {
          if ($('#txtTipoMotivo').val() == '' && ('#cbBaixar').isChecked()) {
            throw msgAlerta('Tipo de Movimento deve ser informado!');
          }
          if ($('#txtDeposito').val() == '' && ('#cbBaixar').isChecked()) {
            throw msgAlerta('Tipo de Movimento deve ser informado!');
          }

          let body = {
            NUMERO: $('#txtNumero').val(),
            NOTAFISCAL: $('#txtNotaFiscal').val(),
            PED_CLIENTE: $('#txtPedCliente').val(),
            CODIGO: $('#txtCodigo').val(),
            CLIENTE: $('#txtCliente').val(),
            DEPOSITO: $('#txtDeposito').val(),
            GRUPO_PROD: $('#txtGrupoProd').val(),
            MARCA: $('#txtMarca').val(),
            MOTIVO: $('#txtMotivo').val(),
            TIPO_MOTIVO: $('#txtTipoMotivo').val(),
            QUALIDADE: $('#txtQualidade').val(),
            ETIQUETA: $('#txtEtiqueta').val(),
            BARRA: $('#txtBarra').val(),
            BAIXAR_ESTOQUE: $('#cbBaixarEstoque').isChecked() ? 'S' : 'N',
            GERAR_RECEBER: $('#cbGerarReceber').isChecked() ? 'S' : 'N',
            IMPRE_CONFIG: $('#cbImpressaoConfigurada').isChecked() ? 'S' : 'N',
            EXCLUIR_RESERVA: $('#cbExcluirReserva').isChecked() ? 'S' : 'N',
            SOMENTE_QTDE_PEND: $('#cbSomenteQtdePendente').isChecked() ? 'S' : 'N',
            VOLTA_EXP: $('#cbVoltaExpedicao').isChecked() ? 'S' : 'N',
            CANC_TOTAL: $('#cbCancelarTotal').isChecked() ? 'S' : 'N',
            FAT_TOTAL: $('#cbFatTotal').isChecked() ? 'S' : 'N',
            ControlePedIten: buscaDadosTabela(),
          };

          const response = await requisicao('POST', `/sisplan/cancelamento/V1/cancelamento?`, '', `JSON=${JSON.stringify(body)}&NUMERO=${embarque}`, 90000);

          if (!response) {
            return;
          }

          let jsonStr = await response.json();
          if (response.status != 200) {
            msgAlerta(jsonStr.mensagem);
            return;
          }

          toastr
            .success("Cadastro efetuado com sucesso!", "Confirmação", {
              toastClass: "alert",
              iconClasses: {
                error: "alert-error",
                info: "alert-info",
                success: "alert-success",
                warning: "alert-warning",
              },
              positionClass: "toast-top-center",
              progressBar: true,
              timeOut: 3000,
              fadeOut: 1000,
              onHidden() {
                window.location.href = `${BASE_URI}/cancelamento_pedido`;
              },
            })
            .css({
              "margin-top": "20%",
              width: "500px",
              "max-width": "500px",
            });
        } catch (error) {
          console.error(error);
        }

      } finally {
        $.LoadingOverlay("hide");
      }
    },
  });

  function buscaDadosTabela() {
    let arr = [];
    i = 1;
    $('#tabelaPedido').DataTable().rows().data().map(item => {
      arr.push({
        QTDE_CANC: $(`#txtCancelar_${i}`).val(),
        QTDE_F: $(`#txtFaturada_${i}`).val(),
      })
      i++
    });
    return arr;
  };

  async function buscaDadosPedidos(pedido) {
    const whereCompleto = await montaWherePesquisa(pedido);
    const ligacaoCompleta = await montaLigacoesPesquisa();
    const camposCompleto = await montaCamposSelect();

    let dataSetCols = [];

    try {
      try {
        $.LoadingOverlay("show");

        for (let i = 0; i < camposCompleto.colunas.length; i++) {
          dataSetCols.push({
            'title': camposCompleto.colunas[i],
            'data': i
          });
        }

        let response = await requisicao(
          'GET', `/sisplan/funcoes/v1/pesquisa?`, `JSON={"tabela":"PED_ITEN", "camposSelect":${camposCompleto.camposSelect}, "leftjoin": [${ligacaoCompleta}], "where": ["1=1 ${whereCompleto}"]}`, 15000);

        if (!response) {
          return;
        }

        let jsonStr = await response.json();

        return jsonStr;

      } catch (error) {
        console.error(error);
        msgErro('Não foi possível buscar os dados.');
      }
    } finally {
      $.LoadingOverlay("hide");
      $('#modal-filtros').modal('hide');
    }
  };

  async function montaWherePesquisa(pedido) {
    let where = '';
    // AND PED_ITEN.CODIGO = '2001008'
    where += pedido != '' ? ` AND PED_ITEN.NUMERO = '${pedido}'` : '';
    // where += $('#txtCodigo').val() != '' ? ` AND PED_ITEN.CODIGO = '${$('#txtCodigo').val()}'` : '';
    where += ` AND (PED_ITEN.QTDE [SOMA] PED_ITEN.QTDE_CANC [SOMA] [SOMA] PED_ITEN.QTDE_F) > 0`;
    return where;
  }

  async function montaLigacoesPesquisa() {
    let ligacao = `{"tabela": "PEDIDO", "condicao": "(PED_ITEN.NUMERO = PEDIDO.NUMERO)"},` +
      `{"tabela": "MATERIAL", "condicao": "(PED_ITEN.CODIGO = MATERIAL.CODIGO)"},` +
      `{"tabela": "CADCOR", "condicao": "(PED_ITEN.COR = CADCOR.COR)"},` +
      `{"tabela": "COLECAO", "condicao": "(PEDIDO.COLECAO = COLECAO.CODIGO)"},` +
      `{"tabela": "TIPO", "condicao": "(TIPO.ID_TIPO = PEDIDO.ID_TIPO)"},` +
      `{"tabela": "PRODUTO", "condicao": "(PED_ITEN.CODIGO = PRODUTO.CODIGO)"},` +
      `{"tabela": "(SELECT CODIGO, COR, TAM, MIN(LOTE) LOTE, MAX(BARRA) BARRA FROM [PA_ITEN] GROUP BY CODIGO, COR, TAM)",
        "tabelaSelect": "(SELECT CODIGO, COR, TAM, MIN(LOTE) LOTE, MAX(BARRA) BARRA FROM [PA_ITEN] GROUP BY CODIGO, COR, TAM)",
        "condicao": "(PA.CODIGO = PED_ITEN.CODIGO AND PA.COR = PED_ITEN.COR AND PA.TAM = PED_ITEN.TAM)",
        "alias": "PA"},` +

      `{"tabela": "(SELECT PROG_COMPRA.CODIGO, PROG_COMPRA.COR, PROG_COMPRA.TAM, SUM(PROG_COMPRA.QUANTIDADE) QTDE FROM [PROG_COMPRA] PROG_COMPRA 
                    INNER JOIN [TABPRZ] TABPRZ ON (TABPRZ.PRAZO = PROG_COMPRA.PERIODO) WHERE TABPRZ.ATIVO_PRODUCAO = 'S' GROUP BY PROG_COMPRA.CODIGO, PROG_COMPRA.COR, PROG_COMPRA.TAM)",
        "tabelaSelect": "(SELECT PROG_COMPRA.CODIGO, PROG_COMPRA.COR, PROG_COMPRA.TAM, SUM(PROG_COMPRA.QUANTIDADE) QTDE FROM [PROG_COMPRA] PROG_COMPRA 
                          INNER JOIN [TABPRZ] TABPRZ ON (TABPRZ.PRAZO = PROG_COMPRA.PERIODO) WHERE TABPRZ.ATIVO_PRODUCAO = 'S' GROUP BY PROG_COMPRA.CODIGO, PROG_COMPRA.COR, PROG_COMPRA.TAM)",
        "condicao": "(PROG_COMPRA.CODIGO = PED_ITEN.CODIGO AND PROG_COMPRA.COR = PED_ITEN.COR AND PROG_COMPRA.TAM = PED_ITEN.TAM)",
        "alias" : "PROG_COMPRA"},`+

      `{"tabela": "(SELECT PED_ITEN.CODIGO, PED_ITEN.COR, PED_ITEN.TAM, SUM(PED_ITEN.QTDE + PED_ITEN.QTDE_F) QTDE FROM [PED_ITEN] PED_ITEN GROUP BY PED_ITEN.CODIGO, PED_ITEN.COR, PED_ITEN.TAM)",
        "tabelaSelect":"(SELECT PED_ITEN.CODIGO, PED_ITEN.COR, PED_ITEN.TAM, SUM(PED_ITEN.QTDE [SOMA] PED_ITEN.QTDE_F) QTDE FROM [PED_ITEN] PED_ITEN GROUP BY PED_ITEN.CODIGO, PED_ITEN.COR, PED_ITEN.TAM)",
        "condicao": "(PEDTOTAL.CODIGO = PED_ITEN.CODIGO AND PEDTOTAL.COR = PED_ITEN.COR AND PEDTOTAL.TAM = PED_ITEN.TAM)",
        "alias": "PEDTOTAL"}`;

    return ligacao;
  }

  async function montaCamposSelect() {
    let camposSelect = [];
    let colunas = [];

    camposSelect = `["PED_ITEN.CODIGO", "PRODUTO.DESCRICAO DESC_PRODUTO", "MATERIAL.DESCRICAO DESC_MAT" ,"PED_ITEN.COR" ,"PED_ITEN.TAM" ,"PED_ITEN.TIPO"
      ,"PED_ITEN.QTDE", "PED_ITEN.QTDE_F", "PED_ITEN.QTDE_CANC", "PED_ITEN.PRECO", "PEDIDO.TAB_PRE", "PEDIDO.CODREP", "PED_ITEN.ORDEM", "PED_ITEN.QUALIDADE"
      ,"CADCOR.DESCRICAO DESC_COR", "PA.BARRA AS PA_BARRA", "(PED_ITEN.PRECO - ((PED_ITEN.PRECO*PEDIDO.PER_DESC)/100)) as PRECOLIQ", "PED_ITEN.PROGRAMADO"
      ,"PED_ITEN.QTDE_F", "PED_ITEN.QTDE_ORIG", "PRODUTO.CODIGO2", "PED_ITEN.ID_ITEM_PED", "PEDIDO.COLECAO", "COLECAO.DESCRICAO DESC_COLECAO", "PEDIDO.ID_TIPO"
      ,"TIPO.DESCRICAO DESC_TIPO", "PROG_COMPRA.QTDE QTDE_PROJ", "PEDTOTAL.QTDE TOTAL_PED", "'000000' LOTE"]`;

    colunas = ["CODIGO", "DESC_PRODUTO", "COR", "DESC_COR", "TAM", "QTDE_ORIG", "QTDE", "CANCELADA", "FATURADA", "QTDE_CANC", "QTDE_F"];

    return objeto = {
      camposSelect: camposSelect,
      colunas: colunas
    };
  }

  $('#btnVoltar').on('click', async function () {
    await deletaRegistro('CANCELAMENTO_PEDIDO', getCookie('usuario'), parametros[5]);
    window.location.href = `${BASE_URI}/cancelamento_pedido`;
  });

  $('#btnVoltarFaturado').on('click', async function () {
    if (($('#txtDeposito').val() != '') && ($('#cbBaixarEstoque').is(':checked'))) {
      throw msgAlerta('Depósito precisa ser informado, verifique!');
    }

    if (($('#txtTipoMvto').val()) != '' && ($('#cbBaixarEstoque').is(':checked'))) {
      throw msgAlerta('Tipo motivo precisa ser informado, verifique!');
    }
    await msgAlerta(
      'Deseja voltar as quantidades faturadas?',
      async function () {
        await voltarQuantidadeFat();
      },
      async function () {
        () => { }
      }
    );
  });

  async function voltarQuantidadeFat() {
    try {
      $.LoadingOverlay('show');
      const ListaItensPedido = buscaDadosTabela();
      const params = buscaParams();

      let objeto = { ListaItensPedido };
      let response = await requisicao('POST', `/sisplan/cancelamentopedido/v1/voltarfaturado?`, '', `JSON=${JSON.stringify(objeto)}${params}`, 15000);

      if (!response) {
        return;
      }

      toastr.success(
        `Voltado quantidades faturadas!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/cancelamento_pedido`;
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });

    } catch (err) {
      console.log(err)
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  async function voltarQuantidadeCanc() {
    try {
      $.LoadingOverlay('show');
      const ListaItensPedido = buscaDadosTabela();
      const params = buscaParams();

      let objeto = { ListaItensPedido };
      let response = await requisicao('POST', `/sisplan/cancelamentopedido/v1/voltarcancelado?`, '', `JSON=${JSON.stringify(objeto)}${params}`, 15000);

      if (!response) {
        return;
      }

      toastr.success(
        `Voltado quantidades faturadas!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/cancelamento_pedido`;
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });

    } catch (err) {
      console.log(err)
    } finally {
      $.LoadingOverlay('hide');
    }
  }

  function buscaDadosTabela() {
    const tabela = $('#tabelaPedido').DataTable().rows().data().toArray();
    let listaItensPedido = tabela.map((item, i) => {
      return {
        CODIGO: item[0],
        COR: item[2],
        TAM: item[4],
        QTDE_ORIG: item[5],
        QTDE: item[6],
        CANCELADA: $(`#txtCancelar_${i}`).val(),
        FATURADA: $(`#txtFaturada_${i}`).val(),
        QTDE_CANC: item[9],
        QTDE_F: item[10],
        ID_ITEM_PED: item[11],
        ORDEM: item[12],
        QUALIDADE: item[15],
        TIPO: item[16]
      };
    });
    return listaItensPedido;
  }

  function buscaParams() {
    //CHECKBOX
    let sBaixar_estoque = $('#cbBaixarEstoque').is(':checked') ? 'S' : 'N';
    let sGerar_receber = $('#cbGerarReceber').is(':checked') ? 'S' : 'N';
    let sImpConfigurada = $('#cbImpressaoConfigurada').is(':checked') ? 'S' : 'N';
    let sExcluirReserva = $('#cbExcluirReserva').is(':checked') ? 'S' : 'N';
    let sSomenteQtdePendente = $('#cbSomenteQtdePendente').is(':checked') ? 'S' : 'N';
    let sVoltaExpedicao = $('#cbVoltaExpedicao').is(':checked') ? 'S' : 'N';
    let sUtiliza_barra = $('#cbUtilizaBarra').is(':checked') ? 'S' : 'N';
    //RADIO
    let sCancelarTotal = $('#cbCancelarTotal').is(':checked') ? 'S' : 'N';
    let sFaturarTotal = $('#cbFatTotal').is(':checked') ? 'S' : 'N';
    let sFaturarExpedicao = $('#cbFatExpedicao').is(':checked') ? 'S' : 'N';
    //CAMPOS    
    let sNumero = $('#txtNumero').val();
    let sNotaFiscal = $('#txtNotaFiscal').val();
    let sPedCliente = $('#txtPedCliente').val();
    let sCodigo = $('#txtCodigo').val();
    let sCliente = pegaChave('#txtCliente');
    let sDeposito = pegaChave('#txtDeposito');
    let sGrupoProd = pegaChave('#txtGrupoProd');
    let sMarca = pegaChave('#txtMarca');
    let sMotivo = pegaChave('#txtMotivo');
    let sTipoMvto = pegaChave('#txtTipoMvto');
    let sQualidade = pegaChave('#txtQualidade');
    let sEtiqueta = pegaChave('#txtEtiqueta');
    let sBarra = $('#txtBarra').val();
    let sObs = $('#txtObs').val();
    //TOTALIZADORES
    let sValorLiq = $('#txtValorTotalLiq').val()

    let retorno =
      `&EMP_ID=${getCookie('emp_id')}` +
      //CHECKBOX
      `&BAIXAR_ESTOQUE=${sBaixar_estoque}` +
      `&GERAR_RECEBER=${sGerar_receber}` +
      `&IMP_CONFIGURADA=${sImpConfigurada}` +
      `&EXCLUI_RESERVA=${sExcluirReserva}` +
      `&SOMENTE_QTDE_PENDENTE=${sSomenteQtdePendente}` +
      `&VOLTAR_EXPEDICAO=${sVoltaExpedicao}` +
      `&UTILIZA_BARRA=${sUtiliza_barra}` +
      //RADIO
      `&CANCELAR_TOTAL=${sCancelarTotal}` +
      `&FATURAR_TOTAL=${sFaturarTotal}` +
      `&FATURAR_EXPEDICAO=${sFaturarExpedicao}` +
      //CAMPOS
      `&NUMERO=${sNumero}` +
      `&NOTA_FISCAL=${sNotaFiscal}` +
      `&PED_CLIENTE=${sPedCliente}` +
      `&CODIGO=${sCodigo}` +
      `&CODCLI=${sCliente}` +
      `&DEPOSITO=${sDeposito}` +
      `&GRUPO_PRODUTO=${sGrupoProd}` +
      `&MARCA=${sMarca}` +
      `&MOTIVO=${sMotivo}` +
      `&TIPO_MVTO=${sTipoMvto}` +
      `&QUALIDADE=${sQualidade}` +
      `&ETIQUETA=${sEtiqueta}` +
      `&BARRA=${sBarra}` +
      `&OBS=${sObs}` +
      //TOTALIZADORES
      `&VALOR_LIQUIDO=${sValorLiq}`;

    return retorno;
  };

  $('#btnVoltarCancelado').on('click', async function () {
    await msgAlerta(
      'Deseja voltar as quantidades canceladas?',
      async function () {
        await voltarQuantidadeCanc();
      },
      async function () {
        () => { }
      }
    );
  });

  $('#btnGravar').on('click', async function () {
    try {
      validacoesGravar();

      const ListaItensPedido = buscaDadosTabela();
      const params = buscaParams();

      let objeto = { ListaItensPedido };
      let response = await requisicao('POST', `/sisplan/cancelamentopedido/v1/gravar?`, '', `JSON=${JSON.stringify(objeto)}${params}`, 15000);

      if (!response) {
        return;
      };

      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return;
      }

      toastr.success(
        `Cadastro efetuado com sucesso!`,
        'Confirmação', {
        toastClass: 'alert',
        iconClasses: {
          error: 'alert-error',
          info: 'alert-info',
          success: 'alert-success',
          warning: 'alert-warning'
        },
        positionClass: "toast-top-center",
        progressBar: true,
        timeOut: 3000,
        fadeOut: 1000,
        onHidden() {
          window.location.href = `${BASE_URI}/cancelamento_pedido`;
        }
      }
      ).css({
        "margin-top": "20%",
        "width": "500px",
        "max-width": "500px"
      });

    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  function validacoesGravar() {
    if (!$('#txtDeposito').val() && $('#cbBaixarEstoque').is(':checked')) {
      throw msgAlerta('Código do depóstio deve ser informado, verifique!');
    }

    if (!$('#txtTipoMvto').val() && $('#cbBaixarEstoque').is(':checked')) {
      throw msgAlerta('Tipo de movimento deve ser informado!');
    }

    if (!$('#txtMotivo').val()) {
      throw msgAlerta('Necessário inserir um motivo, verifique!');
    }
  }
});