<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Cancelamento de Pedido</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.232.21.1">

  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.232.21.1">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.232.21.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.232.21.1">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.232.21.1">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.232.21.1">
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.232.21.1">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.232.21.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.232.21.1">
  <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet">
</head>

<style>
  .border-Field .textoBorda {
    font-size: 1.1em !important;
    text-align: left !important;
    width: auto;
    padding: 0 10px;
    border-bottom: none;
  }

  .border-Field {
    border: 1px solid #fff !important;
    padding: 0 1.0em 0 1.0em !important;
    margin: 0 0 1.0em 0 !important;
    border-radius: 5px;
    -webkit-box-shadow: 0px 0px 0px 0px #000;
    box-shadow: 0px 0px 0px 0px #000;
  }

</style>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <?php include_once('../../../menu.php'); ?>

    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Cancelamento de Pedido</h1>
              <button title="Tutorial" type="button" class="btn btn-info btn-sm ml-2" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="index">Início</a></li>
                <li class="breadcrumb-item active">Acesso Cancelamento</li>
                <p id="date1"></p>
              </ol>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <fieldset>
                <div class="row card">
                  <div class="col-sm-12 mt-3">
                    <button class="btn btn-success btn-sisp" id="btnFiltros" type="button"><span class="fas fa-filter"></span> Filtros</button>
                    <button class="btn btn-danger btn-sisp" id="btnNovoCancelamento"><span class="fas fa-plus"></span> Incluir</button>
                  </div>
                  <div class="card-body">
                    <div class="col-sm-12 table-responsive card-body" id="tutTabelaPedido">
                      <h5>Lista de Pedidos</h5>
                      <table id="tabelaPedido" class="table table-sm table-select table-hover" width="100%">
                        <thead>
                          <tr>
                            <th class="th-sm">NUMERO
                            </th>
                            <th class="th-sm">CODCLI
                            </th>
                            <th class="th-sm">NOME_CLIENTE
                            </th>
                            <th class="th-sm">CODREP
                            </th>
                            <th class="th-sm">NOME_REPRESEN
                            </th>
                            <th class="th-sm">QTDE
                            </th>
                            <th class="th-sm">QTDE_CANC
                            </th>
                            <th class="th-sm">VALOR_CANC
                            </th>
                            <th class="th-sm">VALOR_FAT
                            </th>
                            <th class="th-sm">QTDE_FAT
                            </th>
                          </tr>
                        </thead>
                        <tbody>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
              </fieldset>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-xl" role="document">
      <div class="modal-content" id="modalBody">
        <div class="modal-header">
          <h4 class="modal-title">Filtros</h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <div class="row">
            <div class="col-md-12 col-12 form" id="tipos">
              <fieldset class="form border-Field mb-0 pb-0">
                <legend class="textoBorda mb-0 pb-0">Opções</legend>
                <div class="form-row ml-2">
                  <div class="form-group form-check">
                    <input type="checkbox" class="form-check-input" id="cbMotivoCancelamento">
                    <label class="form-check-label pr-4" for="cbMotivoCancelamento">Motivo de Cancelamento</label>
                  </div>
                  <!-- <div class="form-group form-check">
                    <input type="checkbox" class="form-check-input" id="cbCancelarTotal">
                    <label class="form-check-label pr-4" for="cbCancelarTotal">Cancelar Total</label>
                  </div> -->
                  <div class="form-group form-check">
                    <input type="checkbox" class="form-check-input" id="cbFaturamentoParcial">
                    <label class="form-check-label pr-4" for="cbFaturamentoParcial">Pedidos c/ Faturamento Parcial</label>
                  </div>
                  <div class="form-group form-check">
                    <input type="checkbox" class="form-check-input" id="cbSomenteQtdePendente">
                    <label class="form-check-label pr-4" for="cbSomenteQtdePendente">Somente Qtde Pendente</label>
                  </div>
                </div>
              </fieldset>
            </div>
            <div class="col-4">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtRegra">Cancelamento De/ Até:</label>
              <div class="input-group">
                <input type="date" class="input-default focus form-control" id="dtCancalamentoDe" value="1200-01-01" name="dtCancalamentoDe" class="form-control">
                <input type="date" class="input-default focus form-control" id="dtCancelamentoAte" value="2500-12-31" name="dtCancelamentoAte" class="form-control">
              </div>
            </div>
            <div class="col-4 col-lg-4">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtPedido">Pedido:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtPedido" name="txtPedido" class="form-control" placeholder="Pedido">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnPedido" name="btnPedido" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaPedido" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-4 col-lg-4">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCliente">Cliente:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtCliente" name="txtCliente" class="form-control" placeholder="Cliente">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnCliente" name="btnCliente" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaCliente" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-4 col-lg-4">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtRepresentante">Representante:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtRepresentante" name="txtRepresentante" class="form-control" placeholder="Representante">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnRepresentante" name="btnRepresentante" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaRepresentante" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-4 col-lg-4">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtMotivo">Motivo/ Filtro:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtMotivo" name="txtMotivo" class="form-control" placeholder="Motivo/ Filtro">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnMotivo" name="btnMotivo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaMotivo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-4 col-lg-4">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtReserva">Reserva:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtReserva" name="txtReserva" class="form-control" placeholder="Reserva">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnReserva" name="btnReserva" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaReserva" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-4 col-lg-4">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtColecao">Coleção:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtColecao" name="txtColecao" class="form-control" placeholder="Coleção">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnColecao" name="btnColecao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaColecao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <!-- <div class="col-4 col-lg-4">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtEtiqueta">Etiqueta:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtEtiqueta" name="txtEtiqueta" class="form-control" placeholder="Etiqueta">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnEtiqueta" name="btnEtiqueta" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaEtiqueta" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div> -->
            <!-- <div class="col-4 col-lg-4">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtCor">Cor:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtCor" name="txtCor" class="form-control" placeholder="Cor">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnCor" name="btnCor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaCor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div> -->
            <!-- <div class="col-4 col-lg-4">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtTamanho">Tamanho:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtTamanho" name="txtTamanho" class="form-control" placeholder="Tamanho">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnTamanho" name="btnTamanho" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaTamanho" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div> -->
            <!-- <div class="col-4 col-lg-4">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtMotivoGrava">Motivo Grava:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtMotivoGrava" name="txtMotivoGrava" class="form-control" placeholder="Motivo Grava">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnMotivoGrava" name="btnMotivoGrava" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaMotivoGrava" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div> -->
            <div class="col-4 col-lg-4">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtProduto">Produto:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtProduto" name="txtProduto" class="form-control" placeholder="Produto">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnProduto" name="btnProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-4 col-lg-4">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtGrupoProduto">Grupo Produto:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtGrupoProduto" name="txtGrupoProduto" class="form-control" placeholder="Grupo Produto">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnGrupoProduto" name="btnGrupoProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaGrupoProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="col-4 col-lg-4">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtProgramacao">Programação:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtProgramacao" name="txtProgramacao" class="form-control" placeholder="Programação">
                <div class="input-group-append">
                  <button class="btn bg-danger" id="btnProgramacao" name="btnProgramacao" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                  <button class="btn bg-danger" id="btnLimpaProgramacao" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                </div>
              </div>
            </div>
            <!-- <div class="col-8 col-lg-8">
              <label data-error="wrong" class="labelGeral" data-success="right" for="txtObservacao">Observação:</label>
              <div class="input-group">
                <input type="text" class="input-default focus form-control" id="txtObservacao" name="txtObservacao" class="form-control" placeholder="Observação">
              </div>
            </div> -->
          </div>
        </div>
        <div class="modal-footer">
          <button id="btnLimpaFiltros" class='btn btn-danger btn-sisp' type='button'><span class="fas fa-trash"></span> Limpar Filtros </button>
          <button id="btnConsultar" class='btn btn-primary btn-sisp' type='button'><span class="fas fa-search"></span> Consultar </button>
        </div>
      </div>
    </div>
  </div>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  <?php include_once('../../../footer.php'); ?>
  </div>

  <script src="plugins/jquery/jquery.min.js?versao=3.232.21.1"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.232.21.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.232.21.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.232.21.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.232.21.1"></script>
  <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.232.21.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.232.21.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.232.21.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.232.21.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.232.21.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.232.21.1"></script>
  <script src="plugins/moment/moment.min.js?versao=2.6.8"></script>
  <script src="dist/js/valida_cpf_cnpj.js?versao=3.232.21.1"></script>
  <script src="plugins/jquery-validation/jquery.validate.min.js?versao=3.232.21.1"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.232.21.1"></script>
  <script src="dist/js/sisplan.js?versao=3.232.21.1"></script>
  <script src="utils/funcoes.js?versao=3.232.21.1"></script>
  <script src="utils/cookies.js?versao=3.232.21.1"></script>
  <script src="dist/js/driver.min.js?versao=3.232.21.1"></script>
  <script src="config.js"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;
      sArquivo = `${BASE_URI}/pages/cancelamento_pedido/acesso_cancelamento/acesso_cancelamento.js?versao=3.232.21.1`;
      const nomeTela = ('<?php echo basename(__FILE__) ?>').replace('.php', '');
      // nomeTela
      const temAcesso = await temAcessoTela('CANCELAMENTO_PEDIDO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      await insereJavaScriptPagina(sArquivo);

      habilitaCamposObrigatoriosTela(nomeTela);
    });
  </script>

</body>

</html>