$('#tutorial').on('click', function () {
  $('#geral-tab').trigger('click');
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      onHighlightStarted: (Element) => {
        if (Element.node.id == 'geral') {
          if (!$('#DadosGerais').hasClass('show'));
          $('#DadosGerais').collapse('show');
        }
      },
    });

    driver.defineSteps([{
      element: '#btnFiltros',
      popover: {
        title: 'Filtros',
        description: 'Aqui você pode inserir filtros para fazer a consulta do cancelamento.',
        position: 'bottom'
      }
    },
    {
      element: '#btnNovoCancelamento',
      popover: {
        title: 'Incluir Cancelamento',
        description: 'Ao selecionar esse botão, você será direcionado para a tela de cancelamento de pedido.',
        position: 'bottom'
      }
    },
    {
      element: '#tutTabelaPedido',
      popover: {
        title: 'Tabela de Pedidos',
        description: 'Aqui estão pedidos, é possivel identificar as quantidades canceladas e/ou faturadas.',
        position: 'bottom'
      }
    }
    ]);

    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("CANCELAMENTO_PEDIDO");

  $('#txtPedido').autocompleta(1, `JSON={ "tabela":"PEDIDO", "camposSelect":["NUMERO CHAVE", "DT_EMISSAO DESCRICAO"], "where": null}`);
  $('#txtCliente').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":["CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtRepresentante').autocompleta(1, `JSON={ "tabela":"REPRESEN", "camposSelect":["CODREP CHAVE", "NOME DESCRICAO"], "where": null}`);
  $('#txtMotivo').autocompleta(1, `JSON={ "tabela":"MENSAGEM", "camposSelect":["CODMEN CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtReserva').autocompleta(1, `JSON={ "tabela":"PED_RESERVA", "camposSelect":["NUMERO CHAVE", "CODIGO DESCRICAO"], "where": null}`);
  $('#txtColecao').autocompleta(1, `JSON={ "tabela":"COLECAO", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtEtiqueta').autocompleta(1, `JSON={ "tabela":"ETQ_PROD", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtCor').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":["COR CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtTamanho').autocompleta(1, `JSON={ "tabela":"TABTAM", "camposSelect":["TAM CODIGO", "FAIXA DESCRICAO"], "where": null}`);
  $('#txtMotivoGrava').autocompleta(1, `JSON={ "tabela":"CODMEN", "camposSelect":["CODMEN CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtProduto').autocompleta(1, `JSON={ "tabela":"PRODUTO", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtGrupoProduto').autocompleta(1, `JSON={ "tabela":"GRUPO_PA", "camposSelect":["CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
  $('#txtProgramacao').autocompleta(1, `JSON={ "tabela":"OF1", "camposSelect":["NUMERO CHAVE", "PROGRAMACAO DESCRICAO"], "where": null}`);

  $('#btnPedido').pesquisa('#txtPedido', 'NUMERO', 'DT_EMISSAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"PEDIDO", "camposSelect":[ "NUMERO", "DT_EMISSAO"]}`, 'Pesquisa Pedido', 'PEDIDO');
  $('#btnCliente').pesquisa('#txtCliente', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"]}`, 'Pesquisa Cliente', 'ENTIDADE');
  $('#btnRepresentante').pesquisa('#txtRepresentante', 'CODREP', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REPRESEN", "camposSelect":[ "CODREP", "NOME"]}`, 'Pesquisa Representante', 'REPRESEN');
  $('#btnMotivo').pesquisa('#txtMotivo', 'CODMEN', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO"]}`, 'Pesquisa Motivo', 'MENSAGEM');
  $('#btnReserva').pesquisa('#txtReserva', 'NUMERO', 'CODIGO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"PED_RESERVA", "camposSelect":[ "NUMERO", "CODIGO"]}`, 'Pesquisa Reserva', 'PED_RESERVA');
  $('#btnColecao').pesquisa('#txtColecao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"COLECAO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Colecao', 'COLECAO');
  $('#btnEtiqueta').pesquisa('#txtEtiqueta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"ETQ_PROD", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Etiqueta', 'ETQ_PROD');
  $('#btnCor').pesquisa('#txtCor', 'COR', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO"]}`, 'Pesquisa Cor', 'CADCOR');
  $('#btnTamanho').pesquisa('#txtTamanho', 'TAM', 'FAIXA', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"TABTAM", "camposSelect":[ "TAM", "FAIXA"]}`, 'Pesquisa Tamanho', 'TABTAM');
  $('#btnMotivoGrava').pesquisa('#txtMotivoGrava', 'CODMEN', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"MENSAGEM", "camposSelect":[ "CODMEN", "DESCRICAO"]}`, 'Pesquisa Motivo Grava', 'MENSAGEM');
  $('#btnProduto').pesquisa('#txtProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"PRODUTO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Produto', 'PRODUTO');
  $('#btnGrupoProduto').pesquisa('#txtGrupoProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"GRUPO_PA", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Grupo Produto', 'GRUPO_PA');
  $('#btnProgramacao').pesquisa('#txtProgramacao', 'NUMERO', 'PROGRAMACAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"OF1", "camposSelect":[ "NUMERO", "PROGRAMACAO"]}`, 'Pesquisa Programacao', 'OF1');

  $('#btnLimpaPedido').on('click', function () {
    $('#txtPedido').val('');
  });

  $('#btnLimpaCliente').on('click', function () {
    $('#txtCliente').val('');
  });

  $('#btnLimpaRepresentante').on('click', function () {
    $('#txtRepresentante').val('');
  });

  $('#btnLimpaMotivo').on('click', function () {
    $('#txtMotivo').val('');
  });

  $('#btnLimpaReserva').on('click', function () {
    $('#txtReserva').val('');
  });

  $('#btnLimpaColecao').on('click', function () {
    $('#txtColecao').val('');
  });

  $('#btnLimpaEtiqueta').on('click', function () {
    $('#xtEtiqueta').val('');
  });

  $('#btnLimpaCor').on('click', function () {
    $('#txtCor').val('');
  });

  $('#btnLimpaTamanho').on('click', function () {
    $('#txtTamanho').val('');
  });

  $('#btnMotivoGrava').on('click', function () {
    $('#txtMotivoGrava').val('');
  });

  $('#btnLimpaProgramacao').on('click', function () {
    $('#txtProgramacao').val('');
  });

  $('#btnLimpaGrupoProduto').on('click', function () {
    $('#txtGrupoProduto').val('');
  });

  function buscaParametros() {
    //CHECKBOX
    let sMotivoCancelamento = $('#cbMotivoCancelamento').is(':checked') ? 'S' : 'N';
    let sFaturadoParcialmente = $('#cbFaturamentoParcial').is(':checked') ? 'S' : 'N';
    let sComQtdePendente = $('#cbSomenteQtdePendente').is(':checked') ? 'S' : 'N';
    //CAMPOS    
    let sDtCancelamentoDe = $('#dtCancalamentoDe').val();
    let sDtCancelamentoAte = $('#dtCancelamentoAte').val();
    let sPedido = pegaChave('#txtPedido');
    let sCliente = pegaChave('#txtCliente');
    let sRepresentante = pegaChave('#txtRepresentante');
    let sReserva = pegaChave('#txtReserva');
    let sMotivo = pegaChave('#txtMotivo');
    let sColecao = pegaChave('#txtColecao');
    let sEtiqueta = pegaChave('#txtEtiqueta');
    let sCor = pegaChave('#txtCor');
    let sTamanho = pegaChave('#txtTamanho');
    let sProduto = pegaChave('#txtProduto');
    let sGrupoProduto = pegaChave('#txtGrupoProduto');
    let sProgramacao = pegaChave('#txtProgramacao');

    let retorno =
      //CHECKBOX
      `MOTIVO_CANCELAMENTO=${sMotivoCancelamento}` +
      `&FATURADO_PARCIALMENTE=${sFaturadoParcialmente}` +
      `&COM_QTDE_PENDENTE=${sComQtdePendente}` +
      //CAMPOS
      `&DT_CANCEL_INICIO=${sDtCancelamentoDe}` +
      `&DT_CANCEL_FIM=${sDtCancelamentoAte}` +
      `&NUMERO=${sPedido}` +
      `&CLIENTE=${sCliente}` +
      `&CODREP=${sRepresentante}` +
      `&RESERVA=${sReserva}` +
      `&MOTIVO=${sMotivo}` +
      `&COLECAO=${sColecao}` +
      `&ETIQUETA=${sEtiqueta}` +
      `&COR=${sCor}` +
      `&TAMANHO=${sTamanho}` +
      `&PRODUTO=${sProduto}` +
      `&GRUPO_PRODUTO=${sGrupoProduto}` +
      `&PROGRAMACAO=${sProgramacao}`;

    return retorno;
  };

  async function buscaCancelamento() {
    $.LoadingOverlay("show");
    try {
      let params = buscaParametros();
      const response = await requisicao('GET', '/sisplan/cancelamentopedido/v1/buscarcancelamento?', params, '', 15000);

      if (!response) {
        return;
      }

      let jsonStr = await response.json();

      return jsonStr;
    } catch (error) {
      console.log(error)
    } finally {
      $.LoadingOverlay("hide");
    }
  }

  $('#btnConsultar').on('click', async function () {
    if ($.fn.DataTable.isDataTable('#tabelaPedido')) {
      $('#tabelaPedido').DataTable().destroy();
      $('#tabelaPedido').empty();
    }
    try {
      var dataSet = await buscaCancelamento();
      var dataSetCols = [];

      var keys = Object.keys(dataSet[0]);

      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      }

      $('#tabelaPedido').DataTable({
        paging: true,
        lengthChange: false,
        filter: false,
        info: true,
        order: false,
        destroy: true,
        "language": {
          "sEmptyTable": "Nenhuma consulta realizada",
          "sInfo": "_TOTAL_ registros",
          "sInfoEmpty": " 0 registros",
          "sInfoFiltered": "(Filtrados de _MAX_ registros)",
          "sInfoPostFix": "",
          "sInfoThousands": ".",
          "sLengthMenu": "_MENU_ resultados",
          "sLoadingRecords": "Carregando...",
          "sProcessing": "Processando...",
          "sZeroRecords": "Nenhuma consulta realizada",
          "sSearch": "Pesquisar",
          "oPaginate": {
            "sNext": "Próximo",
            "sPrevious": "Anterior",
            "sFirst": "Primeiro",
            "sLast": "Último"
          },
          "oAria": {
            "sSortAscending": ": Ordenar colunas de forma ascendente",
            "sSortDescending": ": Ordenar colunas de forma descendente"
          }
        },
        "data": dataSet,
        "columns": dataSetCols,
        columnDefs: [{
          targets: [07, 09],
          render(data) {
            return 'R$ ' + parseFloat(data).toFixed(2).replace('.', ',')
          }
        }]
      });

    } catch (err) {
      console.log(err)
    } finally {
      $('#modal-filtros').modal('hide');
    }
  });

  $('#tabelaPedido').on('dblclick', 'tr', async function () {
    try {
      if (permissaoUsuarioLogado.ALTERA == 'S') {
        let data = $('#tabelaPedido').DataTable().row($(this)).data();
        window.location.href = `cancelamento_pedido/${data.NUMERO}`;
      } else {
        msgAlertaSemConfirmacao("Sem permissão para alterar!");
      }
    } catch (error) {
      console.error();
    }
  });

  $('#btnNovoCancelamento').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "cancelamento_pedido/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#btnFiltros').on('click', function () {
    $('#modal-filtros').modal('show');
  });

  // $('#btnConsultar').trigger('click');
});