<?php include_once('../../../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Preço Produto</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.231.12.1">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.231.12.1">

  <!-- Google Font: Source Sans Pro -->
  <link href='https://fonts.googleapis.com/css?family=Roboto:400,300,500,600,700,400italic' rel='stylesheet' type='text/css'>


  <link rel="stylesheet" href="dist/css/custom.css?versao=3.231.12.1">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.231.12.1">
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.231.12.1" />
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.231.12.1">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.231.12.1" />
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.231.12.1">
  <style>
    #tabelaCadProdPreco td div button {
      padding: .0rem .5rem;
      margin-top: .1rem;
      margin-bottom: .2rem;
    }

    #tabelaCadProdPreco td {
      padding: 0 !important;
      padding-left: 10px !important;
    }

    .btnBarra {
      color: black;
      border: 0 none;
      border-radius: 0px;
      cursor: pointer;
      padding: 10px 5px;
      margin: 10px 5px 10px 5px;
      float: right;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">
    <?php
    include_once('../../../menu.php');
    ?>
    <div class="content-wrapper">
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Preço Produto</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" title="Tutorial" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i></button>
            </div>
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="./index">Início</a></li>
                <li class="breadcrumb-item active">Preço Produto</li>
              </ol>
            </div><!-- /.col -->
          </div><!-- /.row -->
        </div>
        <div class="container-fluid">
          <div class="row card">
            <div class="col-sm-12 mt-3">
              <button class="btn btn-success btn-sisp" id="btnFiltros"><span class="fas fa-search"></span>
                Filtros</button>
              <button class="btn btn-danger btn-sisp" id="btnNovoPrecoProduto"><span class="fas fa-plus"></span> Incluir</button>
            </div>

            <div class="col-sm-12 table-responsive card-body">
              <h5>Lista de Produtos</h5>
              <table id="tabelaCadProdPreco" class="table table-sm table-select table-hover" width="100%">
                <thead>
                  <tr>
                    <th class="th-sm">Código
                    </th>
                    <th class="th-sm">Descrição
                    </th>
                    <th class="th-sm">Preço 1
                    </th>
                    <th class="th-sm">Preço 2
                    </th>
                    <th class="th-sm">Preço 3
                    </th>
                  </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
          </div>
          <div id="modal-filtros" class="modal" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-xl" role="document">
              <div class="modal-content" id="modalBody">
                <div class="modal-header">
                  <h4 class="modal-title">Filtros</h4>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                  <div class="row">
                    <div class="col-md-12 col-sm-12 col-12">
                      <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtConsultaProduto">Código:</label>
                      <div class="relative" style="margin-top: 5px;">
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtConsultaProduto" name="txtConsultaProduto" class="form-control" placeholder="Código">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-ConsultaProduto" name="btn-ConsultaProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-ConsultaProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="row mt-3">
                    <div class="col-md-6 col-sm-12 col-12">
                      <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtConsultaGrupo">Grupo:</label>
                      <div class="relative" style="margin-top: 5px;">
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtConsultaGrupo" name="txtConsultaGrupo" class="form-control" placeholder="Grupo">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-ConsultaGrupo" name="btn-ConsultaGrupo" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-ConsultaGrupo" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                    <div class="col-md-6 col-sm-12 col-12">
                      <label style="margin-bottom: .1rem;" data-error="wrong" data-success="right" for="txtConsultaSetor">Setor:</label>
                      <div class="relative" style="margin-top: 5px;">
                        <div class="input-group">
                          <input type="text" class="input-default focus form-control" id="txtConsultaSetor" name="txtConsultaSetor" class="form-control" placeholder="Setor">
                          <div class="input-group-append">
                            <button class="btn bg-danger" id="btn-ConsultaSetor" name="btn-ConsultaSetor" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                            <button class="btn bg-danger" id="btn-limpa-ConsultaSetor" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="row" style="margin-top: 1.4%;">
                    <div class="col-md-6 col-sm-12 col-12">
                      <label for="txtDataDe">Data Cadastro De: </label>
                      <div class="relative">
                        <div class="input-group">
                          <input type="date" max="2500-12-31" value="1200-01-01" class="input-default focus form-control validate" id="txtDataDe" name="DataDe">
                        </div>
                      </div>
                    </div>
                    <div class="col-md-6 col-sm-12 col-12">
                      <label for="txtDataAte">Até: </label>
                      <div class="relative">
                        <div class="input-group">
                          <input type="date" max="2500-12-31" value="2500-12-31" class="input-default focus form-control validate" id="txtDataAte" name="DataAte">
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="modal-footer">
                  <div class="row">
                    <button class="btn btn-primary btn-sisp" id="btnLimparFiltros" style="background-color: #B22222; border-color: #B22222"><span class="fas fa-trash"></span> Limpar Filtros</button>     
                    <button class="btn btn-primary btn-sisp" id="btnConsultar"><span class="fas fa-search"></span> Consultar</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php
  include_once('../../../footer.php');
  include_once('../../../modals/modal_anexos.html');
  include_once('../../../modals/modal_medidas.html');
  include_once('../../../modals/modal_combinacao.html');
  include_once('../../../modals/modal_histprod.html');
  include_once('../../../modals/modal_fluxo_produto.html');
  ?>
  <aside class="control-sidebar control-sidebar-dark">
  </aside>
  </div>
  <script src="plugins/jquery/jquery.min.js?versao=3.231.12.1"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.231.12.1"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.231.12.1"></script>
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.231.12.1"></script>
  <script>
    $.widget.bridge('uibutton', $.ui.button);
  </script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.231.12.1"></script>
  <script src="dist/js/adminlte.min.js?versao=3.231.12.1"></script>
  <script src="dist/js/sisplan.js?versao=3.231.12.1"></script>
  <script src="utils/funcoes.js?versao=3.231.12.1"></script>
  <script src="utils/cookies.js?versao=3.231.12.1"></script>
  <script src="dist/js/requisicoes.js?versao=3.231.12.1"></script>
  <script src="dist/js/loadingoverlay.min.js?versao=3.231.12.1"></script>
  <script src="dist/js/driver.min.js?versao=3.231.12.1"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.231.12.1"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.231.12.1"></script>
  <script type="text/javascript" src="config.js?versao=3.231.12.1"></script>
  <script type="text/javascript" src="modals/modal_anexos.js?versao=3.231.12.1"></script>
  <script type="text/javascript" src="modals/modal_medidas.js?versao=3.229.29.1"></script>
  <script type="text/javascript" src="modals/modal_combinacao.js?versao=3.2210.10.1"></script>
  <script type="text/javascript" src="modals/modal_histprod.js?versao=3.2210.10.1"></script>
  <script type="text/javascript" src="modals/modal_fluxo_produto.js?versao=3.2210.10.1"></script>
  <script>
    $(document).ready(async function() {
      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('CADPRODPRECO');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/cadprodpreco/acesso_prodpreco/acesso_prodpreco.js?versao=3.231.12.1`;
      insereJavaScriptPagina(sArquivo);

    });
  </script>
</body>

</html>