/* eslint-disable prefer-destructuring */
$('#tutorial').on('click', function () {
    // $('#geral-tab').trigger('click');
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            onHighlightStarted: (Element) => {
                if (Element.node.id == 'geral') {
                    if (!$('#multiCollapseExample1').hasClass('show')) {
                        $('#multiCollapseExample1').collapse('show');
                    }
                } else if (Element.node.id == 'itens') {
                    if (!$('#multiCollapseExample2').hasClass('show')) {
                        $('#multiCollapseExample2').collapse('show');
                    }
                } else if (Element.node.id == 'aviamentos') {
                    if (!$('#multiCollapseExample3').hasClass('show')) {
                        $('#multiCollapseExample3').collapse('show');
                    }
                } else if (Element.node.id == 'compras') {
                    if (!$('#multiCollapseExample4').hasClass('show')) {
                        $('#multiCollapseExample4').collapse('show');
                    }
                }
            },
            onPrevious: (Element) => {
                if (
                    Element.node.id == "geral"
                ) {
                    if ($("#geral>a").hasClass("collapsed")) {
                        $("#multiCollapseExample1").collapse("show");
                    }
                } else if (Element.node.id == "dados-contratuais") {
                    if ($("#itens>a").hasClass("collapsed")) {
                        $("#multiCollapseExample2").collapse("show");
                    }
                } else if (Element.node.id == "dados-pagamento") {
                    if ($("#aviamentos>a").hasClass("collapsed")) {
                        $("#multiCollapseExample3").collapse("show");
                    }
                } else if (Element.node.id == "outros") {
                    if ($("#compras>a").hasClass("collapsed")) {
                        $("#multiCollapseExample4").collapse("show");
                    }
                }
            }
        });

        driver.defineSteps([{
            element: '#geral',
            popover: {
                title: 'Aba Geral',
                description: 'Clique aqui para abrir a aba geral.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample1',
            popover: {
                title: 'Dados Gerais',
                description: 'Esses são os campos que você preencherá com os dados gerais de cadastro.',
                position: 'top'
            }
        },
        {
            element: '#itens',
            popover: {
                title: 'Aba Cores',
                description: 'Clique aqui para abrir a aba cores/itens.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample2',
            popover: {
                title: 'Dados de Cores',
                description: 'Aqui ficam as cores e preços das cores do material.',
                position: 'top'
            }
        },
        {
            element: '#btnControleItens',
            popover: {
                title: 'Modal Controle de Itens',
                description: 'Clicando neste botão abrirá um modal para fazer a manutenção das cores do material.',
                position: 'top'
            }
        },
        {
            element: '#btnQuebras',
            popover: {
                title: 'Modal Quebras',
                description: 'Clicando neste botão abrirá um modal para fazer a manutenção das quebras do material.',
                position: 'top'
            }
        },
        {
            element: '#btnPrecoTinturaria',
            popover: {
                title: 'Modal Preço Tinturaria',
                description: 'Clicando neste botão abrirá um modal para buscar o preço da tinturaria das cores do material.',
                position: 'top'
            }
        },
        {
            element: '#btnCustoMalhas',
            popover: {
                title: 'Modal Custo Malha',
                description: 'Clicando neste botão abrirá um modal para buscar o custo das malhas do material.',
                position: 'top'
            }
        },
        {
            element: '#aviamentos',
            popover: {
                title: 'Aba Aviamentos',
                description: 'Clique aqui para abrir a aba aviamentos.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample3',
            popover: {
                title: 'Dados de Aviamentos',
                description: 'Aqui ficam os aviamentos e preços dos aviamentos do material.',
                position: 'top'
            }
        },
        {
            element: '#btnAviamentos',
            popover: {
                title: 'Modal Aviamentos',
                description: 'Clicando neste botão abrirá um modal para fazer a manutenção dos aviamentos do material.',
                position: 'top'
            }
        },
        {
            element: '#compras',
            popover: {
                title: 'Aba Últimas Compras',
                description: 'Clique aqui para abrir a aba últimas compras.',
                position: 'top'
            }
        },
        {
            element: '#multiCollapseExample4',
            popover: {
                title: 'Últimas Compras',
                description: 'Aqui ficam as últimas compras do material.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: 'Botão Voltar',
                description: 'Ao clicar nesse botão você retorna para a tela de consulta.',
                position: "left",
            },
        },
        {
            element: '#btnGravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Ao clicar nesse botão você grava os dados inseridos.',
                position: 'left'
            }
        }
        ]);

        driver.start();
    });
});


$(document).ready(async function () {

    const queryString = window.location.href;
    const parametros = queryString.split('/');
    let codMat = parametros[parametros.length - 1];

    if (codMat != 'create') {
        $('#txtCodigo').prop('disabled', true);
        $('#txtCodigo').prop('readonly', true);
    } else {
        $('.create').prop('disabled', true);
    }

    let inclusaoCI = false;
    let inclusaoQuebras = false;
    let inclusaoAviamentos = false;
    let impostos = 0;
    const piscofins = await retornaPisCofins();

    const cus210_7 = await buscaParametroERP('CUS', '210', '7', '1');
    const cus210_8 = await buscaParametroERP('CUS', '210', '8', '1');
    const cus280_32 = await buscaParametroERP('CUS', '280', '32', '1');
    const cus280_18 = await buscaParametroERP('CUS', '280', '18', '1');
    const cus280_10 = await buscaParametroERP('CUS', '280', '10', '1');
    const cus280_23 = await buscaParametroERP('CUS', '280', '23', '1');
    const cus280_21 = await buscaParametroERP('CUS', '280', '21', '1');
    const cus280_12 = await buscaParametroERP('CUS', '280', '12', '1');
    const cus280_96 = await buscaParametroERP('CUS', '280', '96', '1');
    const cus280_19 = await buscaParametroERP('CUS', '280', '19', '1');
    const cus280_91 = await buscaParametroERP('CUS', '280', '91', '1');
    const cus280_5 = await buscaParametroERP('CUS', '280', '5', '1');

    $('#cbEsconderFoto').on('change', function () {
        if ($('#cbEsconderFoto').prop('checked') == true) {
            $('#divImagem').addClass('d-none');
            $('#infoGerais').addClass('col-12');
        } else {
            $('#divImagem').removeClass('d-none');
            $('#infoGerais').removeClass('col-12');
            $('#infoGerais').addClass('col-8');
        }
    });

    async function buscaFoto(codigo) {
        try {
            let urlRequisicao = '/Sisplan/Funcoes/v1/FotoItem?';
            let response = await requisicao('GET', urlRequisicao, `codigo=${codigo}`, null);

            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
                $("#imagemMat").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
                return;
            }

            let sBase64 = jsonStr;
            $("#imagemMat").attr('src', `data:image/png;base64,${sBase64.mensagem}`);

        } catch (error) {
            console.error(error);
            $("#imagemMat").attr('src', `${BASE_URI}/dist/img/prod-1.png`);
        }
    }

    $('#txtCodigo').on('input', async function () {
        codMat = $('#txtCodigo').val();

        if ($('#txtCodigo').val() != '') {
            $('.create').prop('disabled', false);
            await buscaDadosCreate(codMat);
        } else {
            $('.create').prop('disabled', true);
            $('#txtDescricao').val('');
            $('input').val('');
            $('#btnGravar').val('Gravar');
        }
    });

    $('#txtCodigo').on('blur', async function () {

        let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"MAT_PRECO",
                "camposSelect":["CODIGO, TIPO"],
                "where": ["MAT_PRECO.CODIGO = '${codMat}'", "MAT_PRECO.EMP_ID = '${getCookie('emp_id')}'"]}`, null);

        if (!response) {
            return;
        }

        const validaMatPreco = (await response.json()).RESULT[0];
        if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return;
        }

        if (validaMatPreco.length > 0) {
            msgAlerta('Código já cadastrado, deseja alterar os dados?', () => {
                $.LoadingOverlay('show');
                if (validaMatPreco[0].TIPO == 'M' || validaMatPreco[0].TIPO == '') {
                    window.location.href = `${BASE_URI}/cadmatpreco/${codMat}`;
                } else {
                    window.location.href = `${BASE_URI}/cadprodpreco/${codMat}`;
                }
                $.LoadingOverlay('hide');
            }, () => {
                $.LoadingOverlay('show');
                $('.create').prop('disabled', true);
                $('#txtCodigo').val('');
                $('#txtDescricao').val('');
                $('#txtUnidade').val('');
                $('#txtCodigo').focus();
                codMat = $('#txtCodigo').val();
                $.LoadingOverlay('hide');
            })
        } else {
            $('#txtFatorConversao').val('1');
        }
    });

    async function buscaDadosCreate(codigo) {

        let descricao = '';
        let unidade = '';
        let divisor = '';
        let aproveitamento = '';

        let response = null;
        response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"MATERIAL",
                "camposSelect":["DESCRICAO, UNIDADE, DIVISOR, APROVEITAMENTO"],
                "where": ["MATERIAL.CODIGO = '${codigo}'"]}`, null);

        if (!response) {
            return;
        }

        const data = (await response.json()).RESULT[0];
        if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return;
        }

        if (data.length > 0) {
            descricao = data[0].DESCRICAO;
            unidade = data[0].UNIDADE;
            divisor = data[0].DIVISOR;
            aproveitamento = data[0].APROVEITAMENTO;
        }

        if (descricao != '' && descricao != undefined && descricao != null) {
            $.LoadingOverlay('show');
            $('#txtDescricao').val(descricao);
            $.LoadingOverlay('hide');
        } else {
            $('#txtDescricao').val('');
        }

        if (unidade != '' && unidade != undefined && unidade != null) {
            $.LoadingOverlay('show');
            $('#txtUnidade').val(unidade);
            $.LoadingOverlay('hide');
        } else {
            $('#txtUnidade').val('');
        }

        if (divisor != '' && divisor != undefined && divisor != null) {
            $.LoadingOverlay('show');
            $('#txtDivisor').val(divisor);
            $.LoadingOverlay('hide');
        } else {
            $('#txtDivisor').val('');
        }

        if (aproveitamento != '' && aproveitamento != undefined && aproveitamento != null) {
            $.LoadingOverlay('show');
            $('#txtAproveitamento').val(aproveitamento);
            $.LoadingOverlay('hide');
        } else {
            $('#txtAproveitamento').val('');
        }

        if ($('#txtCodigo').val() != '') {
            await buscaUltimasCompras(codMat);
        }

    };

    async function retornaPisCofins() {
        const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"EMPRESA",
                    "camposSelect":["EMPRESA.EMP_PIS, EMPRESA.EMP_COFINS"],
                    "where": ["EMPRESA.EMP_PAT = '${getCookie('empresa')}'"]}`, null);

        if (!response) {
            return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
        }

        if (jsonStr.RESULT[0].length == 0) {
            return;
        }

        const piscofins = (100 - (jsonStr.RESULT[0][0].EMP_PIS + jsonStr.RESULT[0][0].EMP_COFINS)) / 100;

        return piscofins;
    };

    function retornaOpcoes(sChave, tabela) {

        let retorno = '<div> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnOpcoesOrdem" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">' + sChave +
            '    </button> ' +
            '    <div class="dropdown-menu"> '
        if (tabela == 'tabelaControleItens') {
            retorno += '    <button class="dropdown-item" id="btn-alterar-ci">Alterar</button>' +
                '    <button class="dropdown-item" id="btn-excluir-ci">Excluir</button>'
        } else if (tabela == 'tabelaPrecoTin') {
            retorno += '    <button class="dropdown-item" id="btn-alterar-precotin">Alterar</button>'
        } else if (tabela == 'tabelaQuebras') {
            retorno += '    <button class="dropdown-item" id="btn-alterar-quebras">Alterar</button>' +
                '    <button class="dropdown-item" id="btn-excluir-quebras">Excluir</button>'
        } else if (tabela == 'tabelaModalAviamentos') {
            retorno += '    <button class="dropdown-item" id="btn-alterar-avi">Alterar</button>' +
                '    <button class="dropdown-item" id="btn-excluir-avi">Excluir</button>'
        }

        retorno += '    </div>';

        return retorno;
    };

    function criaTabela(tabela, cols, opcoes = null) {

        tabela.DataTable({
            paging: true,
            lengthChange: false,
            info: false,
            order: false,
            destroy: true,
            autowidth: true,
            columnDefs: [
                {
                    targets: cols,
                    visible: false,
                },
                {
                    targets: opcoes,
                    render: function (data) {
                        return retornaOpcoes(data, tabela[0].id);
                    }
                }
            ],
            "language": {
                "sEmptyTable": "Nenhum registro encontrado",
                "sInfo": "_TOTAL_ registros",
                "sInfoEmpty": " 0 registros",
                "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                "sInfoPostFix": "",
                "sInfoThousands": ".",
                "sLengthMenu": "_MENU_ resultados",
                "sLoadingRecords": "Carregando...",
                "sProcessing": "Processando...",
                "sZeroRecords": "Nenhum registro encontrado",
                "sSearch": "Pesquisar",
                "oPaginate": {
                    "sNext": "Próximo",
                    "sPrevious": "Anterior",
                    "sFirst": "Primeiro",
                    "sLast": "Último"
                },
                "oAria": {
                    "sSortAscending": ": Ordenar colunas de forma ascendente",
                    "sSortDescending": ": Ordenar colunas de forma descendente"
                }
            },
        });

    }

    function formataData(date) {

        if (!date) {
            return '30/12/1899';
        }

        let data = date.split('-');

        if ((data[0] == '' || data[0] == undefined) || (data[1] == '' || data[1] == undefined) || (data[2] == '' || data[2] == undefined)) {
            return '30/12/1899';
        }

        return `${data[2].substring(0, 2)}/${data[1]}/${data[0]}`;
    }

    async function buscaDados() {

        try {
            $.LoadingOverlay("show");
            try {
                const pesquisaMatPreco = {
                    camposSelect: ['CODIGO'],
                    tabela: 'MAT_PRECO',
                    where: [`CODIGO = '${codMat}' AND EMP_ID = '${getCookie('emp_id')}'`]
                };

                const validaMatPreco = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaMatPreco));

                if (validaMatPreco.length > 0) {
                    let jsonStr = await retornaInfoMatPreco();

                    if (jsonStr.RESULT[0].length == 0) {
                        return;
                    }

                    if (jsonStr.RESULT[0][0].CODIGO_IMPRESSAO != '') {
                        const pesquisaGrupo = {
                            camposSelect: ['DESCRICAO'],
                            tabela: 'PRECO_GRUPO',
                            where: [`CODIGO = '${jsonStr.RESULT[0][0].CODIGO_IMPRESSAO}'`]
                        };

                        const nomeGrupo = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaGrupo));
                        insereValor('#txtGrupo', jsonStr.RESULT[0][0].CODIGO_IMPRESSAO, nomeGrupo != '' ? nomeGrupo[0].DESCRICAO : '')
                    }

                    if (jsonStr.RESULT[0][0].SETOR != '') {
                        const pesquisaSetor = {
                            camposSelect: ['DESCRICAO'],
                            tabela: 'CADFLUXO',
                            where: [`CODIGO = '${jsonStr.RESULT[0][0].SETOR}'`]
                        };

                        const nomeSetor = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaSetor));
                        insereValor('#txtSetor', jsonStr.RESULT[0][0].SETOR, nomeSetor != '' ? nomeSetor[0].DESCRICAO : '')
                    }

                    if (jsonStr.RESULT[0][0].PARTE != '') {
                        const pesquisaParte = {
                            camposSelect: ['DESCRICAO'],
                            tabela: 'TIPO_APL',
                            where: [`CODIGO = '${jsonStr.RESULT[0][0].PARTE}'`]
                        };

                        const nomeParte = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParte));
                        insereValor('#txtParte', jsonStr.RESULT[0][0].PARTE, nomeParte != '' ? nomeParte[0].DESCRICAO : '')
                    }

                    const data = jsonStr.RESULT[0][0].DT_ULT_ATUALIZACAO == null ? '' : jsonStr.RESULT[0][0].DT_ULT_ATUALIZACAO;

                    $('#cbProduzido').prop('checked', jsonStr.RESULT[0][0].PRODUZIDO == 'S' ? true : false);
                    $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val((jsonStr.RESULT[0][0].DESCRICAO).toUpperCase());
                    $('#txtUnidade').val(jsonStr.RESULT[0][0].UNIDADE);
                    $('#txtPrecoCompra').val(jsonStr.RESULT[0][0].PRECO_COMPRA);
                    $('#txtPreco1').val(jsonStr.RESULT[0][0].PRECO_1);
                    $('#txtPreco2').val(jsonStr.RESULT[0][0].PRECO_2);
                    $('#txtPreco3').val(jsonStr.RESULT[0][0].PRECO_3);
                    $('#txtCreditoIPI').val(jsonStr.RESULT[0][0].IPI);
                    $('#cbCreditoIPI').prop('checked', jsonStr.RESULT[0][0].CREDITA_IPI == 'S' ? true : false);
                    $('#txtCreditoICMS').val(jsonStr.RESULT[0][0].ICM);
                    $('#cbCreditoICMS').prop('checked', jsonStr.RESULT[0][0].CREDITA_ICMS == 'S' ? true : false);
                    $('#txtCreditoPIS').val(jsonStr.RESULT[0][0].PIS);
                    $('#cbCreditoPIS').prop('checked', jsonStr.RESULT[0][0].CREDITA_PIS == 'S' ? true : false);
                    $('#txtCreditoCOFINS').val(jsonStr.RESULT[0][0].COFINS);
                    $('#cbCreditoCOFINS').prop('checked', jsonStr.RESULT[0][0].CREDITA_COFINS == 'S' ? true : false);
                    $('#txtDespesasIPI').val(jsonStr.RESULT[0][0].PERC_IPI);
                    $('#txtFrete').val(jsonStr.RESULT[0][0].PERC_FRETE);
                    $('#txtValorFrete').val(jsonStr.RESULT[0][0].VLR_FRETE);
                    $('#txtFatorConversao').val(jsonStr.RESULT[0][0].DIVISOR == null ? 1 : jsonStr.RESULT[0][0].DIVISOR);
                    $('#txtAproveitamento').val(jsonStr.RESULT[0][0].APROVEITAMENTO);
                    $('#txtData').val(jsonStr.RESULT[0][0].DATA.substring(0, 10));
                    $('#txtPrecoAnterior').val(jsonStr.RESULT[0][0].PRECO_4);
                    $('#txtDataUltimaAtualizacao').val(data.substring(0, 10));
                    $('#txtLarguraMalha').val(jsonStr.RESULT[0][0].LARGURA);
                    $('#txtGramatura').val(jsonStr.RESULT[0][0].GRAMATURA);
                    $('#txtIndicePeso').val(jsonStr.RESULT[0][0].INDICE_PESO);
                    $('#txtMVA').val(jsonStr.RESULT[0][0].MVA);
                    $('#txtInfoCompl').val(jsonStr.RESULT[0][0].INF_COMPL);
                    $('#txtObs').val(jsonStr.RESULT[0][0].OBS);

                }

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function retornaInfoMatPreco() {

        const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"MAT_PRECO",
                "camposSelect":["MAT_PRECO.PRODUZIDO", "MAT_PRECO.CODIGO", "MAT_PRECO.DESCRICAO", "MAT_PRECO.UNIDADE", "MAT_PRECO.CODIGO_IMPRESSAO", "MAT_PRECO.SETOR",
                                 "MAT_PRECO.PARTE", "MAT_PRECO.PRECO_COMPRA", "MAT_PRECO.PRECO_1", "MAT_PRECO.PRECO_2", "MAT_PRECO.PRECO_3",
                                 "MAT_PRECO.PERC_IPI", "MAT_PRECO.CREDITA_IPI", "MAT_PRECO.ICM", "MAT_PRECO.CREDITA_ICMS", "MAT_PRECO.PIS",
                                 "MAT_PRECO.CREDITA_PIS", "MAT_PRECO.COFINS", "MAT_PRECO.CREDITA_COFINS", "MAT_PRECO.IPI", "MAT_PRECO.PERC_FRETE", "MAT_PRECO.VLR_FRETE",
                                 "MATERIAL.DIVISOR", "MAT_PRECO.APROVEITAMENTO", "MAT_PRECO.DATA", "MAT_PRECO.PRECO_4", "DT_ULT_ATUALIZACAO", "MAT_PRECO.LARGURA",
                                 "MAT_PRECO.GRAMATURA", "MAT_PRECO.INDICE_PESO", "MAT_PRECO.MVA", "MAT_PRECO.INF_COMPL", "MAT_PRECO.OBS"],
                "leftjoin": [{"tabela": "MATERIAL", "condicao": "MAT_PRECO.CODIGO = MATERIAL.CODIGO"}],
                "where": ["MAT_PRECO.CODIGO = '${codMat}'", "MAT_PRECO.EMP_ID = '${getCookie('emp_id')}'"]}`, null);

        if (!response) {
            return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
        }


        return jsonStr;
    }

    async function buscaUltimasCompras(codigo) {

        try {
            const response = await requisicao("GET", "/sisplan/cadmatpreco/v1/ultimascompras?", `CODIGO=${codigo}`);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            montaCardCompras(jsonStr);

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        }

    };

    function montaCardCompras(data) {

        $('#cardbody-compras').empty();

        let card = '';

        if (data.length > 0) {

            card = '<div class="scroll" style="max-height: 500px; overflow-y: scroll">' +
                '<div style="background-color: white; height: 1px;">' +
                '</div>';

            for (let i = 0; i < data.length; i++) {

                card += '<div class="card col-12">' +
                    '<div style="background-color: white; height: 1px;">' +
                    '</div>' +
                    '<div class="form-row pl-1 pt-2 col-12">' +
                    '<h6 class="col-9"><b>Fornecedor:</b> [' +
                    data[i].CODCRE + '] - ' + data[i].NOME +
                    '</h6>' +
                    '<h6 class="col-3"><b>Nota:</b> ' +
                    data[i].NOTAFISCAL +
                    '</h6>' +
                    '</div>' +
                    '<div class="form-row pl-1 col-12">' +
                    '<h6 class="col-2"><b>Data:</b> ' +
                    data[i].DT_ENTRADA +
                    '</h6>' +
                    '<h6 class="col-3"><b>Unidade de Compra:</b> ' +
                    data[i].UNI_COM +
                    '</h6>' +
                    '<h6 class="col-2"><b>Redução ICMS:</b> ' +
                    data[i].PERC_ICMS_REDUZ +
                    '</h6>' +
                    '<h6 class="col-2"><b>Quantidade:</b> ' +
                    data[i].QTDE +
                    '</h6>' +
                    '<h6 class="col-3"><b>Preço:</b> ' +
                    data[i].VALOR +
                    '</h6>' +
                    '</div' +
                    '<div class="form-row pl-1 pt-1 col-12">' +
                    '<h6 class="col-2"><b>Fator Conversão:</b> ' +
                    data[i].DIVISOR +
                    '</h6>' +
                    '<h6 class="col-3"><b>Preço Convertido:</b> ' +
                    data[i].PRECO_CONVERTIDO +
                    '</h6>' +
                    '<h6 class="col-2"><b>Val Uni ICMS:</b> ' +
                    data[i].VAL_UNI_ICMS +
                    '</h6>' +
                    '<h6 class="col-2"><b>Val Uni IPI:</b> ' +
                    data[i].VAL_UNI_IPI +
                    '</h6>' +
                    '<h6 class="col-3"><b>Custo Mat_Mov:</b> ' +
                    data[i].CUSTO +
                    '</h6>' +
                    '</div> ' +
                    '<div style="background-color: white; height: 1px;">' +
                    '</div>' +
                    '</div>';
            }
        } else {
            card = '<div class="scroll" style="max-height: 500px">' +
                '<div style="background-color: white; height: 1px;">' +
                '</div>';

            card += '<div class="d-flex justify-content-center">' +
                '<h6 class="my-3"><b>Nenhum registro encontrato</b>' +
                '</h6>' +
                '</div>'
        }

        card += '<div style="background-color: white; height: 1px;">' +
            '</div>' +
            '</div>';

        $('#cardbody-compras').append(card);

    };

    async function buscaPrecoCores() {

        const where = `["MAT_PRECO_COR.CODIGO = '${codMat}'", "MAT_PRECO_COR.EMP_ID = '${getCookie('emp_id')}'"]`;

        try {
            $.LoadingOverlay('show');
            try {

                const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"MAT_PRECO_COR",
                "camposSelect":["MAT_PRECO_COR.ID", "MAT_PRECO_COR.ATIVO", "MAT_PRECO_COR.COR", "CADCOR.DESCRICAO", "MAT_PRECO_COR.PRECO_TING",
                                "MAT_PRECO_COR.PRECO_COMPRA", "MAT_PRECO_COR.PERC_DESP", "MAT_PRECO_COR.PRECO", "CADCOR.PANTONE", "CADCOR.TINTURARIA",
                                "ENTIDADE.NOME", "CADCOR.CODIGO2", "CADCOR.GRUPO", "GRUPO_COR.DESCRICAO AS DESC_GRUPO", "MATERIAL.DIVISOR"], 
                "leftjoin": [
                            {"tabela" : "CADCOR", "condicao" : "MAT_PRECO_COR.COR = CADCOR.COR"},
                            {"tabela" : "ENTIDADE", "condicao" : "CADCOR.TINTURARIA = ENTIDADE.CODCLI"},
                            {"tabela" : "GRUPO_COR", "condicao" : "CADCOR.GRUPO = GRUPO_COR.CODIGO"},
                            {"tabela" : "MATERIAL", "condicao" : "MAT_PRECO_COR.CODIGO = MATERIAL.CODIGO"}
                        ]                            
                "where": ${where}}`,
                )

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                const data = jsonStr.RESULT[0];

                preencheDadosTabelaCores(data);

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }

    };

    function preencheDadosTabelaCores(data) {
        for (let i = 0; i < data.length; i++) {
            let preco_ting = 0;
            let preco_compra = 0;
            let perc_desp = 0;
            let preco = 0;

            if (data[i].PRECO_TING != '' && data[i].PRECO_TING != null && data[i].PRECO_TING != undefined) {
                preco_ting = data[i].PRECO_TING;
            }

            if (data[i].PRECO_COMPRA != '' && data[i].PRECO_COMPRA != null && data[i].PRECO_COMPRA != undefined) {
                preco_compra = data[i].PRECO_COMPRA;
            }

            if (data[i].PERC_DESP != '' && data[i].PERC_DESP != null && data[i].PERC_DESP != undefined) {
                perc_desp = data[i].PERC_DESP;
            }

            if (data[i].PRECO != '' && data[i].PRECO != null && data[i].PRECO != undefined) {
                preco = data[i].PRECO;
            }

            $('#tabelaCores').DataTable().row.add([
                data[i].ID,
                data[i].ATIVO,
                data[i].COR,
                data[i].DESCRICAO,
                parseFloat(preco_ting).toFixed(6) == 'NaN' ? 0 : parseFloat(preco_ting).toFixed(6),
                parseFloat(preco_compra).toFixed(6) == 'NaN' ? 0 : parseFloat(preco_compra).toFixed(6),
                parseFloat(perc_desp).toFixed(6) == 'NaN' ? 0 : parseFloat(perc_desp).toFixed(6),
                parseFloat(preco).toFixed(6) == 'NaN' ? 0 : parseFloat(preco).toFixed(6),
                data[i].PANTONE,
                data[i].TINTURARIA,
                data[i].NOME,
                data[i].CODIGO2,
                data[i].GRUPO,
                data[i].DESC_GRUPO
            ]).draw(false);
        }

    }

    async function buscaPrecoAviamentos() {

        try {
            $.LoadingOverlay('show');
            try {

                const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"MAT_PRECO_ITEN",
                "camposSelect":["DISTINCT MAT_PRECO_ITEN.ORDEM", "MAT_PRECO_ITEN.CODIGO", "MAT_PRECO_ITEN.MATERIAL", "MAT_PRECO_ITEN.CUSTO", "MAT_PRECO_ITEN.QUANTIDADE",
                "MAT_PRECO_ITEN.VALOR", "MAT_PRECO_ITEN.ACUMULADO", "MAT_PRECO_ITEN.UNIDADE",
                "(SELECT MAX(MAT_PRECO.DT_ULT_ATUALIZACAO) FROM [MAT_PRECO] MAT_PRECO WHERE MAT_PRECO.CODIGO = MAT_PRECO_ITEN.CODIGO) DT_ULT_ATUALIZACAO", "MAT_PRECO_ITEN.QUEBRA"],
                "where": [
                    "MAT_PRECO_ITEN.ARTIGO = '${codMat}'",
                    "MAT_PRECO_ITEN.TAM = '0'",
                    "(MAT_PRECO_ITEN.MARKUP IS NULL OR MAT_PRECO_ITEN.MARKUP = '')",
                    "MAT_PRECO_ITEN.CODCLI IS NOT NULL",
                    "MAT_PRECO_ITEN.EMP_ID = '${getCookie('emp_id')}'"
                ],
                "orderby": ["MAT_PRECO_ITEN.ORDEM"]}`
                )

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                const data = jsonStr.RESULT[0];

                preencheTabelasAviamentos(data, $('#tabelaAviamentos'));

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }

    };

    function preencheTabelasAviamentos(data, tabela) {

        for (let i = 0; i < data.length; i++) {

            let custo = (data[i].CUSTO);
            if (typeof custo == 'string') {
                custo = custo.replace(',', '.');
            }
            const custoFormatado = parseFloat(custo).toFixed(6) == 'NaN' ? 0 : parseFloat(custo).toFixed(6);

            let acumulado = (data[i].ACUMULADO);
            if (typeof acumulado == 'string') {
                acumulado = acumulado.replace(',', '.');
            }
            const acumuladoFormatado = parseFloat(acumulado).toFixed(6) == 'NaN' ? 0 : parseFloat(acumulado).toFixed(6);

            if (tabela[0].id == 'tabelaAviamentos') {
                $('#tabelaAviamentos').DataTable().row.add([
                    data[i].ORDEM,
                    data[i].CODIGO,
                    data[i].MATERIAL,
                    custoFormatado,
                    data[i].QUANTIDADE,
                    calculaValorComQuebra(data[i].QUANTIDADE, data[i].CUSTO, data[i].QUEBRA),
                    acumuladoFormatado,
                    data[i].UNIDADE,
                    formataData(data[i].DT_ULT_ATUALIZACAO),
                    data[i].QUEBRA,
                ]).draw(false);
            } else {
                $('#tabelaModalAviamentos').DataTable().row.add([
                    data[i].ORDEM,
                    data[i].CODIGO,
                    data[i].MATERIAL,
                    data[i].UNIDADE,
                    data[i].QUANTIDADE,
                    custoFormatado,
                    data[i].QUEBRA,
                    calculaValorComQuebra(data[i].QUANTIDADE, data[i].CUSTO, data[i].QUEBRA),
                    acumuladoFormatado,
                    formataData(data[i].DT_ULT_ATUALIZACAO),
                ]).draw(false);
            }
        }
    };

    $('#cbCreditoIPI').on('change', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#cbCreditoICMS').on('change', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#cbCreditoPIS').on('change', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#cbCreditoCOFINS').on('change', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtPrecoCompra').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtCreditoIPI').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtCreditoICMS').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtCreditoPIS').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtCreditoCOFINS').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtDespesasIPI').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtFrete').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtValorFrete').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtAproveitamento').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    $('#txtMVA').on('blur', async function () {
        calculaPrecoComDesconto(
            $('#txtPrecoCompra').val(),
            $('#cbCreditoIPI').prop('checked'),
            $('#cbCreditoICMS').prop('checked'),
            $('#cbCreditoPIS').prop('checked'),
            $('#cbCreditoCOFINS').prop('checked')
        )
    });

    function calculaPrecoComDesconto(precoCompra, descontaIPI, descontaICMS, descontaPIS, descontaCOFINS) {
        try {

            precoCompra = retornaFloat(precoCompra);

            if (precoCompra > 0) {

                let preco = precoCompra;

                preco = retornaFloat(preco);

                let aproveitamento = retornaFloat($('#txtAproveitamento').val())

                if (cus280_23 == 'S' && aproveitamento != 0) {
                    preco = preco / (aproveitamento / 100);
                };

                if (descontaIPI) {

                    let ipi = retornaFloat($('#txtCreditoIPI').val());

                    preco -= precoCompra * (ipi / 100);
                };

                if (descontaICMS) {

                    let icms = retornaFloat($('#txtCreditoICMS').val());

                    preco -= precoCompra * (icms / 100);
                };

                if (descontaPIS) {

                    let pis = retornaFloat($('#txtCreditoPIS').val());

                    preco -= precoCompra * (pis / 100);
                };

                if (descontaCOFINS) {

                    let cofins = retornaFloat($('#txtCreditoCOFINS').val());

                    preco -= precoCompra * (cofins / 100);
                };

                let percFrete = retornaFloat($('#txtFrete').val());

                let valorFrete = retornaFloat($('#txtValorFrete').val());

                let despesasIPI = retornaFloat($('#txtDespesasIPI').val());

                let mva = retornaFloat($('#txtMVA').val());

                preco += (precoCompra * (percFrete / 100)) + valorFrete;

                preco += precoCompra * (despesasIPI / 100);

                preco += precoCompra * (mva / 100);

                if (cus280_23 == 'D' && aproveitamento != 0) {
                    preco = preco / (aproveitamento / 100);
                };

                impostos = preco / precoCompra;

                if (precoCompra == 1000) {
                    precoCompra = 0;
                    preco = 0;
                };

                let divisor = $('#txtFatorConversao').val();

                if (divisor == '') {
                    divisor = 1;
                };

                if (typeof divisor == 'string') {
                    divisor = divisor.replace(',', '.');
                };

                divisor = parseFloat(divisor);

                if (cus280_21 == 'S' && divisor != 0) {
                    preco = preco / divisor;
                };

                $('#txtPrecoCompra').val(precoCompra);
                $('#txtPreco1').val((preco).toFixed(6));

                if (cus280_12 == 'S') {
                    $('#txtPreco2').val((preco).toFixed(6));
                    $('#txtPreco3').val((preco).toFixed(6));
                };
            }

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        }
    };

    function retornaFloat(valor) {
        if (valor == '') {
            valor = 0;
        };

        if (typeof valor == 'string') {
            valor = valor.replace(',', '.');
        };

        valor = parseFloat(valor);

        return valor;
    }

    $('#btnGravar').on('click', async function () {

        msgAlerta('Deseja gravar os dados?', async () => {
            await gravaDados();
        });
    });

    $('#btnGravar').on('click', async function () {

        if ($('#txtCodigo').val() == '') {
            msgErro('Campo código deve ser preenchido, favor verificar.', () => {
                $('#txtGrupo').focus();
            });
            $('#txtCodigo').focus();
            return;
        }

        if ($('#txtDescricao').val() == '') {
            msgErro('Campo descrição deve ser preenchido, favor verificar.', () => {
                $('#txtGrupo').focus();
            });
            $('#txtDescricao').focus();
            return;
        }

        if ($('#txtGrupo').val() == '') {
            msgErro('Campo grupo deve ser preenchido, favor verificar.', () => {
                $('#txtGrupo').focus();
            });
            return;
        }

        msgAlerta('Deseja gravar os dados?', async () => {
            await gravaDados();
        });
    });

    async function retornaDataGravar() {

        let data = $('#txtDataUltimaAtualizacao').val();

        const resposta = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"MAT_PRECO",
        "camposSelect":["MAT_PRECO.CODIGO"],
        "where": ["MAT_PRECO.CODIGO = '${codMat}'", "MAT_PRECO.EMP_ID = '${getCookie('emp_id')}'"]}`, null);

        if (!resposta) {
            return;
        }

        let validaExisCod = (await resposta.json()).RESULT[0];
        if (resposta.status != 200) {
            msgErro(validaExisCod.mensagem);
            return;
        }

        if (validaExisCod.length > 0 && cus280_5 == 'S') {
            data = new Date().toJSON().slice(0, 10);
            return data;
        }

        preco = retornaFloat($('#txtPreco1').val());

        const preco_ant = await retornaPrecoAnt();

        if (preco != preco_ant) {
            data = new Date().toJSON().slice(0, 10);
            return data;
        }

        if (data == '') {
            data = new Date().toJSON().slice(0, 10);
        }

        return data;

    }

    async function retornaPrecoAnt() {
        const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"MAT_PRECO",
        "camposSelect":["MAT_PRECO.PRECO_1"],
        "where": ["MAT_PRECO.CODIGO = '${codMat}'", "MAT_PRECO.EMP_ID = '${getCookie('emp_id')}'"]}`, null);

        if (!response) {
            return;
        }

        let jsonStr = (await response.json()).RESULT[0];
        if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            return;
        }

        let preco_ant = 0;

        if (jsonStr.length > 0) {
            preco_ant = jsonStr[0].PRECO_1;
        }

        return retornaFloat(preco_ant);

    }

    async function gravaDados() {
        try {
            $.LoadingOverlay('show');
            try {

                const dt_atualizacao = await retornaDataGravar();

                const preco_ant = await retornaPrecoAnt();

                const obs = preco_ant != retornaFloat($('#txtPreco1').val()) ?
                    `MATERIAL ATUALIZADO EM ${dt_atualizacao} PELO USUÁRIO ${getCookie('usuario')}` :
                    $('#txtObs').val();

                let material = {};

                material.APROVEITAMENTO = $('#txtAproveitamento').val() == '' ? '100' : $('#txtAproveitamento').val();
                material.CODIGO = $('#txtCodigo').val();
                material.CODIGO_IMPRESSAO = pegaChave('#txtGrupo');
                material.DATA = $('#txtData').val() == '' ? new Date().toJSON().slice(0, 10) : $('#txtData').val();
                material.DESCRICAO = $('#txtDescricao').val();
                material.ICM = $('#txtCreditoICMS').val() == '' ? 0 : $('#txtCreditoICMS').val();
                material.OBS = obs;
                material.PRECO_1 = $('#txtPreco1').val() == '' ? 0 : $('#txtPreco1').val();
                material.PRECO_2 = $('#txtPreco2').val() == '' ? 0 : $('#txtPreco2').val();
                material.UNIDADE = $('#txtUnidade').val();
                material.GRAMATURA = $('#txtGramatura').val();
                material.INDICE_PESO = $('#txtIndicePeso').val();
                material.LARGURA = $('#txtLarguraMalha').val();
                material.SETOR = pegaChave('#txtSetor');
                material.INF_COMPL = $('#txtInfoCompl').val();
                material.COFINS = $('#txtCreditoCOFINS').val() == '' ? 0 : $('#txtCreditoCOFINS').val();
                material.PIS = $('#txtCreditoPIS').val() == '' ? 0 : $('#txtCreditoPIS').val();
                material.PRECO_COMPRA = $('#txtPrecoCompra').val() == '' ? 0 : $('#txtPrecoCompra').val();
                material.IPI = $('#txtCreditoIPI').val() == '' ? 0 : $('#txtCreditoIPI').val();
                material.PERC_FRETE = $('#txtFrete').val() == '' ? 0 : $('#txtFrete').val();
                material.VLR_FRETE = $('#txtValorFrete').val() == '' ? 0 : $('#txtValorFrete').val();
                material.DT_ULT_ATUALIZACAO = dt_atualizacao;
                material.PARTE = pegaChave('#txtParte');
                material.PRECO_3 = $('#txtPreco3').val() == '' ? 0 : $('#txtPreco3').val();
                material.PRECO_4 = preco_ant;
                material.PERC_IPI = $('#txtDespesasIPI').val() == '' ? 0 : $('#txtDespesasIPI').val();
                material.TIPO = 'M';
                material.PRODUZIDO = $('#cbProduzido').prop('checked') == true ? 'S' : 'N';
                material.CREDITA_COFINS = $('#cbCreditoCOFINS').prop('checked') == true ? 'S' : 'N';
                material.CREDITA_ICMS = $('#cbCreditoICMS').prop('checked') == true ? 'S' : 'N';
                material.CREDITA_IPI = $('#cbCreditoIPI').prop('checked') == true ? 'S' : 'N';
                material.CREDITA_PIS = $('#cbCreditoPIS').prop('checked') == true ? 'S' : 'N';
                material.EMP_ID = getCookie('emp_id');
                material.MVA = $('#txtMVA').val() == '' ? 0 : $('#txtMVA').val();

                material.PRECOCORES = retornaCoresGravar();

                material.PRECOQUEBRAS = retornaQuebrasGravar();

                material.PRECOAVIAMENTOS = retornaAviamentosGravar();

                const response = await requisicao("POST", `/sisplan/cadmatpreco/v1/gravadados?&CODUSUARIO=${getCookie('cod_usuario')}`, `&EMPRESA=${getCookie('empresa')}`, `JSON=${encodeURIComponent(JSON.stringify(material))}`);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgAlerta(jsonStr.mensagem);
                    return;
                }

                toastr.success("Dados gravados com sucesso!", "Confirmação", {
                    toastClass: "alert",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        window.location.href = `${BASE_URI}/cadmatpreco`;
                    },
                })
                    .css({
                        "margin-top": "20%",
                        width: "500px",
                        "max-width": "500px",
                    });

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível gravar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    function retornaCoresGravar() {

        const dados = $('#tabelaCores').DataTable().data();

        let json = [];

        let preco_compra = 0;

        dados.map(element => {
            preco_compra = element[5];

            if (dados.length == 1 && cus280_96 == 'S') {
                preco_compra = $('#txtPrecoCompra').val();
            }

            json.push({
                ID: element[0],
                ATIVO: element[1],
                COR: element[2],
                PRECO_TING: element[4],
                PRECO_COMPRA: preco_compra,
                PERC_DESP: element[6],
                PRECO: element[7],
                CODIGO: $('#txtCodigo').val(),
                EMP_ID: getCookie('emp_id')
            })
        })

        return json;
    };

    function retornaQuebrasGravar() {
        const dados = $('#tabelaQuebrasGravar').DataTable().data();

        let json = [];

        dados.map(element => {
            json.push({
                CODIGO: $('#txtCodigo').val(),
                ORDEM: element[0],
                MAT_QUEBRA: element[1],
                PERC_QUEBRA: element[4],
                EMP_ID: getCookie('emp_id')
            })
        });

        return json;
    }

    function retornaAviamentosGravar() {

        const dados = $('#tabelaAviamentos').DataTable().data();

        let json = [];

        dados.map(element => {
            json.push({
                ARTIGO: $('#txtCodigo').val(),
                ORDEM: element[0],
                CODIGO: element[1],
                MATERIAL: element[2],
                CUSTO: element[3],
                QUANTIDADE: element[4],
                VALOR: element[5],
                ACUMULADO: element[7],
                UNIDADE: element[7],
                QUEBRA: element[9],
                TAM: 0,
                EMP_ID: getCookie('emp_id')
            })
        });

        return json;
    };

    function preencheDadosQuebrasGravar(data) {

        $('#tabelaQuebrasGravar').DataTable().rows().remove();

        try {
            $.LoadingOverlay('show');
            try {
                for (let i = 0; i < data.length; i++) {
                    $('#tabelaQuebrasGravar').DataTable().row.add([
                        i + 1,
                        data[i].CODIGO,
                        data[i].DESCRICAO,
                        data[i].UNIDADE,
                        data[i].QUEBRA
                    ]).draw(false);
                }
            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $('#modalQuebras').modal('hide');
            $.LoadingOverlay('hide');
        }
    };

    try {
        $.LoadingOverlay('show');

        if (codMat != 'create') {
            await buscaDados();
            await buscaPrecoCores();
            await buscaQuebras();
            await buscaPrecoAviamentos();
        }
        criaTabela($('#tabelaCores'), [12, 13]);
        criaTabela($('#tabelaQuebrasGravar'));
        criaTabela($('#tabelaAviamentos'), null);
        await buscaUltimasCompras(codMat);
        await buscaFoto(codMat);
    } finally {
        $.LoadingOverlay('hide');
    }

    $('#txtGrupo').autocompleta(1, `JSON={ "tabela":"PRECO_GRUPO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtSetor').autocompleta(1, `JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);
    $('#txtParte').autocompleta(1, `JSON={ "tabela":"TIPO_APL", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`);

    $('#btnGrupo').pesquisa('#txtGrupo', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"PRECO_GRUPO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Grupo', '');
    $('#btnSetor').pesquisa('#txtSetor', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"CADFLUXO", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Setor', '');
    $('#btnParte').pesquisa('#txtParte', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TIPO_APL", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Parte', '');

    $('#btnAGrupo').on('click', function () {
        $('#txtGrupo').val('');
    });
    $('#btnASetor').on('click', function () {
        $('#txtSetor').val('');
    });
    $('#btnAParte').on('click', function () {
        $('#txtParte').val('');
    });

    function preencheDadosTabelaConIt(data) {
        $('#tabelaControleItens').DataTable().rows().remove().draw(false);
        if (data.length > 0) {
            for (let i = 0; i < data.length; i++) {
                $('#tabelaControleItens').DataTable().row.add([
                    data[i].ID,
                    data[i].ATIVO,
                    data[i].COR,
                    data[i].DESCRICAO,
                    parseFloat(data[i].PRECO_TING).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i].PRECO_TING).toFixed(6),
                    parseFloat(data[i].PRECO_COMPRA).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i].PRECO_COMPRA).toFixed(6),
                    parseFloat(data[i].PERC_DESP).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i].PERC_DESP).toFixed(6),
                    parseFloat(data[i].PRECO).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i].PRECO).toFixed(6),
                    data[i].PANTONE,
                    data[i].TINTURARIA,
                    data[i].NOME,
                    data[i].CODIGO2,
                    data[i].GRUPO,
                    data[i].DESC_GRUPO
                ]).draw(false);
            }
        }
    };

    $('#btnControleItens').on('click', async function () {

        try {

            $.LoadingOverlay('show');

            $('#modalControleItens').modal('show');

            $('#tituloControleItens').html(`[${codMat}] - ${$('#txtDescricao').val()}`);

            criaTabela($('#tabelaControleItens'), [9, 10, 11], [2]);
            const dados = $('#tabelaCores').DataTable().data();

            json = [];

            for (let i = 0; i < dados.length; i++) {

                json.push(
                    {
                        ID: dados[i][0],
                        ATIVO: dados[i][1],
                        COR: dados[i][2],
                        DESCRICAO: dados[i][3],
                        PRECO_TING: dados[i][4],
                        PRECO_COMPRA: dados[i][5],
                        PERC_DESP: dados[i][6],
                        PRECO: dados[i][7],
                        PANTONE: dados[i][8],
                        TINTURARIA: dados[i][9],
                        NOME: dados[i][10],
                        CODIGO2: dados[i][11],
                        GRUPO: dados[i][12],
                        DESC_GRUPO: dados[i][13]
                    })
            }

            $('#txtUtilizaFatConv').val($('#txtFatorConversao').val());

            preencheDadosTabelaConIt(json);

        } finally {
            $.LoadingOverlay('hide');
        }

    });

    $('#btnConsultarCI').on('click', async function () {

        filtraItensPorGrupo();
    });

    $('#tabelaControleItens').on('click', '#btn-alterar-ci', async function () {
        if ($('#tabelaControleItens').DataTable().data().length > 0) {
            habAlteracaoControleItens($("#tabelaControleItens").DataTable().row($(this).parents('tr')).data());
            $('#tabelaControleItens').DataTable().$('tr.selected').removeClass('selected');
            $(this).parents('tr').addClass('selected');
            $('.bodyModal').scrollTop(0);
        }
    });

    $('#tabelaControleItens').on('click', '#btn-excluir-ci', async function () {
        const linha = $('#tabelaControleItens').DataTable().$($(this).parents('tr'))[0]._DT_RowIndex;
        const data = $('#tabelaControleItens').DataTable().data();
        excluiLinhaControleItens(linha, data);
    });

    $('#btnDesistirCI').on('click', function () {
        desabAlteracaoControleItens();
    });

    $('#cbUtilizaFatConv').on('change', function () {
        const preco = calculaPrecoControleItens(
            $('#txtPrecoTingimentoCI').val(),
            $('#txtPrecoCompraCI').val(),
            $('#txtPercDespCI').val(),
            $('#txtUtilizaFatConv').val(),
            $('#cbUtilizaFatConv').prop('checked')
        )

        $('#txtPrecoCI').val(preco);
    });

    function habAlteracaoControleItens(linha) {
        if (inclusaoCI) {
            $('#cbAtivoCI').prop('checked', true);
            $('#precosTodosCI').addClass('d-none');
            $('#precosCI').removeClass('d-none');
            $('#btnIncluirCI').addClass('d-none');
            $('#btnExcluirCI').prop('disabled', false);
            $('#btnDesistirCI').removeClass('d-none');
            $('#btnConsultarCI').addClass('d-none');
            $('#btnAtualizarCoresCI').addClass('d-none');
            $('#grupoCI').addClass('d-none');
            $('#btnExcluirCI').addClass('d-none');
            $('#btnConfirmarCI').removeClass('d-none');
            $('#tabelaControleItens').prop('disabled', true);
            $('#txtCorCI').prop('disabled', false);
            $('#btnCorCI').prop('disabled', false);
        } else {
            $('#cbAtivoCI').prop('checked', linha[1] == 'S' ? true : false);
            $('#txtIdCI').val(linha[0]);
            insereValor('#txtCorCI', linha[2], linha[3]);
            $('#txtPantoneCI').val(linha[8]);
            $('#precosTodosCI').addClass('d-none');
            $('#precosCI').removeClass('d-none');
            $('#txtPrecoTingimentoCI').val(linha[4]);
            $('#txtPrecoCompraCI').val(linha[5]);
            $('#txtPrecoCI').val(linha[7]);
            $('#txtPercDespCI').val(linha[6]);
            $('#btnIncluirCI').addClass('d-none');
            $('#btnExcluirCI').prop('disabled', false);
            $('#btnDesistirCI').removeClass('d-none');
            $('#btnConsultarCI').addClass('d-none');
            $('#btnAtualizarCoresCI').addClass('d-none');
            $('#grupoCI').addClass('d-none');
            $('#btnConfirmarCI').removeClass('d-none');
            $('#btnPesquisaPrecoTinCI').prop('disabled', false);

            $('#btnPesquisaPrecoTinCI').pesquisa_serverside(['#txtPrecoTingimentoCI'],
                ['CUSTO'], ['CUSTO'],
                `{"tabela":"TINTUR_ITEN",
                "camposSelect":[ "TINTURARIA", "NOME", "CUSTO"],
                "innerjoin": [{
                    "tabela": "TINTUR", "condicao": "TINTUR_ITEN.NUMERO = TINTUR.NUMERO"
                }],
                "leftjoin": [{
                    "tabela": "ENTIDADE", "condicao": "TINTUR.TINTURARIA = ENTIDADE.CODCLI"
                },
                {
                    "tabela": "FLUXO", "condicao": "TINTUR_ITEN.FLUXO = FLUXO.CODIGO"
                }],
                "where": ["TINTUR_ITEN.CODIGO_ENTRADA = '${codMat}'", "TINTUR_ITEN.COR = '${pegaChave('#txtCorCI')}'"],
                "orderby": ["TINTUR.TINTURARIA ASC"]}`, 'Pesquisa Custo', null, [true]);
        }
        $('#cbUtilizaFatConv').prop('disabled', false);
        $('#btnGravarControleItens').addClass('d-none');
    };

    function desabAlteracaoControleItens() {
        $('#tabelaControleItens').DataTable().$('tr.selected').removeClass('selected');
        $('#cbAtivoCI').prop('checked', false);
        $('#txtIdCI').val('');
        $('#txtCorCI').val('');
        $('#txtPrecoTingimentoCI').val('');
        $('#txtPrecoCompraCI').val('');
        $('#txtPercDespCI').val('');
        $('#txtPrecoCI').val('');
        $('#txtPantoneCI').val('');
        $('#precosTodosCI').removeClass('d-none');
        $('#precosCI').addClass('d-none');
        $('#btnIncluirCI').removeClass('d-none');
        $('#btnExcluirCI').prop('disabled', true);
        $('#btnDesistirCI').addClass('d-none');
        $('#btnConsultarCI').removeClass('d-none');
        $('#btnAtualizarCoresCI').removeClass('d-none');
        $('#grupoCI').removeClass('d-none');
        $('#txtPrecoTingimentoTodosCI').val('');
        $('#txtPrecoCompraTodosCI').val('');
        $('#txtPrecoTodosCI').val('');
        $('#txtPercDesperdicioTodosCI').val('');
        if (inclusaoCI) {
            $('#tabelaControleItens').prop('disabled', false)
            $('#btnExcluirCI').removeClass('d-none');
            $('#txtCorCI').prop('disabled', true);
            $('#btnCorCI').prop('disabled', true);
            $('#txtIdCI').prop('placeholder', 'ID');
            inclusaoCI = false;
        }
        $('#btnConfirmarCI').addClass('d-none');
        $('#cbUtilizaFatConv').prop('disabled', true);
        $('#btnGravarControleItens').removeClass('d-none');
        $('#btnPesquisaPrecoTinCI').prop('disabled', true);
    };

    $('#btnIncluirCI').on('click', function () {
        inclusaoCI = true;
        habAlteracaoControleItens(null);
    });

    $('#btnPrecoTingimentoTodosCI').on('click', function () {
        atualizaPrecoTodosCI(4, pegaChave('#txtGrupoCI'));
    });

    $('#btnPrecoCompraTodosCI').on('click', function () {
        atualizaPrecoTodosCI(5, pegaChave('#txtGrupoCI'));
    });

    $('#btnPrecoTodosCI').on('click', function () {
        atualizaPrecoTodosCI(7, pegaChave('#txtGrupoCI'));
    });

    $('#btnPercDesperdicioTodosCI').on('click', function () {
        atualizaPrecoTodosCI(6, pegaChave('#txtGrupoCI'));
    });

    function atualizaPrecoTodosCI(coluna, grupo) {

        try {
            $.LoadingOverlay('show');

            try {
                if (coluna == undefined) {
                    return;
                }
                let valorCampo = '';
                let preco = 0;

                if (coluna == 4) {
                    valorCampo = $('#txtPrecoTingimentoTodosCI').val()
                } else if (coluna == 5) {
                    valorCampo = $('#txtPrecoCompraTodosCI').val();
                } else if (coluna == 7) {
                    valorCampo = $('#txtPrecoTodosCI').val();
                } else if (coluna == 6) {
                    valorCampo = $('#txtPercDesperdicioTodosCI').val();
                } else {
                    return;
                }


                if (valorCampo == '') {
                    valorCampo = '0';
                }

                valorCampo = valorCampo.replace(',', '.');

                const data = $('#tabelaControleItens').DataTable().data();
                data.rows().remove();

                if (grupo != '' && grupo != undefined && grupo != null) {
                    for (let i = 0; i < data.length; i++) {

                        data[i][coluna] = parseFloat(valorCampo);

                        if (data[i][12] == grupo) {
                            if (coluna != 7) {
                                preco = calculaPrecoControleItens(
                                    data[i][4],
                                    data[i][5],
                                    data[i][6],
                                    0,
                                    'N');
                            } else {
                                preco = parseFloat(valorCampo).toFixed(6) == 'NaN' ? 0 : parseFloat(valorCampo).toFixed(6);
                            }

                        }

                        $('#tabelaControleItens').DataTable().row.add([
                            data[i][0],
                            data[i][1],
                            data[i][2],
                            data[i][3],
                            parseFloat(data[i][4]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][4]).toFixed(6),
                            parseFloat(data[i][5]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][5]).toFixed(6),
                            parseFloat(data[i][6]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][6]).toFixed(6),
                            preco,
                            data[i][8],
                            data[i][9],
                            data[i][10],
                            data[i][11],
                            data[i][12],
                            data[i][13]
                        ]).draw(false);
                    }
                } else {
                    for (let i = 0; i < data.length; i++) {

                        data[i][coluna] = parseFloat(valorCampo);

                        if (coluna != 7) {
                            preco = calculaPrecoControleItens(
                                data[i][4],
                                data[i][5],
                                data[i][6],
                                0,
                                'N');
                        } else {
                            preco = parseFloat(valorCampo).toFixed(6) == 'NaN' ? 0 : parseFloat(valorCampo).toFixed(6);
                        }

                        $('#tabelaControleItens').DataTable().row.add([
                            data[i][0],
                            data[i][1],
                            data[i][2],
                            data[i][3],
                            parseFloat(data[i][4]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][4]).toFixed(6),
                            parseFloat(data[i][5]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][5]).toFixed(6),
                            parseFloat(data[i][6]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][6]).toFixed(6),
                            preco,
                            data[i][8],
                            data[i][9],
                            data[i][10],
                            data[i][11],
                            data[i][12],
                            data[i][13]
                        ]).draw(false);
                    }
                }
            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }

    };

    $('#btnConfirmarCI').on('click', async function () {

        let linha = null;

        if (!inclusaoCI) {
            linha = $('#tabelaControleItens').DataTable().$('tr.selected')[0]._DT_RowIndex;
        }
        const data = $('#tabelaControleItens').DataTable().data();

        if ($('#txtCorCI').val() == '') {
            msgErro('É necessário informar uma cor, favor verificar.');
            return;
        }

        let corExistente = false;
        const corInclusa = pegaChave('#txtCorCI');

        if (data.length > 0) {
            for (let i = 0; i < data.length; i++) {
                if (data[i][2] == corInclusa) {
                    corExistente = true;
                }
            }
        }

        if (corExistente && inclusaoCI) {
            msgErro('Cor já Informada para o material, favor verificar.');
            return;
        }

        await confirmaAltControleItens(data, linha)
        desabAlteracaoControleItens();

    });

    $('#txtPrecoTingimentoCI').on('blur', function () {
        const preco = calculaPrecoControleItens(
            $('#txtPrecoTingimentoCI').val(),
            $('#txtPrecoCompraCI').val(),
            $('#txtPercDespCI').val(),
            $('#txtUtilizaFatConv').val(),
            $('#cbUtilizaFatConv').prop('checked')
        );

        $('#txtPrecoCI').val(preco);
    });

    $('#txtPrecoCompraCI').on('blur', function () {
        const preco = calculaPrecoControleItens(
            $('#txtPrecoTingimentoCI').val(),
            $('#txtPrecoCompraCI').val(),
            $('#txtPercDespCI').val(),
            $('#txtUtilizaFatConv').val(),
            $('#cbUtilizaFatConv').prop('checked')
        );

        $('#txtPrecoCI').val(preco);
    });

    $('#txtPercDespCI').on('blur', function () {
        const preco = calculaPrecoControleItens(
            $('#txtPrecoTingimentoCI').val(),
            $('#txtPrecoCompraCI').val(),
            $('#txtPercDespCI').val(),
            $('#txtUtilizaFatConv').val(),
            $('#cbUtilizaFatConv').prop('checked')
        );

        $('#txtPrecoCI').val(preco);
    });

    function calculaPrecoControleItens(precoTin, precoCom, percDesp, divisor, calculaDivisor) {

        try {

            if (divisor < 0.000001) {
                divisor = 1;
            };

            if (precoTin == '') {
                precoTin = 0;
            }

            if (typeof precoTin == 'string') {
                precoTin = precoTin.replace(',', '.');
            }

            precoTin = parseFloat(precoTin);

            if (precoCom == '') {
                precoCom = 0;
            }

            if (typeof precoCom == 'string') {
                precoCom = precoCom.replace(',', '.');
            }

            precoCom = parseFloat(precoCom);

            if (percDesp == '') {
                percDesp = 0;
            }

            if (typeof percDesp == 'string') {
                percDesp = percDesp.replace(',', '.');
            }

            percDesp = parseFloat(percDesp);

            let preco = precoCom + precoTin;

            if (cus280_32 == 'S') {
                preco = precoCom + (precoTin * piscofins);
            }

            if (cus280_18 == 'S') {
                preco = preco * impostos;
            }

            if (preco > 0) {
                if (calculaDivisor) {
                    preco = preco / divisor;
                }

                if (cus280_10 == 'S') {
                    preco = preco / ((100 - percDesp) / 100);
                } else {
                    preco = preco + (preco * (percDesp / 100));
                }
            }

            return preco.toFixed(6);

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        }

    }

    async function confirmaAltControleItens(data, linha) {

        try {
            $.LoadingOverlay('show');
            try {
                if (!data) {
                    return;
                }

                const info = await retornaDadosCor(pegaChave('#txtCorCI'));

                data.rows().remove();
                if (inclusaoCI) {
                    data.unshift([
                        $('#txtIdCI').val(),
                        $('#cbAtivoCI').prop('checked') == true ? 'S' : 'N',
                        pegaChave('#txtCorCI'),
                        pegaDescricao('#txtCorCI'),
                        $('#txtPrecoTingimentoCI').val() == '' ? 0.00 : parseFloat(($('#txtPrecoTingimentoCI').val()).replace(',', '.')),
                        $('#txtPrecoCompraCI').val() == '' ? 0.00 : parseFloat(($('#txtPrecoCompraCI').val()).replace(',', '.')),
                        $('#txtPercDespCI').val() == '' ? 0.00 : parseFloat(($('#txtPercDespCI').val()).replace(',', '.')),
                        $('#txtPrecoCI').val() == '' ? 0.00 : parseFloat(($('#txtPrecoCI').val()).replace(',', '.')),
                        $('#txtPantoneCI').val(),
                        info == undefined ? '' : info.TINTURARIA,
                        info == undefined ? '' : info.NOME,
                        info == undefined ? '' : info.CODIGO2,
                        info == undefined ? '' : info.GRUPO,
                        info == undefined ? '' : info.DESCRICAO
                    ]);
                } else {
                    data[linha][0] = data[linha][0];
                    data[linha][1] = $('#cbAtivoCI').prop('checked') == true ? 'S' : 'N';
                    data[linha][2] = data[linha][2];
                    data[linha][3] = data[linha][3];
                    data[linha][4] = $('#txtPrecoTingimentoCI').val() == '' ? 0.00 : parseFloat(($('#txtPrecoTingimentoCI').val()).replace(',', '.'));
                    data[linha][5] = $('#txtPrecoCompraCI').val() == '' ? 0.00 : parseFloat(($('#txtPrecoCompraCI').val()).replace(',', '.'));
                    data[linha][6] = $('#txtPercDespCI').val() == '' ? 0.00 : parseFloat(($('#txtPercDespCI').val()).replace(',', '.'));
                    data[linha][7] = $('#txtPrecoCI').val() == '' ? 0.00 : parseFloat(($('#txtPrecoCI').val()).replace(',', '.'));
                    data[linha][8] = data[linha][8];
                    data[linha][9] = data[linha][9];
                    data[linha][10] = data[linha][10];
                    data[linha][11] = data[linha][11];
                    data[linha][12] = data[linha][12];
                    data[linha][13] = data[linha][13];
                }

                for (let i = 0; i < data.length; i++) {
                    $('#tabelaControleItens').DataTable().row.add([
                        data[i][0],
                        data[i][1],
                        data[i][2],
                        data[i][3],
                        parseFloat(data[i][4]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][4]).toFixed(6),
                        parseFloat(data[i][5]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][5]).toFixed(6),
                        parseFloat(data[i][6]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][6]).toFixed(6),
                        parseFloat(data[i][7]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][7]).toFixed(6),
                        data[i][8],
                        data[i][9],
                        data[i][10],
                        data[i][11],
                        data[i][12],
                        data[i][13]
                    ]).draw(false);
                }
            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível gravar os dados: ${error}`);
            }
        } finally {
            $('#txtPrecoTingimentoCI').val('');
            $('#txtPrecoCompraCI').val('');
            $('#txtPercDespCI').val('');
            $.LoadingOverlay('hide');
        }
    };

    function excluiLinhaControleItens(linha, data) {

        try {
            $.LoadingOverlay('show');
            try {
                data.rows().remove().draw(false);

                data.splice(linha, 1);

                if (data.length > 0) {
                    for (let i = 0; i < data.length; i++) {
                        $('#tabelaControleItens').DataTable().row.add([
                            data[i][0],
                            data[i][1],
                            data[i][2],
                            data[i][3],
                            parseFloat(data[i][4]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][4]).toFixed(6),
                            parseFloat(data[i][5]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][5]).toFixed(6),
                            parseFloat(data[i][6]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][6]).toFixed(6),
                            parseFloat(data[i][7]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][7]).toFixed(6),
                            data[i][8],
                            data[i][9],
                            data[i][10],
                            data[i][11],
                            data[i][12],
                            data[i][13]
                        ]).draw(false);
                    }
                } else {
                    $('#tabelaControleItens').DataTable().draw(false);
                }

                desabAlteracaoControleItens();
            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível excluir o registro: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function retornaDadosCor(cor) {

        const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
            `JSON={ "tabela":"CADCOR",
                "camposSelect":["CADCOR.GRUPO, GRUPO_COR.DESCRICAO, CADCOR.TINTURARIA, ENTIDADE.NOME, CADCOR.CODIGO2"],
                "leftjoin": [
                    {"tabela": "GRUPO_COR", "condicao": "CADCOR.GRUPO = GRUPO_COR.CODIGO"},
                    {"tabela": "ENTIDADE", "condicao": "CADCOR.TINTURARIA = ENTIDADE.CODCLI"}
                ],
                "where": ["CADCOR.COR = '${cor}'"]}`, null);

        if (!response) {
            return;
        }

        let jsonStr = await response.json();
        if (response.status != 200) {
            msgErro(jsonStr.RESULT[0].mensagem);
            return;
        }

        if (jsonStr.RESULT[0].length == 0) {
            return;
        }

        return jsonStr.RESULT[0][0];

    };

    $('#btnAtualizarCoresCI').on('click', async function () {
        const cores = await buscaNovasCores(codMat);
        insereNovasCores(cores);
    });

    async function buscaNovasCores(codigo) {

        try {
            try {
                $.LoadingOverlay('show');

                const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"MAT_ITEN",
                "camposSelect":["DISTINCT MAT_ITEN.ATIVO, MAT_ITEN.CODIGO, MATERIAL.DESCRICAO, MAT_ITEN.COR, CADCOR.DESCRICAO AS DESC_COR,
                MAT_ITEN.PRECO_MED AS PRECO, CADCOR.PANTONE, CADCOR.GRUPO, GRUPO_COR.DESCRICAO AS DESC_GRUPO, CADCOR.TINTURARIA, ENTIDADE.NOME, CADCOR.CODIGO2"],
                "innerjoin": [
                    {"tabela": "MATERIAL", "condicao": "MAT_ITEN.CODIGO = MATERIAL.CODIGO"},
                    {"tabela": "CADCOR", "condicao": "MAT_ITEN.COR = CADCOR.COR"},
                    {"tabela": "GRUPO_COR", "condicao": "CADCOR.GRUPO = GRUPO_COR.CODIGO"}],
                "leftjoin": [
                    {"tabela": "ENTIDADE", "condicao": "CADCOR.TINTURARIA = ENTIDADE.CODCLI"}    
                ],
                "where": ["MAT_ITEN.CODIGO = '${codigo}'", "MAT_ITEN.ATIVO IS NOT NULL"]}`, null);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                jsonStr = jsonStr.RESULT[0];

                jsonStr.map(element => {
                    if (element.ATIVO == '') {
                        element.ATIVO = 'S';
                    }

                    if (cus280_19 == 'S') {
                        element.PRECO_COMPRA = element.PRECO
                    } else {
                        element.PRECO_COMPRA = 0;
                    }
                })

                return jsonStr;

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    function insereNovasCores(cores) {

        if (cores == '' || cores == undefined) {
            return;
        };

        listaCores = [];
        cores.map(element => {
            listaCores.push([
                '',
                element.ATIVO,
                element.COR,
                element.DESC_COR,
                element.PRECO,
                0,
                element.PRECO_COMPRA,
                0,
                element.PANTONE,
                element.TINTURARIA,
                element.NOME,
                element.CODIGO2,
                element.GRUPO,
                element.DESC_GRUPO
            ])
        });

        let arrayCores = [];

        let arrayIndices = [];

        for (let i = 0; i < listaCores.length; i++) {
            if (arrayCores.indexOf(listaCores[i][2]) == -1) {
                arrayCores.push(listaCores[i][2]);
                arrayIndices.push(i);
            }
        };

        const data = $('#tabelaControleItens').DataTable().data();
        data.rows().remove();

        arrayCores = [];

        for (let i = 0; i < data.length; i++) {
            arrayCores.push(data[i][2]);

        }

        for (i in arrayIndices) {
            if ((arrayCores.indexOf(listaCores[arrayIndices[i]][2]) == -1)) {
                data.unshift(
                    listaCores[arrayIndices[i]]
                );
            }
        }

        data.map(element => {
            $('#tabelaControleItens').DataTable().row.add([
                element[0],
                element[1],
                element[2],
                element[3],
                parseFloat(element[4]).toFixed(6) == 'NaN' ? 0 : parseFloat(element[4]).toFixed(6),
                parseFloat(element[5]).toFixed(6) == 'NaN' ? 0 : parseFloat(element[5]).toFixed(6),
                parseFloat(element[6]).toFixed(6) == 'NaN' ? 0 : parseFloat(element[6]).toFixed(6),
                parseFloat(element[7]).toFixed(6) == 'NaN' ? 0 : parseFloat(element[7]).toFixed(6),
                element[8],
                element[9],
                element[10],
                element[11],
                element[12],
                element[13]
            ]).draw(false);
        })

    };

    $('#btnGravarControleItens').on('click', function () {

        if ($('#tabelaControleItens').DataTable().data().length == 0) {
            msgErro('Não há nenhum dado a ser gravado, favor verificar.');
            return;
        }

        const data = $('#tabelaControleItens').DataTable().data();
        atualizaTabelaCores(data);

    });

    function atualizaTabelaCores(data) {

        try {

            $.LoadingOverlay('show');
            try {
                let dados = [];

                for (let i = 0; i < data.length; i++) {
                    dados.push(
                        {
                            ID: data[i][0],
                            ATIVO: data[i][1],
                            COR: data[i][2],
                            DESCRICAO: data[i][3],
                            PRECO_TING: data[i][4],
                            PRECO_COMPRA: data[i][5],
                            PERC_DESP: data[i][6],
                            PRECO: data[i][7],
                            PANTONE: data[i][8],
                            TINTURARIA: data[i][9],
                            NOME: data[i][10],
                            CODIGO2: data[i][11],
                            GRUPO: data[i][12],
                            DESC_GRUPO: data[i][13]
                        }
                    )
                }

                $('#tabelaCores').DataTable().data().rows().remove();
                preencheDadosTabelaCores(dados);

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        }
        finally {
            $('#modalControleItens').modal('hide');
            $.LoadingOverlay('hide');
        }
    }


    $('#modalControleItens').on('hide.bs.modal', function () {
        $('#tabelaControleItens').DataTable().data().rows().remove();
        $('.bodyModal').scrollTop(0);
        desabAlteracaoControleItens();
    });

    function filtraItensPorGrupo() {

        try {
            $.LoadingOverlay('show');

            try {

                const grupo = pegaChave('#txtGrupoCI');
                $('#tabelaControleItens').DataTable().columns(12).search(grupo).draw();

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#btnFecharControleItens').on('click', function () {
        if ($('#tabelaControleItens').DataTable().data().length != $('#tabelaCores').DataTable().data().length) {
            msgAlerta('Podem haver informações não gravadas, deseja continuar?', () => {
                $('#modalControleItens').modal('hide');
            });
        } else {
            $('#modalControleItens').modal('hide');
        }
    });

    $('#txtCorCI').autocompleta(1, `JSON={ "tabela":"CADCOR", "camposSelect":[ "COR CHAVE, DESCRICAO DESCRICAO, PANTONE"], "where": [] }`, ['#txtPantoneCI'], ['PANTONE'], ['PANTONE'], null, [true]);
    $('#txtGrupoCI').autocompleta(1, `JSON={ "tabela":"GRUPO_COR", "camposSelect":[ "CODIGO CHAVE", "DESCRICAO DESCRICAO"], "where": null}`, null, null, null);

    $('#btnGrupoCI').pesquisa_serverside(['#txtGrupoCI'], ['CODIGO'], ['DESCRICAO'], '{"tabela":"GRUPO_COR", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": null}', 'Pesquisa Grupo');

    $('#btnCorCI').pesquisa_serverside(['#txtCorCI', '#txtPantoneCI'], ['COR', 'PANTONE'], ['DESCRICAO', 'PANTONE'], '{"tabela":"CADCOR", "camposSelect":[ "COR", "DESCRICAO", "PANTONE"], "where": null}', 'Pesquisa Cor', null, [false, true]);

    $('#btnAGrupoCI').on('click', async function () {
        $('#txtGrupoCI').val('');
    });

    $('#txtCorCI').on('blur', async function () {
        if (inclusaoCI) {
            const dadosSelect = {
                tabela: `MAT_ITEN`,
                camposSelect: [`MAX(PRECO_MED) PRECO_MED`],
                where: [`CODIGO = '${codMat}'`, `COR = '${pegaChave('#txtCorCI')}'`],
            };
            const retornoSelect = await retornaJsonPesquisaPadrao(
                JSON.stringify(dadosSelect)
            );

            $('#txtPrecoCI').val(retornoSelect[0].PRECO_MED);
        }

        if ($('#txtCorCI').val() != '') {
            $('#btnPesquisaPrecoTinCI').prop('disabled', false);
        }

        $('#btnPesquisaPrecoTinCI').pesquisa_serverside(['#txtPrecoTingimentoCI'],
            ['CUSTO'], ['CUSTO'],
            `{"tabela":"TINTUR_ITEN",
                "camposSelect":[ "TINTURARIA", "NOME", "CUSTO"],
                "innerjoin": [{
                    "tabela": "TINTUR", "condicao": "TINTUR_ITEN.NUMERO = TINTUR.NUMERO"
                }],
                "leftjoin": [{
                    "tabela": "ENTIDADE", "condicao": "TINTUR.TINTURARIA = ENTIDADE.CODCLI"
                },
                {
                    "tabela": "FLUXO", "condicao": "TINTUR_ITEN.FLUXO = FLUXO.CODIGO"
                }],
                "where": ["TINTUR_ITEN.CODIGO_ENTRADA = '${codMat}'", "TINTUR_ITEN.COR = '${pegaChave('#txtCorCI')}'"],
                "orderby": ["TINTUR.TINTURARIA ASC"]}`, 'Pesquisa Custo', null, [true]);

    });


    async function buscaQuebras() {

        try {
            $.LoadingOverlay('show');
            try {
                const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"MATPRECOQUEBRA",
                "camposSelect":["MATPRECOQUEBRA.MAT_QUEBRA CODIGO", "MATPRECOQUEBRA.PERC_QUEBRA QUEBRA", "MATPRECOQUEBRA.ORDEM",
                                "MATERIAL.DESCRICAO", "MATERIAL.UNIDADE"], 
                "leftjoin": [
                            {"tabela" : "MATERIAL", "condicao" : "MATPRECOQUEBRA.MAT_QUEBRA = MATERIAL.CODIGO"} ],                            
                "where": ["MATPRECOQUEBRA.CODIGO = '${codMat}'"],
                "orderby": ["MATPRECOQUEBRA.ORDEM"]}`,
                )

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }


                const data = jsonStr.RESULT[0];

                preencheDadosQuebrasGravar(data);

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }

    };

    $('#btnQuebras').on('click', async function () {

        try {

            $.LoadingOverlay('show');

            $('#modalQuebras').modal('show');

            $('#tituloQuebras').html(`[${codMat}] - ${$('#txtDescricao').val()}`);

            criaTabela($('#tabelaQuebras'), null, [0]);
            const dados = $('#tabelaQuebrasGravar').DataTable().data();

            for (let i = 0; i < dados.length; i++) {
                $('#tabelaQuebras').DataTable().row.add([
                    dados[i][0],
                    dados[i][1],
                    dados[i][2],
                    dados[i][3],
                    dados[i][4]
                ]).draw(false);
            }
        } finally {
            $.LoadingOverlay('hide');
        }

    });

    // $('#tabelaQuebras tbody').unbind('click');
    // $('#tabelaQuebras tbody').on('click', 'tr', async function () {
    //     if ($('#tabelaQuebras').DataTable().data().length > 0) {
    //         $('#tabelaQuebras').DataTable().$('tr.selected').removeClass('selected');
    //         $(this).addClass('selected');
    //         await habAlteracaoQuebras($("#tabelaQuebras").DataTable().row($(this)).data());
    //     }
    // });

    $('#btnDesistirQuebras').on('click', async function () {
        await desabAlteracaoQuebras();
    });

    async function habAlteracaoQuebras(linha) {

        const data = $('#tabelaQuebras').DataTable().data();
        let ordens = [];

        for (let i = 0; i < data.length; i++) {
            ordens.push(data[i][0]);
        }

        let novaOrdem = null;

        if (ordens.length > 0) {
            novaOrdem = (Math.max(...ordens)) + 1;
        } else {
            novaOrdem = 1;
        }

        if (inclusaoQuebras) {
            $('#btnIncluirQuebras').addClass('d-none');
            $('#btnConfirmarQuebras').removeClass('d-none');
            $('#btnDesistirQuebras').removeClass('d-none');
            $('#btnExcluirQuebras').prop('disabled', false);
            $('#txtOrdemQuebras').val(novaOrdem);
            $('#txtCodigoQuebras').val('');
            $('#txtUnidadeQuebras').val('');
            $('#txtQuebraQuebras').val('');
            $('#txtOrdemQuebras').prop('disabled', false);
            $('#txtCodigoQuebras').prop('disabled', false);
            $('#btnCodigoQuebras').prop('disabled', false);
            $('#btnACodigoQuebras').prop('disabled', false);
            $('#txtQuebraQuebras').prop('disabled', false);
        } else {
            $('#btnIncluirQuebras').addClass('d-none');
            $('#btnConfirmarQuebras').removeClass('d-none');
            $('#btnDesistirQuebras').removeClass('d-none');
            $('#btnExcluirQuebras').prop('disabled', false);
            $('#txtOrdemQuebras').val(linha[0]);
            insereValor('#txtCodigoQuebras', linha[1], linha[2]);
            $('#txtUnidadeQuebras').val(linha[3]);
            $('#txtQuebraQuebras').val(linha[4]);
            $('#txtOrdemQuebras').prop('disabled', false);
            $('#txtCodigoQuebras').prop('disabled', false);
            $('#btnCodigoQuebras').prop('disabled', false);
            $('#btnACodigoQuebras').prop('disabled', false);
            $('#txtQuebraQuebras').prop('disabled', false);
        }

        $('#btnGravarQuebras').addClass('d-none');
    }

    async function desabAlteracaoQuebras() {
        if (inclusaoQuebras) {
            inclusaoQuebras = false;
        }
        $('#tabelaQuebras').DataTable().$('tr.selected').removeClass('selected');
        $('#btnIncluirQuebras').removeClass('d-none');
        $('#btnConfirmarQuebras').addClass('d-none');
        $('#btnDesistirQuebras').addClass('d-none');
        $('#btnExcluirQuebras').prop('disabled', true);
        $('#txtOrdemQuebras').val('');
        $('#txtCodigoQuebras').val('');
        $('#txtUnidadeQuebras').val('');
        $('#txtQuebraQuebras').val('');
        $('#txtOrdemQuebras').prop('disabled', true);
        $('#txtCodigoQuebras').prop('disabled', true);
        $('#btnCodigoQuebras').prop('disabled', true);
        $('#btnACodigoQuebras').prop('disabled', true);
        $('#txtUnidadeQuebras').prop('disabled', true);
        $('#txtQuebraQuebras').prop('disabled', true);
        $('#btnGravarQuebras').removeClass('d-none');
    }

    $('#btnIncluirQuebras').on('click', async function () {
        inclusaoQuebras = true;
        await habAlteracaoQuebras();
    })

    // $('#btnExcluirQuebras').on('click', async function () {

    //     const linha = $('#tabelaQuebras').DataTable().$('tr.selected')[0]._DT_RowIndex
    //     const data = $('#tabelaQuebras').DataTable().data();
    //     await excluiLinhaQuebras(linha, data)
    // });

    $('#tabelaQuebras').on('click', '#btn-excluir-quebras', async function () {
        const linha = $('#tabelaQuebras').DataTable().$($(this).parents('tr'))[0]._DT_RowIndex;
        const data = $('#tabelaQuebras').DataTable().data();
        await excluiLinhaQuebras(linha, data);
    });

    $('#tabelaQuebras').on('click', '#btn-alterar-quebras', async function () {
        if ($('#tabelaQuebras').DataTable().data().length > 0) {
            await habAlteracaoQuebras($("#tabelaQuebras").DataTable().row($(this).parents('tr')).data());
            $('#tabelaQuebras').DataTable().$('tr.selected').removeClass('selected');
            $(this).parents('tr').addClass('selected');
            $('.bodyModal').scrollTop(0);
        }
    });

    async function excluiLinhaQuebras(linha, data) {

        try {
            $.LoadingOverlay('show');
            try {
                data.rows().remove();
                data.splice(linha, 1);

                if (data.length > 0) {
                    for (let i = 0; i < data.length; i++) {
                        $('#tabelaQuebras').DataTable().row.add([
                            data[i][0],
                            data[i][1],
                            data[i][2],
                            data[i][3],
                            data[i][4]
                        ]).draw(false);
                    }
                } else {
                    $('#tabelaQuebras').DataTable().draw(false);
                }

                await desabAlteracaoQuebras();

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível excluir o registro: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $('#btnConfirmarQuebras').on('click', async function () {

        let linha = null;

        if (!inclusaoQuebras) {
            linha = $('#tabelaQuebras').DataTable().$('tr.selected')[0]._DT_RowIndex
        }
        const data = $('#tabelaQuebras').DataTable().data();

        if ($('#txtCodigoQuebras').val() == '') {
            msgErro('É necessário informar um material, favor verificar.');
            return;
        }

        await confirmaAltQuebras(data, linha);
        await desabAlteracaoQuebras();

    });

    async function confirmaAltQuebras(data, linha) {
        try {
            $.LoadingOverlay('show');
            try {
                if (!data) {
                    return;
                }

                data.rows().remove();
                if (inclusaoQuebras) {
                    data.push([
                        $('#txtOrdemQuebras').val(),
                        pegaChave('#txtCodigoQuebras'),
                        pegaDescricao('#txtCodigoQuebras'),
                        $('#txtUnidadeQuebras').val(),
                        $('#txtQuebraQuebras').val() == '' ? 0.00 : parseFloat($('#txtQuebraQuebras').val())
                    ]);
                } else {
                    data[linha][0] = $('#txtOrdemQuebras').val();
                    data[linha][1] = pegaChave('#txtCodigoQuebras');
                    data[linha][2] = pegaDescricao('#txtCodigoQuebras');
                    data[linha][3] = $('#txtUnidadeQuebras').val();
                    data[linha][4] = $('#txtQuebraQuebras').val() == '' ? 0.00 : parseFloat($('#txtQuebraQuebras').val());
                }

                for (let i = 0; i < data.length; i++) {
                    $('#tabelaQuebras').DataTable().row.add([
                        data[i][0],
                        data[i][1],
                        data[i][2],
                        data[i][3],
                        data[i][4]
                    ]).draw(false);
                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#btnGravarQuebras').on('click', async function () {

        const data = $('#tabelaQuebras').DataTable().data();

        let json = [];

        data.map(element => {
            json.push({
                ORDEM: element[0],
                CODIGO: element[1],
                DESCRICAO: element[2],
                UNIDADE: element[3],
                QUEBRA: element[4]
            })
        })

        preencheDadosQuebrasGravar(json);
    });

    $('#modalQuebras').on('hide.bs.modal', async function () {
        $('#tabelaQuebras').DataTable().data().rows().remove();
        $('.bodyModal').scrollTop(0);
        await desabAlteracaoQuebras();
    });

    $('#btnFecharQuebras').on('click', async function () {
        if ($('#tabelaQuebras').DataTable().data().length != $('#tabelaQuebrasGravar').DataTable().data().length) {
            msgAlerta('Podem haver informações não gravadas, deseja continuar?', async () => {
                $('#tabelaQuebras').DataTable().data().rows().remove();
                $('#modalQuebras').modal('hide');
            });
        } else {
            $('#modalQuebras').modal('hide');
        }
    });

    $('#txtCodigoQuebras').autocompleta(1, `JSON={ "tabela":"MATERIAL", "camposSelect":[ "CODIGO CHAVE, DESCRICAO DESCRICAO, UNIDADE"], "where": [] }`, ['#txtUnidadeQuebras'], ['UNIDADE'], ['UNIDADE'], null, [true]);

    $('#btnCodigoQuebras').pesquisa_serverside(['#txtCodigoQuebras', '#txtUnidadeQuebras'], ['CODIGO', 'UNIDADE'], ['DESCRICAO', 'UNIDADE'], '{"tabela":"MATERIAL", "camposSelect":[ "CODIGO", "DESCRICAO", "UNIDADE"], "where": null}', 'Pesquisa Material', null, [false, true]);

    $('#btnACodigoQuebras').on('click', async function () {
        $('#txtCodigoQuebras').val('');
    });

    async function buscaPrecoTin(codigo, cliente) {

        try {
            const response = await requisicao("GET", "/sisplan/cadmatpreco/v1/buscaprecotin?", `CODIGO=${codigo}&CODCLI=${cliente}`);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }


            return jsonStr;
        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        }

    };

    $('#btnPrecoTinturaria').on('click', async function () {

        $('#modalPrecoTin').modal('show');

        $('#tituloPrecoTin').html(`[${codMat}] - ${$('#txtDescricao').val()}`);

        criaTabela($('#tabelaPrecoTin'), [5, 6, 7, 8, 9, 10], [0]);

        if (cus280_91 != 'S') {
            $('#btnConsultarPrecoTin').trigger('click');
        }

    });

    $('#tabelaPrecoTin').on('click', '#btn-alterar-precotin', async function () {
        if ($('#tabelaPrecoTin').DataTable().data().length > 0) {
            $('#tabelaPrecoTin').DataTable().$('tr.selected').removeClass('selected');
            $(this).parents('tr').addClass('selected');
            await habAlteracaoPrecoTin($("#tabelaPrecoTin").DataTable().row($(this).parents('tr')).data());
            $('.bodyModal').scrollTop(0);
        }
    });

    $('#btnDesistirPrecoTin').on('click', async function () {
        await desabAlteracaoPrecoTin();
    });

    async function habAlteracaoPrecoTin(linha) {
        $('#txtPrecoNovoPrecoTin').prop('disabled', false);
        $('#txtPrecoNovoPrecoTin').val(linha[4]);
        $('#btnConfirmarPrecoTin').removeClass('d-none');
        $('#btnDesistirPrecoTin').removeClass('d-none');
        $('#btnGravarPrecoTin').addClass('d-none');
    };

    async function desabAlteracaoPrecoTin() {
        $('#tabelaPrecoTin').DataTable().$('tr.selected').removeClass('selected');
        $('#txtPrecoNovoPrecoTin').prop('disabled', true);
        $('#txtPrecoNovoPrecoTin').val('');
        $('#btnConfirmarPrecoTin').addClass('d-none');
        $('#btnDesistirPrecoTin').addClass('d-none');
        $('#btnGravarPrecoTin').removeClass('d-none');
    };

    $('#btnConfirmarPrecoTin').on('click', async function () {
        const linha = $('#tabelaPrecoTin').DataTable().$('tr.selected')[0]._DT_RowIndex;
        const data = $('#tabelaPrecoTin').DataTable().data();

        await confirmaAltPrecoTin(data, linha)
        await desabAlteracaoPrecoTin();
    });

    async function confirmaAltPrecoTin(data, linha) {
        try {
            $.LoadingOverlay('show');
            try {
                if (!data) {
                    return;
                }

                data.rows().remove();
                data[linha][0] = data[linha][0];
                data[linha][1] = data[linha][1];
                data[linha][2] = data[linha][2];
                data[linha][3] = data[linha][3];
                data[linha][4] = $('#txtPrecoNovoPrecoTin').val() == '' ? 0.00 : parseFloat(($('#txtPrecoNovoPrecoTin').val()).replace(',', '.'));

                for (let i = 0; i < data.length; i++) {
                    $('#tabelaPrecoTin').DataTable().row.add([
                        data[i][0],
                        data[i][1],
                        parseFloat(data[i][2]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][2]).toFixed(6),
                        parseFloat(data[i][3]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][3]).toFixed(6),
                        parseFloat(data[i][4]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][4]).toFixed(6),
                        data[linha][5],
                        data[linha][6],
                        data[linha][7],
                        data[linha][8],
                        data[linha][9],
                        data[linha][10]
                    ]).draw(false);
                };
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#btnConsultarPrecoTin').on('click', async function () {

        if (cus280_91 == 'S') {
            if ($('#txtTinturariaPrecoTin').val() == '') {
                msgErro('É necessário informar uma tinturaria, favor verificar.');
                return;
            }
        }

        const cliente = pegaChave('#txtTinturariaPrecoTin')

        let dados = null;

        if (cus280_91 == 'S') {
            dados = await buscaPrecoTin(codMat, cliente);
        } else {
            dados = await buscaPrecoTin(codMat, '00000')
        }

        await montaTabelaPrecoTin(dados);
    });

    async function montaTabelaPrecoTin(dados) {
        try {
            $.LoadingOverlay('show');

            try {
                $('#tabelaPrecoTin').DataTable().data().rows().remove();

                if (dados.length > 0) {
                    let pis;
                    let cofins;

                    let consulta = await buscaValor('EMPRESA', 'EMP_PIS', 'EMP_PAT', getCookie('empresa'));
                    if (consulta != undefined) {
                        pis = retornaFloat(consulta.EMP_PIS);
                    }

                    consulta = await buscaValor('EMPRESA', 'EMP_COFINS', 'EMP_PAT', getCookie('empresa'));
                    if (consulta != undefined) {
                        cofins = retornaFloat(consulta.EMP_COFINS);
                    }

                    for (let i = 0; i < dados.length; i++) {
                        let precoAtual = 0;
                        let precoTintur = 0;
                        let precoNovo = 0;

                        if (dados[i].PRECO == null) {
                            precoTintur = precoTintur.toFixed(6);
                        } else {
                            precoTintur = parseFloat(dados[i].PRECO).toFixed(6) == 'NaN' ? 0 : parseFloat(dados[i].PRECO).toFixed(6);
                        }

                        if (dados[i].PRECO_ATUAL == null) {
                            precoAtual = precoAtual.toFixed(6);
                        } else {
                            precoAtual = parseFloat(dados[i].PRECO_ATUAL).toFixed(6) == 'NaN' ? 0 : parseFloat(dados[i].PRECO_ATUAL).toFixed(6);
                        }

                        precoNovo = retornaFloat(precoTintur);

                        if (cus210_7 == 'S') {
                            precoNovo -= (retornaFloat(precoTintur) * (pis / 100));
                        }

                        if (cus210_8 == 'S') {
                            precoNovo -= (retornaFloat(precoTintur) * (cofins / 100));
                        }

                        precoNovo = precoNovo.toFixed(6);

                        $('#tabelaPrecoTin').DataTable().row.add([
                            dados[i].COR,
                            dados[i].DESCRICAO,
                            precoAtual,
                            precoTintur,
                            precoNovo,
                            dados[i].PANTONE,
                            dados[i].TINTURARIA,
                            dados[i].NOME,
                            dados[i].CODIGO2,
                            dados[i].GRUPO,
                            dados[i].DESC_GRUPO
                        ]).draw(false);
                    }
                }

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível gravar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    $('#btnGravarPrecoTin').on('click', async function () {
        if ($('#tabelaPrecoTin').DataTable().data().length == 0) {
            msgErro('Não há nenhum dado a ser gravado, favor verificar.');
            return;
        }

        msgAlerta('Deseja atualizar o preço conforme a tinturaria?', async () => {
            await gravaDadosPrecoTin();
        });
    });

    async function gravaDadosPrecoTin() {

        try {

            $.LoadingOverlay('show');

            try {

                const data = $('#tabelaCores').DataTable().data();
                const data2 = $('#tabelaPrecoTin').DataTable().data();

                let listaCores = [];
                let listaPrecosTint = [];
                let listaPrecosNovo = [];

                data2.map(e => {
                    listaCores.push(
                        e[0]
                    )
                    listaPrecosTint.push(
                        e[3]
                    )
                    listaPrecosNovo.push(
                        e[4]
                    )
                });

                data.map(e => {

                    const index = listaCores.indexOf(e[2]);

                    if (index != -1) {
                        e[4] = listaPrecosTint[index];
                        e[7] = listaPrecosNovo[index];
                    }

                });

                listaCores = [];
                listaPrecosTint = [];
                listaPrecosNovo = [];

                data.map(e => {
                    listaCores.push(
                        e[2]
                    )
                });

                data2.map(e => {

                    const index = listaCores.indexOf(e[0]);

                    if (index == -1) {
                        data.push([
                            '',
                            'S',
                            e[0],
                            e[1],
                            e[3],
                            0,
                            0,
                            e[4],
                            e[5],
                            e[6],
                            e[7],
                            e[8],
                            e[9],
                            e[10]
                        ])
                    }

                });

                json = [];

                data.map(e => {
                    json.push({
                        ID: e[0],
                        ATIVO: e[1],
                        COR: e[2],
                        DESCRICAO: e[3],
                        PRECO_TING: e[4],
                        PRECO_COMPRA: e[5],
                        PERC_DESP: e[6],
                        PRECO: e[7],
                        PANTONE: e[8],
                        TINTURARIA: e[9],
                        NOME: e[10],
                        CODIGO2: e[11],
                        GRUPO: e[12],
                        DESC_GRUPO: e[13]
                    })
                });

                $('#tabelaCores').DataTable().rows().remove();

                preencheDadosTabelaCores(json);

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível gravar os dados: ${error}`);
            }
        } finally {
            $('#modalPrecoTin').modal('hide');
            $.LoadingOverlay('hide');
        }
    };

    $('#modalPrecoTin').on('hide.bs.modal', async function () {
        $('#tabelaPrecoTin').DataTable().data().rows().remove();
        $('.bodyModal').scrollTop(0);
        $('#txtTinturariaPrecoTin').val('');
        await desabAlteracaoPrecoTin();
    });

    $('#btnFecharPrecoTin').on('click', async function () {
        msgAlerta('Podem haver informações não gravadas, deseja continuar?', async () => {
            $('#modalPrecoTin').modal('hide');
        });
    });

    $('#txtTinturariaPrecoTin').autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI CHAVE", "NOME DESCRICAO"], "where": null}`);

    $('#btnTinturariaPrecoTin').pesquisa_serverside(['#txtTinturariaPrecoTin'], ['CODCLI'], ['NOME'], '{"tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME"], "where": null}', 'Pesquisa Entidade');

    $('#btnATinturariaPrecoTin').on('click', function () {
        $('#txtTinturariaPrecoTin').val('');
    });

    $('#btnAviamentos').on('click', async function () {

        try {

            $.LoadingOverlay('show');

            $('#modalAviamentos').modal('show');

            $('#tituloModalAviamentos').html(`[${codMat}] - ${$('#txtDescricao').val()}`);

            criaTabela($('#tabelaModalAviamentos'), null, [0]);
            const dadosModalAviamentos = $('#tabelaAviamentos').DataTable().data();

            jsonDados = [];

            dadosModalAviamentos.map(element => {
                jsonDados.push({
                    ORDEM: element[0],
                    CODIGO: element[1],
                    MATERIAL: element[2],
                    UNIDADE: element[7],
                    QUANTIDADE: element[4],
                    CUSTO: element[3],
                    QUEBRA: element[9],
                    VALOR: element[5],
                    ACUMULADO: element[6],
                    DT_ULT_ATUALIZACAO: element[8]
                })
            })

            preencheTabelasAviamentos(jsonDados, $('#tabelaModalAviamentos'));

        } finally {
            $.LoadingOverlay('hide');
        }

    });

    $('#btnRecalcularModalAviamentos').on('click', async function () {
        const aproveitamento = await buscaAproveitamentoMatPreco();

        const dados = $('#tabelaModalAviamentos').DataTable().data();

        const data = await recalculaAviamentos(aproveitamento, dados);

        await montaTabelaAviamentos(data);
    });

    async function montaTabelaAviamentos(data) {
        data.rows().remove();
        for (let i = 0; i < data.length; i++) {
            $('#tabelaModalAviamentos').DataTable().row.add([
                data[i][0],
                data[i][1],
                data[i][2],
                data[i][3],
                data[i][4],
                parseFloat(data[i][5]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][5]).toFixed(6),
                parseFloat(data[i][6]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][6]).toFixed(6),
                parseFloat(data[i][7]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][7]).toFixed(6),
                parseFloat(data[i][8]).toFixed(6) == 'NaN' ? 0 : parseFloat(data[i][8]).toFixed(6),
                data[i][9]
            ]).draw(false);
        }
    }

    async function recalculaAviamentos(aprov, data) {

        let novoValor = 0;
        let acumulado = 0;
        for (let i = 0; i < data.length; i++) {
            if (data[i][3] == 'HO' || data[i][3 == 'HR']) {
                novoValor = parseFloat(((((data[i][5]) * (data[i][4] / 60)) / (aprov / 100))))
                if (novoValor > 0) {
                    novoValor = novoValor / ((100 - data[i][6]) / 100);
                }
            } else {
                if (aprov < 10) {
                    aprov = 100;
                }
                novoValor = parseFloat(((data[i][5] * data[i][4]) / (aprov / 100)));
                if ((data[i][6] > 0) && (data[i][6] < 100)) {
                    novoValor = parseFloat(novoValor / ((100 - parseFloat(data[i][6])) / 100));
                }
            }
            acumulado += novoValor;
            data[i][8] = acumulado;
            data[i][7] = novoValor;
        }
        return data;
    };

    async function buscaAproveitamentoMatPreco() {
        try {
            $.LoadingOverlay('show');
            try {
                const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"MAT_PRECO",
                "camposSelect":["MAT_PRECO.APROVEITAMENTO"], 
                "where": ["MAT_PRECO.CODIGO = '${codMat}'", "MAT_PRECO.EMP_ID = '${getCookie('emp_id')}'"]}`,
                )

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                const data = jsonStr.RESULT[0];

                let aprov = 100;
                if (data.length > 0) {
                    aprov =  data[0].APROVEITAMENTO;
                }

                return aprov;

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $('#btnIncluirModalAviamentos').on('click', async function () {
        inclusaoAviamentos = true;
        await habAlteracaoAviamentos(null);
    });

    $('#btnDesistirModalAviamentos').on('click', async function () {
        await desabAlteracaoAviamentos();
    });

    async function habAlteracaoAviamentos(linha) {

        const data = $('#tabelaModalAviamentos').DataTable().data();
        let ordens = [];

        for (let i = 0; i < data.length; i++) {
            ordens.push(data[i][0]);
        }

        let novaOrdem = null;

        if (ordens.length > 0) {
            novaOrdem = (Math.max(...ordens)) + 1;
        } else {
            novaOrdem = 1;
        }

        $('#btnIncluirModalAviamentos').addClass('d-none');
        $('#btnRecalcularModalAviamentos').addClass('d-none');
        $('#btnConfirmarModalAviamentos').removeClass('d-none');
        $('#btnDesistirModalAviamentos').removeClass('d-none');
        $('#txtMaterialModalAviamentos').prop('disabled', false);
        $('#btnMaterialModalAviamentos').prop('disabled', false);
        $('#btnAMaterialModalAviamentos').prop('disabled', false);
        $('#txtQuantidadeModalAviamentos').prop('disabled', false);
        $('#txtQuebraModalAviamentos').prop('disabled', false);
        $('#txtOrdemModalAviamentos').prop('disabled', false);
        $('#btnComposicaoModalAviamentos').addClass('d-none');
        if (!inclusaoAviamentos) {
            $('#txtOrdemModalAviamentos').val(linha[0]);
            insereValor('#txtMaterialModalAviamentos', linha[1], linha[2]);
            $('#txtUnidadeModalAviamentos').val(linha[3]);
            $('#txtQuantidadeModalAviamentos').val(linha[4]);
            $('#txtQuebraModalAviamentos').val(linha[6]);
            $('#btnExcluirModalAviamentos').removeClass('d-none');
        } else {
            $('#txtOrdemModalAviamentos').val(novaOrdem);
        }
        $('#btnGravarModalAviamentos').addClass('d-none');
    };

    async function desabAlteracaoAviamentos() {
        $('#btnIncluirModalAviamentos').removeClass('d-none');
        $('#btnRecalcularModalAviamentos').removeClass('d-none');
        $('#btnConfirmarModalAviamentos').addClass('d-none');
        $('#btnDesistirModalAviamentos').addClass('d-none');
        $('#txtMaterialModalAviamentos').prop('disabled', true);
        $('#btnMaterialModalAviamentos').prop('disabled', true);
        $('#btnAMaterialModalAviamentos').prop('disabled', true);
        $('#txtQuantidadeModalAviamentos').prop('disabled', true);
        $('#txtOrdemModalAviamentos').val('');
        $('#txtMaterialModalAviamentos').val('');
        $('#txtUnidadeModalAviamentos').val('');
        $('#txtQuantidadeModalAviamentos').val('');
        $('#txtQuebraModalAviamentos').val('');
        $('#tabelaModalAviamentos').DataTable().$('tr.selected').removeClass('selected');
        $('#txtQuebraModalAviamentos').prop('disabled', true);
        $('#txtOrdemModalAviamentos').prop('disabled', true);
        $('#btnExcluirModalAviamentos').addClass('d-none');
        if (inclusaoAviamentos) {
            inclusaoAviamentos = false;
        }
        $('#btnComposicaoModalAviamentos').removeClass('d-none');
        $('#btnGravarModalAviamentos').removeClass('d-none');
    };

    $('#btnConfirmarModalAviamentos').on('click', async function () {

        if ($('#txtMaterialModalAviamentos').val() == '') {
            msgErro('É necessário informar um material, favor verificar.');
            return;
        }

        let linha = null;
        if (!inclusaoAviamentos) {
            linha = $('#tabelaModalAviamentos').DataTable().$('tr.selected')[0]._DT_RowIndex;
        }
        const data = $('#tabelaModalAviamentos').DataTable().data();

        await confirmaAltAviamentos(linha, data);
        await desabAlteracaoAviamentos();
    });

    async function confirmaAltAviamentos(linha, data) {
        if (!data) {
            return;
        }

        const codigo = pegaChave('#txtMaterialModalAviamentos');

        let qtde = 0;
        let custo = 0;
        let quebra = 0;

        data.rows().remove();
        if (inclusaoAviamentos) {

            let dados = null;

            try {
                const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"MAT_PRECO",
                "camposSelect":["MAT_PRECO.PRECO_1, MAT_PRECO.DT_ULT_ATUALIZACAO"], 
                "where": ["MAT_PRECO.CODIGO = '${codigo}'", "MAT_PRECO.EMP_ID = '${getCookie('emp_id')}'"]}`,
                )

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                dados = jsonStr.RESULT[0];

                if (dados.length > 0) {
                    dados = dados[0];
                }

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }

            if (!dados || dados == undefined || dados == '' || dados == null) {
                return;
            };

            qtde = retornaFloat($('#txtQuantidadeModalAviamentos').val());
            custo = dados.length == 0 ? 0 : retornaFloat(dados.PRECO_1);
            quebra = retornaFloat($('#txtQuebraModalAviamentos').val());

            data.push([
                $('#txtOrdemModalAviamentos').val(),
                pegaChave('#txtMaterialModalAviamentos'),
                pegaDescricao('#txtMaterialModalAviamentos'),
                $('#txtUnidadeModalAviamentos').val(),
                qtde,
                custo,
                quebra,
                calculaValorComQuebra($('#txtQuantidadeModalAviamentos').val(), dados.PRECO_1, $('#txtQuebraModalAviamentos').val()),
                0,
                formataData(dados.DT_ULT_ATUALIZACAO)
            ]);
        } else {
            qtde = retornaFloat($('#txtQuantidadeModalAviamentos').val());
            custo = retornaFloat(data[linha][5]);
            quebra = retornaFloat($('#txtQuebraModalAviamentos').val());

            data[linha][0] = $('#txtOrdemModalAviamentos').val();
            data[linha][1] = pegaChave('#txtMaterialModalAviamentos');
            data[linha][2] = pegaDescricao('#txtMaterialModalAviamentos');
            data[linha][3] = $('#txtUnidadeModalAviamentos').val();
            data[linha][4] = qtde;
            data[linha][5] = custo.toFixed(6);
            data[linha][6] = quebra.toFixed(6);
            data[linha][7] = calculaValorComQuebra($('#txtQuantidadeModalAviamentos').val(), data[linha][5], $('#txtQuebraModalAviamentos').val());
            data[linha][8] = data[linha][8];
            data[linha][9] = data[linha][9];
        }

        let acumulado = 0;
        let valor = 0;

        for (let i = 0; i < data.length; i++) {

            if (data[i][0] == '') {
                data[i][0] = 0;
            }

            valor = parseFloat(data[i][7]);

            acumulado += valor;

            data[i][8] = acumulado;

        }
        await montaTabelaAviamentos(data);
    }

    $('#btnExcluirModalAviamentos').on('click', async function () {
        const linha = $('#tabelaModalAviamentos').DataTable().$('tr.selected')[0]._DT_RowIndex
        const data = $('#tabelaModalAviamentos').DataTable().data();
        await excluiLinhaModalAviamentos(linha, data);
        await desabAlteracaoAviamentos();
    });

    async function excluiLinhaModalAviamentos(linha, data) {
        try {
            $.LoadingOverlay('show');
            try {
                data.rows().remove();
                data.splice(linha, 1);

                if (data.length > 0) {
                    await montaTabelaAviamentos(data);
                } else {
                    $('#tabelaModalAviamentos').DataTable().draw(false);
                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay('hide');
        }

    }

    function calculaValorComQuebra(quantidade, custo, quebra) {

        if (quantidade == '') {
            quantidade = 0;
        }

        if (custo == '') {
            custo = 0;
        }

        if (quebra == '') {
            quebra = 0;
        }

        if (typeof quantidade == 'string') {
            quantidade = quantidade.replace(',', '.');
        }

        if (typeof custo == 'string') {
            custo = custo.replace(',', '.');
        }

        if (typeof quebra == 'string') {
            quebra = quebra.replace(',', '.');
        }

        quantidade = parseFloat(quantidade);
        custo = parseFloat(custo);
        quebra = parseFloat(quebra);

        if (quantidade == '' || quantidade == null || quantidade == undefined) {
            quantidade = 0;
        }

        if (custo == '' || custo == null || custo == undefined) {
            custo = 0;
        }

        if (quebra == '' || quebra == null || quebra == undefined) {
            quebra = 0;
        }

        let valor = quantidade * custo;

        if (quebra > 0) {
            valor = valor / ((100 - quebra) / 100);
        }

        return parseFloat(valor).toFixed(6) == 'NaN' ? 0 : parseFloat(valor).toFixed(6);

    }

    // $('#tabelaModalAviamentos tbody').unbind('click');
    // $('#tabelaModalAviamentos tbody').on('click', 'tr', async function () {
    //     if ($('#tabelaModalAviamentos').DataTable().data().length > 0) {
    //         $('#tabelaModalAviamentos').DataTable().$('tr.selected').removeClass('selected');
    //         $(this).addClass('selected');
    //         await habAlteracaoAviamentos($("#tabelaModalAviamentos").DataTable().row($(this)).data());
    //     }
    // });

    $('#tabelaModalAviamentos').on('click', '#btn-alterar-avi', async function () {
        if ($('#tabelaModalAviamentos').DataTable().data().length > 0) {
            await habAlteracaoAviamentos($("#tabelaModalAviamentos").DataTable().row($(this).parents('tr')).data());
            $('#tabelaModalAviamentos').DataTable().$('tr.selected').removeClass('selected');
            $(this).parents('tr').addClass('selected');
            $('.bodyModal').scrollTop(0);
        }
    });

    $('#tabelaModalAviamentos').on('click', '#btn-excluir-avi', async function () {
        const linha = $('#tabelaModalAviamentos').DataTable().$($(this).parents('tr'))[0]._DT_RowIndex;
        const data = $('#tabelaModalAviamentos').DataTable().data();
        await excluiLinhaModalAviamentos(linha, data);
    });

    $('#btnComposicaoModalAviamentos').on('click', async function () {
        if ($('#tabelaModalAviamentos').DataTable().data().length > 0) {
            msgAlerta('Já existem registros para esse cadastro, deseja refazer?', async () => {
                salvaArquivo
                const comp = await buscaComposicao(codMat);

                if (comp.length == 0) {
                    msgErro('Não existem dados de combinação para este material, favor verificar.')
                    return;
                }

                await buscaDadosPrecoIten(comp);
            })
        } else {
            const comp = await buscaComposicao(codMat);

            if (comp.length == 0) {
                msgErro('Não existem dados de combinação para este material, favor verificar.')
                return;
            }

            await buscaDadosPrecoIten(comp);
        }
    });

    async function buscaComposicao(codigo) {

        try {
            $.LoadingOverlay('show');
            try {
                const response = await requisicao("GET", "/sisplan/cadmatpreco/v1/buscacomposicao?", `CODIGO=${codigo}`);

                if (!response) {
                    return;
                }

                const jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                return jsonStr;

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function buscaDadosPrecoIten(data) {

        try {
            $.LoadingOverlay('show');

            try {

                let aviamentos = '(';
                if (data != undefined) {
                    for (let i = 0; i < data.length; i++) {
                        if (i != data.length - 1) {
                            aviamentos += `'${data[i].CODIGO}', `
                        } else {
                            aviamentos += `'${data[i].CODIGO}'`
                        }
                    };

                } else {
                    aviamentos += `'INEXISTENTE'`;
                }

                aviamentos += ')';

                const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"MAT_PRECO",
                "camposSelect":["MAT_PRECO.CODIGO, MAT_PRECO.DESCRICAO, MAT_PRECO.UNIDADE, MAT_PRECO.PRECO_1 CUSTO, MAT_PRECO.DT_ULT_ATUALIZACAO, MAT_PRECO.APROVEITAMENTO"], 
                "where": ["MAT_PRECO.CODIGO IN ${aviamentos}", "MAT_PRECO.EMP_ID = '${getCookie('emp_id')}'"]}`,
                );

                if (!response) {
                    return;
                }

                let jsonStr = (await response.json()).RESULT[0]
                if (response.status != 200) {
                    msgErro(jsonStr.mensagem);
                    return;
                }

                const tecelagem = await retornaTecelagemAviamentos();

                if (tecelagem != undefined) {
                    jsonStr.push(tecelagem);
                }

                $('#tabelaModalAviamentos').DataTable().data().rows().remove();

                let acumulado = 0;
                let valor = 0;

                if (jsonStr[0] != undefined) {
                    for (let i = 0; i < jsonStr.length; i++) {
                        for (let j = 0; j < data.length; j++) {
                            if (jsonStr[i].CODIGO == data[j].CODIGO) {
                                jsonStr[i].QTDE = data[j].PERC / 100;
                            }
                        }


                        valor = (jsonStr[i].QTDE * jsonStr[i].CUSTO);

                        acumulado += valor;

                        $('#tabelaModalAviamentos').DataTable().row.add([
                            i + 1,
                            jsonStr[i].CODIGO,
                            jsonStr[i].DESCRICAO,
                            jsonStr[i].UNIDADE,
                            jsonStr[i].QTDE,
                            parseFloat(jsonStr[i].CUSTO).toFixed(6) == 'NaN' ? 0 : parseFloat(jsonStr[i].CUSTO).toFixed(6),
                            0,
                            parseFloat(valor).toFixed(6) == 'NaN' ? 0 : parseFloat(valor).toFixed(6),
                            parseFloat(acumulado).toFixed(6) == 'NaN' ? 0 : parseFloat(acumulado).toFixed(6),
                            formataData(jsonStr[i].DT_ULT_ATUALIZACAO)
                        ]).draw(false);
                    }
                }

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    async function retornaTecelagemAviamentos() {
        try {
            const pesquisa = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"SOLUCAO",
            "camposSelect":["SOLUCAO.DESCRICAO, SOLUCAO.DESCRICAO2, SOLUCAO.DESCRICAO3, SOLUCAO.DESCRICAO4"], 
            "where": ["SOLUCAO.VARIAVEL = 'PRECO6'", "SOLUCAO.DESCRICAO = 'MAODEOBRATECEL'"]}`,
            );

            if (!pesquisa) {
                return;
            }

            let tecelagem = (await pesquisa.json()).RESULT[0];
            if (pesquisa.status != 200) {
                msgErro(tecelagem.mensagem);
                return;
            }

            tecelagem = tecelagem[0];

            let tecel = '';

            if (tecelagem != undefined && tecelagem != '') {
                if (tecelagem.DESCRICAO2 != '') {
                    tecel = tecelagem.DESCRICAO2;
                } else if (tecelagem.DESCRICAO3 != '') {
                    tecel = tecelagem.DESCRICAO3;
                } else if (tecelagem.DESCRICAO4 != '') {
                    tecel = tecelagem.DESCRICAO4;
                } else {
                    tecel = '';
                }
            } else {
                tecel = 'TECELAGEM';
            }

            const consulta = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"MAT_PRECO",
            "camposSelect":["MAT_PRECO.CODIGO, MAT_PRECO.PIS, MAT_PRECO.COFINS, MAT_PRECO.IPI, MAT_PRECO.ICM,
                             MAT_PRECO.CREDITA_PIS, MAT_PRECO.CREDITA_COFINS, MAT_PRECO.CREDITA_IPI, MAT_PRECO.CREDITA_ICMS,
                             MAT_PRECO.UNIDADE, MAT_PRECO.DT_ULT_ATUALIZACAO"], 
            "where": ["MAT_PRECO.CODIGO = '${tecel}'", "MAT_PRECO.EMP_ID = '${getCookie('emp_id')}'"]}`,
            );

            if (!consulta) {
                return;
            }

            let infoTecel = (await consulta.json()).RESULT[0];
            if (consulta.status != 200) {
                msgErro(infoTecel.mensagem);
                return;
            }

            if (infoTecel.length == 0) {
                return;
            }

            infoTecel = infoTecel[0];

            if (infoTecel == undefined) {
                return;
            }

            const tipoPreco = $('#opcoesPrecoAviamentos').val();

            let select = '';

            select += 'JSON={"tabela": "CADCORTI", "camposSelect": '

            if (tipoPreco == 'P') {
                const pesquisaCodSaida = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"CADMATTI",
                        "camposSelect":["CADMATTI.CODIGO"], 
                        "where": ["CADMATTI.CODIGO2 = '${codMat}'", "CADMATTI.PADRAO = 'S'"]}`,
                );

                if (!pesquisaCodSaida) {
                    return;
                }

                let codSaida = (await pesquisaCodSaida.json()).RESULT[0];
                if (pesquisaCodSaida.status != 200) {
                    msgErro(codSaida.mensagem);
                    return;
                }

                if (codSaida.length == 0) {
                    return;
                }

                codSaida = codSaida[0];

                select += `["CADCORTI.CUSTO"], 
                           "where": ["CADCORTI.CODIGO = '${codSaida}'", "CADCORTI.TIPO = 'M'", "CADCORTI.PADRAO = 'S'"]`;
            } else {
                select += `["MAX(CADCORTI.CUSTO) CUSTO"],
                          "innerjoin": [
                            {"tabela": "MATERIAL", "condicao": "CADCORTI.CODIGO = MATERIAL.CODIGO"}
                        ], 
                        "leftjoin": [
                            {"tabela": "CADMATTI", "condicao": "CADCORTI.CODIGO = CADMATTI.CODIGO"}
                        ],
                        "where": ["CADMATTI.CODIGO2 = '${codMat}'", "CADCORTI.TIPO = 'M'"]`
            }

            select += '}';

            const pesquisaCusto = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                select,
            );

            if (!pesquisaCusto) {
                return;
            }

            let custo = 0;

            let validaCusto = (await pesquisaCusto.json()).RESULT[0];

            if (validaCusto.length == 0) {
                return;
            }

            validaCusto = validaCusto[0];

            if (validaCusto != undefined && validaCusto != '') {
                custo = validaCusto.CUSTO;
                if (pesquisaCusto.status != 200) {
                    msgErro(custo.RESULT[0].mensagem);
                    return;
                }
            }

            let percDesconto = 0;

            if (infoTecel.CREDITA_PIS == 'S') {
                percDesconto += parseFloat(infoTecel.PIS) / 100;
            }
            if (infoTecel.CREDITA_COFINS == 'S') {
                percDesconto += parseFloat(infoTecel.COFINS) / 100;
            }
            if (infoTecel.CREDITA_IPI == 'S') {
                percDesconto += parseFloat(infoTecel.IPI) / 100;
            }
            if (infoTecel.CREDITA_ICMS == 'S') {
                percDesconto += parseFloat(infoTecel.ICM) / 100;
            }

            custo = custo - (custo * (parseFloat(percDesconto)));

            infoTecel.CUSTO = custo;
            infoTecel.QTDE = 1;
            infoTecel.DESCRICAO = 'MAO DE OBRA DE TECELAGEM';

            return infoTecel;

        } catch (error) {
            console.log(error);
        }

    }

    $('#btnGravarModalAviamentos').on('click', async function () {

        const data = $('#tabelaModalAviamentos').DataTable().data();
        gravaDadosAviamentos(data);
    });

    function gravaDadosAviamentos(data) {
        try {
            $.LoadingOverlay('show');

            try {
                $('#tabelaAviamentos').DataTable().data().rows().remove().draw(false);

                if (data.length > 0) {
                    for (let i = 0; i < data.length; i++) {
                        $('#tabelaAviamentos').DataTable().row.add([
                            data[i][0],
                            data[i][1],
                            data[i][2],
                            data[i][5],
                            data[i][4],
                            data[i][7],
                            data[i][8],
                            data[i][3],
                            data[i][9],
                            data[i][6]
                        ]).draw(false);
                    }
                }
            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível gravar os dados: ${error}`);
            }

        } finally {
            $('#modalAviamentos').modal('hide');
            $.LoadingOverlay('hide');
        }
    };

    $('#modalAviamentos').on('hide.bs.modal', async function () {
        $('#tabelaModalAviamentos').DataTable().data().rows().remove();
        $('.bodyModal').scrollTop(0);
        await desabAlteracaoAviamentos();
    });

    $('#btnFecharModalAviamentos').on('click', async function () {
        if ($('#tabelaModalAviamentos').DataTable().data().length != $('#tabelaAviamentos').DataTable().data().length) {
            msgAlerta('Podem haver informações não gravadas, deseja continuar?', async () => {
                $('#modalAviamentos').modal('hide');
            });
        } else {
            $('#modalAviamentos').modal('hide');
        }
    });

    $('#txtMaterialModalAviamentos').autocompleta(1, `JSON={ "tabela":"MAT_PRECO", "camposSelect":[ "CODIGO CHAVE, DESCRICAO DESCRICAO, UNIDADE"], "where": ["MAT_PRECO.EMP_ID = '${getCookie('emp_id')}'"] }`, ['#txtUnidadeModalAviamentos'], ['UNIDADE'], ['UNIDADE'], null, [true]);

    $('#btnMaterialModalAviamentos').pesquisa_serverside(['#txtMaterialModalAviamentos', '#txtUnidadeModalAviamentos'], ['CODIGO', 'UNIDADE'], ['DESCRICAO', 'UNIDADE'], `{"tabela":"MAT_PRECO", "camposSelect":[ "CODIGO", "DESCRICAO", "UNIDADE", "PRECO_1"], "where": ["MAT_PRECO.EMP_ID = '${getCookie('emp_id')}'"]}`, 'Pesquisa Material', null, [false, true]);

    $('#btnAMaterialModalAviamentos').on('click', function () {
        $('#txtMaterialModalAviamentos').val('');
    });

    $('#btnCustoMalhas').on('click', async function () {

        try {

            $.LoadingOverlay('show');

            $('#tituloCustoMalhas').html(`[${codMat}] - ${$('#txtDescricao').val()}`);

            criaTabela($('#tabelaCustoMalhas'), [4, 5, 6, 7, 8, 9], [0]);

            criaTabela($('#tabelaCustoMalhaBase'), null);
            criaTabela($('#tabelaCustoMalhaCrua'), null);
            criaTabela($('#tabelaCustoMalhaRotativa'), null);

            await carregaDadosCustoMalhas();
            await calculaValoresCustoMalha();

            $('#modalCustoMalhas').modal('show');
        } finally {
            $.LoadingOverlay('hide');
        }
    });

    async function carregaDadosCustoMalhas() {
        await carregaMalhaRotativa(codMat);
        if ($('#tabelaCustoMalhaRotativa').DataTable().data().length > 0) {
            await carregaMalhaBase(codMat);
        } else {
            await carregaMalhaBaseSemRotativa(codMat);
            $('#divMalhasRotativas').addClass('d-none');
        }

        await carregaMalhaCrua();
    }

    async function carregaMalhaRotativa(codigo) {

        try {

            const codsaida = '';

            const response = await requisicao("GET", "/sisplan/cadmatpreco/v1/buscamalharotativa?", `CODIGO=${codigo}&CODSAIDA=${codsaida}`);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            montaTabelaMalhaRotativa(jsonStr)

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        }

    }

    function montaTabelaMalhaRotativa(data) {
        data.map(e => {
            $('#tabelaCustoMalhaRotativa').DataTable().row.add([
                e.COR,
                e.DESC_COR,
                e.COR_FUNDO,
                e.DESC_COR_FUNDO,
                e.PRECO,
                e.CUSTO_MALHA,
                e.DESPERDICIO,
                e.CUSTO_TOTAL
            ]).draw(false);
        });
    }

    async function carregaMalhaBase(codigo) {

        try {

            let malhaBase = await buscaValor('CADMATTI', 'CODIGO', 'CODIGO2', codigo);
            if (malhaBase != undefined) {
                malhaBase = malhaBase.CODIGO;
            }

            let malhaCrua = await buscaValor('CADMATTI', 'CODIGO', 'CODIGO2', malhaBase);
            if (malhaCrua != undefined) {
                malhaCrua = malhaCrua.CODIGO;
            }

            $('#txtMalhaBase').val(malhaBase);

            let corFundo = `'`;

            const data = $('#tabelaCustoMalhaRotativa').DataTable().data();

            data.map(e => {
                if (corFundo != `'`) {
                    corFundo += `, '`;
                }

                corFundo += e[2] + `'`;
            })

            if (corFundo == '') {
                return;
            }

            const response = await requisicao("GET", "/sisplan/cadmatpreco/v1/buscamalhabase?", `CODIGO=${malhaBase}&COR_FUNDO=${corFundo}&CODSAIDA=${malhaCrua}`);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            montaTabelaMalhaBase(jsonStr);

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        }

    }

    function montaTabelaMalhaBase(data) {
        data.map(e => {
            $('#tabelaCustoMalhaBase').DataTable().row.add([
                e.COR,
                e.DESC_COR,
                e.CUSTO_CRUA,
                e.CUSTO_TINT,
                e.DESPERDICIO,
                e.CUSTO_TOTAL
            ]).draw(false);
        })
    }

    async function carregaMalhaBaseSemRotativa(codigo) {

        try {

            let malhaCrua = '';

            $('#txtMalhaBase').val(codigo);
            const c = await buscaValor('CADMATTI', 'CODIGO', 'CODIGO2', codigo);
            if (c != undefined) {
                malhaCrua = c.CODIGO;
            } else {

            }

            const corFundo = '';

            const response = await requisicao("GET", "/sisplan/cadmatpreco/v1/buscamalhabase?", `CODIGO=${codigo}&COR_FUNDO=${corFundo}&CODSAIDA=${malhaCrua}`);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            montaTabelaMalhaBase(jsonStr);

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        }

    }

    async function carregaMalhaCrua() {

        try {

            let malhaCrua = '';

            const c = await buscaValor('CADMATTI', 'CODIGO', 'CODIGO2', $('#txtMalhaBase').val());

            if (c != undefined) {
                malhaCrua = c.CODIGO;
            } else {
                malhaCrua = '';
            }

            if (c != undefined && malhaCrua != '') {

                $('#txtMalhaCrua').val(malhaCrua);

                const response = await requisicao("GET", "/sisplan/cadmatpreco/v1/buscamalhacrua?", `CODIGO=${malhaCrua}`);

                if (!response) {
                    return;
                }

                const jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                montaTabelaMalhaCrua(jsonStr);
            }

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        }

    }

    function montaTabelaMalhaCrua(data) {

        $('#txtCustoTec').val((retornaFloat(data[0].CUSTO_TEC)).toFixed(2));

        data.map(async (e) => {

            let aprov = retornaFloat(e.APROVEITAMENTO);
            let qtde = (retornaFloat(e.PERC) / 100);
            let preco_compra = retornaFloat(e.PRECO_COMPRA);
            let desperdicio = retornaFloat(e.DESPERDICIO);
            let valor = 0;

            e.CUSTO_QUEBRA = 0;
            e.CUSTO_TOTAL = 0;

            if ((e.UNIDADE == 'HO') || (e.UNIDADE == 'HR')) {
                valor = (preco_compra * (qtde / 60)) / (aprov / 100);

                if (desperdicio > 0) {
                    valor = valor / ((100 - desperdicio) / 100);
                }
                e.CUSTO_QUEBRA = valor;
            } else {
                if (aprov < 10) {
                    aprov = 100;
                }
                valor = ((preco_compra * qtde) / (aprov / 100));
                if ((desperdicio > 0) && desperdicio < 100) {
                    valor = valor / ((100 - desperdicio) / 100);
                }
                e.CUSTO_QUEBRA = valor;
            }

            e.CUSTO_TOTAL = e.CUSTO_QUEBRA;

            e.PRECO_COMPRA = e.PRECO_COMPRA.toFixed(2);
            e.DESPERDICIO = e.DESPERDICIO.toFixed(2);
            e.CUSTO_QUEBRA = e.CUSTO_QUEBRA.toFixed(2);
            e.CUSTO_TOTAL = e.CUSTO_TOTAL.toFixed(2);

            $('#tabelaCustoMalhaCrua').DataTable().row.add([
                e.CODIGO,
                e.DESCRICAO,
                e.COR,
                e.DESC_COR,
                e.PRECO_COMPRA,
                e.DESPERDICIO,
                e.CUSTO_QUEBRA,
                e.CUSTO_TOTAL
            ]).draw(false);
        });
    }

    async function calculaValoresCustoMalha() {
        calculaMalhaBase();
        if ($('#tabelaCustoMalhaRotativa').DataTable().data().length > 0) {
            calculaMalhaRotativa(codMat);
        }
    }

    function calculaMalhaBase(custo = 0) {
        try {

            const data = $('#tabelaCustoMalhaBase').DataTable().data();

            const dataCrua = $('#tabelaCustoMalhaCrua').DataTable().data();

            let custoMalhaCrua = 0;
            let custoTotal = 0;
            let desp = 0;

            if (custo == 0) {
                dataCrua.map(e => {
                    custoMalhaCrua += retornaFloat(e[7]);
                })

                custoMalhaCrua += retornaFloat($('#txtCustoTec').val());
            } else {
                custoMalhaCrua = custo;
            }

            custoMalhaCrua = (retornaFloat(custoMalhaCrua)).toFixed(2);

            json = [];

            data.map(e => {

                custoTotal = retornaFloat(custoMalhaCrua) + retornaFloat(e[3]);

                desp = retornaFloat(e[4]);

                if (desp > 0) {
                    custoTotal += ((desp / 100) * custoTotal);
                }

                custoTotal = custoTotal.toFixed(2);

                json.push({
                    COR: e[0],
                    DESC_COR: e[1],
                    CUSTO_CRUA: custoMalhaCrua,
                    CUSTO_TINT: e[3],
                    DESPERDICIO: e[4],
                    CUSTO_TOTAL: custoTotal
                })
            });

            $('#tabelaCustoMalhaBase').DataTable().rows().remove();

            montaTabelaMalhaBase(json);

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        }
    }

    async function calculaMalhaRotativa(codigo) {
        try {

            const codsaida = $('#txtMalhaBase').val();

            const response = await requisicao("GET", "/sisplan/cadmatpreco/v1/buscamalharotativa?", `CODIGO=${codigo}&CODSAIDA=${codsaida}`);

            if (!response) {
                return;
            }

            const jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            const data = $('#tabelaCustoMalhaBase').DataTable().data();

            let json = [];
            let listaCores = [];
            let listaPrecos = [];
            let precoMalha = 0;
            let custoTotal = 0;
            let desp = 0;

            data.map(e => {
                listaCores.push(
                    e[0]
                )
                listaPrecos.push(
                    e[5]
                )
            })

            jsonStr.map(e => {

                const index = listaCores.indexOf(e.COR_FUNDO);

                if (index != -1) {
                    precoMalha = listaPrecos[index];
                } else {
                    precoMalha = e.CUSTO_MALHA;
                }

                precoMalha = retornaFloat(precoMalha);
                desp = retornaFloat(e.DESPERDICIO);

                custoTotal = retornaFloat(e.PRECO) + precoMalha;

                if (desp > 0) {
                    custoTotal += retornaFloat(((desp / 100) * custoTotal));
                };

                custoTotal = custoTotal.toFixed(2);

                json.push({
                    COR: e.COR,
                    DESC_COR: e.DESC_COR,
                    COR_FUNDO: e.COR_FUNDO,
                    DESC_COR_FUNDO: e.DESC_COR_FUNDO,
                    PRECO: e.PRECO,
                    CUSTO_MALHA: precoMalha,
                    DESPERDICIO: desp,
                    CUSTO_TOTAL: custoTotal
                })
            });

            $('#tabelaCustoMalhaRotativa').DataTable().rows().remove();

            montaTabelaMalhaRotativa(json);

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        }

    }

    $('#btnConsultarCustoMalhas').on('click', async function () {

        try {

            $.LoadingOverlay('show');

            const malha = $('#txtMalhaBase').val();
            let malhaCrua = await buscaValor('CADMATTI', 'CODIGO', 'CODIGO2', malha);
            if (malhaCrua != undefined) {
                malhaCrua = malhaCrua.CODIGO;
            }

            let custo = await buscaValor('MAT_PRECO', 'PRECO_1', 'CODIGO', malhaCrua);
            if (custo != undefined) {
                custo = custo.PRECO_1;
            }

            custo = custo == null ? 0 : custo;

            calculaMalhaBase(custo);

        } finally {
            $.LoadingOverlay('hide');
        }
    });

    $('#btnGravarModalCusto').on('click', async function () {

        const data1 = $('#tabelaCustoMalhaRotativa').DataTable().data().length;
        const data2 = $('#tabelaCustoMalhaBase').DataTable().data().length;
        const data3 = $('#tabelaCustoMalhaCrua').DataTable().data().length;

        if (data1 == 0 && data2 == 0 && data3 == 0) {
            msgErro('Não há nenhum dado a ser gravado, favor verificar.')
            return;
        }

        await msgAlerta('Deseja atualizar o preço dos itens?', async () => {
            gravaDadosCusto();
        });

    });

    function gravaDadosCusto() {
        try {

            $.LoadingOverlay('show');

            if ($('#tabelaCustoMalhaRotativa').DataTable().data().length > 0) {
                gravaDadosMalhaRotativa();
            } else {
                gravaDadosMalhaBase();
            }
        } finally {
            $('#modalCustoMalhas').modal('hide');
            $.LoadingOverlay('hide');
        }
    }

    async function gravaDadosMalhaRotativa() {

        try {

            const data = $('#tabelaCores').DataTable().data();

            const data2 = $('#tabelaCustoMalhaRotativa').DataTable().data();

            let listaCores = [];
            let listaPrecos = [];
            let json = [];

            data2.map(e => {
                listaCores.push(
                    e[0]
                )
                listaPrecos.push(
                    e[7]
                )
            });


            data.map(e => {
                const index = listaCores.indexOf(e[2]);

                if (index != -1) {
                    e[7] = listaPrecos[index]
                }

                json.push({
                    ID: e[0],
                    ATIVO: e[1],
                    COR: e[2],
                    DESCRICAO: e[3],
                    PRECO_TING: e[4],
                    PRECO_COMPRA: e[5],
                    PERC_DESP: e[6],
                    PRECO: e[7],
                    PANTONE: e[8],
                    TINTURARIA: e[9],
                    NOME: e[10],
                    CODIGO2: e[11],
                    GRUPO: e[12],
                    DESC_GRUPO: e[13]
                });

            });

            $('#tabelaCores').DataTable().rows().remove();

            preencheDadosTabelaCores(json);

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        }
    }

    async function gravaDadosMalhaBase() {

        try {

            const data = $('#tabelaCores').DataTable().data();

            const data2 = $('#tabelaCustoMalhaBase').DataTable().data();

            let listaCores = [];
            let listaPrecos = [];
            let listaPrecosTint = [];
            let listaPrecosCompra = [];
            let json = [];

            data2.map(e => {
                listaCores.push(
                    e[0]
                )
                listaPrecos.push(
                    e[5]
                )
                listaPrecosTint.push(
                    e[3]
                )
                listaPrecosCompra.push(
                    e[2]
                )
            });


            data.map(e => {
                const index = listaCores.indexOf(e[2]);

                if (index != -1) {
                    e[7] = listaPrecos[index];
                    e[4] = listaPrecosTint[index];
                    e[5] = listaPrecosCompra[index];
                }

                json.push({
                    ID: e[0],
                    ATIVO: e[1],
                    COR: e[2],
                    DESCRICAO: e[3],
                    PRECO_TING: e[4],
                    PRECO_COMPRA: e[5],
                    PERC_DESP: e[6],
                    PRECO: e[7],
                    PANTONE: e[8],
                    TINTURARIA: e[9],
                    NOME: e[10],
                    CODIGO2: e[11],
                    GRUPO: e[12],
                    DESC_GRUPO: e[13]
                });

            });

            $('#tabelaCores').DataTable().rows().remove();

            preencheDadosTabelaCores(json);

        } catch (error) {
            console.error(error);
            msgErro(`Não foi possível buscar os dados: ${error}`);
        }
    };

    $('#btnFecharModalCusto').on('click', function () {
        $('#modalCustoMalhas').modal('hide');
    });

    $('#modalCustoMalhas').on('hide.bs.modal', function () {
        $('#tabelaCustoMalhaRotativa').DataTable().data().rows().remove();
        $('#tabelaCustoMalhaBase').DataTable().data().rows().remove();
        $('#tabelaCustoMalhaCrua').DataTable().data().rows().remove();
        $('#divMalhaRotativa').removeClass('d-none');
        $('.bodyModal').scrollTop(0);
        desabAlteracaoControleItens();
    });

    $('#btnVoltar').on('click', async function () {
        window.location.href = `${BASE_URI}/cadmatpreco`;
    });

    $('#msform').validate({
        debug: false,
        ignore: "",
        rules: {
            txtCodigo: {
                required: true,
            },
            txtDescricao: {
                required: true,
            },
            txtGrupo: {
                required: true,
            }
        },
        messages: {
            txtCodigo: {
                required: "Código não pode ser em branco.",
            },
            txtDescricao: {
                required: "Descrição não pode ser em branco.",
            },
            txtGrupo: {
                required: "Informe um grupo válida."
            }
        },
        errorElement: 'span',
        errorPlacement(error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight(element) {
            $(element).addClass('is-invalid');
        },
        unhighlight(element) {
            $(element).removeClass('is-invalid');
        }
    });
});