$('#tutorial').on('click', function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false
    });
    driver.defineSteps([

      {
        element: '#btnFiltros',
        popover: {
          title: 'Botão Filtros',
          description: 'Clique aqui para filtrar a consulta das FALs.',
          position: 'right'
        }
      },
      {
        element: '#btnIncluir',
        popover: {
          title: 'Botão Incluir',
          description: 'Clique aqui para iniciar o cadastro de uma FAL.',
          position: 'right'
        }
      },
      {
        element: '#tabelaServTingimento',
        popover: {
          title: 'Tabela Serviço de Tingimento',
          description: 'Aqui estão todas as FALs cadastradas.',
          position: 'top'
        }
      }
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("SERVTINGIMENTO");

  let colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

  if (colunas == null || colunas.servTingimento == undefined) {
    localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunas, material: [] }))
    colunas = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))
  }

  $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
    const cols = [];
    let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

    $('#tabelaServTingimento').DataTable().columns().every(function () {
      cols.push({
        'title': $(this.header()).text().trim(),
        'data': this.dataSrc()
      })
    });

    adicionaColunas(cols, colunasInvisiveis.servTingimento ?? [], [])
  });

  addPesquisaAutocompleta();
  await consultaServTingimento();

  $('#btnFiltros').on('click', async function () {
    $('#modal-filtros').modal('show');
  });

  $('#btnConsultar').on('click', async function () {
    await consultaServTingimento(true);
    $('#modal-filtros').modal('hide');
  });

  async function consultaServTingimento() {
    try {
      $.LoadingOverlay("show");

      const codigo = pegaChave('#txtFal') != '' ? ` AND FAL.NUMERO = '${pegaChave('#txtFal')}'` : '';
      const status = pegaValor('#rgStatus') != '' ? ` AND (FAL.STATUS = '${pegaValor('#rgStatus')}')` : '';
      const dtIni = pegaValor('#txtDataInicio') != '' ? ` AND (FAL.DATA_INI >= '${pegaValor('#txtDataInicio')}')` : '';
      const dtFim = pegaValor('#txtDataFim') != '' ? ` AND (FAL.DATA_INI <= '${pegaValor('#txtDataFim')}')` : '';
      const lote = $('#txtLote').val() != '' ? ` AND (FAL.NUMERO IN (SELECT FAL FROM [FAL_ITEN] WHERE LOTE IN (${await formataListas($('#txtLote').val().toString())})))` : '';
      const solicitacao = pegaChave('#txtSolicitacao') != '' ? ` AND FAL.SOL_PORTAL = '${pegaChave('#txtSolicitacao')}'` : '';

      const pesquisaParam = {
        tabela: 'FAL',
        camposSelect: [
          'FAL.NUMERO',
          'FAL.SOL_PORTAL SOLICITACAO',
          // 'EMPRESA.EMP_PAT',
          // 'EMPRESA.EMP_NOME',
          "(SELECT STRING_AGG( DISTINCT FI.LOTE, ', ' ORDER BY FI.LOTE) FROM [FAL_ITEN] FI WHERE FI.FAL = FAL.NUMERO) AS LOTE ",
          'FAL.STATUS',
          'FASE.TIPO',
          'FAL.DATA_INI EMISSAO',
          'FAL.DATA_FIN ENTREGA',
          'FAL.DATA_FIN_ORIG ENTREGA_ORIG',
          'SUM(FAL_ITEN.PESO) TOTAL'
        ],
        leftJoin: [
          { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = FAL.CLIENTE' },
          { tabela: 'FAL_ITEN', condicao: 'FAL_ITEN.FAL = FAL.NUMERO' },
          { tabela: 'EMPRESA', condicao: `EMPRESA.EMP_ID = ${getCookie('emp_id')}` },
          { tabela: 'FASE', condicao: `FASE.CODIGO = FAL.FASE_ATUAL` }
        ],
        groupBy: [
          'FAL.NUMERO',
          'FAL.SOL_PORTAL',
          'FAL.LOTE',
          // 'EMPRESA.EMP_PAT',
          // 'EMPRESA.EMP_NOME',
          'FAL.STATUS',
          'FASE.TIPO',
          'FAL.DATA_INI',
          'FAL.DATA_FIN',
          'FAL.DATA_FIN_ORIG'
        ],
        where: [`1=1 ${codigo} ${dtIni} ${dtFim} ${lote} ${solicitacao} ${pegaValor('#rgStatus') != 'P' ? status : ` AND ((FAL.STATUS = '${pegaValor('#rgStatus')}') OR (FAL.STATUS = 'PA'))`} AND FAL.CLIENTE = '${getCookie('cod_usuario')}'`]
      };

      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (jsonStr.length == 0) {
        msgAlerta('Nenhum dado encontrado, favor verificar os filtros.');
        $.LoadingOverlay("hide");
        return;
      }

      const dataSetCols = [];
      const keys = Object.keys(jsonStr[0]);
      for (var k in keys) {
        dataSetCols.push({
          'title': keys[k],
          'data': keys[k]
        });
      };

      $('#tabelaServTingimento').DataTable({
        search: false,
        filter: true,
        destroy: true,
        scrollX: true,
        scrollY: '55vh',
        pageLength: 25,
        paging: true,
        data: jsonStr,
        columns: dataSetCols,
        order: [[0, 'desc']],
        autoWidth: false,
        colReorder: true,
        columnDefs: [
          {
            render: funcBotaoOpcoes,
            targets: [0]
          },
          {
            render: funcRetornaStatus,
            targets: [3],
          },
          {
            render: funcRetornaFase,
            targets: [4],
          },
          {
            render: funcFormataData,
            targets: [5, 6, 7],
          }
        ]
      });

      $('#tabelaServTingimento_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
      $('#tabelaServTingimento_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

      $('#buttonColVis').prop('title', 'Configurar colunas visíveis');
      $('#buttonExcel').prop('title', 'Exportar');

      $('#buttonColVis').on('click', async function () {
        $.LoadingOverlay('show')
        try {
          $('#modal-ColunasVisiveis').modal('show');
        } finally {
          $.LoadingOverlay('hide')
        }
      });

      $("#btnConfirmarColunas").off();
      $("#btnConfirmarColunas").on("click", async function () {
        try {
          $.LoadingOverlay("show");

          const novasColunas = retornaNovasColunasInvisiveis();
          localStorage.setItem(
            "colunasInvisiveisRelatorios",
            JSON.stringify({
              ...colunas,
              servTingimento: novasColunas,
            })
          );

          $('#tabelaServTingimento').DataTable().columns().visible(true);

          $('#tabelaServTingimento')
            .DataTable()
            .columns()
            .every(function () {
              const colAtual = String(this.dataSrc());
              if (novasColunas.indexOf(colAtual) != -1) {
                this.visible(false);
              }
            });

        } finally {
          $.LoadingOverlay("hide");
          $("#modal-ColunasVisiveis").modal("hide");
        }
      });

      $('#buttonExcel').off();
      $('#buttonExcel').on('click', async function () {
        const dados = $("#tabelaServTingimento").DataTable().data().toArray();
        await exportaCSV("", "", undefined, null, 'Relatório de Serviços de Tingimento', '', '', 999, false, false, dados);
      });


      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
    }
  }

  $('#btnIncluir').on('click', function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
      window.location.href = "servtingimento/create";
    } else {
      msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });

  $('#tabelaServTingimento').on('click', '#btn-editar', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaServTingimento').DataTable().row($(this).parents('tr')).data();
      if ((data.STATUS == '') || (data.STATUS == 'N')) {
        window.location.href = `servtingimento/${data.NUMERO}`;
      } else {
        msgAlerta('FAL já foi aceita, impossível alterar.');
        return;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaServTingimento').on('dblclick', 'tr', async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $('#tabelaServTingimento').DataTable().row($(this)).data();
      if ((data.STATUS == '') || (data.STATUS == 'N')) {
        window.location.href = `servtingimento/${data.NUMERO}`;
      } else {
        msgAlerta('FAL já foi aceita, impossível alterar.');
        return;
      }
    } else {
      msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
  });

  $('#tabelaServTingimento').on('click', '#btn-imprimir', async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaServTingimento').DataTable().row($(this).parents('tr')).data();
      const url = `/sisplan/impressao/v1/imprimirtingimentoindividual?`;

      const filtros = `NUMERO=${data.NUMERO}`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelTingimentoIndividual');
      let arquivo = await GeraRelatorio(`${url}${filtros}`, 'GET', 150000, false, 'RelTingimentoIndividual');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#tabelaServTingimento').on('click', '#btn-imprimir-solicitacao', async function () {
    $.LoadingOverlay('show');
    try {
      const data = $('#tabelaServTingimento').DataTable().row($(this).parents('tr')).data();
      const url = `/sisplan/impressao/v1/imprimirtingimentoindividual?`;

      const filtros = `NUMERO=${data.SOLICITACAO}&SOLICITACAO=S`;
      const bImprimeAutomatico = await verificaImprimirAutomatico('RelTingimentoSolicitacao');
      let arquivo = await GeraRelatorio(`${url}${filtros}`, 'GET', 150000, false, 'RelTingimentoSolicitacao');
      if (arquivo != undefined) {
        if (!bImprimeAutomatico) {
          window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, '_blank');
        }
        await limparRelatorios();
      }

    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  function funcFormataData(data, type, row) {
    if (!data) {
      return 'NÃO ESPECIFICADO'
    }
    x = data.slice(0, 10).split('-');
    return `${x[2]}/${x[1]}/${x[0]}`;
  };

  function funcRetornaStatus(data, type, row) {
    if (!data) {
      return 'NÃO ACEITO'
    }
    if (data == 'N') {
      return 'NÃO ACEITO'
    }
    if (data == 'A') {
      return 'ACEITO'
    }
    if (data == 'R') {
      return 'RECEBIDO'
    }
    if ((data == 'P') || (data == 'PA')) {
      return 'EM PROGRESSO';
    }
    if (data == 'F') {
      return '<span style="color: green">FATURADO</span>'
    }
    return data;
  };

  function funcRetornaFase(data, type, row) {
    if (!data) {
      return 'DESCONHECIDO'
    }
    if (data == 'N') {
      return 'OUTROS'
    }
    if (data == 'TERMO') {
      return 'TERMOFIXAR'
    }
    if (data == 'RAMA') {
      return 'ACABAMENTO'
    }
    if (data == 'EST') {
      return 'ESTAMPARIA'
    }
    if (data == 'TING') {
      return 'TINGIMENTO'
    }
    if (data == 'EXP') {
      return 'EXPEDIÇÃO'
    }
    if (data == 'QUAL') {
      return 'QUALIDADE'
    }
    return data;
  };

  function funcBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      `    <button class="dropdown-item" type="button" id="btn-imprimir" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout RelTingimentoIndividual.FR3"' : 'title="Imprimir"'}>Imprimir</button>    ` +
      `    <button class="dropdown-item" type="button" id="btn-imprimir-solicitacao" ${getCookie('cod_usuario') == '0000' ? 'title="Este botão chama o Layout RelTingimentoSolicitacao.FR3"' : 'title="Imprimir"'}>Imprimir Solicitação</button>    ` +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
      '</div>';
    return retorno;
  };

  function addPesquisaAutocompleta() {
    $('#txtFal').autocompleta(1, `JSON={ "tabela":"FAL", "camposSelect":[ "NUMERO CHAVE", "CLIENTE DESCRICAO"], "where": ["CLIENTE = '${getCookie('cod_usuario')}'"]}`);
    $('#btnConsultaFal').pesquisa('#txtFal', 'NUMERO', 'CLIENTE', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"FAL", "camposSelect":[ "NUMERO", "CLIENTE"], "where": ["CLIENTE = '${getCookie('cod_usuario')}'"]}`, 'Pesquisa FAL', 'FAL');
    $('#btnLimpaFal').on('click', function () {
      $('#txtFal').val('');
    });

    $('#txtSolicitacao').autocompleta(1, `JSON={ "tabela":"FAL", "camposSelect":[ "DISTINCT SOL_PORTAL CHAVE", "CLIENTE DESCRICAO"], "where": ["CLIENTE = '${getCookie('cod_usuario')}'"]}`);
    $('#btnConsultaSolicitacao').pesquisa('#txtSolicitacao', 'SOLICITACAO', 'CLIENTE', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"FAL", "camposSelect":[ "DISTINCT SOL_PORTAL SOLICITACAO", "CLIENTE"], "where": ["CLIENTE = '${getCookie('cod_usuario')}'"]}`, 'Pesquisa Solicitação', 'FAL');
    $('#btnLimpaSolicitacao').on('click', function () {
      $('#txtSolicitacao').val('');
    });

    $('#btnLimparFiltros').on('click', function () {
      $('#txtFal').val('');
      $('#txtSolicitacao').val('');
      $('#rgStatus').val('').change();
      $('#txtDataInicio').val('');
      $('#txtDataFim').val('');
      $('#txtLote').empty().trigger('change');
    });

    $('#txtLote').pesquisa_variosServerside(1, `{ "tabela":"FAL_ITEN", "camposSelect":[ "FAL_ITEN.LOTE", "FAL_ITEN.FAL" ], "leftJoin": [{"tabela": "FAL", "condicao": "FAL_ITEN.FAL = FAL.NUMERO"}], "where": ["FAL.CLIENTE = '${getCookie('cod_usuario')}'"]}`, 'LOTE', 'FAL');
    $('#btnLote').pesquisa_serversideSel('#txtLote', `{ "tabela":"FAL_ITEN", "camposSelect":[ "FAL_ITEN.LOTE", "FAL_ITEN.FAL" ], "leftJoin": [{"tabela": "FAL", "condicao": "FAL_ITEN.FAL = FAL.NUMERO"}], "where": ["FAL.CLIENTE = '${getCookie('cod_usuario')}'"]}`, 'Pesquisa de Lote');
    $('#btnlimparLote').on('click', function () {
      $('#txtLote').empty().trigger('change');
    });
  };

  function retornaLangDataTable() {
    return {
      "sEmptyTable": "Nenhum registro encontrado",
      "sInfo": "_TOTAL_ registros",
      "sInfoEmpty": " 0 registros",
      "sInfoFiltered": "(Filtrados de _MAX_ registros)",
      "sInfoPostFix": "",
      "sInfoThousands": ".",
      "sLengthMenu": "_MENU_ resultados",
      "sLoadingRecords": "Carregando...",
      "sProcessing": "Processando...",
      "sZeroRecords": "Nenhum registro encontrado",
      "sSearch": "Pesquisar",
      "oPaginate": {
        "sNext": "Próximo",
        "sPrevious": "Anterior",
        "sFirst": "Primeiro",
        "sLast": "Último"
      },
      "oAria": {
        "sSortAscending": ": Ordenar colunas de forma ascendente",
        "sSortDescending": ": Ordenar colunas de forma descendente"
      }
    }
  };

});